---
lang: fr
lang-ref: ch.02-3
title: Réseaux de neurones artificiels
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
typora-root-url: 02-3
translation-date: 19 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

* Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**.

* **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**.

  In both cases, these points are not linearly separable.

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "Clean" 2D spiral
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "Noisy" 2D spiral
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>

What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution!

**How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data.

**Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level.
-->

## [Apprentissage supervisé pour la classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

* Considérons la figure 1(a) ci-dessous. Les points de ce graphique se trouvent sur les branches de la spirale et vivent dans $\R^2$. Chaque couleur représente une classe. Le nombre de classes uniques est $K = 3$. Ceci est représenté mathématiquement par l’*éqn. 1(a)*.

* La figure 1(b) montre une spirale similaire, avec un terme de bruit gaussien ajouté. Ceci est représenté mathématiquement par l’*éqn. 1(b)*.

  Dans les deux cas, ces points ne sont pas séparables linéairement.

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Figure 1(a) :</b> Spirale 2D « propre »
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Figure 1(b) :</b> Spirale 2D « bruyante »
       </center>
      </td>
  </table>
  </center><br><br>
  


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center><br><br>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>
<br>


**Que signifie effectuer une classification ?**   
Considérons le cas de la régression logistique. Si la régression logistique pour la classification est appliquée à ces données, elle créera un ensemble de **plans linéaires** (limites de décision) dans le but de séparer les données en classes. Le problème avec cette solution est que dans chaque région, il y a des points appartenant à plusieurs classes. Les branches de la spirale traversent les limites de décision linéaires. Ce **n'est pas** une très bonne solution !

**Comment pouvons-nous résoudre ce problème ?**  
Nous transformons l'espace d'entrée de telle sorte que les données soient forcées d'être linéairement séparables. Au cours de l’entraînement d'un réseau de neurones à cette fin, les limites de décision apprises essaieront de s'adapter à la distribution des données d’entraînement.

**Note** : un réseau de neurones est toujours représenté à partir de la base. La première couche est en bas et la dernière en haut. Ceci est dû au fait que, conceptuellement, les données d'entrée sont des caractéristiques de bas niveau pour n'importe quelle tâche que le réseau neuronal tente d'accomplir. Lorsque les données traversent le réseau de **bas en haut**, chaque couche suivante extrait des caractéristiques de plus haut niveau.


<!--
## Training data

Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network.

* $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Training data
</center>

* Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below).

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> One hot encoding
</center>

  * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots.
-->

## Données d'entraînement

La semaine précédente, nous avons vu qu'un réseau de neurones nouvellement initialisé transforme son entrée de manière arbitraire. Cette transformation, cependant, n'est pas **(initialement)** déterminante dans l'accomplissement de la tâche en question. Nous explorons comment, à l'aide de données, nous pouvons forcer cette transformation à avoir une signification qui soit pertinente pour la tâche à accomplir. Les données suivantes sont utilisées comme données d'entraînement pour un réseau.

* $\vect{X}$ représente les données d'entrée, une matrice de dimensions $m$ (nombre de points de données d'entraînement) x $n$ (dimensionnalité de chaque point d'entrée). Dans le cas des données indiquées dans les figures **1(a)** et **1(b)**, $n = 2$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Figure 2 : </b> Données d'entraînement
</center>

* Le vecteur $\vect{c}$ et la matrice $\boldsymbol{Y}$ représentent tous deux des labels de classe pour chacun des points de données $m$. Dans l'exemple ci-dessus, il y a $3$ de classes distinctes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, et $\vect{c} \in \R^m$. Cependant, nous ne pouvons pas utiliser $\vect{c}$ comme données d'entraînement. Si nous utilisons des labels de classe numériques distinctes $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, le réseau peut déduire un ordre au sein des classes qui n'est pas représentatif de la distribution des données.
  * Pour contourner ce problème, nous utilisons un *one-hot encoding*. Pour chaque label $c_i$, un vecteur nul de dimension $K$ $\vect{y}^{(i)}$ est créé, dont le $c_i$-ème élément est fixé à $1$ (voir **Fig. 3** ci-dessous).

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Figure 3 :</b> Un one-hot encoding
</center>

  * Donc, $\boldsymbol Y \in \R^{m \times K}$. Cette matrice peut également être considérée comme ayant une certaine masse probabiliste, qui est entièrement concentrée sur l'un des points $K$.


<!--
## Fully (FC) connected layers

We will now take a look at what a fully connected (FC) network is, and how it works.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Fully connected neural network
</center>

Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $\boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, *i.e* one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}}$. This network can be represented mathematically by the equations in **Eqn. 2** below. $f$ and $g$ are both non-linearities.

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>Eqn. 2</b> Mathematics behind a FC network</center>

A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax.

The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron

Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extended to a $n$-layer network.

Now let's move to a more complicated case.

Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Neural net with 3 hidden layers
</center>

Let's consider a neuron $j$ in the second layer. It's activation is:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$.

Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, *etc*.

The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post.
-->

## Couches entièrement connectées

Nous allons maintenant examiner ce qu'est un réseau entièrement connecté et comment il fonctionne.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Figure 4 :</b> Réseau neuronal entièrement connecté
</center>

Considérons le réseau présenté ci-dessus à la figure 4. Les données d'entrée, $\boldsymbol x$, sont soumises à une transformation affine définie par $\boldsymbol W_h$, suivie d'une transformation non linéaire. Le résultat de cette transformation non linéaire est désigné par $\boldsymbol h$, représentant une sortie **cachée**, c'est-à-dire qui n'est pas **vu** de l'extérieur du réseau. Cette transformation est suivie d'une autre transformation affine ($\boldsymbol W_y$), suivie d'une autre transformation non linéaire. Cela produit la sortie finale, $\boldsymbol{\hat{y}}$. Ce réseau peut être représenté mathématiquement par les équations de **éqn. 2** ci-dessous. $f$ et $g$ sont tous deux des non-linéarités.

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$
 
<center><b>Eqn. 2 :</b> Mathématiques derrière un réseau entièrement connecté </center>

Un réseau neuronal de base tel que celui illustré ci-dessus n'est qu'un ensemble de paires successives. Chaque paire étant une transformation affine suivie d'une opération non linéaire (écrasement). Les fonctions non linéaires les plus fréquemment utilisées sont *ReLU*, sigmoïde, tangente hyperbolique et softmax.

Le réseau illustré ci-dessus est un réseau à trois couches :

 1. neurone d'entrée
 2. neurone caché
 3. neurone de sortie

Par conséquent, un réseau neuronal à $3$ couches a des transformations affines à $2$. Cela peut être étendu à un réseau à couche $n$.

Passons maintenant à un cas plus complexe.

Faisons un cas de 3 couches cachées, entièrement connectées dans chaque couche. Une illustration peut être trouvée dans la figure 5.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Figure 5 :</b> Réseau neuronal avec 3 couches cachées
</center>

Considérons un neurone $j$ dans la deuxième couche. C'est l'activation :

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

où $\vect{w}^{(j)}$ est la $j$-ième ligne de $\vect{W}^{(1)}$.

Dans ce cas, l'activation de la couche d'entrée n'est que l'identité. Les couches cachées peuvent avoir des activations comme *ReLU*, tangente hyperbolique, sigmoïde, soft(arg)max, etc.

L'activation de la dernière couche en général dépend de votre cas d'utilisation.

<!--
## Neural network (inference)

Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Three-layer neural network
</center>

What kind of functions are we looking at?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$).
-->

## Réseau de neurones (inférence)

Pensons encore au réseau neuronal à trois couches (entrée, caché, sortie), comme on le voit sur la **figure 6**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Figure 6 :</b> Réseau neuronal à trois couches
</center>

**Quel type de fonctions envisageons-nous ?**

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

Cependant, il est utile de visualiser le fait qu'il y a une couche cachée et que l'espace où vivent les entités peut être étendu en conséquence :

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<br>
<br>
**À quoi pourrait ressembler un exemple de configuration pour le cas ci-dessus ?**    
Dans ce cas, on a une entrée de dimension deux ($n=2$), la couche cachée unique pourrait avoir une dimension de $1000$ ($d = 1000$), et nous avons 3 classes ($C=3$). Il y a de bonnes raisons pratiques de ne pas avoir autant de neurones dans une couche cachée, il pourrait donc être logique de diviser cette couche cachée unique en 3 avec 10 neurones chacun ($1000 \rightarrow 10 \times 10 \times 10$).

<!--
## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

So what does typical training look like? It is helpful to formulate this into the standard terminology of losses.

First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor Le Cun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm).

The soft (arg)max will give you logits in the last layer that look like this:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

It is important to note that the set is not closed because of the strictly positive nature of the exponential function.

Given the set of the predictions $\matr{\hat{Y}}$, the loss will be:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Here $c$ denotes the integer label, not the one hot encoding representation.

So let's do two examples, one where an example is correctly classified, and one where it is not.

Let's say

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

What is the instance wise loss?

For the case of *nearly perfect prediction* ($\sim$ means *circa*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

For the case of *nearly absolutely wrong*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think.

**Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice!
-->

## [Réseau de neurones (entraînement I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

**À quoi ressemble un entraînement typique ?**  

Il est utile de formuler cela dans la terminologie standard des pertes.
Tout d'abord, réintroduisons la fonction soft(arg)max et précisons explicitement qu'il s'agit d'une fonction d'activation commune pour la dernière couche, lorsque l'on utilise la perte de log-vraisemblance négative, dans les cas de prédiction multiclasses. Comme l'a indiqué Yann lors du cours magistral, c'est parce que vous obtenez de plus jolis gradients que si vous utilisiez les sigmoïdes et la perte quadratique. En outre, votre dernière couche sera déjà normalisée (la somme de tous les neurones de la dernière couche est égale à 1), ce qui est plus intéressant pour les méthodes de gradient que la normalisation explicite (division par la norme).

La fonction soft(arg)max vous donnera des logits dans la dernière couche qui ressemblent à ceci :

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

Il est important de noter que l'ensemble n'est pas fermé en raison de la nature strictement positive de la fonction exponentielle.

Étant donné l'ensemble des prédictions $\matr{\hat{Y}}$, la perte sera :

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Ici, $c$ désigne le label de l'entier, et non la représentation de l'encodage one hot.

Faisons donc deux exemples, un où un exemple est correctement classé, et un autre où il ne l'est pas.

Supposons que

$$
\boldsymbol{x},  c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$
<br>

**Qu'est-ce que la perte d'instance ?**   
Dans le cas d'une *prévision presque parfaite* ($\sim$ signifie *circa*) :

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\\sim 0 \\\\sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\\sim 0 \\\\sim 0 \end{pmatrix}}
1\right) \rightarrow 0^{+}
$$

Pour le cas *presque absolument faux* :

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\\ \sim 1 \\\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\\ \sim 1 \\\ \sim 0 \end{pmatrix}}
1\right) \rightarrow +\infty $$

A noter dans les exemples ci-dessus que $\sim 0 \rightarrow 0^{+}$ et $\sim 1 \rightarrow 1^{-}$.

**Note** : il est important de savoir que si vous utilisez la `CrossEntropyLoss` en PyTorch, vous obtiendrez `LogSoftMax` et `NLLLLoss` (voir la [semaine 11](https://atcold.github.io/pytorch-Deep-Learning/fr/week11/11/) pour plus de détails sur ces fonctions), alors ne le faites pas deux fois !


<!--
## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem.

A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimizing a loss function through gradient descent.
</center>

We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network.

In order to compute the necessary gradients, we have to use back-propagation

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$
-->

## [Réseau de neurones (entraînement II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

Pour l'entraînement, nous agrégeons tous les paramètres pouvant être entraînés (matrices de poids et biais) dans une collection que nous appelons $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. Cela nous permet d'écrire la fonction objectif ou la perte comme :

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}}) \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

Cela fait dépendre la perte de la sortie du réseau $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, donc nous pouvons transformer cela en un problème d'optimisation.

Une illustration simple de la façon dont cela fonctionne peut être vue dans la figure 7, où $J(\vartheta)$, la fonction que nous devons minimiser, n'a qu'un paramètre scalaire $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom : 60% ; couleur de fond:#DCDCDC ;" /><br>
<b>Figure 7 :</b> Optimisation d'une fonction de perte par descente de gradient
</center>

Nous choisissons un point d'initialisation aléatoire $\vartheta_0$  avec une perte associée $J(\vartheta_0)$. Nous pouvons calculer la dérivée évaluée à ce point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. Dans ce cas, la pente de la dérivée est positive. Nous devons donc faire un pas dans la direction de la descente la plus raide. Dans ce cas, c'est $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

La répétition itérative de ce processus est connue sous le nom de descente de gradient. Les méthodes de gradient sont les principaux outils pour l'entraînement d'un réseau de neurones.

Afin de calculer les gradients nécessaires, nous devons utiliser la rétropropagation

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$


<!--
## Spiral classification - Jupyter notebook

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels -- in red, yellow and blue -- as can be seen in **Fig. 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Spiral classification data.
</center>

`nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html).

Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing.

As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Linear decision boundaries.
</center>

When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Non-linear decision boundaries.
</center>

An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Neural networks, along with their variance and standard deviation.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>

The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" -- since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Neural networks, with mean and standard deviation, outside training interval.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>

To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop:

1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

When training a NN, it is very likely that you need these 5 steps in the order they were presented.
-->
## Notebook Jupyter 
La version anglaise du *notebook* Jupyter se trouve [ici](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). La version française se trouve pour sa part [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/04-spiral_classification.ipynb). Pour le faire fonctionner, assurez-vous que vous avez installé l'environnement `pDL` comme indiqué dans le fichier [README.md](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/docs/fr/README-FR.md).
Une explication sur l'utilisation de `torch.device()` se trouve dans [les notes de la semaine 1](https://atcold.github.io/pytorch-Deep-Learning/fr/week01/01-3/).
Comme auparavant, nous allons travailler avec des points dans $\mathbb{R}^2$ avec trois labels catégoriels différents (en rouge, jaune et bleu ) comme on peut le voir dans figure 8.
<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br> <b>Figure 8 : </b> Données de classification en spirale
</center>

`nn.Sequential()` est un conteneur, qui passe les modules au constructeur dans l'ordre où ils sont ajoutés.  
`nn.linear()` est mal nommé car il applique une transformation **affine** aux données entrantes : $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. Pour plus d'informations, consultez la [documentation PyTorch](https://pytorch.org/docs/stable/nn.html).
N'oubliez pas qu'une transformation affine est composée de cinq choses : rotation, réflexion, translation, mise à l'échelle (la scalabilité) et le *shearing*.  
Comme on peut le voir sur la figure 9, en essayant de séparer les données en spirale avec des limites de décision linéaires (en utilisant uniquement des modules `nn.linear()`, sans non-linéarité entre eux) le mieux que nous puissions obtenir est une précision de $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br> <b>Figure 9 :</b> Limites de décision linéaires
</center>
Lorsque nous passons d'un modèle linéaire à un modèle comportant deux modules `nn.linear()` et un module `nn.ReLU()` entre eux, la précision passe à 95 %. C'est parce que les limites deviennent non linéaires et s'adaptent beaucoup mieux à la forme en spirale des données, comme on peut le voir sur la figure 10.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>    
<b>Figure 10 :</b> Limites de décision non linéaires
</center>

Un exemple de problème de régression qui ne peut pas être résolu correctement par une régression linéaire, mais qui est facilement résolu avec la même structure de réseau neuronal peut être vu dans [ce notebook](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/05-regression.ipynb) et dans la figure 11 qui montre 10 réseaux différents, où 5 ont une fonction `nn.ReLU()` et 5 ont une fonction `nn.Tanh()`. La première est une fonction linéaire par morceaux, tandis que la seconde est une régression continue et régulière.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br> <b>Figure 11 :</b> 10 réseaux de neurones, avec leur variance et leur écart-type.<br>
A gauche : cinq réseaux avec une <code>ReLU</code>.  A droite : Cinq réseaux avec une <code>tanh</code>.
</center>

Les lignes jaune et verte indiquent l'écart-type et la variance des réseaux. Leur utilisation est utile pour quelque chose de similaire à un intervalle de confiance, puisque les fonctions donnent une seule prédiction par sortie. L'utilisation de la prédiction de la variance d'ensemble nous permet d'estimer l'incertitude avec laquelle la prédiction est faite. L'importance de cette fonction est illustrée par la figure 12 où nous étendons les fonctions de décision en dehors de l'intervalle d'entraînement et où celles-ci tendent vers $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br> <b>Figure 12 :</b> Réseaux de neurones, avec moyenne et écart-type, en dehors de l'intervalle d'entraînement.<br>
A gauche : cinq réseaux avec une <code>ReLU</code>.  A droite : Cinq réseaux avec une <code>tanh</code>.
</center>

Pour entraîner un réseau de neurones à l'aide de PyTorch, il faut suivre 5 étapes fondamentales dans la boucle d'entraînement :
1. `output = model(input)` est la passe en avant du modèle, qui prend l'entrée et génère la sortie.
2. `J = loss(output, target <or> label)` prend la sortie du modèle et calcule la perte d'entraînement par rapport à la véritable cible.
3. `model.zero_grad()` nettoie les calculs du gradient afin qu'ils ne soient pas accumulés pour la prochaine passe.
4. `J.backward()` fait la rétropropagation et l'accumulation. Il calcule $\nabla_\texttt{x} J$ pour chaque variable $\texttt{x}$ pour laquelle nous avons spécifié `requires_grad=True`. Elles sont cumulées dans le gradient de chaque variable : $\texttt{x.grad} \gets \texttt{x.grad} + \nabla_\texttt{x} J$.
5. `optimiser.step()` fait un pas dans la descente de la pente : $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

Lors de l'entraînement d'un réseau, il est très probable que vous ayez besoin de ces 5 étapes dans l'ordre où elles ont été présentées.
