---
lang: fr
lang-ref: ch.02-2
lecturer: Yann Le Cun
title: Calcul des gradients pour les modules des réseaux de neurones et astuces pratiques pour la rétropropagation
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
translation-date: 19 Aug 2020
translator: Loïck Bourdois
---

<!--
## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)
-->

## [Un exemple concret de rétropropagation et d'introduction aux modules de base des réseaux neuronaux](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)

<!--
### Example

We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is input into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e. the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.)

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Gradient diagram" style="zoom:40%;" /></center>

In this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.

Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount.
-->

### Exemple

Nous considérons un exemple concret de rétropropagation à l'aide d'une représentation graphique. La fonction arbitraire $G(w)$ est introduite dans la fonction de coût $C$, qui peut être représentée sous forme d'un graphe. Par la manipulation de la multiplication des matrices jacobiennes, nous pouvons transformer ce graphe en un qui calculera les gradients à l'envers. 
Notez que PyTorch et TensorFlow font cela automatiquement pour l'utilisateur, c'est-à-dire que le graphe de la propagation avant est automatiquement « inversé » pour créer le graphe dérivé qui rétropropage le gradient.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Gradient diagram" style="zoom:40%;" />
  <b> Figure 1 :</b> Illustration graphique de la rétropropagation
</center>

Dans cet exemple, le graphe vert à droite représente le gradient. En suivant le graphe à partir du nœud supérieur, il s'ensuit que :

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$
<br>
<br>

En termes de dimensions :
- $\frac{\partial C(y,\bar{y})}{\partial w}$ est un vecteur ligne de taille $1\times N$ où $N$ est le nombre de composantes de $w$ 
-  $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$ est un vecteur ligne de taille $1\times M$, où $M$ est la dimension de la sortie 
-   $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ est une matrice de taille $M\times N$, où $M$ est le nombre de sorties de $G$ et $N$ est la dimension de $w$.

Des complications peuvent survenir lorsque l'architecture du graphe n'est pas fixe mais dépend des données. Par exemple, nous pourrions choisir un module de réseau neuronal en fonction de la longueur du vecteur d'entrée. Bien que cela soit possible, cela devient de plus en plus difficile de gérer cette variation lorsque le nombre de boucles dépasse un montant raisonnable.

<!--
### Basic neural net modules

There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules).

- Linear: $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
  $$

- Duplicate: $Y_1=X$, $Y_2=X$

  - Akin to a "Y - splitter" where both outputs are equal to the input.

  - When backpropagating, the gradients get summed

  - Can be split into $n$ branches similarly

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$


- Add: $Y=X_1+X_2$

  - With two variables being summed, when one is perturbed, the output will be perturbed by the same quantity, i.e.

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$


- Max: $Y=\max(X_1,X_2)$

  -  Since this function can also be represented as

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$

  - Therefore, by the chain rule,

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$
-->

### Modules de base des réseaux neuronaux

Il existe différents types de modules préconstruits en plus des modules *Linear* et *ReLU* bien connus. Ils sont utiles car ils sont optimisés de manière unique pour remplir leurs fonctions respectives (par opposition à une combinaison d'autres modules élémentaires).

- *Linear* : $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$  

- *ReLU* : $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{ else}
      \end{cases}
  $$  

- Dupliquer : $Y_1=X$, $Y_2=X$

  - semblable à un "Y - splitter" où les deux sorties sont égales à l'entrée.

  - en rétropropagation, les gradients sont additionnés

  - peut être divisé en $n$ branches : $ \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}$  


- Ajouter : $Y=X_1+X_2$

  - en additionnant deux variables, lorsque l'une d'entre elles est perturbée, la sortie sera perturbée par la même quantité, c'est-à-dire :

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{et}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$  


- Max : $Y=\max(X_1,X_2)$

  - cette fonction peut également être représentée comme :

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\\\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\\\
          0 & \text{else}
       \end{cases}
    $$

  - donc, par la règle de la chaîne :

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{sinon}
      \end{cases}
    $$


<!--
## [LogSoftMax *vs.* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between $0$ and $1$ that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when $s$ is large, $h(s)$ is $1$, and when s is small, $h(s)$ is $0$. Because the sigmoid function is flat at $h(s) = 0$ and $h(s) = 1$, the gradient is $0$, which results in a vanishing gradient.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Sigmoid function to illustrate vanishing gradient" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When $s$ is very small, the value is $0$, and when $s$ is very large, the value is $s$. As a result it doesn’t saturate, and the vanishing gradient problem is avoided.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Plot of logarithmic part of the functions" /></center>
-->
## [La fonction LogSoftMax *vs* la fonction SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, qui est également un module PyTorch, est un moyen pratique de transformer un groupe de nombres en un groupe de nombres positifs entre $0$ et $1$ dont la somme vaut 1. Ces nombres peuvent être interprétés comme une distribution de probabilité. Par conséquent, il est couramment utilisé dans les problèmes de classification. $y_i$ dans l'équation ci-dessous est un vecteur de probabilités pour toutes les catégories.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

Cependant, l'utilisation de *SoftMax* laisse la possibilité que les gradients disparaissent dans le réseau. La disparition du gradient est un problème, car elle empêche les poids en aval d'être modifiés par le réseau neuronal, ce qui peut empêcher complètement l’entraînement du réseau neuronal. La fonction sigmoïde logistique, qui est la fonction softmax pour une valeur, montre que lorsque $s$ est grand, $h(s)$ vaut $1$, et lorsque s est petit, $h(s)$ vaut $0$. Comme la fonction sigmoïde est plate à $h(s) = 0$ et $h(s) = 1$, le gradient est de $0$, ce qui se traduit par un gradient qui disparaît.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Fonction sigmoïde pour illustrer la disparition du gradient" style="background-color:#DCDCDC;" />
  <b> Figure 2 :</b> La fonction sigmoïde
</center>
<br>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

Les mathématiciens ont eu l'idée de la fonction *LogSoftMax* afin de résoudre le problème de disparition du gradient créé par la fonction *SoftMax*. *LogSoftMax* est un autre module de base de PyTorch. Comme on peut le voir dans l'équation ci-dessous, *LogSoftMax* est une combinaison de softmax et du log.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

L'équation ci-dessous montre une autre façon de considérer la même équation. La figure ci-dessous montre la partie $\log(1 + \exp(s))$ de la fonction. Lorsque $s$ est très petit, la valeur est $0$, et lorsque $s$ est très grand, la valeur est $s$. Par conséquent, elle ne sature pas et le problème du gradient disparaît.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Tracé de la partie logarithmique des fonctions" /></center>


<!--
## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)
-->
## [Astuces pour la rétropropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)

<!--
### Use ReLU as the non-linear activation function

ReLU works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.
-->

### Utiliser *ReLU* comme fonction d'activation non linéaire

*ReLU* fonctionne mieux pour les réseaux à plusieurs couches, ce qui a fait que des alternatives comme la fonction sigmoïde et la fonction tangente hyperbolique $\tanh(\cdot)$ ont perdu de leur popularité. La raison pour laquelle *ReLU* fonctionne le mieux est probablement due à son unique nœud qui le rend d'échelle équivalente.

<!--
### Use cross-entropy loss as the objective function for classification problems

Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).
-->

### Utiliser la perte d'entropie croisée comme fonction objectif pour les problèmes de classification

La fonction logsoftmax, dont nous avons parlé plus tôt, est un cas particulier de l'entropie croisée. Dans PyTorch, il faut mieux s'assurer de fournir la fonction de perte d'entropie croisée avec *log*softmax comme entrée (par opposition à la softmax normale).

<!--
### Use stochastic gradient descent on minibatches during training

As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.
-->

### Utiliser la descente de gradient stochastique sur les minibatchs pendant l'entraînement

Comme nous l'avons vu précédemment (voir la page web [Introduction à la descente de gradient et à l’algorithme de rétropropagation](https://atcold.github.io/pytorch-Deep-Learning/fr/week02/02-1/)), les *minibatchs* permettent d’entraîner plus efficacement car utilisent la redondance des données. Cela évite d'avoir besoin de faire une prédiction et de calculer la perte sur chaque observation à chaque étape pour estimer le gradient.

<!--
### Shuffle the order of the training examples when using stochastic gradient descent

Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, *etc*. Ideally, you should have samples from every class in every minibatch.

However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch).
-->

### Mélanger l'ordre des exemples d'entraînement lorsque vous utilisez la descente stochastique

L'ordre est important. Si le modèle ne voit que des exemples d'une seule classe à chaque étape de l’entraînement, il apprendra à prédire cette classe sans savoir pourquoi il devrait le faire. Par exemple, si vous essayez de classer des chiffres du jeu de données MNIST et que les données ne sont pas mélangées, les paramètres de biais dans la dernière couche prédiraient simplement toujours zéro, puis s'adapteraient pour toujours prédire un, puis deux, etc. Idéalement, il faut avoir des échantillons de chaque classe dans chaque minibatch.

Cependant, le débat se poursuit pour savoir s'il faut changer l'ordre des échantillons à chaque passage (époque).

<!--
### Normalize the inputs to have zero mean and unit variance

Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none.
-->

### Normaliser les entrées pour avoir une moyenne nulle et une variance de 1 

Avant d'entraîner, il est utile de normaliser chaque caractéristique d'entrée afin qu'elle ait une moyenne de zéro et un écart-type de un. Lors de l'utilisation de données d'images RVB, il est courant de prendre la moyenne et l'écart-type de chaque canal individuellement et de normaliser l'image par canal. Par exemple, prendre la moyenne $m_b$ et l'écart-type $\sigma_b$ de toutes les valeurs du bleu dans l'ensemble de données, puis normaliser les valeurs du bleu pour chaque image individuelle comme

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

où $\epsilon$ est un nombre arbitrairement petit que nous utilisons pour éviter la division par zéro. Il faut alors répéter la même chose pour les canaux verts et rouges.   
Ceci est nécessaire pour obtenir un signal significatif à partir d'images prises sous différents éclairages. Par exemple, les images prises en plein jour contiennent beaucoup de rouge alors que les images sous-marines n'en contiennent presque pas.

<!--
### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam which adapt the learning rate instead of simple SGD with a constant learning rate.
-->

### Utiliser un schéma pour diminuer le taux d'apprentissage

Le taux d'apprentissage devrait diminuer au fur et à mesure de l’entraînement. En pratique, la plupart des modèles avancés sont entraînés en utilisant des algorithmes comme *Adam* qui adaptent le taux d'apprentissage au lieu d'une simple SGD avec un taux d'apprentissage constant.

<!--
### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to $0$.
-->

### Utiliser la régularisation L1 et/ou L2 pour le taux de décroissance des poids

Il est possible d'ajouter un coût pour les poids importants à la fonction de coût. Par exemple, en utilisant la régularisation L2, nous définirions la perte $L$ et mettrions à jour les pondérations $w$ comme suit :

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

Pour comprendre pourquoi on appelle cela le taux de décroissance des poids (*weight decay* en anglais), notez que nous pouvons réécrire la formule ci-dessus pour montrer que nous multiplions $w_i$ par une constante inférieure à un pendant la mise à jour :

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

La régularisation L1 (Lasso) est similaire, sauf que nous utilisons $\sum_i \vert w_i\vert$ au lieu de $\Vert w \Vert^2$.

Essentiellement, la régularisation essaie de dire au système de minimiser la fonction de coût avec le vecteur de poids le plus court possible. Avec la régularisation L1, les poids qui ne sont pas utiles sont mis à $0$.

<!--
### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the standard deviation of the weights is inversely proportional to square root of number of inputs.
-->

### Initialisation des poids

Les poids doivent être initialisés au hasard, mais ils ne doivent pas être trop grands ou trop petits pour que la sortie soit à peu près de la même variance que l'entrée. PyTorch comporte plusieurs astuces d'initialisation des poids. Une des astuces qui fonctionne bien pour les modèles profonds est l'initialisation de Kaiming où l'écart-type des poids est inversement proportionnel à la racine carrée du nombre d'entrées.

<!--
### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

For more tricks, see  <a href="http://yann.Le Cun.com/exdb/publis/pdf/Le Cun-98b.pdf">Le Cun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules.
-->

### Utiliser le dropout

Le *dropout* est une autre forme de régularisation. Il peut être considéré comme une autre couche du réseau neuronal : il prend les entrées, met aléatoirement à zéro $n/2$ des entrées, et renvoie le résultat en sortie. Cela oblige le système à prendre des informations de toutes les unités d'entrée plutôt que de devenir trop dépendant d'un petit nombre d'unités d'entrée, répartissant ainsi les informations sur toutes les unités d'une couche. Cette méthode a été initialement proposée par <a href="https://arxiv.org/abs/1207.0580">Hinton et al. (2012)</a>.

Pour plus d'astuces, voir <a href="http://yann.Le Cun.com/exdb/publis/pdf/Le Cun-98b.pdf">Le Cun et al. (1998)</a>.
Enfin, notez que la rétropropagation ne fonctionne pas seulement pour les modèles empilés. Elle peut fonctionner pour tout graphe acyclique dirigé (*DAG* de l'anglais pour *directed acyclic graph*) tant qu'il y a un ordre partiel sur les modules.
