---
lang-ref: ch.01-3
lang: fr
title: Motivation du problème, algèbre linéaire et visualisation
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translation-date: 1 Aug 2020
translator: Loïck Bourdois
---


<!--
## Resources

Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box.
-->

## Ressources

Nous vous invitons à suivre Alfredo Canziani [sur Twitter @alfcnz](https://twitter.com/alfcnz). Vous trouverez sur son compte des vidéos et des manuels contenant des détails pertinents sur l'algèbre linéaire et la décomposition en valeurs singulières (SVD). Ce contenu est trouvable en effectuant une recherche (en anglais) sur le Twitter d'Alfredo, en tapant par exemple `linear algebra (from:alfcnz)` dans la barre de recherche.


<!--

## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:

-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections.
-->

## [Transformations et motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

À titre d'exemple, considérons la classification d'images. Supposons que nous prenons une photo avec un appareil photo de $1$ mégapixel. Cette image aura environ $1 000$ pixels verticalement et $1 000$ pixels horizontalement. De plus chaque pixel aura trois dimensions de couleur pour le rouge, le vert et le bleu (RVB). Chaque image peut donc être considérée comme un point dans un espace à $3$ millions de dimensions.
Avec une telle dimensionnalité, de nombreuses images intéressantes que nous pourrions vouloir classer, comme un chien ou un chat, se trouveront essentiellement dans la même région de l'espace.

Afin de séparer efficacement ces images, nous envisageons des moyens de transformer les données afin de déplacer les points. Rappelons que dans l'espace bidimensionnel, une transformation linéaire équivaut à une multiplication matricielle. Par exemple, les transformations suivantes peuvent être obtenues en changeant les caractéristiques de la matrice :

- Rotation : lorsque la matrice est orthonormée.
- Mise à l'échelle (« scalabilité ») : lorsque la matrice est diagonale.
- Réflexion : lorsque le déterminant est négatif.
- *Shearing*.
- Translation.

Notez que la translation seule n’est pas linéaire puisque $0$ ne sera pas toujours mis en correspondance avec $0$, mais c’est une transformation affine. Pour revenir à notre exemple d’image, nous pouvons transformer les points de données en les translatant de manière à ce qu’ils soient regroupés autour de 0 et en les mettant à l’échelle à l’aide d’une matrice diagonale de manière à effectuer un « zoom avant » sur cette région. Enfin, nous pouvons effectuer une classification en trouvant des lignes dans l’espace qui séparent les différents points dans leurs classes respectives. En d’autres termes, l’idée est d’utiliser des transformations linéaires et non linéaires pour représenter les points dans un espace tel qu’ils soient linéairement séparables. Cette idée est rendue plus concrète dans les sections suivantes.


<!--

## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one vs all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities.
-->

## [Visualisation des données : séparation des points à l'aide d'un réseau](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

Dans notre visualisation, nous avons cinq branches d'une spirale, chaque branche correspondant à une couleur différente. Les points vivent dans un plan bidimensionnel et peuvent être représentés sous la forme d'un *tuple*. La couleur représente une troisième dimension qui peut être considérée comme les différentes classes pour chacun des points. Nous utilisons ensuite le réseau pour séparer chacun des points par couleur.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
| (a) Points d'entrée, pré-réseau | (b) Points de sortie, post-réseau |

<center> Figure 1 : Spirale à cinq couleurs </center>


Le réseau « étire » le tissu spatial afin de séparer chacun des points en différents sous-espaces. À la convergence, le réseau sépare chacune des couleurs en différents sous-espaces de la surface finale. En d'autres termes, chacune des couleurs dans ce nouvel espace sera linéairement séparable par une régression « un contre tous ». Les vecteurs du diagramme peuvent être représentés par une matrice de $5 \times 2$. Cette matrice peut être multipliée à chaque point pour obtenir des scores pour chacune des cinq couleurs. Chacun des points peut ensuite être classé par couleur en utilisant les scores respectifs. Ici, la dimension de sortie est de cinq, une pour chacune des couleurs, et la dimension d'entrée est de deux, une pour les coordonnées $x$ et $y$ de chacun des points. Pour résumer, ce réseau prend le tissu spatial et effectue une transformation de l'espace paramétrée par plusieurs matrices puis par des non-linéarités.


<!--
### Network architecture

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center>

The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour.
-->


### Architecture du réseau

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom : 40% ; background-color:#DCDCDC;" /><br>
Figure 2 : Architecture du réseau (se lit de bas en haut)
</center>

La première matrice fait correspondre l'entrée bidimensionnelle à une couche cachée intermédiaire à $100$ dimensions. Nous avons ensuite une couche non linéaire, `ReLU` (*Rectified Linear Unit*), qui est simplement une fonction *partie positive* $(\cdot)^+$. Ensuite, pour afficher notre image dans une représentation graphique, nous incluons une couche de représentation vectorielle qui fait correspondre l'entrée de la couche cachée à $100$ dimensions à une sortie bidimensionnelle. Enfin, la couche est projetée sur la couche finale à cinq dimensions du réseau, représentant un score pour chaque couleur.


<!--

## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

The English Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). The French one is available [here](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/02-space_stretching.ipynb) In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->

## [Projections aléatoires : notebook Jupyter](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

La version anglaise du *notebook* Jupyter peut être consultée [ici](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). Celle en français est disponible [ici](https://github.com/lbourdois/pytorch-Deep-Learning-Notebooks-in-French/blob/master/02-space_stretching.ipynb). Pour le faire fonctionner, assurez-vous que l'environnement `pDL` est installé comme indiqué dans le fichier [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/docs/fr/README-FR.md).

<!--

### PyTorch `device`

PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`.
-->


### PyTorch

PyTorch peut fonctionner à la fois sur le CPU et le GPU d'un ordinateur. Le CPU est utile pour les tâches séquentielles, tandis que le GPU est utile pour les tâches parallèles. Avant d'exécuter sur l'appareil désiré, nous devons d'abord nous assurer que nos tenseurs et modèles sont transférés dans la mémoire de l'appareil. Cela peut être fait avec les deux lignes de code suivantes :

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

La première ligne crée une variable, appelée `device`, qui est assignée au GPU s'il y en a un de disponible, sinon elle est assignée par défaut au CPU. À la ligne suivante, un tenseur est créé et envoyé à la mémoire du périphérique en appelant `.to(device)`.


<!--

### Jupyter Notebook tip

To see the documentation for a function in a notebook cell, use `Shift + Tab.`
-->

### Astuce pour les notebooks Jupyter

Pour voir la documentation d'une fonction dans une cellule du *notebook*, utilisez `Shift + Tab`.

<!--

### Visualizing linear transformations

Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figure 3:  Linear transformations from random matrices </center>
-->

### Visualisation des transformations linéaires

Rappelons qu'une transformation linéaire peut être représentée sous forme de matrice. En utilisant la décomposition en valeur singulière, nous pouvons décomposer cette matrice en trois matrices composantes, chacune représentant une transformation linéaire différente.

$$
W = U\begin{bmatrix}s_1 & 0 \\\ 0 & s_2 \end{bmatrix} V^\top
$$

Dans l'équation (1), les matrices $U$ et $V^\top$ sont orthogonales et représentent les transformations de rotation et de réflexion. La matrice du milieu est diagonale et représente une transformation d'échelle.

Nous visualisons les transformations linéaires de plusieurs matrices aléatoires dans la figure 3. Notez l'effet des valeurs singulières sur les transformations résultantes.

Les matrices utilisées ont été générées avec NumPy, cependant, nous pouvons également utiliser la classe `nn.Linear` de PyTorch avec `bias = False` pour créer des transformations linéaires.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
| (a) Points originaux | (b) $s_1$ = 1,540, $s_2$ = 0,304 | (c) $s_1$ = 0,464, $s_2$ = 0,017 |

<center> Figure 3 : Transformations linéaires à partir de matrices aléatoires </center>


<!--

### Non-linear transformations

Next, we visualize the following transformation:

$$
f(x) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \bigg)
$$

Recall, the graph of $\tanh(\cdot)$ in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center>

The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center>
-->

### Transformations non linéaires

Ensuite, nous visualisons la transformation suivante :

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Rappelez-vous, le graphique de $\tanh(\cdot)$ de la figure 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4 : Non-linéarité de la tangente hyperbolique
</center>

Cette non-linéarité a pour effet de délimiter des points entre $-1$ et $+1$, créant ainsi un carré. Plus la valeur de $s$ dans l'équation (2) augmente, plus les points sont poussés vers le bord du carré. C'est ce que montre la figure 5. En forçant plus de points vers le bord, nous les étalons davantage et pouvons alors tenter de les classer.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site. baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
| (a) Non-linéarité avec $s=1$ | (b) Non-linéarité avec $s=5$ |

<center> Figure 5 : Transformations non linéaires </center>


<!--

### Random neural net

Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center>
-->

### Réseau neuronal aléatoire
Enfin, nous visualisons la transformation effectuée par un simple réseau de neurones non entraîné. Le réseau est constitué d'une couche linéaire, qui effectue une transformation affine, suivie d'une tangente hyperbolique non-linéaire, et enfin d'une autre couche linéaire. En examinant la transformation de la figure 6, nous constatons qu'elle est différente des transformations linéaires et non linéaires vues précédemment. Nous allons voir comment rendre utiles ces transformations effectuées par les réseaux de neurones pour notre objectif final de classification.
<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6 : Transformation d'un réseau de neurones non entraîné
</center>

