---
lang-ref: ch.01-2
lang: fr
lecturer: Yann Le Cun
title: Evolution et utilisations des ConvNets et « pourquoi l'apprentissage profond » ? 
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translation-date: 1 Aug 2020
translator: Loïck Bourdois
---

<!--
## [Evolution of CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)
-->

## [Evolution des ConvNets](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!--
In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.

Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling).

Le Cun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top.

These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present.

Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking.

Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again.

The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% vs 16.4% top-5 error rate.

After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs.

Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster.
-->


Dans le cerveau des animaux, les neurones réagissent aux bords qui ont des orientations particulières. Les groupes de neurones qui réagissent aux mêmes orientations sont reproduits sur l'ensemble du champ visuel.

En se basant sur deux concepts, Fukushima (1982) a construit un réseau de neurones qui fonctionne de la même manière que le cerveau. Premièrement, les neurones sont répliqués sur l'ensemble du champ visuel. Deuxièmement, il existe des cellules complexes qui regroupent les informations provenant de cellules simples (unités d'orientation-sélection). Par conséquent, le déplacement de l'image modifie l'activation des cellules simples mais n'influence pas l'activation intégrée de la cellule complexe (le *pooling* convolutif).

Yann Le Cun (1990) a utilisé la rétropropagation pour entraîner un ConvNet à reconnaître les chiffres manuscrits. Il existe une [démo de 1993](https://www.youtube.com/watch?v=FwFduRA_L6Q&list=PL80I41oVxglKKxF1OBbKHdOEX2VZVNzAR&index=1) où l'algorithme reconnaît les chiffres de n'importe quel style. La reconnaissance de caractères/motifs à l'aide d'un modèle entraîné de bout en bout était nouvelle à l'époque. Auparavant, les gens utilisaient des extracteurs de caractéristiques avec un modèle supervisé par-dessus.

Ces nouveaux systèmes ConvNets pouvaient reconnaître plusieurs caractères dans l'image en même temps. Pour ce faire, les gens utilisaient une petite fenêtre de saisie pour un ConvNet et la glissaient sur toute l'image. Si elle s'activait, cela signifiait qu'un caractère particulier était présent.

Plus tard, cette idée a été appliquée à la détection des visages/personnes et à la segmentation sémantique (classification au niveau du pixel). Citons par exemple Hadsell (2009) et Farabet (2012). Cette méthode a fini par devenir populaire dans l'industrie, utilisée dans des applications de conduite autonome telles que le suivi de voie.

Les capacités de calcul pour entraîner un ConvNet étaient un sujet brûlant dans les années 1980, puis l'intérêt a chuté, et est maintenant redevenu populaire.

La révolution de l'apprentissage profond (bien que le terme ne soit pas utilisé à l'époque) a commencé en 2010-2013. Les chercheurs se sont concentrés sur l'invention d'algorithmes qui pourraient aider à entraîner plus rapidement les gros ConvNets. Krizhevsky (2012) a conçu AlexNet, qui était un ConvNet beaucoup plus grand que ceux utilisés auparavant, et l'a entraîné sur ImageNet (1,3 million d'échantillons) en utilisant des GPUs. Après quelques semaines de fonctionnement, AlexNet a largement dépassé les performances des meilleurs systèmes concurrents avec un taux d'erreur pour les 5 premières sorties du modèle (*Top-5 error rate*) de 16,4% contre 25,8% pour les autres. 

Après avoir vu le succès d'AlexNet, la communauté de la vision par ordinateur (souvent abrégée en *CV* en anglais pour *Computer Vision*) a été convaincue que les ConvNets fonctionnent. Alors que tous les articles de 2011-2012 mentionnant les ConvNets étaient alors rejetés, depuis 2016 la plupart des papiers acceptés utilisent les ConvNets.

Au fil des ans, le nombre de couches utilisées a augmenté : 7 pour LeNet, 12 pour AlexNet, 19 pour VGG, 50 pour ResNet. Toutefois, il y a un compromis à faire entre le nombre d'opérations nécessaires pour calculer le résultat, la taille du modèle et sa précision. Ainsi, un sujet actuellement populaire est de savoir comment comprimer les réseaux pour rendre les calculs plus rapides.




<!--
## [Deep Learning and Feature Extraction](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)
-->

## [Apprentissage profond et extraction de caractéristiques](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

<!--
Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy, combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature.

Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement.

Mask RCNNs have found their use in segmenting individual objects, i.e. creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, i.e. identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source.

Some of the practical applications of CNNs are powering autonomous driving and analysing medical images.

Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work?

Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes.

Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:

- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines

Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example:

-  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.
-  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.
-  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation.
-->

Les réseaux multicouches ont du succès parce qu'ils exploitent la structure des données naturelles (la parole, les images, le texte). Dans la hiérarchie des compositions, les combinaisons d'objets à une couche de la hiérarchie forment les objets de la couche suivante. Si nous imitons cette hiérarchie sous forme de couches multiples et que nous laissons le réseau apprendre la combinaison de caractéristiques appropriée, nous obtenons ce que l'on appelle l'architecture d'apprentissage profond. Ainsi, les réseaux d'apprentissage profond sont de nature hiérarchique.

Les architectures d'apprentissage profond ont conduit à un progrès incroyable dans les tâches de vision par ordinateur, allant de l'identification et de la génération de masques précis autour d'objets à l'identification des propriétés spatiales d'un objet. Les architectures *Mask-RCNN* et *RetinaNet* ont principalement conduit à cette amélioration.

*Mask-RCNN* est utilité dans la segmentation d'objets individuels, c'est-à-dire la création de masques pour chaque objet d'une image. L'entrée et la sortie sont toutes deux des images. L'architecture peut également être utilisée pour faire de la segmentation d'instance, c'est-à-dire identifier différents objets du même type dans une image. *Detectron*, un système logiciel de *Facebook AI Research* (*FAIR*), met en œuvre tous ces algorithmes de détection d'objets de pointe et est open source.

Certaines des applications pratiques des ConvNets sont l'aide à la conduite et l'analyse d'images médicales.

Bien que les sciences et les mathématiques qui sous-tendent l'apprentissage profond soient assez bien comprises, il reste quelques questions intéressantes qui nécessitent davantage de recherche. Ces questions sont les suivantes : 
- Pourquoi les architectures à plusieurs couches sont-elles plus performantes, étant donné que nous pouvons approximer n'importe quelle fonction avec deux couches ? 
- Pourquoi les ConvNets fonctionnent-ils aussi bien avec des données naturelles telles que la parole, les images et le texte ? 
- Comment sommes-nous capables d'optimiser aussi bien les fonctions non convexes ? 
- Pourquoi les architectures surparamétrées fonctionnent-elles ?

L'extraction de caractéristiques consiste à élargir la dimension de représentation de telle sorte que les caractéristiques élargies aient plus de chances d'être linéairement séparables (en raison de l'augmentation du nombre de plans de séparation possibles).

Auparavant, les experts en apprentissage machine s'appuyaient sur des caractéristiques de haute qualité, artisanales et spécifiques à une tâche afin de construire des modèles d'intelligence artificielle. Mais avec l'avènement de l'apprentissage profond, les modèles sont capables d'extraire automatiquement les caractéristiques génériques. Certaines approches courantes utilisées dans les algorithmes d'extraction de caractéristiques sont mises en évidence ci-dessous :

- Pavage de l'espace (*Space tiling*)
- Projections aléatoires (*Random Projections*)
- Classifieur polynomial (*Polynomial Classifier*)
- Fonctions radiales (*Radial basis functions*)
- Machines à noyaux (*Kernel Machines*)


En raison de la nature compositionnelle des données, les traits appris ont une hiérarchie de représentations avec un niveau d'abstraction croissant. Par exemple :
- pour les images:\\
Au niveau le plus granulaire, les images peuvent être considérées comme des pixels. La combinaison de pixels constitue des bords qui, lorsqu'ils sont combinés, forment des textons (formes à bords multiples). Les textons forment des motifs et les motifs font partie de l'image. En combinant ces parties ensemble, on obtient l'image finale.
- pour le texte:\\
De même, il existe une hiérarchie inhérente aux données textuelles. Les caractères forment des mots, lorsque nous combinons des mots ensemble, nous obtenons des groupes de mots, puis en les combinant nous obtenons des phrases. Les phrases nous disent finalement quelle histoire est véhiculée.
- pour la parole:\\
Dans la parole, les échantillons composent des bandes, qui composent des sons, puis des phonèmes, puis des mots entiers, puis des phrases, montrant ainsi une hiérarchie claire dans la représentation.



<!--
## [Learning representations](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)
-->

## [Apprendre les représentations](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

<!--
There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more?

For example: SVMs find a separating hyperplane "in the span of the data", meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in $N$ (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to $\log(N)$, the layers become linear in $N$. There is a trade-off between time and space.

An analogy is designing a circuit to compute a boolean function with no more than two layers of gates -- we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions.

What is "deep"?

- An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity**

How can models learn representations (good features)?

Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*).

Q&A from the end of lecture:

- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not
-->


Certaines personnes rejettent l'apprentissage profond car si nous pouvons approcher n'importe quelle fonction avec deux couches, pourquoi en avoir plus ?

Par exemple, les SVMs (de l’anglais *support vector machines*, pouvant être traduit en français par machines à vecteurs de support) trouvent un hyperplan de séparation dans l'étendue des données. Cela signifie que les prédictions sont basées sur des comparaisons avec des exemples d’entraînement. Les SVMs peuvent être vues comme un réseau neuronal à deux couches très simpliste, où la première couche définit des « pochoirs » et la seconde couche est un classifieur linéaire. Le problème avec deux couches est que la complexité et la taille de la couche intermédiaire sont exponentielles en $N$ (pour réussir une tâche difficile, il faut BEAUCOUP de modèles). Mais si vous augmentez le nombre de couches à $\log(N)$, les couches deviennent linéaires en $N$. Il y a un compromis entre le temps et l'espace.

Une analogie consiste à concevoir un circuit pour calculer une fonction booléenne avec un maximum de deux couches de portes : nous pouvons calculer **toute fonction booléenne** de cette façon ! Mais, la complexité et les ressources de la première couche (nombre de portes) deviennent rapidement inutilisables pour les fonctions complexes.


Qu'est-ce que la « profondeur » ?  
- Une SVM n'est pas profonde car ne comporte que deux couches
- Un arbre de classification n'est pas profond car chaque couche analyse les mêmes caractéristiques (brutes)
- Un réseau profond comporte plusieurs couches et les utilise pour construire une **hiérarchie de caractéristiques d'une complexité croissante**


Comment les modèles peuvent-ils apprendre les représentations (les bonnes caractéristiques) ?  
L'ensemble des images possibles est essentiellement infini, l'ensemble des images « naturelles » est un minuscule sous-ensemble. Par exemple : pour une image d'une personne, l'ensemble des images possibles est de l'ordre de grandeur du nombre de muscles du visage qu'elle peut bouger (degrés de liberté) soit environ 50. Un extracteur de caractéristiques idéal (et irréaliste) représente tous les facteurs de variation (chacun des muscles, éclairage, etc.). C'est l'hypothèse de la multiplicité : les données naturelles vivent dans une multiplicité à faible dimension.  


Réponses aux questions d'étudiants :  
**Pour l'exemple du visage, l'ACP qui est une technique de réduction de la dimensionnalité pourrait-elle extraire ces traits ?**
> Cela ne fonctionnerait que si la surface est un hyperplan, ce qui n'est pas le cas.
