---
lang: fr
lang-ref: ch.01-1
lecturer: Yann Le Cun
title: Motivation de l'apprentissage profond, son histoire et son inspiration
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 1 Aug 2020
translator: Loïck Bourdois
---


<!--
## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)
-->

## [Plan du cours](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!--
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
-->

- Les bases de l'apprentissage supervisé, des réseaux de neurones et de l'apprentissage profond
- Rétropropagation et composantes architecturales
- Les réseaux de neurones convolutifs et leurs applications
- Plus d’architectures d'apprentissage profond
- Astuces pour la régularisation / astuces pour l'optimisation / comprendre le fonctionnement de l'apprentissage profond
- Modèles à base d'énergie
- L’apprentissage autosupervisé et au-delà



<!--
## Inspiration of Deep Learning and its history
-->

## L'inspiration de l'apprentissage profond et son histoire

<!--
On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.

The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.

In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.

Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.

In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.

Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:

- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.

Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->

Sur le plan conceptuel, l'apprentissage profond est inspiré par le cerveau. Cependant tous les détails du cerveau ne sont pas pertinents. À titre de comparaison, les avions ont été inspirés par les oiseaux. Le principe du vol est le même, mais les détails sont extrêmement différents (les avions ne battant pas des ailes).

L'histoire de l'apprentissage profond remonte à un domaine qui a changé de nom pour devenir aujourd’hui la cybernétique. Elle a commencé dans les années 1940 avec McCulloch et Pitts. Ils ont eu comme idée que les neurones sont des unités de seuil avec des états de marche et d'arrêt. De ce fait, il est possible de construire un circuit booléen en connectant les neurones entre eux et d'effectuer des inférences logiques avec les neurones. Le cerveau est essentiellement une machine d'inférence logique car les neurones sont binaires. Les neurones calculent une somme pondérée d'entrées et comparent cette somme à son seuil. Un neurone s'allume s'il est supérieur au seuil et s'éteint s'il est inférieur. Ceci est une vue simplifiée du fonctionnement des réseaux neuronaux.

En 1947, Donald Hebb a eu l'idée que les neurones du cerveau apprennent en modifiant la force des connexions entre eux. C'est ce qu'on appelle l'hyperapprentissage, où si deux neurones sont activés ensemble alors la connexion entre eux augmente et s'ils ne sont pas activés ensemble alors la connexion diminue.

Plus tard, en 1948, la cybernétique a été proposée par Norbert Wiener. Il se base sur l'idée qu'en ayant des systèmes avec des capteurs et des actionneurs, alors il y a une boucle de rétroaction et un système d'autorégulation. Les règles du mécanisme de rétroaction d'une voiture sont toutes issues de son travail.

En 1957, Frank Rosenblatt a proposé le Perceptron, un algorithme d'apprentissage qui modifie les poids de réseaux neuronaux très simples.

Dans l'ensemble, cette idée d'essayer de construire des machines intellectuelles en simulant de nombreux neurones est née dans les années 1940. Elle a pris son essor dans les années 1950 et s'est complètement éteinte à la fin des années 1960. Les principales raisons de la disparition du domaine en 1960 sont les suivantes :

- Les chercheurs ont utilisé des neurones binaires. Cependant, la façon de faire fonctionner la rétropropagation est d'utiliser des fonctions d'activation qui sont continues. À cette époque, les chercheurs n'avaient pas l'idée d'utiliser des neurones continus et ils ne pensaient pas pouvoir réaliser l’entraînement avec des gradients car les neurones binaires ne sont pas différentiels.
- Avec les neurones continus, il faudrait multiplier l'activation d'un neurone par un poids pour obtenir une contribution à la somme pondérée. Cependant, avant 1980, la multiplication de deux nombres, en particulier des nombres à virgule flottante, était extrêmement lente. Cela n'encourageait donc pas à utiliser des neurones continus.

L’apprentissage profond a pris un nouvel essor en 1985 avec l'apparition de la rétropropagation. En 1995, le domaine a périclité à nouveau et la communauté de l'apprentissage machine a abandonné l'idée des réseaux neuronaux. Début 2010, les gens ont commencé à utiliser les réseaux de neurones dans la reconnaissance vocale avec une amélioration considérable des performances et, plus tard, ils ont été largement déployés dans le domaine commercial. En 2013, la vision par ordinateur a commencé à passer aux réseaux de neurones. En 2016, la même transition a eu lieu dans le traitement du langage naturel. Bientôt, des révolutions similaires se produiront dans la robotique, le contrôle et bien d'autres domaines.




<!--
### Supervised Learning
-->

### L’apprentissage supervisé

<!--
$90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.

Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->

$90\%$ des applications d'apprentissage profond utilisent l'apprentissage supervisé. L'apprentissage supervisé est un processus par lequel, on collecte un tas de paires d'entrées et de sorties. Les entrées sont introduites dans une machine pour apprendre la sortie correcte. Lorsque la sortie est correcte, on ne fait rien. Si la sortie est incorrecte, on ajuste le paramètre de la machine afin d’obtenir une nouvelle sortie ressemblant davantage à celle désirée. L'astuce consiste à déterminer la direction et l'ampleur de l'ajustement du paramètre, ce qui revient à calculer le gradient et la rétropropagation.

L'apprentissage supervisé est issu du Perceptron et de l'Adaline. L'Adaline est basé sur la même architecture avec des entrées pondérées. Au-dessus du seuil, cela s'allume et en dessous du seuil, cela s'éteint. Le Perceptron est un réseau de neurones à deux couches dont la première couche est fixe et la deuxième couche est entraînable. La plupart du temps, la première couche est déterminée de manière aléatoire et c'est ce qu'on appelle les couches associatives.


<!--
## [History of Pattern Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)
-->
## [Histoire de la reconnaissance des motifs et de l'introduction de la descente en gradient](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!--
The foregoing is the conceptual basis of *pattern* recognition before deep learning developed. The standard model of *pattern* recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, *pattern* recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.

After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.

The simplest multi-layer architecture with tunable parameters and nonlinearity could be: input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix which coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.

Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is loss computing distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.

The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.

The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->

La base conceptuelle de la reconnaissance des motifs précède le développement de l'apprentissage profond. 
Le modèle standard de reconnaissance des motifs comprend un extracteur de caractéristiques et un classifieur pouvant être entraîné. 
L'entrée va dans l'extracteur de caractéristiques où sont extraites les caractéristiques pertinentes comme la détection d'un œil lorsque le but est de reconnaître le visage. Ensuite, le vecteur de caractéristiques est envoyé au classifieur (pouvant être entraîné) pour calculer la somme pondérée et la comparer avec le seuil. Dans ce cas, un classifieur pouvant être entraîné peut être un perceptron ou un réseau neuronal unique. Le problème est que l'extracteur de caractéristiques doit être conçu à la main. Ce qui signifie que la reconnaissance des motifs et la vision par ordinateur se concentrent sur l'extracteur en considérant la façon de le concevoir pour un problème particulier, ce qui n'est pas vraiment le cas d'un classifieur pouvant être entraîné.

Après l'émergence et le développement de l'apprentissage profond, le processus en deux étapes est passé à des séquences de modules. Chaque module a des paramètres réglables et une non-linéarité. Ensuite, il faut les empiler pour former plusieurs couches. C'est pourquoi on l'appelle « apprentissage profond ». La raison pour laquelle on utilise une non-linéarité plutôt qu'une linéarité est que deux couches linéaires reviennent à une seule couche linéaire puisque la composition de deux linéaires est linéaire.

L'architecture multicouche la plus simple avec des paramètres réglables et la non-linéarité pourrait être la suivante. L'entrée est représentée par un vecteur tel qu'une image ou un son. Cette entrée est multipliée par la matrice de poids dont le coefficient est un paramètre réglable. Ensuite, chaque composante du vecteur de résultat est passée par une fonction non linéaire telle que la ReLU (*Rectified Linear Unit*). En répétant ce processus, cela devient un réseau neuronal de base. La raison pour laquelle on parle de neurones est que cette architecture calcule la somme pondérée des composantes d'entrée par les lignes correspondantes d'une matrice.

Pour en revenir à l'apprentissage supervisé, nous comparons le résultat obtenu avec le résultat cible puis nous optimisons la fonction objectif qui est la perte du calcul de la distance/pénalité/divergence entre le résultat et la cible. Ensuite, nous faisons la moyenne de cette fonction de coût sur le jeu d’entraînement. C'est l'objectif que nous voulons minimiser. En d'autres termes, nous voulons trouver la valeur des paramètres qui minimisent cette moyenne.

La méthode pour trouver cette valeur est le calcul du gradient. Par exemple, si nous sommes perdus dans une montagne par une nuit brumeuse et nous voulons aller au village dans la vallée, un moyen pourrait être de faire demi-tour et de voir quel est le chemin le plus raide pour descendre puis de faire un petit pas vers le bas. La direction est le gradient (négatif). En supposant que la vallée est convexe, nous pouvons atteindre la vallée.

Le chemin le plus efficace est appelé la « descente de gradient stochastique » (SGD en anglais pour *Stochastic Gradient Descent*). Comme nous voulons minimiser la perte moyenne sur le jeu d’entraînement, nous prenons un échantillon ou un petit groupe d'échantillons et nous calculons l'erreur. Puis nous utilisons la descente de gradient. Ensuite, nous prenons un nouvel échantillon et obtenons une nouvelle valeur pour l'erreur. Nous avons alors le gradient qui est normalement une direction différente. Deux des principales raisons d'utiliser la SGD sont qu'elle permet à un modèle de converger rapidement si le jeu d’entraînement est très grand et qu'elle permet une meilleure généralisation, c'est-à-dire qu'elle donne des performances similaires sur différents jeux de données.




<!--
### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)
-->
### [Calculer les gradients par rétropropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!--
Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$
-->

Le calcul des gradients par rétropropagation est une application pratique de la règle de la chaîne. L'équation de rétropropagation pour les gradients d'entrée est la suivante :

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$


<!--
The backpropagation equation for the weight gradients is as follows:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$
-->

Dans la même logique, l'équation de rétropropagation pour les gradients des poids est la suivante :

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!--
Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.

It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->

Notez qu'au lieu d'entrées scalaires, il s'agit d'entrées vectorielles. Plus généralement, il s'agit d'entrées multidimensionnelles. La rétropropagation permet de calculer la dérivée de la différence entre la sortie souhaitée et la sortie obtenue (qui est la valeur de la fonction objectif) par rapport à toute valeur à l'intérieur du réseau. Enfin, la rétropropagation est essentielle car elle s'applique à plusieurs couches.

Il est important de réfléchir à la manière d'interpréter les entrées. Par exemple, une image de $256\times256$ nécessite une matrice d'une valeur de $200 000$. On aurait alors d'énormes matrices que les couches du réseau neuronal auraient à manipuler. Il n'est donc pas pratique d'utiliser de telles matrices. Par conséquent, il est important de faire des hypothèses sur la structure de la matrice.


<!--
## Hierarchical representation of the Visual Cortex
-->
## Représentation hiérarchique du cortex visuel

<!--
Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does *pattern* recognition in a hierarchical manner.

Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (e.g. vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->

Les expériences de Fukushima nous ont permis de comprendre comment notre cerveau interprète les données transmises à nos yeux. En résumé, les neurones situés devant notre rétine compriment l'entrée (connue sous le nom de normalisation du contraste) et le signal voyage de nos yeux à notre cerveau. Ensuite, l'image est traitée par étapes et certains neurones sont activés pour certaines catégories. Ainsi, le cortex visuel effectue une reconnaissance des motifs de manière hiérarchique.

Des expériences dans lesquelles des chercheurs ont enfoncé des électrodes dans des zones spécifiques du cortex visuel, en particulier la zone V1, ont permis de réaliser que certains neurones réagissent à des motifs qui apparaissent dans une très petite zone du champ visuel et de la même façon avec les neurones voisins et les zones voisines du champ visuel. En outre, les neurones qui réagissent au même champ visuel réagissent à différents types de bords de manière organisée (par exemple, les bords verticaux ou horizontaux). Il est également important de noter qu'il y a aussi l'idée que le processus visuel est essentiellement un processus *feed forward*. Par conséquent, une reconnaissance rapide peut être effectuée d'une manière ou d'une autre, sans que certaines connexions récurrentes soient nécessaires.
