---
lang-ref: ch.14-3
title: بیش برازش و قانونمند سازی
lecturer: Alfredo Canziani
authors: Karl Otness, Xiaoyi Zhang, Shreyas Chandrakaladharan, Chady Raach
date: 5 May 2020
lang: fa
translation-date: 1 Oct 2020
translator: Nikan Doosti Lakhani
---

<!--
## Overfitting

Consider a regression problem. A model could underfit, right-fit, or overfit.

If the model is insufficiently expressive for the data it will underfit. If the model is more expressive than the data (as is the case with deep neural networks), it runs the risk of overfitting.

In this case, the model is powerful enough to fit both the original data *and* the noise, producing a poor solution for the task at hand.

Ideally we would like our model to fit the underlying data and not the noise, producing a good fit for our data. We would especially like to do this without needing to reduce the power of our models. Deep learning models are very powerful, often much more than is strictly necessary in order to learn the data. We would like to keep that power (to make training easier), but still fight overfitting.
-->

## بیش برازش

یک مسئله رگرسیون را در نظر بگیرید. یک مدل می تواند کم برازش، برازش و یا بیش برازش داشته باشد.

اگر مدل به طور ناکافی بیانگر داده ها باشد، آنگاه کم برازش شده است. اگر مدل بیشتر بیانگری بیشتر از داده ها داشته باشد (مانند حالت شبکه های عصبی) خطر بیش برازش را به همراه دارد.

در این حالت، مدل به اندازه کافی قوی هست که بتواند هم داده *و* هم نویز را یاد گرفته، و راه حل هایی ضعیف را برای مشکل موجود تولید کند.

به صورت ایده آل، ما دوست داریم که مدل داده های اساسی و نه نویز را یاد بگیرد و یک برازش مناسب برای داده ها ایجاد کند. ما به صورت مخصوص علاقه داریم که این اتفاق را بدون نیاز به کاهش دادن قدرت مدل انجام دهیم.  مدل های یادگیری عمیق بسیار قدرتمند هستند، اغلب خیلی بیشتر از چیزی که لزوما برای یادگیری داده ها وجود دارد. ما علاقه داریم که این قدرت را نگه داشته (تا آموزش را آسان تر کنیم)، ولی همچنان با بیش برازش نیز مقابله کنیم.

<!--
### Overfitting for debugging

Overfitting can be useful in some cases, such as during debugging. One can test a network on a small subset of training data (even a single batch or a set of random noise tensors) and make sure that the network is able to overfit to this data. If it fails to learn, it is a sign that there may be a bug.
-->

### بیش برازش برا ی اشکال زدایی

بیش برازش در برخی موارد می تواند کاربردی نیز باشد، مانند در حین اشکال زدایی. شخص می تواند یک شبکه را بر روی یک زیر مجموعه کوچک از داده های آموزشی (حتی یک دسته تنها و یا یک مجموعه از تنسورهای نویز تصادفی) آزمایش کرده و مطمئن شود که شبکه توانایی بیش برازش بر روی این داده ها را دارد. اگر آن در یادگیری شکست بخورد، نشانه ای است که ممکن است باگی وجود داشته باشد.


<!--
## Regularization

We can try to fight overfitting by introducing regularization. The amount of regularization will affect the model's validation performance. Too little regularization will fail to resolve the overfitting problem. Too much regularization will make the model much less effective.

*Regularization* adds prior knowledge to a model; a prior distribution is specified for the parameters. It acts as a restriction on the set of possible learnable functions.

Another definition of regularization from Ian Goodfellow:
> Regularization is any modification we make to a learning algorithm that is intended to reduce its generalization error but not its training error.
-->

## قانونمند سازی
ما می توانیم با معرفی قانونمند سازی، به تلاش برای مبارزه با بیش برازش بپردازیم. میزان قانونمند سازی بر روی اعتبارسنجی مدل تأثیر می گذارد. مقدار بسیار کوچک قانونمند سازی در حل مشکل بیش برازش شکست خواهد خورد. مقدار بسیار بزرگ قانونمند سازی نیز، مدل را بسیار کم تأثیر تر می کند.

*قانونمند سازی* یک دانش پیشین به مدل اضافه می کند. یک توضیع پیشین برای پارامترها تعیین می گردد. این موضوع به عنوان یک محدودیت بر روی مجموعه توابع قابل یادگیری ممکن تأثیر می گذارد.

تعریف دیگر قانونمند سازی از Ian Goodfellow:
> قانونمند سازی، تغییری است که ما بر روی یک الگوریتم آموزش اعمال می کنیم که در نظر دارد تا خطای عمومی سازی را کاهش داده ولی خطای آموزش را خیر.

<!--
### Initialization techniques

We can select a prior for our network parameters by initializing the weights according to a particular distribution. One option: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).
-->

### تکنیک های مقدار دهیه اولیه
ما می توانیم یک دانش پیشین را به وسیله مقدار دهیه اولیه وزن ها طبق یک توضیع خاص برای شبکه خود انتخاب کنیم. یک گزینه [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).

<!--
### Weight decay regularisation

Weight decay is our first regularisation technique. Weight decay is in widespread use in machine learning, but less so with neural networks.  In PyTorch, weight decay is provided as a parameter to the optimizer (see for example the `weight_decay` parameter for [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).

This is also called:

- L2
- Ridge
- Gaussian prior

We can consider an objective which acts on the parameters:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

then we have updates:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

For weight decay we add a penalty term:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

This new term in the update drives the parameters $\theta$ slightly toward zero, adding some "decay" in the weights with each update.
-->

### قانونمند سازی افول وزن

افول وزن اولین تکنیک قانونمند سازی ماست. افول وزن به صورت گسترده در یادگیری ماشین ولی به صورت کمتر با شبکه های عصبی مورد استفاده قرار می گیرد. در پایتورچ، افول وزن به عنوان یک پارامتر به بهینه ساز داده می شود ( مثال مربوط به پارامتر `weight_decay` را برای [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD) ببینید).

این همچنین به اسامی زیر صدا زده می شود:

- L2
- Ridge
- Gaussian prior

ما می توانیم یک هدف که بر روی پارامترها عمل می کند را در نظر بگیریم:

 $$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

سپس بروزرسانی را خواهیم داشت:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

برای افول وزن، یک عبارت پنالتی نیز اضافه می کنیم:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

که بروزرسانی زیر را تولید می کند:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

عبارت جدید در بروزرسانی، پارامترهای $\theta$ را به مقدار کمی به سمت صفر می راند، و مقداری "افول" در وزنها با هر بروزرسانی اضافه می کند.

<!--
### L1 regularisation

Available as an option for PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html).

Also called:

- LASSO: Least Absolute Shrinkage Selector Operator
- Laplacian prior
- Sparsity prior

Viewing this as a Laplace distribution prior, this regularization puts more probability mass near zero than does a Gaussian distribution.

Starting with the same update as above we can view this as adding another penalty:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

Unlike $L_2$ weight decay, the $L_1$ regularization will "kill" components that are close to an axis in the parameter space, rather than evenly reducing the length of the parameter vector.
-->

### قانونمند سازی L1

به عنوان یک گزینه برای [بهینه ساز های](https://pytorch.org/docs/stable/optim.html) پایتورچ در دسترس است.

نام گذاری های دیگر:

- LASSO: اپراتور انتخاب کمترین مقدار مطلق انقباض
- Laplacian prior
- Sparsity prior

با نگاه به این به عنوان یک توضیع پیشین لاپلاس، این قانونمند سازی مقدار احتمال بیشتری را نزدیک به صفر، نسبت به توضیع گاوسی قرار می دهد.

با شروع با بروزرسانی ای یکسان با بالا، ما می توانیم این را به عنوان اضافه کردن یک پنالتی جدید ببینیم:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

که بروزرسانی زیر را تولید می کند:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

بر خلاف افول وزن $L_2$، قانونمند سازی $L_1$ اجزایی را که نزدیک به یک محور در فضای پارامتر هستند را به جای کاهش طول بردار پارامتر به صورت مساوی، از بین می برد.

<!--
### Dropout

Dropout involves setting a certain number of neurons to zero randomly during training. This prevents the network from learning a singular path from input to output. Similarly, due to the large parametrisation of neural networks, it is possible for the neural network to effectively memorize the input. However, with dropout, this is a lot more difficult since the input is being put into a different network each time since dropout effectively trains a infinite number of networks that are different each time. Hence, dropout can be a powerful way of controlling overfitting and being more robust against small variations in the input.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 1: Network without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 2: Network with dropout
</center>

In PyTorch, we can set a random dropout rate of neuron.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
Figure 3: Dropout code
</center>

After training, during inference, dropout is not used any more. In order to create the final network for inference, we average over all of the individual networks created during dropout and use that for inference. We can similarly multiply all of the weights by $1/1-p$ where $p$ is the dropout rate.
-->

### Dropout
dropout، شامل صفر کردن تعدادی از نورون به صورت تصادفی در طول آموزش است. این باعث می شود تا از یادگیری یک مسیر تنها از ورودی به خروجی توسط شبکه جلوگیری شود. به صورت مشابه، به دلیل پارامتری شدن زیاد شبکه های عصبی، این امکان برای شبکه های عصبی وجود دارد که به صورت مؤثری ورودی را به خاطر بسپارد. اگرچه، با dropout، این بسیار سخت تر خواهد بود زیرا ورودی هر برای به یک شبکه متفاوت داده می شود زیرا dropout، تعداد بی نهایت شبکه را که در هر زمان با هم متفاوت هستند به صورت مؤثری آموزش می دهد. بنابراین، dropout می تواند یه روش قدرتمند برای کنترل بیش برازش بوده و مقاومت در برابر تغییرات کوچک در ورودی را پدید می آورد.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
شکل 1: شبکه بدون dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
شکل 2: شبکه با dropout
</center>

در پایتورچ، ما می توانیم نرخ dropout نورون را تنظیم کنیم.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
شکل 3: کد dropout
</center>

بعد از آموزش، در حین استنتاج، dropout دیگر استفاده نمی شود. برای اینکه شبکه نهایی را برای استتنتاج بسازیم، ما بر روی تمامی تک تک شبکه هایی که در حین dropout ساخته شده اند، میانگین گرفته و از آن برای استنتاج استفاده می کنیم. ما به طور مشابه می توانیم همه وزن ها را در $1/1-p$ ضرب کنیم که $p$ نرخ dropout است.

<!--
### Early-stopping

During training, if the validation loss starts increasing, we can stop training and use the best weights found so far. This prevents the weights from growing too much which will start hurting validation performance at some point. In practise, it is common to calculate the validation performance at certain intervals and stop after a certain number of validation error calculations stop decreasing.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
Figure 4: Early stopping
</center>
-->

# توقف زود هنگام

در طول آموزش، اگر خطای اعتبارسنجی شروع به افزایش کند، ما می توانیم آموزش را متوقف کرده و از بهترین وزن هایی که تا به حال استفاده شده است، بهره ببریم. این از بزرگ شدن بیش از اندازه وزن ها جلوگیری می کند که شروع به آسیب زدن به کارایی اعتبارسنجی در نقطه ای خواهد زد. در عمل، این رایج است که کارایی اعتبارسنجی را در بازه های مشخصی محاسبه کرده و آنرا بعد از محاسبه تعداد مشخصی از خطای اعتبارسنجی که از کاسته شدن متوقف شده اند، متوقف می کنیم.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
شکل 4: توقف زود هنگام
</center>

<!--
# Fighting overfitting indirectly

There are techniques that have the side-effect of regularizing parameters but are not regularisers themselves.


## Batch-norm

Q. How does batch norm make training more efficient?
A. We can use higher learning rate when applying batch norm.

Batch normalization is used to prevent the internal covariate shift of a neural network but there is a lot debate if it actually does this and what the true benefit actually is.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
Figure 5: Batch normalization
</center>

Batch normalisation essentially extends the logic of normalizing the input of the neural network to normalizing the input of each hidden layer in the network. The basic idea is to have a fixed distribution feed each subsequent layer of a neural network since learning occurs best when we have a fixed distribution. To do this, we compute the mean and variance of each batch before each hidden layer and normalize the incoming values by these batch specific statistics, which reduces the amount by which the values will ultimately shift around during training.

Regarding the regularizing effect, due to each batch being different, each sample will be normalized by slightly different statistics based upon the batch it is in.  Hence, the network will see various slightly altered versions of a single input which helps the network learn to be more robust against slight variations in the input and prevent overfitting.

Another benefit of batch normalisation is that training is a lot faster.
-->

# مبارزه با بیش برازش به صورت غیر مستقیم

روش هایی وجود دارد که اثر جانبی قانونمند سازی را دارند ولی خودشان قانونمند ساز نیستند.

## نرمال سازی دسته ای

سوال: چطور نرمال سازی دسته ای آموزش را مؤثرتر می کند؟
پاسخ: ما می توانیم از نرخ آموزش بالاتری وقتی که از نرمال سازی دسته ای استفاده می کنیم، بهره ببریم.

نرمال سازی دسته ای برای جلوگیری از شیفت covariate داخلی شبکه عصبی استفاده شده است، ولی شبهات زیادی وجود دارد که آیا واقعا اینکار را انجام می دهد و اینکه مزیت حقیقی چیست.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
شکل 5: نرمال سازی دسته ای
</center>

نرمال سازی دسته ای اصولا منطق نرمال سازی ورودی شبکه عصبی را به نرمال سازی ورودی هر لایه مخفی در شبکه عصبی گسترش داده است. ایده پایه ای این است که توضیع معینی برای هر لایه متوالی در شبکه عصبی داشته باشیم زیرا آموزش زمانی به بهترین شکل رقم می خورد که توضیع معینی داشته باشیم. برای اینکار، ما میانگین و واریانس هر یک از دسته ها را قبل از هر لایه مخفی محاسبه کرده و مقادیر وارده را به وسیله این آمارهای مشخص دسته، نرمال سازی می کنیم که مقداری که مقادیر در نهایت در طول آموزش شیفت خواهند یافت را کاهش می دهد.

درباره ی اثر قانونمند سازی، از آنجا که هر دسته متفاوت است، هر نمونه بر اساس آمارهای مختلف اندکی متفاوت، بر اساس اینکه در چه دسته ای است،  نرمال خواهد شد. بنابراین، شبکه نسخه های مختلف کمی تفاوت یافته از یک وروردی یکسان را خواهد دید که به شبکه کمک می کند تا در مقابل تغییرات کم در ورودی مقاوم شده و از بیش برازش جلوگیری کند.

مزیت دیگر نرمال سازی دسته ای این است که آموزش بسیار سریع تر است.

<!--
### More data

Gathering more data is a easy way to prevent overfitting but can be expensive or not feasible.


### Data-augmentation

Transformations using Torchvision can have a regularizing effect by teaching the network to learn how to be insensitive to perturbations.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
Figure 6: Data augmentation with Torchvision.
</center>
-->

## داده بیشتر

جمع آوری داده بیشتر یک راه آسان برای جلوگیری از بیش برازش است ولی اینکار می تواند هزینه بر و یا اصلا شدنی نباشد.

### تکثیر داده

تبدیل ها به وسیله Torchvision می تواند اثر قانونمند سازی را به وسیله آموزش شبکه در یادگیری اینکه چگونه نسبت به انحرافات حساس نباشد را به وجود آورد.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
شکل 6: تکثیر داده با Torchvision.
</center>

<!--
### Transfer leaning (TF) fine-tuning (FT)

Transfer learning (TF) refers to just training a final classifier on top of a pre-trained network (used in cases of little data generally).

Fine tuning (FT) refers to training partial/full portions of the pre-trained netowrk as well (used in cases where we have a lot of data generally).

Q. Generally, when should we freeze the layers of a pre-trained model?
A. If we have little training data.

4 general cases:
1) If we have little data with similar distributions, we can just do transfer learning.
2) If we have a lot of data with similar distributions we can do fine-tuning in order to improve the performance of the feature extractor as well.
3) If we have a little data and a different distribution we should remove a few of the final trained layers in the feature extractor since they are too specialized.
4) If we have a lot of data and they are from different distributions, we can just train all portions.

Note, we can also use different learning rates for different layers in order to improve performance.

To further our discussion about overfitting and regularisation, let us look at the visualisations below. These visualisations were generated with the code from [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb).

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Loss curves without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Loss curves with dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Effect of regularization on weights
</center>

From Figure 7 and Figure 8, we can understand the dramatic effect that dropout has on generalisation error i.e the difference between the training loss and validation loss. In Figure 7, without dropout there is clear overfitting as the training loss is much lower than the validation loss. However, in Figure 8, with dropout the training loss and validation loss almost continuously overlap indicating that the model is generalising well to the validation set, which serves as our proxy for out-of-sample set. Of course, we can measure the actual out-of-sample performance using a separate holdout test set.

In Figure 9, we observe the effect that regularisation (L1 & L2) have on the weights of the network.

- When we apply L1 regularisation, from the red peak at zero, we can understand that most of the weights are zero. Small red dots closer to zero are the non-zero weights of the model.

- Contrastingly, in L2 regularisation, from the lavender peak near zero we can see that most of the weights are close to zero but non-zero.

- When there is no regularisation (blue) the weights are much more flexible and spread out around zero resembling a normal distribution.
-->

### انتقال یادگیری (Transfer Learning) و تنظیم دقیق (Fine Tuning)

انتقال یادگیری (TF) فقط به آموزش یک شبکه عصبی بر روی یک شبکه از بپش آموزش داده شده (به صورت عمومی در مواردی که داده کم است استفاده شده است) اشاره دارد.

تنظیم دقیق (FT) به آموزش بخش/کل یک شبکه از پیش آموزش داده شده (در مواردی استفاده می شود که معمولا داده به مقدار زیاد موجود است) نیز اشاره دارد.

سوال: به صورت عمومی، چه زمانی باید لایه های یک مدل از پیش آموزش داده شده را ثابت نگه داریم؟
پاسخ: زمانی که داده کمی داریم.

4 حالت کلی:
1) زمانی که داده کم با توضیع مشابه داریم، می توانیم فقط انتقال یادگیری انجام دهیم.
2) زمانی که داده زیاد یا توضیع مشابه داریم، می توانیم از تنظیم دقیق استفاده کنیم تا کارایی استخراج گر ویژگی را نیز بهبود دهیم.
3) زمانی که داده کم با توضیع متفاوت داریم، باید تعدادی از لایه های پایانی آموزش دیده شده در استخراج گر ویژگی را حذف کنیم، زیرا آنها بسیار خاص منظوره شده اند.
4) زمانی که داده زیاد با توضیع متفاوت داریم، می توانیم تمامی بخش ها را آموزش دهیم.

توجه کنید، می توانیم از نرخ های یادگیری متفاوتی برای لایه های متفاوت استفاده کنیم تا کارایی را بهبود دهیم.

برای اینکه بحث خودمان را درباره ی بیش برازش و قانونمند سازی گسترش دهیم، بیاید به نمایش زیر نگاه کنیم. این نمایش ها از طریق کد از [نوت بوک](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb) تولید شده اند.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شکل 7:</b> منحنی های خطا بدون dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شکل 8:</b> منحنی های خطا با dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شکل 9:</b> تأثیر قانونمند سازی بر وزن ها
</center>

از شکل 7 و 8، ما می توانیم اثر دراماتیکی که dropout بر روی خطای عمومی سازی یا همان تفاوت میان خطای آموزش و خطای اعتبارسنجی دارد را بفهمیم. در شکل 7، بدون dropout، به صورت واضح بیش برازش وجود دارد، از آنجا که خطای آموزش بسیار پایین تر از خطای اعتبارسنجی است. اگرچه، در شکل 8، با dropout، خطای آموزش و خطای اعتبارسنجی تقریبا به صورت پیوسته همپوشانی دارند که نشان دهنده این است که مدل بر مجموعه اعتبارسنجی به صورت خوبی عمومی سازی کرده است، که به عنوان یک پروکسی برای مجموعه خارج از نمونه عمل می کند. البته، ما می توانیم عملکرد واقعی خارج از نمونه را به وسیله یک مجموعه تست باقی مانده، اندازه گیری کنیم.

در شکل 9، ما اثر قانونمند سازی (L1 و L2) را بر روی وزن های شبکه می بینیم.

- وقتی که قانونمند سازی L1 را اعمال می کنیم، از جهش قرمز در صفر، ما می توانیم بفهمیم که اکثر وزن ها صفر هستند. نقاط قرمز رنگ نزدیک به صفر، وزن های غیر صفر مدل هستند.

- برعکس، در قانونمند سازی L2، از جهش به رنگ بنفش کمرنگ در اطراف صفر، می توانیم ببینیم که اکثر وزن ها نزدیک به صفر، ولی غیر صفر هستند.

- وقتی که هیچ قانونمند سازی ای وجود ندارد (آبی)، وزن ها بسیار بیشتر انعطاف پذیر هستند و اطراف صفر پخش شده اند به طوری که یک توضیع نرمال را تشبیه می کنند.

<!--
## Bayesian Neural Networks: estimating uncertainty around predictions

We care about uncertainty in neural networks because a network needs to know how certain/confident on its prediction.

Ex: If you build a neural networks to predict steering control, you need to know how confident the network's predictions.

We can use a neural network with dropout to get a confidence interval around our predictions. Let us train a network with dropout, $r$ being the dropout ratio.

Usually during inference, we set the network to validation mode and use all neurons to get the final prediction. While doing the prediction, we scale the weights $\delta$ by $\dfrac{1}{1-r}$ to account for dropping neurons during training.

This method gives us a single prediction for each input. However, to get a confidence interval around our prediction, we need multiple predictions for the same input. So instead of setting the network to validation mode during inference, we retain it in training mode *i.e.* still drop neurons randomly and get a prediction. When we predict multiple times using this dropout network, for the same input we will get different predictions depending on the neurons being dropped. We use these predictions to estimate the average final prediction and a confidence interval around it.

In the below images, we have estimated confidence intervals around the predictions of networks. These visualisations were generated with the code from [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). The red line represents the predictions. The purple shaded region around the predictions represent the uncertainty *i.e.* variance of predictions.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Uncertainty Estimation using ReLU activation
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Uncertainty Estimation using Tanh activation
</center>

As you can observe in the above images, these uncertainty estimations are not calibrated. They are different for different activation functions. Noticeably in the images, uncertainty around data points is low. Furthermore, the variance that we can observe is a differentiable function. So we can run gradient descent to minimise this variance. Thereby we can get more confident predictions.
-->

## شبکه های عصبی بیزی: تخمین عدم قطعیت اطراف پیش بینی ها

ما درباره ی عدم قطعیت در شبکه های عصبی اهمیت می دهیم، زیرا یک شبکه باید بداند که چقدر قطعیت/اطمینان به پیش بینی هایش دارد.

مثال: اگر شما یک شبکه عصبی بسازید تا کنترل فرمان را پیش بینی کند، باید بدانید که چقدر پیش بینی های شبکه قابل اعتماد هستند.

ما می توانیم از یک شبکه عصبی با dropout برای بدست آوردن بازه اطمینان در اطراف پیش بینی هایمان استفاده کنیم. بیایید یک شبکه با dropout که $r$ نرخ dropout باشد، آموزش دهیم.

معمولا در حین استتنتاج، ما شبکه را به حالت اعتبارسنجی تنظیم می کنیم و از تمامی نورون ها استفاده می کنیم تا پیش بینی نهایی را بدست آوریم. در حین انجام پیش بینی ها، ما وزن ها $\delta$ را با $\dfrac{1}{1-r}$ قیاس می کنیم تا نورون های حذف شده در حین آموزش را در نظر گرفته باشیم.

این روش یک پیش بینی برای هر ورودی خواهد داد. با این حال، برای بدست آوردن یک بازه اطمینان اطراف پیش بینی هایمان، ما نیاز به چندین پیش بینی برای یک ورودی یکسان داریم. در نتیجه، به جای تنظیم شبکه به حالت اعتبارسنجی در حین استتنتاج، آنرا در حین آموزش نیز نگه می داریم،  *به عبارت دیگر*، همچنان نورون ها به صورت تصادفی حذف شده و پیش بینی بدست می آید. وقتی ما برای چندبار به وسیله شبکه با dropout پیش بینی می کنیم، برای یک ورودی یکسان، پیش بینی متفاوتی را بسته به اینکه کدام نورون ها حذف شده اند، خواهیم گرفت. ما از این پیش بینی ها برای تخمین میانگین پیش بینی نهایی و بازه اطمینان اطراف آن، استفاده می کنیم.

 در تصاویر پایین، ما بازه های اطمینان را اطراف پیش بینی های شبکه ها داریم. این نمایش ها به وسیله کد از [نوتبوک شبکه های عصبی بیزی](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb) تولید شده است. خط قرمز بیانگر پیش بینی ها است. ناحیه بنفش اطراف پیش بینی ها بیانگر عدم قطعیت *به عبارت دیگر*، واریانس پیش بینی ها است.
 
 <center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شکل 10:</b> تخمین عدم قطعیت با تابع فعالساز ReLU
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>شکل 11:</b> تخمین عدم قطعیت با تابع فعالساز Tanh
</center>

همانطور که در تصاویر بالا مشاهده می کنید، این تخمین های عدم قطعیت، کالیبره نشده اند. آنها برای توابع فعالسازی متفاوت، متفاوت هستند.به طور مشخصی در تصاویر، عدم قطعیت در اطراف نقاط داده کم است. همچنین، واریانسی که می توانیم مشاهده کنیم، یک تابع مشتق پذیر است. در نتیجه، ما می توانیم از گرادیان کاهشی برای کمینه سازی این واریانس استفاده کنیم. در نتیجه می توانیم پیش بینی های با اطمینان بیشتری داشته باشیم.

<!--
#### If we have multiple terms contributing to total loss in our EBM model, how do they interact?

In EBM models, we can simply and conveniently sum the different terms to estimate the total loss.

**Digression**: A term that penalises the length of the latent variable can act as one of many loss terms in a model. The length of a vector is roughly proportional to the number  of dimensions it has. So if you decrease the number of dimensions, then the length of the vector decreases and as a result it encodes less information. In an auto-encoder setting, this makes sure that the model is retaining the most important information. So, one way to bottleneck information in latent spaces is to reduce the dimensionality of the latent space.
-->

#### اگر ما چندین عبارت داشته باشیم که به خطای کلی در مدل EBM ما شرکت می کنند، آنها چطور تعامل دارند؟

در مدل های EBM، ما به سادگی و راحتی، عبارت های مختلف را جمع کنیم تا خطای کلی را تخمین بزنیم.

**Digression**: عبارتی که طول متغییر latent را تنبیه می کند، می تواند به عنوان یکی از تعداد زیادی از عبارت های خطا در مدل رفتار کند. طول یک بردار، به صورت تقریبی، متناسب است با تعداد ابعادی که دارد. بنابراین، اگر شما تعداد ابعاد را کاهش دهید، آنگاه طول بردار کاهش یافته و در نتیجه آن، مقدار اطلاعات کمتری را انکود می کند. در تنظیمات اتوانکودر، این مطمئن می شود که مدل اکثر اطالاعات مهم را نگه داری می کند. بنابراین، یک راه برای ایجاد گلوگاه اطالاعاتی در فضای latent این است که ابعاد فضای latent را کاهش دهیم.

<!--
#### How can we determine the hyper-parameter for regularisation?

In practice, to determine the optimal hyper-parameter for regularisation i.e regularisation strength we can use

- Bayesian hyper-parameter Optimization
- Grid Search
- Random Search

While doing these searches, the first few epochs are usually enough to give us a sense of how the regularization is working. So we need train the model extensively.
-->

#### چطور می توانیم هاپیرپارامتر را برای قانونمند سازی تعیین نماییم؟

در عمل، برای تعیین هاپیرپارامتر بهینه برای قانونمند سازی، به عبارت دیگر، قدرت قانونمند سازی، ما می توانیم از موارد زیر استفاده کنیم

- بهینه سازی هاپیرپارامتر بیزی
- جستجوی شبکه ای
- جستجوی تصادفی

در حین انجام این جستجوها، چند دوره اول معمولا کافی هستند تا با ما یک حس از اینکه قانونمند سازی در حال عمل است، بدهند. در نتیجه، نیاز داریم تا مدل را به صورت گسترده آموزش دهیم.

