---
lang-ref: ch.14-2
lecturer: Yann LeCun
title: روشهای مبتنی بر انرژی گرافی
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
lang: fa
translation-date: 1 Oct 2020
translator: Nikan Doosti Lakhani
---

<!--
## Comparing Losses

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center>

In the figure above, incorrect paths have -1.

Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.

In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.

Q: How is the segmentor implemented in the model above?

A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition.
-->

## مقایسه خطاها

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
شکل 1: معماری شبکه
</center>

در شکل بالا، مسیرهای نادرست مقدار -1 دارند.

پروفسور LeCun با خطای پرسپترون شروع می کند که در مثال مدل مبدل گراف در شکل بالا استفاده شده است. هدف این است که انرژی جواب های نادرست را زیاد و انرژی موارد درست را کم کنیم.

از دید پیاده سازی، یال های درون نمایش را باید به صورت بردار پیاده سازی کنید. به جای استفاده از یک بردار مجزا برای هر گروه، یک بردار شامل هم گروه و هم مقدار امتیاز برای هر گروه خواهد بود.

سوال: قطعه بند در مدل بالا به چه صورت پیاده سازی شده است؟

پاسخ: قطعه بند یک مجموعه از هیوریستیک های دست سازی شده است. مدل از یک قطعه بند دست ساز استفاده می کند، اگر چه راهی وجود دارد تا آن را به صورت سرتاسر آموزش داد. این روش دست ساز جایگزین روش پنجره لغزان برای بازشناسی کاراکتر شده بود.

<!--
## Overview of Losses

<center>
Table 1: Various Loss Equations
</center>

| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.

* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.

Q: How may hinge be better than NLL loss?

A: Hinge is better than NLL becuase NLL will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m).
-->

## مرور خطاها
<center>
جدول 1: معادلات خطاهای مختلف
</center>

| معادله خطا | فرمول  | حاشیه |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |

خطای پرسپترون دیده شده در جدول بالا حاشیه ای ندارد و در نتیجه این خطا، خطر فروریختگی و سقوط شدید را در خود دارد.

* خطای Hinge انرژی را از جواب های با بیشترین تهاجم و جواب های درست می گیرد و تفاوت آنها را محاسبه می کند. به صورت شهودی، با حاشیه m، خطای hinge  تنها زمانی خطای 0 خواهد داشت که انرژی جواب های درست از تهاجمی ترین انرژی به اندازه _حداقل_ m کمتر باشد.
* خطای MSE در بازشناسی گفتار استفاده شده است به زیگموید بسیار شبیه است.
* خطای NLL کوچک کردن انرژی جواب های درست و  بزرگ کردن قسمت لگاریتمی معادله را هدف قرار می دهد.

سوال: چطور hinge می تواند بهتر از NLL باشد؟

پاسخ: Hinge از خطای NLL بهتر است زیرا NLL تلاش می کند تا تفاوت میان پاسخ درست و سایر جواب ها را به سمت بی نهایت هل دهد، در حالی که hinge فقط می خواهد مقدار آن را بزرگ تر مقداری (حاشیه m) کند.

<!--
### DEFINITION:

A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.

Q: What are some examples of problems that can use decoders?
A: Language modelling, machine translation, and sequence tagging.
-->

### تعریف
یک دیکودر، یک رشته از از بردارهایی که بیانگر امتیازها یا انرژی هر یک از صداها و یا تصاویر هستند را به عنوان ورودی گرفته و بهترین خروجی ممکن را بر می دارد.

سوال: چه نمونه هایی از مسائل هستند که از دیکودر استفاده می توانند کنند؟
پاسخ: مدل سازی زبانی، ترجمه ماشینی و برچسب زنی رشته ها.

<!--
## Forward algorithm in Graph Transformer Networks

### Graph Composition

Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center>

The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.

Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?

The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values.

If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.

In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.

As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.
-->

## الگوریتم های جلو رونده در شبکه های مبدل گراف

### ترکیب گراف
ترکیب گراف این امکان را به ما می دهد که تا دو گراف را ترکیب کنیم. در این مثال می توانیم ببینم که یک مدل زبانی واژگان از طریق یک $trie$ (یک گراف) و یک گراف بازشناسی که باز طریق شبکه عصبی ساخته شده است، بیان شده است.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>شکل 2</b>: ترکیب گراف
</center>

گراف بازشناسی از طریق مقادیر مختلف انرژی (منتسب به هر یال) بیان می کند که چقدر یک کاراکتر در قدمی خاص محتمل است.

حال، برای این مثال، سوالی که ما با عملیات ترکیب گراف پاسخ می دهیم این است که، چه مسیری در این گراف بازشناسی بهترین است که در عین حال با واژگان ما منطق باشد؟

پرش مشترک از قدم 1 به قدم 2 بین گراف بازشناسی و گرامر، کاراکتر $c$ با انرژی 0.4 است. بنابراین، گراف ادراک ما شامل تنها یک یال بین قدم 1 و 2 متناظر با $c$ است. به طور مشابه، کاراکترهای ممکن بین قدم 2و 3 به ترتیب $x$، $u$ و $a$ در گراف بازشناسی هستند. شاخه های بعد از $c$ در گراف گرامر شامل $u$ و $a$ هستند. در نتیجه، عمل ترکیب گراف یال های $u$ و $a$ را بر میدارد تا در گراف ادراک نمایش دهد. این همچنین یال کپی شده از گراف بازشناسی را با مقادیر انرژیشان انتساب می دهد.

اگر گرامر نیز مقادیر انرژی ای منتسب با یال ها داشته باشد، ترکیب گراف مقادیر انرژی را جمع می زد یا از طریق اپراتور دیگری این مقادیر را ترکیب می کرد.

در روشی مشابه، ترکیب گراف این اجازه را نیز به ما می دهد که تا پایگاه دانش را که از طریق شبکه های عصبی بیان شده اند، ترکیب نماییم. در مثال بحث شده بالا، گرامر می تواند اساسا به صورت یک شبکه عصبی که کاراکتر بعدی را پیش بینی می کند، بیان شود. خروجی softmax از NN برای ما احتمالات انتقال به کاراکتر بعدی در ازای داشتن یک رأس را فراهم می آورد.

به عنوان یک نکته حاشیه ای، اگر مدل زبانی نشان داده شده در این مثال یک شبکه عصبی باشد، می توانیم از درون تمامی ساختار پس انتشار را انجام دهیم. این تبدیل به یک مثال از برنامه مشتق پذیر می شود که از درون برنامه شامل حلقه، شروط if، بازگشتی ها و غیره، می توان پس انتشار داشت.

<!--
### A check reader from mid-90s

The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center>

This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.

The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.

Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.
-->
### یک چک خوان از میانه دهه 90

تمامی معماری یک چک خوان از میانه دهه 90 تقریبا پیچیده است ولی آنچه که ما صورت اصلی به آن علاقه مند هستیم، بخشی است که با بازشناسی کاراکتر شروع شده که گراف بازشناسی را تولید می کند.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>شکل 3</b>: چک خوان
</center>

این گراف بازشناسی دستخوش دو عملیات ترکیبی است، یکی مربوط به تفسیر صحیح (یا داده صحت سنجی شده) و دیگری مربوط به گرامر که یک گراف از تمامی ادراک های ممکن می سازد.

تمامی سیستم با تابع خطای Negative Log-Likelihood آموزش داده شده است. Negative log-likelihood می گویید که هر مسیر در گراف ادراک یک تفسیر محتمل است و جمع انرژی در این مسیر، انرژی آن تفسیر است.

حال، به جای استفاده از الگوریتم Viterbi، از الگوریتم جلو رونده استفاده می کنیم. زیر بخش های ادامه، تفاوت میان دو روش روش بررسی مورد بحث قرار می دهد.

<!--
#### Viterbi algorithm

Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.

$$F (x, y) = \min_{z} \; E(x, y, z)$$

#### The forward algorithm

The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.

The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.

The working of the forward algorithm can be shown using the following example defined on an interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center>


The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.

For the red node, the value of energy at the node is given by:

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$
-->

#### الگوریتم Viterbi
الگوریتم Viterbi یک الگوریتم برنامه نویسی پویا است که برای یافتن مسیر با بالاترین شانس ( یا مسیر با حداقل انرژی) در یک گراف موجود، استفاده می شود می شود. این روش، انرژی را نسبت به متغیر latent z کمینه می کند که z، بیانگر مسیری است که ما در گراف در حال طی کردن هستیم.

$$F (x, y) = \min_{z} \; E(x, y, z)$$

#### الگوریتم جلو رونده

از طرفی دیگر، الگوریتم جلو رونده، لگاریتم مجموع نمایی های مقادیر منفی انرژی های همه مسیرها را محاسبه می کند. این عبارت پیچیده را می توان به سادگی در در فرمول پایین دید:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

این عبارت در حال حاشیه سازی بر روی متغییر latent z که مسیرها را در گراف ادراک تعریف می کند، است. این روش،این مقدار لگارتیم مجموع نمایی ها را بر روی تمامی مسیرهای ممکن به یک رأس خاص برا محاسبه می کند. این همانند آن است که هزینه تمامی مسیرهای ممکن را در روشی نظیر soft-minimum ترکیب کنیم.

الگوریتم جلو رونده برای پیاده سازی کم هزینه بوده و از روش Viterbi هزینه بیشتری ندارد. همچنین، ما می توانیم از درون رأس الگوریتم جلو رونده در گراف، پس انتشار را انجام دهیم.

روش کار الگوریتم جلو رونده را می توان در مثال تعریف شده بر روی گراف ادراک، در ادامه نشان داد.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>شکل 4</b>: گراف ادراک
</center>

هزینه از رأس ورودی به رأس قرمز از طریق حاشیه سازی بر روی تمامی مسیرهای ممکن که به رأس قرمز دست یابی دارند، محاسبه می شود. فلش هایی وارد شونده به رأس قرمز، این مسیرهای ممکن را در مثال ما تعریف می کنند.

برای رأس قرمز، مقدار انرژی در رأس از طریق زیر داده شده است:

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$


<!--
#### Neural network analogy of forward algorithm

The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term.

For each node in the interpretation graph, we maintain a variable $\alpha$.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

where $e_{ki}$ is the energy of the link from node $k$ to node $i$.

$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.

We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>

Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.

The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations.
-->

#### آنالوژی شبکه عصبی برای الگوریتم جلو رونده

الگوریتم جلو رونده یک حالت خاص از الگوریتم انتشار-باور است، وقتی که گراف اصلی یک گراف زنجیری باشد. تمامی الگوریتم را می توان به صورت یک شبکه عصبی پیشخور (feedforward) است که تابع در هر رأس از یک لگارتیم از جمع نمایی ها و یک عبارت جمعی تشکل شده است.

برای هر رأس در گراف ادراک، ما یک متغییر $\alpha$ را نگه می داریم.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

که $e_{ki}$ یک انرژی لینک از رأس $k$ به رأس $i$ است.

$\alpha_i$ فعالسازی رأسی نظیر $i$ را در این شبکه عصبی می سازد و $e_{ki}$ وزن بین رئوس $k$ و رأس $i$ است. این فرمول بندی به صورت جبری با عملیات جمع وزن دار یک شبکه عصبی معمولی در دامنه لگاریتمی براری می کند.

ما می توانیم از درون گراف ادراک پویا (از آنجا که برای هر نمونه تغییر می کند) پس انتشار را انجام دهیم که ما برای روی آن الگوریتم جلو رونده را اعمال می کنیم. ما می توانیم گرادیان های $F(x, y)$ را در آخرین رأس گراف نسبت به $e_{ki}$ وزن ها که یال های گراف ادراک را می سازند، محاسبه کنیم.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>شکل 5</b>: چک خوان
</center>

اگر به مثال چک خوان باز گردیم، ما الگوریتم جلو رونده را بر روی دو ترکیب گراف اعمال می کنیم و مقدار انرژی را در آخرین رأس به وسیله فرمول لگارتیم جمع نمایی بدست می آوریم. تفاوت میان مقادیر این انرژی، خطای negative log-likelihood است.

مقدار بدست آمده از طریق اعمال الگوریتم جلو رونده بر روی گراف ترکیب بین جواب درس و گراف بازشناسی، لگارتیم جمع نمایی جواب های درست است. در حالی که، مقدار لگارتیم جمع نمایی در آخرین رأس از گراف ترکیب بین گراف بازشناسی و گرامر، مقدار حاشیه سازی شده بر روی همه تفاسیر های ممکن معتبر است.

<!--
# Lagrangian formulation of Backpropagation
For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.

The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).

To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.

- For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.

This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.

In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.
-->

# فرمول بندی لاگرانژ پس انتشار
برای ورودی $x$ و خروجی هدف $y$، ما می توانیم یک شبکه را به عنوان مجموعه ای از توابع فرمول بندی کنیم، $f_k$ و وزنها، $w_k$، به طوری که قدم های بعدی در شبکه خروجی $z_k$ را با $z_{k+1} = f_k(z_k, w_k)$ خروجی دهند. در حالت با ناظر، هدف شبکه این است که $C(z_n, y)$ را کمینه کند که هزینه خروجی $n$ ام شبکه نسبت به داده صحت سنجی شده است. این برابر است با کمینه کردن $C(z_n, y)$ نسبت به محدودیت های $z_{k+1} = f_k(z_k, w_k)$ و $z_0 = x$.

لاگرانژ را می توان به صورت زیر نوشت: $$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
که عبارت $ \lambda $ ضرایب لاگرانژ (رجوع کنید به [نوشته های آنلاین پاؤل](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) به عنوان یک تازه سازی اگر ریاضیات 3 مربوط به زمان دوری بوده است) هستند.

برای کمینه کردن $\mathcal{L}$، نیاز داریم تا مشتقات جزئی $\mathcal{L}$ را نسبت به هر یک از آرگمان هایش برابر با صفر قرار داده و حل کنیم.

- برای $\lambda$، ما به راحتی محدودیت را بدست می آوریم: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$
- برای $z_k$، $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$، که فقط یک فرمول استاندارد پس انتشار است.

این روش از لاگرانژ و همیلتون در زمینه مکانیک کلاسیک ریشه گرفته است، که کمینه سازی بر روی انرژی سیستم است و عبارت $\lambda$، محدودیت های فیزیکی سیستم را بیان می کند که برای نمونه، دو توپ مجبور به این باشند که در یک فاصله ثابت از هم قرار بگیرند که در نتیجه برای مثال، اتصال به وسیله یک نوار فلزی باشد.

در حالتی که ما نیاز داریم تا هزینه $C$ را در هر قدم زمانی کمینه کنیم، $k$، لاگرانژ به $$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$ تبدیل می شود.

<!--
# Neural Ordinary Differential Equation
Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).
-->

# معادلات دیفرانسیل معمولی عصبی
به وسیله این فرمول بندی از پس انتشار، حال می توانیم راجب یک کلاس جدید از مدلها صحبت کنیم، ODE های عصبی. اینها اساسا شبکه های بازگشتی ای هستند که حالت، $z$، در زمان $t$ به وسیله $ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $ داده شده است، که $ W$ بیانگر یک مجموعه از پارامترهای معین است. همچنین، می توان این موضوع را به صورت معادله دیفرانسیل معمولی (بدون مشتق جزئی) بیان کرد: $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

آموزش چنین شبکه ای به وسیله قرمول بندی لاگرانژ بسیار سر راست است. اگر ما هدف، $y$، را داشته باشیم و حالتی از سیستم را بخواهیم که به  $y$ تا زمان $T$ برسد، ما به راحتی تابع هزینه را به عنوان فاصله بین $z_T$ و $y$ برقرار می کنیم. هدف دیگر سیستم، پیدا کردن یک حالت پایدار از سیستم نیز می تواند باشد، به عبارت دیگر، از تغییر از یک نقطه مشخص به بعد دست می کشد. به صورت ریاضی، این با برقراری $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$ برابری می کند. در حالت کلی، پیدا کردن یک پاسخ $y$ به این معادله بسیار آسان تر از پس انتشار از درون زمان است.، زیرا شبکه نیازی ندارد تا گرادیان ها را نسبت به تمامی رشته به خاطر بسپارد و تنها نیاز دارد تا $f$ یا $\lvert f \rvert^2$ را کمینه کند. برای اطلاعات بیشتر درباره ی آموزش یک ODE عصبی تا به یک نقطه خاص برسد، [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf) را ببینید.


<!--
# Variational Inference in terms of Energy

## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.

We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
-->

## استنتاج متغیر بر حسب انرژی

## مقدمه
برای یک تابع انرژی مقدماتی $E(x,y,z)$، اگر می خواهیم تا بر روی یک متغییر z حاشیه سازی کنیم تا یک خطا بر حسب فقط $x$ و $y$ بدست آوریم، $L(x,y)$، ما باید

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

را محاسبه کنیم. حال اگر در $\frac{q(z)}{q(z)}$ ضرب کنیم،

$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

بدست می آید.

اگر فرض کنیم که $q(z)$ یک توضیع احتمالی بر روی $z$ باشد، می توانیم انتگرال تابع خطای بازنویسی شده خودمان را به عنوان مقدار امید ریاضی، نسبت به توضیع $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$، تفسیر کنیم.

ما از این تفسیر، نابرابری ینسن و تقریب مبتنی بر نمونه برداری استفاده می کنیم تا به صورت نا مستقیم، تابع هزینه خودمان را کمینه کنیم.

<!--
## Jensen's Inequality

Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.
-->

## نابرابری ینسن

نابرابری ینسن یک مشاهده ریاضی است که بیان می کند: اگر ما یک تابع محدب داشته باشیم، آنگاه *امید ریاضی* آن تابع بر روی یک بازه، کمتر از میانگین تابع که در نقاط ابتدایی و انتهایی بازه ارزیابی شده است، خواهد بود. در نمایش به صورت هندسی، این بسیار مشهود است:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>شکل 6:</b> نابرابری ینسن (گرفته شده از [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

به صورت مشابه، اگر $F$ محدب باشد، برای یک توضیع احتمال معین $q$، ما از نابرابری ینسن بر روی بازه $z$، می توانیم استنتاج کنیم.

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

حال، به خاطر بیاورید که مقدار حاشیه سازی شده  $L(x,y)$ بعد از ضرب با $\frac{q(z)}{q(z)}$ برابر است با،
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

اگر ما $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$ را در نظر بگیریم، از نابرابری ینسن $(1)$ می دانیم که،

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

حال بیاید به کار با این، برای یک تابع خطای محدب ملموس $F(x) = -\log(x)$، ادامه دهیم

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

عالی! حال ما یک حاشیه بالا برای تابع خطای خودمان $L(x,y)$، مرکب از دو عبارت که ما آنرا می توانیم درک کنیم. عبارت اول $\int_z q(z)E(x,y,z)$ مقدار *متوسط* انرژی است. و عبارت دوم $\frac{1}{\beta}\int_z\log(q(z))$، فقط یک فاکتور ($-\frac{1}{\beta}$) ضرب در *آنتروپی* توضیع $q$ است.

<!--
## What's the point?

We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!

To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.

The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.

Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$.
-->

## هدف چیست؟

ما حالا  یک حاشیه بالا را به صورتی که بتوان از انتگرال های پیچیده دوری کرد، فرمول بندی کرده ایم و به سادگی به جای آن،  این مقادیر را به وسیله نمونه برداری از یک توضیع جانشین ($q(z)$)، به انتخاب خودمان، تقریب می زنیم!

برای دست یابی به مقدار عبارت اول از تابع حاشیه بالا، ما تنها از آن توضیع نمونه برداری می کنیم و مقدار میانگین $L$ را که ما با اعمال بر $z$ های نمونه برداری شده، بدست می آورده ایم، محاسبه می کنیم.

عبارت دوم (یک فاکتور از آنتروپی) تنها یک خصوصیت از خانواده توضیع است و مانند قبل می تواند از طریق نمونه برداری تصادفی از $q$، تقریب زده شود.

در انتها، ما می توانیم $L$ را نسبت به پارامترهایش (مثلا وزنهای شبکه $W$) کمینه کنیم به این طریق که این تابع $L$ را که از بالا محدود است را کمینه کنیم. ما این کمینه سازی را با به روز رسانی دو متغییرمان هدایت می کنیم: (1) آنتروپی $q$، (2) پارامترهای مدل $W$


<!--
## Summary
This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about.
-->

## خلاصه
این "نمای انرژی" از استنتاج متغیر است. اگر نیاز دارید تا لگارتیم مجموع نمایی ها را محاسبه کنید، آن را با مقدار میانگین تابعتان به اضافه یک عبارت آنتروپی جایگزین کنید. این به ما یک حاشیه بالا می دهد. حال ما این حاشیه بالا را کمینه سازی می کنیم و با اینکار در نتیجه، ما تابع ای که برایمان اهمیت دارد را کمینه می کنیم.
