---
lang-ref: ch.14-1
lecturer: Yann LeCun
title: یادگیری عمیق برای پیش بینی ساخت یافته
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
lang: fa
translation-date: 27 Sep 2020
translator: Nikan Doosti Lakhani
---

<!--
## Structured Prediction

It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values.
For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain.
-->

## پیش بینی ساخت یافته
این مسئله پیش بینی متغیر y برای یک ورودی داده شده x است که به جای مقدار اسکالر گسسته یا حقیقی، به طور دو به دو مستقل و محدود شده است. متغییر خروجی به یک دسته خاص تعلق ندارد ولی می تواند نمایی یا بی نهایت مقدار داشته باشد.
برای نمونه، در مورد بازشناسی گفتار/نوشتار و یا ترجمه زبان طبیعی، خروجی باید از لحاظ گرامری دست بوده و این امکان وجود ندارد که بتوان تعداد احتمالات خروجی را محدود کرد. وظیفه مدل این است که ساختار ترکیبی، مکانی یا رشته ای درون دامنه مسئله را بدست آورد.

<!--
### Early works on structured prediction
This vector is fed to a TDNN which gives a feature vector which in case of model systems can be compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used.

The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center>

This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance.

To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every incorrect answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients.
-->

### کارهای مقدماتی پیش بینی ساخت یافته
این بردار به یک TDNN که یک بردار ویژگی که در مورد سیستم های مدل می تواند با softmax مقایسه شود را می دهد که بیانگر یک گروه است. مشکلی که رخ میدهد این است که در حالت بازشناسی کلمه که تلفظ شده است ، افراد متفاوت می توانند همان کلمه را به روش ها و سرعت های مختلف تلفظ کنند. برای حل این مشکل، تاب دهی زمان هوشمند مورد استفاده قرار گرفته است.

ایده به این صورت است که برای سیستم یک مجموعه از قالب های آماده از پیش ضبط شده را که با رشته یا بردار ویژگی ای که توسط شخصی ضبظ شده است متناظر باشد، فراهم می آوریم. شبکه عصبی همزمان با قالب آماده آموزش داده می شود تا سیستم بازشناسی کلمه را برای تلفظ های متفاوت بتواند یاد بگیرد. متغییر latent این امکان را به ما می دهد تا بردار ویژگی را تاب دهی زمانی کنیم تا با طول قالب آماده تناسب پیدا کند.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
شکل 1.
</center>

این می تواند با جابجایی بردارهای ویژگی از TDNN به صورت افقی و قالب آماده کلمات به صورت عمودی به صورت یک ماتریس به نمایش گذاشته شود. هر عنصر در ماتریس با فاصله بین بردارهای ویژگی متناظر است. این می تواند به صورت مسئله گراف به نمایش گذاشته شود که در آن هدف این است که از گوشه پایین سمت چپ شروع کرده و با گوشه بالا سمت راست به صورتی که مسیر طی شده فاصله را کمینه کند، برسیم.

برای آموزش این مدل متغییر latent ما نیاز داریم تا انرژی را برای پاسخ های درست تا حد امکان کوچک و برای پاسخ های نادرست تا حد امکان بزرگ کنیم. برای اینکار از تابع هدفی استفاده می کنیم که قالب های آماده کلمات نادرست را گرفته و آن ها را از رشته فعلی از ویژگی ها دور کرده و سپس گرادیان ها را پس انتشار می دهد.


<!--
## Energy based factor graphs

The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The benefit of these models is that efficient inference algorithms can be employed.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center>
-->

## گراف فاکتور مبتی بر انرژی
ایده به این صورت است که یک مدل مبتنی براانرژی بسازیم که در آن انرژی، جمع ترم های انرژی جزئی یا وقتی که احتمال، ضرب فاکتورها باشد، است. مزیت این مدل ها این است که الگوریتم های استنتاج بهینه ای می تواند در اختیار گرفته شود.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
شکل 2.
</center>

<!--
### Sequence Labeling

The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center>

In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels.
-->

### برچسب زنی رشته ها
مدل یک سیگنال گفتار ورودی X را گرفته و لیبل های Y را خروجی می دهد به طوری که لیبل های خروجی، مجموع ترم های انرژی را کمینه کنند.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
شکل 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
شکل 4.
</center>

در این حالت، انرژی مجموع سه ترم که به وسیله مربع های آبی نمایش داده شده اند است که شبکه های عصبی هستند که برای متغییر های ورودی، بردار های ویژگی تولید می کنند. در مورد مسئله بازیابی گفتار، X می تواند به صورت سیگنال گفتار در نظر گرفته شود  و مربع ها محدودیت های گرامری را پیاده سازی و Y لیبل های خروجی تولید شده را بیان می کند.

<!--
## Efficient Inference for Energy-Based Factor Graphs

A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):

Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center>

A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding:

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations).

However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence,
there is no need for more than $2 + 4 + 4 + 6 = 16$ single factor evaluations.

Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom).

The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general.

To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$.


The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure.

However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent[? or decent] algorithm such as simulated annealing could be used.
-->

## استنتاج بهینه برای فاکتور گراف های مبتنی بر انرژی،
آموزشی بر آموزش مبتی بر انرژی (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):

آموزش و استنتاج در مدل های مبتنی بر انرژی شامل یک کمینه سازی انرژی بر روی یک مجموعه از پاسخ ها $\mathcal{Y}$ و متغییر latent $\mathcal{Z}$ است. زمانی که کاردینالیتی $\mathcal{Y}\times \mathcal{Z}$ بزرگ است، این کمینه سازی ممکن است قابل دست یابی نباشد. یک راه حل برای این مشکل این است که ساختار تابع انرژی را مورد بهره جویی قرار داده تا بتوان استنتاج را به صورت بهینه انجام داد. یکی از مواردی که در آن می توان از ساختار بهره جویی جست، زمانی است که در آن انرژی قابلیت بیان شدن توسط مجموع توابعی (فاکتورها) که هر یک تنها به زیرمجموعه ای از متغییر ها در Y و Z بستگی دارند را داشته باشد. این وابستگی ها به بهترین شکل قابلیت بیان شدن در فاکتور گراف ها را دارا دارند. فاکتور گراف ها یک حالت عمومی از مدل های گرافی یا شبکه های باور هستند.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
شکل 5.
</center>

یک نمونه ساده از یک فاکتور گراف در شکل 19 (بالا) نمایش داده شده است. تابع انرژی جمع چهار فاکتور است:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

که  $Y = [Y_1, Y_2]$ متغییر های خروجی و $Z = [Z_1, Z_2]$ متغییر های latent هستند. هر فاکتور را میتوان به صورت بازنمایش محدودیت های نرم بین مقادیر متغییر های ورودی اش دید. مسئله استنتاج شامل یافتن:

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

فرض کنید که $Z_1$،  $Z_2$ و $Y_1$ متغیر های باینری گسسته هستند و $Y_2$ یک متغییر سه-مقداری است. کاردینالیتی دامنه $X$ مهم نخواهد بود زیرا X همیشه مشاهده شده است. تعداد کانفیگ های محتمل برای $Z$ و $Y$ به ازای داشتن X برابر است با $2 \times 2 \times 2 \times 3 = 24$. یک روش ساده کمینه سازی، از طریق جستجوی کامل می تواند تمامی تابع انرژی را 24 بار (96 اعتبار سنجی تک فاکتوری) اعتبار سنجی کند.

اگرچه، متوجه میشم که در ازای داشتن $X$، $E_a$ تنها دو کانفیگ ورودی دارد: $Z_1 = 0$ و $Z_1 = 1$. به طور مشابه، $E_b$ و $E_c$ تنها 4 کانفیگ ورودی و $E_d$ 6 حالت را دارا می باشند. در نتیجه، احتیاجی به اعتبار سنجی تک فاکتوری بیشتر از $2 + 4 + 4 + 6 = 16$ نیست.

بنابراین، ما می توانیم 16 مقدار فاکتور  را پیش محاسبه و آنها برو روی یال ها در یک مشبک همانند شکل 19 (پایین) قرار دهیم.

رأس ها در هر ستون مقادیر ممکن برای یک متغییر تنها را بیان می کنند. هر یال به وسیله انرژی خروجی فاکتور برای مقادیر متناظر متغییر ورودی اش، وزن دهی می شوند. با این روش بیان، یه مسیر تنها از رأس شروع تا به رأس پایان بیانگر یک کانفیگ محتمل از تمام متغییر ها خواهد بود. مجموع وزن ها در طول یک مسیر برابر است با مجموع انرژی برای کانفیگ متناظر با آن. بنابراین، در نتیجه مسئله استنتاج می تواند به جستجو برای یافتن **کوتاه ترین مسیر** در گراف کاهش پیدا کند. این می تواند به وسیله روش های برنامه نویسی پویا نظیر الگوریتم Viterbi و یا A\* حل شود. هزنیه متناسب است با تعداد یال ها که به صورت نمایی کوچک تر از تعداد مسیر ها در حالت کلی است.

برای محاسبه $E(Y, X) = \min_{z\in Z} E(Y, z, X)$، ما روش یکسانی را به کار می گیریم، ولی گراف را به زیرمجموعه از یال ها محدود می کنیم که با مقدار از پیش تعیین شده $Y$ تناسب داشته باشد.

روش بالا گاهی با عنوان الگوریتم min-sum نامگذاری می شود و این نسخه لگاریتمی دامنه ی روش سنتی max-product برای مدل های گرافی سنتی است. این روش به سادگی می تواند به گراف فاکتور ها عمومی سازی شود که فاکتور ها بیشتر از دو متغییر را به عنوان ورودی دریافت می کنند و یا فاکتور گراف هایی که به جای ساختار زنجیری، ساختار درختی دارند.

اگرچه، این فقط برای فاکتور گراف ها یی که درخت های دو-بخشی (بدون حلقه) هستند صادق است. وقتی که حلقه ها درون گراف حاضر هستند، الگوریتم min-sum ممکن است یک حل تخمینی وقتی که به صورت گردشی به کار گرفته می شود ارایه دهد و یا اصلا  همگرا نشود. در این حالت، یک الگوریتم بهتر نظیر تبرید شبیه سازی شده استفاده کرد.

<!--
## Simple Energy-Based Factor Graphs with “Shallow” Factors

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center>

The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about)

Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$

And then we can think about like what type of loss function. Here comes several different models.
-->

## فاکتور گراف های مبتنی بر انرژی ساده با فاکتور های "سطحی"

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
شکل 6.
</center>

فاکتور گراف نشان داده شده در شکل 20 یک فاکتور گراف دامنه لگاریتمی برای مدل های ساخت یافته خطی است ( در مورد " فاکتور گرفا های مبتنی بر انرژی ساده" صحبت می کنیم).

هر فاکتور یک تابع خطی از پارامترهای قابل آموزش است. این به ورودی $X$ و یک جفت از لیبل های $(Y_m, Y_n)$ بستگی دارد. در حالت کلی، هر فاکتور می تواند به بیشتر از دو لیبل تنها بستگی داشته باشد، ولی ما مبحث را به فاکتور های جفت محودود می کنیم تا بتوانیم نماد گذاری ساده تری داشته باشیم:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

اینجا $\mathcal{F}$ بیانگر مجموعه فاکتورها (مجموعه ای از جفت لیبل های تنها که به صورت مستقیم وابستگی بینابینی دارند)، $W_{m n}$ بردار پارامتر برای فاکتور $(m, n),$ و $f_{m n}\left(X, Y_{m}،  Y_{n}\right)$ یک (ثابت) بردار ویژگی هستند. بردار پارامتر جهانی $W$ حاصل چسباندن همه ی $W_{m n}.$ است.

و سپس ما می توانیم راجب مسائلی نظیر چه تابع خطایی فکر کنیم. در اینجا برخی از مدل های متفاوت آورده شده است.


<!--
### Conditional Random Field

We can use the negative log-likelihood loss function to train a linear structured model.

This is the Conditional Random Field

The intuition is we want the energy of the correct answer to be low and want the log of exponential for all the answers, including the good one, to be large.

Below is the formal definition for the negative log-likelihood loss function:

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$
-->

### میدان تصادفی شرطی
ما می توانیم از تابع خطای negative log-likelihood  برای آموزش یک مدل ساخت یافته خطی استفاده کنیم.

این یک میدان تصادفی شرطی است

به صورت شهودی، ما می خواهیم که انرژی پاسخ های درست به پایین بوده و همچنین می خواهیم که لگاریتم نمایی برای همه پاسخ ها، شامل خوب ها نیز، بزرگ باشد.

رابطه پایین تعریف صوری برای تابع خطای negative log-likelihood است:

 $$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$


<!--
### Max Margin Markov Nets and Latent SVM

We can also using the Hinge loss function for optimization.

The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway.

This is the idea behind Max Margin Markov Nets and Latent SVM.
-->

### شبکه های مارکوف حداکثر-حاشیه و Latent SVM
ما همچنین می توانیم از تابع خطای Hinge برای بهینه سازی استفاده کنیم.

به صورت شهودی، ما می خواهیم که انرژی پاسخ های درست کم بوده و سپس در بین همه کانفیگ های ممکن از پاسخ های نادرست، ما به دنبال آنهایی هستیم که حداقل انرژی را میان همه اشتباه ها یا بدها دارا باشند. سپس، به دنبال آن هستیم که انرژی این را به بالا هل دهیم. ما نیازی نداریم که انرژی را برای سایر جواب های بد به بالا هل دهیم زیرا در هر حالت بزرگ تر هستند.

این ایده شبکه های مارکوف حداکثر-حاشیه و Latent SVM است.

<!--
### Structured Perceptron model

We can train the linear structured model by using perceptron loss.

Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP:

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

where $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ is the answer produced by the system.
-->

### مدل پرسپترون ساخت یافته

ما می توانیم مدل ساخت یافته خطی را به وسیله خطای پرسپترون آموزش دهیم.

Collins [Collins, 2000, Collins, 2002] استفاده از آن را برای مدل های ساخت یافته خطی در حوزه NLP مورد ستایش قرار داده است.

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

که $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ پاسخی است به وسیله سیستم تولید شده است.


<!--
#### Early trails on discriminative training for speech/handwritten recognition.

Minimum Empirical Error Loss (Ljolje, and Rabiner 1990):

By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use neural networks, and have other ways in turning speech signals into sound categories.
-->

#### نشانه های اولیه آموزش تفکیک کننده برای بازشناسی گفتار/نوشتار

تابع خطای حداقل خطای عملی (Ljolje, and Rabiner 1990):

با آموزش در سطح رشته، آنها به سیستم نمی گویند این صدا و آن مکان. آنها به سیستم داده رشته ورودی و رونویسی آن شامل کلمات را داده و از سیستم می خواهند تا آن را با تاب دهی زمانی درک کند. آنها از شبکه های عصبی استفاده نکردند و راه های دیگری برای تبدیل سیگنال های گفتار به دسته بندی صدا در اختیار داشتند.

<!--
## Graph Transformer Net

Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works.

We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center>

We run each through the same character recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird form of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center>

Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center>

So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path.

Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, neural net is regular and the Path Selector and Viterbi Transformer are basically switches that pick a particular edge or not.

So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set the gradient for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and will come back to this later. Then you can backpropagate gradient through the neural net. That will make the energy of the correct answer small.

What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of neural net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the situation where things like PyTorch are really important.

This phase of backpropagation make the energy of correct answer small. And there's going to be a second phase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discriminative training for structure prediction that use perceptual loss.

The first stages of phase two are exactly the same with the first phase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether this path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phase one, since the energy get here is the smallest among all possible paths.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figure 10.
</center>

Putting phase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perceptron loss.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figure 11.
</center>
-->

## شبکه مبدل گراف
اینجا مسئله این است که ما یک رشته از ارقام را در ورودی داریم و نمیدانیم که چطور قطعه بندی کنیم. کاری که می توانیم کنیم این است که یک گراف بسازیم که در آن هر مسیر یک راه برای شکستن رشته کاراکترها است، و ما به دنبال پیدا کردن مسیری هستیم که کمترین انرژی را داشته باشد، به طور پایه ای، به دنبال کوتاه ترین مسیر هستیم. اینجا یک مثال منسجم از نحوه عملکرد آورده شده است.

ما تصویر ورودی 34 را داریم. این را از درون قطعه بند عبور داده و چندین قطع بندی جایگزین بدست می آید. این قطعه بندی ها رو هایی هستند که می توان این قطعه ها را در کنار یکدیگر گروه بندی کرد. هر مسیر در گراف قطعه بندی متناظر است با یک روش خاص از گروه بندی این قطع های جوهر.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
شکل 7.
</center>

ما هر یک را از درون یک ConvNet بازشناسی کاراکتر یکسان عبور می دهیم و یک لیست از 10 نمره به دست می آوریم (دو در اینجا ولی اصولا باید 10 باشد، بیانگر 10 دسته). برای نمونه، 1 [0.1] به این معنی است که انرژی برای دسته 1 برابر با 0.1 است. خوب، در اینجا یک گراف بدست می آوریم و شما می توانید به آن به عنوان یک فرم عجیب از تنسور نگاه کنید. این در واقع یک تنسور اسپارس است. این یک تنسور است که برای هر کانفیگ ممکن از این متغییر، هزینه آن را به ما می گوید. بیشتر شبیه یک توضیع روی تنسورها یا لگاریتم توضیع، زیرا ما درباره ی انرژی صحبت می کنیم.

 <center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
شکل 8.
</center>

این گراف را گرفته سپس می خواهم مقدار انرژی پاسخ درست را محاسبه کنم. من به شما می گویم که پاسخ درست 34 است. از میان آن مسیرها آنهایی را پیدا کن که می گوید 34. دو مورد از آنها وجود دارد، یکی با انرژی 3.4 + 2.4 = 5.8، و دیگری 0.1 + 0.6 = 0.7. مسیر با انرژی کمتر را انتخاب کن. اینجا ما مسیر با انرژی 0.7 را می گیریم.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
شکل 9.
</center>

در نتیجه یافتن مسیر شبیه کمینه سازی متغیر latent وقتی که متغیر latent همان مسیری است که شما انتخاب می کنید.
به طور مفهومی، این یک مدل انرژی با متغیر latent به عنوان یک مسیر است.

حال ما انرژی مسیر درست را داریم، 0.7. کاری که حال نیاز داریم این است که گرادیان ها را از درون همه ساختار پس انتشار دهیم تا بتوانیم وزن ها را در ConvNet به گونه ای تغییر دهیم که انرژی نهایی کم شود. به نظر کاری بسیار پیچیده اما کاملا شدنی است. زیرا تمام این سیستم از المان هایی ساخته شده که ما در حال حاظر از آنها اطلاع داریم، شبکه عصبی معمولی است و انتخاب کننده مسیر و مبدل Viterbi اساسا سوییچ هایی هستند که لبه خاصی را انتخاب می کنند و یا نه.

حال چطور پس انتشار را انجام می دهیم؟ خوب، نقطه 0.7 حاصل جمع 0.1 و 0.6 است. در نتیجه هر دو نقطه 0.1 و 0.6 گرادیان +1 خواهند داشت که آنها را در براکت ها نمایش داده ایم. سپس مبدل Viterbi فقط یک مسیر از دو مسیر ممکن را انتخاب می کند. در نتیجه تنها گرادیان ها را برای لبه های متناظر در ورودی گراف کپی کرده و گرادیان سایر مسیرهایی که انتخاب نشده اند را برابر با صفر قرار دهید. این دقیقا همان چیزی است که در Max-Pooling و یا Mean-Pooling رخ می دهد. انتخاب کننده مسیر نیز همین گونه است، این فقط سیستمی است که جواب درست را انتخاب می کند. توجه کنید که در این مرحله 3 [0.1] (0) در گراف باید 3 [0.1] (1) باشد و به این موضوع بعدا باز خواهیم گشت. حال شما می توانید گرادیان ها را از درون شبکه پس انتشار دهید. اینکار انرژی پاسخ صحیح را کوچک خواهد کرد.

چیزی که اینجا مهم است این است که این ساختار به صورتی پویاست که اگر من به شما یک ورودی جدید بدهم، تعداد نمونه های شبکه عصبی متناسب با تعداد قطعه بندی تغییر خواهد کرد، و همچنین گراف های بدست آمده نیز تغییر خواهند کرد. ما نیاز داریم که از درون این ساختار پویا، پس انتشار را انجام دهیم. این حالت شرایطی است که چیزهایی نظیر PyTorch بسیار مهم هستند. 

این فاز از پس انتشار انرژی پاسخ های درست را کاهش خواهد داد. و فاز دومی وجود خواهد داشت که در آن ما انرژی مربوط به جواب های نادرست را بزرگ خواهیم کرد. در این حالت، ما اجازه می دهیم سیستم هر جوابی که خودش می خواهد را بردارد. این یک فرم ساده شده از یادگیری تفکیک کننده برای پیش بینی ساختار است که از خطای ادراکی استفاده می کنیم.

مراحل اولیه فاز دوم دقیقا همانند فاز اول هستند. مبدل Viterbi اینجا بهترین مسیر با کمترین انرژی را انتخاب می کند و در این مرحله ما اهمیتی نمی دهیم که این مسیر درست است یا خیر. انرژی ای که اینجا می گیرید کوچک تر یا برابر با آنچه از فاز یک می گیرید خواهد بود، زیرا انرژی ای که به اینجا می رسد از همه مسیر های ممکن کوچک تر است.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
شکل 10.
</center>

حال فاز اول و دوم را کنار هم قرار می دهیم. تابع خطا باید energy1 - energy2 باشد. از قبل، ما نحوه پس انتشار از میان پخش سمت چپ را معرفی کردیم، و حالا در واقع می خواهیم که از درون تمام ساختار پس انتشار را انجام دهیم. هر مسیری که در سمت چپ باشد +1 خواهد گرفت و هر مسیری که در سمت راست باشد -1. در نتیجه 3 [0.1] در هر دو مسیر نمایان شده، در نتیجه باید گرادیان 0 بگیرد. اگر اینکار را انجام دهیم، سیستم در نهایت تفاوت میان انرژی پاسخ های صحیح و انرژی بهترین پاسخ، هر چه که باشد را کمینه می کند. تابع خطا در اینجا خطای پرسپترون است.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
شکل 11.
</center>


<!--
## Comprehension Questions and Answers


#### Question1: Why is inference easy in the case of energy-based factor graphs?

Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead.


#### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm?

We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference.


#### Question3: Are the NN boxes refering to seperate ConvNets?

They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network.
-->

## سوالات و پاسخ های مفهومی،

#### سوال 1: چرا استنتاج در حالت فاکتور گراف های مبتنی بر انرژی ساده است؟

استنتاج در حالت مدل های مبتنی بر انرژی با متغیر latent، شامل استفاده از روش های فراگیر نظیر گرادیان کاهشی برای کمینه کردن انرژی است اگرچه از آنجا که انرژی در این حالت، حاصل جمع فاکتورهاست، تکنیک هایی نظیر برنامه نویسی پویا می تواند مورد استفاده قرار گیرد.

#### سوال 2: اگر متغیر پنهان در فاکتور گراف ها متغییر های پیوسته باشند، چه رخ می دهد؟ آیا همچنان می توانیم از الگوریتم min-sum استفاده کنیم؟

نمی توانیم، زیر نمی توانیم برای همه ترکیب های ممکن برای همه مقادیر فاکتور به جستجو بپردازیم. اگرچه، در این حالت، انرژی ها به ما برتری خواهند داد، زیرا می توانیم بهینه سازی مستقل انجام دهیم. مثلا ترکیب  $Z_1$ و $Z_2$ فقط $E_b$ را در شکل 19 تحت تاثیر قرار می دهد. ما می توانیم بهینه سازی مستقل و برنامه نویسی پویا را برای استنتاج استفاده کنیم.

#### سوال 3: آیا جعبه های NN به ConvNet های جداگانه ای اشاره دارند؟

آنها مشترک هستند. آنها چندین کپی از یک ConvNet هستند. این تنها یک شبکه بازشناسی کاراکتر است.
