---
lang-ref: ch.13-1
lang: fa
title: شبکه های کانولوشنی گرافی
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
translation-date: 23 Sep 2020
translator: Zhabiz Gharibshah
---

<!--
## [Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)
-->
## [شبکه های عصبی کانولوشنی سنتی(CovNets)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)

<!--
ConvNets are powerful architectures to solve high-dimensional learning problems.
-->
شبکه های عصبی کانولوشنی سنتی از معماری قدرتمند برای حل مسایل یادگیری ماشینی با دامنه ورودی با ابعاد بالا برخوردار هستند.

<!--### What is the Curse of Dimensionality?
-->
### نفرین بعدیت چیست؟

<!--
Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10}^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example.
-->
یک عکس با ابعاد 1024 در 1024 پیکسلی را در نظر بگیرید. این عکس را می توان نقطه ای در فضا در نظر گرفت که با یک میلیون بعد توصیف می شود. استفاده از 10 نمونه از این عکس ها از نظر بعد اندازه ای برابر با ${10}^{1,000,000}$ دارند که شدیدا عددی بزرگ می باشد. CovNets شبکه های عصبی بسیار قدرتمندی هستند که قادر به استخراج بهترین نمایش از داده های تصویری با ابعاد بالا همانند مثال ارایه شده هستند. 

- dim(image) = **1024 x 1024** = ${10}^{6}$
- برای **N = 10** نمونه/دامنه --> **${10}^{1,000,000}$ نقطه**

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<!--
<b>Fig. 1</b>: ConvNets extract representation of high-dimensional image data.
-->
<b>شکل 1:</b>شبکه های CovNets نمایشی از داده های تصویری با ابعاد بالا را استخراج می کنند.
</center>

<!--
### Main assumptions about ConvNets:
-->
### فرضیات اصلی درباره CovNets

<!--
 **1. Data (images, videos, speech) is compositional.**
-->

 **1. داده (تصاویر، ویدیو، گفتار صوتی) دارای ساختار مرکب هستند**

<!--
It is formed of patterns that are:
-->
داده ها از مجموعه ای از الگوها تشکیل شده اند:

<!--* **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.-->
* **محلی**  یک نرون در شبکه عصبی بجای اتصال به تمامی لایه ها در شبکه تنها به لایه های همسایه متصل است
<!--* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.-->
* **ساکن** الگوها دارای شباهت هستند و در دامنه تصویر تکرار شده اند. مثال این موضوع حضور ملافه زرد در میانه شکل 2 است.
<!--* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation.-->
* **سلسله مراتبی** ترکیب ویژگیهای مرتبه پایین ویژگی های مرتبه متو سط را تشکیل می  دهند. سپس ترکیب این ویژگیهای مرتبه متوسط به صورت ادامه دار ویژگیهای مرتبه های بالاتر را تشکیل می دهد.مثال نمایش تصویرگرا

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<!--<b>Fig. 2</b>: Data is compositional.-->
<b>شکل 2:</b>داده ها ساختار مرکب دارند.
</center>

<!--**2. ConvNets leverage the compositionality structure.**-->
**2. شبکه های عصبی کانولوشنی از ساختار ترکیب بندی سود می برند.**

<!--They extract compositional features and feed them to classifier, recommender, etc.-->
آنها ویژگیهای مرکب را استخراج می کنند تا به عنوان ورودی در اختیار سیستم طبقه بندی کننده ها یا پیشنهاد دهنده ها قرار دهند.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<!--<b>Fig. 3</b>: ConvNets leverage the compositionality structure.-->
<b>شکل 3:</b> شبکه های عصبی کانولوشنی از ساختار ترکیب بندی سود می برند.
</center>

<!--# Graph Domain-->
## حوزه گراف

<!--### Data Domain-->
### حوزه داده

<!--* Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values.-->
* تصاویر، حجم ها و ویدیوها در فضای اقلیدسی دو بعدی، سه بعدی ، دوبعدی +1 قرار می گیرند. هر پیکسل با برداری از رنگ های قرمز، سبز و آبی نشان داده می شود.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<!--<b>Fig. 4</b>: Images have multiple dimensions.-->
<b>شکل 4:</b>تصاویر دارای چندین بعد می باشند.
</center>


<!--* Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer.-->
* جملات، کلمات، گفتار در یک فضای یک بعدی قرار می گیرند. به عنوان مثال هر حرف می تواند با یک عدد نمایش داده شود.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <!--<b>Fig. 5</b>: Sequences have single dimension.-->
  <b>شکل 5:</b>دنباله ها دارای یک بعد می باشند.
  </center>


<!--* These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined.-->
* این دامنه ها دارای ساختار منظم فضایی هستند که شرایط را برای اجرای عملیات  توسط شبکه های عصبی کانولوشنی به صورت سریع و با فرمولاسیون ریاضی به خوبی تعریف شده، فراهم می آورند.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <!--<b>Fig. 6</b>: Speech data has 1D grid.-->
  <b>شکل 6:</b>داده گفتاری در شبکه اقلیدسی یک بعدی قرار می گیرد.
  </center>


<!--### Graph Domain-->
### حوزه گراف

<!--#### Motivational Examples of graph domains-->
#### مثال های انگیزشی از حوزه های گراف

<!--Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos.-->
یک شبکه اجتماعی را در نظر بگیرید. یک شبکه اجتماعی با یک نمایش گرافی به طرز عالی توصیف می شود چون پیوند های دو به دو بین کاربران در شبکه ساختار مشبک ندارند. گره ها در گراف نمایش دهنده کاربران در شبکه اجتماعی هستند در حالی که یال ها بین گره ها اتصال بین گره ها نمایش می دهند. هر کاربر یک ماتریس سه یعدی از ویژگی ها دارد که شامل پیغام ها، تصاویر و ویدیوها می باشند.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<!--<b>Fig. 7</b>: Social networks by graph representation.-->
<b>شکل 7:</b>نمایش گرافی از شبکه اجتماعی.
</center>

<!--The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest.-->
اتصال بین ساختار و کارکرد مغز برای پیش بینی بیماری های ژنتیکی یک مثال انگیزشی قابل ملاحظه می باشد. همانطور که در پایین دیده می شود، مغز از مجموعه ای از ناحیه های علاقه (ROI) تشکیل شده است. این ناحیه های علاقه فقط به صورت محلی به تعدادی از ناحیه های علاقه پیرامونی متصل هستند. ماتریس همسایگی درجه قدرت بین نواحی علاقه را نمایش می دهد.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<!--<b>Fig. 8</b>: Brain connectivity by graph representation.-->
<b>شکل 7:</b>نمایش گرافی از قابلیت اتصال در مغز.
</center>


<!--Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc.-->
شیمی کوانتم همچنین یک نمایش جالب توجه حوزه گرافیکی ارایه می کند. هر اتم با یک گره در گراف نشان داده می شود که از طریق پیوند ها و به وسیله یال ها به سایر اتم ها متصل می باشد. هریک از این اتم ها یا مولکول ها ویژگیهای مختلفی دارند شامل تخلیه بار مرتبط یا نوع پیوند و غیره.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<!--<b>Fig. 9</b>: Quantum chemistry by graph representation.-->
<b>شکل 9:</b>نمایش گرافی از شیمی کوانتم.
</center>


<!--### Graph Definition and Characteristics-->
### تعریف و خصوصیات گراف

<!--* Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A**-->
	
* گراف G به صورت زیر تعریف می شود:
    * **گره ها V**
    * **یال ها E**
    * **ماتریس همسایگی A**	


<!--* Graph features:
    * **Node features: $h_{i}$, $h_{j}$** (atom type)
    * **Edge features: $e_{ij}$** (bond type)
    * **Graph features:** g (molecule energy)-->
	
* ویژگیهای گراف:
    * **ویژگیهای گره: $h_{i}$, $h_{j}$** (نوع اتم)
    * **ویژگیهای یال: $e_{ij}$** (نوع پیوند)
    * **ویژگیهای گراف:** g (انرژی مولکول)	

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<!--<b>Fig. 10</b>: Graph.-->
<b>شکل 10:</b>گراف.
</center>




<!--## [Convolution of Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)-->
## [کانولوشن در شبکه عصبی کانولوشنی سنتی](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)

<!--### Convolution-->
### کانولوشن

<!--We abstractly define convolution as:-->
ما به صورت انتزاعی کانولوشن به صورت زیر تعریف می کنیم:

$$h^{\ell+l} = w^\ell * h^\ell,$$
<!--where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.-->
که $h^{\ell+1}$ برابر است با $n_1\times n_2\times d$-بعدی, $w^\ell$ برابر است با $3\times 3\times d$-بعدی, و $h^\ell$ برابر است با $n_1\times n_2\times d$-بعدی.
<!--For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (*e.g.*, 3 for a colored image).\\-->
به عنوان مثال $n_1$ و $n_2$ می تواند تعداد پیکسل ها در جهت های $x$ و $y$ یک تصویر باشد, و $d$ برابر با بعد هر پیکسل می باشد (*مثال:*, 3 برای یک تصویر رنگی).\\
<!--So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\-->
بنابرین $h^{\ell+1}$ برابر با یک ویژگی در لایه داخلی(پنهان) $(\ell+1)$ ام است که با اعمال کانولوشن $w^\ell$ به ویژگی در لایه $\ell$ ام بدست می آید.\\
<!--Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\-->
به طور معمول کرنل دارای ساختار کوچکی می باشد که برای نمایش میدان دریافت محلی استفاده می شود -- در مثال اینجا $3\times 3$, یا $5\times 5$.\\
<!--Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\-->
نکته: ما از لایه گذاری برای اطمینان از برابری بعد $h^{\ell+1}$ و آنهایی که دارای بعد $h^\ell$ هستند استفاده می کنیم .\\

<!--For example, in this image, the kernel may be used to recognize lines.-->
برای مثال در این تصویر، کرنل ممکن است برای تشخیص خطوط در تصویر استفاده شود.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<!--<b>Fig. 11</b>: Kernel can be used to recognize lines in images.-->
<b>شکل 11:</b>کرنل برای تشخیص خطوط در تصاویر می تواند استفاده شود.
</center>

<!--### How do we define convolution?-->
### چگونه کانولوشن تعریف می شود؟

<!--More exactly, convolution is defined as follows:-->
به صورت مشخص، کانولوشن به شکلی که در ادامه می اید تعریف می شود.

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

<!--The above defines convolution as *template matching*.\\-->
تعریف بالا کانولوشن را به عنوان *تطبیق قالب* معرفی می نماید.\\
<!--We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching.-->
ما به طور معمول از $h_{i+j}$ بجای $h_{i-j}$ استفاده می کنیم, چون عبارت اول در واقع کانولوشن می باشد که خیلی شباهت با تطبیق الگو دارد.

<!--However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning.-->
با این وجود، استفاده از عبارت اول یا دوم تفاوت عمده ای ایجاد نمی کنند، دلیل این موضوع این است که کرنل در واقع وارونه شده است و در نتیجه ی پروسه یادگیری در سیستم تغییری مشهود ایجاد نمی کند.

<!--In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$.-->
در خط سوم, ما تنها عبارت $h_{i+j}^\ell$ را به صورت $h_{ij}^\ell$ می نویسیم.

<!--The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line.-->
کرنل خیلی کوچک است، بنابرین بجای انجام عمل جمع در کل تصویر، مطابق خط دوم، ما در واقع عمل جمع را در همسایگی سلول $i$ ام انجام می دهیم، $\mathcal{N}_i$ ، همانطور که در خط سوم نشان داده شده است.

<!--This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image.-->
این موجب می شود که پیچیدگی محاسباتی عمل کانولوشن برابر با $O(n)$ می باشد، که در اینجا $n$ برابر با تعداد پیکسل های داخل تصویر می باشد.

<!--Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids.-->
کانولوشن برای هر مجموعه $n$ پیکسل در تصویر در نظر گرفته شده است، با محاسبه جمع روی ضرب داخلی برداری با بعد $d$ روی ساختار مشبک ابعاد $3\times 3$.

<!--The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels.-->
در این حالت پیچیدگی محاسباتی برابر با $n\cdot 3\cdot 3\cdot d$ محاسبه می شود, که برابر یا $O(n)$ می باشد;  در ضمن برای موازی سازی می توان GPU ها برای هر محاسبه کانولوشن برای هر $n$ پیکسل می توان بهره برد.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<!--<b>Fig. 12</b>: Nodes are ordered in the same way.-->
<b>شکل 12:</b>نود ها به صورت مشابه مرتب شده هستند.
</center>

<!--If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.-->
اگر گرافی که در حال اجرا کانولوشن بر روی آن هستیم یک شبکه مشبک باشد، مشابه اعمال روش استاندارد کانولوشن بر روی تصاویر در بینایی ماشینی، نود ها به صورت نشان داده شده در تصویر شکل بالا مرتب شده می باشند.
<!--Therefore, $j_3$ will always be in the top right corner of the pattern.-->
بنابرین, در این حالت $j_3$ همیشه در گوشه بالایی سمت راست الگو خواهد بود.

<!--So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.-->
بنابرین برای همه نودهای $i$ در تصویر زیر, از جمله $i$ و $i'$, مرتب سازی نود ها در کرنل همیشه یکسان می باشد.
<!--For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.-->
برای مثال, شما همیشه $j_3$ در گوشه راست بالای الگو را با گوشه سمت راست تکه تصویر مقایسه می کنیم (آنچه که برای اجرای کانولوشن برای پیکسل $i$ استفاده می کنیم), همانطور که به صورت زیر نشان داده شده است.
<!--Mathematically speaking:-->
به زبان ریاضی:

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

<!--and-->
و

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

<!--are always for the top right corner between the template and the image patches.-->
همیشه برای گوشه راست بالا بین قالب و تکه تصویر می باشد.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<!--<b>Fig. 13</b>: Image patches match the templates.-->
<b>شکل 13:</b>تکه های تصویر با قالب ها تطبیق داده می شوند.
</center>


<!--### Can we extend template matching for graphs?-->
### چگونه می توانیم تطبیق قالب در تصاویر را به گراف گسترش دهیم؟

<!--We have a couple of issues:-->
برای انجام این امر ما با چندین مشکل مواجه هستیم:
<!--1. First, in a graph, there is no ordering of the nodes.-->
1. نخست، در یک گراف هیچ ترتیبی بین نود ها وجود ندارد.

<!--So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.-->
بنابرین در قالبی که در تصویر زیر نشان داده شده است، گره $j_3$ مکان مشخصی ندارد، بلکه تنها یک نمایه دلخواه دارد.
<!--So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\-->
بنابرین, زمانی که برای تطبیق گره های $i$ و $i'$ در گراف زیر اقدام می کنیم, ما از تطبیق گره $j_3$  با گره های مشابه در هر دو کانولوشن ها اطلاع نداریم.\\
<!--This is because there is no notion of the *top right corner* of the graph.\\-->
دلیل این موضوع عدم وجود ایده *گوشه راست بالا* در گراف می باشد.\\
<!--There is no notion of up, down, left right.\\-->
چون مفاهیم بالا پایین چپ و راست در گرافها تعریف نمی شوند.\\
<!--Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above.-->
از این رو، عملا تطبیق قالب در گراف معنایی ندارد و ارایه تعریف تطبیق قالب همانند آنچه که در بالا ارایه شد، امکان پذیر نیست.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<!--<b>Fig. 14</b>: No node ordering in a graph.-->
<b>شکل 14:</b>مرتب سازی گره ها در گراف وجود ندارد.
</center>

<!--2. The second issue is that neighborhood sizes may be different.-->
2. مشکل دوم اندازه همسایگی ها می باشد دارای مقادیر متفاوتی می توانند باشند.

<!--So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.-->
بنابرین قالب $w^\ell$ که در زیر نشان داده شده است دارای 4 گره می باشد، اگرچه نود $i$ 7 گره در همسایگی خود دارد.
<!--How can we compare these two?-->
چگونه می توانیم این دو را مقایسه کنیم?

<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<!--<b>Fig. 15</b>: Different neighborhood sizes in a graph.-->
<b>شکل 15:</b>اندازه های همسایگی مختلف در یک گراف.
</center>

<!--## Graph Convolution-->
## کانولوشن گرافی

<!--We now use the **Convolution Theorem** to define convolution for graphs.-->
در این بخش ما از **تئوری کانولوشن** برای تعریف کانولوشن در گراف ها استفاده می کنیم.

<!--The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms:-->
در اینجا بر طبق **تئوری کانولوشن** تبدیل فوریه کانولوشن دو تابع که برابر با ضرب نقطه به نقطه تبدیل های فوریه می باشد به صورت زیر می باشد:

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

<!--In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT.-->
به طور کلی، تبدیل فوریه پیچیدگی محاسباتی برابر با $O(n^2)$ دارد، ولی در صورتی که دامنه یک شبکه مشبک باشد، پیچیدگی محاسباتی با انجام تبدیل سریع فوریه به $O(n\log n)$ کاهش می یابد.

<!--### Can we extend the Convolution theorem to graphs?-->
### چگونه می توانیم تئوری کانولوشن را به گراف ها توسعه دهیم؟

<!--This raises two questions:-->
انجام این موضوع نیازمند پاسخ به دو سوال زیر می باشد:
<!--1. How to define Fourier transforms for graphs?-->
1. چگونه می توانیم تبدیل فوریه برای گرافها استفاده کنیم؟
<!--2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)?-->
2. چگونه می توانیم کانولوشن های طیفی را با پیچیدگی محاسباتی $O(n)$ برای کرنل های فشرده (همانطور که برای تطبیق قالب استفاده می شود) محاسبه کنیم؟

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

<!--We are going to use these two design for graph neural networks:-->
ما قصد داریم از دو طراحی برای شبکه ها ی عصبی گرافی استفاده کنیم:
<!--Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets.-->
تطبیق قالب برای شبکه عصبی گرافی فضایی CovNets و تئوری کانولوشن برای شبکه های ConvNets فضایی استفاده می شود.


<!--## [Spectral Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)-->
## [شبکه های CovNets طیفی گرافی](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)

<!--How to perform spectral convolution?-->
چگونه کانولوشن طیفی اجرا می شود؟

<!--### Step 1 : Graph Laplacian-->
### گام نخست: لاپلاسین گراف

<!--This is the core operator in spectral graph theory.-->
<!--Define-->
لاپلاسین گراف عملگر اصلی در تئوری طیفی گراف می باشد که به صورت زیر تعریف می شود.

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


<!--Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.-->
توجه داشته باشید ماتریس $A$ برابر با ماتریس همسایگی می باشد, و $\Delta$ لاپلاسین می باشد, که برابر با ماتریس یکه منهای ماتریس همسایگی می باشد که با ماتریس $D$ نرمال می گردد. ماتریس $D$ یک ماتریس قطری می باشد که عنصر در قطر ماتریس برابر با درجه گره در گراف می باشد. این عملیات اینجا لاپلاسین نرمال یا به صورت پیش فرض لاپلاسین در این متن نامیده می شود.


The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$.
لاپلاسین در اینجا معیار همواری گراف تفسیر می شود یا به عبارت دیگر تفاوت بین مقدار محلی $h_i$ و مقدار میانگین همسایگی های $h_j$ شناخته می شود. عبارت $d_i$ در فرمول زیر برابر با درجه گره $i$ می باشد و $\mathcal{N}_{i}$ برابر با تمامی همسایه های نود $i$ است.

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

<!--The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and *vice versa*.-->
فرمول بالا برای اعمال لاپلاسین به تابع $h$ بر روی گره $i$ استفاده می شود که برابر با مقدار $h_i$ منهای مقدار میانگین  محاسبه شده بر روی گره های همسایه $h_j$' می باشد. به صورت پایه, اگر مقدار سیگنال بسیار نرم باشد، مقدار لاپلاسین نیز کوچک خواهد بود و *بالعکس*.

<!--### Step 2 : Fourier Functions-->
### گام دوم : توابع فوریه

<!--The following is the eigen-decomposition of graph Laplacian,-->
در ادامه تجزیه ماتریس لاپلاسین گراف به مقدار و بردارهای ویژه آن ارایه می شود:

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$


<!--The Laplacian is factorized into three matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.-->
در این حالت لاپلاسین به سه ماتریس زیر فاکتور بندی می شود شامل: $\Phi ^ T$، $\Lambda$، $\Phi$.

<!--$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis.-->
ماتریس $\Phi$ به صورت بردارهای ستونی برابر یا بردار های ویژه لاپلاسین از $\phi_1$ تا $\phi_n$ با اندازه ای برابر با  $n \times 1$ و آنهایی که توابع فوریه نامیده می شوند تعریف می شوند. در اینجا شکل توابع فوریه از ساختار orthonormal پیروی می کند.

$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$



$\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$


<!--Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$.-->
در زیر یک مثال تجزیه به مقدار و بردارهای ویژه نشان داده می شود. ماتریس لاپلاسین $\Lambda$ با یک بردار ویژه $\phi_k$ ضرب می شود. در این حالت خروجی برابر با $\lambda_k \phi_k$ با ابعاد $n \times 1$ می باشد.


$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

<!--The image below is the visualization of eigenvectors of 1D Euclidean Laplacian.-->
شکل زیر تجسم تصویری از بردارهای ویژه لاپلاسین یک بعدی نشان می دهد.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<!--<b>Fig. 16</b>: Grid/Euclidean Domain: eigenvectors of 1D Euclidean Laplacian.-->
<b>شکل 16:</b>دامنه اقلیدسی/مشبک: بردارهای ویژه لاپلاسین اقلیدسی یک بعدی.
</center>

<!--For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below.-->
در فضای گراف، از چپ به راست، اولین، دومین و سومین و ... و n-امین توابع فوریه یک گراف می باشد. به عنوان مثال $\phi_1$ نوسانی بین مقادیر مثبت(قرمز) و منفی(آبی) دارد. این نوسان ها به توپولوژی گراف که مرتبط به ساختارهای هندسی گرافها شامل اجتماع گره ها(community)، گره های هاب و غیره وابسته می باشند. این موضوع برای خوشه بندی گراف مفید می باشد.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<!--<b>Fig. 17</b>: Graph Domain: Fourier functions of a graph.-->
<b>شکل 17:</b>دامنه گراف: توابع فوریه یک گراف
</center>

<!--### Step 3 : Fourier Transform-->
### گام سوم : تبدیل فوریه

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

<!--**Fourier series: Decompose function $h$ with Fourier functions.**-->
** سری فوریه: تجزیه تابع به توابع فوریه $h$ **

<!--Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$.-->
تابع $h$ در نظر بگیرید که به تابع فوریه $\phi_k$ تصویر می شود, در این حالت ضرایب سری فوریه $k$، که از نوع اسکالر می باشند با تابع $\phi_k$ ضرب می شوند.

<!--The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series.-->
تبدیل فوریه در اصل تابع $h$ را بر روی توابع فوریه تصویر می کند. نتیجه برابر با ضرایب سری فوریه می باشند.

<!--**Fourier Transform/ coefficients of Fourier Series**-->
**تبدیل فوریه/ضرایب سری فوریه**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$


**Inverse Fourier Transform**
**تبدیل فوریه معکوس**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


<!--Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$.-->
تبدیل های فوریه عملگر خطی می باشند، که ماتریس $\Phi^{T}$ با بردار $h$ ضرب می کند.



<!--### Step 4 : Convolution Theorem-->
### گام چهارم : تئوری کانولوشن


<!--Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms.-->
تبدیل فوریه کانولوشن دو تابع برابر با ضرب نقطه به نقطه تبدیل های فوریه می باشد.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

<!--The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.-->
مثال بالا کانولوشن بین $w$ و $h$ می باشد، هر دو ابعادی برابر با  $n \times 1$ دارند، این مساوی با اعمال تبدیل فوریه معکوس بر روی ضرب نقطه به نقطه بین تبدیل های فوریه $w$ و $h$ می باشد. فرمول بالا همچنین برابر با ضرب ماتریس های $\hat{w}(\Delta)$ و $h$ است.

<!--The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph.-->
کانولوشن دو تابع $h$ و $w$ در گراف که به عنوان کانولوشن طیف گرا تعریف می شود برابر با در تظر گرفتن تابع طیفی $w$ می باشد که بر لاپلاسین اعمال شده و با $h$ ضرب می شود. در این حالت پیچیدگی محاسباتی برابر با $\mathrm{O}\left(n^{2}\right)$ است که $n$ برابر با تعداد گره ها در گراف می باشد.


<!--## Limitation-->
## محدودیت

<!--The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.-->
کانولوشن طیفی در حوزه گراف ویژگی تغییرناپذیری را جابه جا نمی کند. این به معنی آن است اگر کانولوشن جابه جایی اعمال کند، ابعاد تابع ممکن است به نوبه خود تفییر کنند در حالی که در حوزه شبکه مشبک این موضوع وجود ندارد.


<!--## Recommended book-->
## کتاب پیشنهادی

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)

