---
lang: fa
lang-ref: ch.12-2
title: مدل های زبان رمزگشا
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
translator: Tayeb Pourebrahim
---


<!--
## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)


Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.
The algorithm selects the best scoring hypothesis.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center>
--->
## [الگوریتم جستجو پرتو محلی](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)
الگوریتم جستجو پرتو محلی یک تکنیک دیگر برای رمزگشایی از مدل زبانی و ایجاد متن است. در هر مرحله، الگوریتم ردپای مسیر $k$ محتمل‌ترین (بهترین) ترجمه های جزئی(فرضیه‌ها) دنبال می‌کند. امتیاز هر فرضیه برابر با لگاریتم احتمال آن است.
الگوریتم فرضیه های با بالاترین نمره را انتخاب می کند.
<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>تصویر اول</b>: رمزگشایی پرتو محلی
</center>


<!-----
How deep does the beam tree branch out ?

The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished.

Why (in NMT) do very large beam sizes often results in empty translations?

At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.

Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached.
---->
درخت پرتو تا چه عمقی منشعب می شود؟

درخت پرتو تا زمانی که به ژتون انتهای جمله برسد، ادامه می یابد. به محض خروجی ژتون انتهای جمله، فرضیه تمام می شود.

چرا (در NMT) اندازه های بسیار بزرگ پرتو اغلب منجر به ترجمه های خالی می شود؟

در زمان آموزش، الگوریتم اغلب از پرتو استفاده نمی کند، زیرا بسیار گران است. به جای استفاده از فاکتورگیری خودهمبسته (که از خروجی درست پیشبینی $n+1$ کلمه‌ی اول به دست آوردیم). این مدل در هنگام آموزش در معرض اشتباهات خود قرار ندارد، بنابراین ممکن است که «مُهملاتی» در پرتو نشان داده شود.

خلاصه: جستجوی پرتو را تا زمانی که تمام $K$ فرضیه ژتون پایانی را تولید کنند یا به حد حداکثر رمزگشایی T برسند ادامه پیدا می‌کند.


<!---
### Sampling

We may not want the most likely sequence. Instead we can sample from the model distribution.

However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops.
--->

### نمونه گیری
ما ممکن است محتمل‌ترین دنباله را نخواهیم. در عوض می توانیم از توزیع مدل نمونه بگیریم.

با این حال، نمونه گیری از توزیع مدل مشکل خاص خود را ایجاد می کند. هنگامی که از یک انتخاب «بد» نمونه برداری شد، مدل در وضعیتی است که در طول آموزش هرگز با آن روبرو نشده است، احتمال ادامه ارزیابی «بد» افزایش میابد. بنابراین الگوریتم می تواند در حلقه‌های بازخورد وحشتناک گیر کند.

<!--
### Top-K Sampling

A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center>
--->
### نمونه گیری کی-بالا
یک تکنیک نمونه گیری خالص که توزیع را به $K$ بهترین‌ها کوتاه می‌کنیم و سپس دوباره نرمالایز می‌کنیم و از توزیع نمونه می‌گیریم.
<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>تصویر دوم</b>: نمونه گیری کی-بالا
</center>

<!---
#### Question: Why does Top-K sampling work so well?

This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail.
--->

### سوال: چرا نمونه گیری کی-بالا به خوبی کار می‌کند؟

این تکنیک به این دلیل خوب کار می‌کند که اساساً سعی می شود مانع از افتادن از منیفولد زبان خوب شود وقتی که ما فقط از سر توزیع استفاده کنیم و دم توزیع را حذف می‌کنیم.
<!---
## Evaluating Text Generation

Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues.
--->
## ارزیابی تولید متن

ارزیابی مدل زبان به سادگی نیاز به لگاریتم درست نمایی دیتای بیرون نگه داشته (یا دادهای تست) دارد. با این حال، ارزیابی متن دشوار است. معیار های کلمات متداول همپوشانی با الگوریتم‌های مرجع (همانند BLEU، ROUGE و ...) دارد، اما آنها مشکلات خاص خود را دارند.


<!---
## Sequence-To-Sequence Models


### Conditional Language Models

Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.

Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer
---->

## مدل‌های ترتیب به ترتیب


### مدل‌های زبان مشروط

مدل های زبان مشروط برای تولید نمونه های تصادفی انگلیسی مفید نیستند، اما برای تولید متنی با یک ورودی، مفید هستند.

مثال‌ها:

- با توجه به یک جمله فرانسه، ترجمه انگلیسی را تولید کنیم.
- با توجه به یک سند، خلاصه را تولید کنیم.
- با توجه به یک دیالوگ، پاسخ بعدی را تولید کنیم.
- با توجه به یک سوال، جواب را تولید کنیم. 

<!---
### Sequence-To-Sequence Models

Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center>
---->
### مدل‌های ترتیب به ترتیب

به طور کلی، متن ورودی رمزگذاری شده است. این نتیجه جاسازی شده به عنوان "بردار فکر" شناخته می شود، که سپس به رمزگشای منتقل می شود تا کلمه به کلمه ژوتن‌ها را تولید کند.

center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>تصویر سوم</b>: بردار فکر
</center>

<!-----
### Sequence-To-Sequence Transformer

The sequence-to-sequence variation of transformers has 2 stacks:

1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input

2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center>

Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models.
--->
### دگرگون ساز ترتیب به ترتیب

نوع ترتیب به ترتیب دگرگون ساز، دو نوع دارد:

۱. نوع رمزگذار - خود-توجه‌ای پوشیده نیست بنابراین همه ژتون‌های ورودی می توانند به ژتون‌های دیگر ورودی نگاه کنند

۲. نوع رمزگشا - جدای استفاده از استفاده «توجه» روی خودش، روی تمام ورودی‌ها هم استفاده می‌شود

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>تصویر چهارم</b>: دگرگون ساز ترتیب به ترتیب
</center>

هر ژتون در خروجی با هر ژتون قبلی در خروجی و همچنین با هر کلمه در ورودی ارتباط مستقیم دارد. اتصالات این مدل ها را بسیار رسا و قدرتمند می کند. این دگرگون‌سازها بهبودهایی در امتیاز ترجمه نسبت به مدل‌های بازگشتی و کانولوشنی ایجاد کردند.

<!----
## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model.

--->
##  [ترجمه مجدد] (https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)
هنگام آموزش این مدل ها، ما معمولاً به مقدار زیادی متن برچسب خورده وابسته‌ایم. متن اقدامات پارلمان اروپا منبع خوبی از دیتا است - این متن به صورت دستی به زبان‌های مختلفی ترجمه شده است که می‌توانیم به عنوان ورودی‌ها و خروجی‌‌های مدل استفاده کنیم.
<!---
### Issues

- Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, *i.e.* no input / output pairs?

Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German

- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.

Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:

- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English
--->

### مسائل

- همه زبانها در پارلمان اروپا نمایندگی ندارند، به این معنی که الزاماً برای همه زبان هایی که ممکن است به آنها علاقه داشته باشیم جفت ترجمه نخواهیم داشت. چگونه متنی را برای آموزش به زبانی پیدا کنیم که لزوماً نتوانیم داده ها را برای آن بدست آوریم؟

- از آنجا که مدل هایی مانند دگرگون‌سازها با داده های بیشتر عملکرد بهتری دارند، چگونه می‌توان از متن تک زبانه به طور کارآمد استفاده کرد ، * یعنی * بدون جفت ورودی / خروجی؟

فرض کنید می خواهیم مدلی را ترجمه کنیم که آلمانی را به انگلیسی ترجمه کند. ایده ترجمه مجدد این است که ابتدا یک مدل معکوس انگلیسی به آلمانی آموزش دهیم

- با استفاده از برخی  داده های دو متنی محدود می توانیم جملات مشابه را به دو زبان مختلف بدست آوریم
- هنگامی که ما مدل انگلیسی به آلمانی را داریم، بسیاری از کلمات یک زبانه را از انگلیسی به آلمانی ترجمه کنید.

در آخر، آموزش مدل آلمانی به انگلیسی با استفاده از کلماتی که در مراحل قبلی «ترجمه مجدد» شده است، انجام می‌دهیم. ما توجه داریم که:

- مهم نیست که مدل معکوس چقدر خوب باشد - ما ممکن است ترجمه های آلمانی نویزی داشته باشیم اما در نهایت ترجمه دقیق انگلیسی داشته باشیم.
- ما باید یاد بگیریم که انگلیسی را فراتر از داده های جفت های انگلیسی / آلمانی (قبلاً ترجمه شده) درک کنیم - از مقادیر زیادی [متن] انگلیسی تک زبانه استفاده کنید

<!----
### Iterated Back-translation

- We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data
--->
### ترجمه مجدد تکرار شده

- ما می توانیم روش ترجمه مجدد را تکرار کنیم تا حتی داده های دو متنی بیشتری تولید کنیم و عملکرد بسیار بهتری داشته باشیم - فقط با استفاده از داده های تک زبانه آموزش را ادامه دهید
- وقتی داده موازی زیادی نباشد، خیلی کمک می کند
<!----
## Massive multilingual MT

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center>

- Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center>

Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language).
--->
## ترجمه ماشینی چند زبانه عظیم

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>تصویر پنجم</b>: ترجمه ماشینی چند زبانه
</center>

<!----
## Unsupervised Learning for NLP

There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text?
---->
## یادگیری بدون نظارت پردازش زبان‌های طبیعی

مقادیر زیادی از متن بدون هیچ برچسب وجود دارد و داده های نظارت شده کمی وجود دارد. چقدر می توان فقط با خواندن متن بدون برچسب در مورد زبان یاد گرفت؟

<!---
### `word2vec`

Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.

- Goal is to learn vector space representations for words (learn embeddings)

Pretraining task - mask some word and use neighbouring words to fill in the blanks.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center>

For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal.

Take the words and apply a linear projection

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center>

Want to know

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Word embeddings hold some structure

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center>

- The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors
--->
### `word2vec`

شهود - اگر کلمات در متن نزدیک به هم ظاهر شوند، احتمالاً با هم مرتبط هستند، بنابراین امیدواریم که فقط با نگاه کردن به متن انگلیسی بدون برچسب، معنی آنها را یاد بگیریم.

- هدف یادگیری فضای برداری نماینده های کلمات است (یادگیری جاسازی‌ها)

وظیفه قبل از آموزش - مقداری کلمه را مخفی کنید و از کلمات همسایه برای پر کردن جای خالی استفاده کنید.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>تصویر هفتم</b>: word2vec پوشاندن بصری
</center>




به عنوان مثال، در اینجا ایده این است که "شاخ" و "موی نقره ای" بیش از برخی حیوانات دیگر در متن "تک شاخ" ظاهر می شوند.

کلمات را بگیرید و یک برون‌فکنی خطی اعمال کنید
<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>تصویر هشتم</b>:  word2vec جاسازی ها
</center>

می خواهیم بدانیم

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

جاسازی کلمه‌ها دارای ساختار است.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>تصویر نهم</b>: مثالی برای ساختار جاسازی
</center>

- ایده این است که اگر ما جاسازی را برای "پادشاه" پس از آموزش بگیریم و جاسازی را برای "زن" اضافه کنیم ، یک جاسازی بسیار نزدیک به "ملکه" بدست خواهیم آورد
- برخی اختلافات معنی دار بین بردارها را نشان می دهد

<!---
#### Question: Are the word representation dependent or independent of context?

Independent and have no idea how they relate to other words


#### Question: What would be an example of a situation that this model would struggle in?

Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word.

-->
### سوال: آیا نماینده کلمه مستقل از زمینه است یا وابسته به زمینه است؟

مستقل و هیچ ایده ای درباره ارتباط آنها با کلمات دیگر ندارند


### سوال: نمونه ای از وضعیتی که این مدل در آن گیر می کند چه خواهد بود؟

تفسیر کلمات بستگی زیادی به زمینه دارد. بنابراین در نمونه کلمات مبهم - کلماتی که ممکن است چندین معنی داشته باشند - این مدل با مشکل روبرو خواهد شد زیرا بردارهای جاسازی، زمینه مورد نیاز که برای درک صحیح کلمه را درک نمی کنند.


<!--- 
### GPT

To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.

- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review

This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks.
--->
### GPT

برای اضافه کردن زمینه به مدل، می توانیم یک مدل زبان مشروط را آموزش دهیم. سپس با توجه به این مدل زبان، که کلمه را در هر مرحله پیش بینی می کند، هر یک از خروجی های مدل را با ویژگی دیگری جایگزین کنید.

- پیش آموزش- کلمه بعدی را پیش بینی کنید
- تنظیم دقیق - تغییر به یک کار خاص. مثال ها:
  - پیش بینی کنید اسم است و یا صفت
  - با توجه به برخی از متن های متشکل از بررسی سایت آمازون، امتیاز را برای بررسی پیش بینی کنید

این روش خوب است زیرا ما می توانیم مدل را مجدداً استفاده کنیم. ما یک مدل بزرگ را از قبل آموزش می دهیم و می توانیم با کارهای دیگر هماهنگ کنیم.
<!---
### ELMo

GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.

Here the approach is to train _two_ language models

- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context.

This is still a "shallow" combination, and we want some more complex interaction between the left and right context.
--->
### ELMo

GPT فقط زمینه سمت چپ را در نظر می گیرد، این بدان معناست که مدل نمی تواند به هیچ کلمه ای در آینده وابسته باشد - این کاری را که مدل می تواند انجام دهد بسیار محدود می کند.

در اینجا رویکرد آموزش دو مدل زبان است

- یکی در متن چپ به راست
- یکی در متن راست به چپ
- برای ارائه دادن کلمه، خروجی دو مدل را بهم میچسبانیم. اکنون می تواند به زمینه راست و چپ بستگی داشته باشد.

این هنوز یک ترکیب «کم عمق» است و ما می خواهیم تعامل پیچیده تری بین زمینه چپ و راست داشته باشیم.

<!---
### BERT

BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.

Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now.
--->

### BERT


مدل BERT از این نظر شبیه word2vec است که ما یک وظیفه «پر کردن جای خالی» داریم. با این حال، در word2vec ما پیش بینی های خطی داشتیم، در حالی که در BERT یک دگرگون‌ساز بزرگ وجود دارد که می تواند زمینه های بیشتری را مشاهده کند. برای آموزش، ما ۱۵٪ از نشانه ها را می پوشانیم و سعی می کنیم جای خالی را پیش بینی کنیم.

به راحتی در مقیاس بزرگ قابل استفاده است (RoBERTa)

- هدف BERT را قبل از آموزش ساده کنید
- مقیاس اندازه دسته را افزایش دهید
- روی مقادیر زیادی GPU آموزش دهید
- حتی روی متن بیشتر آموزش دهید

حتی پیشرفت‌های بزرگتری روی عملکرد BERT - امروزه عملکرد در وظیفه «سوال و پاسخ» فوق انسانی است.

<!---
## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.

- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order

- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens

- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.

- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.

- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.

The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet


Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training.
---->
## [پیش آموزش برای ‫طبيعی‬ ‫زبان‬ ‫پردازش‬](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

بیایید نگاهی سریع به رویکردهای مختلف پیش از آموزش نظارت بر خود بیندازیم که برای ‫طبيعی‬ ‫زبان‬ ‫پردازش تحقیق شده اند.

- XLNet: 
   به جای پیشبینی تمام ژتون‌های پوشیده شده به صورت مشروط مستقل، XLNet به صورت خود همبسته به ترتیب تصادفی ژتون‌های پوشیده شده را پیشبینی می‌کند.

- SpanBERT
    پوشاندن اسپن‌ها (توالی کلمات متوالی) به جای ژتون‌ها
- ELECTRA:
    ما به جای پوشاندن کلمات، ژتون‌ها را با کلمات مشابه جایگزین می کنیم. سپس با تلاش برای پیش بینی اینکه آیا نشانه ها جایگزین شده اند یا نه، یک مسئله طبقه بندی باینری را حل می کنیم.
- ALBERT:
   مدل سبک‌تر BERT: ما BERT را اصلاح می کنیم و با گره زدن وزنه ها روی لایه ها، آن را سبک تر می کنیم. این پارامترهای مدل و محاسبات مربوطه را کاهش می دهد. جالب اینجاست که نویسندگان ALBERT مجبور نبودند که در «دقت» زیاد مصالحه کنند.

- XLM:


   مدل چند زبانه BERT: ما به جای تغذیه یک متن انگلیسی، متن را چند زبان ارائه می دهیم. همانطور که انتظار می رود، ارتباطات بین زبانی را بهتر یاد گرفت.
   
مهمترین نقاط کلیدی مدلهای ذکر شده در بالا عبارتند از:

- اهداف پیش آموزش‌های زیاد و مختلف بسیار خوب کار می‌کنند!

- ارتباط دوطرفه بین کلمات برای عمق مدل حیاتی است

- دستاورد های بزرگی از پیش آموزش در مقیاس بزرگ به دست می‌آید، هنوز بدون هیچ محدودیت مشخصی


بیشتر مدل هایی که در بالا بحث شد برای حل مسئله طبقه بندی متن مهندسی شده اند. با این حال، برای حل مشکل تولید متن، جایی که ما به ترتیب و مانند مدل «seq2seq» خروجی تولید می کنیم، به روش کمی متفاوت قبل از آموزش نیاز داریم.

   
<!----
#### Pre-training for Conditional Generation: BART and T5

BART: pre-training `seq2seq` models by de-noising text

In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.

This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.

BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa.
---->
### پیش آموزش برای نسل مشروط: BART و T5

مدل BART: پیش آموزش مدل های «seq2seq» توسط متن بدون نویز

در مدل BART، برای پیش آموزش، ما یک جمله را می گیریم و آن را با پوشاندن تصادفی ژتون‌ها خراب می کنیم. به جای پیش بینی ژتون‌های پوشیده شده (مانند هدف BERT)، ما کل توالی خراب را بگیریم و سعی می کنیم کل توالی صحیح را پیش بینی کنیم.

این رویکرد پیش آموز «seq2seq» به ما انعطاف پذیری در طراحی رویه خراب کردن متن را می دهد. ما می توانیم جملات را بُر بزنیم، عبارات را حذف کنیم، عبارات جدیدی معرفی کنیم، و غیره.

مدل BART می توانست با RoBERTa در کارهای SQUAD و GLUE مطابقت داشته باشد. با این حال، این روش جدید SOTA در زمینه خلاصه سازی، گفتگو و مجموعه داده های انتزاعی پرسش و پاسخ بود. این نتایج انگیزه ما را برای BART تقویت می کند، که در انجام کارهای تولید متن بهتر از BERT / RoBERTa باشیم.


<!----
### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language?
---->

### بعضی از سوالات باز در پردازش زبان طبیعی

- چگونه باید دانش جهانی را با هم ادغام کنیم
- چگونه اسناد طولانی را مدلسازی می کنیم؟ (مدل های بر پایه BERT معمولا ۵۱۲ ژتون دارند)
- چگونه یادگیری چند وظیفه ای را به بهترین وجه انجام می دهیم؟
- آیا می توانیم با داده کمتری تنظیم دقیق کنیم؟
- آیا این مدل ها واقعاً زبان را درک می کنند؟
<!----

### Summary

- Training models on lots of data beats explicitly modelling linguistic structure.

From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks

- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy

- Bidirectional context is crucial
---->
### خلاصه

- مدل های آموزشی بر روی تعداد زیادی از داده ها، مدل سازی صریح ساختار زبانی را به راحتی شکست می دهد.

از دیدگاه اریبی واریانس، دگرگون‌سازها مدل هایی با اریبی کم (بسیار رسا) هستند. تغذیه متن های متناسب با این مدل ها بهتر از مدل سازی صریح ساختار زبانی (اریبی زیاد) است. معماری ها باید فشرده سازی توالی ها را از طریق گلوگاه ها انجام دهند.

- مدل ها می توانند با پیش بینی کلمات در متن بدون برچسب، چیزهای زیادی در مورد زبان یاد بگیرند. به نظر می رسد این یک هدف یادگیری بدون نظارت عالی است. تنظیم دقیق برای کارهای خاص پس از آن آسان است

- متن دو زبانه بسیار مهم است

<!----
### Additional Insights from questions after class:

What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?

"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.

Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way.

--->

### بینش بیشتر از سوالات بعد از کلاس:

چه روش‌هایی برای تعیین کمیت «درک زبان» وجود دارد؟ از کجا می دانیم که این مدل ها واقعاً زبان درک می کنند؟

«جایزه در چمدان قرار نگرفت زیرا بسیار بزرگ بود»: حل ارجاع به «آن» در این جمله برای ماشینها مشکل است. انسانها در این کار تبحر دارند. یک مجموعه داده وجود دارد که از چنین مثالهای دشواری تشکیل شده و انسانها عملکرد ۹۵ درصدی در آن مجموعه داده دارند. قبل از انقلابی که توسط دگرگون ساز‌ها ایجاد شده بود، برنامه های رایانه ای عملکردی فقط در حدود ۶۰٪ در این مجموه داده به دست می آوردند. مدلهای مدرن دگرگون‌سازها قادر به دستیابی به بیش از ۹۰٪ ای در آن مجموعه داده هستند. این نشان می دهد که این مدلها فقط داده‌ها را حفظ / استخراج نکرده اند بلکه مفهایم و اشیای زبانی را از طریق الگوهای آماری یادگرفته‌اند.

<!---
#### Grounded Language

Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization.
-->
#### Grounded Language

جالب توجه است که مدرس (مایک لوئیس ، محقق دانشمند ، FAIR) در حال کار بر روی مفهومی به نام «Grounded Language» است. هدف از این زمینه تحقیق ایجاد مکالمه کننده‌ای است که قادر به  صحبت دوستانه و کوتاه (چیت چت) یا مذاکره باشد. گفتگو و مذاکره وظایفی انتزاعی با اهداف نامشخص در مقایسه با طبقه بندی متن یا خلاصه متن است.

<!----
#### Can we evaluate whether the model already has world knowledge?

‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’.
----> 
#### آیا می توانیم ارزیابی کنیم که آیا این مدل همین الان دانش جهانی دارد؟

«دانش جهانی» مفهومی انتزاعی است. می توانیم با پرسیدن سوالات بسیار ساده در سطوح ابتدایی از موضوعاتی که به آن علاقه مندیم، سطح علم مدل‌های خود را تست کنیم. مدل هایی همانند BERT، RoBERTA و T5 میلیاردها پارامتر دارند و با توجه به اینکه این مدل ها روی مجموعه عظیمی از متن اطلاعاتی مانند ویکی پدیا آموزش دیده اند، آنها حقایق را با استفاده از پارامترهای خود به خاطر می سپارند و می توانند به سوالات ما پاسخ دهند. علاوه بر این، ما همچنین می توانیم آزمایش مشابه دانش را قبل و بعد از تنظیم دقیق یک مدل روی برخی از کارها انجام دهیم. این می تواند به ما درک کند که مدل چه مقدار اطلاعات را «فراموش» کرده است.
