---
lang: fa
lang-ref: ch.12-1
title: یادگیری عمیق برای «پردازش زبان‌های طبیعی«
lecturer: Mike Lewis
authors: Jiayu Qiu, Yuhong Zhu, Lyuang Fu, Ian Leefmans
date: 20 Apr 2020
translator: Tayeb Pourebrahim
translation-date: 10 Oct 2020
---

<!-----
## [Overview](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)

* Amazing progress in recent years:
  - Humans prefer machine translation to human translators for some languages
  - Super-human performance on many question answering datasets
  - Language models generate fluent paragraphs (e.g Radford et al. 2019)
*  Minimal specialist techniques needed per task, can achieve these things with fairly generic models
----->
## [بررسی اجمالی](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)
* پیشرفت شگفت انگیز در سالهای اخیر:
  - در برخی زبان‌ها، انسان‌ها ترجمه ماشینی را بر ترجمه انسانی ترجیح می‌دهند
  - عملکرد فرا انسانی در تعداد زیادی مجموعه داده‌ی سوال-پاسخ
  - مدل های زبان، پاراگراف‌های روان تولید می کنند (برای مثال: مقاله رادفورد و همکاران ۲۰۱۹) 
* حداقل تکنیک‌های تخصصی نسبت بر هر کار مورد نیاز است و با مدل‌های نسبتاً عمومی این موارد به دست می‌آید


<!---
## Language Models

* Language models assign a probability to a text:
  $p(x_0, \cdots, x_n)$
* Many possible sentences so we can’t just train a classifier
* Most popular method is to factorize distribution using chain rule:

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$
--->
## مدل های زبان
* مدل های زبان یک احتمال را به یک متن اختصاص می دهند:
  $p(x_0, \cdots, x_n)$
* تعداد زیادی جمله‌ی محتمل وجود دارد بنابراین نمی‌توانیم فقط یک «دسته‌بند» را آموزش دهیم
* محبوب‌ترین روش تجزیه کردن توزیع با استفاده از قانون زنجیره‌ای است:
$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$


<!---
## Neural Language Models

Basically we input the text into a neural network, the neural network will map all this context onto a vector. This vector represents the next word and we have some big word embedding matrix. The word embedding matrix contains a vector for every possible word the model can output. We then compute similarity by dot product of the context vector and each of the word vectors. We'll get a likelihood of predicting the next word, then train this model by maximum likelihood. The key detail here is that we don't deal with words directly, but we deal with things called sub-words or characters.

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  Fig.1: Neural language model</center>
</figure>
--->
## مدل‌های زبان عصبی

اساساً ما متن را وارد یک شبکه عصبی می‌کنیم، شبکه عصبی تمام اجزای متن را بر روی یک بردار نگاشت می کند. این بردار کلمه بعدی را نشان می‌دهد و ما چند ماتریس بزرگ جاسازی کلمات داریم. ماتریس جاسازی کلمه شامل برداری برای هم کلمه‌ی محتمل که می‌توان خروجی مدل باشد، است. سپس ما به طور مشابه ضرب داخلی «بردار اجزا» را در بردار‌ هر کلمه محاسبه می‌کنیم. ما درست‌نمایی پیشبینی کلمه بعدی را به دست می‌آوریم، سپس این مدل را با استفاده از «درست‌نمایی بیشینه» آموزش می‌دهیم. جزء اصلی این است که ما با کلمات به طور مستقیم سر و کار نداریم بلکه با چیزهایی به نام «زیر-کلمه» یا کاراکتر‌ها سر و کار داریم.

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  تصویر شماره ۱: مدل‌های زبان عصبی</center>
</figure>

<!--
### Convolutional Language Models

* The first neural language model
* Embed each word as a vector, which is a lookup table to the embedding matrix, so the word will get the same vector no matter what context it appears in
* Apply same feed forward network at each time step
* Unfortunately, fixed length history means it can only condition on bounded context
* These models do have the upside of being very fast

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center>  Fig.2: Convolutional language model</center>
</figure>
-->
## مدل‌های زبان کانولوشنی

* اولین مدل عصبی زبان
* هر کلمه را به عنوان یک بردار جاسازی کنید، که یک جدول جستجو برای ماتریس جاسازی است، پس کلمه همان بردار را می‌گیرد بدون توجه به موضوعی که در آن ظاهر شده است
* در هر مرحله «شبکه پیشخور» یکسانی اعمال می شود
* متاسفانه،‌ «تاریخچه با اندازه ثابت» به معنی این است که فقط محدود به متن کراندار است
* جنبه مثبت این مدل‌ها سرعت بسیار زیادشون است
<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center> تصویر ۲: مدل زبان کانولوشنی </center>
</figure>

<!--
### Recurrent Language Models

* The most popular approach until a couple years ago.
* Conceptually straightforward: every time step we maintain some state (received from the previous time step, which represents what we've read so far. This is combined with current word being read and used at later state. Then we repeat this process for as many time steps as we need.
* Uses unbounded context: in principle the title of a book would affect the hidden states of last word of the book.
* Disadvantages:
  - The whole history of the document reading is compressed into fixed-size vector at each time step, which is the bottleneck of this model
  - Gradients tend to vanish with long contexts
  - Not possible to parallelize over time-steps, so slow training

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  Fig.3: Recurrent language model</center>
</figure>
##
-->
## مدل‌های زبان بازگشتی

* محبوب‌ترین روش تا چندین سال پیش 
* از نظر مفهموی سرراست است: هر مرحله زمانی ما بعضی حالت ها را حفظ می کنیم (دریافت شده از مرحله زمان قبلی، که نشان دهنده آنچه ما تاکنون خوانده ایم. این با کلمه فعلی ترکیب شده است که در حالت بعدی خوانده و استفاده می شود. سپس این روند را به تعداد گام های زمانی که نیاز داریم تکرار می کنیم.
* استفاده در متن‌های بی‌کران: در اصل عنوان یک کتاب بر وضعیت های پنهان آخرین کلمه کتاب تأثیر می گذارد.
* معایب:
  - کل تاریخچه خواندن سند در هر مرحله به بردار با اندازه ثابت فشرده می شود، که «گلوگاه» این مدل است
  - گرادیان‌ها در متون طولانی تمایل به از بین رفتن دارند
  - امکان پردازش موازی در مرحله-زمان وجود ندارد، پس سرعت آموزش پایینی دارد
  
  <figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  تصویر سوم: مدل زبان بازگشتی</center>
</figure>
  
<!---
### [Transformer Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)

* Most recent model used in NLP
* Revolutionized penalty
* Three main stages
    * Input stage
    * $n$ times transformer blocks (encoding layers) with different parameters
    * Output stage
* Example with 6 transformer modules (encoding layers) in the original transformer paper:

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  Fig.4:Transformer language model </center>
</figure>

Sub-layers are connected by the boxes labelled "Add&Norm". The "Add" part means it is a residual connection, which helps in stopping the gradient from vanishing. The norm here denotes layer normalization.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  Fig.5: Encoder Layer </center>
</figure>

It should be noted that transformers share weights across time-steps.
--->
### [مدل‌های زبان دگرگون ساز] (https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)

* جدیدترین مدل در پردازش زبان‌های طبیعی
* جریمه اساسی
* سه مرحله اصلی
    * مرحله ورودی
    * $n$ بار بلاک‌ها (لایه‌‌های رمز شده) را با مولفه‌های مختلف دگرگون می‌کند
    * مرحله خروجی
* مثالی با ۶ ماژول (لایه‌های رمز شده) در مقاله اصلی دگرگون ساز:

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  تصویر چهارم: مدل زبان دگرگون ساز </center>
</figure>
زیر لایه‌ها توسط جعبه هایی با عنوان "Add&Norm" به هم متصل می‌شوند. قسمت "Add" به معنی این است که اتصال باقی مانده است، که کمک می‌کند به جلوگیری از محو شدن گرادیان.‍ نُرم در اینجا به معنی لایه نرمال‌سازی شده است.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  تصویر پنجم: لایه رمز شده</center>
</figure>
لازم به ذکر است که «دگرگون سازها» وزن‌ها را در مراحل زمانی به اشتراک می‌گذراند.


<!--
# Multi-headed attention

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  Fig.6: Multi-headed Attention </center>
</figure>
-->
# توجه چند سر
figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  تصویر ششم: توجه چند سر </center>
</figure>


<!---
For the words we are trying to predict, we compute values called **query(q)**. For all the previous words use to predict we call them **keys(k)**. Query is something that tells about the context, such as previous adjectives. Key is like a label containing information about the current word such as whether it's an adjective or not. Once q is computed, we can derive the distribution of previous words ($p_i$):
-->
برای کلماتی که تلاش میکنیم آن ها را پیشبینی کنیم، مقادیری رو محاسبه می‌کنیم به نام **query(q)**. برای تمام کلمات قبلی که پیشبینی کردیم را **keys(k)** می‌نامیم. پرسش یا query چیزی است که موضوع متن را به ما می‌گوید، همانند صفت‌های قبلی. کلید یا key همانند برجسب زدن اطلاعات فعلی درباره کلمه فعلی همانند «آب و هوا» است، یک صفت است یا نیست. یکبار که q محاسبه شود، می‌توانیم توزیع کلمات قبلی را به دست بیاوریم ($p_i$):


$$p_i = \text{softmax}(q,k_i)$$


<!---
Then we also compute quantities called **values(v)** for the previous words. Values represent the content of the words.

Once we have the values, we compute the hidden states by maximizing the attention distribution:
-->
سپس مقادیری را حساب می‌کنیم که برای کلمات قبلی به آن‌ها **values(v)** یا **مقادیر (v)** می‌گوییم. مقادیر نشان دهنده محتوای کلمات است.
هنگامی که مقادیر را بدست آوردیم، با به حداکثر رساندن توزیع توجه، حالت های پنهان را محاسبه می کنیم:
 $$h_i = \sum_{i}{p_i v_i}$$

<!---
We compute the same thing with different queries, values, and keys multiple times in parallel. The reason for this is that we want to predict the next word using different things. For example, when we predict the word "unicorns" using three previous words "These" "horned" and "silver-white". We know it is a unicorn by "horned" "silver-white". However, we can know it is plural "unicorns" by "These". Therefore, we probably want to use all these three words to know what the next word should be. Multi-headed attention is a way of letting each word look at multiple previous words.
--->
ما یک چیز را چندین بار به طور موازی با پرسش‌ها، مقادیر و کلیدهای مختلف محاسبه می کنیم. دلیل این امر این است که ما می خواهیم کلمه بعدی را با استفاده از چیزهای مختلف پیش بینی کنیم. به عنوان مثال، وقتی کلمه unicorns یا «تک شاخ‌ها» را با استفاده از سه کلمه قبلی these یا «این‌ها»، horned یا «شاخدار» و silver-white یا «سفید نقره‌ای» پیش بینی می کنیم. ما می دانیم که این یک «تک شاخ» است توسط «شاخدار» و «سفید-نقره‌ای». اگرچه با توجه به these یا «این‌ها» می‌دانیم که unicorns به معنی تک‌شاخ‌ها حالت جمع unicorn است. بنابراین، احتمالاً می خواهیم از این سه کلمه استفاده کنیم تا بدانیم کلمه بعدی باید چه باشد. توجه چند سره راهی است که باعث می شود هر کلمه به چندین کلمه قبلی نگاه کند.

<!---
One big advantage about the multi-headed attention is that it is very parallelisable. Unlike RNNs, it computes all heads of the multi-head attention modules and all the time-steps at once. One problem of computing all time-steps at once is that it could look at futures words too, while we only want to condition on previous words. One solution to that is what is called **self-attention masking**. The mask is an upper triangular matrix that have zeros in the lower triangle and negative infinity in the upper triangle. The effect of adding this mask to the output of the attention module is that every word  to the left has a much higher attention score than words to the right, so the model in practice only focuses on previous words. The application of the mask is crucial in language model because it makes it mathematically correct, however, in text encoders, bidirectional context can be helpful.
--->
یک مزیت بزرگ در مورد توجه چند سر این است که به صورت موازی بسیار قابل محاسبه است. برخلاف RNNها، که سرهای ماژول های توجه چند سر و همه مراحل گام را به طور همزمان محاسبه می کند. یک مشکل محاسبه همزمان همه مراحل زمانی این است که می تواند کلمات آینده را نیز بررسی کند، در حالی که ما فقط می خواهیم به کلمات قبلی شرط بگذاریم. یک راه حل برای آن چیزی است که ** پوشش خود-توجه ای ** نامیده می شود. پوشش یک ماتریس مثلثی فوقانی است که در مثلث پایین صفر و در مثلث بالایی بی نهایت منفی دارد. تأثیر افزودن این پوشش به خروجی ماژول توجه این است که هر کلمه به سمت چپ دارای نمره توجه بسیار بیشتری نسبت به کلمات به سمت راست است، بنابراین مدل در عمل فقط بر روی کلمات قبلی تمرکز دارد. استفاده از پوشش در مدل زبان بسیار مهم است زیرا آن را از نظر ریاضی صحیح می کند، با این حال، در رمزگذارهای متن، متن دو زبانه می تواند مفید باشد.


<!--
One detail to make the transformer language model work is to add the positional embedding to the input. In language, some properties like the order are important to interpret. The technique used here is learning separate embeddings at different time-steps and adding these to the input, so the input now is the summation of word vector and the positional vector. This gives the order information.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  Fig.7: Transformer Architecture </center>
</figure>
--->
یک جزئیات برای کارکرد مدل زبان دگرگون ساز افزودن جاساز موقعیتی به ورودی است. در زبان، برخی از خصوصیات مانند ترتیب برای تفسیر مهم هستند. تکنیک مورد استفاده در اینجا یادگیری جاسازهای جداگانه در مراحل مختلف زمانی و افزودن این موارد به ورودی است، بنابراین ورودی اکنون جمع برداری از بردار کلمه و بردار موقعیتی است. این تکنیک ترتیب اطلاعات را به ما می دهد.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  تصویر هفتم: معماری دگرگون ساز</center>
</figure>
<!---
**Why the model is so good:**

1. It gives direct connections between each pair of words. Each word can directly access the hidden states of the previous words, mitigating vanishing gradients. It learns very expensive function very easily
2. All time-steps are computed in parallel
3. Self-attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length
--->

**چرا این مدل خوب است؟**
۱. ارتباط مستقیمی بین هر جفت کلمه ایجاد می کند. هر کلمه می تواند مستقیماً به حالت های پنهان کلمات قبلی دسترسی پیدا کند و گرادیان های ناپدید شده را کاهش دهد. تابع پرهزینه ای را به راحتی یاد می‌گیرد.
۲. تمام گام‌های زمانی به صورت موازی محاسبه می‌شود.
۳. خود-توجه‌ای درجه دوم است (تمام گام‌های زمانی می تواند به همه موارد دیگر مربوط شود)، محدود به حداکثر طول دنباله.


<!---
## [Some tricks (especially for multi-head attention and positional encoding) and decoding Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)


### Trick 1: Extensive use of layer normalization to stabilize training is really helpful

- Really important for transformers


### Trick 2: Warm-up + Inverse-square root training schedule

- Make use of learning rate schedule: in order to make the transformers work well, you have to make your learning rate decay linearly from zero to thousandth steps.


### Trick 3: Careful initialization

- Really helpful for a task like machine translation


### Trick 4: Label smoothing

- Really helpful for a task like machine translation

The following are the results from some methods mentioned above. In these tests, the metric on the right called `ppl` was perplexity (the lower the `ppl` the better).

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  Fig.8: Model Performance Comparison </center>
</figure>

You could see that when transformers were introduced, the performance was greatly improved.
--->
## [برخی از ترفندها (به ویژه برای توجه چند سر و رمزگذاری موقعیتی) و رمزگشایی مدل های زبان](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)

### ترفند ۱: استفاده گسترده از نرمال سازی لایه برای تثبیت آموزش واقعاً مفید است

- برای دگرگون ساز بسیار مهم است
 
 
### ترفند ۲: دست گرمی + برنامه زمانی آموزش ریشه مربع معکوس

- از برنامه زمانی نرخ یادگیری استفاده کنید: برای اینکه دگرگون سازها به خوبی کار کنند، باید سرعت یادگیری خود را از صفر تا هزار مرحله به صورت خطی کاهش دهید

### ترفند ۳: مقداردهی اولیه دقیق
- برای کاری مثل ترجمه ماشینی بسیار مفید است
 
### ترفند ۴: هموارسازی برچسب
- برای کاری مثل ترجمه ماشینی بسیار مفید است


در زیر نتایج برخی از روشهای ذکر شده در بالا آمده است. در این آزمون ها، معیار سمت راست به نام «ppl» مقدار گیجی است ( هرچقدر مقدار ppl کمتر باشد بهتر است.)
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  تصویر هشتم: مقایسه عملکرد مدل </center>
</figure>
می توانید ببینید که وقتی دگرگون سازها معرفی شدند، عملکرد به شکل بسیار خوبی بهبود یافت.

<!---
## Some important facts of Transformer Language Models

 - Minimal inductive bias
 - All words directly connected, which will mitigate vanishing gradients.
 - All time-steps computed in parallel.


Self attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length.

- As self attention is quadratic, its expense grows linearly in practice, which could cause a problem.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  Fig.9: Transformers *vs.* RNNs </center>
</figure>
-->
## برخی از حقایق مهم مدل‌های دگرگون ساز زبان

  - حداقل سوگیری استقرایی
  - تمام کلمات به طور مستقیم متصل هستند، که باعث کاهش گرادیان‌های ناپدید شده می شوند.
  - تمام مراحل زمانی به طور موازی محاسبه می شوند.

خود-توجه‌ای درجه دوم است (تمام گام‌های زمانی می تواند به همه موارد دیگر مربوط شود)، محدود به حداکثر طول دنباله.

- باتوجه به اینکه خود-توجه‌ای درجه دوم است، هزینه آن در عمل به صورت خطی رشد می کند، که می تواند مشکلی ایجاد کند.
<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  تصویر نهم: دگرگون سازها در مقابل RNNها</center>
</figure>

<!---
### Transformers scale up very well

1. Unlimited training data, even far more than you need
2. GPT 2 used 2 billion parameters in 2019
3. Recent models use up to 17B parameters and in 2020
--->
### دگرگون سازها بسیار خوب مقیاس پذیر می شوند
۱. داده های آموزش نامحدود، حتی بسیار بیشتر از آنچه شما نیاز دارید
۲. GPT-2 درسال ۲۰۱۹ از ۲ میلیارد (بیلیون) پارامتر استفاده کرده است
۳. مدل‌های امروزی تا ۱۷ میلیارد (بیلیون) استفاده می‌کنند و امسال ۲۰۲۰ است

<!--- 
## Decoding Language Models

We can now train a probability distribution over text - now essentially we could get exponentially many possible outputs, so we can’t compute the maximum. Whatever choice you make for your first word could affect all the other decisions.
Thus, given that, the greedy decoding was introduced as follows.


### Greedy Decoding does not work

We take most likely word at each time step. However, no guarantee this gives most likely sequence because if you have to make that step at some point, then you get no way of back-tracking your search to undo any previous sessions.


### Exhaustive search also not possible

It requires computing all possible sequences and because of the complexity of $O(V^T)$, it will be too expensive
---> 
## مدل های زبان رمزگشا

اکنون می توانیم توزیع احتمال را روی متن آموزش دهیم - در حال حاضر اساساً می توانیم به صورت نمایی بسیاری از خروجی های ممکن را بدست آوریم، بنابراین نمی توانیم حداکثر را محاسبه کنیم. هر انتخابی که برای اولین کلمه خود انجام می دهید می تواند بر سایر تصمیمات تأثیر بگذارد.
بنابراین، با توجه به این، رمزگشایی حریصانه به شرح زیر معرفی شد.


### رمزگشایی حریص کار نمی کند

ما محتمل ترین کلمه را در هر مرحله زمان می گیریم. با این وجود، هیچ تضمینی این محتمل ترین توالی ممکن باشد، زیرا اگر مجبور باشید در مرحله ای آن مرحله را انجام دهید، دیگر هیچ راهی برای پیگیری جستجوی خود برای پس‌گرد سایر نشست‌های قبلی ندارید.

### جستجوی خسته کننده نیز امکان پذیر نیست

این نیاز به محاسبه تمامی توالی های ممکن دارد و به دلیل پیچیدگی $O(V^T)$، بسیار گران خواهد بود

<!---
## Comprehension Questions and Answers

1. What is the benefit of multi-headed attention as opposed to a single-headed attention model?

    * To predict the next word you need to observe multiple separate things, in other words attention can be placed on multiple previous words in trying to understand the context necessary to predict the next word.

2. How do transformers solve the informational bottlenecks of CNNs and RNNs?

    * Attention models allow for direct connection between all words allowing for each word to be conditioned on all previous words, effectively removing this bottleneck.

3. How do transformers differ from RNNs in the way they exploit GPU parallelization?

    * The multi-headed attention modules in transformers are highly parallelisable whereas RNNs are not and therefore cannot take advantage of GPU technology. In fact transformers compute all time steps at once in single forward pass.
--->

## سوالات و پاسخ های درک مطلب

۱. توجه چند سر در مقابل مدل توجه تک سر چه فایده ای دارد؟

    * برای پیش بینی کلمه بعدی باید چندین چیز جداگانه را مشاهده کنید، به عبارت دیگر، برای درک زمینه لازم برای پیش بینی کلمه بعدی می‌توان «توجه» را روی چند کلمه قبلی نشاند.

۲. چگونه دگرگون ساز‌ها گلوگاه های اطلاعاتی CNNها و RNNها را حل می کنند؟

    * مدل های توجه امکان ارتباط مستقیم بین تمام کلمات را فراهم می کنند و باعث می شوند هر کلمه به تمام کلمات قبلی مشروط شود و به طور موثر این گلوگاه را برطرف کند.
    
۳. تفاوت دگرگون ساز‌ها با RNNها در نحوه بهره برداری از موازی سازی GPU چیست؟

    * ماژول های توجه چندسر در دگرگون ساز‌ها بسیار امکان پردازش موازی دارند در حالی که RNNها اینطور نیستند و بنابراین نمی توانند از فناوری GPU استفاده کنند. در حقیقت دگرگون سازها تمام مراحل زمانی را همزمان با یک «پیش خور» محاسبه می کنند.
