---
lang-ref: ch.09-1
lecturer: Yann LeCun
title: اتوانکودرهای پراکنده بازگشتی تمایزی و پراکندگی گروهی
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 30 Mar 2020
lang: fa
translation-date: 23 Sep 2020
translator: Seyed Mohammad Mousavi
---

## [Discriminative recurrent sparse autoencoder (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&amp;t=35s)



<!--The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training.
-->

ایده DrSAE از ترکیب کدگذاری پراکنده یا اتوانکودر پراکنده با آموزش تمایزی تشکیل شده است.

<center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/></center>

<!--**Fig 1:** Discriminative Recurrent Sparse Auto-Encoder Network
-->

**شکل 1:** شبکه اتوانکودر پراکنده بازگشتی تمایزی

<!--The encoder, $W_e$, is similar to the encoder in the LISTA method. The $X$ variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, $S$, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer.
-->

انکودر، $W_e$، مشابه انکودر در روش LISTA است. متغیر $X$ از طریق $W_e$ و سپس از طریق غیرخطی اجرا می شود. سپس این نتیجه در یک ماتریس آموخته شده دیگر، $S$، ضرب شده و به $W_e$ اضافه می شود. سپس از طریق غیرخطی دیگری ارسال می شود. این فرآیند می تواند چندین بار تکرار شود، با هر تکرار به صورت یک لایه.

<!--We train this neural network with 3 different criteria:
1. $L_1$: Apply $L_1$ criterion on the feature vector $Z$ to make it sparse.
2. Reconstruct $X$: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.
3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category.
-->

ما این شبکه عصبی را با 3 معیار مختلف آموزش می دهیم:
1. $L_1$ : معیار $L_1$ را روی بردار ویژگی $Z$ اعمال می‌کنیم تا پراکند شود.
2. بازسازی $X$: این کار با استفاده از یک ماتریس دیکود انجام می شود که ورودی را روی خروجی مجدد تولید می کند. این کار با به حداقل رساندن خطای مربع (توان 2)، که با $W_d$ در شکل 1 نشان داده شده است، انجام می شود.
3. افزودن یک بخش سوم: این بخش سوم که با $W_c$ نشان داده می شود، یک دسته‌بندی کننده خطی ساده است که سعی در پیش بینی یک دسته دارد.

<!--The system is trained to minimize all 3 of these criteria at the same time.
-->

این سیستم آموزش دیده است تا هر سه این معیارها را به طور همزمان کاهش دهد.

<!--The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features.
-->

مزیت این کار مجبور کردن سیستم برای یافتن بازنمایی‌هایی است که می تواند ورودی را بازسازی کند، سپس شما اساساً سیستم را به سمت استخراج ویژگی‌هایی که حاوی هرچه بیشتر اطلاعات مربوط به ورودی هستند بایاس می کنید. به عبارت دیگر، ویژگی‌ها را غنی می‌کنید.

<!--
### Group Sparsity
-->

### پراکندگی گروهی

<!--The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling.
-->

ایده در اینجا تولید ویژگی‌های پراکنده است، اما نه فقط ویژگی‌های معمولی که توسط کانولوشن‌ها استخراج می‌شوند، بلکه اساساً تولید ویژگی‌هایی که پس از سرکشی (pooling) پراکنده هستند.

<center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/></center>


<!--**Fig 2:** Auto-Encoder with Group Sparsity
-->

**شکل 2:** اتوانکودر با پراکندگی گروهی

<!--Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable $Z$ going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of $Z$, and take the sum of those norms. So now that is what is used as the regulariser, so we can have sparsity on groups of $Z$. These groups, or pools of features, tend to group together features that are similar to one another.
-->

شکل 2 نمونه ای از اتوانکودر با پراکندگی گروهی را نشان می دهد. در اینجا، به جای اینکه متغیر پنهان $Z$ به یک $L_1$ برسد، اساساً از طریق $L_2$ از گروه‌ها عبور می کند. بنابراین شما نرم $L_2$ برای هریک از اجزای گروه $z$ را در نظر می‌گیرید و همه آن نرم‌هارا باهم جمع می‌کنید. بنابراین اکنون این همان چیزی است که به عنوان تنظیم کننده مورد استفاده قرار می گیرد، پس ما می‌توانیم در گروه‌های $z$ پراکندگی داشته باشیم. این گروه‌ها یا مجموعه‌ای از ویژگی‌ها، تمایل دارند ویژگی‌های مشابه یکدیگر را در یک گروه قرار دهند.

<!--
## [AE with group sparsity: questions and clarification](https://www.youtube.com/watch?v=Pgct8PKV7iw&amp;t=918s)
-->

## [AE با پراکندگی گروهی: سوال‌ها و توضیحات](https://www.youtube.com/watch?v=Pgct8PKV7iw&amp;t=918s)

<!--Q: Can a similar strategy used in the first slide with classifier and regulariser be applied for VAE?
-->

سوال: آیا می توان از استراتژی مشابهی که در اولین اسلاید برای دسته‌بندی‌کننده و تنظیم‌کننده استفاده شده برای VAE استفاده کرد؟

<!--A: Adding noise and forcing sparsity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function.
-->

پاسخ: افزودن نویز و اجبار کردن پراکندگی در VAE دو راه برای کاهش اطلاعات متغیر پنهان/کد است که از یادگیری تابع هویت جلوگیری می‌کند.

<!--Q: In slide "AE with Group Sparsity", what is $P_j$?
-->

سوال: در اسلاید "AE با پراکندگی گروهی"، $P_j$ چیست؟

<!--A: $p$ is a pool of features. For a vector $z$, it would be a subset of the values in $z$.
-->

پاسخ: $p$ مجموعه‌ای از ویژگی‌ها است. برای یک بردار $z$ زیر مجموعه‌ای از مقادیر $z$ خواهد بود.

<!--Q: *Clarification on feature pooling.*
-->

سوال: *توضیحات مربوط به جمع‌آوری ویژگی‌ها.*

<!--A: (Yann draws representation of AE with group sparsity) Encoder produces latent variable $z$, which is regularized using the $L_2$ norm of pooled features. This $z$ is used by the decoder for image reconstruction.
-->

پاسخ: (Yann بازنمایی AE را با پراکندگی گروهی ترسیم می کند) انکودر متغیر پنهان $z$ را تولید می کند که با استفاده از نرم $L_2$ ویژگی‌های جمع‌آوری شده تنظیم می شود. $z$ توسط دیکودر برای بازسازی تصویر استفاده می شود.

<!--Q: Does group regularization help with grouping similar features?
-->

سوال: آیا تنظیم کردن گروه به گروه‌بندی ویژگی‌های مشابه کمک می کند؟

<!--A: The answer is unclear, work done here was done before computational power/ data was readily available. Techniques have not been brought back to the forefront.
-->

پاسخ: پاسخ نامشخص است، کارهایی که در اینجا انجام شده، قبل از آن بوده است که توان محاسباتی/داده به راحتی در دسترس باشد. تکنیک‌ها دیگر به خط‌مقدم برنگشته‌اند.

<!--
## [Image level training, local filters but no weight sharing](https://www.youtube.com/watch?v=Pgct8PKV7iw&amp;t=1834s)
-->

## [آموزش در سطح عکس، فیلترهای محلی اما بدون اشتراک وزن](https://www.youtube.com/watch?v=Pgct8PKV7iw&amp;t=1834s)

<!--The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it.
-->

پاسخ در مورد اینکه آیا کمک می کند یا نه روشن نیست. افراد علاقه‌مند به این کار یا علاقه‌مند به ترمیم تصاویر یا نوعی یادگیری خود نظارت‌شده هستند. این قضیه وقتی دیتاست بسیار کوچک باشد، به خوبی کار می کند. هنگامی که یک انکودر و دیکودر دارید که از نوع کانولوشن است و با پراکندگی گروهی روی سلول‌های پیچیده تمرین می کنید، پس از اتمام کار پیش‌آموزش، سیستمی که شما از دیکودر خلاص می شوید و فقط از انکودر به عنوان استخراج‌کننده ویژگی‌ها استفاده می کنید، لایه اول شبکه کانولوشن و چسباندن یک لایه دوم بر روی آن است.

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/></center>

<!--**Fig 3:** Structure of Convolutional RELU with Group Sparsity
-->

**شکل 3:** ساختار کانولوشن یکسوساز با گروه پراکندگی

<!--As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regulariser. This is like L2 pooling with an architecture similar to group sparsity.
-->

همانطور که در بالا مشاهده می شود، شما با یک تصویر شروع می کنید، یک انکودر دارید که اساساً کانولوشن یکسوساز است و نوعی لایه مقیاس کننده پس از این است. شما با پراکندگی گروهی آموزش می‌دهید. شما یک دیکودر خطی و یک معیار دارید که بر مبنای یک گروه بندی شده‌اند. شما پراکندگی گروه را به عنوان یک قانونمند کننده در نظر می گیرید. این مانند سرکشی L2 با معماری مشابه پراکندگی گروه است.

<!--You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity.
-->

همچنین می توانید نمونه دیگری از این شبکه را آموزش دهید. این بار می توانید لایه‌های بیشتری اضافه کنید و یک دیکودر با سرکشی L2 و معیار پراکندگی داشته باشید، آن را آموزش دهید تا ورودی خود را با سرکشی از بالا بازسازی کند. با این کار یک شبکه کانولوشن 2 لایه پیش‌آموزش دیده ایجاد می شود. این روش اتوانکودر پشته شده (Stacked Autoencoder) نیز نامیده می شود. ویژگی اصلی در اینجا این است که برای تولید ویژگی‌های ثابت با پراکندگی گروه آموزش دیده است.

<!--Q : Should we use all possible sub-trees as groups?
-->

سوال: آیا باید از همه زیر درختان ممکن به عنوان گروه استفاده کنیم؟

<!--A : It’s up to you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used.
-->

پاسخ: به خود شما بستگی دارد، در صورت تمایل می توانید از چندین درخت استفاده کنید. ما می توانیم درخت را با یک درخت بزرگتر از حد ضروری آموزش دهیم و سپس شاخه‌هایی را که به ندرت استفاده می شوند حذف کنیم.

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/></center>
<!-- **Fig 4:** Image Level Training, local filters but no weight sharing
-->

**شکل 4:** آموزش در سطح تصویر ، فیلترهای محلی اما بدون اشتراک وزن

<!--These are called pin-wheel patterns. This is a kind of organisation of the features. The orientation varies continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain.
-->

به این‌ها الگوهای چرخ پین گفته می شود. یک نوع از سازماندهی ویژگی‌هاست. با دور زدن روی آن نقاط قرمز، جهت گیری به طور مداوم تغییر می‌کند. اگر یکی از آن نقاط قرمز را برداریم و اگر اطراف نقاط قرمز دور کوچکی بزنیم، متوجه می شوید که نوع حرکت استخراج‌کننده به طور مداوم با حرکت شما تغییر می‌کند. روندهای مشابه این در مغز مشاهده می شود.

<!--Q : Is the group sparsity term trained to have a small value?
-->

سوال: آیا پراکنده گروهی آموزش داده شده است که ارزش کمی داشته باشد؟

<!--It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criterion, it determines what the encoder and decoder will do and what sort of features will be extracted.
-->

یک تنظیم‌کننده است. به خودی خود آموزش داده نمی شود، ثابت است. این فقط نرم L2 گروه‌ها است و گروه‌ها از قبل تعیین شده اند. اما از آنجا که یک معیار است، تعیین می کند که انکودر و دیکودر چه کاری را انجام می‌دهند و چه نوع ویژگی‌هایی استخراج می شوند.

<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/></center>
<!-- **Fig 5:** Invariant Features through Lateral Inhibition
-->

**شکل 5:** ویژگی‌های ثابت از طریق بازدارندگی جانبی

<!--Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix $S$ is either determined by hand or learned so as to maximise this term. If the terms in $S$ are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuroscience). Thus, you try to find a value for $S$ that is as large as possible.
-->

در اینجا، یک دیکودر خطی با خطای بازسازی مربع (توان دو) وجود دارد. یک معیار در انرژی وجود دارد. ماتریس $S$ یا با دست تعیین می شود یا به گونه ای آموخته می شود که این اصطلاح را به حداکثر برساند. اگر اصطلاحات در $S$ مثبت و بزرگ باشند، این بدان معنا است که سیستم نمی خواهد $z_i$ و $z_j$ به طور همزمان روشن باشند. بنابراین، این نوعی بازدارندگی متقابل است (بازدارندگی طبیعی در علوم اعصاب نامیده می شود). بنابراین شما سعی می کنید مقداری برای $S$ پیدا کنید که تا حد ممکن بزرگ باشد.

<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
<!-- **Fig 6:** Invariant Features through Lateral Inhibition (Tree Form)
-->

**شکل 6:** ویژگی های ثابت از طریق بازدارندگی جانبی (فرم درخت)

<!--If you organise S in terms of a tree, the lines represent the zero terms in the $S$ matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features except those which are up the tree or down the tree from it. This is something like the converse of group sparsity.
-->

اگر S را از نظر یک درخت سازماندهی کنید، خطوط، نمایانگر اصطلاحات صفر در ماتریس $S$ هستند. هر وقت خطی نداشته باشید، اصطلاحی غیر صفر وجود دارد. بنابراین، هر ویژگی از تمام ویژگی‌های دیگر بازدارندگی می کند، به جز ویژگی‌هایی که در بالای درخت یا پایین درخت از آن قرار دارند. این چیزی شبیه برعکس پراکنده‌گی گروه بودن است.

<!--You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition.
-->

بار دیگر می‌بینید که سیستم‌ها کم و بیش به صورت پیوسته ویژگی‌ها را سازمان‌دهی می‌کنند. خصوصیات در امتداد یک شاخه درخت نمایانگر همان ویژگی با سطوح مختلف انتخاب هستند. ویژگی‌های پیرامون حاشیه کم و بیش به طور پیوسته تغییر‌ می‌کنند زیرا هیچ بازدارندگی‌ای وجود ندارد.

<!--To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger.
-->

برای آموزش این سیستم، در هربار تکرار، شما یک $x$ می‌دهید و $z$ را پیدا می کنید که عملکرد این تابع انرژی را به حداقل می رساند. سپس برای به روزرسانی $W$، یک مرحله از گرادیان کاهشی را انجام دهید. برای بزرگتر کردن اصطلاحات در $S$ می‌توانید یک مرحله گرادیان افزایشی نیز انجام دهید.
