---
lang-ref: ch.06-2
lang: fa
lecturer: Yann LeCun
title: RNNها، GRUها، LSTMها، توجه، Seq2Seq و شبکه‌های حافظه‌ای
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 Mar 2020
translation-date: 3 Oct 2020
translator: Alireza Moradi
---

<!--
In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.

As with what we saw with convolutional networks, network architecture is important.
-->
## [معماری‌های یادگیری عمیق](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

در یادگیری عمیق،‌ ماژول‌های مختلفی برای یادگیری توابع مختلف وجود دارد. تخصص در یادگیری عمیق شامل طراحی معماری‌هایی برا تکمیل وظایفی خاص است. مشابه با نوشتن برنامه‌ها با الگوریتم‌ها برای دادن دستورات به کامپیوتر در گذشته، یادگیری عمیق یک تابع پیچیده را به یک گراف از ماژول‌های عملکردی (احتمالا پویا)، که توابع آن‌ها با آموزش نهایی می‌شوند، کاهش می‌دهد. 

مشابه با چیزی که با شبکه‌های کانولوشنال دیدیم، معماری شبکه حائز اهمیت است.

<!--
## Recurrent Networks

In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.

As shown in Figure 1, there are loops in Recurrent Neural Networks.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figure 1. Recurrent Neural Network with roll
</center>

 - $x(t)$ : input that varies across time
 - $\text{Enc}(x(t))$: encoder that generates a representation of input
 - $h(t)$: a representation of the input
 - $w$: trainable parameters
 - $z(t-1)$: previous hidden state, which is the output of the previous time step
 - $z(t)$: current hidden state
 - $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
 - $\text{Dec}(z(t))$: decoder that generates an output
-->

## شبکه‌های بازگشتی

در یک شبکه‌ی عصبی کانولوشنال، گراف اتصالات نمی‌توانست حلقه داشته باشد. حداقل یک ترتیب جزئی در میان ماژول‌ها وجود دارد که ورودی‌ها در هنگام محاسبه‌ی خروجی‌ها در دسترس هستند.

همانطور که در شکل ۱ نشان داده شده، در شبکه‌های عصبی بازگشتی حلقه وجود دارد.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
شکل ۱: شبکه‌ی عصبی بازگشتی با رول
</center>

- $x(t)$ : ورودی که با گذر زمان تغییر می‌کند
- $\text{Enc}(x(t))$: انکودر که نمایشی از ورودی تولید می‌کند
- $h(t)$: نمایشی از ورودی
- $w$: پارامترهای قابل آموزش
- $z(t-1)$: حالت مخفی پیشین، که خروجی گام زمانی قبلی است
- ${z(t)}$: حالت مخفی فعلی
- $g$: تابعی که می‌تواند یک شبکه‌ی عصبی پیچیده باشد و یکی از ورودی‌ها ${z(t-1)}$ است که خروجی گام زمانی پیشین است
- $\text{Dec}(z(t))$: دیکودر که یک خروجی را تولید می‌کند

<!--
## Recurrent Networks: Unroll the loop

Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$.

<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figure 2. Recurrent Networks with unrolled loop
</center>

In Figure 2, the input is $x_1, x_2, x_3$.

At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.

As there are no loops in this network, and we can implement backpropagation.

Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.

BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN.

Problems with RNNs:

1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work.

One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.

An example that has vanishing gradient problem:

The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program.
-->

## شبکه‌های عصبی بازگشتی: باز کردن حلقه

حلقه را در زمان باز کنید. ورودی یک دنباله است $x_1, x_2, \cdots, x_T$.

<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
شکل ۱: شبکه‌های عصبی بازگشتی با حلقه‌ی باز شده
</center>

در شکل ۲ ورودی ${x_1, x_2, x_3}$ است.

در زمان t=0 ورودی $x(0)$ به انکودر داده شده و انکودر نمایش $h(x(0)) = \text{Enc}(x(0))$ را تولید کرده و سپس آن را به G داده تا حالت مخفی $z(0) = G(h_0, z', w)$ را تولید کند. در t = 0، $z'$ در G می‌تواند با 0 یا تصادفی مقدار دهی شود. $z(0)$ به دیکودر داده شده تا یک خروجی و همچنین گام زمانی بعدی تولید شوند.

حلقه‌ای در این شبکه وجود ندارد و می‌توانیم پس انتشار را پیاده‌سازی کنیم.

شکل ۲ یک شبکه‌ی معمولی با یک مشخصه به خصوص را نشان می‌دهد: همه‌ی بلوک‌ها وزن‌های یکسانی دارند. سه انکودر، دیکودر و توابع G به ترتیب وزن‌های یکسانی در گام‌های زمانی مختلف دارند.

پس انتشار در زمان(BPTT): متاسفانه BPTT در فرم ساده‌ی RNN عملکرد خوبی ندارد.

مشکلات RNNها:

1. گرادیان‌های محو شونده:
- در یک دنباله‌ی طولانی، گرادیان‌ها در هر گام زمانی در ماتریس وزن(ترانهاده) ضرب می‌شوند. اگر اعداد موجود در ماتریس وزن کوچک باشند، میانگین گرادیان‌ها بصورت نمایی کاهش می‌یابد.
2. گرادیان‌های منفجر شونده:
- اگر یک ماتریس وزن بزرگ داشته باشیم و غیر خطی بودن موجود در لایه‌ی بازگشتی اشباع نشده باشد، گرادیان‌ها منفجر می‌شوند. وزن‌ها در گام بروزرسانی واگرا می‌شوند. ممکن مجبور باشیم نرخ یادگیری را خیلی کوچک در نظر بگیریم تا کاهش گرادیان به درستی کار کند.

یکی از دلایل استفاده از RNNها به علت مزیت به خاطر داشتن اطلاعات گذشته است. با این حال،‌ ممکن است یک RNN ساده بدون ترفند، نتواند اطلاعات خیلی قدیمی را به خاطر بسپارد.

یک مثال که گرادیان محو شونده دارد:

ورودی کاراکترهای یک برنامه به زبان C است. سیستم خواهد گفت آیا ورودی از لحاظ نحوی یک برنامه‌ی درست است یا خیر. یک برنامه‌ی درست از لحاظ نحوی، باید تعداد درستی از آکولاد و پرانتزها داشته باشد. بدین ترتیب، شبکه باید به خاطر داشته باشد که چه تعداد آکولاد و پرانتز باز شده وجود دارد که باید چک شوند که آیا همگی آن‌ها بسته شده‌اند یا نه. شبکه باید این اطلاعات را مانند یک شمارنده در حالت‌های مخفی ذخیره کند. با این حال، به خاطر گرادیان‌های محو شونده، شبکه نمی‌تواند این اطلاعات را برای یک برنامه‌ی طولانی نگهدارد.

<!--
##  RNN Tricks

- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix.
-->

## ترفندهای RNN

- قطع کردن گرادیان‌ها: (جلوگیری از گرادیان‌های منفجر شونده)
وقتی گرادیان‌های خیلی بزرگ می‌شوند آن‌ها را له کنیم.
- مقداردهی (تخمین درست از انفجار/محو شدن گرادیان‌ها جلوگیری می‌کند)
‍ماتریس وزن‌ها را طوری مقدار دهی کنیم که میانگین آن‌ها کمتر از یک حد بالا باشد. برای مثال، مقدار دهی عمودی ماتریس وزن را به صورت یک ماتریس متعامد مقدار دهی می‌کند.

<!--
## Multiplicative Modules

In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.

Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor.

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$
 
where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.

Hypernetwork architecture: weights are computed by another network.
-->

## ماژول‌های ضربی

در ماژول‌های ضربی بجای این که جمع وزن‌دار ورودی‌ها محاسبه شود، حاصل ضرب‌های ورودی‌ها را محاسبه و سپس جمع وزن‌دار آن را محاسبه می‌کنیم.

فرض کنید $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. در اینجا U یک تنسور است.

<div dir="ltr"> 
$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$
</div>

که $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$ است.

خروجی سیستم جمع وزن‌دار ورودی‌ها و وزن‌ها است. وزن‌ها خودشان برابر جمع وزن‌دار وزن‌ها و ورودی‌ها هستند.

معماری ابرشبکه: وزن‌ها خودشان توسط یک شبکه‌ی دیگر محاسبه می‌شوند.

<!--
## Attention

$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.

$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.

By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.

The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.

Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.

The weights are data independent because z is data independent.
-->

## توجه (Attention)

$x_1$ و $x_2$ وکتور هستند. $w_1$ و $w_2$ اعداد بعد از softmax هستند که $w_1 + w_2 = 1$ و $w_1$ و $w_2$ بین 0 و 1 هستند.

$w_1x_1 + w_2x_2$ جمع وزن‌دار $x_1$ و $x_2$ که توسط ضرایب $w_1$ و $w_2$ وزن‌دار شده‌اند، است.

با تغییر اندازه‌ی نسبی $w_1$ و $w_2$ می‌توانیم خروجی  $w_1x_1 + w_2x_2$ را به $x_1$ یا $x_2$ یا یک ترکیب خطی از $x_1$ و $x_2$ تغییر دهیم.

ورودی‌ها می‌توانند چندین وکتور $x$ داشته باشند (بیشتر از $x_1$ و $x_2$). سیستم ترکیب مناسب را انتخاب خواهد کرد، انتخابی که توسط یک متغیر دیگر به نام z به دست می‌آید. مکانیزم توجه به شبکه‌ی عصبی اجازه می‌دهد که توجه خود را بر روی یک سری ورودی خاص گذاشته و بقیه را در نظر نگیرد.

توجه بطور افزایشی در سیستم‌های NLP (پردازش زبان طبیعی) که از معماری‌های مبدل یا دیگر انواع توجه استفاده می‌کنند مهم شده است.

وزن‌ها مستقل از داده هستند چون متغیر z مستقل از داده است.

<!--
## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. Gated Recurrent Unit
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.

To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.

The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input.
-->

## [واحد دروازه‌دار بازگشتی (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

همانطور که در بالا اشاره شد، RNN مشکلات گرادیان‌های محو شونده/منفجر شونده و عدم توانایی به خاطر سپردن حالت‌ها در طولانی مدت را دارد. GRU، [Cho, 2014](https://arxiv.org/abs/1406.1078), یک کاربرد از ماژول‌های ضربی است که سعی در حل این مشکلات دارد. GRU یک مثال از شبکه‌ی بازگشتی با حافظه است(یکی دیگر از این مثال‌ها LSTM است). ساختار یک واحد GRU به صورت زیر است:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. واحد دروازه‌دار بازگشتی(GRU)
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

که در آن ${\odot}$ نشانگر ضرب دانه-دانه، ${x_t}$ وکتور خروجی، ${z_t}$ وکتور دروازه‌ی آپدیت، ${r_t}$ وکتور دروازه‌ی ریست، ${\phi_h}$ تانژانت هیپربولیک، و ${W}$، ${U}$ و ${b}$ پارامتر‌های قابل آموزش هستند.

در اصل، ${z_t}$ یک وکتور دروازه‌ای است که نشان می‌دهد چه مقدار از اطلاعات گذشته باید به آینده انتقال پیدا کند. این وکتور یک تابع sigmoid بر روی مجموع دو لایه‌ی خطی و یک بایاس بر روی ورودی ${x_t}$ و حالت قبلی ${h_{t-1}}$ اعمال می‌کند.در نتیجه‌ی اعمال تابع sigmoid، ${x_t}$ دارای ضرایبی بین 0 و 1 می‌شود. حالت خروجی نهایی ${h_t}$ یک ترکیب محدب از ${h_{t-1}}$ و ${\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h}$ با ${z_t}$ است. اگر ضریب 1 باشد، خروجی واحد فعلی یک کپی از حالت قبلی خواهد بود و  ورودی در نظر گرفته نمی‌شود (که حالت پیش فرض همین است). اگر کمتر از 1 باشد، یک سری اطلاعات جدید از ورودی را نیز در نظر می‌گیرد.

دروازه‌ی ریست ${r_t}$ تصمیم می‌گیرد که چه مقدار از اطلاعات گذشته فراموش شوند. در داده‌های جدید حافظه ${\phi_h(W_hx_t + U_h(r_t\odot h_{t-1} + b_h)}$، اگر ضریب داخل ${r_t}$ صفر باشد، هیچ کدام از اطلاعات گذشته ذخیره نمی‌شوند. اگر در یک لحظه ${z_t}$ هم صفر باشد، سیستم به طور کامل ریست می‌شود، چون ${h_t}$ فقط به ورودی نگاه می‌کند.

<!--
## LSTM (Long Short-Term Memory)

GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figure 4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.

An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.

Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers.
-->

## حافظه‌ی کوتاه مدت بلند (Long Short-Term Memory)

GRU در حقیقت نسخه‌ی ساده شده‌ای از LSTM که زودتر منتشر شده بود است،[Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). با ساختن سلول‌های حافظه برای نگهداری از اطلاعات گذشته، LSTM سعی کرده مشکل از دست رفتن اطلاعات در طولانی مدت در RNNها را نیز رفع کند. ساختار LSTM بصورت زیر است:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figure 4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

که در آن ${\odot}$ نشانگر ضرب دانه-دانه، ${x_t\in\mathbb{R}^a}$ یک وکتور ورودی به واحد LSTM، ${f_t\in\mathbb{R}^h}$ وکتور فعالسازی دروازه‌ی فراموشی، ${i_t\in\mathbb{R}^h}$ وکتور فعالسازی دروازه‌ی ورودی/آپدیت، ${o_t\in\mathbb{R}^h}$ وکتور فعالسازی دروازه‌ی خروجی، ${h_t\in\mathbb{R}^h}$ وکتور حالت مخفی (که با نام خروجی نیز آن را می‌شناسیم) و ${c_t\in\mathbb{R}^h}$ وکتور حالت سلول است.

یک واحد LSTM از وکتور حالت سلول ${c_t}$ برای حمل اطلاعات در طول سلول استفاده می‌کند. این وکتور میزان نگه داشتن یا حذف کردن اطلاعات از حالت سلول را تنظیم می‌کند. دروازه‌ی فراموشی ${f_t}$ درباره‌ی این که چه مقدار اطلاعات را از حالت سلول پیشین ${c_{t-1}}$ را می‌خواهیم نگه داریم، با نگاه کردن به ورودی فعلی و حالت مخفی پیشین و تولید کردن یک عدد بین 0 و 1 به عنوان ضریب ${c_{t-1}}$، تصمیم می‌گیرد. ${\tanh(W_cx_t + U_ch_{t-1} + b_c)}$ یک کاندید جدید برای آپدیت کردن حالت سلول محاسبه می‌کند،  و همانند دروازه‌ی فراموشی، دروازه‌ی ورودی ${i_t}$ تصمیم می‌گیرد که چه مقدار از آپدیت اعمال شود. در نهایت،‌ خروجی ${h_t}$ بر اساس حالت سلول ${c_t}$ خواهد بود، ولی از یک ${\tanh}$ عبور کرده و توسط دروازه‌ی خروجی ${o_t}$ فیلتر خواهد شد.

با اینکه LSTMها در پردازش زبان طبیعی(NLP) به وفور استفاده می‌شوند، محبوبیت آن‌ها رو به کاهش است. برای مثال، تشخیص گفتار در حال حرکت به سمت استفاده از CNN زمانی است، و NLP در حال حرکت به سمت استفاده از ترنسفورمرها است.

<!--
## Sequence to Sequence Model

The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center>

Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.

This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information.
-->

## مدل دنباله به دنباله (Sequence to Sequence)

این روش که برای اولین بار توسط [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) ارائه شد، اولین سیستم ترجمه‌ی ماشینی عصبی بود که کارایی آن با روش‌های کلاسیک قابل مقایسه بود. این روش از یک معماری انکودر-دیکودر استفاده می‌کند که هر دوی انکودر و دیکودر LSTMهای چند لایه هستند.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center>

هر سلولی که در عکس می‌بینید یک LSTM است. برای انکودر(قسمتی که در سمت چپ است)، تعداد گام‌های زمانی برابر طول جمله‌ای که باید ترجمه شود، است. در هر گام، یک پشته از LSTMها داریم(۴ تا در مقاله) که حالت مخفی LSTM قبلی وارد بعدی می‌شود. آخرین لایه از آخرین گام زمانی یک وکتور که نمایانگر معنای کل جمله است را خروجی می‌دهد که سپس وارد یک LSTM چند لایه (دیکودر) می‌شود، که در این مرحله زبان مورد نظر تولید می‌شود. در دیکودر، متن به روش توالی (Sequence) ساخته می‌شود. هر گام یک کلمه تولید می‌کند، که به عنوان ورودی به گام زمانی بعدی داده می‌شود.

این معماری به دو دلیل رضایت بخش نیست: اول، تمام معنای یک جمله باید وارد حالت مخفی بین دیکودر و انکودر فشرده شود. دوم، LSTMها در حقیقت اطلاعات را برای بیش از ۲۰ کلمه حفظ نمی‌کنند. راه حل این مشکل LSTM دو طرفه (Bi-LSTM) است، که دو LSTM را در جهت‌های مخالف قرار می‌دهد. در یک LSTM دو طرفه معنا در دو وکتور انکود می‌شود، یکی که توسط LSTM چپ به راست ساخته شده و دیگری توسط LSTM راست به چپ. این کار به ما اجازه می‌دهد که طول جمله را بدون از دست دادن اطلاعات دو برابر کنیم.

<!--
## Seq2seq with Attention

The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, *i.e.* the attention mechanism.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq with Attention
</center>

In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!

Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention.
-->

## Seq2seq با «توجه»

موفقیت روش بالا کوتاه بود. مقاله‌ای دیگر توسط  [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473) پیشنهاد می‌کرد که به جای یک شبکه‌ی غول پیکر که معنای کل جمله را در یک وکتور می‌فشرد، بهتر است که اگر در هر گام  زمانی توجه را فقط بر روی مکان‌های مربوط در زبان اصلی با معنای مرتبط متمرکز کنیم. که با نام مکانیزم توجه شناخته می‌شود.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq با توجه
</center>

در توجه، برای تولید کلمه در هر گام زمانی، ابتدا تصمیم می‌گیریم که بر روی کدام نمایانگر مخفی از کلمه‌های موجود در جمله‌ی ورودی تمرکز کنیم. اساسا یک شبکه یاد می‌گیرد که میزان تطابق هر ورودی انکود شده با خروجی فعلی از دیکودر را بسنجد. این سنجش با یک نمره‌دهی انجام می‌شود که توسط softmax نرمالسازی شده، سپس ضرایب آن برای محاسبه‌ی جمع وزن‌دار حالت‌های مخفی انکودر در گام‌های زمانی مختلف استفاده می‌شوند. با تنظیم کردن وزن‌ها، سیستم می‌تواند مکان‌های ورودی برای تمرکز کردن را تنظیم کند. جادوی این مکانیزم آن است که می‌توان شبکه‌ای که این ضرایب را محاسبه می‌کند را می‌توان توسط پس انتشار آموزش داد. نیازی به ساختن آن‌ها به صورت دستی نیست!

مکانیزم‌های توجه به طور کامل ترجمه‌ی ماشینی عصبی را دگرگون کردند. بعد تر، گوگل یک مقاله منتشر کرد [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762)، و ترنسفورمر را جلو گذاشتند، که هر لایه و گروه از نورون‌ها توجه را پیاده‌سازی می‌کنند.

<!--
## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.

The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.

For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. Memory Network
</center>

If one of the keys (*e.g.* $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.

This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.

What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.

This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.

The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks.
-->

## [شبکه‌ی حافظه‌ای](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

شبکه‌های حافظه‌ای ریشه در کاری که در Facebook شروع شد ( [Antoine Bordes](https://arxiv.org/abs/1410.3916) در سال ۲۰۱۴ و [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) در سال ۲۰۱۵) دارند.

ایده‌ی شبکه‌های حافظه‌ای این است که دو بخش مهم در مغز شما وجود دارند: یکی cortex است که حافظه‌ی بلند مدت اینجا است. یه دسته‌ی جداگانه از نورون‌ها به نام **hippocampus** وجود دارند که سیم‌هایی را به تقریبا همه‌جای cortex می‌فرستند. تصور می‌شود که از hippocampus برای حافظه‌ی کوتاه مدت استفاده می‌شود، که اطلاعات را برای زمانی کوتاه به خاطر می‌آورد. تئوری رایج این است که زمانی که می‌خوابید، مقدار زیادی اطلاعات از hippocampus به cortex منتقل می‌شود تا در حافظه‌ی بلند مدت ثبت شوند، زیرا hippocampus ظرفیت محدودی دارد.

برای یک شبکه‌ی حافظه‌ای، یک ورودی به شبکه وجود دارد، ${x}$ (به عنوان یک آدرس در حافظه به آن نگاه کنید)، این ${x}$ را با وکتور‌های ${k_1, k_2, k_3, \cdots}$ («کلیدها») توسط ضرب داخلی مقایسه می‌کند. سپس آن‌ها را از softmax عبور دهید و نتیجه یک آرایه از اعداد است که مجموع آن‌ها ۱ خواهد بود. تعدادی وکتور دیگر ${v_1, v_2, v_3, \cdots}$ («مقادیر») نیز وجود دارند. این وکتور‌ها را در مقیاس‌های softmax ضرب کنید و مجموع این وکتورها (شباهت آن با مکانیزم توجه را ببینید) نتیجه را به شما خواهد داد.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. شبکه‌ی حافظه‌ای
</center>

اگر یکی از کلیدها (مثل ${k_i}$) دقیقا با ${x}$ مطابقت کند، ضرایب مرتبط با این کلید بسیار به 1 نزدیک خواهند بود. پس خروجی سیستم اساسا ${v_i}$ خواهد بود.

این **حافظه‌ی انجمنی آدرس‌پذیر** است. حافظه‌ی انجمنی آن است که اگر ورودی شما با یک کلید مطابقت کند، شما *آن* مقدار را می‌گیرید. و این نسخه فقط یک متمایز کننده‌ی نرم است، که به شما اجازه‌ی پس انتشار و تغییر وکتورها با استفاده از کاهش گرادیان را می‌دهد.

کاری که نویسندگان کرده بودند این بود که یک داستان برای سیستم، با دادن توالی‌ای از جملات به آن، تعریف کرده بودند. جملات با گذراندن از یک شبکه‌ی عصبی که از قبل آموزش ندیده، به وکتور‌هایی انکود می‌شوند. جملات به حافظه‌ای از این نوع برگردانده می‌شوند. وقتی شما یک سوال از سیستم می‌پرسید، شما سوال را انکود کرده و به عنوان ورودی به شبکه‌ی عصبی می‌دهید، شبکه‌ی عصبی یک ${x}$ به حافظه می‌دهد، و حافظه مقدار را برمی‌گرداند.

این مقدار، به همراه حالت قبلی شبکه، برای دسترسی دوباره به حافظه استفاده می‌شود. و شما این شبکه را آموزش می‌دهید تا یک پاسخ به سوال شما تولید کند. پس از آموزش گسترده، مدل یا می‌گیرد که داستان‌ها را ذخیره کرده و به سوالات پاسخ دهد.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

در شبکه‌ی حافظه‌ای، یک شبکه‌ی عصبی وجود دارد که یک ورودی گرفته و سپس یک آدرس برای حافظه تولید کرده، مقدار را به شبکه باز گردانده، و به همین صورت جلو رفته و در نهایت یک خروجی تولید می‌کند. این بسیار شبیه به یک کامپیوتر است چون یک CPU و یک حافظه‌ی خارجی برای خواندن و نوشتن وجود دارد.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>


Figure 8. مقایسه بین شبکه‌ی حافظه‌ای و کامپیوتر (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

افرادی وجود دارند که تصور می‌کنند می‌شود **کامپیوترهای تغییر پذیر** از این‌ها ساخت. یک مثال مقاله‌ی [Neural Turing Machine](https://arxiv.org/abs/1410.5401) از DeepMind است، که سه روز پس از انتشار مقاله‌ی Facebook برروی arXiv، به صورت عمومی منتشر شد. 

ایده‌ آن است که ورودی‌ها را با کلیدها مقایسه کرده، ضرایب را تولید کرده، و مقادیر را تولید کنیم - که در حقیقت همان ترنسفورمر است. ترنسفورمر یک شبکه‌ی عصبی است که در آن هر گروه از نورون‌ها یکی از این شبکه‌ها است.
