---
lang-ref: ch.06-1
lang: fa
lecturer: Yann LeCun
title: کاربردهای شبکه‌ی کانولوشن
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
translation-date: 21 Sep 2020
translator: Alireza Moradi
---

 <!--
In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network.
-->

## [تشخیص‌دهی کد پستی](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

در درس قبل، نشان دادیم که شبکه‌ی کانولوشن می‌تواند ارقام را تشخیص دهد، هرچند، سوالی که باقی می‌ماند این است که  مدل چگونه هر رقم را انتخاب می‌کند و از ایجاد اختلال روی ارقام کناری پرهیز می‌کند. قدم بعدی تشخیص اشیاء بدون اشتراک و استفاده از روش Non-Maxmimum Suppression (NMS) است. حالا با این فرض که ورودی یک سری از ارقام بدون اشتراک است، استراتژی، آموزش دادن چندین شبکه‌ی کانولوشن و استفاده از بیشترین رای یا انتخاب کردن ارقام با بالاترین نمره‌ای که شبکه کانولوشن تولید کرده است می‌باشد.  

<!--
### Recognition with CNN

Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center>

Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit.
-->

### تشخیص‌‌دهی با شبکه‌ی عصبی کانولوشنال (CNN)
در اینجا ما وظیفه‌ی تشخیص دادن ۵ کد پستی بدون اشتراک را ارائه می‌کنیم. به سیستم هیچگونه دستوری مبنی بر چگونگی جدا کردن هر رقم داده نشده ولی می‌داند که باید ۵ رقم را پیش‌بینی کند. سیستم (شکل ۱) تشکیل شده از ۴ شبکه‌ی کانولوشن با سایزهای متفاوت است که هرکدام یک مجموعه از خروجی‌ها را تولید می‌کند. خروجی بصورت تعدادی ماتریس نمایش داده می‌شود. ۴ ماتریس خروجی از مدل‌هایی با سایز کرنل متفاوت در لایه‌ی آخر هستند. در هر خروجی ۱۰ ردیف وجود دارد که نشان‌دهنده‌ی ۱۰ دسته از ۰ تا ۹ هستند. مربع سفید بزرگتر نشان‌دهنده‌ی نمره‌ی بالاتر در آن دسته است. در این ۴ بلوک خروجی، اندازه‌های افقی کرنل‌های لایه‌ی آخر به ترتیب ۵ و ۴ و ۳ و ۲ هستند. اندازه‌ی کرنل تصمیم می‌گیرد که پهنای پنجره‌ای که مدل از درون آن ورودی را می‌بیند چقدر باشد، در نتیجه هر مدل بر اساس اندازه‌ی پنجره‌ی متفاوت در حال پیش‌بینی رقم خروجی است. سپس مدل بیشترین رأی را در نظر گرفته و دسته‌ای را انتخاب می‌کند که به بیشترین نمره در آن پنجره اشاره می‌کند. برای استخراج اطلاعات مفید،‌ باید در نظر داشته باشیم که همه‌ی جایگشت‌های کاراکترها امکان‌پذیر نیستند، در نتیجه برای اطمینان از صحیح بودن کدهای پستی خروجی، تصحیح خطایی که بر روی ورودی محدودیت اعمال می‌کند، مفید خواهد بود. 

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>شکل ۱:</b> چندین دسته‌بند مختلف بر روی تشخیص کد پستی
</center>

حالا می‌خواهیم ترتیب کاراکترها را معلوم کنیم. روش آن بکارگیری یک الگوریتم مسیریابی است. به دلیل آنکه ما یک محدوده از کاراکترهای امکان‌پذیر و تعداد کاراکترهایی که باید پیش‌بینی کنیم را داریم، می‌توانیم این با این مسئله به عنوان مسئله‌ی محاسبه‌ی کمترین هزینه‌ی تولید رقم‌ها و گذارهای بین رقم برخورد کنیم. مسیر باید پیوسته و از سلول پایین سمت چپ به سلول بالا سمت راست روی گراف باشد. مسیر محدود شده تا فقط حرکت از چپ به راست و پایین به بالا داشته باشد. در نظر داشته باشید که اگر یک عدد در کنار هم تکرار شده باشد، الگوریتم به جای پیش‌بینی یک رقم باید بتواند تشخیص دهد که اعداد تکرار شونده وجود دارد.

<!--
## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist.


- **False Positives**: There are many different variations of non-face objects that may appear in a patch of an image. During the training stage, the model may not see all of them (*i.e.* a fully representative set of non-face patches). Therefore, the model may suffer from a lot of false positives at test time. For example, if the network has not been trained on images containing hands, it may detect faces based on skin tones and incorrectly classify patches of images containing hands as faces, thereby giving rise to false positives.

- **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost.

-->


## [تشخیص چهره](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

شبکه‌های عصبی کانولوشنال بر روی وظایف تشخیص به خوبی عمل می‌کنند و تشخیص چهره هم از این وظایف مستثنا نیست. برای انجام تشخیص چهره، دیتاستی از تصاویری با چهره و بدون چهره جمع آوری میکنیم، و شبکه‌ی کانولوشنی با اندازه‌ی پنجره‌ی ${30 \times 30}$ پیکسل را برروی آن آموزش داده و از شبکه میخواهیم که بگوید آیا چهره‌ای در عکس وجود دارد یا خیر. پس از آموزش، مدل را بر روی یک تصویر جدید با پنجره‌ی ${30 \times 30}$ پیکسل اعمال می‌کنیم، شبکه‌ی کانولوشنال خروجی‌ها را در مکان‌های مربوطه روشن می‌کند. با این حال دو مشکل وجود دارد.


- **مثبت‌های کاذب:** انواع مختلفی از اشیای غیر-صورت وجود دارند که ممکن است در بخشی از یک تصویر وجود داشته باشند. در مرحله‌ی آموزش، مدل ممکن است همه‌ی آن‌ها را نبیند (مثلا یک دسته‌ی نمایانگر بخش های غیر-صورت). برای همین مدل ممکن است از تعداد زیادی مثبت کاذب در زمان تست رنج ببرد. برای مثال، اگر شبکه بر روی تصاویری که شامل «دست» است آموزش ندیده باشد، ممکن است بر اساس رنگ پوست ان‌ها را به اشتباه «صورت» تشخیص داده و در نتیجه‌ی آن آمار مثبت‌های کاذب را بالا ببرد.

- **چهره‌های با اندازه‌های متفاوت:** همه‌ی چهره‌ها ${30 \times 30}$ پیکسل نیستند، چهره‌های با اندازه‌های متفاوت ممکن است تشخیص داده نشوند. یک راه برای حل این مشکل تولید چند مقیاس از یک تصویر است. تشخیص دهنده‌ی اصلی چهره‌های اطراف ${30 \times 30}$ پیکسل را تشخیص خواهد داد. اگر مقیاسی با مرتبه‌ی $\sqrt 2$ بر روی تصویر اعمال کنیم، مدل چهره‌هایی را تشخیص خواهد داد که در تصویر اصلی کوچک‌تر بودند چون ${30 \times 30}$ اکنون تقریبا ${20 \times 20}$ است. برای تشخیص چهره‌های بزرگ‌تر، می‌توانیم تصویر را کوچک کنیم. این روند کم هزینه است چون نیمی از هزینه از پردازش تصویر اصلی بدون مقیاس می‌آید. مجموع هزینه‌های همه‌ی شبکه‌های دیگر که باهم ترکیب شده‌اند تقریبا برابر با هزینه پردازش تصویر اصلی بدون مقیاس است. اندازه‌ی شبکه برابر با مربع اندازه‌ی عکس در یک طرف است، پس اگر عکس را با مقیاس $\sqrt 2$ کوچک کنید، شبکه‌ای که نیاز خواهید داشت تا اجرا کنید با مقیاس ۲ کوچک‌تر است. پس هزینه‌ی کلی $1+1/2+1/4+1/8+1/16…$ است که برابر با ۲ است. اعمال مدل چند مقیاسی تنها هزینه‌ی پردازشی را دو برابر خواهد کرد.

<!--
### A multi-scale face detection system

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center>

The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center>
-->

### یک سیستم تشخیص دهنده‌ی چهره‌ی چند مقیاسی

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>شکل ۲:</b> سیستم تشخیص دهنده‌ی چهره
</center>

تبدیلات نشان داده شده در شکل ۳ نشان دهنده‌ی نمره‌های تشخیص دهنده‌های چهره هستند. این شناسایی‌ کننده‌ی چهره، چهره‌هایی با اندازه‌‌ی ${20 \times 20}$ را تشخیص می‌دهد. در مقیاس آخر (مقیاس ۳) چندین نمره‌ی بالا وجود دارد ولی خیلی قطعی نیستند. وقتی مقیاس بالا می‌رود (مقیاس ۶) نواحی سفید خوشه‌بندی شده‌ی بیشتری می‌بینیم. این نواحی سفید نشان‌دهنده‌ی چهره‌های تشخیص داده شده هستند. سپس non-maximum suppression را اعمال می‌کنیم تا مکان نهایی چهره‌ها را بدست اوریم.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>شکل ۳:</b> نمره‌های تشخیص دهنده‌ی چهره برای چند مقیاس مختلف
</center>

<!---
### Non-maximum suppression

For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location.
-->

### Non-maximum suppression

برای هر ناحیه با نمره‌ی بالا، امکان دارد یک چهره وجود داشته باشد. اگه چهره‌های بیشتری، نزدیک به چهره‌ی اول، تشخیص داده شوند، این بدان معنا است که تنها یکی از آنها باید درست در نظر گرفته شده و باقی چهره‌ها اشتباه هستند. با non-maximum suppression ما از بین جعبه‌های محدود کننده، جعبه‌ی با بالاترین نمره را انتخاب کرده و بقیه را حذف می‌کنیم. نتیجه یک جعبه‌ی محدود کننده در مکان مطلوب خواهد بود.

<!--
### Negative mining

In the last section, we discussed how the model may run into a large number of false positives at test time as there are many ways for non-face objects to appear similar to a face. No training set will include all the possible non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches which the model has (erroneously) detected as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives.
-->

### استخراج منفی (Negative mining)

در بخش قبلی در مورد اینکه ممکن است مدل، در هنگام تست، وارد تعداد زیادی مثبت کاذب شود(به دلیل این که راه‌های زیادی هست که اشیاء غیر چهره شبیه به چهره به نظر بیایند.). هیچ داده‌ی آموزشی‌ای وجود ندارد که شامل تمام اشیای غیر چهره که شبیه به چهره هستند باشد. ما می‌توانیم این مشکل را با استخراج منفی کاهش دهیم. در استخراج منفی،‌ ما یک دیتاست منفی از اشیای غیر چهره که مدل به اشتباه چهره تشخیص داده را تولید می‌کنیم. این داده‌ها با اجرای مدل بر روی ورودی‌هایی که می‌دانیم هیچ چهره‌ای در آنها نیست جمع اوری می‌کنیم. سپس تشخیص دهنده را با دیتاست منفی دوباره آموزش می‌دهیم. می‌توانیم این روند را تکرار کنیم تا توان‌مندی مدل را در برابر مثبت‌های کاذب افزایش دهیم. 

<!--
## Semantic segmentation

Semantic segmentation is the task of assigning a category to every pixel in an input image.
-->

## تقسیم‌بندی معنایی (semantic segmentation)

تقسیم‌بندی معنایی وظیفه‌ی تخصیص یک دسته به هر پیکسل یک تصویر ورودی است.

<!--
### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center>

There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle.
-->

### [CNN برای بینایی ربات تطبیق‌پذیر دوربرد](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

در این پروژه، هدف برچسب‌گذاری نواحی از تصویر ورودی است تا یک ربات بتواند جاده‌ها را از موانع متمایز کند. در شکل، نواحی سبز رنگ جاهایی است که ربات می‌تواند روی آن حرکت کند و نواحی قرمز رنگ موانع (مانند علف بلند) هستند. برای آموزش شبکه برای این وظیفه، بخشی از یک تصویر را گرفتیم و به صورت دستی آنرا قابل عبور یا غیر قابل عبور (سبز یا قرمز) برچسب گذاری کردیم. سپس یک شبکه‌ی کانولوشنال را بر روی این تکه عکس‌ها با خواستن پیش‌بینی رنگ تکه عکس آموزش دادیم. زمانی که سیستم به اندازه کافی آموزش داده شد، آن را برروی کل تصویر اعمال می‌کنیم تا کل نواحی عکس را سبز یا قرمز برچسب گذاری کند.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>شکل ۴:</b> CNN برای بینایی ربات تطبیق‌پذیر دوربرد (DARPA LAGR program 2005-2008)
</center>

<!--
**Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it.
 -->
 
 **برچسب‌های استریو** (شکل ۴، ستون ۲)
 تصاویر توسط ۴ دوربین بر روی ربات، که بصورت ۲ گروه جفتی استریو هستند،  ثبت می‌شوند. با دانستن فاصله‌ی بین جفت دوربین استریو، مکان هر پیکسل در فضای سه بعدی، با اندازه‌گیری فاصله‌ی نسبی بین پیکسل‌هایی که در هر دو دوربین داخل جفت استریو هستند، تخمین زده می‌شود. این همان روشی است که مغز ما استفاده می‌کند تا فاصله‌ی بین اشیایی که ما می‌بینیم را تخمین بزند. با استفاده از اطلاعات مکانی تخمین زده شده، یک سطح بر روی زمین قرار داده می‌شود، و پیکسل‌هایی که نزدیک زمین هستند سبز و آنهایی که با زمین فاصله دارند قرمز برچسب‌گذاری می‌شوند. 

<!--
* **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center>
-->

* **محدودیت‌ها و محرک‌ برای شبکه‌ی کانولوشنال(ConvNet)**: دید استریو فقط تا ۱۰ متر جوابگو است و حرکت دادن یک ربات نیازمند داشتن دید دوربرد است. با این حال اگر یک شبکه‌ی کانولوشنال به درستی آموزش داده شود، قادر است اشیایی در فواصل بسیار دور را تشخیص دهد.

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>شکل ۵:</b> هرم فارغ از مقیاس از تصاویر نرمال‌سازی شده بر حسب فاصله
</center>

<!--
* **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales.
-->

* **خدمت به عنوان ورودی‌های مدل**: یک پیش-پردازش مهم شامل ساختن هرم فارغ از مقیاس از تصاویر نرمال‌سازی شده بر حسب فاصله (شکل ۵) است. این شبیه کاری است که قبل‌تر در این درس، زمانی که سعی کردیم چهره‌ها را با چندین مقیاس تشخیص دهیم، انجام دادیم. 

<!--
**Model Outputs** (Figure 4, Column 3)

The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network.
-->

**خروجی‌های مدل** (شکل ۴، ستون ۳)

مدل برای هر پیکسل داخل عکس **تا افق** یک برچسب خروجی می‌دهد. این‌ها خروجی‌های دسته‌بند (classifier outputs) یک شبکه کانولوشنال چند مقیاسی (multi-scale convolutional network) هستند.

<!--
* **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed.
-->
* **چگونگی تطبیق‌پذیر شدن مدل**: ربات‌ها به طور پیوسته به برچسب‌های استریو دسترسی دارند که اجازه می‌دهد شبکه دوباره آموزش ببیند و با محیط جدیدی که در آن قرار گرفته تطبیق پیدا کند. در نظر داشته باشید که تنها لایه‌ی آخر شبکه دوباره آموزش داده می‌شود. لایه‌های قبلی در آزمایشگاه آموزش داده شده و تغییر داده نمی‌شوند.

<!--
**System Performance**

When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away.
-->

**کارایی سیستم**

وقتی تلاش کردیم به یک مختصات جغرافیایی واقع در پشت یک مانع برویم، ربات مانع را از فاصله‌ی دور "دید" و مسیری را انتخاب کرد که مانع را دور می‌زد. این به خاطر تشخیص اشیاء تا ۵۰-۱۰۰ متر دورتر توسط CNN است.

<!--
**Limitation**

Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly.
-->

**محدودیت‌**

در سال‌های ۲۰۰۰ تا ۲۰۱۰، منابع محاسباتی محدود بودند. ربات قادر بود با سرعت حدود ۱ فریم بر ثانیه پردازش انجام دهد که بدان معنا بود که اگر فردی در مسیر ربات قرار می‌گرفت ۱ ثانیه طول می‌کشید تا ربات به آن واکنش نشان دهد. راه حل این محدودیت یک مدل **اودومتری بصری کم هزینه** است.

<!--
### Scene Parsing and Labelling

In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6).

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center>

Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.

However, sometimes this context size is not enough to determine the category for larger objects.
-->

### تجزیه‌ی صحنه و برچسب گذاری

در این کار،‌مدل برای هر پیکسل یک دسته‌بندی شی‌ئی (ساختمان‌ها، ماشین‌ها، آسمان و ...) خروجی می‌دهد. معماری آن نیز به صورت چند مقیاسی است (شکل ۶)

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>شکل ۶:</b> CNN چند مقیاسی برای تجزیه‌ی صحنه
</center>

توجه کنید که اگر یک خروجی از CNN را به ورودی پس انتشار دهیم، مانند یک پنجره‌ی ورودی با اندازه‌ی ${46 \times 46}$ بر روی تصویر موجود در پایین هرم لاپلاسی است. این بدان معنا است که ما **از زمینه‌ای با ${46 \times 46}$ پیکسل استفاده می‌کنیم تا در مورد دسته‌بندی پیکسل وسطی تصمیم‌گیری کنیم**.

با این حال بعضی اوقات این زمینه برای تصمیم‌گیری در مورد دسته‌بندی اشیای بزرگ‌تر کافی نیست.


<!--
**The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.


Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$.

**Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking.
-->

**روش چند مقیاسی با فراهم کردن تصاویر تغییر مقیاس داده شده‌ی اضافه به عنوان ورودی، دید وسیع‌تری به ربات می‌دهد.** مراحل به صورت زیر است:
1. یک تصویر یکسان را در نظر گرفته و آن را به صورت جداگانه با مقیاس ۲ و ۴ کاهش دهیم.
2. این تصاویر تغییر مقیاس داده شده‌ی اضافه به **همان شبکه‌ی کانولوشن قبلی**(وزن‌های یکسان، کرنل‌های یکسان) داده شده و دو مجموعه اجزای مرحله‌ ۲ دریافت می‌کنیم. 
3. این ویژگی‌ها را **بزرگ** می‌کنیم تا اندازه‌ای برابر با اجزای مرحله ۲ تصویر اصلی داشته باشند.
4. این سه مجموعه‌ی [بزرگ شده] از اجزا را **روی هم** قرار داده و به دسته‌بند (classifier) می‌دهیم.    


حال، بزرگ‌ترین اندازه‌ی موثر از محتوا، برابر با ${184 \times 184}$ است.(${46 \times 4 = 184}$)

**کارایی**: بدون پس پردازش و اجرای فریم به فریم، مدل حتی برروی سخت افزار استاندارد نیز بسیار سریع است. مدل، داده‌ی آموزشی نسبتا کوچکی (حدود ۲ تا ۳ هزار) دارد ولی نتایج رکورد شکننده هستند.
