---
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: جبرخطی و عملگرهای کانوُلوشِن
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
lang: fa
translation-date: 27 Sep 2020
translator: Erfan Miahi
---


<!-- ## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s) -->
## [مروری بر جبرِ خطی](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)


<!-- This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:-->
در این بخش به مرور جبر خطی مربوط به شبکه های عصبی میپردازیم. در ابتدا، معرفی ساده ای از لایه ی پنهان $\boldsymbol{h}$ که یکی از بخش های شبکه های عصبی است، ارائه می شود:

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!-- The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$: -->
خروجی این لایه، یک تابع غیرخطی به نام $f$ است که به بردار $z$ اعمال می شود. در اینجا، بردار $z$ خروجی اعمال تبدیل آفینِ $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ به بردار ورودیِ $\boldsymbol{x} \in\mathbb{R^n}$ است:

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!-- For simplicity biases are ignored. The linear equation can be expanded as: -->
برای سادگی فهم مطلب، متغیرهای بایاس در این معادله ها در نظر گرفته نشده اند. با در نظر گرفتن این مطلب، معاله ی خطی بالا به صورت زیر بسط داده می شود:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

<!-- where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$. -->
در این معادله، متغیر $\boldsymbol{a}^{(i)}$ سطر $i$ اُم ماتریس $\boldsymbol{A}$ است.

<!-- To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$. -->
برای فهم بهتر این تبدیل، به بررسی یکی از جزء های متغیر $\boldsymbol{z}$ مانند $a^{(1)}\boldsymbol{x}$ میپردازیم. با در نظر گرفتن $n=2$ خواهیم داشت $\boldsymbol{a} = (a_1,a_2)$ و $\boldsymbol{x}  = (x_1,x_2)$.

<!-- $\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as: -->
در ادامه، تصور کنید که $\boldsymbol{a}$ و $\boldsymbol{x}$ به عنوان بردارهایی در دستگاه مختصات دو بعدی کشیده شده اند. حال، زاویه بین $\boldsymbol{a}$ و $\hat{\boldsymbol{\imath}}$ را $\alpha$ و همچنین زاویه بین $\boldsymbol{x}$ و $\hat{\boldsymbol{\imath}}$ را $\xi$ در نظر بگیرید. با توجه به این مطالب، فرمول مثلثاتی $a^\top\boldsymbol{x}$ به صورت زیر خواهد بود:

$$ \begin {aligned} \boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\ &=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\ &=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\ &=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha) \end {aligned} $$

<!-- The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can be understood by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.-->
خروجی معادله ی بالا در اصل میزان هم ترازی بردار ورودی را با سطر مشخصی از ماتریس $\boldsymbol{A}$ اندازه گیری می کند. برای فهم بهتر این مطلب میتوان به زاویه ی بین این دو بردار که $\xi-\alpha$ است، توجه کرد. زمانی که $\xi = \alpha$ و این دو بردار کاملا روی هم قرار می گیرند، بیشترین مقدار از این معادله حاصل می شود. اما، اگر $\xi - \alpha = \pi$ باشد یا به عبارتی دو بردار در جهت مخالف هم قرار گیرند، معادله $\boldsymbol{a}^\top\boldsymbol{x}$ به کمترین مقدار خود می رسد. در اصل، این نگاشت خطی به ما اجازه میدهد تا تصویر یک بردار ورودی را در جهت های مختلفی که با ماتریس $A$ تعریف شده است، مشاهده کنیم. چنین بینشی قابل بسط دادن به بعد های بیشتر نیز هست.

<!-- Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:-->
راه دیگری که برای فهم این نگاشت خطی وجود دارد، فهمیدن این مطلب است که بردار $\boldsymbol{z}$ را میتوان به صورت زیر نیز بسط داد:

$$ \boldsymbol{A}\boldsymbol{x} = \begin{pmatrix} \vert & \vert & & \vert \ \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n \ \vert & \vert & & \vert \ \end{pmatrix} \begin{matrix} \rvert \ \boldsymbol{x} \ \rvert \end{matrix} = x_1 \begin{matrix} \rvert \ \boldsymbol{a}_1 \ \rvert \end{matrix} + x_2 \begin{matrix} \rvert \ \boldsymbol{a}_2 \ \rvert \end{matrix} + \cdots + x_n \begin{matrix} \rvert \ \boldsymbol{a}_n \ \rvert \end{matrix} $$

<!-- The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.-->
خروجی این معادله جمع وزنی ستون های ماتریس $\boldsymbol{A}$ است. با توجه به این، این سیگنال فقط ترکیبی از ورودی هاست.

<!-- ## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s) -->
## [بسط دادن جبر خطی به عملگر کانوُلوشِن](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!-- Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: -->
در این بخش با ارائه دادن مثال های مربوط به تحلیل داده های صوتی، به بسط دادن جبر خطی به عملگر کانوُلوشِن می پردازیم. این مبحث را با ارائه کردن یک لایه تماماً متصل که به شکل ضرب ماتریسی نمایش داده شده است، شروع می کنیم:

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$. -->
در این مثال، ابعاد ماتریس وزن ها $4 \times 3$، ابعاد بردار ورودی $3 \times 1$، و ابعاد بردار خروجی $4 \times 1$ است.

<!-- However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (*e.g.* 3 seconds) times the sampling rate (*e.g.* 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat". -->
اما، باید در نظر گرفته شود که برای داده های صوتی طول بردار خروجی به شدت بیشتر است (برخلاف این مثال که تعداد نمونه ها فقط $3$ عدد است). در واقعیت، تعداد نمونه های استخراج شده از داده های صوتی برابر با طول زمانی داده ی صوتی (برای مثال، $3$ ثانیه) ضرب در نرخ نمونه برداری (برای مثال، $22.05$ kHz) است. همانطور که در معادله ی زیر نشان داده شده است، طول بردار ورودی $\boldsymbol{x}$ که همان نمونه های داده های صوتی است، به شدت زیاد می شود. همچنین، با زیاد شدن طول $\boldsymbol{x}$، عرض (تعداد ستون ها) بردار وزن ها نیز به همان مقدار افزایش می یابد.

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- The above formulation will be difficult to train. Fortunately there are ways to simplify the same. -->
آموزش فرمول بالا (لایه تماماً متصل) دشوار خواهد بود. اما، خوشبختانه روش هایی برای ساده سازی این فرمول وجود دارد.


<!-- ### Property: locality -->
### خاصیت محلی بودن

<!-- Due to locality (*i.e.* we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$. -->
به خاطر خاصیت محلی بودن (ما به داده هایی که در فاصله ی زیادی قرار دارند اهمیت نمی دهیم) داده ها، درایه ی $w_{1k}$ از ماتریس وزنی بالا را میتوان با مقادیر $0$ پر کرد به شرطی که $k$ نسبتا زیاد باشد. با توجه به این مطلب، سطر اول ماتریس به یک کِرنِل با طول $3$ تبدیل خواهد شد. با در نظر گرفتن کِرنِل با طول $3$ به صورت مقابل $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$، خواهیم داشت:

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- ### Property: stationarity -->
### خاصیت ایستایی

<!-- Natural data signals have the property of stationarity (*i.e.* certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (*i.e.* stride is 1), resulting in the following: -->
سیگنال های داده های طبیعی خاصیت ایستایی دارند (به عبارت دیگر، اُلگوهای بخصوصی در این داده ها تکرار می شوند). این خاصیت به ما کمک می کند تا از کِرنِل $\mathbf{a}^{(1)}$ که قبلا تعریف شده است، به صورت مجدد استفاده کنیم. ما این کِرنِل را با جابه جا کردنش در هر مرحله به میزان یک گام استفاده خواهیم کرد (به عبارت دیگر، اِستراید برابر با 1 است). پس، طبق این خاصیت نتیجه ی زیر حاصل می شود:

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

<!-- Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing. -->
همانطور که مشاهده می شود، هم قسمت بالا سمت راست و پایین سمت چپ این ماتریس با مقادیر $0$ پر شده اند. دلیل این نتیجه نیز خاصیت محلی بودن است که باعث خاصیت اِسپارس شدن (خلوت شدن) در این ماتریس می شود. به این عمل استفاده ی مجدد از یک کِرنِل مشخص، اشتراک وزنی گفته می شود.

<!-- ### Multiple layers of Toeplitz matrix -->
### لایه های متعدد ماتریس توپلیتس (قطر-ثابت)

<!-- After these changes, the number of parameters we are left with is 3 (*i.e.* $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (*i.e.* $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same. -->
بعد از این تغییرات، فقط $3$ پارامتر برای ما باقی می ماند ($a_1,a_2,a_3$). در مقایسه با ماتریس قبلی که $12$ پارامتر داشت ($w_{11},w_{12},\cdots,w_{43}$)، تعداد پارامترهای حال حاضر بسیار محدودکننده است. پس، ما میخواهیم که تعداد پارامترهارا به همان اندازه افزایش دهیم.

<!-- The previous matrix can be considered to be a layer (*i.e.* a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters. -->
ماتریس قبلی را میتوان به عنوان یک لایه (لایه ی کانوُلوشِن) با کِرنِل $\boldsymbol{a}^{(1)}$ در نظر گرفت. با توجه به این، ما میتوانیم لایه های متعددی را با کِرنِل های متفاوتِ $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$ و غیره بسازیم. به کمک این روش قادر خواهیم بود که تعداد پارامترها را افزایش دهیم.

<!-- Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well. -->
هر کدام از این لایه ها، دارای یک ماتریس است که از تکرار فقط یک کِرنِل تشکیل شده است. چنین نوع ماتریسی را ماتریس توپلیتس (قطر-ثابت) می نامیم. در چنین ماتریسی تمام قطرهای نزولی که از چپ به راست کشیده شده اند مقدار ثابتی دارند. ماتریس های توپلیتسی که در اینجا استفاده میکنیم، ماتریس اِسپارس (خلوت) نیز به شمار می آیند. 
ا
<!-- Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector looks like the following: -->
با در نظر گرفتن کِرنِل اول به صورت $\boldsymbol{a}^{(1)}$ و بردار ورودی به صورت $\boldsymbol{x}$، اولین درایه ی بردار خروجی این لایه $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$ خواهد بود. در نتیجه، بردار خروجی به شکل زیر خواهد بود:


$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$



<!-- The same matrix multiplication method can be applied on following convolutional layers with other kernels (*e.g.* $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results. -->
با کمک همین روش ضرب ماتریسی میتوان خروجی لایه های کانوُلوشِنی با کِرنِل های دیگر ($\boldsymbol{a}^{(2)}$ و $\boldsymbol{a}^{(3)}$) را محاسبه کرد، و نتیجه ی مشابهی گرفت.


<!-- ## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s) -->
سخنرانی مربوط به تمریناتِ ارائه شده در ژوپیتر نوتبوک این مبحث به نام Listening to convolutions را میتوانید در [اینجا](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s) مشاهده کنید.


<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb). -->
ژوپیتر نوتبوک مربوط به این سخنرانی را میتوانید در [اینجا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb) مشاهده کنید.


<!-- In this notebook, we are going to explore Convolution as a 'running scalar product'. -->
در این نوتبوک، مطالب مربوط به کانوُلوشِن به عنوان 'ضرب نرده ایِ متحرک' بررسی خواهد شد.

<!-- The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and its sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2). -->
کتابخانه ی `librosa` ما را قادر می سازد تا کلیپ های صوتی $\boldsymbol{x}$ و نرخ نمونه برداریشان را بارگذاری کنیم. در این مثال، 70641 نمونه با نرخ نمونه برداری 22.05kHz وجود دارد. طول این کلیپ نیز 3.2 ثانیه است. سیگنال صوتی بارگذاری شده نوسان دارد (با توجه به شکل 1) و بر اساس دامنه ی محور $y$ آن میتوان حدس زد که چه صدایی تولید می کند. در واقع، سیگنال صوتی $x(t)$ صدایی است که زمان خاموش کردن سیستم عامل ویندوز تولید می شود (به شکل 2 توجه شود).

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: A visualization of the audio signal. <br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>شکل 1</b>: نمودار تغییرات دامنه بر طبق زمان سیگنال صوتی<br>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Notes for the above audio signal.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>شکل 2</b>: نوت موسیقی سیگنال صوتی شکل بالا<br>
</center>


<!-- We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (*e.g.* first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal. -->
پس از بارگذاری سیگنال صوتی، نوت های موسیقی باید از شکل موج جدا شوند. برای رسیدن به این هدف اگر از تبدیل فوریه استفاده کنیم، تمام نوت ها بدون ترتیب و به صورت یکجا استخراج می شوند و نمی توان زمان و مکان دقیق هر یک از زیروبمی ها (pitch) را شناسایی کرد. در نتیجه، روش تبدیل فوریه ی محلی شده (یا همان روش طیف‌ نگاره) باید مورد استفاده قرار گیرد. همانطور که در شکل 3 که مربوط به طیف نگاره است مشاهده می شود، زیروبمی های متفاوت نقطه ی اوج خود را در فرکانس های متفاوتی تجربه می کنند (برای مثال، نقطه ی اوج اولین زیروبمی 1600 است). وصل کردن چهار زیروبمی در فرکانسشان برای ما نسخه ی زیروبمی شده ی سیگنال اصلی را فراهم می سازد.

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Audio signal and its spectrogram.<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>شکل 3</b>: سیگنال صوتی و طیف نگاره ی آن<br>
</center>

<!-- Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes in the input piece (*i.e.* the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolutions of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the convolutions prove the effectiveness of the convolutions in extracting the notes. -->
انجام عمل کانوُلوشِن روی سیگنال ورودی با در نظر گرفتن تمام زیروبمی هایش (برای مثال، تمام کلید های پیانو) می تواند به ما کمک کند تا تمام نوت های موجود در این قطعه ی ورودی را استخراج کنیم (به عبارتی، هیت هایی که زمان تطابق پیدا کردن سیگنال صوتی با کِرنل های مشخصی ایجاد میشوند). طیف نگاره های سیگنال اصلی و سیگنال تشکیل شده از متصل شدن زیروبمی ها در شکل 4 نشان داده شده است، در حالی که فرکانس های سیگنال اصلی و چهار زیروبمی های بدست آمده در شکل 5 نمایش داده شده است. نمودار عمل کانوُلوشِن انجام شده به کمک چهار کِرنل روی سیگنال ورودی (سیگنال اصلی) در شکل 6 نمایش داده شده است. این شکل به همراه کلیپ های صوتی کانوُلوشِن ها اثبات میکند که کانوُلوشِن ها روش موثری برای استخراج نوت های موسیقی هستند.

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>شکل 4</b>: طیف نگاره ی سیگنال اصلی (شکل چپ) و طیف نگاره ی زیروبمی های متصل شده (شکل راست)<br>
</center>


<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: First note of the melody.<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>شکل 5</b>: اولین نوت این مِلودی<br>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolution of four kernels.<br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>شکل 6</b>: کانوُلوشِن چهار کِرنل<br>
</center>

<!-- ## Dimensionality of different datasets -->
## ابعاد مجموعه داده های مختلف

<!-- The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$. -->
در بخش آخر، به سمت روش های مختلف نمایش ابعاد مجموعه داده ها منحرف شده و همچنین مثال هایی برای این مطلب ارائه می دهیم. در این قسمت در نظر میگیریم که مجموعه ی ورودی $X$ از نگاشت توابعی از دامنه های $\Omega$ در کانال های $c$ ساخته شده است.

<!-- ### Examples -->
### مثال ها


<!-- * Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), *etc.* -->
* داده ی صوتی: دارای دامنه ی 1 بعدی و سیگنال گسسته ای که با زمان فهرست بندی شده است. تعداد کانال های $c$ می تواند 1 (مونو)، 2 (استریو)، 5 (دالبی 5.1) و غیره باشد.

<!-- * Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*-->
* داده ی تصویری: دارای دامنه ی 2 بعدی (پیکسل های تصویر) است. $c$ می تواند مقادیر 1 (تصویر خاکستری)، 3 (تصویر رنگی)، 20 (تصویر فراطیفی)، و غیره را بگیرد.

<!-- * Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it is called Hamiltonian. -->
* نسبیت خاص: دارای دامنه ی $\mathbb{R^4} \times \mathbb{R^4}$ (فضا-زمان در چهار تکانه) است. زمانی که $c = 1$  باشد، در اصل تبدیل به مشاهده پذیری هامیلتونین می شود.

<!-- <center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>شکل 7</b>ابعاد مختلفِ انواع سیگنال هایِ متفاوت: <br>
</center> -->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>شکل 7</b>: ابعاد مختلفِ انواع سیگنال هایِ متفاوت<br>
</center>