---
lang-ref: ch.03-3
title: Properties of natural signals
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
lang: fa
translation-date: 21 Sep 2020
translator: Ali Abedi
---


## [ویژگی‌های سیگنال‌های طبیعی](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)
<!--
All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language *i.e.* it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.
-->
تمامی سیگنال‌ها را می‌توان به صورت بردار فرض نمود. به عنوان مثال، یک سیگنال صوت، یک سیگنال یک بعدی $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ است که هر $x_t$ آن بزرگی آن سیگنال در زمان $t$ است. برای آنکه گفتار کسی را متوجه شویم، گوش ما فشار هوا را به سیگنال تبدیل می‌کند و سپس مغزما از یک مدل زبانی برای تبدیل این سیگنال به زبان استفاده می‌کند. به عبارت دیگر نطق با بیشترین تطابق بر اساس سیگنال را انتخاب می‌کند. برای موسیقی، صدای استریو که دو کانال یا بیشتر دارد به شما این احساس را می‌دهد که صدا دار از جهات مختلف پخش می‌شود. با وجود اینکه دو کانال دارد باز هم یک سیگنال یک بعدی است چون زمان تنها متغیر است که نشان می‌دهد کدام سیگنال در حال تغییر است. 

<!--
An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.
-->

یک عکس یک سیگنال دو بعدی است زیرا اطلاعات به صورت مکانی کشیده شده‌اند. نکته قابل ذکر این است که هر نقطه خودش می‌تواند یک وکتور باشد. این به این معنی است که اگر ما $d$ کانال در یک عکس داشته باشیم، هر نقطه مکانی در عکس یک بردار $d$ بعدی است. یک عکس رنگی صفحات RGB دارد که به این معنی است که $d = 3$. برای هر نقطه، $x_{i,j}$ به ترتیب میزان روشنایی رنگ‌های قرمز، سبز و آبی را نشان می‌دهد.

<!--
We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.
-->
ما حتی می‌توانیم زبان را با قاعده بالا نمایش دهیم. هر کلمه به یک بردار one-hot با مقدار یک در ستون مربوط به کلمه ما و صفر در بقیه خانه‌ها تبدیل می‌شود. در حقیقت هر کلمه به یک بردار به اندازه تعداد واژگان ما تبدیل می‌شود.

<!--
Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.
-->

سیگنال‌های طبیعی ویژگی‌های زیر را دارا هستند:

۱- ایستایی: شکل‌های مشخصی در حین یک سیگنال رخ می‌دهند. در سیگنال صوتی ما یک الگوی مشخص را در فضای زمان مرتبا مشاهده می‌کنیم. در عکس این به این معنی است که می‌توانیم الگوهای ظاهری مشخصی را در بعد‌ها انتظار داشته باشیم.

۲- مکانی بودن: نقاط نزدیک به هم نسبت به نقاط دور از هم بیشتر به هم مربوط هستند. برای یک سیگنال یک بعدی، این به این معنی است که ما اگر یک قله در نقطه $t_i$ داشته باشیم، انتظار داریم نقاط اطراف $t_i$ مقداری شبیه به مقدار $t_i$ داشته باشند اما برای نقطه‌ای مثل $t_j$ دور از $t_i$، $x_{t_i}$ جهت کمتری نسبت به $x_{t_j}$ دارد. به عبارت دیگر، کانولوشن یک سیگنال با نسخه flip شده آن وقتی به قله می‌رسد که سیگنال‌ها به صورت کامل بر هم منطبق شوند. کانولوشن بین دو سیگنال یک بعدی چیزی جز ضرب داخلی آنها که نشان دهنده میزان شباهت آن دو سیگنال به هم دیگر است، نیست. پس اطلاعات در یک بخش‌های مشخصی از سیگنال قرار دارد. برای عکس‌ها این به این معنی است که ارتباط بین دو نقطه در عکس وقتی از هم دور می‌شوند، کم می‌شود. اگر پیکسل $x_{0,0}$ آبی باشد، احتمال اینکه پیکسل بعدی نیز آبی باشد زیاد است اما وقتی به انتهای دیگر عکس می‌روید $x_{-1, -1}$ مقدار پیکسل غیر وابسطه به مقدار $x_{0,0}$ است.

۳- ترکیب بندی: همه چیز در طبیعت از بخش‌هایی تشکیل شده است که خود از بخش‌های دیگر تشکیل شده است. به عنوان مثال، کاراکتر‌های یک رشته از یک کلمه که از یک جمله هستند. جملات هم می‌توانند به داکیومنت تبدیل شوند. ترکیب بندی به حهان این اجازه را می‌دهد که قابل توضیح باشد.

<!--
If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.
-->
اگر داده ما ایستایی، مکانی بودن و ترکیب بندی را داشته باشد می‌توانیم از آن به وسیله یک شبکه که پراکندگی، اشتراک گذاری وزن‌ها و پشته‌سازی را در لایه‌ها دارد استفاده کنیم.

## [استفاده از ویژگی‌های سیگنال‌های طبیعی برای ایجاد invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)


### پراکندگی  $\Rightarrow$ مکانی بودن

<!--
Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.
-->
عکس شماره ۱ - نشان دادن یک شبکه پنج لایه کاملا متصل به هم. هر سطر نشان دهنده وزن‌هایی هستند که باید با ورودی‌ها ضرب شوند. همانطور که مشاهده می‌شود این شبکه از لحاظ محاسباتی خیلی سنگین است.


<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>عکس ۱:</b> شبکه کاملا به هم متصل</center>

<!--
If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.
-->
 اگر داده‌های ما مکانی باشند، هر نورون نیاز دارد که به تعداد کمی از نورون‌های لایه قبلی متصل شود.لذا همانطور که در عکس ۲ نشان داده شده است، برخی از اتصالات را می‌توان حذف کرد. عکس ۲(آ) یک شبکه کاملا متصل را نشان میدهد. با تکیه بر ویژگی مکانی بودن داده‌هایمان،  ما یک سری از اتصالات بین نورون‌ها را از بین می‌بریم که در شکل  ۲(ب) مشاهده می‌شود. هرچند نورون‌های لایه‌های مخفی (سبز رنگ) در شکل ۲ (ب) به طور کامل ورودی‌ها را پوشش نمی‌دهد، ساختار کلی شبکه میتواند برای تمام نورون‌های ورودی در نظر گرفته شود. میدان تاثیر تعداد نورون‌های لایه قبل هستند که هر نورون از یک لایه خاص می‌تواند ببیند یا در نظر بگیرد. به همین خاطر میدان تاثیر لایه خروجی با در نظر گرفتن لایه‌های پنهان ۳ است و میدان تاثیر لایه‌های پنهان با در نظر گرفتن لایه ورودی ۳ است اما میدان تاثیر لایه خروجی با در نظر گرفتن لایه ورودی ۵ است.
 
|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>عکس 2(آ):</b> قبل از اعمال پراکندگی | <b>عکس 2(ب):</b> بعد از اعمال پراکندگی|


### اشتراک پارامتر‌ها $\Rightarrow$ ایستایی

<!--
If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.
-->
اگر داده‌ها شرط ایستایی را داشته باشند، ما میتوانیم یک مجموعه کوچک از پارامترها را در ساختار شبکه چندبار استفاده کنیم. به عنوان مثال در شبکه پراکنده ما در عکس ۳(آ)، میتوانیم سه پارامتر مشترک (زرد، نارنجی و قرمز) را استفاده کنیم. تعداد پارامترها در این حالت از ۹ به ۳ کاهش می‌یابد! ساختار جدید حتی ممکن است بهتر کار کند چون ما داده‌های بیشتری برای آموزش آن وزن‌ها داریم. وزن‌ها بعد از اعمال پراکندگی و اشتراک گذاری پارامتر را هسته کانولوشنی مینامیم.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>عکس ۳(آ):</b> قبل از اعمال اشتراک گذاری پارامترها | <b>عکس ۳(ب):</b> بعد از اعمال اشتراک گذاری پارامترها|

<!--
Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation
-->
برخی از فواید استفاده از پراکندگی و اشتراک گذاری پارامتر:
* اشتراک گذاری پارامتر
  * همگرایی سریع‌تر
  * تعمیم پذیری بهتر
  * عدم محدود شدن به سایز ورودی
  * مستقل از هسته -> امکان موازی‌سازی بالا

<!--
Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).
-->
عکس ۴ مثالی از یک هسته روی داده‌های یک بعدی را نشان می‌دهد که اندازه هسته ۲(تعداد هسته‌ها) * ۷(اندازه لایه قبل) * ۳(تعداد اتصلات / وزن‌های یکتا)

<!--
The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.
-->
انتخاب اندازه هسته به صورت تجربی است. هسته ۳*۳ کوچک‌ترین نوع هسته برای داده‌های دارای فضا است. هسته با سایز ۱ را میتوان برای دستیابی به لایه آخر استفاده کرد که می‌توان روی عکس ورودی بزرگ‌تری پیاده کرد. سایز هسته زوج ممکن است کیفیت داده را پایین بیاورد لذا ما همیشه از هسته با اندازه فرد مثل ۳ یا ۵ استفاده می‌کنیم.

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>عکس ۴(آ):</b> هسته بر داده‌های یک بعدی | <b>عکس ۴(ب):</b> داده با پوشش صفر|

### پوشش
<!--
Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.
-->
پوشش‌ها به صورت کلی نتیجه پایانی را خراب می‌کنند اما از لحاظ برنامه‌ای راحت هستند. ما معمولا از پوشش صفر استفاده می‌کنیم: `size = (kernel size - 1)/2`

### شبکه عصبی کانولوشنی مکانی استاندارد

<!--
A standard spatial CNN has the following properties:

* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection

-->
یک شبکه عصبی کانولوشنی مکانی استاندارد ویژگی‌های زیر را دارد:

* چند لایه بودن
  * کانولوشن
  * غیر خطی بودن (استفاده از توابع فعال سازی ReLU یا Leaky)
  * ادغام
  * نرمال سازی دسته‌ای
* ارتباط میانبر باقی‌مانده

<!--
Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.
-->
نرمال سازی دسته‌ای و ارتباط میانبر باقی‌مانده بسیار برای آموزش خوب شبکه کمک کننده هستند.
اگر لایه‌های زیادی را پشت هم بچینیم ممکن است قسمتی از سیگنال گم بشود. بنابر این ارتباط میان‌بر یک مسیر از پایین به بالا همچنین گرادیان از بالا به پایین را تضمین می‌کند.

<!--
In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.
-->
در شکل ۵، در حالی که عکس ورودی فقط شامل اطلاعات مکانی از دو بعد است (جدای از اطلاعات مشخصه که رنگ هر پیکسل است)، لایه آخر پر حجم است. بنابر این یک توازن باید بین اطلاعات مکانی و مشخصه‌ای باشد و نمایش متراکم‌تر باشد. همانطور که ما به صورت سلسله مراتبی بالاتر می‌رویم، اطلاعات مکانی را از دست می‌دهیم و در نتیجه نمایش ما متراکم‌تر می‌شود.

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>عکس ۵:</b> نمایش اطلاعات در حالت بالارفتن سلسله مراتبی</center>


### [ادغام](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>عکس ۶:</b> نمایش ادغام</center>

<!--
A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.
-->
یک عملگر مشخص $L_p$-norm در ناحیه مختلف اعمال می‌شود. (به عکس ۶ مراجعه شود). این عملگر تنها یک مقدار به ازای هر ناحیه می‌دهد (در مثال ما، یک مقدار به ازای ۴ پیکسل). ما بر روی کل داده‌ها به صورت ناحیه ناحیه تکرار انجام می‌دهیم و گام‌ها را تکرار می‌کنیم. اگر با یک داده m*n را بر روی یک داده با c کانال شروع کنیم، به یک داده با $\frac{m}{2} * \frac{n}{2}$ و c کانال می‌رسیم (عکس ۷).
ادغام پارامتردار نیست با این وجود می‌توانیم ادغام‌هایم مختلف مثل ادغام بیشترین یا ادغام میانگین و غیره. هدف ادغام کم کردن میزان داده است که باعث می‌شود بتوانیم در یک تایم خوب محاسبات را انجام دهیم
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>شکل ۷:</b> ادغام نتایج </center>


## شبکه‌های عصبی کانولوشنی - Jupyter Notebook

<!--
The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->
دفترچه Jupyter را میتوانید در [اینجا](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb) ببینید.
برای اینکه دفترچه درست اجرا ‌شود باید محیط `pDL` را نصب کرده باشید همانطور که در [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md) نوشته است.

<!--
In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)
-->
در این دفترچه، یک شبکه پرسپترون چند لایه کاملا متصل و یک شبکه عصبی کانولوشنی برای مسئله دسته بندی مجموعه داده MINST آموزش داده شده است. توجه شود که هر دوی شبکه‌ها یک تعداد مشخصی پارامتر دارند. (عکس ۸)

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>عکس ۸:</b> نمونه‌ای از مجموعه‌داده MINST </center>

<!--
Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:
-->
قبل از آموزش ما داده‌هایمان را نرمال می‌کنیم در نتیجه با مقدار دهی اولیه شبکه‌مان خوانایی دارد. این مسئله خیلی مهم است! همچنین مطمئن شوید که این عملیات‌ها / قدم‌ها در آموزش‌ها وجود دارد:

<!--
 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method
 -->
 ۱. دادن داده به مدل
 ۲. محاسبه خطا
 ۳. پاک کردن مقدار‌های موقت گرادیان‌ها با دستور zero_grad()
 ۴. محاسبه گرادیان‌ها
 ۵. یک قدم در متد بهینه سازی برداشتن

<!--
First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.
-->
در ابتدا ما هر دو شبکه را بر روی داده‌های نرمال شده MINST آموزش می‌دهیم. دقت شبکه کاملا به هم متصل ۸۷ درصد در صورتی که دقت شبکه کانولوشنی ۹۵ درصد می‌شود! با تعداد پارامتر مساوی، شبکه کانولوشنی فیلتر‌های بیشتری را آموزش می‌دهد. در شبکه کاملا به هم متصل، فیلترها سعی میکنند اطلاعاتی که از هم دور هستند را هم به هم مرتبط سازند که کار بیهوده‌ای است. در حالی که در شبکه‌های کانولوشنی، همه محاسبات بر روی پیکسل‌های همسایه تمرکز دارند.

<!--
Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.
-->
در ادامه ما یک تغییر در تمامی پیکسل‌های عکس‌های مجموعه داده‌یمان دادیم. مانند تغییر شکل ۸ به ۹. سپس هر دو شبکه را بر داده‌های تغییر داده شده آموزش دادیم.
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>عکس ۹:</b> نمونه‌ای از مجموعه داده تغییر داده شده.</center>


<!--
The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->
کارکرد شبکه کاملا به هم متصل تغیریبا بدون تغییر ماند در حالی که کارکرد شبکه کانولوشنی به ۸۳ درصد کاهش یافت! این به خاطر این است که بعد از یک تغییر به صورت تصادفی عکس دیگر سه شرط مکانی بودن، ایستایی و ترکیب بندی بودن را که برای شبکه کانولوشنی الزامی است را ندارد.