---
lang-ref: ch.02-2
lecturer: Yann LeCun
title: محاسبه کردن گرادیان برای اجزای شبکه های مصنوعی و فوت و فن هایی برای پس انتشاری
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
translation-date: 3 oct 2020
lang: fa
translator: Zahra Hosseini
---


<!-- 
## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)
-->
##[  یک مثال عینی از پس انتشار و معرفی ایی بر عناصر شبکه ی مصنوعی پایه](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)
<!-- 
### Example

We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is input into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e. the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.)
-->
##مثال
در گام بعدی ما یک مثال عینی از پس انتشار مطرح میکنیم با کمک گرفتن از یک گراف بصری.تابع دلخواه
$G(W)$
 وردی تابع هزینه
 $\C$
  است.
که میتواند به عنوان یک گراف نمایش داده شود.از طریق دستکاری کردن ماتریکس ژاکوبی،ما میتوانیم این گراف را به گرافی که میخواهد گرادیانی که به عقب میرود را حساب کند،تبدیل کنیم.
(لازم به ذکر است که$\PyTorch$و$\TensorFlow$این کار را به صورت خودکار برای کاربر انجام میدهند.گراف پیش رو نیز به صورت خودکار معکوس میشود تا گراف مشتق ساخته شود که گرادیان را پس انتشار کند.   ) 
<!--<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Gradient diagram" style="zoom:40%;" /></center> -->
<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="نمودار گرادیان" style="zoom:40%;" /></center>

<!--In this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.

Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount.-->
در این مثال ،گراف سبز رنگ در سمت راست،گراف گرادیان را نمایش میدهد.با دنبال کردن گراف از بالاترین گره،نتیجه میشود که

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

از لحاظ ابعاد ،$\frac{\partial C(y,\bar{y})}{\partial w}$ 
یک بردار ردیفی به سایز$1\times N$ که در واقع$N$برابر تعداد عناصر$w$است؛$\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$یک بردار ردیفی به سایز$1\times M$که در واقع$M$
اندازه ی بُعد خروجی است؛$\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ یک ماتریکس به سایز
$M\times N$،است که در واقع
$M$ برابر است باتعداد خروجی های $G$ 
 و$N$برابر اندازه بعد $w$.
<!--### Basic neural net modules

There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules).
-->

###ماژول های پایه شبکه عصبی مصنوعی
 در اینجا نوع های مختلفی از ماژول های از پیش ساخته شده وجود دارد،در کنار ماژول های آشنای خطی و 
 یکسوساز.اینها کاربردی هستند زیرا آنها به صورت منحصر به فرد بهینه شده اند تا وظایف مربوطه خود را انجام دهند.(بر خلاف حالتی که توسط ترکیبی از ماژول های ابتدایی ساخته شده باشد) 

<!--
Linear: $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$
-->

خطی:$Y=W\cdot X$

$$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
$$

  <!--
- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
  $$
-->

یکسو ساز: $y=(x)^+$

$$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
$$

  <!--
- Duplicate: $Y_1=X$, $Y_2=X$

  - Akin to a "Y - splitter" where both outputs are equal to the input.

  - When backpropagating, the gradients get summed

  - Can be split into $n$ branches similarly

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$

-->

دو نسخه ایی:  $Y_1=X$, $Y_2=X$
- یکسان با "Y اسپیلیتر" جایی که هر دوی خروجی و ورودی برابر هستند.
- در زمان پس انتظاری،گرادیان ها جمع میشوند
-  میتواند اسپیلت شود به $n$ به شاخه به طور مشابه

 $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
 $$

<!--
- Add: $Y=X_1+X_2$

  - With two variables being summed, when one is perturbed, the output will be perturbed by the same quantity, i.e.

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$

-->

- جمع: $Y=X_1+X_2$

- با دو متغییر جمع میشود،وقتی یکی آشفته است،خروجی نیز با مقدار یکسانی آشفته خواهد .شد

$$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
$$

 <!--   
- Max: $Y=\max(X_1,X_2)$

  -  Since this function can also be represented as

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$
-->

- حداکثر : $Y=\max(X_1,X_2)$

- از آنجا که این تابع میتواند همچنین نمایش داده شود به صورت:

 $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
$$

<!--
  - Therefore, by the chain rule,

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$
-->

- از این رو،با قاعده ی زنجیره ایی ،

$$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
$$

<!-- ## [LogSoftMax *vs.* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between $0$ and $1$ that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when $s$ is large, $h(s)$ is $1$, and when s is small, $h(s)$ is $0$. Because the sigmoid function is flat at $h(s) = 0$ and $h(s) = 1$, the gradient is $0$, which results in a vanishing gradient.X_2 \\
          0 & \text{else}
      \end{cases}
    $$
-->

## [LogSoftMax و SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s) 

softmaxکه همچنین یک ماژول pytorchاست، یک راه راحت برای تبدیل گروهی از اعداد به گروهی از هداد مثبت در بازه ی 0 تا 1 است که جمع آنها برابر یک میشود.
این اعداد میتوانند،توزیع احتمال تفسیر شوند.
به عنوان نتیجه،این مورد به طور معمول در مسایل کلاس بندی استفاده میشود.
&\y&در معادله ی زیر یک بردار از احتمال هر یک از دسته بندی هاست.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

در هر حال،استفاده از softmax شبکه را مستعد به رخ دادن محو شدگی گرادیان میکند.محوشدگی گرادیان یک مسئله است که جلوگیری میکند از اصلاح وزن های پایین دست توسط شبکه ی عصبی،که این ممکن است به طور کامل شبکه عصبی را از آموختن باز دارد.
تابع لاجیستیک sigmoidکه در واقع همان تابع softmaxبرای یک مقدار است،نشان میدهد که وقتی $S$ بزرگ باشد،&h(s)$برابر $1$میشود و وقتی که sکوچک باشد،$h(s)$برابر $0$میشود.
زیرا تابع sigmoid هموار است در $h(s)=0$و در $h(s)=1$.گرادیان برابر $0$است که نیجه ی آن محوشدگی گرادیان میشود.
X_2 \\
          0 & \text{else}
      \end{cases}
    $$

<!--

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Sigmoid function to illustrate vanishing gradient" style="background-color:#DCDCDC;" /></center>
-->
<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="تابع sigmoid برای نشان داد محوشدگی گرادیان" style="background-color:#DCDCDC;" /></center>

<!-- 
$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When $s$ is very small, the value is $0$, and when $s$ is very large, the value is $s$. As a result it doesn’t saturate, and the vanishing gradient problem is avoided.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Plot of logarithmic part of the functions" /></center>
-->

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

ریاضیدانان،ایده ی logosoftmax را مطرح کردند برا ی حل کردن مشکلات محو شدگی گرادیان حاصل از softmax.*logosoftmax* یکی دیگر از ماژول های پایه در Pytorchاست.
همانطور که در معادله ی زیر میتوان دید،*logosoftmax* یک ترکیب ازsoftmax و log است.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

معادله ی زیر یک راه دیگر برای نگاه کردن به معادله ی یکسانی را نشان میدهد.شکل زیر نشان میدهد که $\log(1 + \exp(s))$ بخشی از تابع است.وقتی که $s$خیلی کوچک باشد،مقدار برابر $0$
است و زمانی که $s$خیلی بزرگ باشد مقدار برابر آن برابر $s$میشود.
به عنوان نتیجه،ابن باعث اشباع نمیشود و مانع از محو شدگی گرادیان میشود.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="رسم بخش لگاریتمی از تابع ها" /></center>



<!--
## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)


### Use ReLU as the non-linear activation function

ReLU works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.

-->
## [فوت و فن های عملی برای پس انتشاری](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)

## استفاده از یکسوساز به عنوان تابع غیر خطی فعال ساز

یکسوساز در شبکه های با تعداد لایه ی زیاد بهتر عمل میکند،که باعث شده گزینه های دیگری مانند عملکرد سیگموئید و تابع مماس هذلولی $ \ tanh (\ cdot) $ مورد پسند واقع نشوند.
 دلیل کارکرد بهتر یکسوساز  به دلیل پیچ خوردگی منفرد آن است که باعث می شود مقیاس آن برابر شود. 

<!--

### Use cross-entropy loss as the objective function for classification problems

Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).


### Use stochastic gradient descent on minibatches during training

As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.


### Shuffle the order of the training examples when using stochastic gradient descent

Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, *etc*. Ideally, you should have samples from every class in every minibatch.

However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch).

-->
###   استفاده از خطا انتروپی متقابل به عنوان تابع هدف برای مسائل کلاس بندی

logsoftmax که قبلتر بحث کردیم درباره ی آن،یک نوع خاص از خطا انتروپی متقابل است.در Pytorch  باید مطمئن شد که تابع خطا انتروپی متقابل با *log* softmax بهبود یافته به عنوان ورودی.(در مقابل softmaxمعمولی)

### استفاده از گرادیان کاهشی تصادفی روی مینی بچ ها در زمان آموختن

همانظور که بحث شد قبلا، مینی بچ ها اجازه میدهند به طور کارآمد تری یادگیری انجام شود.زیرا در داده ها افزونگی وجود دارد. برای تخمین گرادیان نیازی به پیش بینی و محاسبه ضرر در هر مشاهده در هر مرحله نیست.

### بهم زدن ترتیب نمونه های یادگیری وقتی که از گرادیان کاهشی تصادفی استفاده میکنیم
سفارش مهم است. اگر مدل در طول هر مرحله آموزش فقط نمونه هایی از یک کلاس واحد را ببیند ، یاد می گیرد که آن کلاس را پیش بینی کند بدون اینکه یاد بگیرد چرا باید آن کلاس را پیش بینی کند. به عنوان مثال ، اگر می خواهید ارقام را از مجموعه داده های MNIST طبقه بندی کنید و داده ها مرتب نباشند ، پارامترهای بایاس در لایه آخر همیشه صفر را پیش بینی می کنند ، سپس با همیشه یک ، سپس دو ، * و غیره * را پیش بینی می کنید. در حالت ایده آل ، شما باید از هر کلاس در هر مینی بچ نمونه داشته باشید.

<!--

### Normalize the inputs to have zero mean and unit variance

Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none.

-->

### ورودی ها را عادی کنید تا دارای میانگین و واریانس واحد باشند

قبل از آموزش،مفید است که هر ویژگی ورودی را نرمال کنیم به گونه ای است که دارای میانگین صفر و انحراف معیار یک باشد. هنگام استفاده از داده های تصویر RGB ، معمول است که میانگین و انحراف معیار هر کانال را به صورت جداگانه در نظر بگیریم و کانال تصویر را عادی کنیم. به عنوان مثال ، میانگین $ m_b $ و انحراف استاندارد $ \ sigma_b $ از تمام مقادیر آبی موجود در مجموعه داده را بگیرید ، سپس مقادیر آبی را برای هر تصویر جداگانه عادی کنید به عنوان

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

یه طوری که $\epsilon$ یک عدد دلخواه کوچک است که ما استفاده میکنیم تا از تقسیم بر صفر جلوگیری کنیم.
همین کار را برای کانال های سبز و قرمز تکرار کنید. این امر برای دریافت سیگنال معنی دار از تصاویر گرفته شده در نورهای مختلف ضروری است. به عنوان مثال ، تصاویر روز روشن قرمز زیادی دارند در حالی که تصاویر زیر آب تقریباً هیچ رنگی ندارند.

<!--


### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam which adapt the learning rate instead of simple SGD with a constant learning rate.


### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to $0$.

-->


### استفاده از زمانبدی برای کاهش میزان یادگیری
با ادامه آموزش باید میزان یادگیری کاهش یابد. در عمل ، بیشتر مدل های پیشرفته با استفاده از الگوریتم هایی مانند ادم آموزش می بینند که میزان یادگیری را به جای SGD ساده با میزان یادگیری ثابت تطبیق می دهند.

### استفاده از L1 و/یا L2 قانونمند سازی برای فرسوده سازی وزن

می توانید برای وزن های بزرگ هزینه ای به تابع هزینه اضافه کنید. به عنوان مثال ، با استفاده از  قانونمند سازی L2 خطا $L$ را تعریف میکنیم.و وزن $W$ را به صورت زیر به روز رسانی میکنیم:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

رای فهمیدن اینکه چرا به این پوسیدگی وزن گفته می شود ، توجه داشته باشید که می توانیم فرمول فوق را دوباره بنویسیم تا نشان دهیم که در هنگام به روزرسانی $W_i$ را در یک ثابت کمتر از یک ضرب می کنیم.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

قانونمندسازی L1نیز مشابه است به جز اینکه از $\sum_i \vert w_i\vert$  به جای  $\Vert w \Vert^2$ استفاده میکنیم. 

اساساً ، با تنظیم قانون سعی می شود تا به سیستم بگوییم تا تابع هزینه را با کمترین وزن برداری ممکن به حداقل برساند.با قانونمندسازی L1 وزن هایی که مقید نیستند به $0$کاهش میابند.

<!--
### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the variance of the weights is inversely proportional to square root of number of inputs.


### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

For more tricks, see  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules.

-->

### مقداردهی اولیه وزن

وزن ها باید بصورت تصادفی مقدار دهی شوند ، با این حال ، نباید خیلی بزرگ یا خیلی کوچک باشند ، به طوری که خروجی تقریباً با واریانس ورودی برابر باشد. ترفندهای مختلفی برای شروع وزن در PyTorch وجود دارد. یکی از ترفندهایی که برای مدل های عمیق به خوبی کار می کند ، مقدمه گذاری Kaiming است که در آن واریانس وزن ها با ریشه مربع تعداد ورودی ها متناسب است.

### استفاده از برون اندازی

ترک تحصیل نوع دیگری از قاعده مند شدن است. می توان آن را لایه دیگری از شبکه عصبی دانست: ورودی ها را می گیرد ، به طور تصادفی n / 2 $ از ورودی ها را صفر می کند و نتیجه را به عنوان خروجی برمی گرداند. این سیستم را مجبور می کند تا اطلاعات را از همه واحدهای ورودی بگیرد نه اینکه بیش از حد به تعداد کمی از واحدهای ورودی متکی باشد و اطلاعات را در تمام واحدهای موجود در یک لایه توزیع می کند. این روش در ابتدا توسط <a href="https://arxiv.org/abs/1207.0580 "> هینتون و همکاران (2012) </a> ارائه شد.

برای ترفندهای بیشتر ، به <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf "> LeCun و همکاران 1998 مراجعه کنید </a>.

سرانجام ، توجه داشته باشید که پس انتشاری ‍ فقط برای مدلهای انباشته کار نمی کند.
تا زمانی که ترتیب جزئی روی ماژول ها وجود داشته باشد ، میتواند برای هر گراف جهت دار بدون دور کار کند.
