---
lang-ref: ch.14-3
title: Overfitting and regularization
lecturer: Alfredo Canziani
authors: Karl Otness, Xiaoyi Zhang, Shreyas Chandrakaladharan, Chady Raach
date: 5 May 2020
lang: es
translator: lcipolina (Lucia Cipolina-Kun)
date: 15 Sep 2020
---

<!--
## Overfitting

Consider a regression problem. A model could underfit, right-fit, or overfit.

If the model is insufficiently expressive for the data it will underfit. If the model is more expressive than the data (as is the case with deep neural networks), it runs the risk of overfitting.

In this case, the model is powerful enough to fit both the original data *and* the noise, producing a poor solution for the task at hand.

Ideally we would like our model to fit the underlying data and not the noise, producing a good fit for our data. We would especially like to do this without needing to reduce the power of our models. Deep learning models are very powerful, often much more than is strictly necessary in order to learn the data. We would like to keep that power (to make training easier), but still fight overfitting.


### Overfitting for debugging

Overfitting can be useful in some cases, such as during debugging. One can test a network on a small subset of training data (even a single batch or a set of random noise tensors) and make sure that the network is able to overfit to this data. If it fails to learn, it is a sign that there may be a bug.


## Regularization

We can try to fight overfitting by introducing regularization. The amount of regularization will affect the model's validation performance. Too little regularization will fail to resolve the overfitting problem. Too much regularization will make the model much less effective.

*Regularization* adds prior knowledge to a model; a prior distribution is specified for the parameters. It acts as a restriction on the set of possible learnable functions.

Another definition of regularization from Ian Goodfellow:
> Regularization is any modification we make to a learning algorithm that is intended to reduce its generalization error but not its training error.


### Initialization techniques

We can select a prior for our network parameters by initializing the weights according to a particular distribution. One option: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).


### Weight decay regularisation

Weight decay is our first regularisation technique. Weight decay is in widespread use in machine learning, but less so with neural networks.  In PyTorch, weight decay is provided as a parameter to the optimizer (see for example the `weight_decay` parameter for [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)).

This is also called:

- L2
- Ridge
- Gaussian prior

We can consider an objective which acts on the parameters:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

then we have updates:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

For weight decay we add a penalty term:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

This new term in the update drives the parameters $\theta$ slightly toward zero, adding some "decay" in the weights with each update.


### L1 regularisation

Available as an option for PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html).

Also called:

- LASSO: Least Absolute Shrinkage Selector Operator
- Laplacian prior
- Sparsity prior

Viewing this as a Laplace distribution prior, this regularization puts more probability mass near zero than does a Gaussian distribution.

Starting with the same update as above we can view this as adding another penalty:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

which produces an update

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$

Unlike $L_2$ weight decay, the $L_1$ regularization will "kill" components that are close to an axis in the parameter space, rather than evenly reducing the length of the parameter vector.


### Dropout

Dropout involves setting a certain number of neurons to zero randomly during training. This prevents the network from learning a singular path from input to output. Similarly, due to the large parametrisation of neural networks, it is possible for the neural network to effectively memorize the input. However, with dropout, this is a lot more difficult since the input is being put into a different network each time since dropout effectively trains a infinite number of networks that are different each time. Hence, dropout can be a powerful way of controlling overfitting and being more robust against small variations in the input.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 1: Network without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figure 2: Network with dropout
</center>

In PyTorch, we can set a random dropout rate of neuron.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
Figure 3: Dropout code
</center>

After training, during inference, dropout is not used any more. In order to create the final network for inference, we average over all of the individual networks created during dropout and use that for inference. We can similarly multiply all of the weights by $1/1-p$ where $p$ is the dropout rate.


### Early-stopping

During training, if the validation loss starts increasing, we can stop training and use the best weights found so far. This prevents the weights from growing too much which will start hurting validation performance at some point. In practise, it is common to calculate the validation performance at certain intervals and stop after a certain number of validation error calculations stop decreasing.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
Figure 4: Early stopping
</center>


# Fighting overfitting indirectly

There are techniques that have the side-effect of regularizing parameters but are not regularisers themselves.


## Batch-norm

Q. How does batch norm make training more efficient?
A. We can use higher learning rate when applying batch norm.

Batch normalization is used to prevent the internal covariate shift of a neural network but there is a lot debate if it actually does this and what the true benefit actually is.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
Figure 5: Batch normalization
</center>

Batch normalisation essentially extends the logic of normalizing the input of the neural network to normalizing the input of each hidden layer in the network. The basic idea is to have a fixed distribution feed each subsequent layer of a neural network since learning occurs best when we have a fixed distribution. To do this, we compute the mean and variance of each batch before each hidden layer and normalize the incoming values by these batch specific statistics, which reduces the amount by which the values will ultimately shift around during training.

Regarding the regularizing effect, due to each batch being different, each sample will be normalized by slightly different statistics based upon the batch it is in.  Hence, the network will see various slightly altered versions of a single input which helps the network learn to be more robust against slight variations in the input and prevent overfitting.

Another benefit of batch normalisation is that training is a lot faster.


### More data

Gathering more data is a easy way to prevent overfitting but can be expensive or not feasible.


### Data-augmentation

Transformations using Torchvision can have a regularizing effect by teaching the network to learn how to be insensitive to perturbations.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
Figure 6: Data augmentation with Torchvision.
</center>


### Transfer leaning (TF) fine-tuning (FT)

Transfer learning (TF) refers to just training a final classifier on top of a pre-trained network (used in cases of little data generally).

Fine tuning (FT) refers to training partial/full portions of the pre-trained netowrk as well (used in cases where we have a lot of data generally).

Q. Generally, when should we freeze the layers of a pre-trained model?
A. If we have little training data.

4 general cases:
1) If we have little data with similar distributions, we can just do transfer learning.
2) If we have a lot of data with similar distributions we can do fine-tuning in order to improve the performance of the feature extractor as well.
3) If we have a little data and a different distribution we should remove a few of the final trained layers in the feature extractor since they are too specialized.
4) If we have a lot of data and they are from different distributions, we can just train all portions.

Note, we can also use different learning rates for different layers in order to improve performance.

To further our discussion about overfitting and regularisation, let us look at the visualisations below. These visualisations were generated with the code from [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb).

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Loss curves without dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Loss curves with dropout
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Effect of regularization on weights
</center>

From Figure 7 and Figure 8, we can understand the dramatic effect that dropout has on generalisation error i.e the difference between the training loss and validation loss. In Figure 7, without dropout there is clear overfitting as the training loss is much lower than the validation loss. However, in Figure 8, with dropout the training loss and validation loss almost continuously overlap indicating that the model is generalising well to the validation set, which serves as our proxy for out-of-sample set. Of course, we can measure the actual out-of-sample performance using a separate holdout test set.

In Figure 9, we observe the effect that regularisation (L1 & L2) have on the weights of the network.

- When we apply L1 regularisation, from the red peak at zero, we can understand that most of the weights are zero. Small red dots closer to zero are the non-zero weights of the model.

- Contrastingly, in L2 regularisation, from the blue peak near zero we can see that most of the weights are close to zero but non-zero.

- When there is no regularisation (lavender) the weights are much more flexible and spread out around zero resembling a normal distribution.


## Bayesian Neural Networks: estimating uncertainty around predictions

We care about uncertainty in neural networks because a network needs to know how certain/confident on its prediction.

Ex: If you build a neural networks to predict steering control, you need to know how confident the network's predictions.

We can use a neural network with dropout to get a confidence interval around our predictions. Let us train a network with dropout, $r$ being the dropout ratio.

Usually during inference, we set the network to validation mode and use all neurons to get the final prediction. While doing the prediction, we scale the weights $\delta$ by $\dfrac{1}{1-r}$ to account for dropping neurons during training.

This method gives us a single prediction for each input. However, to get a confidence interval around our prediction, we need multiple predictions for the same input. So instead of setting the network to validation mode during inference, we retain it in training mode *i.e.* still drop neurons randomly and get a prediction. When we predict multiple times using this dropout network, for the same input we will get different predictions depending on the neurons being dropped. We use these predictions to estimate the average final prediction and a confidence interval around it.

In the below images, we have estimated confidence intervals around the predictions of networks. These visualisations were generated with the code from [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). The red line represents the predictions. The purple shaded region around the predictions represent the uncertainty *i.e.* variance of predictions.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Uncertainty Estimation using ReLU activation
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Uncertainty Estimation using Tanh activation
</center>

As you can observe in the above images, these uncertainty estimations are not calibrated. They are different for different activation functions. Noticeably in the images, uncertainty around data points is low. Furthermore, the variance that we can observe is a differentiable function. So we can run gradient descent to minimise this variance. Thereby we can get more confident predictions.


#### If we have multiple terms contributing to total loss in our EBM model, how do they interact?

In EBM models, we can simply and conveniently sum the different terms to estimate the total loss.

**Digression**: A term that penalises the length of the latent variable can act as one of many loss terms in a model. The length of a vector is roughly proportional to the number  of dimensions it has. So if you decrease the number of dimensions, then the length of the vector decreases and as a result it encodes less information. In an auto-encoder setting, this makes sure that the model is retaining the most important information. So, one way to bottleneck information in latent spaces is to reduce the dimensionality of the latent space.


#### How can we determine the hyper-parameter for regularisation?

In practice, to determine the optimal hyper-parameter for regularisation i.e regularisation strength we can use

- Bayesian hyper-parameter Optimization
- Grid Search
- Random Search

While doing these searches, the first few epochs are usually enough to give us a sense of how the regularization is working. So we need train the model extensively.
-->

## Sobreajuste

Considere un problema de regresión. Un modelo podría: ajustarse, encajar bien o sobreajustarse.

Si el modelo no es lo suficientemente expresivo para los datos, se ajustará. Si el modelo es más expresivo que los datos (como es el caso de las redes neuronales profundas), corre el riesgo de sobreajuste.

En este caso, el modelo es lo suficientemente potente como para adaptarse tanto a los datos originales *como* al ruido, lo que produce una mala solución para la tarea en cuestión.

Idealmente, nos gustaría que nuestro modelo se ajustara a los datos subyacentes y no al ruido, produciendo un buen ajuste para nuestros datos. Nos gustaría especialmente hacer esto sin necesidad de reducir la potencia de nuestros modelos. Los modelos de aprendizaje profundo son muy poderosos, a menudo mucho más de lo estrictamente necesario para aprender los datos. Nos gustaría mantener ese poder (para facilitar el entrenamiento), pero aún así luchar contra el sobreajuste.


### Sobreajuste para depuración

El sobreajuste puede resultar útil en algunos casos, como durante la depuración. Se puede probar una red en un pequeño subconjunto de datos de entrenamiento (incluso un solo lote o un conjunto de tensores de ruido aleatorios) y asegurarse de que la red pueda sobreajustarse a estos datos. Si no aprende, es una señal de que puede haber un error.


## Regularización

Podemos intentar luchar contra el sobreajuste introduciendo la regularización. La cantidad de regularización afectará el rendimiento de validación del modelo. Muy poca regularización no resolverá el problema de sobreajuste. Demasiada regularización hará que el modelo sea mucho menos efectivo.

* Regularización * agrega conocimientos previos a un modelo; se especifica una distribución previa para los parámetros. Actúa como una restricción sobre el conjunto de posibles funciones aprendibles.

Otra definición de regularización de Ian Goodfellow:
> La regularización es cualquier modificación que hacemos a un algoritmo de aprendizaje que tiene como objetivo reducir su error de generalización pero no su error de entrenamiento.


### Técnicas de inicialización

Podemos seleccionar un previo para nuestros parámetros de red inicializando los pesos de acuerdo con una distribución particular. Una opción: [Xavier initialization](https://pytorch.org/docs/stable/nn.init.html#torch.nn.init.xavier_normal_).


### Regularización de caída de peso

La pérdida de peso es nuestra primera técnica de regularización. La pérdida de peso se usa ampliamente en el aprendizaje automático, pero menos en las redes neuronales. En PyTorch, la caída de peso se proporciona como un parámetro para el optimizador (consulte, por ejemplo, el parámetro `weight_decay` para [SGD](https://pytorch.org/docs/stable/optim.html#torch.optim.SGD)). 

Esto también se llama:

- L2
- Ridge
- Prior gaussiano

Podemos considerar un objetivo que actúa sobre los parámetros:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta)$$

entonces tenemos actualizaciones:

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta)$$

Para la disminución de peso, agregamos un término de penalización:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\frac\lambda2 {\lVert\theta\rVert}_2^2}_{\text{penalty}}$$

que produce una actualización

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\theta}_{\text{decay}}$$

Este nuevo término en la actualización lleva los parámetros $\theta$ ligeramente hacia cero, agregando algo de "decaimiento" en los pesos con cada actualización.


### Regularización L1

Disponible como una opción para PyTorch [optimizers](https://pytorch.org/docs/stable/optim.html)..

También llamado:

- LASSO: Operador selector de contracción mínima absoluta
- Prior laplaciano
- Escasa antes

Al ver esto como una distribución de Laplace anterior, esta regularización pone más masa de probabilidad cerca de cero que una distribución gaussiana.

Comenzando con la misma actualización que la anterior, podemos ver esto como agregar otra penalización:

$$J_{\text{train}}(\theta) = J^{\text{old}}_{\text{train}}(\theta) + \underbrace{\lambda{\lVert\theta\rVert}_1}_{\text{penalty}}$$

que produce una actualización

$$\theta \gets \theta - \eta \nabla_{\theta} J^{\text{old}}_{\text{train}}(\theta) - \underbrace{\eta\lambda\cdot\mathrm{sign}(\theta)}_{\text{penalty}}$$


A diferencia del decaimiento de peso de $L_2$, la regularización de $L_1$ "matará" los componentes que están cerca de un eje en el espacio de parámetros, en lugar de reducir uniformemente la longitud del vector de parámetros.


### Abandonar

La deserción implica poner a cero una cierta cantidad de neuronas al azar durante el entrenamiento. Esto evita que la red aprenda una ruta singular de entrada a salida. Del mismo modo, debido a la gran parametrización de las redes neuronales, es posible que la red neuronal memorice eficazmente la entrada. Sin embargo, con la deserción, esto es mucho más difícil, ya que la entrada se coloca en una red diferente cada vez, ya que la deserción entrena efectivamente un número infinito de redes que son diferentes cada vez. Por lo tanto, la deserción puede ser una forma poderosa de controlar el sobreajuste y ser más robusto frente a pequeñas variaciones en la entrada.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_without_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figura 1: Red sin abandono
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/network_with_dropout.JPG" style="background-color:#DCDCDC;" /><br>
Figura 2: Red con abandono
</center>


En PyTorch, podemos establecer una tasa de abandono aleatoria de neuronas.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/code.JPG" style="background-color:#DCDCDC;" /><br>
Figura 3: Código de abandono
</center>


Después del entrenamiento, durante la inferencia, la deserción ya no se usa. Con el fin de crear la red final para la inferencia, promediamos todas las redes individuales creadas durante el abandono y las usamos para la inferencia. De manera similar, podemos multiplicar todos los pesos por $1/1-p$ donde $p$ es la tasa de abandono.


### Parada temprana

Durante el entrenamiento, si la pérdida de validación comienza a aumentar, podemos detener el entrenamiento y usar los mejores pesos encontrados hasta ahora. Esto evita que los pesos crezcan demasiado, lo que comenzará a dañar el rendimiento de la validación en algún momento. En la práctica, es común calcular el rendimiento de la validación en ciertos intervalos y detenerse después de que un cierto número de cálculos de errores de validación dejan de disminuir.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/early_stop.JPG" style="background-color:#DCDCDC;" /><br>
Figura 4: Parada anticipada
</center>



# Lucha contra el sobreajuste indirecto

Hay técnicas que tienen el efecto secundario de regularizar parámetros pero no son regularizadores en sí mismos.


## Norma de lote

P. ¿Cómo la norma por lotes hace que la capacitación sea más eficiente?
R. Podemos utilizar una tasa de aprendizaje más alta al aplicar la norma por lotes.

La normalización por lotes se utiliza para evitar el cambio de covariables interno de una red neuronal, pero existe un gran debate sobre si realmente hace esto y cuál es el verdadero beneficio.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/BN.JPG" style="background-color:#DCDCDC;" /><br>
Figura 5: Normalización por lotes
</center>


La normalización por lotes esencialmente extiende la lógica de normalizar la entrada de la red neuronal para normalizar la entrada de cada capa oculta en la red. La idea básica es tener una distribución fija que alimente cada capa subsiguiente de una red neuronal, ya que el aprendizaje ocurre mejor cuando tenemos una distribución fija. Para hacer esto, calculamos la media y la varianza de cada lote antes de cada capa oculta y normalizamos los valores entrantes mediante estas estadísticas específicas del lote, lo que reduce la cantidad en la que los valores finalmente cambiarán durante el entrenamiento.

Con respecto al efecto de regularización, debido a que cada lote es diferente, cada muestra se normalizará con estadísticas ligeramente diferentes basadas en el lote en el que se encuentra. Por lo tanto, la red verá varias versiones ligeramente alteradas de una sola entrada que ayuda a la red a aprender a ser más robusto frente a ligeras variaciones en la entrada y evita el sobreajuste.

Otro beneficio de la normalización por lotes es que el entrenamiento es mucho más rápido.


### Más datos

Recopilar más datos es una forma fácil de evitar el sobreajuste, pero puede resultar caro o no factible.


### Aumento de datos

Las transformaciones que utilizan Torchvision pueden tener un efecto de regularización al enseñar a la red a aprender a ser insensible a las perturbaciones.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/augmentation.JPG" style="background-color:#DCDCDC;" /><br>
Figure 6: Data augmentation with Torchvision.
</center>


### Ajuste fino de inclinación de transferencia (TF) (FT)

El aprendizaje por transferencia (TF) se refiere simplemente a entrenar a un clasificador final en la parte superior de una red previamente entrenada (generalmente se usa en casos de pocos datos).

El ajuste fino (FT) también se refiere al entrenamiento de porciones parciales / completas del netowrk previamente entrenado (utilizado en los casos en los que tenemos muchos datos en general).

P. Generalmente, ¿cuándo deberíamos congelar las capas de un modelo previamente entrenado?
R. Si tenemos pocos datos de entrenamiento.

4 casos generales:
1) Si tenemos pocos datos con distribuciones similares, podemos simplemente transferir el aprendizaje.
2) Si tenemos muchos datos con distribuciones similares, podemos hacer ajustes para mejorar también el rendimiento del extractor de características.
3) Si tenemos pocos datos y una distribución diferente, deberíamos eliminar algunas de las capas finales entrenadas en el extractor de características, ya que son demasiado especializadas.
4) Si tenemos muchos datos y son de diferentes distribuciones, podemos entrenar todas las porciones.

Tenga en cuenta que también podemos usar diferentes tasas de aprendizaje para diferentes capas a fin de mejorar el rendimiento.

Para ampliar nuestra discusión sobre el sobreajuste y la regularización, veamos las visualizaciones a continuación. Estas visualizaciones se generaron con el código de [Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/12-regularization.ipynb).

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_wo_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b>  Curvas de pérdida sin abandono
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/loss_w_dropout.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Curvas de pérdida con deserción
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/regularization_weights.png"  style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Efecto de la regularización sobre los pesos
</center>



De la Figura 7 y la Figura 8, podemos comprender el efecto dramático que tiene la deserción en el error de generalización, es decir, la diferencia entre la pérdida de entrenamiento y la pérdida de validación. En la Figura 7, sin abandonos hay un claro sobreajuste ya que la pérdida de entrenamiento es mucho menor que la pérdida de validación.

 Sin embargo, en la Figura 8, con el abandono, la pérdida de entrenamiento y la pérdida de validación se superponen casi continuamente, lo que indica que el modelo se está generalizando bien al conjunto de validación, que sirve como nuestro proxy para el conjunto fuera de la muestra. Por supuesto, podemos medir el rendimiento real fuera de la muestra utilizando un conjunto de pruebas de exclusión por separado.

En la Figura 9, observamos el efecto que tiene la regularización (L1 y L2) sobre los pesos de la red.

- Cuando aplicamos la regularización L1, desde el pico rojo en cero, podemos entender que la mayoría de los pesos son cero. Los pequeños puntos rojos más cercanos a cero son los pesos distintos de cero del modelo.

- Por el contrario, en la regularización L2, desde el pico azul cercano a cero podemos ver que la mayoría de los pesos están cerca de cero pero distintos de cero.

- Cuando no hay regularización (lavanda) los pesos son mucho más flexibles y se distribuyen alrededor de cero pareciendo una distribución normal.


## Redes neuronales bayesianas: estimación de la incertidumbre en torno a las predicciones

Nos preocupamos por la incertidumbre en las redes neuronales porque una red necesita saber qué tan segura / segura de su predicción.

Por ejemplo: si construye una red neuronal para predecir el control de dirección, necesita saber qué tan confiables son las predicciones de la red.

Podemos usar una red neuronal con abandono para obtener un intervalo de confianza alrededor de nuestras predicciones. Entrenemos una red con deserción, siendo $r$ la tasa de deserción.

Por lo general, durante la inferencia, configuramos la red en modo de validación y usamos todas las neuronas para obtener la predicción final. Mientras hacemos la predicción, escalamos los pesos $\delta$ por $\dfrac {1} {1-r}$ para tener en cuenta la caída de neuronas durante el entrenamiento.

Este método nos da una única predicción para cada entrada. Sin embargo, para obtener un intervalo de confianza alrededor de nuestra predicción, necesitamos múltiples predicciones para la misma entrada. Entonces, en lugar de configurar la red en modo de validación durante la inferencia, la retenemos en modo de entrenamiento *es decir,* todavía suelta neuronas al azar y obtenemos una predicción. Cuando predecimos varias veces usando esta red de deserción, para la misma entrada obtendremos diferentes predicciones dependiendo de las neuronas que se eliminen. Usamos estas predicciones para estimar la predicción final promedio y un intervalo de confianza a su alrededor.

En las siguientes imágenes, hemos estimado intervalos de confianza en torno a las predicciones de redes. Estas visualizaciones se generaron con el código de [Bayesian Neural Networks Notebook](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/13-bayesian_nn.ipynb). La línea roja representa las predicciones. La región sombreada de color púrpura alrededor de las predicciones representa la incertidumbre *es decir,* la varianza de las predicciones.

<center>
<img src="{{site.baseurl}}/images/week14/14-3/relu_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Estimación de la incertidumbre mediante la activación de ReLU
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-3/tanh_bayesian_nn.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Estimación de la incertidumbre mediante la activación de Tanh
</center>


Como puede observar en las imágenes anteriores, estas estimaciones de incertidumbre no están calibradas. Son diferentes para diferentes funciones de activación. Notablemente en las imágenes, la incertidumbre en torno a los puntos de datos es baja. Además, la varianza que podemos observar es una función diferenciable. Entonces podemos ejecutar un descenso de gradiente para minimizar esta variación. De este modo podemos obtener predicciones más seguras.


#### Si tenemos varios términos que contribuyen a la pérdida total en nuestro modelo de EBM, ¿cómo interactúan?

En los modelos EBM, podemos sumar de manera simple y conveniente los diferentes términos para estimar la pérdida total.

**Digresión**: un término que penaliza la longitud de la variable latente puede actuar como uno de los muchos términos de pérdida en un modelo. La longitud de un vector es aproximadamente proporcional al número de dimensiones que tiene. Entonces, si disminuye el número de dimensiones, la longitud del vector disminuye y, como resultado, codifica menos información. En una configuración de codificador automático, esto asegura que el modelo está reteniendo la información más importante. Entonces, una forma de bloquear la información en los espacios latentes es reducir la dimensionalidad del espacio latente.


#### ¿Cómo podemos determinar el hiperparámetro para regularización?

En la práctica, para determinar el hiperparámetro óptimo para la regularización, es decir, la fuerza de regularización, podemos usar

- Optimización de hiperparámetros bayesianos
- Búsqueda de cuadrícula
- Búsqueda aleatoria

Al hacer estas búsquedas, las primeras épocas suelen ser suficientes para darnos una idea de cómo está funcionando la regularización. Entonces necesitamos train el modelo extensamente.
