---
lang-ref: ch.14-2
lang: es
lecturer: Yann LeCun
title: Graphical Energy-based Methods
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
date: 15 Sep 2020
translator: lcipolina (Lucia Cipolina-Kun)
---

<!--
## Comparing Losses

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center>

In the figure above, incorrect paths have -1.

Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.

In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.

Q: How is the segmentor implemented in the model above?

A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition.
-->
## Comparación de pérdidas

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figura 1: Arcitectura de la red
</center>

En la figura anterior, las rutas incorrectas tienen -1.

El profesor LeCun comienza con la pérdida de perceptrón, que se utiliza en el ejemplo de Graph Transformer Model en la figura anterior. El objetivo es aumentar la energía de las respuestas incorrectas y reducir las respuestas correctas.

En términos de implementación, representaría los arcos en la visualización con un vector. En lugar de un arco separado para cada categoría, un vector contiene tanto las categorías como la puntuación para cada categoría.

P: ¿Cómo se implementa el segmento o en el modelo anterior?

R: El segmento es heurístico artesanal. El modelo utiliza un segmento artesanal aunque hay una forma de hacerlo entrenable de principio a fin. Este enfoque artesanal fue reemplazado por el enfoque de ventana deslizante para el reconocimiento de personajes.

<!--
## Overview of Losses

<center>
Table 1: Various Loss Equations
</center>

| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.

* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.

Q: How may hinge be better than NLL loss?

A: Hinge is better than NLL becuase NLL will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m). 
-->

## Resumen de las funciones de pérdida

<center>
Tabla 1: Varias ecuaciones de pérdida
</center>

| Ecuacion de pérdida | Formula  | Margen |
| :---- | :----: | ---:|
| Perdida de energia | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Bisagra  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Cuadrado-cuadrado | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Cuadrado-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


La pérdida de perceptrón que se ve en la tabla anterior no tiene margen y, por lo tanto, la pérdida tiene el riesgo de colapsar.

* La <<pérdida de bisagra>> consiste en tomar la energía de la peor respuesta y la respuesta correcta y calcular su diferencia. Intuitivamente, con un margen 'm', la bisagra solo tendrá una pérdida de 0 cuando la energía correcta sea menor que la energía más ofensiva en (al menos) 'm'.
* La pérdida de MCE se utiliza en el reconocimiento de voz y se parece a un sigmoide.
* La pérdida de NLL tiene como objetivo hacer que la energía de la respuesta correcta sea pequeña y que el componente logarítmico de la ecuación sea grande.

P: ¿Cómo puede ser mejor la bisagra que la pérdida NLL?

R: Bisagra es mejor que NLL porque NLL intentará llevar la diferencia entre la respuesta correcta y otras respuestas al infinito, mientras que Hinge solo quiere que sea más grande que algún valor (el margen m).

<!--
### DEFINITION:

A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.

Q: What are some examples of problems that can use decoders? 
A: Language modelling, machine translation, and sequence tagging. 
-->
### DEFINICIÓN:

Un decodificador ltoma como variable de entrada una secuencia de vectores que indican las puntuaciones o la energía de sonidos o imágenes individuales y selecciona la mejor salida posible.

P: ¿Cuáles son algunos ejemplos de problemas que se pueden utilizar con decodificadores?
R: Modelado de idiomas, traducción automática y etiquetado de secuencias.

<!--
## Forward algorithm in Graph Transformer Networks

### Graph Composition

Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center>

The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.

Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?

The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values. 

If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.

In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.

As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.
-->

## Algoritmo de avance en redes de transformadores de grafos

### Composición de grafos

La composición de grafos nos permite combinar dos grafos. En este ejemplo, podemos ver un léxico de un modelo de lenguaje representado como $trie$ (un grafo) y un grafo de reconocimiento producido por una red neuronal.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figura 2</b>: Composicion del grafo
</center>

El grafo de reconocimiento especifica con diferentes valores de energía (asociados con cada arco) la probabilidad de que un personaje esté en un paso en particular.

Ahora, para este ejemplo, la pregunta que respondemos con una operación de composición de grafo es, ¿cuál es el mejor camino en este grafo de reconocimiento que también concuerda con nuestro léxico?

El salto común del paso 1 al paso 2 entre el grafo de reconocimiento y la gramática es el carácter $ c$, asociado con la energía 0.4. Por lo tanto, nuestro grafo de interpretación contiene solo 1 arco entre el paso 1 y 2 correspondiente a $c$. De manera similar, los caracteres posibles entre los pasos 2 y 3 son $ x$, $u$ y $ a$ en el gráfico de reconocimiento. Las ramas que siguen a $ c$ en el gráfico gramatical contienen $ u$ y $ a$. Entonces, la operación de composición de grafos selecciona los arcos $ u$ y $a$ para que estén presentes en el grafo de interpretación. También asocia el arco que copia del grafo de reconocimiento con sus valores de energía.

Si la gramática también contuviese valores de energía asociados con arcos, la composición del grafo habría agregado los valores de energía o los habría combinado usando algún otro operador.

De manera similar, la composición de grafos también nos permite combinar dos bases de conocimiento que están representadas por redes neuronales. En el ejemplo discutido anteriormente, la gramática se puede representar esencialmente como una red neuronal que predice el siguiente carácter. La salida softmax del NN nos proporciona las probabilidades de transición al siguiente carácter de un nodo dado.

Como nota al margen, si el modelo de lenguaje que se muestra en este ejemplo es una red neuronal, podemos propagar hacia atrás a través de toda la estructura. Esto se convierte en un ejemplo de un programa diferenciable en el que retropropagamos a través de un programa que contiene bucles, condiciones if, recursiones, etc.

<!--
### A check reader from mid-90s

The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center>

This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.

The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.

Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.
-->

Toda la arquitectura de un lector de cheques de mediados de los 90 es bastante compleja, pero lo que más nos interesa es la parte que parte del reconocedor de caracteres, que produce el gráfico de reconocimiento.

<centro>
<img src = "{{site.baseurl}} / images / week14 / 14-2 / check_reader.png" /> <br>
<b> Figura 3 </b>: lector de cheques
</center>

Este gráfico de reconocimiento se somete a dos operaciones de composición separadas, una con la interpretación correcta (o la verdad básica) y la segunda con la gramática que crea un gráfico de todas las posibles interpretaciones.

Todo el sistema se entrena mediante la función de pérdida de probabilidad logarítmica negativa. La probabilidad logarítmica negativa dice que cada camino en el grafo de interpretación es una posible interpretación y la suma de energías a lo largo de ese camino es la energía de esa interpretación.

Ahora, en lugar de usar el algoritmo de Viterbi, usamos el algoritmo de avance. Las siguientes subsecciones discuten las diferencias entre los dos enfoques.

<!--
#### Viterbi algorithm

Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.

$$F (x, y) = \min_{z} \; E(x, y, z)$$
-->
#### Algoritmo de Viterbi

El algoritmo de Viterbi es un algoritmo de programación dinámica que se utiliza para encontrar la ruta más probable (o la ruta con la energía mínima) en un gráfico dado. Minimiza la energía con respecto a una variable latente z, donde z representa el camino que estamos tomando en la gráfica.

$$ F (x, y) = \min_ {z} \; E (x, y, z) $$

<!--
#### The forward algorithm

The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.

The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.

The working of the forward algorithm can be shown using the following example defined on an interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center>
-->

#### El algoritmo de avance
El algoritmo directo, por otro lado, calcula el logaritmo de la suma de exponenciales del valor negativo de las energías de todos los caminos. Esto se puede ver fácilmente como una fórmula a continuación:

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

Esto es marginalizar sobre la variable latente z, que define las rutas en un grafo de interpretación. Este enfoque calcula este valor exponencial de suma logarítmica en todas las rutas posibles a un nodo en particular. Esto es como combinar el costo de todos los caminos posibles de una manera mínima suave.

El algoritmo de reenvío es barato de implementar y no cuesta más que el algoritmo de Viterbi. Además, podemos propagar hacia atrás a través del nodo del algoritmo de avance en el gráfico.

El funcionamiento del algoritmo de avance se puede mostrar utilizando el siguiente ejemplo definido en un gráfico de interpretación.

<centro>
<img src = "{{site.baseurl}} / images / week14 / 14-2 / ​​identity_graph.png" height = "50%" width = "50%" /> <br>
<b> Figura 4 </b>: Gráfico de interpretación
</center>

<!--
The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.

For the red node, the value of energy at the node is given by:

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$
-->
El costo desde el nodo de entrada hasta el nodo sombreado en rojo se calcula marginando todos los caminos posibles que llegan al nodo rojo. Las flechas que entran en el nodo rojo definen estas posibles rutas en nuestro ejemplo.

Para el nodo rojo, el valor de la energía en el nodo viene dado por:


$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

<!--
#### Neural network analogy of forward algorithm

The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term. 

For each node in the interpretation graph, we maintain a variable $\alpha$.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

where $e_{ki}$ is the energy of the link from node $k$ to node $i$. 

$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.

We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>
-->
#### Analogía de red neuronal del algoritmo directo

El algoritmo de avance es un caso especial del algoritmo de propagación de creencias, cuando el grafo subyacente es un grafo de cadena. Todo este algoritmo puede verse como una red neuronal de retroalimentación donde la función en cada nodo es una suma logarítmica de exponenciales y un término de suma.

Para cada nodo en el gráfico de interpretación, mantenemos una variable $\alpha$.

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

donde $ e_ {ki} $ es la energía del enlace desde el nodo $ k $ al nodo $i$.

$\alpha_i$ forma la activación de un nodo $i$ en esta red neuronal y $e_ {ki}$ es el peso entre los nodos $k$ y el nodo $i$. Esta formulación es algebraicamente equivalente a las operaciones de suma ponderada de una red neuronal regular en el dominio logarítmico.

Podemos retropropagar a través del gráfico de interpretación dinámica (ya que cambia de un ejemplo a otro) en el que aplicamos el algoritmo de avance. Podemos calcular los gradientes de $F (x, y)$ calculados en el último nodo del grafo con los pesos $e_ {ki}$ que definen los bordes del gráfico de interpretación.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>

<!--
Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.

The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations.
-->
Volviendo al ejemplo del lector de cheques, aplicamos el algoritmo de avance en las dos composiciones de grafos y obtenemos el valor de energía en el último nodo utilizando el foro exponencial de suma logarítmica. La diferencia entre estos valores de energía es la pérdida de probabilidad logarítmica negativa.

El valor obtenido al aplicar el algoritmo de avance en la composición del gráfico entre la respuesta correcta y el gráfico de reconocimiento es el valor exponencial de la suma logarítmica de la respuesta correcta. Por el contrario, el valor exponencial de la suma logarítmica en el último nodo de la composición del gráfico entre el gráfico de reconocimiento y la gramática es el valor marginado sobre todas las posibles interpretaciones válidas.

<!--
# Lagrangian formulation of Backpropagation
For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.

The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).

To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.

- For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.
-->
# Formulación Lagrangiana de retropropagación
Para una entrada $x$ y una salida objetivo $y$, podemos formular una red como una colección de funciones, $f_k$ y pesos, $w_k$ de manera que los pasos sucesivos en la red generen $z_k$ con $z_ {k + 1} = f_k (z_k, w_k)$. En un entorno supervisado, el objetivo de la red es minimizar $C (z_n, y)$, el costo de la salida $n ^ \mathrm {th}$ de la red, con respecto a la verdad del terreno. Esto es equivalente al problema de minimizar $C (z_n, y)$ con respecto a las restricciones $z_ {k + 1} = f_k (z_k, w_k)$ y $z_0 = x$.

El lagrangiano se puede escribir:
$$ \mathcal {L} (x, y, \lambda_i, z_i, w_i) = C (z_n, y) + \sum \limits_ {k = 0} ^ {n-1} \lambda ^ T_ {k + 1 } (z_ {k + 1} - f_k (z_k, w_k)) $$

donde los términos $\lambda$ denotan multiplicadores de Lagrange (ver [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) para un repaso si Calc 3 fue tomada hace un tiempo).

Para minimizar $\mathcal {L}$, necesitamos establecer las derivadas parciales de $\ mathcal{L}$ con respecto a cada uno de sus argumentos a cero y resolver.

- Para $\lambda$, simplemente recuperamos la restricción:  $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- 
- Para $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, que es solo la fórmula de retropropagación estándar.

<!--
This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.

In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.
-->

Este enfoque se originó con Lagrange y Hamilton en el contexto de la Mecánica Clásica, donde la minimización está sobre la energía del sistema y los términos $\lambda$ denotan restricciones físicas del sistema, como dos bolas que se ven obligadas a permanecer a una distancia fija. unos de otros en virtud de estar unidos por una barra de metal, por ejemplo.

En una situación en la que necesitamos minimizar el costo $C$ en cada paso de tiempo, $k$, el Lagrangiano se convierte en

$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.


<!--
# Neural Ordinary Differential Equation
Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).
-->

# Ecuación diferencial ordinaria neural (ODE)
Usando esta formulación de retropropagación, ahora podemos hablar de una nueva clase de modelos, Neural ODEs (Ecuacion Diferencial Ordinaria). Estas son básicamente redes recurrentes donde el estado, $z$, en el momento $ t $ viene dado por $ z_{t+\text{d}t} = z_t + f(z_t, W) dt$, donde $ W $ representa un conjunto de parámetros fijos.

Esto también se puede expresar como una ecuación diferencial ordinaria (sin derivadas parciales): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Entrenar una red de este tipo utilizando la formulación lagrangiana es muy sencillo. Si tenemos un objetivo, $y$, y queremos que el estado del sistema alcance $y$ en el tiempo $T$, simplemente establecemos la función de costo como la distancia entre $z_T$ y $ y $. Otro objetivo de la red podría ser encontrar un estado estable del sistema, es decir, uno que deje de cambiar después de cierto punto.

 Matemáticamente, esto es equivalente a establecer $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. En general, encontrar una solución, $y$ para esta ecuación es mucho más fácil que la propagación hacia atrás en el tiempo, porque la red no necesita recordar el gradiente con respecto a toda la secuencia, y solo tiene que minimizar $f$ o $ \lvert f \rvert ^ 2$. Para obtener más información sobre el entrenamiento de ODE neuronales para alcanzar puntos fijos, consulte [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf).


<!--
# Variational Inference in terms of Energy

## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.

We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
-->

# Inferencia variacional en términos de energía

## Introducción
Para una función de energía elemental $E (x, y, z)$, si deseamos marginar sobre una variable, z, para obtener una pérdida en términos de solo $x$ y $y$, $L (x, y)$, debemos calcular

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

Si luego multiplicamos por $\frac {q (z)} {q (z)}$, obtenemos
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

Si asumimos que $q (z)$ es una distribución de probabilidad sobre $z$, podemos interpretar nuestra integral de función de pérdida reescrita como un valor esperado, con respecto a la distribución de $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.

Usamos esta interpretación, la Desigualdad de Jensen y las aproximaciones basadas en muestreo, para optimizar indirectamente nuestra función de pérdida.

<!--
## Jensen's Inequality

Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>
-->
## Desigualdad de Jensen

La desigualdad de Jensen es una observación geométrica que establece: si tenemos una función convexa, entonces la *expectativa* de esa función, en un rango, es menor que el promedio de la función evaluada al principio y al final del rango. Ilustrado geométricamente, esto es muy intuitivo:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

<!--
Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
-->
Asimismo, si $F$ es convexo, para una distribución de probabilidad fija $q$, podemos inferir de la Desigualdad de Jensen que en el rango $z$,

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

Ahora, recuerde que nuestro $L (x, y)$ marginado después de la multiplicación con $\frac {q (z)} {q (z)}$ es,
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!--

If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.
-->

Si hacemos $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, sabemos de la desigualdad de Jensen $(1)$ que

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

Continuemos trabajando esto, con una función de pérdida convexa concreta, $F(x) = - \log(x)$

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

¡Excelente! Ahora tenemos un límite superior para nuestra función de pérdida $L (x, y)$, compuesto por dos términos que entendemos. El primer término $\int_z q (z) E (x, y, z)$ es la energía *promedio*. Y el segundo término $\frac{1} {\beta} \int_z \log (q (z))$ es solo un factor ($ - \frac {1} {\ beta}$) multiplicado por la *entropía* del distribución $q$.

<!--
## What's the point?

We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!

To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.

The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.

Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$.

## Summary
This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about.
-->

## ¿Cuál es el punto?

Ahora hemos formulado un límite superior de tal manera que podemos evitar integraciones complicadas y, en cambio, simplemente aproximar estos valores tomando muestras de una distribución sustituta ($q(z)$) ¡de nuestra elección!

Para obtener el valor del primer término de nuestra función de límite superior, simplemente tomamos una muestra de esa distribución y calculamos el valor promedio de $L$ que obtenemos aplicando nuestros $z$ de muestra.

El segundo término (un factor de entropía) es solo una propiedad de la familia de distribución, y también puede aproximarse con un muestreo aleatorio de $ q $.

Finalmente, podemos minimizar $L$ con respecto a sus parámetros (digamos, pesos de una red $W$), minimizando esta función que limita $L$ arriba. Llevamos a cabo esta minimización actualizando nuestras dos variables: (1) la entropía de $ q $ y (2) los parámetros de nuestro modelo $ W $.

## Resumen
Ésta es la "visión energética" de la inferencia variacional. Si necesita calcular el logaritmo de una suma de exponenciales, reemplácelo con el promedio de su función más un término de entropía. Esto nos da un límite superior. Luego minimizamos este límite superior y, al hacerlo, minimizamos la función que realmente nos importa.
