---
lang-ref: ch.14-1
lang: es
lecturer: Yann LeCun
title: Aprendizaje profundo para prediccion estructurada
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
translator: lcipolina (Lucia Cipolina-Kun)
date: 15 Sep 2020
---

<!--
<!## Structured Prediction

It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values.
For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain.
-->

## Predicción estructurada

Es el problema de predecir la variable 'y' para una entrada 'x' dada que es mutuamente dependiente y restringida, en lugar de valores escalares discretos o reales. La variable de salida no pertenece a una sola categoría, sino que puede tener un numero de valores posibles exponenciales o infinitos.
Por ejemplo: en el caso de reconocimiento de voz, escritura a mano o traducción de lenguaje natural, la salida debe ser gramaticalmente correcta y no es posible limitar el número de posibilidades de salida. La tarea del modelo es capturar la estructura secuencial, espacial o combinatorial en el dominio del problema.


<!--
### Early works on structured prediction

This vector is fed to a TDNN which gives a feature vector which in case of model systems can be compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used.

The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center>

This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance.

To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every incorrect answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients.
-->

### Primeros trabajos sobre predicción estructurada

Este vector se alimenta a un TDNN que proporciona un vector de características que, en el caso de los sistemas modelo, se puede comparar con softmax, el cual representa una categoría. Un problema que surge en el caso de reconocer la palabra que se pronunció, es que diferentes personas pueden pronunciar la misma palabra de diferentes formas y velocidades. Para resolver esto se utiliza "Deformación en Tiempo Dinámico".

La idea es proporcionar al sistema un conjunto de plantillas (templates) pregrabadas que correspondan a vectores de secuencia o características que alguien haya registrado. La red neuronal se entrena al mismo tiempo que la plantilla para que el sistema aprenda a reconocer la palabra en diferentes pronunciaciones. La variable latente nos permite deformar en el tiempo el vector de características para que coincida con la longitud de las plantillas.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figura 1.
</center>

Esto se puede visualizar como una matriz ordenando los vectores de características de TDNN horizontalmente y las plantillas de palabras verticalmente. Cada entrada en la matriz corresponde a la distancia entre el vector de características. Esto se puede visualizar como un problema de grafos en el que el objetivo es comenzar desde la esquina inferior izquierda y llegar a la esquina superior derecha atravesando el camino que minimiza la distancia.

Para entrenar este modelo de variable latente, necesitamos hacer que la energía para las respuestas correctas sea lo más pequeña posible y más grande para cada respuesta incorrecta. Para hacer esto, usamos una función objetivo que toma plantillas para palabras incorrectas y las aleja de la secuencia actual de características y propaga hacia atrás los gradientes.

<!--
## Energy based factor graphs

The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The benefit of these models is that efficient inference algorithms can be employed.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center>
-->

## Grafos de factores basados en energía

La idea detrás de los grafos de factores basados en energía es construir un modelo basado en "energía" en el que la energía es la suma de términos parciales de energía cuando la probabilidad es un producto de factores. El beneficio de estos modelos es que se pueden emplear algoritmos de inferencia eficientes.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figura 2.
</center>

<!--
### Sequence Labeling

The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center>

In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels.
-->


### Etiquetado de secuencia

El modelo toma una señal de entrada de voz 'X' y devuelve las etiquetas 'Y' de manera que las etiquetas de salida minimizan el término de energía total.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figura 3.
</center>

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figura 4.
</center>

En este caso, la energía es una suma de tres términos representados por los cuadrados azules que son redes neuronales que producen vectores de características para las variables de entrada. En el caso del reconocimiento de voz, la 'X' se puede considerar como una señal de voz y los cuadrados implementan las restricciones gramaticales, las 'Y' representan las etiquetas de salida generadas.


<!--
## Efficient Inference for Energy-Based Factor Graphs

A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):

Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center>

A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding:

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations).

However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence,
there is no need for more than $2 + 4 + 4 + 6 = 16$ single factor evaluations.

Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom).

The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general.

To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$.


The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure.

However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent algorithm such as simulated annealing could be used.
-->




## Inferencia eficiente para gráficos de factores basados en energía

Un tutorial sobre el aprendizaje basado en la energía (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc'Aurelio Ranzato y Fu Jie Huang 2006):

El aprendizaje y la inferencia con modelos basados en energía implican una minimización de la energía sobre el conjunto de respuestas $\mathcal {Y}$ y variables latentes $\ mathcal {Z}$. Cuando la cardinalidad de $\ mathcal {Y} \ times \ mathcal {Z}$ es grande, esta minimización puede volverse intratable. Una forma de abordar el problema es aprovechar la estructura de la función energética para realizar la minimización de manera eficiente. Un caso en el que se puede explotar la estructura ocurre cuando la energía se puede expresar como una suma de funciones individuales (llamadas factores) que dependen de diferentes subconjuntos de las variables en Y y Z. Estas dependencias se expresan mejor en la forma de un factor grafico. Los grafos de factores son una forma general de modelos de grafos o de "redes de creencias".

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figura 5.
</center>

En la Figura (arriba) se muestra un ejemplo simple de un gráfico de factores. La función de energía es la suma de cuatro factores:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

donde $Y = [Y_1, Y_2]$ son las variables de salida y $Z = [Z_1, Z_2]$ son las variables latentes. Cada factor puede verse como una representación de restricciones suaves entre los valores de sus variables de entrada. El problema de la inferencia consiste en encontrar:

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

Supongamos que $Z_1$, $ Z_2$ y $ Y_1$ son variables binarias discretas y que $ Y_2$ es una variable ternaria. La cardinalidad del dominio de $ X$ es inmaterial ya que X siempre es observable. El número de configuraciones posibles de $ Z$ y $ Y$ dado X es $2 \times 2 \times 2 \times 3 = 24$. Un algoritmo de minimización ingenuo a través de una búsqueda exhaustiva evaluaría la función de energía completa 24 veces (96 evaluaciones de un solo factor).

Sin embargo, notamos que para un $X$ dado, $E_a$ solo tiene dos configuraciones de entrada posibles: $Z_1 = 0$ y $Z_1 = 1$. De manera similar, $E_b$ y $E_c$ solo tienen 4 configuraciones de entrada posibles, y $E_d$ tiene 6. Por lo tanto, no hay necesidad de más de $2 + 4 + 4 + 6 = 16$ evaluaciones de un solo factor.

Por lo tanto, podemos calcular previamente los 16 valores de los factores y colocarlos en los arcos en una grilla  como se muestra en la Figura de arriba (parte inferior).

Los nodos de cada columna representan los posibles valores de una sola variable. Cada flanco está ponderado por la energía de salida del factor para los valores correspondientes de sus variables de entrada. Con esta representación, una única ruta desde el nodo inicial al nodo final representa una posible configuración de todas las variables. La suma de los pesos a lo largo de un camino es igual a la energía total para la configuración correspondiente. Por lo tanto, un problema de inferencia se puede reducir a buscar la ** ruta más corta ** en este gráfico. Esto se puede realizar utilizando un método de programación dinámica como el algoritmo de Viterbi o el algoritmo A *. El costo es proporcional al número de aristas (16), que es exponencialmente menor que el número de caminos en general.

Para calcular $E (Y, X) = \ min_ {z \ in Z} E (Y, z, X)$, seguimos el mismo procedimiento, pero restringimos el grafo al subconjunto de arcos que son compatibles con el valor de $Y$.


El procedimiento anterior a veces se denomina algoritmo de suma mínima y es la versión de dominio de registro del producto máximo tradicional para modelos gráficos. El procedimiento se puede generalizar fácilmente a grafos de factores donde los factores toman más de dos variables como entradas, y a grafos de factores que tienen una estructura de árbol en lugar de una estructura de cadena.

Sin embargo, solo se aplica a los grafos de factores que son árboles bipartitos (sin bucles). Cuando hay bucles en el gráfico, el algoritmo de suma mínima puede dar una solución aproximada cuando se repite, o puede que no converja en absoluto. En este caso, se podría utilizar un algoritmo de descenso como el annealing.


<!--
## Simple Energy-Based Factor Graphs with “Shallow” Factors

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center>

The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about)

Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$

And then we can think about like what type of loss function. Here comes several different models.
-->

## Grafos simples de factores basados ​​en energía con factores "superficiales"

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figura 6.
</center>

El grafo de factores que se muestra en la Figura anterior es un grafo de factores de dominio logarítmico para modelos estructurados lineales (estamos hablando de "grafos de factores simples basados ​​en energía")

Cada factor es una función lineal de los parámetros entrenables. Depende de la entrada y de un par de etiquetas individuales $(Y_m, Y_n)$. En general, cada factor podría depender de más de dos etiquetas individuales, pero limitaremos la discusión a factores por pares para simplificar la notación:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Aquí $\ mathcal {F}$ denota el conjunto de factores (el conjunto de pares de etiquetas individuales que tienen una interdependencia directa), $W_ {mn}$ es el vector de parámetro para el factor $(m, n),$ y $f_ {mn} \ left (X, Y_ {m}, Y_ {n} \ right)$ es un vector de características (fijo). El vector de parámetro global $W$ es la concatenación de todos los $W_ {m n}.$

Y luego podemos pensar en qué tipo de función de pérdida utilizar. Aquí vienen varios modelos diferentes.

<!--
### Conditional Random Field

We can use the negative log-likelihood loss function to train a linear structured model.

This is the Conditional Random Field

The intuition is we want the energy of the correct answer to below and want the log of exponential for all the answers, including the good one, to be large.

Below is the formal definition for the negative log-likelihood loss function:

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$
-->

### Campo aleatorio condicional

Podemos usar la función de pérdida de probabilidad logarítmica negativa para entrenar un modelo estructurado lineal.

Este es el campo aleatorio condicional

La intuición es que queremos la energía de la respuesta correcta a la ecuacion debajo y ademas queremos que el logaritmo de exponencial para todas las respuestas, incluida la buena, sea grande.

A continuación se muestra la definición formal de la función de pérdida de probabilidad logarítmica negativa:

$$\mathcal{L} _ {\mathrm{nll}} (W) = \frac {1} {P} \ sum_ {i = 1} ^ {P} E \left (W, Y ^ {i}, X ^ {i} \right) + \ frac {1} {\beta} \log \sum_ {y \ in \mathcal {Y}} e ^ {- \beta E \left (W, y, X ^ {i } \right)}$$

<!--
### Max Margin Markov Nets and Latent SVM

We can also using the Hinge loss function for optimization.

The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway.

This is the idea behind Max Margin Markov Nets and Latent SVM.
-->

### Redes de márgenes de margen máximo y SVM latente

También podemos utilizar la función de pérdida "de bisagra" para la optimización.

La intuición detrás es que queremos que la energía de la respuesta correcta sea baja, y luego entre todas las configuraciones posibles de respuestas incorrectas, vamos a buscar la que tenga la energía más baja entre todas las equivocadas o malas. Luego vamos a impulsar la energía de este. No necesitamos aumentar la energía para las otras respuestas malas porque de todos modos son más grandes.


<!--
### Structured Perceptron model

We can train the linear structured model by using perceptron loss.

Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP:

$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$

where $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ is the answer produced by the system.
-->

### Modelo de perceptrón estructurado

Podemos entrenar el modelo estructurado lineal usando la pérdida de perceptrón.

Collins [Collins, 2000, Collins, 2002] ha abogado por su uso para modelos estructurados lineales en el contexto de la PNL:

$$
\mathcal {L} _ {\text {perceptron}} (W) = \frac {1} {P} \sum_ {i = 1} ^ {P} E \left (W, Y ^ {i}, X ^ {i} \right) -E \left (W, Y ^ {* i}, X ^ {i} \right)
$$

donde $Y ^ {* i} = \operatorname {argmin} _ {y \ in \mathcal {Y}} E \left (W, y, X ^ {i} \right)$ es la respuesta producida por el sistema.

<!--
#### Early trails on discriminative training for speech/handwritten recognition.

Minimum Empirical Error Loss (Ljolje, and Rabiner 1990):

By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use neural networks, and have other ways in turning speech signals into sound categories.
-->

#### Primeras pistas sobre entrenamiento discriminativo para reconocimiento de voz y escritura a mano.

Pérdida mínima por error empírico (Ljolje y Rabiner 1990):

Al entrenar a nivel de secuencia, no le especifican dicen al sistema el sonido o la ubicación. Sino que le dan al sistema una oración de entrada y la transcripción en términos de palabras, y le piden al sistema que la resuelva haciendo deformaciones de tiempo. No usaban redes neuronales ya que tenían otras formas de convertir las señales del habla en categorías de sonido.

<!--
## Graph Transformer Net

Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works.

We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center>
-->
## Red del transformador gráfico

Aquí el problema es que tenemos una secuencia de dígitos en la entrada y no sabemos cómo hacer la segmentación. Lo que podemos hacer es construir un grafo en el que cada camino es una forma de romper la secuencia de caracteres, y vamos a encontrar el camino con menor energía, que básicamente es encontrar el camino más corto. Aquí hay un ejemplo concreto de cómo funciona.

Tenemos la imagen de entrada 34. Ejecute esto a través del segmentador y obtenga múltiples segmentaciones alternativas. Estas segmentaciones son formas de agrupar estas manchas de cosas. Cada ruta en el grafo de segmentación corresponde a una forma particular de agrupar las manchas de tinta.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figura 7.
</center>

<!--
We run each through the same charecter recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird form of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center>

Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center>
-->

Pasamos cada uno por el mismo ConvNet de reconocimiento de caracteres y obtenemos una lista de 10 puntuaciones (aqui hay dos, pero esencialmente deberían ser 10, que representan 10 categorías). Por ejemplo, 1 [0.1] significa que la energía es 0.1 para la categoría 1. Así que obtengo una gráfica aquí, y puedes pensar en ella como una forma extraña de tensor. Realmente es un tensor escaso. Es un tensor que dice que "para cada posible configuración de esta variable, dime el costo de la variable". Es más como una distribución sobre tensores o distribución logarítmica porque estamos hablando de energías.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figura 8.
</center>

Toma esta gráfica y calcula la energía de la respuesta correcta. Le estoy diciendo que la respuesta correcta es 34. Selecciona dentro de esos caminos y encuentra los que dicen 34. Hay dos de ellos, uno de energía 3.4 + 2.4 = 5.8, y el otro 0.1 + 0.6 = 0.7. Elije el camino con la energía más baja. Aquí obtenemos el camino con energía 0.7.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figura 9.
</center>

<!--
So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path.

Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, neural net is regular and the Path Selector and Viterbi Transformer are basically switches that pick a particular edge or not.

So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set  the gradeint for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and wil come back to this later. Then you can backpropagate gradient through the neural net. That will make the energy of the correct answer small.

What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of neural net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the suitation where things like PyTorch are really important.

This phase of backpropagation make the energy of correct answer small. And there's going to be a second phase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discriminative training for structure prediction that use perceptual loss.

The first stages of phase two are exactly the same with the first phase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether this path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phase one, since the energy get here is the smallest among all possible paths.
-->
Entonces, encontrar la ruta es como minimizar la variable latente donde la variable latente es la ruta que elijas. Conceptualmente, es un modelo energético con una variable latente como camino.

Ahora tenemos la energía del camino correcto, 0,7. Lo que tenemos que hacer ahora es propagar el gradiente a través de toda esta estructura, de modo que podamos cambiar el peso en la ConvNet de tal manera que la energía final disminuya. Parece abrumador, pero es completamente posible. Debido a que todo este sistema está construido con elementos que ya conocemos, la red neuronal es regular y el selector de ruta y el transformador de Viterbi son básicamente "switches" o "alternadores" que eligen un borde en particular o no.

Entonces, ¿cómo propagamos hacia atrás? Bueno, el punto 0.7 es la suma de 0.1 y 0.6. Entonces, tanto el punto 0.1 como el 0.6 tendrán gradiente +1, que se indican entre paréntesis. Luego, el transformador de Viterbi simplemente selecciona una ruta entre dos. Así que simplemente copia el gradiente para el borde correspondiente en el gráfico de entrada y establezca el grado para otras rutas que no estén seleccionadas como cero. Es exactamente lo que está sucediendo en Max-Pooling o Mean-Pooling. El selector de ruta es el mismo, es solo un sistema que selecciona la respuesta correcta. Tenga en cuenta que 3 [0.1] (0) en el gráfico debe ser 3 [0.1] (1) en esta etapa, y volveremos a esto más adelante. Luego, puede propagar el gradiente hacia atrás a través de la red neuronal. Eso hará que la energía de la respuesta correcta sea pequeña.

Lo importante aquí es que esta estructura es dinámica en la esencia de que si le doy una nueva entrada, el número de instancias de red neuronal cambiará con el número de segmentaciones, y los gráficos derivados también cambiarán. Necesitamos retropropagar a través de esta estructura dinámica. Esta es la situación donde cosas como PyTorch son realmente importantes.

Esta fase de retropropagación reduce la energía de la respuesta correcta. Y habrá una segunda fase en la que aumentaremos la energía de la respuesta incorrecta. En este caso, simplemente dejamos que el sistema elija la respuesta que desee. Esta será una forma simplificada de entrenamiento discriminativo para la predicción de estructuras que utiliza la pérdida de percepción.

Las primeras etapas de la fase dos son exactamente las mismas que las de la primera. El Transformador de Viterbi solo elige el mejor camino con la energía más baja, no nos importa si este camino es correcto o no aquí. La energía que obtienes aquí será menor o igual a la que obtienes de la fase uno, ya que la energía que obtienes aquí es la más pequeña entre todos los caminos posibles.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figura 10.
</center>

<!--
Putting phase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perceptron loss.
-->
Juntando las fases uno y dos. La función de pérdida debe ser energía1 - energía2. Antes, presentamos como propagar hacia atrás a través de la parte izquierda, y ahora realmente necesitamos propagar hacia atrás a través de toda la estructura. Cualquier camino en el lado izquierdo obtendrá +1, y cualquier camino en el lado derecho obtendrá -1. Entonces apareció 3 [0.1] en ambos caminos, por lo que debería obtener un gradiente 0. Si hacemos esto, el sistema eventualmente minimizará la diferencia entre la energía de la respuesta correcta y la energía de la mejor respuesta cualquiera que sea. La función de pérdida aquí es la pérdida de perceptrón.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figura 11.
</center>

<!--
## Comprehension Questions and Answers


#### Question1: Why is inference easy in the case of energy-based factor graphs?

Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead.


#### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm?

We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference.


#### Question3: Are the NN boxes refering to seperate ConvNets?

They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network.
-->

## Preguntas y respuestas de comprensión


#### Pregunta 1: ¿Por qué es fácil la inferencia en el caso de grafos de factores basados en energía?

La inferencia en el caso del modelo basado en energía con variable latente implica el uso de técnicas exhaustivas como el descenso de gradiente para minimizar la energía, sin embargo, ya que la energía, en este caso, es la suma de factores y se pueden utilizar técnicas como la programación dinámica.


#### Pregunta 2: ¿Qué pasa si las variables latentes en los gráficos de factores son variables continuas? ¿Podemos seguir usando el algoritmo de suma mínima?

No podemos porque ahora no podemos buscar todas las combinaciones posibles para todos los valores de los factores. Sin embargo, en este caso, las energías también nos dan una ventaja, porque podemos hacer optimizaciones independientes. Como la combinación de $Z_1$ y $Z_2$ solo afecta a $E_b$. Podemos hacer una optimización independiente y programación dinámica para hacer la inferencia.


#### Pregunta 3: ¿Los cuadros NN se refieren a ConvNets separados?

Son compartidos. Son varias copias de la misma ConvNet. Es solo una red de reconocimiento de personajes.
