---
lang: es
lang-ref: ch.13-2
title: Grafo de Redes Convolucionales II
lecturer: Xavier Bresson
authors: Neil Menghani, Tejaishwarya Gagadam, Joshua Meisel and Jatin Khilnani
date: 27 Apr 2020
translation-date: 19 Sep 2020
translator: eugeniaf
---

<!-- ## [Spectral Graph ConvNets (GCNs)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=2670s)

In the previous section we discussed Graph Spectral Theory, one of the two ways to define convolution for graphs, which we can now use to define Spectral GCNs.
 -->
## [ConvNets de Grafo Espectral (GCN)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=2670s)

En la sección anterior discutimos la teoría espectral de grafos, una de las dos formas de definir la convolución para grafos, que ahora podemos usar para definir GCN Espectrales.


<!-- ### Vanilla Spectral GCN

We define a graph spectral convolutional layer such that given layer $h^l$, the activation of the next layer is:
 -->
### GCN Espectral Convencional

Definimos una capa convolucional espectral de grafo tal que dada la capa $h^l$, la activación de la siguiente capa es:

$$
h^{l+1}=\eta(w^l*h^l),
$$

<!-- where $\eta$ represents a nonlinear activation and $w^l$ is a spatial filter. The RHS of the equation is equivalent to $\eta(\hat{w}^l(\Delta)h^l)$ where $\hat{w}^l$ represents a spectral filter and $\Delta$ is the Laplacian. We can further decompose the RHS of the equation into $\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$, where $\boldsymbol{\phi}$ is the Fourier matrix and $\Lambda$ is the eigenvalues. This yields the final activation equation as below.
 -->
donde $\eta$ representa una activación no lineal y $w^l$ es un filtro espacial. El lado derecho de la ecuación es equivalente a $\eta(\hat{w}^l(\Delta)h^l)$ donde $\hat{w}^l$ representa un filtro espectral y $\Delta$ es el laplaciano. Podemos descomponer aún más el lado derecho de la ecuación en $\eta(\boldsymbol{\phi}\hat{w}^l(\Lambda)\boldsymbol{\phi^\top}h^l)$, donde $\boldsymbol{\phi}$ es la matriz de Fourier y $\Lambda$ son los valores característicos. Esto produce la ecuación de activación final como se muestra a continuación.

$$
h^{l+1}=\eta\Big(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l\Big)
$$

<!-- The objective is to learn the spectral filter $\hat{w}^l(\lambda)$ using backpropagation instead of hand crafting.

This technique was the first spectral technique used for ConvNets, but it has a few limitations:
* No guarantee of spatial localization of filters
* Need to learn $O(n)$ parameters per layer ($\hat{w}(\lambda_1)$ to $\hat{w}(\lambda_n)$)
* Learning rate is $O(n^2$) because $\boldsymbol{\phi}$ is a dense matrix
 -->
El objetivo es aprender el filtro espectral $\hat{w}^l(\lambda)$ usando retropropagación en lugar de la elaboración manual.

Esta técnica fue la primera técnica espectral utilizada para ConvNets, pero tiene algunas limitaciones:
* No hay garantía de localización espacial de filtros
* Es preciso aprender $O(n)$ parámetros por capa ($\hat{w}(\lambda_1)$a$\hat{w}(\lambda_n)$)
* La tasa de aprendizaje es $O(n^2$) porque $\boldsymbol{\phi}$ es una matriz densa


<!-- ### SplineGCNs
SplineGCNs involve computing smooth spectral filters to get localized spatial filters. The connection between smoothness in frequency domain and localization in space is based on Parseval's Identity (also Heisenberg uncertainty principle): smaller derivative of spectral filter (smoother function) $\Leftrightarrow$ smaller variance of spatial filter (localization).
How do we get a smooth spectral filter? We decompose the spectral filter to be a linear combination of $K$ smooth kernels $\boldsymbol{B}$ (splines) so that $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. The activation equation the is as the following.
 -->
### SplineGCNs

Las SplineGCN implican el cálculo de filtros espectrales suaves para obtener filtros espaciales localizados. La conexión entre la suavidad en el dominio de frecuencia y la localización en el espacio se basa en la identidad de Parseval (también relación de indeterminación de Heisenberg): derivada más pequeña del filtro espectral (función más suave) $\Leftrightarrow$ varianza más pequeña del filtro espacial (localización).

¿Cómo obtenemos un filtro espectral suave? Descomponemos el filtro espectral para que sea una combinación lineal de $K$ kernels suaves $\boldsymbol{B}$ (splines) de modo que $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. La ecuación de activación es la siguiente.

$$
h^{l+1}=\eta\bigg(\boldsymbol{\phi} \Big(\text{diag}(\boldsymbol{B}w^l)\Big)\boldsymbol{\phi^\top} h^l\bigg)
$$

<!-- Now, we only have $O(1)$ parameters (constant $K$) per layer to be learned through backpropagation. However, the learning complexity is still $O(n^2)$.
 -->
Ahora, solo tenemos $O(1)$ parámetros ($K$ constantes) por capa para aprender a través de la retropropagación. Sin embargo, la complejidad del aprendizaje sigue siendo $O(n^2)$.


<!-- ### LapGCNs
How do we learn in linear time $O(n)$ (w.r.t. graph size $n$)? The $O(n^2)$  complexity is a direct result of using Laplacian eigenvectors. We need to avoid eigen-decomposition, which can be achieved by directly learning a function of the Laplacian. The spectral function will be a monomial of the Laplacian as shown here.
 -->
### LapGCNs

¿Cómo aprendemos en tiempo lineal $O(n)$ (en relación al tamaño del grafo $n$)? La complejidad $O(n^2)$ es un resultado directo del uso de autovectores laplacianos. Necesitamos evitar la descomposición propia, que se puede lograr aprendiendo directamente una función del Laplaciano. La función espectral será un monomio del Laplaciano como se muestra aquí.

$$
w*h=\hat{w}(\Delta)h=\bigg(\sum^{K-1}_{k=0}w_k\Delta^k\bigg)h
$$

<!-- One nice feature is that filters are localized in exactly k-hop supports.
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Demonstrates 1-hop and 2-hop neighbourhoods
</center>
 -->
Una característica interesante es que los filtros están localizados exactamente en soportes de k-saltos

<centro>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b> Figura 1: </b> muestra vecindarios de 1 y 2 saltos
</center>

<!-- We replace the expression $\Delta^kh$ with $X_k$, a recursive equation defined as, -->
Reemplazamos la expresión $\Delta^kh$ con $X_k$, una ecuación recursiva definida como,

$$
X_k=\Delta X_{k-1} \text{ and } X_0=h
$$

<!-- Complexity is now $O(E.K)=O(n)$ for sparse (real-world) graphs. We can reshape $X_k$ into $\bar{X}$ to form a linear operation. We now have the following activation equation.
 -->
La complejidad ahora es $O(E.K)=O(n)$ para grafos (del mundo real) dispersos. Podemos remodelar $X_k$ en $\bar{X}$ para formar una operación lineal. Ahora tenemos la siguiente ecuación de activación.

$$
h^{l+1}=\eta\bigg(\sum^{K-1}_{k=0}w_kX_k\bigg)=\eta\Big((w^l)^\top \bar{X}\Big)
$$

<!-- Note: Since no Laplacian eigen-decomposition is used, all operations are in the  spatial (not spectral) domain, so calling them Spectral GCNs may be misguided. Further, another drawback of LapGCNs is that convolutional layers involve sparse linear operations, which GPU's are not fully optimized for.
 -->
<!-- We now have resolved the 3 limitations of Vanilla GCNs through localized filters (in $K$-hop support), $O(1)$ parameters per layer and $O(n)$ learning complexity. However, the limitation of LapGCNs is that monomial basis ($\Delta^0,\Delta^1,\ldots$) used is unstable for optimization because it is not orthogonal (changing one coefficient changes the function approximation).
 -->
Nota: Dado que no se descompone espectralmente el Laplaciano, todas las operaciones están en el dominio espacial (no espectral), por lo que llamarlas GCN espectrales puede estar equivocado. Además, otro inconveniente de las LapGCN es que las capas convolucionales implican operaciones lineales dispersas, para las que los GPU no están completamente optimizados.

Ahora hemos resuelto las 3 limitaciones de las GCN convencionales a través de filtros localizados (en soportes de $K$-saltos), $O(1)$ parámetros por capa y $O(n)$ complejidad de aprendizaje. Sin embargo, la limitación de LapGCN es que la base monomial ($\Delta^0, \Delta^1, \ldots$) utilizada es inestable para la optimización porque no es ortogonal (cambiar un coeficiente cambia la aproximación de la función).


<!-- ### ChebNets
To resolve the issue of unstable basis we can use any orthonormal basis, but it must have a recursive equation to ensure linear complexity. For ChebNets we use Chebyshev polynomials, and as in a LapGCN we represent the expression $T_k(\Delta)h$ (Chebyshev function applied to $h$) by $X_k$, a recursive equation defined as,
 -->
### ChebNets

Para resolver el problema de la base inestable, podemos usar cualquier base ortonormal, pero debe tener una ecuación recursiva para asegurar la complejidad lineal. Para ChebNets usamos polinomios de Chebyshev, y como en una LapGCN, representamos la expresión $T_k(\Delta)h$ (función de Chebyshev aplicada a $h$) por $X_k$, una ecuación recursiva definida como,

$$
X_k=2\tilde{\Delta} X_{k-1} - X_{k-2}, X_0=h, X_1=\tilde{\Delta}h  \text{ and } \tilde{\Delta} = 2\lambda_n^{-1}\Delta - \boldsymbol{I}
$$

<!-- Now we have stability under coefficient perturbation.
ChebNets are GCNs that can be used for any arbitrary graph domain, but the limitation is that they are isotropic. Standard ConvNets produce *anisotropic* filters because Euclidean grids have direction, while Spectral GCNs compute *isotropic* filters since graphs have no notion of direction (up, down, left, right).

We can extend ChebNets to multiple graphs using a 2D spectral filter. This may be useful, for example, in recommender systems where we have movie graphs and user graphs. Multi-graph ChebNets have the activation equation as below.
 -->
Ahora tenemos estabilidad bajo la perturbación del coeficiente.

ChebNets son GCN que se pueden utilizar para cualquier dominio de grafo arbitrario, pero la limitación es que son isotrópicas. Las ConvNet estándar producen filtros *anisotrópicos* porque las cuadrículas euclidianas tienen dirección, mientras que los GCN espectrales calculan filtros *isotrópicos* ya que los grafos no tienen noción de dirección (arriba, abajo, izquierda, derecha).

Podemos extender ChebNets a múltiples grafos usando un filtro espectral 2D. Esto puede ser útil, por ejemplo, en sistemas de recomendación donde tenemos grafos de películas y grafos de usuario. Las ChebNets de grafos múltiples tienen la siguiente ecuación de activación.

$$
h^{l+1}=\eta(\hat{w}(\Delta_1,\Delta_2)*h^l)
$$


<!-- ### CayleyNets
ChebNets are unstable to produce filters (localize) with frequency bands of interest (graph communities). In CayleyNets, we instead use as our orthonormal basis Cayley rationals.
 -->
### CayleyNets

Las ChebNets son inestables para producir filtros (localizar) con bandas de frecuencia de interés (comunidades de grafos). Para CayleyNets, en cambio, utilizamos como base ortonormal los racionales de Cayley.

$$
\hat{w}(\Delta)=w_0+2\Re\left\{\sum^{K-1}_{k=0}w_k\frac{(z\Delta-i)^k}{(z\Delta+i)^k}\right\}
$$

<!-- CayleyNets have the same properties as ChebNets (are isotropic), but they are localized in frequency (with spectral zoom) and provide a richer class of filters (for the same order $K$).
 -->
Las CayleyNets tienen las mismas propiedades que las ChebNets (son isotrópicas), pero están localizadas en frecuencia (con zoom espectral) y proporcionan una clase más rica de filtros (para el mismo orden $K$).

<!-- ## [Spatial Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s)


### Template Matching

To understand Spatial Graph ConvNets, we go back to the Template Matching definition of ConvNets.

The main issue when we perform Template Matching for graphs is the lack of node ordering or positioning for the template. All we have are the indices of nodes, which isn't enough to match information between them. How do we design template matching to be invariant to node re-parametrisation? That is, if we have a graph and one of the nodes had an arbitrary index, say 6, this index could've been 122 as well. So it's essential to be able to perform template matching independent to the index of the node.
 -->
## [ConvNets de grafos espaciales] (https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s)


### Coincidencia de Modelos

Para entender las ConvNets de grafos espaciales, volvemos a la definición de ConvNets de Coincidencia de Modelos.

El problema principal cuando realizamos Coincidencia de Modelos para grafos es la falta de orden o posicionamiento de los nodos para el modelo. Todo lo que tenemos son los índices de los nodos, lo que no es suficiente para coincidir la información entre ellos. ¿Cómo diseñamos una coincidencia de modelos para que sea invariante a la re-parametrización del nodo? Es decir, si tenemos un grafo y uno de los nodos tiene un índice arbitrario, digamos 6, este índice también podría haber sido 122. Por lo tanto, es esencial poder realizar coincidencia de modelos independientemente del índice del nodo.

<!-- The simplest way to do this is by having only one template vector $w^l$, instead of having $w_{j1}$,$w_{j2}$, $w_{j3}$ or so on. So we match this vector $w^l$ with all other features on our graph. Most Graph Neural Networks today use this property.
 -->
La forma más sencilla de hacer esto es tener solo un vector modelo $w^l$, en lugar de tener $w_{j1}$, $w_{j2}$, $w_{j3}$ y así sucesivamente. Así que coincidimos este vector $w^l$ con todas las demás características de nuestro grafo. La mayoría de las redes neuronales de grafo actuales utilizan esta propiedad.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<b>Figura 2:</b> Coincidencia de Modelos usando un vector modelo
</center>

<!-- Mathematically, for one feature we have, -->
Matemáticamente, para una característica tenemos,

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \langle w^l,h_{ij}^l \rangle \bigg)$$

<!-- where, $w^l$ is the template vector at layer $l$ of dimensions $d \times 1$ and $h_{ij}^l$ is the vector at node j with $d \times 1$ which will result in a scalr quantity $h_{i}^{l+1}$ at node $i$.

for more($d$) features,
 -->
donde, $w^l$ es el vector modelo en la capa $l$ de dimensiones $d \times 1$ y $h_{ij}^l$ es el vector en el nodo j con $d \times 1$ que resultará en una cantidad scalar $h_{i}^{l+1}$ en el nodo $i$.

para obtener más ($d$) características,

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \boldsymbol{W}^l,h_{ij}^l\bigg)$$

<!-- where, $\boldsymbol{W}^l$ is of the dimensionality $d \times d$ and $h_{i}^{l+1}$ is $d \times 1$

for a vectoral representation,
 -->
donde, $\boldsymbol{W}^l$ tiene la dimensionalidad $d \times d$ y $h_ {i}^{l+1}$ es $d \times 1$

para una representación vectorial,

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

<!-- where, $\boldsymbol{A}$ is the adjacency matrix of dimensions $n \times n$, $h^l$ is the activation function at the layer $l$ with dimensions $n \times d$.

Based on this definition of Template Matching we can define two types of Spatial GSNs -- Isotropic GCNs and Anisotropic GCNs.
 -->

donde, $ \ boldsymbol {A} $ es la matriz de adyacencia de dimensiones $n \times n$, $h^l$ es la función de activación en la capa $l$ con dimensiones $n \times d$.

En base a esta definición de coincidencia de modelos, podemos definir dos tipos de GCN espaciales: GCN isotrópicas y GCN anisotrópicas.


<!-- ## Isotropic GCNs


### Vanilla Spatial GCNs

It has the same definition as before, but we add the Diagonal matrix in the equation, in such a way that we find the mean value of the neighbourhood.

Matrix representation being,
 -->
## GCN isotrópicas


### GCN espaciales convencionales

Tiene la misma definición que antes, pero agregamos la matriz Diagonal a la ecuación, de tal manera que encontremos el valor medio de la vecindad.

La representación matricial es,

$$h^{l+1} = \eta(\boldsymbol{D}^{-1}\boldsymbol{A}h^{l}\boldsymbol{W}^{l})$$

<!-- where, $\boldsymbol{A}$ has the dimensions $n \times n$, $h^{l}$ has dimensions $n \times d$ and $W^{l}$ has $d \times d$, which results in a $n \times d$ $h^{l+1}$ matrix.

And the vectorial representation being,
 -->
donde, $\boldsymbol{A}$ tiene las dimensiones $n \times n$, $h^{l}$ tiene dimensiones $n \times d$ y $W^{l}$ tiene dimensiones $d \times d$, lo que da como resultado una matriz $n \times d$ $h^{l+1}$.

Y la representación vectorial es,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{A}_{ij}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!-- where, $h_{i}^{l+1}$ has the dimensions of $d \times 1$

The vectorial representation is responsible for handling the absence of node ordering, which is invariant of node re-parametrisation. That is, adding on the previous example, if the node has an in 6 and is changed to 122, this won't change anything in the computation of the activation function of the next layer $h^{l+1}$.

We can also deal with neighbourhood of different sizes. That is we can have a neighbourhood of 4 nodes or 10 nodes, it wouldn't change anything. -->
donde, $h_{i}^{l+1}$ tiene las dimensiones de $d \times 1$

La representación vectorial es responsable de manejar la ausencia de ordenamiento de nodos, que es invariante a la re-parametrización de nodos. Es decir, agregando al ejemplo anterior, si el nodo tiene un índice 6 y se cambia a 122, esto no cambiará nada en el cálculo de la función de activación de la siguiente capa $ h ^ {l + 1} $.

También podemos ocuparnos de vecindarios de diferentes tamaños. Es decir, podemos tener un vecindario de 4 o 10 nodos y no cambiaría nada.

<!-- We are given the local reception field by design, that is, with Graph Neural Networks we only have to consider the neighbours.

We have weight sharing, that is, we the same $\boldsymbol{W}^{l}$ matrix for all features no matter the position of the graph, which is a Convolution property.

This formulation is also independent of the graph size, since all operations are done locally.

Since it is an isotropic model, the neighbours will have the same $\boldsymbol{W}^{l}$ matrix.
 -->
El campo de recepción local está dado por diseño. Es decir, con Redes de Grafo Neuronales solo tenemos que considerar los vecinos.

Tenemos peso compartido. Es decir, tenemos la misma matriz $\boldsymbol{W}^{l}$ para todas las características sin importar la posición del grafo, lo cual es una propiedad de la convolución.

Esta formulación también es independiente del tamaño del grafo, ya que todas las operaciones se realizan localmente.

Dado que es un modelo isotrópico, los vecinos tendrán la misma matriz $\boldsymbol{W}^{l}$.

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b>Figure 3:</b> Isotropic model
</center> -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b> Figura 3: </b> Modelo isotrópico
</center>

$$h_{i}^{l+1} = f_\text{GCN}(h_{i}^{l}, \{h_{j}^l: j \rightarrow i\})$$

<!-- So, the activation of the next layer $h_{i}^{l+1}$ is a function of the activation of the previous layer $h_{i}^{l}$ at node $i$ and the neighbourhood of $i$. When we change the function, we get an entire family of graphs.
 -->
Entonces, la activación de la siguiente capa $h_{i}^{l+1}$ es una función de la activación de la capa anterior $h_{i}^{l}$ en el nodo $i$ y la vecindad de $i$. Cuando cambiamos la función, obtenemos una familia completa de grafos.


<!-- ### ChebNets and Vanilla Spatial GCNs

The above defined Vanilla Spatial GCN is a simplification of ChebNets. We can truncate the expansion of ChebNet by using the first two Chebyshev functions to end up with,
 -->
### ChebNets y GCN espaciales convencionales

La GCN espacial convencional definida anteriormente es una simplificación de ChebNets. Podemos truncar la expansión de ChebNet usando las dos primeras funciones de Chebyshev para terminar con,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{\hat{d_{i}}}\sum_{j \in N_{i}}\hat{\boldsymbol{A}_{ij}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$


<!-- ### GraphSage

If the Adjacency matrix $\boldsymbol{A}_{ij} = 1$ for the edges in Vanilla Spatial GCNs, we get,
 -->
### GraphSage

Si la matriz de adyacencia $\boldsymbol{A}_{ij} = 1$ para los bordes en las GCN espaciales simples, obtenemos,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!-- For this equation, we give the central/core vertex $i$ and it's neighbourhood the same template weight $\boldsymbol{W}^{l}$. We can differentiate this by giving the central node $\boldsymbol{W}\_{1}^{l}$, and having a different template node $\boldsymbol{W}_{2}^{l}$ for the one-hot neighbourhood. This will improve the performance of the GNNs by a substantial amount. This model is still considered to be Isotropic in nature, since the neighbours have the same weight.
 -->
Para esta ecuación, le damos al vértice central/de núcleo $i$ y a su vecindario el mismo modelo de peso $\boldsymbol{W}^{l}$. Podemos diferenciar esto dando al nodo central $\boldsymbol{W}\_{1}^{l}$, y teniendo un modelo de nodo diferente $\boldsymbol{W}_{2}^{l}$ para el Vecindario one-hot. Esto mejorará considerablemente el rendimiento de las GNNes. Esta red todavía se considera de naturaleza isotrópica, ya que los vecinos tienen el mismo peso.

$$h_{i}^{l+1} = \eta\bigg(\boldsymbol{W}_{1}^{l} h_{i}^{l} + \frac{1}{d_{i}} \sum_{j \in N_{i}} \boldsymbol{W}_{2}^{l} h_{j}^{l}\bigg)$$

<!-- where, $\boldsymbol{W}\_{1}^{l}$ and $\boldsymbol{W}\_{2}^{l}$ are of dimension $d \times d$; $h_{i}^{l}$ and $h_{j}^{l}$ are of the dimension $d \times 1$.

In this equation, we can find the summation or maximum of $\boldsymbol{W}\_{2}^{l} h_{j}^{l}$ or the Long-Short Term Memory of $h_{j}^{l}$, instead of the mean.
 -->
donde, $\boldsymbol{W}\_{1}^{l}$ y $\boldsymbol{W}\_{2}^{l}$ son de dimensión $d \times d$; $h_{i}^{l}$ y $h_{j}^{l}$ son de la dimensión $d \times 1$.

En esta ecuación, podemos encontrar la suma o el máximo de $\boldsymbol{W}\_{2}^{l} h_{j}^{l}$ o la memoria a corto y largo plazo de $h_{j}^{l}$, en lugar de la media.

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>Figure 4:</b> GraphSage
</center>
 -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>Figura 4:</b> GraphSage
</center>


<!-- ### Graph Isomorphism Networks (GIN)

An architecture that can differentiate graphs that are not isomorphic. *Isomorphism* is the measure of equivalence between graphs. In the figure below, the two graphs are considered isomorphic to each other. Isomorphic graphs will be treated in a similar way and non-isomorphic graphs will be treated differently.

GIN is an isotropic GCN.
 -->
### Redes de isomorfismos de grafos (GIN)

Una arquitectura que puede diferenciar grafos que no son isomorfos. *Isomorfismo* es la medida de equivalencia entre grafos. En la siguiente figura, los dos grafos son considerados isomórficos entre sí. Los grafos isomórficos se tratarán de manera similar y los grafos no isomórficos se tratarán de manera diferente.

GIN es una GCN isotrópica.

$$h_{i}^{l+1} = \texttt{ReLU}(\boldsymbol{W}_{2}^{l}\space \texttt{ReLU}(\texttt{BN}(\boldsymbol{W}_{1}^{l} \hat(h_{j}^{l+1})))$$

<!-- where, $\texttt{BN}$ stands for Batch Normalization.
 -->
donde, $\texttt{BN}$ significa Normalización por Batch.

$$h_{i}^{l+1} = (1 + \epsilon)h_{i}^{l} + \sum_{j \in N_{i}} h_{j}^{l}$$

<!-- <center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b>Figure 5:</b> Examples of two isomorphic graphs
</center>
 -->
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b> Figura 5: </b> Ejemplos de dos grafos isomorfos
</center>


<!-- ## [Anisotropic GCNs](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s)

Standard CNNs have the ability to produce anisotropic filters — ones that favour certain directions. This is because the directional structure is based on up, down, left, and right. However, the GCNs described above have no notion of direction, and thus can only produce isotropic filters. Anisotropy can be introduced naturally, with edge features. For instance, molecules can have single, double, and triple bonds. Graphically, it is introduced weighting different neighbours differently.
 -->
## [GCN anisotrópicas] (https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s)

Las CNN estándar tienen la capacidad de producir filtros anisotrópicos, algunos que favorecen ciertas direcciones. Esto se debe a que la estructura direccional se basa en arriba, abajo, izquierda y derecha. Sin embargo, las GCN descritas anteriormente no tienen noción de dirección y, por lo tanto, solo pueden producir filtros isotrópicos. La anisotropía se puede introducir de forma natural, con características de borde. Por ejemplo, las moléculas pueden tener enlaces simples, dobles y triples. Gráficamente, se introduce ponderando diferentes vecinos de forma diferente.


<!-- ### MoNets

MoNets use the degree of the graph to learn the parameters of a Gaussian Mixture Model (GMM).

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>Figure 6:</b> MoNet
</center> -->
### MoNets

MoNets usan el grado del grafo para aprender los parámetros de un modelo de mezcla gaussiana (GMM).

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>Figura 6:</b> MoNet
</center>



<!-- ### Graph Attention Networks (GAT)

GAT uses the attention mechanism to introduce anisotropy in the neighbourhood aggregation function.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>Figure 7:</b> GAT
</center> -->
### Redes de grafos de atención (GAT)

GAT utiliza el mecanismo de atención para introducir anisotropía en la función de agregación de vecindad.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>Figura 7:</b> GAT
</center>


<!-- ### Gated Graph ConvNets

These use a simple edge gating mechanism, which can be seen as a softer attention process as the sparse attention mechanism used in GATs.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>Figure 8:</b> Gated Graph ConvNet
</center> -->
### ConvNets de grafos cerrados

Estas utilizan un mecanismo de cerrado de borde simple, que puede verse como un proceso de atención más suave como el mecanismo de atención escasa que se usa en las GAT.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>Figura 8:</b> ConvNet de gráfico cerrado
</center>


<!-- ### Graph Transformers

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>Figure 9:</b> Graph Transformer
</center>

This is the graph version of the standard transformer, commonly used in NLP. If the graph is fully connected (every two nodes share an edge), we recover the definition of a standard transformer.

Graphs obtain their structure from sparsity, so the fully connected graph has trivial structure and is essentially a set. Transformers then can be viewed as **Set** Neural Networks, and are in fact the best technique currently to analyse sets/bags of features. -->
### Transformadores de grafo

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>Figura 9:</b> Transformadores de grafo
</center>

Esta es la versión del transformador de grafo estándar, comúnmente utilizado en PNL. Si el grafo está completamente conectado (cada dos nodos comparten un borde), recuperamos la definición de un transformador estándar.

Los grafos obtienen su estructura de la dispersidad, por lo que el grafo completamente conectado tiene una estructura trivial y es esencialmente un conjunto. Los transformadores se pueden ver como Redes Neuronales **Conjunto** y, de hecho, son la mejor técnica actualmente para analizar conjuntos/bolsas de características.


<!-- ## Benchmarking GNNs

Benchmarks are an essential part of progress in any field. The recently released benchmark [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) has six medium-scale datasets that can be used for four fundamental graph problems - graph classification, graph regression, node classification and edge classification. Though these datasets are mediumly sized, they are enough to statiscally separate trends in various GNNs.

As an example of a **Graph Regression task**, we would want to predict the molecular solubility.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>Figure 10:</b> Graph Regression task - Quantum Chemistry
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figure 11:</b> Performance of various GCNs on the regression task
</center>
 -->
## Evaluación Comparativa de las GNN

Los puntos de referencia son una parte esencial del progreso en cualquier campo. El punto de referencia recientemente publicado [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) tiene seis conjuntos de datos de media escala que se pueden usar para cuatro problemas fundamentales de grafos: clasificación de grafos, regresión de grafos, clasificación de nodos y clasificación de bordes. Aunque estos conjuntos de datos son de tamaño mediano, son suficientes para separar estadísticamente las tendencias en varias GNNes.

Como ejemplo de una **Tarea de Regresión de Grafo**, querríamos predecir la solubilidad molecular.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>Figura 10:</b> Tarea de Regresión de Grafo - Química cuántica
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figura 11:</b> Performance de varias GCN en la tarea de regresión
</center>

<!-- We notice that in most cases anisotropic GCNs perform better compared to isotropic GCNs because we use directional properties.

For a **Graph Classification task**, a Computer Vision problem was chosen where we have super nodes of images and we want to classify the image.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>Figure 12:</b> Graph Classification task
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>Figure 13:</b> Performance of various GCNs on Graph Classification task
</center> -->
Observamos que en la mayoría de los casos las GCN anisotrópicos funcionan mejor en comparación con las GCN isotrópicas porque usamos propiedades direccionales.

Para una **tarea de Clasificación de Grafo**, se eligió un problema de visión por computadora donde tenemos supernodos de imágenes y queremos clasificar la imagen.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>Figura 12:</b> Tarea de Clasificación de Grafo
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>Figura 13:</b> Performance de varias GCN en la tarea de Clasificación de Grafo
</center>

<!-- For an **Edge Classification task**, we have considered the Combinatorial Optimization problem of the Travelling Salesman Problem (TSP) - where we want to know if a particular edge belongs to the optimal solution. If it belongs to the solution it falls in class 1, else class 0. Here we need explicit edge features, and the only model that does a good job of this is GatedGCN.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>Figure 14:</b> Edge Classification task.
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>Figure 15:</b> Performance of various GCNs on Edge Classification task
</center> -->
Para una **Tarea de Clasificación de Bordes**, hemos considerado el problema de Optimización Combinatorial del problema del viajante (TSP por sus siglas en inglés), donde queremos saber si un borde en particular pertenece a la solución óptima. Si pertenece a la solución, cae en la clase 1, de lo contrario en la clase 0. Aquí necesitamos características de borde explícitas, y el único modelo que hace un buen trabajo es GatedGCN.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>Figura 14:</b> Tarea de clasificación de Bordes.
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>Figura 15:</b> Performance de varias GCN en la Tarea de Clasificación de Bordes
</center>

<!-- We can use GCNs for self-supervised tasks as well, they are not limited to supervised learning models. According to Dr. Yann LeCun, almost all self-supervised learning tasks exploit some sort of graph structure. When we do a self-supervised learning task in text, where we take a sequence of words and we learn to predict missing words or new sentences. There is a graphs structure here, which is how many times a word appears some distance away from another word. Text would be a linear graph, and the neighbours chosen would be used to train a Transformer. In the case of contrastive training, where we have two samples that are similar, and two which are dissimilar - it is essentially a similarity graph, where two samples are linked when they are similar and if they are not linked they are considere dissimilar.
 -->
 También podemos usar GCN para tareas auto-supervisadas, no se limitan a modelos de aprendizaje supervisados. Según el Dr. Yann LeCun, casi todas las tareas de aprendizaje auto-supervisadas explotan algún tipo de estructura de grafo. Cuando realizamos una tarea de aprendizaje auto-supervisado en texto, donde tomamos una secuencia de palabras y aprendemos a predecir palabras faltantes o nuevas oraciones. Aquí hay una estructura de grafo, que es la cantidad de veces que una palabra aparece a cierta distancia de otra palabra. El texto sería un grafo lineal y los vecinos elegidos se usarían para entrenar un Transformador. En el caso del entrenamiento contrastivo, donde tenemos dos muestras que son similares y dos que son diferentes, es esencialmente un grafo de similitud, donde dos muestras están vinculadas cuando son similares y si no están vinculadas se consideran diferentes.

<!-- ## Conclusion

GCNs generalize CNNs to data on graphs. The convolution operator needed to be redesigned on graphs. Doing this for template matching gave rise to Spatial GCNs, and for spectral convolution lead to Spectral GCNs.

There is linear complexity for sparse graphs, and GPU implementation, although the latter is not yet optimized for sparse matrix multiplication. The applications are abound as shown below.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>Figure 16:</b> Applications
</center>
 -->
## Conclusión

Las GCN generalizan las CNN a datos en grafos. El operador de convolución necesitaba ser rediseñado para grafos. Hacer esto para la coincidencia de modelos dio lugar a GCN espaciales, y para la convolución espectral condujo a GCN espectrales.

Existe una complejidad lineal para los grafos dispersos y la implementación de GPU, aunque esta última aún no está optimizada para la multiplicación de matrices dispersas. Las aplicaciones abundan como se muestra a continuación.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>Figura 16:</b> Aplicaciones
</center>
