---
lang: es
lang-ref: ch.13-1
title: Grafo de Redes Convolucionales I
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
translation-date: 13 Sep 2020
translator: JonathanVSV
---

<!-- 
## [Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)

ConvNets are powerful architectures to solve high-dimensional learning problems.
-->

## [Redes Convolucionales Tradicionales](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=50s)

Las redes convolucionales son arquitecturas poderosas que permiten resolver problemas de aprendizaje de alta dimensionalidad.

<!-- 
### What is the Curse of Dimensionality?

Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10}^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example.

- dim(image) = **1024 x 1024** = ${10}^{6}$
- For **N = 10** samples/dim --> **${10}^{1,000,000}$ points**

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: ConvNets extract representation of high-dimensional image data.
</center>
-->

## ¿Cuál es la maldición de la dimensionalidad?

Supongamos que tenemos una imagen de 1024 x 1024 pixeles. Esta imagen se puede ver como un punto en un espacio de 1,000,000 de dimensiones. Utilizando 10 muestras por dimensión genera ${10}^{1,000,000}$ imágenes, lo cual es muy grande. Las redes convolucionales son extremadamente poderosas para extraer la mejor representación de datos de alta dimensionalidad, similar a la de este ejemplo.

- dim(image) = **1024 x 1024** = ${10}^{6}$
- Para **N = 10** muestras/dim --> **${10}^{1,000,000}$ puntos**

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: Las redes convolucionales extraen representaciones de datos de imágenes de alta dimensionalidad.
</center>

<!-- 
### Main assumptions about ConvNets:

 **1. Data (images, videos, speech) is compositional.**

It is formed of patterns that are:

* **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.
* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.
* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: Data is compositional.
</center>
-->

### Principales supuestos sobre Redes Convolucionales:

  **1. Datos (imágenes, videos, habla) son composicionales.**

Están formados por patrones que son:

* **Locales** Una neurona en una red neuronal sólo está conectada a capas adyacentes, pero no a todas las capas de la red. A esto le llamamos el supuesto del campo receptivo local.
* **Estacionarios** Tenemos algunos patrones que son similares y que son compartidos en el dominio de nuestra imagen. Por ejemplo, la sábana amarilla en el centro de la imagen de la figura 2.
* **Jerárquica** Los atributos (*features*) de nivel bajo se van a combinar para formar rasgos de nivel intermedio. Subsecuentemente, estos atributos de nivel intermedio se combinarán progresivamente para formar rasgos de mayor y mayor nivel. Por ejemplo, una representación visual.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: Los datos son composicionales.
</center>

<!--**2. ConvNets leverage the compositionality structure.**

They extract compositional features and feed them to classifier, recommender, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: ConvNets leverage the compositionality structure.
</center>
-->

**2. Las redes convolucionales aprovechan la estructura composicional**

Las redes extraen los atributos composicionales y se los proporciona al clasificador, recomendador, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: Las redes convolucionales aprovechan la estructura composicional.
</center> 

<!-- 
## Graph Domain

### Data Domain

* Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: Images have multiple dimensions.
</center>
-->

## Dominio de grafo

### Dominio de los datos

* Imágenes, volúmenes, videos se basan en dominios Euclideanos de 2D, 3D y 2D+1 (cuadrículas). Cada pixel es representado por un vector de valores de rojo, verde y azul.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: Las imágenes pueden tener múltiples dimensiones
</center>

<!--
* Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: Sequences have single dimension.
  </center>
-->

* Oraciones, palabras, y el habla se basan en dominios Euclideanos de 1D. Por ejemplo, cada caracter se puede representar por un número entero.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: Secuencias sólo tienen una dimensión.
  </center>

<!--
* These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: Speech data has 1D grid.
  </center>
-->

* Estos dominios tienen fuertes estructuras espaciales regulares, las cuales permiten que todas las operaciones de las redes convolucionales sean rápidas y bien definidas.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: Datos del habla tienen una cuadrícula de 1D.
  </center>

<!-- 
### Graph Domain

#### Motivational Examples of graph domains

Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: Social networks by graph representation.
</center>
-->

### Dominio de grafos

#### Ejemplos motivacionales de los dominios de grafos

Consideremos una red social. La res social es capturada de mejor manera por un representación gráfica ya que las conexiones pareadas entre dos usuarios no forman una cuadrícula. Los nodos de estos grafos representan usuarios, mientras que los bordes entre nodos representan conexiones entre dos nodos (usuarios). Cada usuario tiene una matriz de atributos tridimensionales que contiene tales mensajes, imágenes y videos.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: Redes sociales representadas como grafos
</center>

<!--
The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: Brain connectivity by graph representation.
</center>
-->

La conexión entre la estructura y función de un cerebro para predecir enfermedades genéticas neuronales ofrece un ejemplo motivacional a considerar. Como se puede ver abajo, el cerebro está compuesto de varias regiones de interés (ROI). Estas ROIs están localmente conectadas a ciertas regiones de interés circundantes. La matriz de adyacencia representa el grado de fuerza entre diferentes regiones de interés.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: Conectividad de un cerebro representada como grafo.
</center>

<!--
Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: Quantum chemistry by graph representation.
</center>
-->

La química quántica también ofrece una interesante representación del dominio gráfico. Cada átomo es representado por un nodo en un grafo, la cual está conectada a otros átomos mediante enlaces utilizando bordes. Cada una de estas moléculas / átomos tienen distintos atributos, tales como una carga asociada, tipo de enlace, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: Representación de química cuántica en un grafo.
</center>

<!-- 
### Graph Definition and Characteristics

* Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A**
-->

### Características y definición de grafos

* El grafo G es definido por: 
      * **Vértices V**
      * **Bordes E**
      * **Matriz de adyacencia A**

<!--
* Graph features:
    * **Node features: $h_{i}$, $h_{j}$** (atom type)
    * **Edge features: $e_{ij}$** (bond type)
    * **Graph features:** g (molecule energy)

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: Graph.
</center>
-->

* Atributos del grafo:
      * **Atributos del nodo: $h_{i}$, $h_{j}$** (tipo de átomo)
      * **Atributos del borde: $e_{ij}$** (tipo de enlace)
      * **Atributos del gráfo:** g (energía de molécula)

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: Grafo.
</center>

<!-- 
## [Convolution of Traditional ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)

### Convolution

We abstractly define convolution as:

$$h^{\ell+l} = w^\ell * h^\ell,$$
where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (*e.g.*, 3 for a colored image).\\
So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\
Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\
Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\
-->
## [Convolución de Redes Convolucionales Tradicionales](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=791s)

### Convolución

Definimos, de manera abstracta, una convolución como:

$$h^{\ell+l} = w^\ell * h^\ell,$$
donde $h^{\ell+1}$ es $n_1\times n_2\times d$-dimensional, $w^\ell$ es $3\times 3\times d$-dimensional, y $h^\ell$ es $n_1\times n_2\times d$-dimensional.
Por ejemplo, $n_1$ y $n_2$ podría ser el número de pixeles en los ejes $x$ y $y$ de una imagen, respectivamente, y $d$ es la dimensionalidad de cada pixel (*e.g.*, 3 para una imagen a color).\\
De esta manera,  $h^{\ell+1}$ es un atribute en el $(\ell+1)$-ésima capa oculta obtenida al realizar la convolución $w^\ell$ a un atributo en la $\ell$-ésima capa.\\
Usualmente, el kernel es pequeño y representa un campo receptivo local -- $3\times 3$ en este caso, o $5\times 5$, por ejemplo.\\
Nota: Las imágenes se rellenan (*padding*) para asegurarnos que las dimensiones de $h^{\ell+1}$ son iguales a las de $h^\ell$.\\

<!--
For example, in this image, the kernel may be used to recognize lines.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: Kernel can be used to recognize lines in images.
</center>
-->

Por ejemplo, en esta imagen el núcleo (*kernel*) puede ser utilizado para reconocer líneas

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: El kernel se puede utilizar para reconocer líneas en imágenes.
</center>

<!-- 
### How do we define convolution?

More exactly, convolution is defined as follows:

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$
-->

### ¿Cómo definimos una convolución?

De manera más exacta, una convolución se define como:

$$h_i^{\ell+1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

<!--
The above defines convolution as *template matching*.\\
We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching.

However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning.

In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$.

The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line.
-->

Lo anterior define una convolución como una correspondencia entre modelos (*template matching*).\\
Nosotros usualmente utilizamos $h_{i+j}$ en lugar de $h_{i-j}$, porque esta última, de hecho, es una correlación, que es más similar a una correspondencia entre modelos.

Sin embargo, realmente no importa si se utiliza la primera o segunda variable, ya que el kernel sólo está volteado, por lo tanto, no influye en el aprendizaje. 

En la tercer linea, sólo escribimos $h_{i+j}^\ell$ como $h_{ij}^\ell$.

El kernel es muy pequeño, así que en lugar de sumar sobre toda la imagen $\Omega$, como en la segunda línea, de hecho, sólo sumamos sobre el vecindario de una celda $i$, $\mathcal{N}_i$, como se muestra en la tercera línea

<!--
This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image.

Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids.

The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: Nodes are ordered in the same way.
</center>
-->

Esto hace que la complejidad de una convolución sea $O(n)$, donde $n$ es el número de pixeles en una imágen de entrada.

Una convolución es exactamente, para cada $n$ pixeles, sumar sobre los productos internos de vectores de dimensión $d$ sobre $3\times 3$ cuadrículas.

La complejidad es entonces, $n\cdot 3\cdot 3\cdot d$, lo cual es $O(n)$; mas aún, esto se puede realizar en paralelo utilizando GPUs en cada uno de los $n$ pixeles.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: Los nodos se ordenan de la misma manera.
</center>

<!--
If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.
Therefore, $j_3$ will always be in the top right corner of the pattern.

So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.
For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.
Mathematically speaking:
-->

Si el grafo sobre el que se está realizando la convolución es una cuadrícula, tal cual como en las convoluciones estándar en imágenes utilizadas en visión computacional, entonces los nodos se ordenan igual que en la imagen anterior.
Entonces, $j_3$ siempre va a estar en la esquina superior derecha del patrón.

Así que para todos los nodos $i$ en la imagen que se encuentra abajo, como $i$ y $i'$, el orden de los nodos en el kernel siempre es el mismo.
Por ejemplo, siempre que compares $j_3$ en la esquina superior derecha del patrón con la esquina superior de una parte de la imagen (lo que convolucionamos para cada pixel $i$), como se muestra abajo.
Poniéndolo en términos matemáticos:

<!--$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

and

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

are always for the top right corner between the template and the image patches.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: Image patches match the templates.
</center>
-->

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

y

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

siempre están en la esquina superior derecha entre el modelo y los parches de una imagen.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: Parches de una imagen que coinciden con los modelos.
</center>

<!-- 
### Can we extend template matching for graphs?

We have a couple of issues:
1. First, in a graph, there is no ordering of the nodes.

So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.
So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\
This is because there is no notion of the *top right corner* of the graph.\\
There is no notion of up, down, left right.\\
Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: No node ordering in a graph.
</center>
-->

### ¿Podemos extender la coincidencia de modelos para gráficas?

Tenemos un par de problemas:
1. Primero, en un grafo, no existe un orden de los nodos.

Así que en el modelo que se muestra abajo, el nodo $j_3$ no tiene una posición específica, pero sólo un índice (arbitrario).
De tal manera, cuando tratamos de coincidir los nodos $i$ y $i'$ en la grafo de abajo, no sabemos si $j_3$ coincide con los mismos nodos en las dos convoluciones.\\
Esto es porque no existe una noción de la *esquina superior derecha* del grafo.\\
No existe una noción de arriba, abajo, izquierda o derecha.\\
Por lo tanto, la coincidencia de modelos no tiene un significado y no podemos utilizar la definicion de coincidencia de modelos directamente, como arriba.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: No existe un orden de los nodos en un grafo.
</center>

<!--
2. The second issue is that neighborhood sizes may be different.

So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.
How can we compare these two?

<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Fig. 15</b>: Different neighborhood sizes in a graph.
</center>
-->

2. El segundo problema es que los tamaños de vecindario pueden ser distintos.

De tal manera, cuanto el modelo $w^\ell$ que se muestra abajo tiene 4 nodos, pero el nodo $i$ tiene 7 nodos en su vecindario. ¿Cómo podemos comparar estos dos?

<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Fig. 15</b>: Diferentes tamaños de vecidanrios en un grafo.
</center>

<!--
## Graph Convolution

We now use the **Convolution Theorem** to define convolution for graphs.

The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms:

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT.
-->

## Convolución de grafos

Ahora utilizamos el **Teorema de la Convolución** para definir una convolución para gráficas.

El **Teorema de la Convolución** establece que una transformada de Fourier de una convolución de dos funciones es el producto punto de sus transformadas de Fourier:

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

En general, la transformada de Fourier tiene complejidad $O(n^2)$, pero si el dominio es una cuadrícula, entonces la complejidad puede ser reducida a $O(n\log n)$ con una transformada rápida de Fourier (FFT).

<!--
### Can we extend the Convolution theorem to graphs?

This raises two questions:
1. How to define Fourier transforms for graphs?
2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)?

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

We are going to use these two design for graph neural networks:
Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets.
-->

## ¿Podemos ampliar el Teorema de la Convolución a las gráficas?

Esto genera dos preguntas:
1. ¿Cómo de define una transformada de Fourier para gráficas?
2. ¿Cómo se calculan las convoluciones espectrales rápidas en un tiempo $O(n)$ para kernels compactos (así como en la coincidencia de modelos)?

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

Vamos a utilizar estos dos diseños para redes neuronales gráficas:
La coincidencia de modelos será utilizada para redes convolucionales gráficas espaciales, mientras que el Teorema de la Convolución va a ser utilizado en redes convolucionales espectrales.


<!--
## [Spectral Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)

How to perform spectral convolution?

### Step 1 : Graph Laplacian

This is the core operator in spectral graph theory.

Define
-->


## [Grafo espectral de Redes convolucionales](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=1529s)

¿Cómo realizar una convolución espectral?

### Paso 1: Grafo Laplaciano

Esto es un operador central en la teoría de grafos espectral.

Define

<!--
$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$


Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.


The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$.

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and *vice versa*.
-->

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$

Cabe destacar que la matriz $A$ es una matriz de adyacencia, y que $\Delta$ es la Laplaciana, la cual equivale la identidad menos la matriz de adyacencia normalizada por la matriz $D$. $D$ es una matriz diagonal y cada elemento en la diagonal es el grado del nodo. A esto se le llama una normalización Laplaciana o simplemente Laplaciana en este contexto.

La Laplaciana se interpreta como una medida de la suavidad del grafo, en otras palabras, la diferencia entre el valor local $h_i$ y el valor promedio de su vecindario de $h_j$'s. $d_i$ en la fórmula presentada abajo es el grado del nodo $i$, y $\mathcal{N}_{i}$ representa a todos los vecinos del nodo $i$.

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

La formula anterior muestra cómo aplicar la Laplaciana a a una función $h$ en el nodo %i$, el cual es de valor $h_i$ menos el valor promedio sobre los nodos de su vecindario $h_j$'s. Básicamente, si la señal es muy suave, el valor Laplaciano es pequeño y *viceversa*.

<!--
### Step 2 : Fourier Functions

The following is the eigen-decomposition of graph Laplacian,

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$
-->

## Paso 2: Funciones de Fourier

Las siguientes fórmulas indican la descomposición en eigenvalores de un grafo Laplaciano

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$

<!--
The Laplacian is factorized into three matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis.

$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$
-->

La Laplaciana se factoriza en tres matrices, $\Phi ^ T$, $\Lambda$, $\Phi$.

$\Phi$ es definida abajo, ésta contiene vectores en columnas, o eigenvectores (*Lap eigenvectors*) de $\phi_1$ a $\phi_n$, cada uno de tamaño $n \times 1$, y a esos también se les llama funciones de Fourier. Y las funciones de Fourier forman una base ortonormal.

$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$

<!--
$\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$
-->

$\Lambda$ es la matriz diagonal con eigenvalores Laplacianos, y en la diagonal están $\lambda_1$ a $\lambda_n$. Y a partir de las normalizaciones, estos valores típicamente se encuentran en el intervalo de $0$ a $2$. A estos también se les conoce como el Espectro de un grafo. Ver la fórmula de abajo.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$

<!--
Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$.


$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

The image below is the visualization of eigenvectors of 1D Euclidean Laplacian.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: Grid/Euclidean Domain: eigenvectors of 1D Euclidean Laplacian.
</center>
-->

Abajo se puede ver un ejemplo de una revisión de la descomposición en eigenvalores. La matriz Laplaciana $\Lambda$ se multiplica por un eigenvector $\phi_k$, las dimensiones del resultado es $n \times 1$, y el resultado es $\lambda_k \phi_k$.


$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

La imagen de abajo muestra una visualización de los eigenvectores de una matriz Laplaciana Euclideana de 1D.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: Dominio de Cuadrícula / Euclideana: eigenvectores de una Laplaciana Euclideana de 1D.
</center>

<!--
For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: Graph Domain: Fourier functions of a graph.
</center>
-->

Para el dominio de grafos, de izquierda a derecha, corresponde a la primera, segunda, tercera, .. función de Fourier de un grafo. Por ejemplo, $\phi_1$ tiene ocilaciones con valores positivos (rojo) y negativos (azul), de igual manera, para $\phi2$, $\phi3$. Estas ocilaciones dependen de la topología del grafo, las cuales están relacionadas con la geometría de los grafos tales como comunidades, núcleos (*hubs*), etc, y es útil para agrupar grafos. Ver abajo. 

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: Dominio de grafo: Funciones de Fourier en un grafo.
</center>

<!--
### Step 3 : Fourier Transform

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$
-->

### Paso 3. Transformada de Fourier

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

<!--
**Fourier series: Decompose function $h$ with Fourier functions.**

Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$.

The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series.
-->

**Series de Fourier: funciones de descomposición $h$ con funciones de Fourier.**

Tomemos la función $h$, la cual, proyectada en cada función de Fourier $\phi_k$, resulta en el coeficiente de las series de Fourier de $k$, un escalar, y después se multiplica por la función $\phi_k$

La transformada de Fourier es básicamente proyectar a la función $h$ en las funciones de Fourier, y como resultado se obtienen los coeficientes de las series de Fourier.

<!--
**Fourier Transform/ coefficients of Fourier Series**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$
-->

**Transformada de Fourier/ coeficientes de las series de Fourier**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$

<!--
**Inverse Fourier Transform**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$.
-->

** Inversa de la Transformada de Fourier**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$


Las transformadas de Fourier son operaciones lineales, las cuales multiplican a una matriz $\Phi^{T}$ por un vector $h$

<!--
### Step 4 : Convolution Theorem


Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$
-->

### Paso 4: Teorema de la Convolución


La transformada de Fourier de una convolución de dos funciones es el producto punto de sus transformadas de Fourier.

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

<!--
The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.

The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph.
-->

El ejemplo de arriba es la convolución de $w$ y $h$, ambos con dimensiones de $n \times 1$, esto equivale a la inversa de la transformada de Fourier del producto punto entre la transformada de Fourier de $w$ y $h$. La fórmula de arriba muestra que también es igual a la muliplicación de las matrices $\hat{w}(\Delta)$ y $h$.

La convolución de dos funciones en el grafo $h$ y $w$ consta de tomar la función espectral de $w$ y aplicarla a la Laplaciana y multiplicarla por $h$, y esta es la definición de una convolución del espectro. Sin embargo, la complejidad del cómputo es $\mathrm{O}\left(n^{2}\right)$, mientras que $n$ es el número de nodos en el grafo.

<!--
## Limitation

The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.
-->

## Limitaciones

La convolución espectral contra el dominio de grafos no es invariante de cambio, lo cual significa que si se realiza un desplazamiento, las dimensiones de la función también se modificarán, mientras que en el dominio de cuadrícula / euclideano, no.

<!--## Recommended book

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
-->

## Libro recomendado

Teoría de grafos espectrales, Fan Chung, (análisis armónico, teoría de grafos, problemas de combinatoria, optimización)
Título original (en inglés): Spectral graph theory, Fan Chung.