---
lang: es
lang-ref: ch.12-2
title: Decodificando Modelos de Lenguaje
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
translation-date: 18 Sep 2020
translator: GastonMazzei (Gaston Mazzei)
---

<!-- ## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)-->

## [Búsqueda por haces] (https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

<!-- Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.-->

La búsqueda por haces es otra técnica para decodificar un modelo de lenguaje y producir texto. En cada paso, el algoritmo realiza un seguimiento de las $k$ traducciones parciales (hipótesis) más probables (mejores). La puntuación de cada hipótesis es igual a su probabilidad logarítmica.

<!-- The algorithm selects the best scoring hypothesis.-->

El algoritmo selecciona la hipótesis con mejor puntuación.

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width = "60%" /> <br>
<b> Fig. 1 </b>: decodificación de haces	
</center>

<!-- How deep does the beam tree branch out ?-->

¿Cómo se ramifica el árbol de haces?

<!-- The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished.-->

El árbol de haces continúa hasta que llega al token de final de oración. Al generar el final del token de oración, la hipótesis está terminada.

<!-- Why (in NMT) do very large beam sizes often results in empty translations?-->

¿Por qué (en NMT) los tamaños de haces muy grandes a menudo dan como resultado traducciones vacías?

<!-- At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.-->

En el momento del entrenamiento, el algoritmo a menudo no usa un haz, porque es muy caro. En su lugar, usa factorización auto-regresiva (dados los resultados correctos anteriores, predice las primeras palabras $ n + 1 $). El modelo no está expuesto a sus propios errores durante el entrenamiento, por lo que es posible que aparezcan "sinsentidos".

<!-- Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached.-->

Resumen: Continúe la búsqueda por haces hasta que todas las $k$ hipótesis produzcan un token final o hasta que se alcance el límite máximo de decodificación T.

<!-- ### Sampling-->

### Muestreo

<!-- We may not want the most likely sequence. Instead we can sample from the model distribution.-->

Puede que no queramos la secuencia más probable. En su lugar, podemos tomar muestras de la distribución del modelo.

<!-- However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops.-->

Sin embargo, el muestreo de la distribución del modelo plantea su propio problema. Una vez que se muestrea una "mala" elección, el modelo se encuentra en un estado que nunca enfrentó durante el entrenamiento, lo que aumenta la probabilidad de una "mala" evaluación continua. Por lo tanto, el algoritmo puede atascarse en ciclos de retroalimentación horribles.

<!-- ### Top-K Sampling-->

### Muestreo de Top-K

<!-- A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution.-->


Una técnica de muestreo pura en la que se trunca la distribución a los $ k $ mejores y luego se vuelve a normalizar y se muestrea la distribución.

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center>-->


<center>
<img src = "{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width = "60%" /> <br>
<b> Fig. 2 </b>: muestreo de los K mejores
</center>

<!-- #### Question: Why does Top-K sampling work so well?-->


#### Pregunta: ¿Por qué el muestreo Top-K funciona tan bien?

<!-- This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail.-->


Esta técnica funciona bien porque esencialmente intenta evitar salirse de la región (variedad matemática) del buen lenguaje cuando probamos algo malo usando solo la cabeza de la distribución y cortando la cola.


<!-- ## Evaluating Text Generation-->

## Evaluación de la generación de texto

<!-- Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues.-->

La evaluación del modelo de lenguaje requiere simplemente el logaritmo de la verosimilitud de los datos retenidos. Sin embargo, es difícil evaluar texto. Normalmente se utilizan métricas de superposición de palabras con una referencia (BLEU, ROUGE, etc.), pero tienen sus propios problemas.

<!-- ## Sequence-To-Sequence Models-->

## Modelos de secuencia a secuencia

<!-- ### Conditional Language Models-->

### Modelos de lenguaje condicional

<!-- Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.-->

Los modelos de lenguaje condicional no son útiles para generar muestras aleatorias de inglés, pero son útiles para generar un texto dado una entrada.

<!-- Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer-->

Ejemplos:

- Dada una oración en francés, generar la traducción al inglés
- Dado un documento, generar un resumen
- Dado un diálogo, generar la siguiente respuesta
- Dada una pregunta, generar la respuesta

<!-- ### Sequence-To-Sequence Models-->

### Modelos de secuencia a secuencia

<!-- Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word.-->

Generalmente, el texto de entrada se codifica. Esta incrustación resultante se conoce como un "vector de pensamiento", que luego se pasa al decodificador para generar tokens palabra por palabra.

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width = "60%" /> <br>
<b> Fig. 3 </b>: Vector de pensamiento
</center>

<!-- ### Sequence-To-Sequence Transformer-->

### Transformador de secuencia a secuencia

<!-- The sequence-to-sequence variation of transformers has 2 stacks:-->

La variación de secuencia a secuencia de transformadores tiene 2 pilas:

<!-- 1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input-->

1. Pila de codificadores: la atención personal no está enmascarada, por lo que cada token en la entrada puede mirar todos los demás tokens en la 
entrada

<!--2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs-->

2. Pila de decodificadores: además de prestar atención a sí mismo, también presta atención a las entradas completas

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width = "60%" /> <br>
<b> Fig. 4 </b>: Transformador de secuencia a secuencia
</center>

<!--Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models.-->

Cada token en la salida tiene conexión directa con cada token anterior en la salida, y también con cada palabra en la entrada. Las conexiones hacen que los modelos sean muy expresivos y poderosos. Estos transformadores han realizado mejoras en la puntuación de traducción con respecto a los modelos recurrentes y convolucionales anteriores.

<!--## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)-->

## [Traducción inversa] (https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

<!--When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model.-->

Al entrenar estos modelos, generalmente confiamos en grandes cantidades de texto etiquetado. Una buena fuente de datos son los procedimientos del Parlamento Europeo: el texto se traduce manualmente a diferentes idiomas que luego podemos utilizar como entradas y salidas del modelo.

<!--### Issues-->

### Cuestiones

<!--- Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?-->

- No todos los idiomas están representados en el parlamento europeo, lo que significa que no obtendremos pares de traducción para todos los idiomas en los que podríamos estar interesados. ¿Cómo encontramos texto para la capacitación en un idioma del que no necesariamente podemos obtener los datos?

<!--- Since models like transformers do much better with more data, how do we use monolingual text efficiently, *i.e.* no input / output pairs?-->

- Dado que los modelos como los transformadores funcionan mucho mejor con más datos, ¿cómo usamos el texto monolingüe de manera eficiente, *i.e.* sin pares de entrada/salida?

<!--Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German-->

Supongamos que queremos entrenar un modelo para que traduzca del alemán al inglés. La idea de la retro-traducción es entrenar primero un modelo inverso del inglés al alemán

<!--- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.-->

- Utilizando un bi-texto limitado podemos adquirir las mismas frases en 2 idiomas diferentes
- Una vez que tengamos un modelo de inglés a alemán, traducimos muchas palabras monolingües del inglés al alemán.

<!--Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:-->

Finalmente, entrenamos el modelo de alemán a inglés usando las palabras alemanas que han sido 'retro-traducidas' en el paso anterior. Notamos que:

<!--- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English-->

- No importa lo bueno que sea el modelo inverso: es posible que tengamos traducciones alemanas ruidosas pero terminemos traduciendo a un inglés limpio.
- Necesitamos aprender a entender el inglés mucho más allá de los datos de los pares inglés/alemán (ya traducidos) - use grandes cantidades de inglés monolingüe

<!--### Iterated Back-translation-->

### Retro-traducción iterada

<!--- We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data-->

- Podemos iterar el procedimiento de retro-traducción para generar aún más datos bi-texto y alcanzar un rendimiento mucho mejor; solo hay que seguir entrenando con datos monolingües.
- Ayuda mucho que hayan pocos datos paralelos

<!--## Massive multilingual MT-->

## MT multilingüe masiva

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width = "60%" /> <br>
<b> Fig. 5 </b>: MT multilingüe
</center>

<!--- Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information.-->

- En lugar de intentar aprender una traducción de un idioma a otro, intente construir una red neuronal para aprender traducciones en varios idiomas.
- El modelo está aprendiendo información general independiente del lenguaje.

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width = "60%" /> <br>
<b> Fig. 6 </b>: Resultados NN multilingües
</center>

<!--Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language).-->

Excelentes resultados, especialmente si queremos entrenar un modelo para traducir a un idioma que no tiene muchos datos disponibles para nosotros (idioma de bajos recursos).

<!--## Unsupervised Learning for NLP-->

## Aprendizaje no supervisado para NLP

<!--There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text?-->

Hay grandes cantidades de texto sin etiquetas y poca información supervisada. ¿Cuánto podemos aprender sobre el idioma con solo leer texto sin etiquetar?

<!--### `word2vec`-->

### `word2vec` (palabra a vector)

<!--Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.-->

Intuición - si las palabras aparecen juntas en el texto, es probable que estén relacionadas, por lo que esperamos que con solo mirar el texto en inglés sin etiquetar, podamos aprender lo que significan.

<!--- Goal is to learn vector space representations for words (learn embeddings)-->

- El objetivo es aprender representaciones de espacios vectoriales para palabras (aprender incrustaciones)

<!--Pretraining task - mask some word and use neighbouring words to fill in the blanks.-->

Tarea de preentrenamiento - enmascare alguna palabra y use palabras vecinas para completar los espacios en blanco.

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width = "60%" /> <br>
<b> Fig. 7 </b>: visual del enmascaramiento de word2vec
</center>

<!--For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal.

Take the words and apply a linear projection-->

Por ejemplo, aquí, la idea es que "cuernos" y "cabello plateado" tienen más probabilidades de aparecer en el contexto de "unicornio" que cualquier otro animal.

Toma las palabras y aplica una proyección lineal.

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width = "60%" /> <br>
<b> Fig. 8 </b>: incrustaciones de word2vec
</center>

<!--Want to know

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Word embeddings hold some structure-->

Quieren saber

$$
p (\texttt {unicornio} \mid \texttt {¿Estos ??? de pelo plateado eran previamente desconocidos})
$$

$$
p (x_n \mid x _ {- n}) = \text {softmax} (\text {E} f (x _ {- n})))
$$

Las incrustaciones de palabras tienen cierta estructura

<!--<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center>-->

<center>
<img src = "{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width = "60%" /> <br>
<b> Fig. 9 </b>: ejemplo de estructura de inserción
</center>

<!--- The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors-->

- La idea es que si tomamos la incrustación de "rey" después del entrenamiento y agregamos la incrustación de "mujer" obtendremos una incrustación muy cercana a la de "reina"
- Muestra algunas diferencias significativas entre vectores.

<!--#### Question: Are the word representation dependent or independent of context?-->

#### Pregunta: ¿La representación de la palabra es dependiente o independiente del contexto?

<!--Independent and have no idea how they relate to other words-->

Independiente y ajena a la representación de otras palabras

<!--#### Question: What would be an example of a situation that this model would struggle in?-->

#### Pregunta: ¿Cuál sería un ejemplo de una situación en la que este modelo tendría dificultades?

<!--Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word.-->

La interpretación de palabras depende en gran medida del contexto. Entonces, en el caso de palabras ambiguas, palabras que pueden tener múltiples significados, el modelo tendrá dificultades, ya que los vectores de incrustación no capturarán el contexto necesario para comprender correctamente la palabra.

<!--### GPT-->

### GPT

<!--To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.-->

Para agregar contexto, podemos entrenar un modelo de lenguaje condicional. Luego, dado este modelo de lenguaje, que predice una palabra en cada paso de tiempo, reemplace cada salida del modelo con alguna otra característica.

<!--- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review-->

- Entrenamiento previo: predice la siguiente palabra
- Ajuste fino: cambie a una tarea específica. Ejemplos:
  - Predecir si es sustantivo o adjetivo
  - Dado un texto que comprende una reseña de Amazon, predice la puntuación de sentimiento para la revisión

<!--This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks.-->

Este enfoque es bueno porque podemos reutilizar el modelo. Entrenamos previamente un modelo grande y podemos ajustarnos a otras tareas.

<!--### ELMo-->

### ELMo

<!--GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.-->

GPT solo considera el contexto hacia la izquierda, lo que significa que el modelo no puede depender de ninguna palabra futura; esto limita mucho lo que el modelo puede hacer.

<!--Here the approach is to train _two_ language models-->

<!--- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context.-->

Aquí el enfoque es entrenar _dos_ modelos de lenguaje

- Uno en el texto de izquierda a derecha
- Uno en el texto de derecha a izquierda
- Concatenar la salida de los dos modelos para obtener la representación de la palabra. Ahora puede condicionar tanto el contexto hacia la derecha como hacia la izquierda.

<!--This is still a "shallow" combination, and we want some more complex interaction between the left and right context.-->

Esta sigue siendo una combinación "superficial" y queremos una interacción más compleja entre el contexto izquierdo y derecho.

<!--### BERT-->

### BERT

<!--BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.-->

BERT es similar a word2vec en el sentido de que también tenemos una tarea de rellenar un espacio en blanco. Sin embargo, en word2vec teníamos proyecciones lineales, mientras que en BERT hay un gran transformador que es capaz de mirar más contexto. Para entrenar, enmascaramos el 15% de los tokens e intentamos predecir el espacio en blanco.

<!--Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now.-->

Puede escalar BERT (RoBERTa):

- Simplificando el objetivo de preentrenamiento de BERT
- Escalando el tamaño del lote
- Entrenando con grandes cantidades de GPUs
- Entrenando aún con más texto

Mejoras aún mayores sobre el rendimiento de BERT: el rendimiento de las tareas de respuesta a preguntas es ahora sobrehumano.

<!--## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)-->

## [Entrenamiento previo para NLP] (https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

<!--Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.-->

Echemos un vistazo rápido a los diferentes enfoques de formación previa autodirigidos que se han investigado para el NLP.

<!--- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order-->

- XLNet:

  En lugar de predecir todos los tokens enmascarados de forma condicionalmente independiente, XLNet predice los tokens enmascarados de forma autorregresiva en orden aleatorio

<!--- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens-->

- SpanBERT

   Enmascara tramos (secuencias de palabras consecutivas) en lugar de tokens

<!--- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.-->

- ELECTRA:

  En lugar de enmascarar palabras, sustituimos tokens por otros similares. Luego, resolvemos un problema de clasificación binaria tratando de predecir si los tokens han sido sustituidos o no.

<!--- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.-->

- ALBERT:

  Un Bert liviano: modificamos BERT y lo hacemos más liviano atando los pesos a través de las capas. Esto reduce los parámetros del modelo y los cálculos involucrados. Curiosamente, los autores de ALBERT no tuvieron que comprometer mucho la precisión.

<!--- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.-->

- XLM:

  BERT multilingüe: en lugar de introducir texto en inglés, lo hacemos en varios idiomas. Como era de esperar, aprendió mejor las conexiones entre idiomas.

<!--The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet-->

Las conclusiones clave de los diferentes modelos mencionados anteriormente son

- ¡Muchos objetivos diferentes de preentrenamiento funcionan bien!

- Es muy importante modelar interacciones profundas y bi-direccionales entre palabras

- Grandes beneficios de agrandar el preentrenamiento, aún sin límites claros

<!--Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training.-->

La mayoría de los modelos discutidos anteriormente están diseñados para resolver el problema de clasificación de texto. Sin embargo, para resolver el problema de la generación de texto, donde generamos resultados secuencialmente como el modelo `seq2seq`, necesitamos un enfoque ligeramente diferente al preentrenamiento.

<!--#### Pre-training for Conditional Generation: BART and T5-->

#### Entrenamiento previo para generación condicional: BART y T5

<!--BART: pre-training `seq2seq` models by de-noising text-->

BART: preentrenamiento de modelos `seq2seq` mediante la eliminación de ruido en el texto

<!--In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.-->

En BART, para el entrenamiento previo, tomamos una oración y la corrompemos enmascarando tokens al azar. En lugar de predecir los tokens de enmascaramiento (como en el objetivo de BERT), alimentamos la secuencia corrupta completa e intentamos predecir la secuencia correcta completa.

<!--This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.-->

Este enfoque de preentrenamiento `seq2seq` nos da flexibilidad para diseñar nuestros esquemas de corrupción. Podemos barajar las oraciones, eliminar frases, introducir nuevas frases, etc.


<!--BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa.-->

BART pudo igualar a RoBERTa en las tareas SQUAD y GLUE. Sin embargo, fue el nuevo estado del arte sobre resumenes, diálogos y conjuntos de datos de control de calidad abstractos. Estos resultados refuerzan nuestra motivación por BART, siendo mejores en tareas de generación de texto que BERT/RoBERTa.

<!--### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language?-->

### Algunas preguntas abiertas en NLP

- ¿Cómo deberíamos integrar el conocimiento mundial?
- ¿Cómo modelamos documentos largos? (Los modelos basados ​​en BERT suelen utilizar 512 tokens)
- ¿Cuál es la mejor manera de hacer el aprendizaje multitarea?
- ¿Podemos realizar ajustes finos con menos datos?
- ¿Estos modelos realmente comprenden el lenguaje?

<!--### Summary-->


### Resumen

<!--- Training models on lots of data beats explicitly modelling linguistic structure.-->


- La formación de modelos sobre una gran cantidad de datos supera al modelado explícito de la estructura lingüística.

<!--From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks-->

Desde una perspectiva de sesgo y varianza, los transformadores son modelos de bajo sesgo (muy expresivos). Alimentar estos modelos con mucho texto es mejor que modelar explícitamente la estructura lingüística (alto sesgo). Las arquitecturas deben comprimir secuencias a través de cuellos de botella

<!--- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy-->

- Los modelos pueden aprender mucho sobre el lenguaje al predecir palabras en texto sin etiquetar. Esto resulta ser un gran objetivo de aprendizaje sin supervisión. La puesta a punto para tareas específicas se vuelve entonces fácil

<!--- Bidirectional context is crucial-->

- El contexto bidireccional es crucial

<!--### Additional Insights from questions after class:-->

### Información adicional de las preguntas después de la clase:

<!--What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?-->

¿Cuáles son algunas formas de cuantificar la "comprensión del lenguaje"? ¿Cómo sabemos que estos modelos realmente entienden el lenguaje?

<!--"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.-->

"El trofeo no cabía en la maleta porque era demasiado grande": Resolver la referencia de 'era' en esta oración es complicado para las máquinas. Los humanos somos buenos en esta tarea. Hay un conjunto de datos que consta de ejemplos igual de difíciles y los humanos lograron 95% de rendimiento en ese conjunto de datos. Los programas de computadora solo podían alcanzar alrededor del 60% antes de la revolución provocada por los transformadores. Los modelos modernos de transformadores pueden lograr más del 90% en ese conjunto de datos. Esto sugiere que estos modelos no solo están memorizando/manipulando los datos sino también aprendiendo conceptos y objetos a través de los patrones estadísticos en los datos.

<!--Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way.-->

Además, BERT y RoBERTa logran un rendimiento sobrehumano en SQUAD y Glue. Los resúmenes textuales generados por BART parecen muy reales para los humanos (puntajes BLEU altos). Estos hechos son evidencia de que los modelos entienden el lenguaje de alguna manera.

<!--#### Grounded Language-->

#### Lenguaje Fundamentado

<!--Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization.-->

Curiosamente, el profesor (Mike Lewis, investigador científico, FAIR) está trabajando en un concepto llamado "Lenguaje Fundamentado". El objetivo de ese campo de investigación es construir agentes conversacionales que sean capaces de charlar o negociar. Charlar y negociar son tareas abstractas con objetivos poco claros en comparación con la clasificación o el resumen del texto.

<!--#### Can we evaluate whether the model already has world knowledge?-->

#### ¿Podemos evaluar si el modelo ya tiene conocimiento del mundo real?

<!--‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’.-->

El "conocimiento del mundo real" es un concepto abstracto. Podemos probar el conocimiento del mundo real que tienen los modelos (en un nivel muy básico) haciéndoles preguntas simples sobre los conceptos que nos interesan. Modelos como BERT, RoBERTa y T5 tienen miles de millones de parámetros. Teniendo en cuenta que estos modelos están entrenados en un enorme corpus de texto informativo como Wikipedia, habrían memorizado hechos usando sus parámetros y podrían responder nuestras preguntas. Además, también podemos pensar en realizar la misma prueba de conocimientos antes y después de ajustar un modelo en alguna tarea. Esto nos daría una idea de cuánta información ha "olvidado" el modelo.
