---
lang-ref: ch.11-3
lang: es
title: Predicción y Aprendizaje de Políticas Bajo Incertidumbre (PPUU)
lecturer: Alfredo Canziani
authors: Anuj Menta, Dipika Rajesh, Vikas Patidar, Mohith Damarapati
date: 14 April 2020
translation-date: 20 Sep 2020
translator: juliotorrest
---

<!--## [Introduction and problem setup](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)
-->

[Introducción y planteamiento del problema](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

<!--Let us say we want to learn how to drive in a model-free Reinforcement learning way. We train models in RL by letting the model make mistakes and learn from them. But this is not the best way since mistakes might take us to heaven/hell where there is no point in learning.

So, let us talk about a more 'human' way to learn how to drive a car. Consider an example of lane switching. Assuming the car is moving at 100 km/h, which roughly translates to 30 m/s, if we look 30 m in front of us, we are roughly looking 1 s into the future.
-->

Digamos que queremos aprender a conducir de una manera que no involucre modelos de aprendizaje por refuerzo. En AR, entrenamos modelos dejando que el modelo cometa errores y aprenda de ellos, pero esta no es la mejor manera ya que estos errores pueden llevarnos al cielo o al infierno donde no tiene sentido el aprendizaje.

Entonces, hablemos de una manera más 'humana' de aprender a conducir un automóvil. Consideremos un ejemplo de cambio de carril. Suponiendo que el automóvil se mueve a 100 km/h, lo que se traduce aproximadamente en 30 m/s, si miramos 30 m frente a nosotros, estamos mirando aproximadamente 1 s hacia el futuro.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 1:</b> Looking into future while driving-->
<b>Figura 1:</b> Mirando hacia el futuro mientras conducimos
</center>

<!--If we were turning, we need to make a decision based on the near future. To take a turn in a few meters, we take an action now, which in this context is turning the steering wheel. Making a decision not only depends on your driving but also the surrounding vehicles in the traffic. Since everyone around us is not so deterministic, it is very hard to take every possibility into account.

Let us now break down what is happening in this scenario. We have an agent(represented here by a brain) that takes the input $s_t$ (position, velocity and context images) and produces an action $a_t$(steering control, acceleration and braking).  The environment takes us to a new state and returns a cost $c_t$.
-->

Si estuviéramos girando, deberíamos tomar una decisión basada en el futuro cercano. Para poder girar en unos cuantos metros debemos realizar una acción ahora, que en este contexto es mover el volante. Tomar una decisión no solo depende de nuestra conducción, sino también de los vehículos circundantes en el tráfico. Dado que todos los que nos rodean no son tan deterministas, es muy difícil tener en cuenta todas las posibilidades.

Analicemos ahora lo que está sucediendo en este escenario. Tenemos un agente (representado aquí por un cerebro) que toma la entrada $s_t$​ (posición, velocidad e imágenes del contexto) y produce una acción $a_t$​(control de dirección, aceleración y frenado). El ambiente nos lleva a un nuevo estado y devuelve un costo $c_t$​.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 2:</b> Illustration of an agent in the real world-->
<b>Figura 2:</b> Ilustración de un agente en el mundo real 
</center>

<!--This is like a simple network where you take actions given a specific state and the world gives us the next state and the next consequence. This is model-free because with every action we are interacting with the real world. But can we train an agent without actually interacting with the real world?

Yes, we can! Let us find out in the "Learning world model" section.-->

Esto es como una red sencilla en la que se toman acciones dado un estado específico y el mundo nos da el siguiente estado y la siguiente consecuencia. Esto no involucra modelos porque con cada acción estamos interactuando con el mundo real. Pero, ¿podemos entrenar a un agente sin interactuar realmente con el mundo real?

¡Si podemos! Averigüémoslo en la sección “Aprendiendo un modelo del mundo”.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 3:</b> Illustration of an agent in the world model-->
<b>Figura 3:</b> Ilustración de un agente en el modelo del mundo
</center>

<!--## Data set
-->

## Conjunto de datos

<!--Before discussing how to learn the world model, let us explore the dataset we have. We have 7 cameras mounted on top of a 30 story building facing the interstate. We adjust the cameras to get the top-down view and then extract bounding boxes for each vehicle. At a time $t$, we can determine $p_t$ representing the position, $v_t$
representing the velocity and $i_t$ representing the current traffic state around the vehicle.

Since we know the kinematics of the driving, we can invert them to figure out what are the actions that the driver is taking. For example, if the car is moving in a rectilinear uniform motion, we know that the acceleration is zero(meaning there is no action)-->

Antes de discutir cómo aprender el modelo del mundo, exploremos el conjunto de datos del que disponemos. Tenemos 7 cámaras montadas en la parte superior de un edificio de 30 pisos frente a la interestatal. Ajustamos las cámaras para obtener la vista desde arriba y luego extraemos los cuadros delimitadores para cada vehículo. Para un tiempo $t$, podemos determinar $p_t$ que representa la posición, $v_t$ la velocidad e $i_t$​ el estado actual del tráfico alrededor del vehículo.

Como conocemos la cinemática de la conducción, podemos invertirla para averiguar cuáles son las acciones que está realizando el conductor. Por ejemplo, si el automóvil realiza un movimiento rectilíneo uniforme, sabemos que la aceleración es cero (lo que significa que no hay acción)

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 4:</b> Machine representation of a single frame-->
<b>Figura 4:</b> Representación del computador, para una sola toma 
</center>

<!--The illustration in blue is the feed and the illustration in green is what we can call the machine representation. To understand this better, we have isolated a few vehicles(marked in the illustration). The views we see below are the bounding boxes of the field-of-view of these vehicles.
-->

La ilustración en azul corresponde a los datos de entrada y la ilustración en verde es la representación del computador. Para entender esto mejor, hemos aislado algunos vehículos (marcados en la ilustración). Las representaciones que vemos abajo son los cuadros delimitadores correspondientes al campo de visión de estos vehículos.

<!--## Cost
-->

## Costo

<!--There are two different types of costs here: lane cost and proximity cost. Lane cost tells us how well we are within a lane and proximity cost tells us how close we are to the other cars.
-->

Hay dos tipos diferentes de costos aquí: costo del carril y costo de proximidad. El costo del carril nos dice qué tan bien ubicados estamos dentro de un carril y el costo de proximidad nos dice qué tan cerca estamos de los otros autos.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 5:</b> Lane cost-->
<b>Figura 5:</b> Costo del carril
</center>

<!--In the above figure, dotted lines represent actual lanes and red lines help us figure out the lane cost given the current position of our car.  Red lines move as our car moves. The height of the intersection of the red lines with the potential curve (in cyan) gives us the cost. If the car is in the centre of the lane, both the red lines overlap with the actual lanes resulting in zero cost. On the other hand, as the car moves away from the centre, the red lines also move to result in a non-zero cost.
-->

En la figura anterior, las líneas punteadas representan carriles reales y las líneas rojas nos ayudan a calcular el costo del carril dada la posición actual de nuestro automóvil. Las líneas rojas se mueven a medida que nuestro automóvil se mueve. La altura de la intersección de las líneas rojas con la curva potencial (en cian) nos da el costo. Si el automóvil está en el centro del carril, ambas líneas rojas se superponen con los carriles reales, lo que resulta en un costo cero. Por otro lado, a medida que el automóvil se aleja del centro, las líneas rojas también se mueven para dar como resultado un costo distinto de cero.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 6:</b> Proximity cost-->
<b>Figura 6:</b> Costo de proximidad
</center>

<!--Proximity cost has two components ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ is similar to the lane cost and $\mathcal{L}_x$ depends on the speed of our car. The Orange curve in Figure 6 tells us about the safety distance. As the speed of the car increases, the orange curve widens. So faster the car is travelling, the more you will need to look ahead and behind. The height of the intersection of a car with the orange curve determines $\mathcal{L}_x$.

The product of these two components gives us the proximity cost.
-->

El costo de proximidad tiene dos componentes ($\mathcal{L}_x$ y $\mathcal{L}_y$). $\mathcal{L}_y$ es similar al costo del carril y $\mathcal{L}_x$ ​depende de la velocidad de nuestro carro. La curva naranja de la Figura 6 nos informa sobre la distancia de seguridad. A medida que aumenta la velocidad del automóvil, la curva naranja se ensancha. Así que mientras más rápido viaja el automóvil, más se tendrá que mirar hacia adelante y hacia atrás. La altura de la intersección de un automóvil con la curva naranja determina $\mathcal{L}_x$.

El producto de estos dos componentes nos da el costo de proximidad.

<!--## Learning world model
-->

## Aprendiendo un modelo del mundo

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 7:</b> Illustration of the world model-->
<b>Figura 7:</b> Ilustración del modelo del mundo
</center>

<!--The world model is fed with an action $a_t$ (steering, brake, and acceleration) and $s_{1:t}$ (sequence of states where each state is represented by position, velocity and context images at that time) and it predicts the next state $\hat s_{t+1}$.  On the other hand, we have the real world which tells us what actually happened ($s_{t+1}$). We optimize MSE (Mean Squared Error) between prediction ($\hat s_{t+1}$) and target ($s_{t+1}$) to train our model.
-->

El modelo del mundo se alimenta de una acción $a_t$ (dirección, frenado y aceleración) y $s_{1:t}$​ (secuencia de estados donde cada estado está representado por posición, velocidad e imágenes de contexto en ese instante) y predice el siguiente estado $\hat s_{t+1}$​. Por otro lado, tenemos el mundo real que nos dice lo que realmente sucedió ($s_{t+1}$). Optimizamos MSE (error cuadrático medio) entre predicciones ($\hat s_{t+1}$) y objetivo ($s_{t+1}$) para entrenar nuestro modelo.


<!--## Deterministic predictor-decoder
-->

## Predictor-decodificador determinista

<!--One way to train our world model is by using a predictor-decoder model explained below.
-->

Una forma de entrenar nuestro modelo del mundo es utilizando el modelo de predictor-decodificador que se explica a continuación.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 8:</b> Deterministic predictor-decoder to learn the world model-->
<b>Figura 8:</b> Predictor-decodificador determinista para aprender el modelo del mundo
</center>

<!--As depicted in Figure 8, we have a sequence of states($s_{1:t}$) and action ($a_t$) which are provided to the predictor module. The predictor outputs a hidden representation of the future which is passed on to the decoder. The decoder is decoding the hidden representation of the future and outputs a prediction($\hat s_{t+1}$). We then train our model by minimising MSE between prediction $\hat s_{t+1}$ and target $s_{t+1}$.
-->

Como se muestra en la Figura 8, tenemos una secuencia de estados ($s_{1:t}$) y acción ($a_t$) que se proporcionan al módulo predictor. El predictor genera una representación oculta del futuro que se transmite al decodificador. El decodificador está decodificando la representación oculta del futuro y genera una predicción ($\hat s_{t+1}$). Luego entrenamos nuestro modelo minimizando MSE entre predicciones$\hat s_{t+1}$ y objetivo $s_{t+1}$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 9:</b> Actual future *vs.* Deterministic future-->
<b>Figura 9:</b> Futuro real * vs. * Futuro determinista
</center>

<!--Unfortunately, this does not work!

We see that the deterministic output becomes very hazy. This is because our model is averaging over all the future possibilities. This can be compared to the future's multimodality discussed a couple of classes earlier, where a pen placed at origin is dropped randomly. If we take the average across all locations, it gives us a belief that pen never moved which is incorrect.

We can address this problem by introducing latent variables in our model.
-->

¡Por desgracia, esto no funciona!

Vemos que la salida determinista se vuelve muy confusa. Esto se debe a que nuestro modelo promedia todas las posibilidades futuras. Esto se puede comparar con la multimodalidad del futuro discutida un par de clases antes, donde una pluma colocada en el origen se deja caer al azar. Si tomamos el promedio de todas las ubicaciones, nos da la creencia de que la pluma nunca se movió, lo cual es incorrecto.

Podemos abordar este problema introduciendo variables latentes en nuestro modelo.

<!--## [Variational predictive network](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)
-->

## [Red predictiva variacional](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

<!--To solve the problem stated in the previous section, we add a low dimensional latent variable $z_t$ to the original network which goes through an expansion module $f_{exp}$ to match the dimensionality.
-->

Para resolver el problema planteado en la sección anterior, agregamos una variable latente de baja dimensión $z_t$ a la red original que pasa por un módulo de expansión $f_{exp}$ para que coincida con la dimensionalidad.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 10:</b> Variational predictive network - train-->
<b>Figura 10:</b> Red predictiva variacional - entrenamiento 
</center>

<!--The $z_t$ is chosen such that the MSE is minimized for a specific prediction. By tuning the latent variable, you can still get MSE to zero by doing gradient descent into latent space. But this is very expensive. So, we can actually predict that latent variable using an encoder. Encoder takes the future state to give us a distribution with a mean and variance from which we can sample $z_t$.

During training, we can find out what is happening by looking into the future and getting information from it and use that information to predict the latent variable. However, we don't have access to the future during testing time. We fix this by enforcing the encoder to give us a posterior distribution as close as possible to the prior by optimizing KL divergence.
-->

Se escoge $z_t$ de manera que el MSE se minimice para una predicción específica. Al ajustar la variable latente, se puede llevar MSE a cero realizando un descenso de gradiente en el espacio latente, pero este es un proceso muy costoso. Entonces, podemos predecir esa variable latente usando un codificador. El codificador toma el estado futuro para darnos una distribución con una media y varianza de las que podemos muestrear $z_t$.

Durante el entrenamiento, podemos averiguar qué está sucediendo en el futuro, obteniendo información de él y usando esa información para predecir la variable latente. Sin embargo, ya en inferencia (prueba) no tenemos acceso al futuro. Arreglamos esto haciendo que el codificador nos dé una distribución posterior lo más cercana posible a la anterior optimizando la divergencia KL.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 11:</b> Variational predictive network - train (with prior distribution)-->
<b>Figura 11:</b> Red predictiva variacional - entrenamiento (con distribución previa) 
</center>

<!--Now, let us look at the inference - How do we drive?
-->

Ahora, veamos la inferencia: ¿cómo conducimos?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 12:</b> Variational predictive network - inference-->
<b>Figura 12:</b> Red predictiva variacional - inferencia
</center>

<!--We sample the low-dimensional latent variable $z_t$ from the prior by enforcing the encoder to shoot it towards this distribution. After getting the prediction $\hat s_{t+1}$, we put it back (in an auto-regressive step) and get the next prediction $\hat s_{t+2}$ and keep feeding the network this way.
-->

Muestreamos la variable latente de pocas dimensiones $z_t$ ​desde la anterior, obligando al codificador a enviarla hacia esta distribución. Después de obtener la predicción $\hat s_{t+1}$, la devolvemos (en un paso autoregresivo) y obtenemos la siguiente predicción $\hat s_{t+2}$ y seguimos alimentando la red de esta manera.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 13:</b> Actual future *vs.* Deterministic-->
<b>Figura 13:</b> Futuro real *vs.* Determinista 
</center>

<!--On the right hand side in the above figure, we can see four different draws from the normal distribution. We start with same initial state and provide different 200 values to the latent variable.
-->

En el lado derecho de la figura anterior, podemos ver cuatro representaciones diferentes de la distribución normal. Comenzamos con el mismo estado inicial y proporcionamos 200 valores diferentes a la variable latente.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 14:</b> Actual future *vs.* Deterministic - after movement-->
<b>Figura 14:</b> Futuro real * vs.* Determinista - después del movimiento 
</center>

<!--We can notice that providing different latent variables generates different sequences of states with different behaviours. Which means we have a network that generates the future. Quite fascinating!

What's next?

We can now use this huge amount of data to train our policy by optimizing the lane and proximity costs described above.

These multiple futures come from the sequence of latent variables that you feed to the network. If you perform gradient ascent - in the latent space, you try to increase the proximity cost so you get the sequence of latent variables such that the other cars are going to be driving into you.
-->

Podemos notar que proporcionar diferentes variables latentes genera diferentes secuencias de estados con diferentes comportamientos. Lo que significa que tenemos una red que genera el futuro. ¡Muy fascinante!

¿Que sigue?

Ahora podemos usar esta enorme cantidad de datos para entrenar nuestra política optimizando los costos de carril y proximidad descritos anteriormente.

Estos múltiples futuros provienen de la secuencia de variables latentes con que se alimenta a la red. Si se realiza un ascenso de gradiente, en el espacio latente, se intenta aumentar el costo de proximidad para obtener la secuencia de variables latentes de manera que los otros carros manejen hacia nosotros.

<!--## Action insensitivity & latent dropout
-->

## Insensibilidad a la acción y dropout latente

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 15:</b> Issues - Action Insensitivity-->
<b>Figura 15:</b> Problemas: insensibilidad a la acción 
</center>

<!--Given that you actually have access to the future, if you turn to the left even slightly, everything is going to be turning to the right and that will contribute in a huge way to the MSE. The MSE loss can be minimized if the latent variable can inform the bottom part of the network that everything is going to turn to the right - which is not what we want! We can tell when everything turns to the right since that is a deterministic task.

The big arrow in Figure 15 signifies a leak of information and therefore it was not any more sensitive to the current action being provided to the predictor.
-->

Dado que en realidad tienes acceso al futuro, si giras a la izquierda aunque sea levemente, todo va a girar a la derecha y eso contribuirá de manera enorme al MSE. La pérdida en el MSE se puede minimizar si la variable latente puede informar a la parte inferior de la red que todo va a girar a la derecha, ¡que no es lo que queremos! Sabemos cuándo todo gira a la derecha ya que es una tarea determinista.

La flecha grande en la Figura 15 significa una fuga de información y, por lo tanto, no es más sensible a la acción actual que se proporciona al predictor.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 16:</b> Issue - Action Insensitivity-->
<b>Figura 16:</b> Problema: insensibilidad a la acción 
</center>

<!--In figure 16, in the rightmost diagram we have the real sequence of latent variables (the latent variables that allow us to get the most precise future) and we have the real sequence of actions taken by the expert. The two figures to the left of this one have randomly sampled latent variables but the real sequence of actions so we expect to see the steering. The last one on the left-hand side has the real sequence of latent variable but arbitrary actions and we can clearly see that the turning came mostly from the latent rather than the action, which encodes the rotation and the action (which are sampled from other episodes).

How to fix this problem?
-->

En la figura 16, en el diagrama de la derecha tenemos la secuencia real de variables latentes (las variables latentes que nos permiten obtener el futuro más preciso) y tenemos la secuencia real de acciones realizadas por el experto. Las dos figuras a la izquierda de ésta han muestreado aleatoriamente las variables latentes, excepto la secuencia real de acciones, por lo que esperamos ver un cambio en la dirección de manejo. El último en el lado izquierdo tiene la secuencia real de acciones de las variables latentes exceptuando las arbitrarias, y podemos ver claramente que el giro provino principalmente de lo latente más que de la acción, lo que codifica la rotación y la acción (que son muestreadas de otras episodios).

¿Cómo arreglar este problema?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 17:</b> Fix - Latent Dropout-->
<b>Figura 17:</b> Solución - Dropout Latente
</center>

<!--The problem is not a memory leak but an information leak. We fix this problem by simply dropping out this latent and sampling it from the prior distribution at random. We don't always rely on the output of the encoder ($f_{enc}$) but pick from the prior. In this way, you cannot encode the rotation in the latent variable any more. In this way, information gets encoded in the action rather than the latent variable.
-->

El problema no es una pérdida de memoria, sino una pérdida de información. Solucionamos este problema simplemente eliminando este elemento latente y muestreándolo de la distribución anterior, al azar. No siempre confiamos en la salida del codificador ($f_{enc}$) sino que lo escogemos del anterior. De esta forma, ya no se puede codificar la rotación en la variable latente. De esta manera, la información se codifica en la acción en lugar de en la variable latente.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 18:</b> Performance with latent dropout-->
<b>Figure 18:</b> Rendimiento con dropout latente 
</center>

<!--In the last two images on the right-hand side, we see two different sets of latent variables having a real sequence of actions and these networks have been trained with the latent dropout trick. We can now see that the rotation is now encoded by the action and no longer by the latent variables.
-->

En las dos últimas imágenes del lado derecho, vemos dos conjuntos diferentes de variables latentes que tienen una secuencia real de acciones, en donde estas redes han sido entrenadas con el truco del dropout latente. Ahora podemos ver que la rotación ahora está codificada por la acción y ya no por las variables latentes.

<!--## [Training the agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)
-->

## [Entrenando al agente](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

<!--In the previous sections, we saw how we can obtain a world model by simulating real world experiences.  In this section, we will use this world model to train our agent.  Our goal is to learn the policy to take an action given the history of previous states.  Given a state $s_t$ (velocity, position & context images), the agent takes an action $a_t$ (acceleration, brake & steering), the world model outputs a next state and cost associated with that $(s_t, a_t)$ pair which is a combination of proximity cost and lane cost.

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

As discussed in the previous section, to avoid hazy predictions, we need to sample latent variable $z_t$ from the encoder module of the future state $s_{t+1}$ or from prior distribution $P(z)$.  The world model gets previous states $s_{1:t}$, action taken by our agent and latent variable $z_t$ to predict the next state $\hat s_{t+1}$ and the cost.  This constitutes one module that is replicated multiple times (Figure 19) to give us final prediction and loss to optimize.
-->

En las secciones anteriores, vimos cómo podemos obtener un modelo del mundo, simulando experiencias del mundo real. En esta sección, usaremos este modelo del mundo para entrenar a nuestro agente. Nuestro objetivo es conocer la política para tomar una acción dada la historia de los estados anteriores. Dado un estado $s_t$ (velocidad, posición e imágenes de contexto), el agente realiza una acción $a_t$ (aceleración, freno y dirección), el modelo del mundo genera el siguiente estado y el costo asociado con ese par $(s_t, a_t)$ que es una combinación de costo de proximidad y costo de carril.

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

Como se discutió en la sección anterior, para evitar predicciones confusas, necesitamos muestrear la variable latente $z_t$ del módulo codificador del estado futuro $s_{t+1}$ o de distribución previa $P(z)$. El modelo del mundo obtiene los estados anteriores $s_{1:t}$​, la acción realizada por nuestro agente y la variable latente $z_t$, para predecir el próximo estado $\hat s_{t+1}$ y el costo. Esto constituye un módulo que se replica varias veces (Figura 19) para darnos la predicción final y la pérdida a optimizar.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 19:</b> Task specific model architecture-->
<b>Figura 19:</b> Arquitectura del modelo de tarea específica
</center>

<!--So, we have our model ready.  Let’s see how it looks !!
-->

Entonces, tenemos nuestro modelo listo. ¡Veamos cómo queda !

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 20:</b> Learned policy: Agent either collides or moves away from the road-->
<b>Figura 20:</b> Política aprendida: el agente choca o se aleja de la carretera 
</center>

<!--Unfortunately, this does not work.  Policy trained this way is not useful as it learns to predict all black since it results in zero cost.

How can we address this issue? Can we try imitating other vehicles to improve our predictions?
-->

Por desgracia, esto no funciona. La política entrenada de esta manera no es útil ya que aprende a predecir todo negro, ya que resulta en un costo cero.

¿Cómo podemos abordar este problema? ¿Podemos intentar imitar a otros vehículos para mejorar nuestras predicciones?

<!--## Imitating the expert
-->

## Imitando al experto

<!--How do we imitate the experts here? We want the prediction of our model after taking a particular action from a state to be as close as possible to the actual future. This acts as an expert regulariser for our training. Our cost function now includes both the task specific cost(proximity cost and lane cost) and this expert regulariser term. Now as we are also calculating the loss with respect to the actual future, we have to remove the latent variable from the model because the latent variable gives us a specific prediction, but this setting works better if we just work with the average prediction.

$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$
-->

¿Cómo imitamos a los expertos aquí? Queremos que la predicción de nuestro modelo después de realizar una acción particular desde un estado sea lo más cercana posible al futuro real. Esto actúa como un regularizador experto en nuestro proceso de entrenamiento. Nuestra función de costo ahora incluye tanto el costo específico de la tarea (costo de proximidad y costo de carril) como este término de regularizador experto. Ahora que también estamos calculando la pérdida con respecto al futuro real, tenemos que eliminar la variable latente del modelo porque la variable latente nos da una predicción específica, pero esta configuración funciona mejor si solo trabajamos con la predicción promedio.

$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 21:</b>  Expert regularization based model architecture-->
<b>Figura 21:</b>  Arquitectura del modelo basado en regularización experta 
</center>

<!--So how does this model perform?
-->

Entonces, ¿qué tan bien funciona este modelo?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 22:</b> Learned policy by imitating the experts-->
<b>Figura 22:</b> Política aprendida imitando a los expertos 
</center>

<!--As we can see in the above figure, the model actually does incredibly well and learns to make very good predictions. This was model based imitation learning, we tried to model our agent to try to imitate others.

But can we do better?
Did we just train the Variational Autoencoder to remove it in the end?

It turns out we can still improve if we look to minimize the uncertainty of the forward model predictions.
-->

Como podemos ver en la figura anterior, el modelo realmente lo hace increíblemente bien y aprende a hacer muy buenas predicciones. Este fue un aprendizaje de imitación basado en modelos, intentamos modelar a nuestro agente para tratar de imitar a otros.

Pero, ¿podemos hacerlo mejor? ¿Acabamos de entrenar el Autoencoder Variacional para eliminarlo al final?

Resulta que aún podemos mejorar si buscamos minimizar la incertidumbre de las predicciones del modelo a futuro.

<!--## Minimizing the Forward Model Uncertainty
-->

## Minimizando la incertidumbre del modelo hacia adelante

<!--What do we mean by minimizing forward model uncertainty and how would we do it? Before we answer that, let’s recap something we saw in the third week’s practicum.

If we train multiple models on the same data, all those models agree on the points in the training region (shown in red) resulting in zero variance in the training region. But as we move further away from the training region, the trajectories of loss functions of these models start diverging and variance increases. This is depicted in the figure 23.  But as the variance is differentiable, we can run gradient descent over the variance in order to minimize it.
-->

¿Qué queremos decir con minimizar la incertidumbre del modelo hacia adelante y cómo lo haríamos? Antes de responder a eso, recapitulemos algo que vimos en la práctica de la tercera semana.

Si entrenamos varios modelos con los mismos datos, todos esos modelos coinciden en los puntos de la región de entrenamiento (mostrados en rojo), lo que da como resultado una varianza cero en la región de entrenamiento. Pero a medida que nos alejamos de la región de entrenamiento, las trayectorias de las funciones de pérdida de estos modelos comienzan a divergir y la varianza aumenta. Esto se muestra en la figura 23. Pero como la varianza es diferenciable, podemos ejecutar un descenso de gradiente sobre la varianza para minimizarla.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 23:</b> Cost visualization across the entire input space-->
<b>Figura 23:</b> Visualización de costos en todo el espacio de entrada 
</center>

<!--Coming back to our discussion, we observe that learning a policy using only observational data is challenging because the distribution of states it produces at execution time may differ from what was  observed during the training phase. The world model may make arbitrary predictions outside the domain it was trained on, which may wrongly result in low cost. The policy network may then exploit these errors in the dynamics model and produce actions which lead to wrongly optimistic states.

To address this, we propose an additional cost which measures the uncertainty of the dynamics model about its own predictions. This can be calculated by passing the same input and action through several different dropout masks, and computing the variance across the different outputs.  This encourages the policy network to only produce actions for which the forward model is confident.

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$
-->

Volviendo a nuestra discusión, observamos que aprender una política utilizando solo datos de observación es un desafío porque la distribución de estados que se produce durante la ejecución puede ser diferente de lo observado durante la fase de entrenamiento. El modelo del mundo puede hacer predicciones arbitrarias fuera del dominio en el que fue entrenado, lo que puede resultar erróneamente en un bajo costo. Entonces, la red de políticas puede aprovechar estos errores en el modelo de dinámica y producir acciones que conduzcan a estados erróneamente optimistas.

Para abordar esto, proponemos un costo adicional que mide la incertidumbre del modelo de dinámica sobre sus propias predicciones. Esto se puede calcular pasando la misma entrada y acción a través de varias máscaras de dropout diferentes y calculando la varianza entre las diferentes salidas. Esto alienta a la red de políticas a producir solo acciones para las que el modelo hacia adelante tiene confianza.

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 24:</b> Uncertainty regulariser based model architecture-->
<b>Figura 24:</b> Arquitectura del modelo basado en regularizador de incertidumbre 
</center>

<!--So, does uncertainty regulariser help us in learning better policy?

Yes, it does. The policy learned this way is better than the previous models.
-->

Entonces, ¿el regularizador de incertidumbre nos ayuda a aprender mejores políticas?

Sí lo hace. La política aprendida de esta manera es mejor que los modelos anteriores.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 25:</b> Learned policy based on uncertainty regulariser-->
<b>Figura 25:</b> Política aprendida basada en regularizador de incertidumbre 
</center>

<!--## Evaluation
-->

## Evaluación

<!--Figure 26 shows how well our agent learned to drive in dense traffic.  Yellow car is the original driver, blue car is our learned agent and all green cars are blind to us (cannot be controlled).
-->

La Figura 26 muestra qué tan bien aprendió nuestro agente a conducir en un tráfico denso. El carro amarillo es el conductor original, el azul es nuestro agente y todos los carros verdes son ciegos para nosotros (no se pueden controlar).

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<!--<b>Figure 26:</b> Performance of model with uncertainty regulariser-->
<b>Figura 26:</b> Rendimiento del modelo con regularizador de incertidumbre 
</center>
