---
lang-ref: ch.11-2
lecturer: Yann LeCun
title: Funciones de Pérdida (cont.)  y Funciones de Pérdida para Modelos Basados en Energía
authors: Charles Brillo-Sonnino, Shizhan Gong, Natalie Frank, Yunan Hu
date: 13 Apr 2020
lang: es
translator: Alberto Mario Ceballos-Arroyo
translation-date: 15 Sep 2020
---

<!--
### [Binary Cross Entropy (BCE) Loss - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)
-->


### [Pérdida de Entropía Cruzada Binaria (BCE) - `nn.BCELoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=3207s)

<!--$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$
-->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log x_n+(1-y_n)\log(1-x_n)]
$$

<!--This loss is a special case of cross entropy for when you have only two classes so it can be reduced to a simpler function. This is used for measuring the error of a reconstruction in, for example, an auto-encoder. This formula assume $x$ and $y$ are probabilities, so they are strictly between 0 and 1.
-->

Esta pérdida es un caso especial de la entropía cruzada para cuando solo tienes dos clases así que se puede reducir a una función más simple. Se puede usar para medir el error de reconstrucción; por ejemplo, en un auto-encoder. Esta fórmula asume que $x$ e $y$ son probabilidades, así que están estrictamente en el rango de entre 0 y 1.

<!--
### Kullback-Leibler Divergence Loss - `nn.KLDivLoss()`
-->


### Pérdida de Divergencia Kullback-Leibler - `nn.KLDivLoss()`

<!--$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$
-->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = y_n(\log y_n-x_n)
$$

<!--This is simple loss function for when your target is a one-hot distribution (*i.e.* $y$ is a category). Again it assumes $x$ and $y$ are probabilities. It has the disadvantage that it is not merged with a softmax or log-softmax so it may have numerical stability issues.
-->

Esta es una función de pérdida simple para cuando tu objetivo es una distribución one-hot (es decir, $y$ es una categoría). De nuevo, se asume que $x$ e $y$ son probabilidades. Tiene la desventaja de que no está combinada con una softmax o una log-softmax, por lo que puede tener problemas de estabilidad numérica.

<!--
### BCE Loss with Logits - `nn.BCEWithLogitsLoss()`
-->


### Pérdida BCE con Logits - `nn.BCEWithLogitsLoss()`

<!--$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$
-->

$$
\ell(x,y) = L = \{l_1,...,l_N\}^T, \qquad l_n = -w_n[y_n\log \sigma(x_n)+(1-y_n)\log(1-\sigma(x_n))]
$$

<!--This version of binary cross entropy loss takes scores that haven't gone though softmax so it does not assume x is between 0 and 1. It is then passed though a sigmoid to ensure it is in that range. The loss function is more likely to be numerically stable when combined like this.
-->

Esta versión de la entropía cruzada binaria recibe puntajes que no han pasado por la función softmax, así que no asume que x esté entre 0 y 1. Después el resultado pasa por una sigmoide para asegurar que esté en ese rango. La función de pérdida tiende a ser más numéricamente estable cuando se combina de esta manera.

<!--
### Margin Ranking Loss - `nn.MarginRankingLoss()`
-->


### Pérdida de Ránking de Margen - `nn.MarginRankingLoss()`

<!--$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margin})
$$
-->

$$
L(x,y) = \max(0, -y*(x_1-x_2)+\text{margen})
$$

<!--Margin losses are an important category of losses. If you have two inputs, this loss function says you want one input to be larger than the other one by at least a margin. In this case $y$ is a binary variable $\in \{ -1, 1\}$. Imagine the two inputs are scores of two categories. You want the score for the correct category larger than the score for the incorrect categories by at least some margin.  Like hinge loss, if $y*(x_1-x_2)$ is larger than margin, the cost is 0. If it is smaller, the cost increases linearly. If you were to use this for classification, you would have $x_1$ be the score of the correct answer and $x_2$ be the score of the highest scoring incorrect answer in the mini-batch. If used in energy based models (discussed later), this loss function pushes down on the correct answer $x_1$ and up on the incorrect answer $x_2$.
-->

Las pérdidas de margen son una categoría de pérdidas importantes. Si tienes dos entradas, esta función de pérdida indica que quieres que una de las entradas sea más grande que la otra por al menos un margen. En este caso $y$ es una variable binaria $\in \{ -1, 1\}$. Puedes pensar en las dos entradas como en puntajes de dos categorías. Vas a querer que el puntaje para la categoría correcta sea más grande que el puntaje para las categorías incorrectas por lo menos por algún margen.  Como la pérdida de bisagra; si $y*(x_1-x_2)$ es más grande que el margen, el costo es 0. Si es más pequeño, el costo incrementa de forma lineal. Si fueses a utilizar esto para clasificar, tendrías que $x_1$ es el puntaje de la respuesta correcta y $x_2$ es el puntaje de la respuesta incorrecta con puntaje más alto en el mini-lote. Si se utiliza en modelos basados en energía (los discutiremos más adelante), esta función de pérdida empuja hacia abajo sobre la respuesta correcta $x_1$ y hacia arriba sobre la respuesta incorrecta $x_2$.

<!--
### Triplet Margin Loss - `nn.TripletMarginLoss()`
-->


### Pérdida de Margen Trilliza  - `nn.TripletMarginLoss()`

<!--$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margin}, 0\}
$$
-->

$$
L(a,p,n) = \max\{d(a_i,p_i)-d(a_i,n_i)+\text{margen}, 0\}
$$

<!--This loss is used for measuring a relative similarity between samples.  For example, you put two images with the same category through a CNN and get two vectors. You want the distance between those two vectors to be as small as possible. If you put two images with different categories through a CNN, you want the distance between those vectors to be as large as possible. This loss function tries to send the first distance toward 0 and the second distance larger than some margin.  However, the only thing that matter is that the distance between the good pair is smaller than the distance between the bad pair.
-->

Esta pérdida se usa para medir la similitud relativa entre muestras.  Por ejemplo, puedes pasar dos imágenes con la misma categoría por una CNN y obtener dos vectores. Vas a querer que la distancia entre los dos vectores sea lo más pequeña posible. Si pasas dos imágenes con diferentes categorias por una CNN, vas a querer que la distancia entre esos vectores sea lo más grande posible. Esta función de pérdida intenta hacer que la primera distancia sea 0 y la segunda distancia sea más grande que algún margen.  Sin embargo, la única cosa que importa es que la distancia entre el par de imágenes de la misma clase sea más pequeña que la distancia entre el par de imágenes de clase distinta.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Triplet Margin Loss
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/tml.png" width="100%"/><br>
<b>Fig. 1</b>: Pérdida de Margen Trilliza 
</center>

<!--This was originally used to train an image search system for Google. At that time, you would type a query into Google and it would encode that query into a vector. It would then compare that vector to a bunch of vectors from images that were previously indexed. Google would then retrieve the images that were the closest to your vector.
-->

Esta función se usó originalmente para entrenar un sistema de búsqueda de imágenes para Google. En ese entonces, escribías una consulta en Google y Google codificaba esa consulta como un vector. Luego, se comparaba ese vector con un montón de vectores de imágenes que se habían indexado anteriormente. Google entonces recuperaba las imágenes más cercanas al vector.

<!--
### Soft Margin Loss - `nn.SoftMarginLoss()`
-->


### Pérdida Soft Margen - `nn.SoftMarginLoss()`

<!--$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelement()}}
$$
-->

$$
L(x,y) = \sum_i\frac{\log(1+\exp(-y[i]*x[i]))}{x.\text{nelemento()}}
$$

<!--Creates a criterion that optimizes a two-class classification logistic loss between input tensor $x$  and target tensor $y$  (containing 1 or -1).
-->

Esta función crea un criterio que optimiza la pérdida logística para clasificación de dos clases entre un tensor de entrada $x$ y un tensor objetivo $y$ (que contiene 1 o -1).

<!--* This softmax version of a margin loss. You have a bunch of positives and a bunch of negatives you want to pass through a softmax. This loss function then tries to make $\text{exp}(-y[i]*x[i])$ for the correct $x[i]$ smaller than for any other.
* This loss function wants to pull the positive values of $y[i]*x[i]$ closer together and push the negative values far apart but, as opposed to a hard margin, with some continuous, exponentially decaying effect on the loss .
-->

* Esta es una versión softmax de la pérdida de margen. Tienes un puñado de ejemplos positivos y de ejemplos negativos que quieres pasar por una softmax. Esta función de pérdida entonces intenta hacer que el $\text{exp}(-y[i]*x[i])$  para el $x[i]$ correcto sea más pequeño que para cualquier otro.
* Esta función de pérdida intenta jalar los valores positivos de $y[i]*x[i]$ para acercarlos y alejar los valores negativos, pero al contrario que el margen duro, tiene un efecto continuo y de decadencia exponencial sobre la función de pérdida.

<!--
### Multi-Class Hinge Loss - `nn.MultiLabelMarginLoss()`
-->


### Pérdida de Bisagra Multi-Clase - `nn.MultiLabelMarginLoss()`

<!--$$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{size}(0)}
$$
-->

$$
L(x,y)=\sum_{ij}\frac{max(0,1-(x[y[j]]-x[i]))}{x.\text{tamano}(0)}
$$

<!--This margin-base loss allows for different inputs to have variable amounts of targets. In this case you have several categories for which you want high scores and it sums the  hinge loss over all categories. For EBMs, this loss function pushes down on desired categories and pushes up on non-desired categories.
-->

Esta pérdida basada en margen permite que las distintas entradas tengan cantidades de objetivos variables. En este caso tienes varias categorías para las cuales quieres puntajes altos y se suma la pérdida de bisagra para todas las categorías. Para modelos basados en energía, esta función de pérdida empuja hacia abajo sobre las categorías deseadas y hacia arriba sobre las no-deseadas.

<!--
### Hinge Embedding Loss - `nn.HingeEmbeddingLoss()`
-->


### Perdida de *Embedding* de Bisagra - `nn.HingeEmbeddingLoss()`

<!--$$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             x_n, &\quad y_n=1,  \\
             \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
             \end{array}
\right.
\end{equation}
$$
-->

$$
l_n =
\left\{
     \begin{array}{lr}
     x_n, &\quad y_n=1,  \\
     \max\{0,\Delta-x_n\}, &\quad y_n=-1  \\
     \end{array}
\right.
$$


<!--Hinge embedding loss used for semi-supervised learning by measuring whether two inputs are similar or dissimilar. It pulls together things that are similar and pushes away things are dissimilar. The $y$ variable indicates whether the pair of scores need to go in a certain direction. Using a hinge loss, the score is positive if $y$ is 1 and some margin $\Delta$ if $y$ is -1.
-->

La pérdida de *embedding* de bisagra se usa para aprendizaje semi-supervisado al medir si dos entradas son similares o disímiles. Acerca las cosas que son similares y separa las cosas que son disímiles. La variable $y$ indica si la pareja de puntajes debe ir en cierta dirección. Usando una pérdida de bisagra, el puntaje es positivo si $y$ es 1 y algún margen $\Delta$ si $y$ es -1.

<!--
### Cosine Embedding Loss - `nn.CosineEmbeddingLoss()`
-->


### Pérdida de *Embedding* de Coseno - `nn.CosineEmbeddingLoss()`

<!--$$
\begin{equation}
l_n =
\left\{
             \begin{array}{lr}
             1-\cos(x_1,x_2), & \quad y=1,  \\
             \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
             \end{array}
\right.
\end{equation}
$$
-->

$$
l_n =
\left\{
     \begin{array}{lr}
     1-\cos(x_1,x_2), & \quad y=1,  \\
     \max(0,\cos(x_1,x_2)-\text{margin}), & \quad y=-1
     \end{array}
\right.
$$

<!--This loss is used for measuring whether two inputs are similar or dissimilar, using the cosine distance, and is typically used for learning nonlinear embeddings or semi-supervised learning.
-->

Esta pérdida se usa para medir si dos entradas son similares o disímiles, usando la distancia de coseno, y a menudo se utiliza para aprender *embeddings* no-lineales o para aprendizaje semi-supervisado.

<!--* Thought of another way, 1 minus the cosine of the angle between the two vectors is basically the normalised Euclidean distance.
* The advantage of this is that whenever you have two vectors and you want to make their distance as large as possible, it is very easy to make the network achieve this by make the vectors very long. Of course this is not optimal. You don't want the system to make the vectors big but rotate vectors in the right direction so you normalise the vectors and calculate the normalised Euclidean distance.
* For positive cases, this loss tries to make the vectors as aligned as possible. For negative pairs, this loss tries to make the cosine smaller than a particular margin. The margin here should be some small positive value.
* In a high dimensional space, there is a lot of area near the equator of the sphere. After normalisation, all your points are now normalised on the sphere. What you want is samples that are semantically similar to you to be close. The samples that are dissimilar should be orthogonal. You don't want them to be opposite each other because there is only one point at the opposite pole. Rather, on the equator, there is a very large amount of space so you want to make the margin some small positive value so you can take advantage of all this area.
-->

* Puesto de otra manera, 1 menos el coseno del ángulo entre los dos vectores es básicamente la distancia Euclidiana normalizada.
* La ventaja de esto es que siempre que tengas dos vectores y quieras hacer la distancia entre ellos lo más grande posible, es muy fácil hacer que la red logre esto haciendo que los vectores sean muy largos. Por supuesto, esto no es óptimo. No quieres que el sistema haga los vectores grandes sino que los rote en la dirección correcta para que los puedas normalizar y calcular la distancia Euclidiana normalizada.
* Para los casos positivos, esta pérdida intenta hacer que los vectores se alineen tanto como sea posible. Para las parejas negativas, se intenta que el coseno sea más pequeño que un margen particular. El margen aquí debería ser algún valor positivo pequeño.
* En un espacio de alta dimensionalidad, hay una área muy grande cerca del ecuador de la esfera. Tras normalizar, todos tus puntos ahora estarán normalizados sobre la esfera. Lo que quieres es que las muestras que son semánticamente parecidas estén cerca. Las muestras que son disímiles deberían ser ortogonales. No quieres que sean opuestas entre sí porque solo hay un punto en el polo opuesto. Más bien, sobre el ecuador hay una cantidad muy grande de espacio así que vas a querer que el margen sea algún valor positivo pequeño para que puedas tomar ventaja de toda esta área.

<!--
### [Connectionist Temporal Classification (CTC) Loss - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)
-->


### [Pérdida de Clasificación Temporal Conexionista (CTC) - `nn.CTCLoss()`](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4103s)

<!--Calculates loss between a continuous (unsegmented) time series and a target sequence.
*  CTC loss sums over the probability of possible alignments of input to target, producing a loss value which is differentiable with respect to each input node.
* The alignment of input to target is assumed to be "many-to-one", which limits the length of the target sequence such that it must less than or equal to the input length.
* Useful when your output is a sequence of vectors, which is correspond to scores of categories.
-->

Calcula la pérdida entre una serie de tiempo continua (no-segmentada) y una secuencia objetivo.
La pérdida CTC realiza una suma sobre la probabilidad de los posibles alineamientos de la entrada al blanco, que produce un valor de pérdida que es diferenciable con respecto a cada nodo de entrada.
* Se asume que el alineamiento entre la entrada y la salida es de «muchos-a-uno», lo que limita la longitud de la secuencia objetivo tal que sea menor o igual a la longitud de la secuencia de entrada.
* Es útil cuando tu salida es una secuencia de vectores, que se corresponden con puntajes de categorías.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: CTC Loss for speech recognition
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig1.png" width="85%"/><br>
<b>Fig. 2</b>: Pérdida CTC para reconocimiento del habla
</center>

<!--Application Example: Speech recognition system
* Goal: Predict what word is being pronounced every 10 milliseconds.
* Each word is represented by a sequence of sounds.
* Depends on the person's speaking speed, different length of the sounds might be mapped to the same word.
* Find the best mapping from the input sequence to the output sequence. A good method for this is using dynamic programming to find the minimum cost path.
-->

Ejemplo de aplicación: Sistema de reconocimiento del habla
* Goal: Predecir una palabra que se pronuncia cada 10 milisegundos.
* Cada palabra se representa como una secuencia de sonidos.
* Dependiendo de la velocidad de habla de una persona, diferentes longitudes de los sonidos podrían mapearse a la misma palabra.
* Encontrar el mejor mapeo de la secuencia de entrada a la secuencia de salida. Un buen método para esto es usar programación dinámica para encontrar el camino de costo mínimo.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Many-to-one mapping setup
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/Fig2.png" width="85%" style="background-color:white;"/><br>
<b>Fig. 3</b>: Configuración para mapeo de muchos-a-uno.
</center>

<!--
# Energy-Based Models (Part IV) - Loss Function
-->


# Modelos Basados en Energía (Parte IV) - Función de Pérdida

<!--
## Architecture and Loss Functional
-->


## Arquitectura y Funcional de Pérdida

<!--Family of energy functions: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.
-->

Familia de funcionales de energía: $\mathcal{E} = \{E(W,Y, X) : W \in \mathcal{W}\}$.

<!--Training set: $S = \{(X^i, Y^i): i = 1 \cdots P\}$
-->

Conjunto de entrenamiento: $S = \{(X^i, Y^i): i = 1 \cdots P\}$

<!--Loss functional: $\mathcal{L} (E, S)$
* Functional means a function of another function. In our case, the functional $\mathcal{L} (E, S)$ is a function of the energy function $E$.
* Because $E$ is parametrised by $W$, we can turn the functional to a loss function of $W$: $\mathcal{L} (W, S)$
* Measures the quality of an energy function on training set
* Invariant under permutations and repetitions of the samples.
-->

Funcional de pédida: $\mathcal{L} (E, S)$
* Funcional quiere decir función de otra función. En nuestro caso, el funcional $\mathcal{L} (E, S)$ es una función de la función de energía $E$.
* Ya que $E$ se parametriza por medio de $W$, podemos convertir el funcional en una función de pérdida de $W$: $\mathcal{L} (W, S)$
* Mide la calidad de una función de energía sobre el conjunto de entrenamiento
* Es invariante a permutaciones y repeticiones de las muestras

<!--Training: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.
-->

Entrenamiento: $W^* = \min_{W\in \mathcal{W}} \mathcal{L}(W, S)$.

<!--Form of the loss functional:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ is per-sample loss
* $Y^i$ is desired answer, can be category or a whole image, etc.
* $E(W, \mathcal{Y}, X^i)$ is energy surface for a given $X_i$ as $Y$ varies
* $R(W)$ is regulariser
-->

Forma del funcional de pérdida:
* $L(Y^i, E(W, \mathcal{Y}, X^i))$ es la pérdida por cada muestra.
* $Y^i$ es la respuesta deseada, puede ser una categoría o una imagen entera, etc.
* $E(W, \mathcal{Y}, X^i)$ es la superficie de energía para un $X_i$ dado a medida que $Y$ varía.
* $R(W)$ es un regularizador.

<!--$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$
-->

$$
\mathcal{L}(E, S) = \frac{1}{P} \sum_{i=1}^P L(Y^i, E(W,\mathcal{Y}, 	X^i)) + R(W)
$$

<!--
## Designing a Good Loss Function
-->


## Diseñar una buena Función de Pérdida

<!--**Push down** on the energy of the correct answer.
-->

**Empujar hacia abajo** sobre la energía de la respuesta correcta.

<!--**Push up** on the energies of the incorrect answers, particularly if they are smaller than the correct one.
-->

**Empujar hacia arriba** sobre las energías de las respuestas incorrectas, en particular si son más pequeñas que la correcta.

<!--
## Examples of Loss Functions
-->


## Ejemplos de Funciones De Pérdida

<!--
### Energy Loss
-->


### Pérdida de Energía

<!--$$
L_{energy} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$
-->

$$
L_{energy} (Y^i, E(W, \mathcal{Y}, X^i)) = E(W, Y^i, X^i)
$$

<!--This loss function simply pushes down on the energy of the correct answer. If the network is not designed properly, it might end up with a mostly flat energy function as you only trying to make the energy of the correct answer small but not pushing up the energy elsewhere. Thus, the system might collapses.
-->

Esta pérdida simplemente empuja hacía abajo sobre la energía de la respuesta correcta. Si la red no se diseña de forma apropiada, podría terminar con una función de energía mayormente plana puesto que intentas hacer que la energía de la respuesta correcta sea pequeña pero no empujas la energía hacia arriba en otras partes. Por lo tanto, el sistema podría colapsar.

<!--
### Negative Log-Likelihood Loss
-->


### Pérdida de Log-Verosimilitud Negativa

<!--$$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$
-->

$$
L_{nll}(W, S) = \frac{1}{P} \sum_{i=1}^P (E(W, Y^i, X^i) + \frac{1}{\beta} \log \int_{y \in \mathcal{Y}} e^{\beta E(W, y, X^i)})
$$

<!--This loss function pushes down on the energy of the correct answer while pushing up on the energies of all answers in proportion to their probabilities. This reduces to the perceptron loss when $\beta \rightarrow \infty$. It has been used for a long time in many communities for discriminative training with structured outputs.
-->

Esta función de pérdida empuja hacía abajo sobre la energía de la respuesta correcta a la vez que empuja hacia arriba las energías de todas las respuestas en proporción a sus probabilidades. Esto reduce la pérdida del perceptrón cuando $\beta \rightarrow \infty$. Se ha utilizado por mucho tiempo en varias comunidades para entrenamiento discriminativo con salidas estructuradas.

<!--A probabilistic model is an EBM in which:
-->

Un modelo probabilístico es un EBM en el cual:

<!--* The energy can be integrated over Y (the variable to be predicted)
* The loss function is the negative log-likelihood
-->

* La energía se puede integrar sobre Y (la variable a predecir)
* La pérdida es la log-verosimilitud negativa

<!--
### [Perceptron Loss](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)
-->


### [Pérdida de Perceptrón](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=4998s)

<!--$$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$
-->

$$
L_{perceptron}(Y^i,E(W,\mathcal Y, X^*))=E(W,Y^i,X^i)-\min_{Y\in \mathcal Y} E(W,Y,X^i)
$$

<!--Very similar to the perceptron loss from 60+ years ago, and it's always positive because the minimum is also taken over $Y^i$, so $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. The same computation shows that it give exactly zero only when $Y^i$ is the correct answer.
-->

Muy parecida a la pérdida de perceptrón de hace 60+ años, y siempre es positiva ya que el mínimo también se toma sobre $Y^i$, así que $E(W,Y^i,X^i)-\min_{Y\in\mathcal Y} E(W,Y,X^i)\geq E(W,Y^i,X^i)-E(W,Y^i,X^i)=0$. El mismo cálculo muestra que devuelve exactamente cero solo cuando $Y^i$ es la respuesta correca.

<!--This loss makes the energy of the correct answer small, and at the same time, makes the energy for all other answers as large as possible. However, this loss does not prevent the function from giving the same value to every incorrect answer $Y^i$, so in this sense, it is a bad loss function for non-linear systems. To improve this loss, we define the *most offending incorrect answer*.
-->

Esta pérdida hace que la energía de la respuesta correcta sea pequeña, y al mismo tiempo, hace que la energía para todas las otras respuestas sea lo más grande posible. Sin embargo, esta pérdida no evita que la función le de el mismo valor a todas las respuestas incorectas $Y^i$, así que en este aspecto, es una función de pérdida mala para sistemas no-lineales. Para mejorar esta función de pérdida, definimos la *respuesta incorrecta más transgresora*.

<!--
## Generalized Margin Loss
-->


## Pérdida de Margen Generalizado

<!--**Most offending incorrect answer**: discrete case
Let $Y$ be a discrete variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all possible answers that are incorrect:
-->

**Respuesta incorrecta más transgresora**:  caso discreto
Sea $Y$ una variable discreta. Entonces para una muestra de entrenamiento $(X^i,Y^i)$, la *respuesta incorrecta más transgresora* $\bar Y^i$ es la respuesta que tiene la energía más baja entre todas las respuestas posibles que son incorrectas:

<!--$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ and }Y\neq Y^i} E(W, Y,X^i)
$$
-->

$$
\bar Y^i=\text{argmin}_{y\in \mathcal Y\text{ y }Y\neq Y^i} E(W, Y,X^i)
$$

<!--**Most offending incorrect answer**: continuous case
Let $Y$ be a continuous variable. Then for a training sample $(X^i,Y^i)$, the *most offending incorrect answer* $\bar Y^i$ is the answer that has the lowest energy among all answers that are at least $\epsilon$ away from the correct answer:
-->

**Respuesta incorrecta más transgresora**:  caso continuo
Sea $Y$ una variable continua. Entonces para una muestra de entrenamiento $(X^i,Y^i)$, la *respuesta incorrecta más transgresora* $\bar Y^i$ es la respuesta que tiene la energía más baja entre todas las respuestas que están por lo menos a un valor $\epsilon$ de distancia de la respuesta correcta:

<!--$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ and }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$
-->

$$
\bar Y^i=\text{argmin}_{Y\in \mathcal Y\text{ y }\|Y-Y^i\|>\epsilon} E(W,Y,X^i)
$$

<!--In the discrete case, the *most offending incorrect answer* is the one with smallest energy that isn't the correct answer. In the continuous case, the energy for $Y$ extremely close to $Y^i$ should be close to $E(W,Y^i,X^i)$. Furthermore, the $\text{argmin}$ evaluated over $Y$ not equal to $Y^i$ would be 0. As a result, we pick a distance $\epsilon$ and decide that only $Y$'s at least $\epsilon$ from $Y_i$ should be considered the "incorrect answer". This is why the optimization is only over $Y$'s of distance at least $\epsilon$ from $Y^i$.
-->

En el caso discreto, la *respuesta incorrecta más transgresora* es la respuesta incorrecta que tiene la energía más pequeña. En el caso continuo, la energía para $Y$ extremadamente cerca de $Y^i$ debería estar cerca de $E(W,Y^i,X^i)$. Además, el $\text{argmin}$ evaluado sobre $Y$ distinto de $Y^i$ sería 0. Como resultado, escogemos una distancia $\epsilon$ y decidimos que solo los $Y$ por lo menos a una distancia $\epsilon$ de $Y_i$ deberían ser considerados como la «respuesta incorrecta». Esto es porque la optimización solo se hace sobre $Y$”s que estén a una distancia de al menos $\epsilon$ de $Y^i$.

<!--If the energy function is able to ensure that the energy of the *most offending incorrect answer* is higher than the energy of the correct answer by some margin, then this energy function should work well.
-->

Si la función de energía es capaz de asegurar que la energía de la *respuesta incorrecta más transgresora* sea más alta que la energía de la respuesta correcta por algún margen, entonces esta función de energía debería funcionar bien.

<!--
## Examples of Generalized Margin Loss Functions
-->


## Ejemplos de Funciones De Pérdida Generalizadas

<!--
### Hinge Loss
-->


### Pérdida de Bisagra

<!--$$
L_{\text{hinge}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$
-->

$$
L_{\text{bisagra}}(W,Y^i,X^i)=( m + E(W,Y^i,X^i) - E(W,\bar Y^i,X^i) )^+
$$

<!--Where $\bar Y^i$ is the *most offending incorrect answer*. This loss enforces that the difference between the correct answer and the most offending incorrect answer be at least $m$.
-->

Donde $\bar Y^i$ es la *respuesta incorrecta más transgresora*. Esta pérdida obliga a que la diferencia entre la respuesta correcta y la respuesta incorrecta más transgresora sea por lo menos de $m$.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Hinge Loss
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/hinge.png" width="60%"/><br>
<b>Fig. 4</b>: Pérdida de Bisagra
</center>

<!--Q: How do you pick $m$?
-->

Q: ¿Cómo escoges $m$?

<!--A: It's arbitrary, but it affects the weights of the last layer.
-->

A: Es arbitrario, pero afecta los pesos de la última capa.

<!--
### Log Loss
-->


### Pérdida Logarítmica

<!--$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$
-->

$$
L_{\log}(W,Y^i,X^i)=\log(1+e^{E(W,Y^i,X^i)-E(W,\bar Y^i,X^i)})
$$

<!--This can be thought of as a "soft" hinge loss. Instead of composing the difference of the correct answer and the most offending incorrect answer with a hinge, it's now composed with a soft hinge. This loss tries to enforce an "infinite margin", but because of the exponential decay of the slope it doesn't happen.
-->

Se puede interpretar como una pérdida de bisagra «suave». En vez de ajustar la diferencia entre la respuesta correcta y la respuesta incorrecta más transgresora con una bisagra, ahora se ajusta con una bisagra suave. Esta pérdida intenta forzar un «margen infinito», pero debido a la degradación exponencial de la pendiente, esto no ocurre.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Fig. 5</b>: Log Loss
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/log.png" width="60%"/><br>
<b>Fig. 5</b>: Pérdida Logarítmica
</center>

<!--
### Square-Square Loss
-->


### Pérdida Cuadrada-Cuadrada

<!--$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$
-->

$$
L_{sq-sq}(W,Y^i,X^i)=E(W,Y^i,X^i)^2+(\max(0,m-E(W,\bar Y^i,X^i)))^2
$$

<!--This loss combines the square of the energy with a square hinge. The combination tries to minimize the energy and but enforce margin at least $m$ on the most offending incorrect answer. This is very similar to the loss used in Siamese nets.
-->

Esta pérdida intenta combinar el cuadrado de la energía con una bisagra al cuadrado. Esta combinación intenta minimizar la energía y forzar un margen de al menos $m$ sobre la respuesta incorrecta más transgresora. Esto es muy similar a la pérdida usada en las redes Siamesas.

<!--
## Other Losses
-->


## Otras Pérdidas

<!--There are a whole bunch. Here is a summary of good and bad loss functions.
-->

Hay muchas otras. Aquí hay un resumen de algunas funciones de pérdida buenas y malas.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selection of EBM loss functions
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-2/other.png" width="100%" style="background-color:white;"/><br>
<b>Fig. 6</b>: Selección de funciones de pérdida para EBMs
</center>

<!--The right-hand column indicates if the energy function enforces a margin. The plain old energy loss does not push up anywhere, so it doesn't have a margin. The energy loss doesn't work for every problem. The perceptron loss works if you have a linear parametrisation of your energy but not in general. Some of them have a finite margin like the hinge loss, and some have an infinite margin like the soft hinge.
-->

La columna de la derecha indica si la función de pérdida obliga a que haya un margen. La típica pérdida de energía no empuja hacia arriba en ninguna parte, así que no tiene un margen. La pérdida de energía no funciona para todos los problemas. La pérdida de perceptrón funciona si tienes una parametrización lineal de tu energía pero no en general. Algunas de ellas tienen un margen finito como la pérdida de bisagra, y otras tienen un margen infinito, como la bisagra suave.

<!--Q: How is the most offending incorrect answer found $\bar Y_i$ found in the continuous case?
-->

Q: ¿Cómo se encuentra la respuesta incorrecta más transgresora $\bar Y_i$ en el caso continuo?

<!--A: You want to push up on a point that is sufficiently far from $Y^i$, because if it's too close, the parameters may not move much since the function defined by a neural net is "stiff". But in general, this is hard and this is the problem that methods selecting contrastive samples try to solve. There's no single correct way to do it.
-->

A: Quieres empujar hacia arriba en un punto que esté lo suficientemente lejos de $Y^i$, porque si está muy cerca, los parámetros podrían no moverse mucho ya que la función definida por una red neuronal es «rígida». Pero en general, esto es difícil y es el problema que intentan resolver los métodos que seleccionan muestras contrastivas. No hay una única forma correcta de hacerlo.

<!--A slightly more general form for hinge type contrastive losses is:
-->

Una forma ligeramente más general de las pérdidas contrastivas de tipo bisagra es:

<!--$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$
-->

$$
L(W,X^i,Y^i)=\sum_y H(E(W, Y^i,X^i)-E(W,y,X^i)+C(Y^i,y))
$$

<!--We assume that $Y$ is discrete, but if it were continuous, the sum would be replaced by an integral. Here, $E(W, Y^i,X^i)-E(W,y,X^i)$ is the difference of $E$ evaluated at the correct answer and some other answer. $C(Y^i,y)$ is the margin, and is generally a distance measure between $Y^i$ and $y$. The motivation is that the amount we want to push up on a incorrect sample $y$ should depend on the distance between $y$ and the correct sample $Y_i$. This can be a more difficult loss to optimize.
-->

Asumimos que $Y$ es discreta, pero si fuese continua, la suma se remplazaría por una integral. Aquí, $E(W, Y^i,X^i)-E(W,y,X^i)$  es la diferencia entre $E$ evaluado en la respuesta correcta y en alguna otra respuesta. $C(Y^i,y)$ es el margen, y generalmente es una medición de la distancia entre $Y^i$ y $y$. La motivación es que la cantidad por la que queremos empujar hacia arriba sobre una muestra incorrecta $y$ debería depender de la distancia entre $y$ y la muestra correcta $Y_i$. Esta puede ser una pérdida difícil de optimizar.

