---
lang-ref: ch.11-1
lecturer: Yann LeCun
title: Funciones de activación y de costo (parte 1)
authors: Haochen Wang, Eunkyung An, Ying Jin, Ningyuan Huang
date: 13 Apr 2020
lang: es
translator: Alberto Mario Ceballos-Arroyo
translation-date: 10 Sep 2020
---

<!--
## [Activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)
-->


## [Funciones de activación](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

<!--In today's lecture, we will review some important activation functions and their implementations in PyTorch. They came from various papers claiming these functions work better for specific problems.
-->

En la clase de hoy, vamos a repasar algunas funciones de activación importantes y sus implementaciones en PyTorch. Estas funciones vienen de varios artículos en los que se asegura que funcionan mejor para problemas específicos.

<!--
### ReLU - `nn.ReLU()`
-->


### ReLU - `nn.ReLU()`

<!--$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$
-->

$$
\text{ReLU}(x) = (x)^{+} = \max(0,x)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU.png" height="400px" /><br>
<b>Fig. 1</b>: ReLU
</center>

<!--
### RReLU - `nn.RReLU()`
-->


### RReLU - `nn.RReLU()`

<!--There are variations in ReLU. The Random ReLU (RReLU) is defined as follows.
-->

Hay variaciones de la ReLU. La ReLU Aleatoria (RReLU, por sus siglas en inglés) se define de la siguiente manera:

<!--$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$
-->

$$
\text{RReLU}(x) = \begin{cases}
      x, & \text{si} x \geq 0\\
      ax, & \text{en otro caso}
    \end{cases}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/RRelU.png" width="700" /><br>
<b>Fig. 2</b>: ReLU, Leaky ReLU/PReLU, RReLU
</center>

<!--Note that for RReLU, $a$ is a random variable that keeps samplings in a given range during training, and remains fixed during testing. For PReLU , $a$ is also learned. For Leaky ReLU, $a$ is fixed.
-->

Recuerda que para la RReLU, $a$ es una variable aleatoria que se muestrea constantemente a partir de un rango dado durante el entrenamiento, y se mantiene fija durante las pruebas. Para PReLU, $a$ es además un parámetro aprendido. Para la Leaky ReLU, $a$ es un valor fijo.

<!--
### LeakyReLU - `nn.LeakyReLU()`
-->


### LeakyReLU - `nn.LeakyReLU()`

<!--$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      a_\text{negative slope}x, & \text{otherwise}
    \end{cases}
$$
-->

$$
\text{LeakyReLU}(x) = \begin{cases}
      x, & \text{si} x \geq 0\\
      a_\text{pendiente negativa}x, & \text{en otro caso}
    \end{cases}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: LeakyReLU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LeakyReLU.png" height="400px" /><br>
<b>Fig. 3</b>: LeakyReLU
</center>

<!--Here $a$ is a fixed parameter. The bottom part of the equation prevents the problem of dying ReLU which refers to the problem when ReLU neurons become inactive and only output 0 for any input. Therefore, its gradient is 0. By using a negative slope, it allows the network to propagate back and learn something useful.
-->

Aquí, $a$ es un parámetro fijo. La parte interior de la ecuación evita el problema de las ReLU muertas, que se refiere al problema que ocurre cuando las neuronas ReLU se vuelven inactivas y solo retornan 0 para cualquier valor de entrada. Por tanto, su gradiente es 0. Al usar una pendiente negativa, se permite que la red haga propagación hacia atrás y aprenda algo útil.

<!--LeakyReLU is necessary for skinny network, which is almost impossible to get gradients flowing back with vanilla ReLU. With LeakyReLU, the network can still have gradients even we are in the region where everything is zero out.
-->

La LeakyReLU es necesaria para las redes neuronales delgadas, en las que es casi imposible hacer que los gradientes fluyan hacia atrás con la ReLU por defecto. Con la LeakyReLU, la red puede seguir teniendo gradientes incluso cuando estamos en la región en la que todo se vuelve cero.

<!--
### PReLU - `nn.PReLU()`
-->


### PReLU - `nn.PReLU()`

<!--$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{if} x \geq 0\\
      ax, & \text{otherwise}
    \end{cases}
$$
-->

$$
\text{PReLU}(x) = \begin{cases}
      x, & \text{si} x \geq 0\\
      ax, & \text{en otro caso}
    \end{cases}
$$

<!--Here $a$ is a learnable parameter.
-->

Aquí, $a$ es un parámetro que se puede aprender.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/PReLU.png" height="400px" /><br>
<b>Fig. 4</b>: ReLU
</center>

<!--The above activation functions (*i.e.* ReLU, LeakyReLU, PReLU) are scale-invariant.
-->

Las funciones de activación descritas arriba (es decir, ReLU, LeakyReLU y PReLU) son invariantes de escala.

<!--
### Softplus - `Softplus()`
-->


### Softplus - `Softplus()`

<!--$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$
-->

$$
\text{Softplus}(x) = \frac{1}{\beta} * \log(1 + \exp(\beta * x))
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softplus.png" height="400px" /><br>
<b>Fig. 5</b>: Softplus
</center>

<!--Softplus is a smooth approximation to the ReLU function and can be used to constrain the output of a machine to always be positive.
-->

La Softplus es una aproximación suave de la función ReLU y puede ser usada para restringir la salida de una neurona para que siempre sea positiva.

<!--The function will become more like ReLU, if the $\beta$ gets larger and larger.
-->

La función se volverá más como la ReLU, si el $\beta$ se vuelve más y más grande.

<!--
### ELU - `nn.ELU()`
-->


### ELU - `nn.ELU()`

<!--$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$
-->

$$
\text{ELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x) - 1)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ELU.png" height="400px" /><br>
<b>Fig. 6</b>: ELU
</center>

<!--Unlike ReLU, it can go below 0 which allows the system to have average output to be zero. Therefore, the model may converge faster. And its variations (CELU, SELU) are just different parametrizations.
-->

Al contrario que la ReLU, puede ir debajo de 0, lo que permite que el sistema tenga una salida promedio de 0. Por lo tanto, el modelo puede converger más rápido. Y sus variaciones (CELU, SELU) son simplemente versiones con parametrizaciones diferentes.

<!--
### CELU - `nn.CELU()`
-->


### CELU - `nn.CELU()`

<!--$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$
-->

$$
\text{CELU}(x) = \max(0, x) + \min(0, \alpha * (\exp(x/\alpha) - 1)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Fig. 7</b>: CELU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/CELU.png" height="400px" /><br>
<b>Fig. 7</b>: CELU
</center>

<!--
### SELU - `nn.SELU()`
-->


### SELU - `nn.SELU()`

<!--$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$
-->

$$
\text{SELU}(x) = \text{scale} * (\max(0, x) + \min(0, \alpha * (\exp(x) - 1))
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/SELU.png" height="400px" /><br>
<b>Fig. 8</b>: SELU
</center>

<!--
### GELU - `nn.GELU()`
-->


### GELU - `nn.GELU()`

<!--$$
\text{GELU(x)} = x * \Phi(x)
$$
-->

$$
\text{GELU(x)} = x * \Phi(x)
$$

<!--where $\Phi(x)$ is the Cumulative Distribution Function for Gaussian Distribution.
-->

donde $\Phi(x)$ es la Función de Distribución Acumulada para la Distribución Gaussiana.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/GELU.png" height="400px" /><br>
<b>Fig. 9</b>: GELU
</center>

<!--
### ReLU6 - `nn.ReLU6()`
-->


### ReLU6 - `nn.ReLU6()`

<!--$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$
-->

$$
\text{ReLU6}(x) = \min(\max(0,x),6)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/ReLU6.png" height="400px" /><br>
<b>Fig. 10</b>: ReLU6
</center>

<!--This is ReLU saturating at 6. But there is no particular reason why picking 6 as saturation, so we can do better by using Sigmoid function below.
-->

Esta es la ReLU saturada en 6. Pero no hay ninguna razón en particular por la que escoger 6 como valor de saturación, así que podemos hacerlo mejor utilizando la función Sigmoide como abajo.

<!--
### Sigmoid - `nn.Sigmoid()`
-->


### Sigmoide - `nn.Sigmoid()`

<!--$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$
-->

$$
\text{Sigmoid}(x) = \sigma(x) = \frac{1}{1 + \exp(-x)}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Sigmoid
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Sigmoid.png" height="400px" /><br>
<b>Fig. 11</b>: Sigmoide
</center>

<!--If we stack sigmoids in many layers, it may be inefficient for the system to learn and requires careful initialization. This is because if the input is very large or small, the gradient of the sigmoid function is close to 0. In this case, there is no gradient flowing back to update the parameters, known as saturating gradient problem. Therefore, for deep neural networks, a single kink function (such as ReLU) is preferred.
-->

Si apilamos sigmoides en muchas capas, puede ser ineficiente para el aprendizaje del sistema y requerirá una inicialización cuidadosa. Esto es debido a que si la entrada es muy grande o pequeña, el gradiente de la función sigmoide se acerca a 0. En este caso, no hay un gradiente que fluya hacia atrás para actualizar los parámetros. Esto también se conoce como el problema del gradiente saturado. Por tanto, para las redes neuronales profundas, se prefiere utilizar funciones con un punto no diferenciable (como la ReLU).

<!--
### Tanh - `nn.Tanh()`
-->


### Tanh - `nn.Tanh()`

<!--$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$
-->

$$
\text{Tanh}(x) = \tanh(x) = \frac{\exp(x) - \exp(-x)}{\exp(x) + \exp(-x)}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanh.png" height="400px" /><br>
<b>Fig. 12</b>: Tanh
</center>

<!--Tanh is basically identical to Sigmoid except it is centred, ranging from -1 to 1. The output of the function will have roughly zero mean. Therefore, the model will converge faster.  Note that convergence is usually faster if the average of each input variable is close to zero. One example is Batch Normalization.
-->

La Tanh es básicamente idéntica a la Sigmoide excepto porque está centrada, con un rango de entre -1 y 1. La salida de la función tendrá una media aproximadamente de 0. Por lo tanto, el modelo convergerá más rápido.  Ten en cuenta que usualmente la convergencia será más rápida si el promedio de cada variable de entrada es cercano a cero. Un ejemplo es la Normalización por Lotes (Batch Normalization en inglés).

<!--
### Softsign - `nn.Softsign()`
-->


### Softsign - `nn.Softsign()`

<!--$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$
-->

$$
\text{SoftSign}(x) = \frac{x}{1 + |x|}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softsign.png" height="400px" /><br>
<b>Fig. 13</b>: Softsign
</center>

<!--It is similar to the Sigmoid function but gets to the asymptote slowly and alleviate the gradient vanishing problem (to some extent).
-->

Es similar a la función Sigmoide pero se acerca lentamente a la asíntota y hasta cierto punto resuelve el problema del desvanecimiento del gradiente.

<!--
### Hardtanh - `nn.Hardtanh()`
-->


### Tanh dura - `nn.Hardtanh()`

<!--$$
\text{HardTanh}(x) = \begin{cases}
      1, & \text{if} x > 1\\
      -1, & \text{if} x < -1\\
      x, & \text{otherwise}
\end{cases}
$$
-->

$$
\text{Tanh dura}(x) = \begin{cases}
      1, & \text{si} x > 1\\
      -1, & \text{si} x < -1\\
      x, & \text{en otro caso}
\end{cases}
$$

<!--The range of the linear region [-1, 1] can be adjusted using `min_val` and `max_val`.
-->

El rango de la región lineal [-1, 1] puede ser ajustado usando `min_val` y `max_val`.

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardtanh.png" height="400px" /><br>
<b>Fig. 14</b>: Hardtanh
</center>

<!--It works surprisingly well especially when weights are kept within the small value range.
-->

Funciona sorprendentemente bien, en especial cuando los pesos se mantienen dentro del pequeño rango de valores.

<!--
### Threshold - `nn.Threshold()`
-->


### Umbral - `nn.Threshold()`

<!--$$
  y = \begin{cases}
      x, & \text{if} x > \text{threshold}\\
      v, & \text{otherwise}
    \end{cases}
$$
-->

$$
  y = \begin{cases}
      x, & \text{si} x > \text{umbral}\\
      v, & \text{en otro caso}
    \end{cases}
$$

<!--It is rarely used because we cannot propagate the gradient back. And it is also the reason preventing people from using back-propagation in 60s and 70s when they were using binary neurons.
-->

Se usa muy raramente puesto que no se puede propagar el gradiente hacia atrás. Es también lo que evitaba que se usara la propagación hacia atrás en los 60s y 70s cuando se utilizaban neuronas binarias.

<!--
### Tanhshrink - `nn.Tanhshrink()`
-->


### Tanh encogida - `nn.Tanhshrink()`

<!--$$
\text{Tanhshrink}(x) = x - \tanh(x)
$$
-->

$$
\text{Tanh encogida}(x) = x - \tanh(x)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanhshrink
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Tanhshrink.png" height="400px" /><br>
<b>Fig. 15</b>: Tanh encogida
</center>

<!--It is rarely used except for sparse coding to compute the value of the latent variable.
-->

Se usa muy raramente, con la excepción de la codificación dispersa, donde se usa para computar el valor de la variable latente.

<!--
### Softshrink - `nn.Softshrink()`
-->


### Encogimiento suave - `nn.Softshrink()`

<!--$$
  \text{SoftShrinkage}(x) = \begin{cases}
      x - \lambda, & \text{if} x > \lambda\\
      x + \lambda, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$
-->

$$
  \text{Encogimiento suave}(x) = \begin{cases}
      x - \lambda, & \text{si} x > \lambda\\
      x + \lambda, & \text{si} x < -\lambda\\
      0, & \text{en otro caso}
    \end{cases}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 16</b>: Softshrink
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Softshrink.png" height="400px" /><br>
<b>Fig. 14</b>: Encogimiento suave
</center>

<!--This basically shrinks the variable by a constant towards 0, and forces to 0 if the variable is close to 0. You can think of it as a step of gradient for the $\ell_1$ criteria. It is also one of the step of the Iterative Shrinkage-Thresholding Algorithm (ISTA). But it is not commonly used in standard neural network as activations.
-->

Esta función básicamente encoge la variable por un valor constante hacía 0, y la obliga a ser 0 si el valor de la variable es cercano a 0. Puedes pensar en ella como un paso del gradiente para los criterios $\ell_1%. Es también uno de los pasos del Algoritmo de Encogimiento-Umbralización Iterativo (ISTA, por sus siglas en inglés). Pero no se usa a menudo en las redes neuronales estándar como función de activación.

<!--
### Hardshrink - `nn.Hardshrink()`
-->


### Encogimiento duro- `nn.Hardshrink()`

<!--$$
  \text{HardShrinkage}(x) = \begin{cases}
      x, & \text{if} x > \lambda\\
      x, & \text{if} x < -\lambda\\
      0, & \text{otherwise}
    \end{cases}
$$
-->

$$
  \text{EncogimientoDuro}(x) = \begin{cases}
      x, & \text{si} x > \lambda\\
      x, & \text{si} x < -\lambda\\
      0, & \text{en otro caso}
    \end{cases}
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Hardshrink
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/Hardshrink.png" height="400px" /><br>
<b>Fig. 17</b>: Encogimiento duro
</center>

<!--It is rarely used except for sparse coding.
-->

Se usa muy raramente, con la excepción de la codificación dispersa.

<!--
### LogSigmoid - `nn.LogSigmoid()`
-->


### LogSigmoide - `nn.LogSigmoid()`

<!--$$
\text{LogSigmoid}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$
-->

$$
\text{LogSigmoide}(x) = \log\left(\frac{1}{1 + \exp(-x)}\right)
$$

<!--<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoid
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week11/11-1/LogSigmoid.png" height="400px" /><br>
<b>Fig. 18</b>: LogSigmoide
</center>

<!--It is mostly used in the loss function but not common for activations.
-->

Se usa mayormente en la función de costo pero no es común en las activaciones.

<!--
### Softmin - `nn.Softmin()`
-->


### Softmin - `nn.Softmin()`

<!--$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$
-->

$$
\text{Softmin}(x_i) = \frac{\exp(-x_i)}{\sum_j \exp(-x_j)}
$$

<!--It turns numbers into a probability distribution.
-->

Convierte números en una distribución de probabilidad.

<!--
### Soft(arg)max - `nn.Softmax()`
-->


### Soft(arg)max - `nn.Softmax()`

<!--$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$
-->

$$
\text{Softmax}(x_i) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

<!--
### LogSoft(arg)max - `nn.LogSoftmax()`
-->


### LogSoft(arg)max - `nn.LogSoftmax()`

<!--$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$
-->

$$
\text{LogSoftmax}(x_i) = \log\left(\frac{\exp(x_i)}{\sum_j \exp(x_j)}\right)
$$

<!--It is mostly used in the loss function but not common for activations.
-->

Se usa mayormente en la función de costo pero no es común en las activaciones.

<!--
## [Q&A activation functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)
-->


## [Q&A funciones de activación](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=861s)

<!--
### `nn.PReLU()` related questions
-->


### preguntas respecto a la `nn.PReLU()`

<!--- Why would we want the same value of $a$ for all channels?
-->

- ¿Por qué querríamos el mismo valor de $a$ para todos los canales?

<!--  > Different channels could have different $a$. You could use $a$ as a parameter of every unit. It could be shared as a feature map as well.
-->

  > Diferentes canales pueden tener distintos valores de $a$. Podrías usar $a$ como un parámetro de todas las unidades. También podría ser compartida como un mapa de características.

<!--- Do we learn $a$? Is learning $a$ advantageous?
-->

- ¿Aprendemos $a$? ¿Es ventajoso aprender $a$?

<!--  > You can learn $a$ or fix it.
  > The reason for fixing is to ensure that nonlinearity gives you a non-zero gradient even if it's in a negative region.
  > Making $a$ learnable allows the system to turn nonlinearity into either linear mapping or full rectification. It could be useful for some applications like implementing an edge detector regardless of the edge polarity.
-->

  > Puedes aprender $a$ o mantenerlo como un valor fijo.
  > La razón para mantenerlo fijo es asegurar que la no-linealidad te de un gradiente distinto de 0 incluso si está en una región negativa.
  > Hacer $a$ un parámetro que se pueda aprender permite que el sistema convierta la no-linealidad ya sea en un mapeo lineal o en una rectificación completa. Podría ser util para algunas aplicaciones como implementar un detector de bordes sin importar la polaridad de los bordes.

<!--- How complex do you want your non-linearity to be?
-->

- ¿Qué tan compleja quieres que sea tu no-linealidad?

<!--  > Theoretically, we can parametrise an entire nonlinear function in very complicated way, such as with spring parameters, Chebyshev polynomial, etc. Parametrising could be a part of learning process.
-->

  > En teoría, podemos parametrizar una función no-lineal completa de formas muy complicadas, ya sea con parámetros de resorte, polinomios de Chebyshev, etc. Parametrizar la función podría ser parte del proceso de aprendizaje.

<!--- What is an advantage of parametrising over having more units in your system?
-->

- ¿Cuál es la ventaja de parametrizar en comparación con tener más unidades en tu sistema?

<!--  > It really depends on what you want to do. For example, when doing regression in a low dimensional space, parametrisation might help. However, if your task is in under a high dimensional space such as image recognition, just "a" nonlinearity is necessary and monotonic nonlinearity will work better.
  > In short, you can parametrize any functions you want but it doesn't bring a huge advantage.
-->

  > En realidad depende de lo que quieras hacer. Por ejemplo, cuando haces regresión en un espacio de baja dimensionalidad, la parametrización podría ayudar. Sin embargo, si tu tarea está en un espacio de alta dimensionalidad tal como el reconocimiento de imágenes, es necesario tener solo «una» no-linealidad y la no-linealidad monotónica funcionará mejor.
  > En resumen, puedes parametrizar cualquier función que desees pero no te dará una ventaja tan grande.

<!--
### Kink related questions
-->


### Preguntas respecto a los puntos no diferenciables

<!--- One kink versus double kink
-->

- Un punto no diferenciable versus dos puntos no diferenciables

<!--  > Double kink is a built-in scale in it. This means that if the input layer is multiplied by two (or the signal amplitude is multiplied by two), then outputs will be completely different. The signal will be more in nonlinearity, thus you will get a completely different behaviour of the output. Whereas, if you have a function with only one kink, if you multiply the input by two, then your output will be also multiplied by two.
-->

  > Double kink is a built-in scale in it. Esto significa que si la capa de entrada se multiplica por dos (o si la amplitud de la señal se multiplica por dos), entonces las salidas serán completamente distintas. La señal tendrá una no-linealidad mayor, y por tanto tendrás un comportamiento completamente distinto de la salida. Mientras que, si tienes una función con solo un punto no diferenciable, si multiplicas la salida por dos, entonces tu salida también será multiplicada por dos.

<!--- Differences between a nonlinear activation having kinks and a smooth nonlinear activation. Why/when one of them is preferred?
-->

- Diferencias entre una activación no-lineal con puntos no diferenciables y una activación no-lineal suave. ¿Por qué/cuando es preferible alguna de ellas?

<!--  > It is a matter of scale equivariance. If kink is hard, you multiply the input by two and the output is multiplied by two. If you have a smooth transition, for example, if you multiply the input by 100, the output looks like you have a hard kink because the smooth part is shrunk by a factor of 100. If you divide the input by 100, the kink becomes a very smooth convex function. Thus, by changing the scale of the input, you change the behaviour of the activation unit.
-->

  > Es un asunto de equivarianza de escala. Si tienes un punto no diferenciable duro, al multiplicar la entrada por dos, la salida se multiplica por dos. Si tienes una transición suave, por ejemplo, al multiplicar la entrada por 100, la salida luce como si tuvieras un punto no diferenciable duro ya que la parte suave se encoge por un factor de 100. Si divides la entrada por 100, el punto no diferenciable se convierte en una función convexa muy suave. Así, al cambiar la escala de la entrada, cambias el comportamiento de la unidad de activación.

<!--  > Sometimes this could be a problem. For example, when you train a multi-layer neural net and you have two layers that are one after the other. You do not have a good control for how big the weights of one layer is relative to the other layer's weights. If you have nonlinearity that cares about scales, your network doesn't have a choice of what size of weight matrix can be used in the first layer because this will completely change the behaviour.
-->

  > Algunas veces esto podría ser un problema. Por ejemplo, cuando entrenas una red neuronal multicapa y tienes dos capas que están una detrás de la otra. No tienes un buen control respecto a qué tan grandes son los pesos de una capa en relación con los pesos de la otra capa. Si tienes una no-linealidad a la que le importan las escalas, tu red no tiene elección respecto a qué tamaños de la matriz de pesos pueden usarse en la primera capa puesto que esto cambiará completamente su comportamiento.

<!--  > One way to fix this problem is setting a hard scale on the weights of every layer so you can normalise the weights of layers, such as batch normalisation. Thus, the variance that goes into a unit becomes always constant. If you fix the scale, then the system doesn't have any way of choosing which part of the nonlinearity will be using in two kink function systems. This could be a problem if this 'fixed' part becomes too 'linear'. For example, Sigmoid becomes almost linear near zero, and thus batch normalisation outputs (close to 0) could not be activated 'non-linearly'.
  >
  > It is not entirely clear why deep networks work better with single kink functions. It's probably due to the scale equivariance property.
-->

  > Una forma de arreglar este problema es colocar un escalado duro en los pesos de cada capa para que se puedan normalizar dichos pesos, como por ejemplo la normalización por lotes. Así, la varianza de los valores que entran en cada unidad se mantiene constante. Si se mantiene fija la escala, entonces el sistema no tiene ninguna forma de escoger qué parte de la no-linearidad usar en funciones con dos puntos no diferenciables. Esto se podría volver un problema si la parte «fija» se vuelve muy «lineal». Por ejemplo, la Sigmoide se vuelve casi lineal cerca del cero, y por tanto las salidas de la normalización por lotes (cercanas a 0) no se pueden activar de forma «no-lineal».
  >
  > No es completamente claro el por qué las redes profundas funcionan mejor con funciones con un solo punto no diferenciable. Probablemente se deba a la propiedad de equivarianza de escala.

<!--
### Temperature coefficient in a soft(arg)max function
-->


### El coeficiente de temperatura en una función soft(arg)max.

<!--- When do we use the temperature coefficient and why do we use it?
-->

- ¿Cuándo usamos el coeficiente de temperatura y por qué lo usamos?

<!--  > To some extent, the temperature is redundant with incoming weights. If you have weighted sums coming into your softmax, the $\beta$ parameter is redundant with the size of weights.
-->

  > Hasta cierto punto, la temperatura es redundante con los pesos que entran. Si tienes sumas ponderadas entrando a tu función softmax, el parámetro $\beta$ es redundante con el tamaño de los pesos.

<!--  > Temperature controls how hard the distribution of output will be. When $\beta$ is very large, it becomes very close to either one or zero. When $\beta$ is small, it is softer. When the limit of $\beta$ equals to zero, it is like an average. When $\beta$ goes infinity, it behaves like argmax. It's no longer its soft version. Thus, if you have some sort of normalisation before the softmax then, tuning this parameter allows you to control the hardness.
  > Sometimes, you can start with a small $\beta$ so that you can have well-behaved gradient descents and then, as running proceeds, if you want a harder decision in your attention mechanism, you increase $\beta$. Thus, you can sharpen the decisions. This trick is called as annealing. It can be useful for a mixture of experts like a self attention mechanism.
-->

  > La temperatura controla qué tan dura será la distribución de la salida. Cuando $\beta$ es muy grande, se vuelve muy cercana a uno o a zero. Cuando $\beta$ es pequeño, es más suave. Cuando el límite de $\beta$ es igual a cero, se comporta como un promedio. Cuando $\beta$ tiende a infinito, se comporta como argmax. Deja de ser su versión suave. Entonces, si tienes algún tipo de normalización antes de la softmax, ajustar este parámetro te permite controlar la dureza.
  > A veces, puedes empezar con un $\beta$ pequeño para que puedas tener descensos de gradiente con buen comportamiento y, a menuda que se hace la ejecución, si quieres unas decisiones más duras en tu mecanismo de atención, incrementas $\beta$.  Así, puedes hacer decisiones más séveras. Este truco se conoce como enfriamiento. Puede ser útil para mezclas de expertos como un mecanismo de auto-atención.

<!--
## [Loss functions](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=1990s)
-->


## [Funciones de costo](https://www.youtube.com/watch?v=bj1fh3BvqSU&t=15s)

<!--PyTorch also has a lot of loss functions implemented. Here we will go through some of them.
-->

PyTorch también tiene muchas funciones de costo implementadas. Revisaremos algunas de ellas.

<!--
### `nn.MSELoss()`
-->


### `nn.MSELoss()`

<!--This function gives the mean squared error (squared L2 norm) between each element in the input $x$ and target $y$. It is also called L2 loss.
-->

Esta función devuelve el error cuadrático medio (norma L2 al cuadrado) entre cada elemento de la entrada $x$ y el objetivo $y$. También se conoce como función de costo L2.

<!--If we are using a minibatch of $n$ samples, then there are $n$ losses, one for each sample in the batch. We can tell the loss function to keep that loss as a vector or to reduce it.
-->

Si estamos usando un mini-lote de $n$ muestras, entonces hay $n$ costos, uno para cada muestra en el lote. Podemos decirle a la función de costo que mantenga ese costo como un vector o que lo reduzca.

<!--If unreduced (*i.e.* set `reduction='none'`), the loss is
-->

Si no se reduce (es decir, se coloca `reduction='none”`), el costo es

<!--$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$
-->

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = (x_n - y_n)^2$$

<!--where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.
-->

donde $N$ es el tamaño del lote, $x$ y $y$ son tensores de formas arbitrarias con un total de n elementos cada uno.

<!--The reduction options are below (note that the default value is `reduction='mean'`).
-->

Las opciones de reducción están debajo (recuerda que el valor por defecto es `reduction='mean'`).

<!--$$l(x,y) = \begin{cases}\text{mean}(L), \quad &\text{if reduction='mean'}\\
\text{sum}(L), \quad &\text{if reduction='sum'}
\end{cases}$$
-->

$$l(x,y) = \begin{cases}\text{media}(L), \quad &\text{si reduction='mean'}\\
\text{suma}(L), \quad &\text{si reduction='sum'}
\end{cases}$$

<!--The sum operation still operates over all the elements, and divides by $n$.
-->

La operación de suma opera sobre todos los elementos y divide por $n$.

<!--The division by $n$ can be avoided if one sets ``reduction = 'sum'``.
-->

La división por $n$ se puede evitar si se coloca ``reduction = 'sum'``.

<!--
### `nn.L1Loss()`
-->


### `nn.L1Loss()`

<!--This measures the mean absolute error (MAE) between each element in the input $x$ and target $y$ (or the actual output and desired output).
-->

Esta función mide el error absoluto medio (MAE, por sus siglas en inglés) entre cada elemento de la entrada $x$ y el objetivo $y$ (o la salida obtenida y la salida deseada).

<!--If unreduced (*i.e.* set `reduction='none'`), the loss is
-->

Si no se reduce (es decir, se coloca `reduction='none”`), el costo es

<!--$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$
-->

$$l(x,y) = L = \{l_1, \dots, l_N\}^\top, l_n = \vert x_n - y_n\vert$$

<!--, where $N$ is the batch size, $x$ and $y$ are tensors of arbitrary shapes with a total of n elements each.
-->

donde $N$ es el tamaño del lote, $x$ y $y$ son tensores de formas arbitrarias con un total de n elementos cada uno.

<!--It also has `reduction` option of `'mean'` and `'sum'` similar to what `nn.MSELoss()` have.
-->

También tiene las opciones de `reduction` `'mean'` y `'sum'` similar a las que tiene `nn.MSELoss()`.

<!--**Use Case:** L1 loss is more robust against outliers and noise compared to L2 loss. In L2, the errors of those outlier/noisy points are squared, so the cost function gets very sensitive to outliers.
-->

**Caso de uso:** La función de costo L1 es más robusta contra valores atípicos y ruido en comparación con la función de costo L2. En la L2, los errores de los puntos atípicos o ruidosos se elevan al cuadrado, así que la función de costo se vuelve muy sensible a dichos puntos.

<!--**Problem:** The L1 loss is not differentiable at the bottom (0). We need to be careful when handling its gradients (namely Softshrink). This motivates the following SmoothL1Loss.
-->

**Problem:** La función de costo L1 no es diferenciable al fondo (0). Tenemos que tener cuidado al manejar sus gradientes (es decir, Encogimiento suave). Esto motiva la siguiente función de costo L1 suave:

<!--
### `nn.SmoothL1Loss()`
-->


### `nn.L1Loss()`

<!--This function uses L2 loss if the absolute element-wise error falls below 1 and L1 loss otherwise.
-->

Esta función usa la función de costo L2 si el error absoluto por elemento está por debajo de 1 y la L1 en caso contrario.

<!--$$\text{loss}(x, y) = \frac{1}{n} \sum_i z_i$$
, where $z_i$ is given by
-->

$$\text{costo}(x, y) = \frac{1}{n} \sum_i z_i$$
, donde $z_i$ está dado por

<!--$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{if } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{otherwise}
\end{cases}$$
-->

$$z_i = \begin{cases}0.5(x_i-y_i)^2, \quad &\text{si } |x_i - y_i| < 1\\
|x_i - y_i| - 0.5, \quad &\text{en otro caso}
\end{cases}$$

<!--It also has `reduction` options.
-->

También tiene opciones de `reduction`.

<!--This is advertised by Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). The Smooth L1 Loss is also known as the Huber Loss or  the Elastic Network when used as an objective function,.
-->

Esto es promovido por Ross Girshick ([Fast R-CNN](https://arxiv.org/abs/1504.08083)). La función de costo L1 suave es también conocida como la función de costo Huber o la Red Elástica cuando se usa como función objetivo.

<!--**Use Case:** It is less sensitive to outliers than the `MSELoss` and is smooth at the bottom. This function is often used in computer vision for protecting against outliers.
-->

**Caso de uso:** Es menos sensible a valores atípicos que la `MSELoss` y es suave al fondo. Esta función a menudo se usa en visión por computador para resguardarse de valores atípicos.

<!--**Problem:** This function has a scale ($0.5$ in the function above).
-->

**Problema:** La función tiene una escala ($0.5$ en la función de arriba).

<!--
### L1 *vs.* L2 for Computer Vision
-->


### L1 *vs.* L2 para Visión por Computador

<!--In making predictions when we have a lot of different $y$'s:
-->

Al hacer predicción cuando tenemos muchos $y$'s diferentes:

<!--* If we use MSE (L2 Loss), it results in an average of all $y$, which in CV it means we will have a blurry image.
* If we use L1 loss, the value $y$ that minimize the L1 distance is the medium, which is not blurry, but note that medium is difficult to define in multiple dimensions.
-->

* Si usamos el MSE (función de costo L2), resulta en un promedio de todos los $y$, lo que en Visión por Computador significa que tendremos una imagen borrosa.
* Si usamos la función de costo L1, el valor de $y$ que minimiza la distancia L1 es el medio, que no es borroso, pero recuerda que el medio es difícil de definir en múltiples dimensiones.

<!--Using L1 results in sharper image for prediction.
-->

Usar la L1 resulta en imágenes más nítidas al predecir.

<!--
### `nn.NLLLoss()`
-->


### `nn.NLLLoss()`

<!--It is the negative log likelihood loss used when training a classification problem with C classes.
-->

La función de costo de log-verosimilitud negativa es la que se usa en problemas de clasificación con C clases.

<!--Note that, mathematically, the input of `NLLLoss` should be (log) likelihoods, but PyTorch doesn't enforce that. So the effect is to make the desired component as large as possible.
-->

Es importante resaltar que, matemáticamente, la entrada de la `NLLLoss` deberían ser log-verosimilitudes, pero PyTorch no verifica eso. Así que el efecto es hacer que el componente deseado sea tan grande como sea posible.

<!--The unreduced (*i.e.* with :attr:`reduction` set to ``'none'``) loss can be described as:
-->

La función de costo sin reducir  (es decir, con el :attr:`reduction` puesto en ``'none”``) se puede describir así: 

<!--$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{weight}[c] \cdot \mathbb{1}\{c \not= \text{ignore\_index}\}$$
-->

$$\ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
        l_n = - w_{y_n} x_{n,y_n}, \quad
        w_{c} = \text{peso}[c] \cdot \mathbb{1}\{c \not= \text{ignorar\_indice}\}$$

<!--,where $N$ is the batch size.
-->

, donde $N$ es el tamaño de lote.

<!--If `reduction` is not ``'none'`` (default ``'mean'``), then
-->

Si `reduction` no es ``'none'`` (por defecto es ``'mean'``), entonces

<!--$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{if reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{if reduction} = \text{'sum'.}
        \end{cases}$$
-->

$$\ell(x, y) = \begin{cases}
            \sum_{n=1}^N \frac{1}{\sum_{n=1}^N w_{y_n}} l_n, &
            \text{si reduction} = \text{'mean';}\\
            \sum_{n=1}^N l_n,  &
            \text{si reduction} = \text{'sum'.}
        \end{cases}$$

<!--This loss function has an optional argument `weight` that can be passed in using a 1D Tensor assigning weight to each of the classes. This is useful when dealing with imbalanced training set.
-->

Esta función de costo tiene un argumento opcional `weight` que puede ser enviado usando un Tensor en 1D en el que se le asigna un peso a cada una de las clases. Esto es útil cuando se trabaja con un conjunto de entrenamiento desbalanceado.

<!--
#### Weights & Imbalanced Classes:
-->


#### Pesos y Clases Desbalanceadas:

<!--Weight vector is useful if the frequency is different for each category/class. For example, the frequency of the common flu is much higher than the lung cancer. We can simply increase the weight for categories that has small number of samples.
-->

El vector de pesos es útil si la frecuencia es diferente para cada categoría/clase. Por ejemplo, la frecuencia de la gripe común es mucho más alta que la del cáncer de pulmón. Entonces podemos simplemente incrementar el peso para las categorías que tienen un pequeño número de muestras.

<!--However, instead of setting the weight, it's better to equalize the frequency in training so that we can exploits stochastic gradients better.
-->

Sin embargo, en vez de poner un peso, es mejor ecualizar la frecuencia durante el entrenamiento para que podamos aprovechar mejor los gradientes estocásticos. 

<!--To equalize the classes in training, we put samples of each class in a different buffer. Then generate each minibatch by picking the same number samples from each buffer. When the smaller buffer runs out of samples to use, we iterate through the smaller buffer from the beginning again until every sample of the larger class is used. This way gives us equal frequency for all categories by going through those circular buffers. We should never go the easy way to equalize frequency by **not** using all samples in the majority class. Don't leave data on the floor!
-->

Para ecualizar las clases en el entrenamiento, ponemos muestras de cada clase en un buffer distinto.  Entonces generamos cada mini-lote escogiendo el mismo número de muestras de cada buffer. Cuando el buffer pequeño se queda sin muestras, volvemos a iterar recorriéndolo desde el principio de nuevo hasta que se usen todas las muestras de la clase más grande. Esto nos da una frecuencia igual para todas las categorías al recorrer estos buffers circulares. Nunca deberíamos ir a la fácil ecualizando la frecuencia al **no** usar todas las muestras de la clase mayoritaria. ¡No dejes datos en el piso!

<!--An obvious problem of the above method is that our NN model wouldn't know the relative frequency of the actual samples. To solve that, we fine-tune the system by running a few epochs at the end with the actual class frequency, so that the system adapts to the biases at the output layer to favour things that are more frequent.
-->

Un problema obvio del método mencionado arriba es que nuestro modelo de red neuronal no conocería la frecuencia relativa real de las muestras. Para resolver esto, afinamos el sistema corriendo unas cuantas épocas al final con la frecuencia de clases real, para que el sistema se adapte a los sesgos en su capa de salida y favorezca cosas que son más frecuentes.

<!--To get an intuition of this scheme, let's go back to the medical school example: students spend just as much time on rare disease as they do on frequent diseases (or maybe even more time, since the rare diseases are often the more complex ones). They learn to adapt to the features of all of them, then correct it to know which are rare.
-->

Para imaginar como funciona este esquema, volvamos al ejemplo de las clases de medicina: los estudiantes gastan tanto tiempo en enfermedades raras como en las frecuentse (o incluso más, pues las enfermedades raras a menudo son las más complejas). Ellos aprenden a adaptarse a las características de toda las enfermedades y entonces se corrigen para saber cuales son raras.

<!--
### `nn.CrossEntropyLoss()`
-->


### `nn.CrossEntropyLoss()`

<!--This function combines `nn.LogSoftmax` and `nn.NLLLoss` in one single class. The combination of the two makes the score of the correct class as large as possible.
-->

Esta función combina `nn.LogSoftmax` y `nn.LLLoss` en una sola clase. La combinación de las dos hace que el puntaje de la clase correcta sea tan grande como sea posible.

<!--The reason why the two functions are merged here is for numerical stability of gradient computation. When the value after softmax is close to 1 or 0, the log of that can get close to 0 or $-\infty$. Slope of log close to 0 is close to $\infty$, causing the intermediate step in backpropagation to have numerical issues. When the two functions are combined, the gradients is saturated so we get a reasonable number at the end.
-->

La razón por la que las dos funciones se combinan es por la estabilidad numérica del cómputo del gradiente. Cuando el valor que sale de la softmax es muy cercano a 1 o 0, el logarítmo de dicho valor puede estar muy cerca de 0 o de $\-infty$. La pendiente del logarítmo cerca de 0 tiende a $\infty$, lo que causa que el paso intermedio en la propagación hacía atrás tenga problemas numéricos. Cuando se combinan ambas funciones, se satura el gradiente y se obtiene un número razonable al final.

<!--The input is expected to be unnormalised score for each class.
-->

La entrada esperada es el puntaje sin normalizar para cada clase.

<!--The loss can be described as:
-->

Esta función de costo se puede describir como:

<!--$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$
-->

$$\text{loss}(x, c) = -\log\left(\frac{\exp(x[c])}{\sum_j \exp(x[j])}\right)
= -x[c] + \log\left(\sum_j \exp(x[j])\right)$$

<!--or in the case of the `weight` argument being specified:
-->

o en caso de que se especifique el argumento `weight`:

<!--$$\text{loss}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$
-->

$$\text{costo}(x, c) = w[c] \left(-x[c] + \log\left(\sum_j\exp(x[j])\right)\right)$$

<!--The losses are averaged across observations for each minibatch.
-->

Los costos se promedían entre todas las observaciones para cada mini-lote.

<!--A physical interpretation of the Cross Entropy Loss is related to the Kullback–Leibler divergence (KL divergence), where we are measuring the divergence between two distributions. Here, the (quasi) distributions are represented by the x vector (predictions) and the target distribution (a one-hot vector with 0 on the wrong classes and 1 on the right class).
-->

Una interpretación física de la función de costo de entropía cruzada se relaciona con la divergencia Kullback–Leibler (divergencia KL), donde se mide la divergencia entre las dos distribuciones. Aquí, las (quasi) distribuciones se representan por el vector x (predicciones) y la distribución objetivo (un vector one-hot con 0 en las clases equivocadas y 1 en la clase correcta).

<!--Mathematically,
-->

Matemáticamente,

<!--$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$
-->

$$H(p,q) = H(p) + \mathcal{D}_{KL} (p \mid\mid q)$$

<!--where $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ is the cross-entropy (between two distributions), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ is the entropy, and $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ is the KL divergence.
-->

donde $$H(p,q) = - \sum_i p(x_i) \log (q(x_i))$$ es la entropía-cruzada (entre dos distribuciones), $$H(p) = - \sum_i p(x_i) \log (p(x_i))$$ es la entropía, y $$\mathcal{D}_{KL} (p \mid\mid q) = \sum_i p(x_i) \log \frac{p(x_i)}{q(x_i)}$$ es la divergencia KL.

<!--### `nn.AdaptiveLogSoftmaxWithLoss()`
-->

### `nn.AdaptiveLogSoftmaxWithLoss()`

<!--This is an efficient softmax approximation of softmax for large number of classes (for example, millions of classes). It implements tricks to improve the speed of the computation.
-->

Esta es una aproximación eficiente de la función softmax para grandes cantidades de clases (por ejemplo, millones de clases) Esta función implementa trucos para mejorar la velocidad de cómputo.

<!--Details of the method is described in [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) by Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou.
-->

Los detalles del método se describen en [Efficient softmax approximation for GPUs](https://arxiv.org/abs/1609.04309) por Edouard Grave, Armand Joulin, Moustapha Cissé, David Grangier, Hervé Jégou.
