---
lang-ref: ch.10-2
title: Aprendizaje auto-supervisado - ClusterFit y ARPI
lecturer: Ishan Misra
authors: Zhonghui Hu, Yuqing Wang, Alfred Ajay Aureate Rajakumar, Param Shah
date: 6 Apr 2020
lang: es
translation-date: 20 Sep 2020
translator: tiagogiraldo
---


<!--### [What is missing from "pretext" tasks? The hope of generalization](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)-->
###[¿Qué falta en las tareas de "pretexto"? La esperanza de la generalización](https://www.youtube.com/watch?v=0KeR6i1_56g&t=3710s)

<!--Pretext task generally comprises of pretraining steps which is self-supervised and then we have our transfer tasks which are often classification or detection. We *hope* that the pretraining task and the transfer tasks are "aligned", meaning, solving the pretext task will help solve the transfer tasks very well. So, a lot of research goes into designing a pretext task and implementing them really well.-->
La tarea de pretexto generalmente comprende pasos de preentrenamiento que se auto-supervisan y luego tenemos nuestras tareas de transferencia que a menudo son de clasificación o detección. *Esperamos* que la tarea de preentrenamiento y las tareas de transferencia estén "alineadas", es decir, resolver la tarea de pretexto ayudará a resolver las tareas de transferencia muy bien. Por lo tanto, se investiga mucho en el diseño de una tarea pretexto e implementarla muy bien.

<!--However, it is very unclear why performing a non-semantic task should produce good features?. For example, why should we expect to learn about “semantics” while solving something like Jigsaw puzzle? Or why should “predicting hashtags” from images be expected to help in learning a classifier on transfer tasks? Therefore, the question remains. How should we design good pre-training tasks which are well aligned with the transfer tasks?-->
Sin embargo, no está muy claro por qué la realización de una tarea no semántica debe producir buenas características... Por ejemplo, ¿por qué deberíamos esperar aprender sobre "semántica" mientras resolvemos algo como un rompecabezas? ¿O por qué se espera que "predecir hashtags" a partir de imágenes ayude a aprender un clasificador en tareas de transferencia? Por lo tanto, la pregunta sigue siendo: ¿Cómo deberíamos diseñar buenas tareas de pre-entrenamiento que estén bien alineadas con las tareas de transferencia?

<!--One way to evaluate this problem is by looking at representations at each layer (refer Fig. 1). If the representations from the last layer are not well aligned with the transfer task, then the pretraining task may not be the right task to solve.-->
Una forma de evaluar este problema es mirando las representaciones en cada capa (ver Fig. 1). Si las representaciones de la última capa no están bien alineadas con la tarea de transferencia, entonces la tarea de preentrenamiento puede no ser la tarea correcta a resolver.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig01.png" height="75%" width="75%"/><br>
<b>Fig. 1</b>: <!--Feature representations at each layer-->Las representaciones de las características en cada capa
</center>

<!--Fig. 2 plots the Mean Average Precision at each layer for Linear Classifiers on VOC07 using Jigsaw Pretraining. It is clear that the last layer is very specialized for the Jigsaw problem.-->

La Fig. 2 muestra la Media de Precisión Promedio en cada capa para los Clasificadores Lineales en el VOC07 usando el Preentrenamiento del Rompecabezas. Está claro que la última capa es muy especializada para el problema del rompecabezas.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig02.png" height="70%" width="80%"/><br>
<b>Fig. 2</b>: <!--Performance of Jigsaw based on each layer-->Desempeño del rompecabezas basado en cada capa
</center>


<!--### What we want from pre-trained features?-->
###¿Qué queremos de las características pre-entrenadas?

<!--* Represent how images relate to one another-->
* Representar cómo se relacionan las imágenes unas con otras

<!--  * ClusterFit: Improving Generalization of Visual Representations-->
  * ClusterFit: Mejorar la generalización de las representaciones visuales
  
<!--* Be robust to "nuisance factors" -- Invariance-->
* Ser robusto a los "factores de perturbación" -- Invariancia

<!--  *E.g.* exact location of objects, lighting, exact colour-->
  *P.ej.* la ubicación exacta de los objetos, la iluminación, el color exacto

<!--  * PIRL: Self-supervised learning of Pre-text Invariant Representations-->
  * ARIP: Aprendizaje auto-supervisado de Representaciones Invariantes de Pretexto

<!--Two ways to achieve the above properties are **Clustering** and **Contrastive Learning**. They have started performing much better than whatever pretext tasks that were designed so far.  One method that belongs to clustering is **ClusterFit** and another falling into invariance is **PIRL**.-->

Dos formas de lograr las propiedades anteriores son **Agrupamiento** y **Aprendizaje Constrastivo**. Estos métodos han comenzado a desempeñarse mucho mejor que las tareas de pretexto que se diseñaron hasta ahora. Un método que pertenece a la agrupación en clústeres es **ClusterFit** y otro que cae en invariancia es **ARIP**.


<!--## ClusterFit: Improving Generalization of Visual Representations-->
## ClusterFit: Mejorando la generalización de las representaciones visuales

<!--Clustering the feature space is a way to see what images relate to one another.-->
Agrupar el espacio de características es una forma de ver qué imágenes se relacionan entre sí.

<!--### Method-->
### Método

<!--ClusterFit follows two steps.  One is the cluster step, and the other is the predict step.-->
ClusterFit sigue dos pasos.  Uno es el paso del clúster, y el otro es el paso de la predicción.

<!--#### Cluster: Feature Clustering-->
#### Clúster: Agrupamiento de características

<!--We take a pretrained network and use it to extract a bunch of features from a set of images. The network can be any kind of pretrained network. K-means clustering is then performed on these features, so each image belongs to a cluster, which becomes its label.-->
Tomamos una red preentrenada y la usamos para extraer un montón de características de un conjunto de imágenes. La red puede ser cualquier tipo de red preentrenada. El agrupamiento de K-medias se realiza entonces sobre estos rasgos, así que cada imagen pertenece a un cluster, que se convierte en su etiqueta.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig03.png"
height="75%" width="75%" /><br>
<b>Fig. 3</b>: <!--Cluster step-->Paso del clúster
</center>


<!--#### Fit: Predict Cluster Assignment-->

#### Ajuste: Predecir la asignación del clúster

<!--For this step, we train a network from scratch to predict the pseudo labels of images. These pseudo labels are what we obtained in the first step through clustering.-->

Para este paso, entrenamos una red desde cero para predecir las pseudo etiquetas de las imágenes. Estas pseudo etiquetas son las que obtuvimos en el primer paso a través de la agrupamiento.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig04.png"
height="75%" width="75%"/><br>
<b>Fig. 4</b>: <!--Predict step-->Paso de Predicción
</center>

<!--A standard pretrain and transfer task first pretrains a network and then evaluates it in downstream tasks, as it is shown in the first row of Fig. 5. ClusterFit performs the pretraining on a dataset $D_{cf}$ to get the pretrained network $N_{pre}$. The pretrained network $N_{pre}$ are performed on dataset $D_{cf}$ to generate clusters. We then learn a new network $N_{cf}$from scratch on this data. Finally, use $N_{cf}$ for all downstream tasks.-->

Una tarea estándar de preentrenamiento y de transferencia primero preentrena una red y luego la evalúa en tareas posteriores, como se muestra en la primera fila de la Fig. 5. ClusterFit aplica el preentrenamiento sobre un conjunto de datos $D_{cf}$ para obtener la red preentrenada $N_{pre}$. Esta red $N_{pre}$ se aplica sobre el conjunto de datos $D_{cf}$ para generar clústeres. Luego aprendemos una nueva red $N_{cf}$ a partir de estos datos. Por último, se usa $N_{cf}$ para todas las tareas posteriores.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig05.png"
height="75%" width="75%"/><br>
<b>Fig. 5</b>: <!--"Standard" pretrain + transfer *vs.* "Standard" pretrain + ClusterFit-->Preentrenamiento "Estándar" + "Transferencia" *vs.* Preentrenamiento "Estándar" + ClusterFit
</center>


<!--### Why ClusterFit Works-->
### ¿Por qué ClusterFit funciona?

<!--The reason why ClusterFit works is that in the clustering step only the essential information is captured, and artefacts are thrown away making the second network learn something slightly more generic.-->

La razón por la que ClusterFit funciona es que en el paso de agrupación sólo captura la información esencial, y los artefactos se sacan haciendo que la segunda red aprenda algo ligeramente más genérico.

<!--To understand this point, a fairly simple experiment is performed.  We add label noise to ImageNet-1K, and train a network based on this dataset. Then, we evaluate the feature representation from this network on a downstream task on ImageNet-9K. As it is shown in Fig. 6, we add different amounts of label noise to the ImageNet-1K, and evaluate the transfer performance of different methods on ImageNet-9K.-->

Para entender este punto, se realiza un experimento sencillo.  Añadimos ruido de etiqueta a ImageNet-1K, y entrenamos una red basada en este conjunto de datos. Luego, evaluamos la representación de las características de esta red en una tarea posterior en ImageNet-9K. Como se muestra en la Fig. 6, añadimos diferentes cantidades de ruido de etiqueta a ImageNet-1K, y evaluamos el desempeño de la transferencia de diferentes métodos en ImageNet-9K.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig06.png"
height="50%" width="50%"/>
<br><b>Fig. 6</b>: <!--Control Experiment-->Experimento de Control
</center>

<!--The pink line shows the performance of pretrained network, which decreases as the amount of label noise increases. The blue line represents model distillation where we take the initial network and use it to generate labels. Distillation generally performs better than pretrained network.  The green line, ClusterFit, is consistently better than either of these methods. This result validates our hypothesis.-->

La línea rosada muestra el rendimiento de la red preentrenada, que disminuye a medida que aumenta la cantidad de ruido de la etiqueta. La línea azul representa la destilación del modelo donde tomamos la red inicial y la usamos para generar etiquetas. La destilación generalmente tiene un mejor rendimiento que la red preentrenada.  La línea verde, ClusterFit, es consistentemente mejor que cualquiera de estos métodos. Este resultado valida nuestra hipótesis.

<!--* Question: Why use distillation method to compare. What's the difference between distillation and ClusterFit?-->
* Pregunta: ¿Por qué usar el método de destilación para comparar? ¿Cuál es la diferencia entre la destilación y ClusterFit?

<!--In model distillation we take the pre-trained network and use the labels the network predicted in a softer fashion to generate labels for our images. For example, we get a distribution over all the classes and use this distribution to train the second network. The softer distribution helps enhance the initial classes that we have. In ClusterFit we don't care about the label space.-->

En la destilación del modelo tomamos la red pre-entrenada y usamos las etiquetas que la red predijo de una manera más ligera para generar etiquetas para nuestras imágenes. Por ejemplo, obtenemos una distribución en todas las clases y usamos esta distribución para entrenar la segunda red. La distribución más ligera ayuda a mejorar las clases iniciales que tenemos. En ClusterFit no nos importa el espacio de la etiqueta.

<!--### Performance-->Rendimiento

<!--We apply this method to self-supervised learning. Here Jigsaw is applied to obtain the pretrained network $N_{pre}$ in ClusterFit. From Fig. 7 we see that the transfer performance on different datasets shows a surprising amount of gains, compared to other self-supervised methods.-->

Aplicamos este método al aprendizaje auto-supervisado. Aquí el rompecabezas se aplica para obtener la red preentrenada $N_{pre}$ en el ClusterFit. En la Fig. 7 vemos que el desempeño de la transferencia en diferentes conjuntos de datos muestra una sorprendente cantidad de ganancias, en comparación con otros métodos auto-supervisados.+

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig07.png"
height="70%" width="70%"/><br><b>Fig. 7</b>: <!--Transfer performance on different datasets-->Rendimiento de transferencia sobre diferentes conjuntos de datos
</center>

<!--ClusterFit works for any pre-trained network. Gains without extra data, labels or changes in architecture can be seen in Fig. 8. So in some way, we can think of the ClusterFit as a self-supervised fine-tuning step, which improves the quality of representation.-->

ClusterFit funciona para cualquier red pre-entrenada. Las ganancias sin datos extra, etiquetas o cambios en la arquitectura pueden verse en la Fig. 8. Así que de alguna manera, podemos pensar en ClusterFit como un paso de afinación auto-supervisado, que mejora la calidad de la representación.
<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig08.png"
height="70%" width="70%"/><br><b>Fig. 8</b>: <!--Gains without extra data, labels or changes in architecture-->Ganancias sin datos extra, etiquetas o cambios en la arquitectura
</center>


<!--## [Self-supervised Learning of Pretext Invariant Representations (PIRL)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)-->
[Aprendizaje auto-supervisado de Representaciones Invariantes de Pretexto (ARIP)]https://www.youtube.com/watch?v=0KeR6i1_56g&t=4748s)

<!--### Contrastive Learning-->
### Aprendizaje Contrastivo

<!--Contrastive learning is basically a general framework that tries to learn a feature space that can combine together or put together points that are related and push apart points that are not related.-->

El aprendizaje contrastivo es básicamente un marco general que trata de aprender un espacio de características que puede combinar o juntar puntos que están relacionados y separar puntos que no están relacionados.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig09.png"
height="20%" width="20%"/><br><b>Fig. 9</b>: <!--Groups of Related and Unrelated Images-->Grupos de Imágenes Relacionadas y No Relacionadas
</center>

<!--In this case, imagine like the blue boxes are the related points, the greens are related, and the purples are related points.-->

En este caso, imagina que las cajas azules son los puntos relacionados, los verdes están relacionados y los púrpuras son los puntos relacionados.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig10.png"
height="100%" width="100%"/><br><b>Fig. 10</b>: <!--Contrastive Learning and Loss Function-->Aprendizaje Contrastivo y Función de Pérdida
</center>

<!--Features for each of these data points would be extracted through a shared network, which is called Siamese Network to get a bunch of image features for each of these data points. Then a contrastive loss function is applied to try to minimize the distance between the blue points as opposed to, say, the distance between the blue point and the green point. Or the distance basically between the blue points should be less than the distance between the blue point and green point or the blue point and the purple point. So, embedding space from the related samples should be much closer than embedding space from the unrelated samples. So that's the general idea of what contrastive learning is and of course Yann was one of the first teachers to propose this method. So contrastive learning is now making a resurgence in self-supervised learning pretty much a lot of the self-supervised state of the art methods are really based on contrastive learning.-->

Las características de cada uno de estos puntos de datos se extraerían a través de una red compartida, que se llama Red Siamesa para obtener un montón de características de imagen para cada uno de estos puntos de datos. Luego se aplica una función de pérdida contrastiva para tratar de minimizar la distancia entre los puntos azules en contraposición a, digamos, la distancia entre el punto azul y el punto verde. O la distancia básicamente entre los puntos azules debería ser menor que la distancia entre el punto azul y el punto verde o el punto azul y el punto púrpura. Por lo tanto, el espacio de incrustación de las muestras relacionadas debería estar mucho más cerca que el espacio de incrustación de las muestras no relacionadas. Así que esa es la idea general de lo que es el aprendizaje contrastivo y por supuesto Yann fue uno de los primeros profesores en proponer este método. Así que el aprendizaje contrastivo está haciendo un resurgimiento en el aprendizaje auto-supervisado.


<!--### How to define related or unrelated?-->
### ¿Cómo definir lo relacionado o no relacionado?

<!--And the main question is how to define what is related and unrelated. In the case of supervised learning that's fairly clear all of the dog images are related images, and any image that is not a dog is basically an unrelated image. But it's not so clear how to define the relatedness and unrelatedness in this case of self-supervised learning. The other main difference from something like a pretext task is that contrastive learning really reasons a lot of data at once.  If you look at the loss function, it always involves multiple images. In the first row it involves basically the blue images and the green images and in the second row it involves the blue images and the purple images. But as if you look at a task like say Jigsaw or a task like rotation, you're always reasoning about a single image independently. So that's another difference with contrastive learning: contrastive learning reasons about multiple data points at once.-->

Y la cuestión principal es cómo definir lo que está relacionado y lo que no lo está. En el caso del aprendizaje supervisado que es bastante claro, todas las imágenes de perros son imágenes relacionadas, y cualquier imagen que no sea un perro es básicamente una imagen no relacionada. Pero no está tan claro cómo definir lo que está relacionado y lo que no lo está en este caso de aprendizaje auto-supervisado. La otra gran diferencia con algo como una tarea de pretexto es que el aprendizaje contrastado realmente razona muchos datos a la vez.  Si observas la función de pérdida, siempre implica múltiples imágenes. En la primera fila implica básicamente las imágenes azules y las imágenes verdes y en la segunda fila implica las imágenes azules y las imágenes púrpuras. Pero si miras una tarea como por ejemplo un rompecabezas o una tarea como la rotación, siempre estás razonando sobre una sola imagen de forma independiente. Así que esa es otra diferencia con el aprendizaje contrastivo: razones de aprendizaje contrastivo sobre múltiples puntos de datos a la vez.

<!--Similar techniques to what was discussed earlier could be used: frames of video or sequential nature of data. Frames that are nearby in a video are related and frames, say, from a different video or which are further away in time are unrelated. And that has formed the basis of a lot of self- supervised learning methods in this area. This method is called CPC, which is contrastive predictive coding, which relies on the sequential nature of a signal and it basically says that samples that are close by, like in the time-space, are related and samples that are further apart in the time-space are unrelated. A fairly large amount of work basically exploiting this: it can either be in the speech domain, video, text, or particular images. And recently, we've also been working on video and audio so basically saying a video and its corresponding audio are related samples and video and audio from a different video are basically unrelated samples.-->

Podrían utilizarse técnicas similares a las que se han examinado anteriormente: recuadros de vídeo o la naturaleza secuencial de los datos. Los recuadros que están cerca en un vídeo están relacionados y los recuadros, digamos, de un vídeo diferente o que están más lejos en el tiempo no están relacionados. Y eso ha formado la base de muchos métodos de aprendizaje auto-supervisados en esta área. Este método se llama CPC, que es una codificación predictiva contrastiva, que se basa en la naturaleza secuencial de una señal y básicamente dice que las muestras que están cerca, como en el espacio-tiempo, están relacionadas y las muestras que están más alejadas en el espacio-tiempo no están relacionadas. Una cantidad bastante grande de trabajo explota esto básicamente: puede ser en el dominio del habla, video, texto o imágenes particulares. Y recientemente, también hemos estado trabajando en vídeo y audio, así que básicamente decir que un vídeo y su correspondiente audio son muestras relacionadas y que el vídeo y el audio de un vídeo diferente son básicamente muestras no relacionadas.

<!--### Tracking Objects-->
### Seguimiento de objetos

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig11.png"
height="80%" width="80%"/><br><b>Fig. 11</b>: <!--Tracking the Objects-->Siguiendo los Objetos
</center>

<!--Some of the early work, like self-supervised learning, also uses this contrastive learning method and they really defined related examples fairly interestingly. You run a tracked object tracker over a video and that gives you a moving patch and what you say is that any patch that was tracked by the tracker is related to the original patch. Whereas, any patch from a different video is not a related patch. So that basically gives out these bunch of related and unrelated samples. In figure 11(c), you have this like distance notation. What this network tries to learn is basically that patches that are coming from the same video are related and patches that are coming from different videos are not related. In some way, it automatically learns about different poses of an object. It tries to group together a cycle, viewed from different viewing angles or different poses of a dog.-->

Algunos de los primeros trabajos, como el aprendizaje auto-supervisado, también utilizan este método de aprendizaje contrastivo y realmente definieron ejemplos relacionados de manera bastante interesante. Si pasas un rastreador de objetos seguidos por un vídeo y eso te da un parche en movimiento, lo que dices es que cualquier parche que haya sido seguido por el rastreador está relacionado con el parche original. En cambio, cualquier parche de un vídeo diferente no es un parche relacionado. Así que eso básicamente da un montón de muestras relacionadas y no relacionadas. En la figura 11(c), tienes esto como una notación de distancia. Lo que esta red intenta aprender es que los parches que provienen del mismo vídeo están relacionados y los parches que provienen de vídeos diferentes no están relacionados. De alguna manera, este aprende automáticamente sobre las diferentes poses de un objeto. Este trata de agruparlos un ciclo, visto desde diferentes ángulos de visión o diferentes poses de un perro.

<!--### Nearby patches *vs.* distant patches of an Image-->
### Parches cercanos *vs.* parches distantes de una imagen

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig12.png"
height="50%" width="50%"/><br><b>Fig. 12</b>: <!--Nearby patches *vs.* distant patches of an Image-->Parches cercanos *vs.* parches distantes de una imagen
</center>

<!--In general, talking about images, a lot of work is done on looking at nearby image patches versus distant patches, so most of the CPC v1 and CPC v2 methods are really exploiting this property of images. So image patches that are close are called as positives and image patches that are further apart are translated as negatives, and the goal is to minimize the contrastive loss using this definition of positives and negatives.-->

En general, hablando de imágenes, se trabaja mucho en la observación de parches de imágenes cercanas frente a parches distantes, por lo que la mayoría de los métodos CPC v1 y CPC v2 están realmente explotando esta propiedad de las imágenes. Así que los parches de imagen que están cerca se llaman positivos y los parches de imagen que están más alejados se traducen como negativos, y el objetivo es minimizar la pérdida contrastiva usando esta definición de positivos y negativos.


<!--### Patches of an image *vs.* patches of other images-->
### Patches of an image *vs.* patches of other images

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig13.png"
height="60%" width="60%"/><br><b>Fig. 13</b>: <!--Patches of an Image *vs.* Patches of Other Images-->Parches de una Imagen *vs.* Parches de Otras Imágenes
</center>

<!--The more popular or performant way of doing this is to look at patches coming from an image and contrast them with patches coming from a different image. This forms the basis of a lot of popular methods like instance discrimination, MoCo, PIRL, SimCLR. The idea is basically what's shown in the image. To go into more details, what these methods do is to extract completely random patches from an image. These patches can be overlapping, they can actually become contained within one another or they can be completely falling apart and then apply some data augmentation. In this case, say, a colour chattering or removing the colour or so on. And then these two patches are defined to be positive examples. Another patch is extracted from a different image. And this is again a random patch and that basically becomes your negatives. And a lot of these methods will extract a lot of negative patches and then they will basically perform contrastive learning. So there are relating two positive samples, but there are a lot of negative samples to do contrastive learning against.-->

La forma más popular o de mejor desempeño de hacer esto es mirar los parches que vienen de una imagen y contrastarlos con los parches que vienen de una imagen diferente. Esto forma la base de muchos métodos populares como la discriminación de instancia, MoCo, ARPI(o PIRL por siglas en inglés), SimCLR. La idea es básicamente lo que se está mostrando en la imagen. Para entrar en más detalles, lo que hacen estos métodos es extraer parches completamente aleatorios de una imagen. Estos parches pueden superponerse, pueden llegar a estar contenidos dentro de otro o pueden estar completamente separados y luego aplicar algún aumento de datos. En este caso, digamos, un color intermitente o quitando el color o así sucesivamente. Y entonces estos dos parches se definen como ejemplos positivos. Otro parche se extrae de una imagen diferente. Y este es de nuevo un parche al azar y eso básicamente se convierte en tus negativos. Y muchos de estos métodos extraerán muchos parches negativos y luego básicamente realizarán un aprendizaje contrastivo. Así que hay que relacionar dos muestras positivas, pero hay muchas muestras negativas contra las que hacer aprendizaje contrastivo.


<!--### Underlying Principle for Pretext Tasks-->
### Principio subyacente para las tareas de pretexto

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig14.png"
height="50%" width="50%"/><br><b>Fig. 14</b>: <!--Pretext Image Transform and Standard Pretext Learning-->Transformación de Imágenes de Pretexto y Aprendizaje de Pretexto Estándar
</center>

<!--Now moving to PIRL a little bit, and that's trying to understand what the main difference of pretext tasks is and how contrastive learning is very different from the pretext tasks. Again, pretext tasks always reason about a single image at once.  So the idea is that given an image your and prior transform to that image, in this case a Jigsaw transform, and then inputting this transformed image into a ConvNet and trying to predict the property of the transform that you applied to, the permutation that you applied or the rotation that you applied or the kind of colour that you removed and so on. So the pretext tasks always reason about a single image. And the second thing is that the task that you're performing in this case really has to capture some property of the transform. So it really needs to capture the exact permutation that are applied or the kind of rotation that are applied, which means that the last layer representations are actually going to go PIRL very a lot as the transform the changes and that is by design, because you're really trying to solve that pretext tasks. But unfortunately, what this means is that the last layer representations capture a very low-level property of the signal. They capture things like rotation or so on. Whereas what is designed or what is expected of these representations is that they are invariant to these things that it should be able to recognize a cat, no matter whether the cat is upright or that the cat is say,  bent towards like by 90 degrees. Whereas when you're solving that particular pretext task you're imposing the exact opposite thing. We're saying that we should be able to recognize whether this picture is upright or whether this picture is basically turning it sideways. There are many exceptions in which you really want these low-level representations to be covariant and a lot of it really has to do with the tasks that you're performing and quite a few tasks in 3D really want to be predictive. So you want to predict what camera transforms you have: you're looking at two views of the same object or so on. But unless you have that kind of a specific application for a lot of semantic tasks, you really want to be invariant to the transforms that are used to use that input.-->

Ahora pasamos a ARPI un poco, y eso es tratar de entender cuál es la principal diferencia de las tareas de pretexto y cómo el aprendizaje contrastivo es muy diferente de las tareas de pretexto. De nuevo, las tareas con pretexto siempre razonan sobre una sola imagen a la vez. Así que la idea es que dándole a una imagen su y previa transformación a esa imagen, en este caso una transformación de rompecabezas, y luego introduciendo esta imagen transformada en una ConvNet e intentando predecir la propiedad de la transformación que aplicaste, la permutación que aplicaste o la rotación que aplicaste o el tipo de color que removiste y así sucesivamente. Así que las tareas de pretexto siempre razonan sobre una sola imagen. Y la segunda cosa es que la tarea que estás realizando en este caso realmente tiene que capturar alguna propiedad de la transformación. Así que realmente tiene que capturar la permutación exacta que se aplican o el tipo de rotación que se aplican, lo que significa que las representaciones de la última capa van a ir mucho ARPI como la transformación de los cambios y eso es por diseño, porque realmente estás tratando de resolver las tareas de pretexto. Pero desafortunadamente, lo que esto significa es que las representaciones de la última capa capturan una propiedad de muy bajo nivel de la señal. Estas capturan cosas como la rotación o algo así. Mientras que lo que se diseña o lo que se espera de estas representaciones es que sean invarintes a estas cosas que debería ser capaz de reconocer un gato, no importa si el gato está en posición vertical o que el gato esté, digamos, inclinado como 90 grados. Mientras que cuando estás resolviendo esa tarea de pretexto particular se impone exactamente lo contrario. Estamos diciendo que deberíamos ser capaces de reconocer si esta imagen está en posición vertical o si esta imagen está básicamente girada hacia los lados. Hay muchas excepciones en las que realmente quieres que estas representaciones de bajo nivel sean covariantes y muchas de ellas tienen que ver con las tareas que estás realizando y bastantes tareas en 3D realmente quieren ser predictivas. Así que quieres predecir qué transformaciones de cámara tienes: estás viendo dos vistas del mismo objeto o algo así. Pero a menos que tengas ese tipo de aplicación específica para muchas tareas semánticas, realmente quieres ser invariante a las transformaciones que se utilizan para usar esa entrada.

<!--### How important has invariance been?-->
### ¿Qué importancia ha tenido la invarianza?

<!--Invariance has been the word course for feature learning. Something like SIFT, which is a fairly popular handcrafted feature where we inserted here is transferred invariant. And supervise networks, for example, supervised Alex nets, they're trained to be invariant data augmentation. You want this network to classify different crops or different rotations of this image as a tree, rather than ask it to predict what exactly was the transformation applied for the input.-->

La invariancia ha sido la palabra clave para el aprendizaje de las características. Algo como SIFT, que es un rasgo artesanal bastante popular donde insertamos aquí es transferido invariante. Y las redes de supervisión, por ejemplo, las redes de Alex supervisadas, están entrenadas para ser aumento de datos invariantes. Quieres que esta red clasifique diferentes cultivos o diferentes rotaciones de esta imagen como un árbol, en lugar de pedirle que prediga cuál fue exactamente la transformación aplicada para la entrada.

<!--### PIRL-->
### ARPI

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig15.png"
height="70%" width="70%"/><br><b>Fig. 15</b>: <!--PIRL-->ARPI
</center>

<!--This is what inspired PIRL. So PIRL stands for pretext invariant representation learning, where the idea is that you want the representation to be invariant or capture as little information as possible of the input transform. So you have the image, you have the transformed version of the image, you feed-forward both of these images through a ConvNet, you get a representation and then you basically encourage these representations to be similar. In terms of the notation referred earlier, the image $I$ and any pretext transformed version of this image $I^t$ are related samples and any other image is underrated samples. So in this way when you frame this network, representation hopefully contains very little information about this transform $t$. And assume you are using contrastive learning. So the contrastive learning part is basically you have the saved feature $v_I$ coming from the original image $I$ and you have the feature $v_{I^t}$ coming from the transform version and you want both of these representations to be the same. And the book paper we looked at is two different states of the art of the pretext transforms, which is the jigsaw and the rotation method discussed earlier. In some way, this is like multitask learning, but just not really trying to predict both designed rotation. You're trying to be invariant of Jigsaw rotation.-->

Esto es lo que inspiró a ARPI. Así que ARPI significa aprendizaje de representación de pretexto invariante, donde la idea es que quieres que la representación sea invariante o capturar la menor información posible de la transformación de entrada. Así que tienes la imagen, tienes la versión transformada de la imagen, alimentas ambas imágenes a través de una ConvNet, obtienes una representación y luego básicamente fomentas que estas representaciones sean similares. En términos de la notación mencionada anteriormente, la imagen $I$ y cualquier versión transformada del pretexto de esta imagen $I^t$ son muestras relacionadas y cualquier otra imagen son muestras infravaloradas. Así que de esta manera, cuando enmarcas esta red, la representación contiene con suerte muy poca información sobre esta transformación $t$. Y supongan que están usando aprendizaje contrastivo. Así que la parte de aprendizaje contrastivo es básicamente que tienes la característica guardada $v_I$ que viene de la imagen original $I$ y tienes la característica $v_{I^t}$ que viene de la versión transformada y quieres que ambas representaciones sean iguales. Y el artículo del libro que vimos tiene dos estados diferentes del arte de las transformaciones de pretexto, que es el rompecabezas y el método de rotación discutido anteriormente. De alguna manera, esto es como un aprendizaje multitarea, pero no tratando de predecir ambas rotaciones diseñadas. Estás tratando de ser invariante de la rotación del rompecabezas.


<!--###  Using a Large Number of Negatives-->
### Usando un gran número de negativos

<!--The key thing that has made contrastive learning work well in the past, taking successful attempts is using a large number of negatives. [One of the good paper](https://arxiv.org/abs/1805.01978) taking successful attempts, is instance discrimination paper from 2018, which introduced this concept of a memory bank. This is powered, most of the research methods which are state of the art techniques hinge on this idea for a memory bank. The memory bank is a nice way to get a large number of negatives without really increasing the sort of computing requirement. What you do is you store a feature vector per image in memory, and then you use that feature vector in your contrastive learning.-->

La clave que ha hecho que el aprendizaje contrastivo funcione bien en el pasado, haciendo intentos exitosos, es utilizar un gran número de negativos. [Uno de los buenos artículos](https://arxiv.org/abs/1805.01978) que han tenido éxito es el artículo de discriminación de 2018, que introdujo este concepto de un banco de memoria. Este es potenciado, la mayoría de los métodos de investigación que son técnicas de vanguardia dependen de esta idea de un banco de memoria. El banco de memoria es una buena manera de obtener un gran número de negativos sin aumentar realmente el tipo de requisitos computacionales. Lo que se hace es almacenar un vector de característica por imagen en la memoria, y luego se utiliza ese vector de característica en su aprendizaje contrastivo.


<!--### How it works-->
### Como funciona

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig16.png"
height="75%" width="75%"/><br><b>Fig. 16</b>: <!--How does the Memory Bank Work-->Cómo funciona el Banco de Memoria
</center>

<!--Let's first talk about how you would do this entire PIRL setup without using a memory bank. So you have an image $I$ and you have an image $I^t$, and you feed-forward both of these images, you get a feature vector $f(v_I)$ from the original image $I$, you get a feature $g(v_{I^t})$ from the transform versions, the patches, in this case. What you want is the features $f$ and $g$ to be similar. And you want features from any other unrelated image to basically be dissimilar. In this case, what we can do now is if you want a lot of negatives, we would really want a lot of these negative images to be feed-forward at the same time, which really means that you need a very large batch size to be able to do this. Of course, a large batch size is not really good, if not possible, on a limited amount of GPU memory. The way to do that is to use something called a memory bank. So what this memory bank does is that it stores a feature vector for each of the images in your data set, and when you're doing contrastive learning rather than using feature vectors, say, from a different from a negative image or a different image in your batch, you can just retrieve these features from memory. You can just retrieve features of any other unrelated image from the memory and you can just substitute that to perform contrastive learning. Simply dividing the objective into two parts, there was a contrasting term to bring the feature vector from the transformed image $g(v_I)$, similar to the representation that we have in the memory so $m_I$. And similarly, we have a second contrastive term that tries to bring the feature $f(v_I)$ close to the feature representation that we have in memory. Essentially $g$ is being pulled close to $m_I$ and $f$ is being pulled close to $m_I$. By transitivity, $f$ and $g$ are being pulled close to one another. And the reason for separating this out was that it stabilized training and we were not able to train without doing this. Basically, the training would not really converge. By separating this out into two forms, rather than doing direct contrastive learning between $f$ and $g$, we were able to stabilize training and actually get it working.-->

Hablemos primero de cómo harías toda esta configuración del ARPI sin usar un banco de memoria. Así que tienes una imagen $I$ y tienes una imagen $I^t$, y retroalimentas ambas imágenes, obtienes un vector de características $f(v_I)$ de la imagen original $I$, obtienes una característica $g(v_{I^t})$ de las versiones transformadas, los parches, en este caso. Lo que quieres es que las características $f$ y $g$ sean similares. Y quieres que las características de cualquier otra imagen no relacionada sean básicamente diferentes. En este caso, lo que podemos hacer ahora es que si quieres muchos negativos, realmente querríamos que muchas de estas imágenes negativas se retroalimentaran al mismo tiempo, lo que realmente significa que se necesita un tamaño de lote muy grande para poder hacer esto. Por supuesto, un gran tamaño de lote no es realmente bueno, si no es posible, en una cantidad limitada de memoria de la GPU. La forma de hacerlo es usar algo llamado banco de memoria. Así que lo que este banco de memoria hace es que almacena un vector de característica para cada una de las imágenes en su conjunto de datos, y cuando usted está haciendo el aprendizaje contrastivo en lugar de utilizar vectores de característica, digamos, de una imagen diferente de un negativo o una imagen diferente en su lote, usted puede simplemente recuperar estas características de la memoria. Puedes recuperar características de cualquier otra imagen no relacionada de la memoria y puedes sustituirla para llevar a cabo un aprendizaje  contrastivo. Simplemente dividiendo el objetivo en dos partes, había un término contrastado para traer el vector de la característica de la imagen transformada $g(v_I)$, similar a la representación que tenemos en la memoria así $m_I$. Y de forma similar, tenemos un segundo término contrastivo que intenta acercar el rasgo $f(v_I)$ a la representación del rasgo que tenemos en la memoria. Esencialmente $g$ se acerca a $m_I$ y $f$ se acerca a $m_I$. Por la transitividad, $f$ y $g$ se acercan el uno al otro. Y la razón para separar esto fue que estabilizó el entrenamiento y no fuimos capaces de entrenar sin hacer esto. Básicamente, el entrenamiento no convergía realmente. Al separar esto en dos formas, en lugar de hacer un aprendizaje directo contrastivo entre $f$ y $g$, fuimos capaces de estabilizar el entrenamiento y hacerlo funcionar. 


<!--### PIRL Pre-training-->
### Preentrenamiento ARPI

<!--The way to evaluate this is basically by standard pre-training evaluation set-up. For transfer learning, we can pretrain on images without labels. The standard way of doing this is to take an image net, throw away the labels and pretend as unsupervised.-->

La forma de evaluar esto es básicamente mediante un sistema estándar de evaluación previa al entrenamiento. Para el aprendizaje de transferencia, podemos pre-entrenar en imágenes sin etiquetas. La forma estándar de hacer esto es tomar una red de imágenes, tirar las etiquetas y fingir que no están supervisadas.


<!--### [Evaluation](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)-->
### [Evaluación](https://www.youtube.com/watch?v=0KeR6i1_56g&t=5889s)

<!--Evaluation can be performed by full fine-tuning (initialisation evaluation) or training a linear classifier (feature evaluation). PIRL robustness has been tested by using images in-distribution by training it on in-the-wild images. So we just took 1 million images randomly from Flickr, which is the YFCC data set. And then we basically performed pre-training on these images and then performed transplanting on different data sets.-->

La evaluación puede realizarse mediante un ajuste completo (evaluación de inicialización) o entrenando un clasificador lineal (evaluación de características). La robustez del ARPI ha sido probada mediante el uso de imágenes en distribución entrenándola en imágenes en la naturaleza. Así que acabamos de tomar un millón de imágenes al azar de Flickr, que es el conjunto de datos del YFCC. Y luego básicamente realizamos el preentrenamiento sore estas imágenes y luego realizamos el transplante en diferentes conjuntos de datos.

<!--#### Evaluating on Object Detection task-->
### Evaluando en la tarea de detección de objetos

<!--PIRL was first evaluated on object detection task (a standard task in vision) and it was able to outperform ImageNet supervised pre-trained networks on both **VOC07+12** and **VOC07** data sets. In fact, PIRL outperformed even in the stricter evaluation criteria, $AP^{all}$ and that's a good positive sign.-->

EL ARPI fue evaluado primero en la tarea de detección de objetos (una tarea estándar en visión) y fue capaz de superar a las redes preentrenadas supervisadas por ImageNet en los conjuntos de datos **VOC07+12** y **VOC07**. De hecho, ARPI superó incluso en los criterios de evaluación más estrictos, $AP^{all}$ y eso es una buena señal positiva.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig17.png"
height="70%" width="70%"/><br><b>Fig. 17</b>: <!--Object detection performance on different datasets-->Rendimiento de la detección de objetos en diferentes conjuntos de datos
</center>


<!--#### Evaluating on Semi-supervised Learning-->
### Evaluación del aprendizaje semisupervisado

<!--PIRL was then evaluated on semi-supervised learning task. Again, PIRL performed fairly well. In fact, PIRL was better than even the pre-text task of Jigsaw. The only difference between the first row and the last row is that, PIRL is an invariant version, whereas Jigsaw is a covariant version.-->

ARPI fue entonces evaluado en una tarea de aprendizaje semisupervisada. Una vez más, ARPI se desempeñó bastante bien. De hecho, ARPI fue mejor que incluso la tarea de pretexto del rompecabezas . La única diferencia entre la primera y la última fila es que ARPI es una versión invariante, mientras que el rompecabezas es una versión covariante.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig18.png"
height="70%" width="70%"/><br><b>Fig. 18</b>: <!--Semi-supervised learning on ImageNet-->Aprendizaje semisupervisado en ImageNet
</center>


<!--#### Evaluating on Linear Classification-->
### Evaluación de la clasificación lineal

<!--Now when evaluating on Linear Classifiers, PIRL was actually on par with the CPCv2, when it came out. It also worked well on a bunch of parameter settings and a bunch of different architectures. And of course, now you can have fairly good performance by methods like SimCLR or so. In fact, the Top-1 Accuracy for SimCLR would be around 69-70, whereas for PIRL, that'd be around 63.-->

Ahora cuando se evaluan los clasificadores lineales, el ARPI estaba a la par con el CPCv2, cuando este salió. También funcionó bien en un montón de ajustes de parámetros y un montón de diferentes arquitecturas. Y por supuesto, ahora puedes tener un rendimiento bastante bueno con métodos como SimCLR o demás. De hecho, la precisión Top-1 para SimCLR sería de alrededor de 69-70, mientras que para el ARPI, sería de alrededor de 63.


<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig19.png"
height="75%" width="75%"/><br><b>Fig. 19</b>: <!--ImageNet classification with linear models-->Clasificación de ImageNet con modelos lineales
</center>


<!--#### Evaluating on YFCC images-->
### Evaluando en las imágenes del YFCC

<!--PIRL was evaluated on *"In-the-wild" Flickr* images from the YFCC data set. It was able to perform better than Jigsaw, even with $100$ times smaller data set. This shows the power of taking invariance into consideration for the representation in the pre-text tasks, rather than just predicting pre-text tasks.-->

El ARPI fue evaluado en imágenes de Flickr "In-the-wild" del conjunto de datos del YFCC. Fue capaz de funcionar mejor que el rompecabezas, incluso con un conjunto de datos $100$ veces más pequeño. Esto muestra el poder de tomar en cuenta la invariancia para la representación en las tareas de pretexto, en lugar de sólo predecir las tareas de pretexto.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig20.png"
height="70%" width="70%"/><br><b>Fig. 20</b>: <!--Pre-training on uncurated YFCC images-->Preentrenamiento en imágenes no curadas del YFCC
</center>


<!--### Semantic Features-->
### Características semánticas

<!--Now, going back to verifying the semantic features, we look at the Top-1 accuracy for PIRL and Jigsaw for different layers of representation from `conv1` to `res5`. It's interesting to note that the accuracy keeps increasing for different layers for both PIRL and Jigsaw, but drops in the 5th layer for Jigsaw. Whereas, the accuracy keeps improving for PIRL, *i.e.* more and more semantic.-->

Ahora, volviendo a la verificación de los características semánticas, miramos la precisión Top-1 para el ARPI y el rompecabezas para diferentes capas de representación desde "conv1" a "res5". Es interesante observar que la precisión sigue aumentando para las diferentes capas tanto para el ARPI como para el rompecabezas, pero disminuye en la 5ª capa para el rompecabezas. Mientras que, la precisión sigue mejorando para ARPI, *i.e.*, más y más semántica.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig21.png"
height="70%" width="70%"/><br><b>Fig. 21</b>: <!--Quality of PIRL representations per layer-->Calidad de las representaciones del ARPI por capa
</center>


<!--### Scalability-->
### Escalabilidad

<!--PIRL is very good at handling problem complexity because you're never predicting the number of permutations, you're just using them as input. So, PIRL can easily scale to all 362,880 possible permutations in the 9 patches. Whereas in Jigsaw, since you're predicting that, you're limited by the size of your output space.-->

ARPI es muy bueno en el manejo problemas complejos porque tu nunca predices el número de permutaciones, sólo los usas como entrada. Así que el ARPI puede escalar fácilmente a todas las 362.880 permutaciones posibles en los 9 parches. Mientras que en el rompecabezas, ya que estás prediciendo eso, estás limitado por el tamaño de tu espacio de salida.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig22.png"
height="70%" width="70%"/><br><b>Fig. 22</b>: <!--Effect of varying the number of patch permutations-->Efecto de la variación del número de permutaciones de parches
</center>

<!--The paper "*Misra & van der Maaten, 2019, PIRL*" also shows how PIRL could be easily extended to other pretext tasks like Jigsaw, Rotations  and so on. Further, it could even be extended to combinations of those tasks like Jigsaw+Rotation.-->

El artículo de "*Misra & van der Maaten, 2019, PIRL*" también muestra como el ARPI podría extenderse fácilmente a otras tareas de pretexto como el rompecabezas, las rotaciones y así sucesivamente. Además, podría incluso extenderse a combinaciones de esas tareas como Rompecabezas+Rotación.

<center>
<img src="{{site.baseurl}}/images/week10/10-2/fig23.png"
height="70%" width="70%"/><br><b>Fig. 23</b>: <!--Using PIRL with (combinations of) different pretext tasks-->Usando PIRL con (combinaciones de) diferentes tareas de pretexto
</center>


<!--### Invariance *vs.* performance-->
### Invariancia *vs.* desempeño

<!--In terms of invariance property, one could, in general, assert that the invariance of PIRL is more than that of the Clustering, which in turn has more invariance than that of the pretext tasks. And similarly, the performance to is higher for PIRL than Clustering, which in turn has higher performance than pretext tasks. This suggests that taking more invariance in your method could improve performance.-->

En cuanto a la propiedad de la invariancia, se podría afirmar, en general, que la invariancia del ARPI es más que la del Agrupamiento, que a su vez tiene más invariancia que la de las tareas de pretexto. Y de forma similar, el desmpeño del ARPI es mayor que el del Agrupamiento, que a su vez tiene un rendimiento mayor que el de las tareas de pretexto. Esto sugiere que tomar más invariancia en su método podría mejorar el rendimiento.


<!--### Shortcomings-->
### Limitaciones

<!--1. It's not very clear as to which set of data transforms matter. Although Jigsaw works, it's not very clear why it works.
2. Saturation with model size and data size.
3. What invariances matter? (One could think about what invariances work for a particular supervised task in general as future work.)-->

1. No está muy claro qué conjunto para transformación de datos importa.  Aunque el Rompecabezas funciona, no está muy claro por qué funciona.
2. Saturación con el tamaño del modelo y el tamaño de los datos.
3. ¿Qué invariancias importan? (Uno podría pensar en qué invariancias funcionan para una tarea supervisada en general como trabajo futuro).

<!--So in general, we should try to predict more and more information and try to be as invariant as possible.-->

Así que en general, debemos tratar de predecir más y más información y tratar de ser lo más invariante posible.

<!--## Some important questions asked as doubts-->
## Algunas preguntas importantes planteadas como dudas

<!--### Contrastive learning and batch norms-->
### Aprendizaje contrastivo y normas de lote

<!--1. Wouldn't the network learn only a very trivial way of separating the negatives from the positives if the contrasting network uses the batch norm layer (as the information would then pass from one sample to the other)?-->

1. ¿No aprendería la red sólo una forma muy trivial de separar los negativos de los positivos si la red de contraste utiliza la capa de norma de lote (ya que la información pasaría entonces de una muestra a la otra)?

<!--**Ans**: *In PIRL, no such phenomenon was observed, so just the usual batch norm was used*-->

**Resp**: *En ARPI, no se observó tal fenómeno, así que sólo se utilizó la norma habitual de lotes*

<!--2. So is it fine to use batch norms for any contrasting networks?-->

2. Entonces, ¿está bien usar normas de lote para cualquier red de contraste?

<!--**Ans**: *In general, yeah. In SimCLR, a variant of the usual batch norm is used to emulate a large batch size. So, batch norm with maybe some tweaking could be used to make the training easier*-->

**Resp**: *En general, sí. En SimCLR, se utiliza una variante de la norma de lote habitual para emular un gran tamaño de lote. Por lo tanto, la norma de lote con tal vez algunos ajustes podría ser utilizado para hacer el entrenamiento más sencillo *

<!--3. Does the batch norm work in the PIRL paper only because it's implemented as a memory bank - as all the representations aren't taken at the same time? (As batch norms aren't specifically used in the MoCo paper for instance)-->

3. ¿Funciona la norma de lote en el artículo del ARPI sólo porque se implementa como un banco de memoria - ya que todas las representaciones no se toman al mismo tiempo? (Como las normas de lote no se utilizan específicamente en el artículo de MoCo, por ejemplo)

<!--**Ans**: *Yeah. In PIRL, the same batch doesn't have all the representations and possibly why batch norm works here, which might not be the case for other tasks where the representations are all correlated within the batch*-->

**Resp**: *Sí. En el ARPI, el mismo lote no tiene todas las representaciones y posiblemente por qué la norma del lote funciona aquí, lo que podría no ser el caso para otras tareas donde las representaciones están todas correlacionadas dentro del lote*

<!--4. So, other than memory bank, are there any other suggestions how to go about for n-pair loss? Should we use AlexNet or others that don't use batch norm? Or is there a way to turn off the batch norm layer? (This is for a video learning task)-->

4. Entonces, aparte del banco de memoria, ¿hay alguna otra sugerencia para la pérdida de n-pares? ¿Deberíamos usar AlexNet u otras que no usen la norma del lote? ¿O hay alguna manera de apagar la capa de norma de lote? (Esto es para una tarea de aprendizaje de video)

<!--**Ans**: *Generally frames are correlated in videos, and the performance of the batch norm degrades when there are correlations. Also, even the simplest implementation of AlexNet actually uses batch norm. Because, it's much more stable when trained with a batch norm. You could even use a higher learning rate and you could also use for other downstream tasks. You could use a variant of batch norm for example, group norm for video learning task, as it doesn't depend on the batch size*-->

**Resp**: *Generalmente los recuadros están correlacionados en los videos, y el desempeño de la norma del lote se degrada cuando hay correlaciones. Además, incluso la implementación más simple de AlexNet de hecho utiliza la norma de lote. Porque, es mucho más estable cuando se entrena con una norma de lote. Incluso se puede utilizar una tasa de aprendizaje más alta y que también se podría utilizar para otras tareas posteriores. Podrías usar una variante de la norma por lotes, por ejemplo, la norma de grupo para la tarea de aprendizaje de vídeo, ya que no depende del tamaño del lote*.

<!--### Loss functions in PIRL-->
### Funciones de pérdida en el ARPI

<!--1. In PIRL, why is NCE (Noise Contrastive Estimator) used for minimizing loss and not just the negative probability of the data distribution: $h(v_{I},v_{I^{t}})$?-->

1. En el ARPI, ¿por qué se utiliza el ECR (Estimador Contrastativo de Ruido) para minimizar la pérdida y no sólo la probabilidad negativa de la distribución de datos: $h(v_{I},v_{I^{t})$?

<!--**Ans**: *Actually, both could be used. The reason for using NCE has more to do with how the memory bank paper was set up. So, with $k+1$ negatives, it's equivalent to solving $k+1$ binary problem. Another way of doing it is using a softmax, where you apply a softmax and minimize the negative log-likelihood*-->

**Resp**: *Realmente, ambos podrían ser usados. La razón para usar el ECR tiene más que ver con la forma en que el fue configurado en el artículo del libro. Así que, con $k+1$ negativos, es equivalente a resolver el problema binario de $k+1$. Otra forma de hacerlo es empleando un softmax, donde se aplica un softmax y se minimiza la probabilidad negativa*


<!--### Self-supervised learning project related tips-->
### Consejos relacionados con el proyecto de aprendizaje auto-supervisado

<!--How do we get a simple self-supervised model working? How do we begin the implementation?-->
¿Cómo hacemos que funcione un simple modelo auto-supervisado? ¿Cómo comenzamos la implementación?

<!--**Ans**: *There are a certain class of techniques that are useful for the initial stages. For instance, you could look at the pretext tasks. Rotation is a very easy task to implement. The number of moving pieces are in general good indicator. If you're planning to implement an existing method, then you might have to take a closer look at the details mentioned by the authors, like - the exact learning rate used, the way batch norms were used, etc. The more number of these things, the harder the implementation. Next very critical thing to consider is data augmentation. If you get something working, then add more data augmentation to it.*-->

**Resp**: *Hay una cierta clase de técnicas que son útiles para las etapas iniciales. Por ejemplo, podrías mirar las tareas de pretexto. La rotación es una tarea muy fácil de implementar. El número de piezas móviles es en general un buen indicador. Si estás planeando implementar un método existente, entonces podrías tener que mirar más de cerca los detalles mencionados por los autores, como - la tasa exacta de aprendizaje utilizada, la forma en que se utilizaron las normas de lote, etc. Cuantas más cosas de estas, más difícil será la implementación. La siguiente cosa muy crítica a considerar es el aumento de los datos. Si consigues que algo funcione, entonces añade más aumento de datos a esta.*


<!--### Generative models-->
### Modelos Generativos

<!--Have you thought of combining generative models with contrasting networks?-->
¿Ha pensado en combinar modelos generativos con redes contrastadas?

<!--**Ans**: *Generally, it's good idea. But, it hasn't been implemented partly because it is tricky and non-trivial to train such models. Integrative approaches are harder to implement, but perhaps the way to go in the future.*-->

**Resp**: *Generalmente, es buena idea. Pero no se ha implementado en parte porque es difícil y no trivial entrenar tales modelos. Los enfoques integradores son más difíciles de implementar, pero quizás sea el camino a seguir en el futuro.


<!--### Distillation-->
### Destilación

<!--Wouldn't the uncertainty of the model increase when richer targets are given by softer distributions? Also, why is it called distillation?-->

¿No aumentaría la incertidumbre del modelo cuando los objetivos más ricos son dados por distribuciones más suaves? Además, ¿por qué se llama destilación?

<!--**Ans**: *If you train on one hot labels, your models tend to be very overconfident. Tricks like label smoothing are being used in some methods. Label smoothing is just a simple version of distillation where you are trying to predict a one hot vector. Now, rather than trying to predict the entire one-hot vector, you take some probability mass out of that, where instead of predicting a one and a bunch of zeros, you predict say $0.97$ and then you add $0.01$, $0.01$ and $0.01$ to the remaining vector (uniformly). Distillation is just a more informed way of doing this. Instead of randomly increasing the probability of an unrelated task, you have a pre-trained network to do that. In general softer distributions are very useful in pre-training methods. Models tend to be over-confident and so softer distributions are easier to train. They converge faster too. These benefits are present in distillation*-->

**Resp**: *Si entrenas con etiquetas one hot, tus modelos tienden a ser extremadamente confiados. Trucos como la suavización de la etiqueta se están utilizando en algunos métodos. La suavización de etiquetas es sólo una versión simple de la destilación en la que se intenta predecir un vector one hot. Ahora, en lugar de tratar de predecir todo el vector one hot de un uno, sacas alguna masa de probabilidad de eso, donde en lugar de predecir un uno y un montón de ceros, predices digamos $0,97$ y luego añades $0,01$, $0,01$ y $0,01$ al vector restante (uniformemente). La destilación es sólo una forma más informada de hacer esto. En lugar de aumentar aleatoriamente la probabilidad de una tarea no relacionada, tienes una red preentrenada para hacerlo. En general, las distribuciones más suaves son muy útiles en los métodos de pre-entrenamiento. Los modelos tienden a ser demasiado confiados y por lo tanto las distribuciones más suaves son más fáciles de entrenar. También convergen más rápidamente. Estos beneficios están presentes en la destilación*
