---
lang: es
lang-ref: ch.10-1
title: Aprendizaje auto-supervisado, tareas de pretexto
lecturer: Ishan Misra
authors: Aniket Bhatnagar, Dhruv Goyal, Cole Smith, Nikhil Supekar
date: 6 Apr 2020
translation-date: 6 Sep 2020
translator: jcremona
---

<!--
## [Success story of supervision: Pre-training](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)
-->

## [Caso de éxito de supervisión: Pre-entrenamiento](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

<!--In the past decade, one of the major success recipes for many different Computer Vision problems has been learning visual representations by performing supervised learning for ImageNet classification. And, using these learned representations, or learned model weights as initialization for other computer vision tasks, where a large quantum of labelled data might not be available.
-->

En la última década, una de las mayores recetas de éxito para muchos diferentes problemas de Visión por Computadora ha sido el aprendizaje de representaciones visuales mediante el aprendizaje supervisado para la clasificación de imágenes de ImageNet. Y luego usar estas representaciones aprendidas o los pesos de los modelos aprendidos como inicialización para otras tareas de Visión por Computadora, para los que una gran cantidad de datos etiquetados podría no estar disponible.

<!--However, getting annotations for a dataset of the magnitude of ImageNet is immensely time-consuming and expensive. Example: ImageNet labelling with 14M images took roughly 22 human years.
-->

Sin embargo, obtener anotaciones para un conjunto de datos de la magnitud de ImageNet consume mucho tiempo y es caro. Ejemplo: el etiquetado de ImageNet con 14 millones de imágenes tomó aproximadamente 22 años humanos.

<!--Because of this, the community started to look for alternate labelling processes, such as hashtags for social media images, GPS locations, or self-supervised approaches where the label is a property of the data sample itself.
-->

Debido a esto, la comunidad comenzó a buscar procesos de etiquetado alternativos, tales como *hashtags* para imágenes de redes sociales, ubicaciones de GPS o enfoques auto-supervisados ​​donde la etiqueta es una propiedad de la muestra de datos en sí.

<!--But an important question that arises before looking for alternate labelling processes is:
-->

Pero una pregunta importante que surge antes de buscar procesos de etiquetado alternativos es:

<!--**How much labelled data can we get after all?**
-->

**¿Cuántos datos etiquetados podemos obtener después de todo?**

<!--- If we search for all images with object-level category and bounding box annotations then there are roughly 1 million images.
- Now, if the constraint for bounding box coordinates is relaxed, the number of images available jumps to 14 million (approximately).
- However, if we consider all images available on the internet, there is a jump of 5 orders in the quantity of data available.
- And, then there is data apart from images, which requires other sensory input to capture or understand.
-->

- Si buscamos todas las imágenes con categorías a nivel de objeto y anotaciones de cuadro delimitador, hay aproximadamente 1 millón de imágenes.
- Ahora, si se relaja la restricción para las coordenadas del cuadro delimitador, el número de imágenes disponibles salta a 14 millones (aproximadamente).
- Sin embargo, si consideramos todas las imágenes disponibles en Internet, hay un salto de 5 órdenes en la cantidad de datos disponibles.
- Y, además de las imágenes, hay datos que requieren otra información sensorial para capturarlos o comprenderlos.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Figure 1:</b> Variation in available data quantum basis complexity of annotation
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<b>Figura 1:</b> Variación en la complejidad básica de la anotación de los datos disponibles
</center>


<!--Hence, drawing from the fact that ImageNet specific annotation alone took 22 human years worth of time, scaling labelling to all internet photos or beyond is completely infeasible.
-->

Por lo tanto, partiendo del hecho de que la anotación específica de ImageNet por sí sola tomó 22 años humanos de tiempo, escalar el etiquetado a todas las fotos de Internet o más es completamente inviable.

<!--**Problem of Rare Concepts** (*Long Tail Problem*)
-->

**Problema de Conceptos Raros** (*Problema de Cola Larga*)

<!--Generally, the plot presenting distribution of the labels for internet images looks like a long tail. That is, most of the images correspond to very few labels, while there exist a large number of labels for which not many images are present. Thus, getting annotated samples for categories towards the end of the tail requires huge quantities of data to be labelled because of the nature of the distribution of categories.
-->

En general, el gráfico que presenta la distribución de las etiquetas de las imágenes de Internet parece una cola larga. Es decir, la mayoría de las imágenes corresponden a muy pocas etiquetas, mientras que existe una gran cantidad de etiquetas para las que no hay muchas imágenes. Por lo tanto, obtener muestras anotadas para categorías hacia el final de la cola requiere que se etiqueten grandes cantidades de datos debido a la naturaleza de la distribución de categorías.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Figure 2:</b> Variation in distribution of available images with labels
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<b>Figura 2:</b> Variación en la distribución de imágenes disponibles con etiquetas
</center>


<!--**Problem of Different Domains**
-->

**Problema de diferentes dominios**

<!--This method of ImageNet pre-training and fine-tuning on downstream task gets even murkier when the downstream task images belong to a completely different domain, such as medical imaging. And, obtaining a dataset of the quantum of ImageNet for pre-training for different domains is not possible.
-->

Este método de pre-entrenamiento y ajuste de ImageNet en tareas posteriores se vuelve aún más confuso cuando las imágenes de dichas tareas pertenecen a un dominio completamente diferente, como las imágenes médicas. Y, obtener un conjunto de datos del tamaño de ImageNet para el pre-entrenamiento para diferentes dominios no es posible.

<!--
## What is self-supervised Learning?
-->

## ¿Qué es el Aprendizaje auto-supervisado?

<!--**Two ways to define self-supervised learning**
-->

**Dos formas de definir el Aprendizaje auto-supervisado**

<!--- **Basis supervised learning definition**, *i.e.* the network follows supervised learning where labels are obtained in a semi-automated manner, without human input.
- **Prediction problem**, where a part of the data is hidden, and rest visible. Hence, the aim is to either predict the hidden data or to predict some property of the hidden data.
-->

- **Definición básica de aprendizaje supervisado**, es decir, la red sigue el aprendizaje supervisado en el que las etiquetas se obtienen de forma semi-automatizada, sin intervención humana.
- **Problema de predicción**, donde una parte de los datos está oculta y el resto visible. Por tanto, el objetivo es predecir los datos ocultos o predecir alguna propiedad de los datos ocultos.

<!--**How self-supervised learning differs from supervised learning and unsupervised learning?**
-->

**¿En qué se diferencia el aprendizaje auto-supervisado del aprendizaje supervisado y el aprendizaje no supervisado?**

<!--- Supervised learning tasks have pre-defined (and generally human-provided) labels,
- Unsupervised learning has just the data samples without any supervision, label or correct output.
- Self-supervised learning derives its labels from a co-occurring modality for the given data sample or from a co-occurring part of the data sample itself.
-->

- Las tareas de aprendizaje supervisado tienen etiquetas predefinidas (y generalmente proporcionadas por humanos),
- El aprendizaje no supervisado tiene solamente las muestras de datos sin supervisión, etiqueta ni salida correcta.
- El aprendizaje auto-supervisado deriva sus etiquetas de una modalidad concurrente para la muestra de datos dada o de una parte concurrente de la muestra de datos misma.

<!--
### Self-Supervised Learning in Natural Language Processing
-->

### Aprendizaje auto-supervisado en el procesamiento del lenguaje natural

<!--#### Word2Vec
-->

#### Word2Vec

<!--- Given an input sentence, the task involves predicting a missing word from that sentence, which is specifically omitted for the purpose of building a pretext task.
- Hence, the set of labels becomes all possible words in the vocabulary, and, the correct label is the word that was omitted from the sentence.
- Thus, the network can then be trained using regular gradient-based methods to learn word-level representations.
-->

- Dada una oración de entrada, la tarea consiste en predecir una palabra que falta en esa oración, que se omite específicamente con el propósito de construir una tarea de pretexto.
- Por lo tanto, el conjunto de etiquetas se convierte en todas las palabras posibles en el vocabulario, y la etiqueta correcta es la palabra que se omitió de la oración.
- Por lo tanto, la red se puede entrenar utilizando los métodos usuales basados ​​en gradientes para aprender representaciones a nivel de palabra.

<!--
### Why self-supervised learning?
-->

### ¿Por qué aplicar aprendizaje auto-supervisado?

<!--- Self-supervised learning enables learning representations of data by just observations of how different parts of the data interact.
- Thereby drops the requirement of huge amount of annotated data.
- Additionally, enables to leverage multiple modalities that might be associated with a single data sample.
-->

- El aprendizaje auto-supervisado permite aprender representaciones de datos solo con observaciones de cómo interactúan las diferentes partes de los datos.
- Por lo tanto, elimina el requisito de contar con una gran cantidad de datos anotados.
- Además, permite aprovechar múltiples modalidades que podrían estar asociadas con una sola muestra de datos.

<!--
### Self-Supervised Learning in Computer Vision
-->

### Aprendizaje auto-supervisado en Visión por Computadora

<!--Generally, computer vision pipelines that employ self-supervised learning involve performing two tasks, a pretext task and a real (downstream) task.
-->

En general, los *pipelines* de Visión por Computadora que emplean aprendizaje auto-supervisado implican la realización de dos tareas, una tarea de pretexto y una tarea real (posterior).

<!--- The real (downstream) task can be anything like classification or detection task, with insufficient annotated data samples.
- The pretext task is the self-supervised learning task solved to learn visual representations, with the aim of using the learned representations or model weights obtained in the process, for the downstream task.
-->

- La tarea real (posterior) puede ser cualquier cosa, como una tarea de clasificación o detección, con insuficientes muestras de datos anotados.
- La tarea de pretexto es la tarea de aprendizaje auto-supervisado que se resuelve para aprender representaciones visuales, con el objetivo de utilizar las representaciones aprendidas o los pesos de los modelos obtenidos en el proceso, para la tarea posterior.

<!--
#### Developing pretext tasks
-->

#### Desarrollando tareas de pretexto

<!--- Pretext tasks for computer vision problems can be developed using either images, video, or video and sound.
- In each pretext task, there is part visible and part hidden data, while the task is to predict either the hidden data or some property of the hidden data.
-->

- Las tareas de pretexto para problemas de Visión por Computadora se pueden desarrollar utilizando imágenes, video o video y sonido.
- En cada tarea de pretexto hay datos en parte visibles y en parte ocultos, mientras que la tarea es predecir los datos ocultos o alguna propiedad de los datos ocultos.

<!--
#### [Example pretext tasks: Predicting relative position of image patches](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)
-->

#### [Ejemplo de tareas de pretexto: predecir la posición relativa de parches de imagen](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

<!--- Input: 2 image patches, one is the anchor image patch while the other is the query image patch.
- Given the 2 image patches, the network needs to predict the relative position of the query image patch with respect to the anchor image patch.
- Thus, this problem can be modelled as an 8-way classification problem, since there are 8 possible locations for a query image, given an anchor.
- And, the label for this task can be automatically generated by feeding the relative position of query patch with respect to the anchor.
-->

- Entrada: 2 parches de imagen, uno es el parche de imagen anclado y el otro es el parche de imagen de consulta.
- Dados los 2 parches de imagen, la red necesita predecir la posición relativa del parche de imagen de consulta con respecto al parche de imagen anclado.
- Por lo tanto, este problema se puede modelar como un problema de clasificación de 8 vías, ya que hay 8 ubicaciones posibles para una imagen de consulta, dada una imagen anclada.
- Y, la etiqueta para esta tarea se puede generar automáticamente al proporcionar la posición relativa del parche de consulta con respecto al ancla.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Figure 3:</b> Relative Position task
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<b>Figura 3:</b> Tarea de posición relativa
</center>

<!--
#### Visual representations learned by relative position prediction task
-->

#### Representaciones visuales aprendidas por la tarea de predicción de posición relativa

<!--We can evaluate the effectiveness of the learned visual representations by checking nearest neighbours for a given image patch basis feature representations provided by the network. For computing nearest neighbours of a given image patch,
-->

Podemos evaluar la eficacia de las representaciones visuales aprendidas comprobando los vecinos más cercanos para una dada representación de características de un parche de imagen provista por la red. Para calcular los vecinos más cercanos de un parche de imagen determinado,

<!--- Compute the CNN features for all images in the dataset, that will act as the sample pool for retrieval.
- Compute CNN features for the required image patch.
- Identify nearest neighbours for the feature vector of the required image, from the pool of feature vectors of images available.
-->

- Calcular las características visuales de la CNN para todas las imágenes del conjunto de datos, que actuarán como grupo de muestras para su recuperación.
- Calcular las características visuales de la CNN para el parche de imagen requerido.
- Identificar los vecinos más cercanos para el vector de características de la imagen requerida, a partir del conjunto de vectores de características de imágenes disponibles.

<!--Relative position task finds out image patches that are very similar to the input image patch, while maintains invariance to factors such as object colour. Thus, the relative position task is able to learn visual representations, where representations for image patches with similar visual appearance are closer in the representation space as well.
-->

La tarea de posición relativa descubre parches de imagen que son muy similares al parche de imagen de entrada, mientras que a su vez mantiene la invariancia a factores como el color del objeto. Por lo tanto, la tarea de posición relativa es capaz de aprender representaciones visuales, donde las representaciones de parches de imagen con apariencia visual similar también están más cerca en el espacio de representación.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Figure 4:</b> Relative Position: Nearest Neighbours
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<b>Figura 4:</b> Posición relativa: vecinos más cercanos
</center>


<!--
#### Predicting Rotation of Images
-->

#### Predicción de la rotación de imágenes

<!--- Predicting rotations is one of the most popular pretext task which has a simple and straightforward architecture and requires minimal sampling.
- We apply rotations of 0, 90, 180, 270 degrees to the image and send these rotated images to the network to predict what sort of rotation was applied to the image and the network simply performs a 4-way classification to predict the rotation.
- Predicting rotations does not make any semantic sense, we are just using this pretext task as a proxy to learn some features and representations to be used in a downstream task.
-->

- La predicción de rotaciones es una de las tareas de pretexto más populares, la cual tiene una arquitectura simple y directa y requiere un muestreo mínimo.
- Aplicamos rotaciones de 0, 90, 180, 270 grados a la imagen y enviamos estas imágenes rotadas a la red para predecir qué tipo de rotación se aplicó a la imagen y la red simplemente realiza una clasificación de 4 vías para predecir la rotación.
- Predecir rotaciones no tiene ningún sentido semántico, solo estamos usando esta tarea de pretexto <!--como un proxy-->para aprender algunas características y representaciones que se utilizarán en una tarea posterior.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Figure 5:</b> Rotations of Image
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<b>Figura 5:</b> Rotaciones de una imagen
</center>

<!--
#### Why rotation helps or why it works?
-->

#### ¿Por qué la rotación ayuda o por qué funciona?

<!--It has been proven that it works empirically. The intuition behind it is that in order to predict the rotations, model needs to understand the rough boundaries and representation of an image. For example, it will have to segregate the sky from water or sand from the water or will understand that trees grow upwards and so on.
-->

Está comprobado que funciona empíricamente. La intuición detrás de esto es que para predecir las rotaciones, el modelo necesita comprender los límites aproximados y la representación de una imagen. Por ejemplo, tendrá que separar el cielo del agua o la arena del agua o comprender que los árboles crecen hacia arriba y así sucesivamente.

<!--
#### Colourisation
-->

#### Coloración

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Figure 6:</b> Colourisation
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<b>Figura 6:</b> Coloración
</center>

<!--In this pretext task, we predict the colours of a grey image. It can be formulated for any image, we just remove the colour and feed this greyscale image to the network to predict its colour. This task is useful in some respects like for colourising the old greyscale films [//]: <> (we can apply this pretext task). The intuition behind this task is that the network needs to understand some meaningful information like that the trees are green, the sky is blue and so on.
-->

En esta tarea de pretexto, predecimos los colores de una imagen gris. Se puede formular para cualquier imagen, simplemente eliminamos el color y proporcionamos esta imagen en escala de grises a la red para predecir su color. Esta tarea es útil en algunos aspectos como para colorear las viejas películas en escala de grises [//]: <> (podemos aplicar esta tarea de pretexto). La intuición detrás de esta tarea es que la red necesita comprender alguna información significativa, como que los árboles son verdes, el cielo es azul, y así sucesivamente.

<!--It is important to note that colour mapping is not deterministic, and several possible true solutions exist. So, for an object if there are several possible colours then the network will colour it as grey which is the mean of all possible solutions. There have been recent works using Variational Auto Encoders and latent variables for diverse colourisation.
-->

Es importante tener en cuenta que el mapeo de colores no es determinista y existen varias posibles soluciones verdaderas. Entonces, para un objeto, si hay varios colores posibles, la red lo coloreará como gris, que es la media de todas las soluciones posibles. Se han realizado trabajos recientes utilizando autoencoders variacionales y variables latentes para coloración diversa.

<!--
#### Fill in the blanks
-->

#### Rellenar los espacios en blanco

<!--We hide a part of an image and predict the hidden part from the remaining surrounding part of the image. This works because the network will learn the implicit structure of the data like to represent that cars run on roads, buildings are composed of windows & doors and so on.
-->

Ocultamos una parte de una imagen y predecimos la parte oculta a partir de la parte circundante restante de la imagen. Esto funciona porque la red aprenderá la estructura implícita de los datos, como por ejemplo, para representar que los automóviles circulan por las carreteras, los edificios están compuestos por ventanas y puertas, y así sucesivamente.

<!--
### Pretext Tasks for videos
-->

### Tareas de pretexto para videos

<!--Videos are composed of sequences of frames and this notion is the idea behind self-supervision, which can be leveraged for some pretext tasks like predicting the order of frames, fill in the blanks and object tracking.
-->

Los videos están compuestos por secuencias de fotogramas y esta noción es la idea detrás de la auto-supervisión, la cual se puede aprovechar para algunas tareas de pretexto como predecir el orden de los fotogramas, completar los espacios en blanco y rastrear objetos.

<!--
#### Shuffle & Learn
-->

#### Mezclar y Aprender

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Figure 7:</b> Interpolation
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<b>Figura 7:</b> Interpolación
</center>

<!--Given a bunch of frames, we extract three frames and if they are extracted in the right order we label it as positive, else if they are shuffled, label it as negative. This now becomes a binary classification problem to predict if the frames are in the right order or not. So, given a start and end point, we check if the middle is a valid interpolation of the two.
-->

Dado un conjunto de fotogramas, extraemos tres fotogramas y, si se extraen en el orden correcto, los etiquetamos como positivos, de lo contrario, si están mezclados, los etiquetamos como negativos. Esto se vuelve un problema de clasificación binaria para predecir si los fotogramas están en el orden correcto o no. Entonces, dado un punto inicial y final, verificamos si el del medio es una interpolación válida de los otros dos.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Figure 8:</b> Shuffle & Learn architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<b>Figure 8:</b> Arquitectura de Mezclar y Aprender
</center>

<!--We can use a triplet Siamese network, where the three frames are independently fed forward and then we concatenate the generated features and perform the binary classification to predict if the frames are shuffled or not.
-->

Podemos usar una red *Siamese Triplet*, donde los tres fotogramas son proporcionados independientemente y luego concatenamos las características visuales generadas y realizamos la clasificación binaria para predecir si los fotogramas están mezclados o no.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Figure 9:</b> Nearest Neighbours Representation
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<b>Figura 9:</b> Representación de vecinos más cercanos
</center>

<!--Again, we can use the Nearest Neighbours algorithm to visualize what our networks are learning. In fig. 9 above, first we have a query frame which we feed-forward to get a feature representation and then look at the nearest neighbours in the representation space. While comparing, we can observe a stark difference between neighbours obtained from ImageNet, Shuffle & Learn and Random.
-->

Nuevamente, podemos usar el algoritmo de vecinos más cercanos para visualizar lo que nuestras redes están aprendiendo. En la fig. 9, primero tenemos un fotograma de consulta (*Query*) que proporcionamos para obtener una representación de características visuales y luego observamos los vecinos más cercanos en el espacio de representación. Al comparar, podemos observar una gran diferencia entre los vecinos obtenidos de ImageNet, Mezclar y Aprender (*Shuffle & Learn*) y Aleatorio (*Random*).

<!--ImageNet is good at collapsing the entire semantic as it could figure out that it is a gym scene for the first input. Similarly, it could figure out that it is an outdoor scene with grass etc. for the second query. Whereas, when we observe Random we can see that it gives high importance to the background colour.
-->

ImageNet es bueno para capturar toda la semántica, ya que pudo descubrir que es una escena de gimnasio para la primera entrada. Del mismo modo, pudo descubrir que es una escena al aire libre con césped, etc. para la segunda consulta. Mientras que, cuando observamos Aleatorio (*Random*), podemos ver que le da mucha importancia al color de fondo.

<!--On observing Shuffle & Learn, it is not immediately clear whether it is focusing on the colour or on the semantic concept. After further inspection and observing various examples, it was observed that it is looking at the pose of the person. For example, in the first image the person is upside down and in second the feet are in a particular position similar to query frame, ignoring the scene or background colour. The reasoning behind this is that our pretext task was predicting whether the frames are in the right order or not, and to do this the network needs to focus on what is moving in the scene, in this case, the person.
-->

Al observar Mezclar y Aprender (*Shuffle & Learn*), no queda claro de inmediato si se centra en el color o en el concepto semántico. Después de una inspección más profunda y de observar varios ejemplos, se observó que está mirando la pose de la persona. Por ejemplo, en la primera imagen la persona está boca abajo y en la segunda los pies están en una posición particular similar al fotograma de consulta, ignorando la escena o el color de fondo. El razonamiento detrás de esto es que nuestra tarea de pretexto era predecir si los fotogramas están en el orden correcto o no, y para hacer esto, la red debe enfocarse en lo que se mueve en la escena, en este caso, la persona.

<!--It was verified quantitatively by fine-tuning this representation to the task of human key-point estimation, where given a human image we predict where certain key points like nose, left shoulder, right shoulder, left elbow, right elbow, etc. are. This method is useful for tracking and pose estimation.
-->

Se realizó una verificación cuantitativa ajustando esta representación a la tarea de estimación de puntos clave humanos, donde dada una imagen humana predecimos dónde están ciertos puntos clave como nariz, hombro izquierdo, hombro derecho, codo izquierdo, codo derecho, etc. Este método es útil para el seguimiento y la estimación de pose.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Figure 10:</b> Key point Estimation comparison
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<b>Figura 10:</b> Comparación de estimación de puntos claves
</center>

<!--In figure 10, we compare the results for supervised ImageNet and Self-Supervised Shuffle & Learn on FLIC and MPII datasets and we can see that Shuffle and Learn gives good results for key point estimation.
-->

En la figura 10, comparamos los resultados de ImageNet supervisado y Mezclar y Aprender auto-supervisado en los conjuntos de datos FLIC y MPII y podemos ver que Mezclar y Aprender da buenos resultados para la estimación de puntos clave.

<!--
### Pretext Tasks for videos and sound
-->

### Tareas de pretexto para videos y sonido

<!--Video and Sound are multi-modal where we have two modalities or sensory inputs one for video and one for sound. Where we try to predict whether the given video clip corresponds to the audio clip or not.
-->

El Video y el Sonido son multimodales donde tenemos dos modalidades o entradas sensoriales, una para video y otra para sonido. Aquí intentamos predecir si el clip de video dado corresponde al clip de audio o no.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Figure 11:</b> Video and sound sampling
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<b>Figura 11:</b> Muestreo de video y sonido
</center>

<!--Given a video with audio of a drum, sample the video frame with corresponding audio and call it a positive set. Next, take the audio of a drum and the video frame of a guitar and tag it as a negative set. Now we can train a network to solve this as a binary classification problem.
-->

Dado un video con audio de un tambor, muestrear el fotograma de video con el audio correspondiente y llamarlo conjunto positivo. A continuación, tomar el audio de un tambor y el fotograma de video de una guitarra y etiquetarlo como conjunto negativo. Ahora podemos entrenar una red para resolver esto como un problema de clasificación binaria.

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Figure 12:</b> Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<b>Figura 12:</b> Arquitectura
</center>

<!--**Architecture:** Pass the video frames to the vision subnetwork and pass the audio to the audio subnetwork, which gives 128-dimensional features and embeddings, we then fuse them together and solve it as a binary classification problem predicting if they correspond with each other or not.
-->

**Arquitectura:** Pasar los fotogramas de video a la subred de visión y pasar el audio a la subred de audio, que proporciona características visuales y *embeddings* de 128 dimensiones, luego las fusionamos y lo resolvemos como un problema de clasificación binaria prediciendo si se corresponden con el uno al otro o no.

<!--It can be used to predict what in the frame might be making a sound. The intuition is if it is the sound of a guitar, the network roughly needs to understand how the guitar looks and same should be true for drums.
-->

Se puede usar para predecir qué podría estar emitiendo un sonido en el fotograma. La intuición es que si se trata del sonido de una guitarra, la red necesita entender aproximadamente cómo se ve la guitarra y lo mismo debería ser cierto para la batería.

<!--
## [Understanding what the "pretext" task learns](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)
-->

## [Comprender lo que aprende la tarea de "pretexto"](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

<!--* Pretext tasks should be **complementary**
-->

* Las tareas de pretexto deben ser **complementarias**

<!--  * Let's take for example the pretext tasks *Relative Position* and *Colourisation*. We can boost performance by training a model to learn both pretext tasks as shown below:
-->

  * Tomemos por ejemplo las tareas de pretexto *Posición relativa* y *Coloración*. Podemos aumentar el rendimiento entrenando un modelo para aprender ambas tareas de pretexto como se muestra a continuación:

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Figure 13:</b> Comparison of disjoint *vs.* combined training of Relative Position and Colourisation pretext tasks. ResNet101. (Misra)
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<b>Figura 13:</b> Comparación de entrenamiento disjunto <em>vs.</em> entrenamiento combinado de tareas de pretexto de Posición relativa y Coloración. ResNet101. (Misra)
</center>
<!--  * A single pretext task may not be the right answer to learn SS representations
-->

  * Una sola tarea de pretexto puede no ser la respuesta correcta para aprender representaciones auto-supervisadas

<!--* Pretext tasks vary greatly in what they try to predict (difficultly)
-->

* Las tareas de pretexto varían mucho en lo que intentan predecir (en cuanto a la dificultad)
<!--  * Relative position is easy since it's a simple classification
  * Masking and fill-in is far harder -> **better representation**
  * **Contrastive methods** generate even more info than pretext tasks-->

  * La posición relativa es fácil ya que es una clasificación simple
  * Enmascarar y rellenar es mucho más difícil -> **mejor representación**
  * Los **métodos contrastivos** generan incluso más información que las tareas de pretexto

<!--* **Question:** How do we train multiple pre-training tasks?
-->

* **Pregunta:** ¿Cómo entrenamos múltiples tareas de pre-entrenamiento?
<!--  * The pretext output will depend on the input. The final fully-connected layer of the network can be **swapped** depending on the batch type.
  * For example: A batch of black-and-white images is fed to the network in which the model is to produce a coloured image. Then, the final layer is switched, and given a batch of patches to predict relative position.-->

  * La salida de pretexto dependerá de la entrada. La capa totalmente conectada final de la red se puede **intercambiar** según el tipo del *batch*.
  * Por ejemplo: un *batch* de imágenes en blanco y negro es proporcionado a la red cuyo modelo va a producir una imagen en color. Luego, se cambia la capa final y se le da un *batch* de parches para predecir la posición relativa.

<!--*  **Question:** How much should we train on a pretext task?
-->

* **Pregunta:** ¿Cuánto deberíamos entrenar en una tarea de pretexto?

<!--  * Rule of thumb: Have a very difficult pretext task such that it improves the downstream task.
  * In practice, the pretext task is trained, and may not be re-trained. In development, it is trained as part of the entire pipeline.
-->

  * Regla de oro: Tener una tarea de pretexto muy difícil de tal manera que mejore la tarea posterior.
  * En la práctica, la tarea de pretexto está entrenada y no puede volver a entrenarse. En desarrollo, se entrena como parte de todo el proceso.

<!--
## Scaling Self-Supervised Learning
-->

## Escalando el aprendizaje auto-supervisado

<!--
### Jigsaw Puzzles
-->

### Rompecabezas

<!--* Partition an image into multiple tiles and then shuffle these tiles. The model is then tasked with un-shuffling the tiles back to the original configuration. (Noorozi & Favaro, 2016)
-->

* Dividir una imagen en varios mosaicos y luego mezclar estos mosaicos. El modelo tiene entonces la tarea de volver a ordenar los mosaicos con la configuración original. (Noorozi & Favaro, 2016)
<!--  * Predict which permutation was applied to the input
  * This is done by creating batches of tiles such that **each tile of an image is evaluated independently**. The convolution output are then concatenated and the permutation is predicted as in figure below-->

  * Predecir qué permutación se aplicó a la entrada
  * Esto se hace creando *batches* de mosaicos de modo que **cada mosaico de una imagen se evalúe de forma independiente**. Luego, la salida de la convolución se concatena y la permutación se predice como en la figura siguiente

<!--<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Figure 14:</b> Siamese network architecture for a Jigsaw pretext task. Each tile is passed through independently, with encodings concatenated to predict a permutation. (Misra)
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<b>Figura 14:</b> Arquitectura de una red siamesa (<em>Siamese</em>) para una tarea de pretexto de Rompecabezas. Cada mosaico se pasa de forma independiente, con codificaciones concatenadas para predecir una permutación. (Misra)
</center>

<!--  * Considerations:
    1. Use a subset of permutations *i.e.* From 9!, use 100)
    2. The n-way ConvNet uses shared parameters
    3. The problem complexity is the size of the subset. The *amount of information you are predicting.*
-->

  * Consideraciones:
    1. Use un subconjunto de permutaciones, es decir, de 9!, use 100
    2. La red convolucional de n vías utiliza parámetros compartidos
    3. La complejidad del problema es el tamaño del subconjunto. La *cantidad de información a predecir.*

<!--* Sometimes, this method can perform better on downstream tasks than supervised methods, since the network is able to learn some concepts about the geometry of its input.
-->

* A veces, este método puede funcionar mejor en tareas posteriores que los métodos supervisados, ya que la red es capaz de aprender algunos conceptos sobre la geometría de su entrada.

<!--* Shortcomings: Few Shot Learning: Limited number of training examples
-->

* Deficiencias: *Few Shot Learning*: número limitado de ejemplos de entrenamiento
<!--  * **Self-supervised representations are not as sample efficient**-->

  * **Las representaciones auto-supervisadas no son tan eficientes en la muestra**

<!--
### Evaluation: Fine-tuning *vs.* Linear Classifier
-->

### Evaluación: Ajuste (*Fine-tuning*) *vs.* Clasificador lineal

<!--  This form of evaluation is a kind of **Transfer Learning**.
-->

Esta forma de evaluación es una especie de **Aprendizaje por Transferencia**.

<!--* **Fine Tuning**: When applying to our downstream task, we use our entire network as an **initialization** for which to train a new one, updating all the weights.
-->

* **Ajuste (Fine-tuning)**: cuando la aplicamos a nuestra tarea posterior, usamos toda nuestra red como una **inicialización** para entrenar una nueva red, actualizando todos los pesos.

<!--* **Linear Classifier**: On top of our pretext network, we train a small linear classifier to perform our downstream task, leaving the rest of the network intact.
-->

* **Clasificador lineal**: sobre nuestra red de pretexto, entrenamos un pequeño clasificador lineal para realizar nuestra tarea posterior, dejando el resto de la red intacto.

<!-- > A good representation should transfer with a **little training**.
-->

> Una buena representación debería transferirse con **un poco de entrenamiento**.

<!--* It is helpful to evaluate the pretext learning on a **multitude of different tasks**. We can do so by extracting the representation created by different layers in the network as **fixed features** and evaluating their usefulness across these different tasks.
  * Measurement: Mean Average Precision (mAP) --The precision averaged across all the different tasks we are considering.
  * Some examples of these tasks include: Object Detection (using fine-tuning), Surface Normal Estimation (see NYU-v2 dataset)
* What does each layer learn?
  * Generally, as the layers become deeper, the mean average precision on downstream tasks using their representations will increase.
  * However, the **final layer** will see a sharp drop in the mAP due to the layer becoming overly **specialized**.
    * This contrasts with supervised networks, in that the mAP generally always increases with depth of layer.
    * This shows that the pretext task is **not well-aligned** to the downstream task.
-->

* Es útil evaluar el aprendizaje de pretexto en **múltiples tareas diferentes**. Podemos hacerlo extrayendo la representación creada por diferentes capas en la red como **características fijas** y evaluando su utilidad en estas diferentes tareas.
  * Medición: *Mean Average Precision* (mAP): la precisión promediada en todas las diferentes tareas que estamos considerando.
  * Algunos ejemplos de estas tareas incluyen: Detección de objetos (mediante el Ajuste), Estimación normal de la superficie (ver conjunto de datos NYU-v2)
* ¿Qué aprende cada capa?
  * Generalmente, a medida que las capas se vuelven más profundas, aumentará el mAP en las tareas posteriores que utilizan sus representaciones.
  * Sin embargo, la **capa final** verá una fuerte caída en el mAP debido a que la capa se vuelve demasiado **especializada**.
    * Esto contrasta con las redes supervisadas, en las que el mAP generalmente siempre aumenta con la profundidad de la capa.
    * Esto muestra que la tarea de pretexto **no está bien alineada** con la tarea posterior.

