---
lang-ref: ch.09-3
lang: es
title: Redes generativas adversarias
lecturer: Alfredo Canziani
authors: William Huang, Kunal Gadkar, Gaomin Wu, Lin Ye
date: 31 Mar 2020
translator: ricalanis
translation-date: 21 Sep 2020
---


<!--## [Introduction to generative adversarial networks (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s)-->
## [Introducción a las redes generativas adversarias (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s)

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANArchitecture.png" height="400px" /><br>
<!--<b>Fig. 1</b>: GAN Architecture-->
<b>Fig. 1</b>: Arquitectura GAN
</center>

<!--GANs are a type of neural network used for unsupervised machine learning. They are comprised of two adversarial modules: _generator_ and _cost_ networks. These modules compete with each other such that the _cost_ network tries to filter fake examples while the _generator_ tries to trick this filter by creating realistic examples $\vect{\hat{x}}$. Through this competition, the model learns a generator that creates realistic data. They can be used in tasks such as future predictions or for generating images after being trained on a particular dataset.-->
Las GAN son un tipo de red neuronal que se utiliza para el aprendizaje automático no supervisado. Se componen de dos módulos adversarios: redes _generador_ y _de costo_. Estos módulos compiten entre sí de modo que la red _de costo_ intenta filtrar ejemplos falsos mientras que el _generador_ intenta engañar a este filtro creando ejemplos realistas $\vect{\hat{x}}$. A través de esta competencia, el modelo aprende un generador que crea datos realistas. Se pueden usar en tareas como predicciones futuras o para generar imágenes después de haber sido entrenadas en un conjunto de datos en particular.

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANMapping.png" height="400px" /><br>
<!--<b>Fig. 2</b>: GAN Mapping from Random Variable-->
<b>Fig. 2</b>: Asignación de GAN a partir de una variable aleatoria
</center>

<!--GANs are examples of energy based models (EBMs). As such, the cost network is trained to produce low costs for inputs closer to the true data distribution denoted by the pink $\vect{x}$ in Fig. 2. Data from other distributions, like the blue $\vect{\hat{x}}$ in Fig. 2, should have high cost. A mean squared error (MSE) loss is typically used to calculate the cost network's performance. It is worth noting that the cost function outputs a positive scalar value within a specified range *i.e.*$\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). This is unlike a classic discriminator which uses discrete classification for its outputs.-->
Las GAN son ejemplos de modelos basados ​​en energía (EBM). Como tal, la red de costos está entrenada para producir costos bajos para entradas más cercanas a la distribución de datos real indicada por el $\vect{x}$ rosa en la Fig. 2. Datos de otras distribuciones, como el $\vect{\hat{x}}$ en la Fig. 2, debería tener un costo elevado. Por lo general, se utiliza una pérdida del cuadrado medio del error (MSE) para calcular el rendimiento de la red de costos. Vale la pena señalar que la función de costo genera un valor escalar positivo dentro de un rango específico *es decir,* $\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). Esto es diferente a un discriminador clásico que usa clasificación discreta para sus salidas.

<!--Meanwhile, the generator network ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) is trained to improve its mapping of random variable $\vect{z}$ to realistic generated data $\vect{\hat{x}}$ to trick the cost network. The generator is trained with respect to the cost network's output, trying to minimize the energy of $\vect{\hat{x}}$. We denote this energy as $C(G(\vect{z}))$, where $C(\cdot)$ is the cost network and $G(\cdot)$ is the generator network.-->
Mientras tanto, la red del generador ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) está entrenada para mejorar su mapeo de la variable aleatoria $\vect{z}$ a datos generados realistas $\vect{\hat{x}}$ para engañar a la red de costos. El generador se entrena con respecto a la salida de la red de costos, tratando de minimizar la energía de $\vect{\hat{x}}$. Denotamos esta energía como $C(G(\vect{z}))$, donde $C(\cdot)$ es la red de costos y $G(\cdot)$ es la red del generador.

<!--The training of the cost network is based on minimizing the MSE loss, while the training of the generator network is through minimizing the cost network, using gradients of $C(\vect{\hat{x}})$ with respect to $\vect{\hat{x}}$.-->
El entrenamiento de la red de costos se basa en minimizar la pérdida de MSE, mientras que el entrenamiento de la red de generadores es minimizando la red de costos, utilizando gradientes de $C(\vect{\hat{x}})$ con respecto a $\vect{\hat{x}}$.

<!--To ensure that high cost is assigned to points outside the data manifold and low cost is assigned to points within it, the loss function for the cost network $\mathcal{L}\_{C}$ is $C(x)+[m-C(G(\vect{z}))]^+$ for some positive margin $m$. Minimizing $\mathcal{L}\_{C}$ requires that $C(\vect{x}) \rightarrow 0$ and $C(G(\vect{z})) \rightarrow m$. The loss for the generator $\mathcal{L}\_{G}$ is simply $C(G(\vect{z}))$, which encourages the generator to ensure that $C(G(\vect{z})) \rightarrow 0$. However, this does create instability as $0 \leftarrow C(G(\vect{z})) \rightarrow m$.-->
Para asegurar que se asigne un alto costo a los puntos fuera del colector de datos y un bajo costo a los puntos dentro de él, la función de pérdida para la red de costos $\mathcal{L}\_{C}$ is $C(x)+[m-C(G(\vect{z}))]^+$ para un margen positivo $m$. Minimizar $\mathcal{L}\_{C}$ requiere que $C(\vect{x}) \rightarrow 0$ y $C(G(\vect{z})) \rightarrow m$. La pérdida para el generador $\mathcal{L}\_{G}$ es simplemente $C(G(\vect{z}))$, lo que anima al generador a asegurarse de que $C(G(\vect{z})) \rightarrow 0$. Sin embargo, esto crea inestabilidad como $0 \leftarrow C(G(\vect{z})) \rightarrow m$.

<!--## [Difference between GANs and VAEs](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s)-->
## [Diferencias entre GANs y VAEs](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s)

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEArchitecture.png" height="400px" /><br>
<!--<b>Fig. 3</b>: VAE (left) *vs.* GAN (right) - Architectural design-->
<b>Fig. 3</b>: VAE (izquierda) *vs.* GAN (derecha) - Diseño de Arquitectura
</center>

<!--Compared to Variational Auto-Encoders (VAEs) from week 8, GANs create generators slightly differently. Recall, VAEs map inputs $\vect{x}$ to a latent space $\mathcal{Z}$ with an _encoder_ and then map from $\mathcal{Z}$ back to the data space with a _decoder_ to get $\vect{\hat{x}}$. They then use the reconstruction loss to push $\vect{x}$ and $\vect{\hat{x}}$ to be similar. GANs, on the other hand, train through an adversarial setting with the generator and cost networks competing as described above. These networks are successively trained through backpropagation through gradient based methods. Comparison of this architectural difference can be seen in Fig. 3.-->
En comparación con los codificadores automáticos variacionales (VAE) de la semana 8, los GAN crean generadores de manera ligeramente diferente. Recuerde, los VAE mapean las entradas $\vect{x}$ a un espacio latente $\mathcal{Z}$ con un _codificador_ y luego mapean desde $\mathcal{Z}$ de regreso al espacio de datos con un _descifrador_ para obtener $\vect{\hat{x}}$. Luego usan la pérdida de reconstrucción para hacer que $\vect{x}$ y $\vect{\hat{x}}$ sean similares. Las GAN, por otro lado, se entrenan a través de un entorno de confrontación con el generador y las redes de costos compitiendo como se describe anteriormente. Estas redes se entrenan sucesivamente mediante retropropagación mediante métodos basados ​​en gradientes. La comparación de esta diferencia arquitectónica se puede ver en la Fig.3.

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEMapping.jpg" height="250px" /><br>
<!--<b>Fig. 4</b>: VAE (left) *vs.* GAN (right) - Mapping from Random Sample $\vect{z}$-->
<b>Fig. 4</b>: VAE (left) *vs.* GAN (right) - Asignación de una muestra aleatoria $\vect{z}$
</center>

<!--GANs also differ from VAEs through how they produce and use $\vect{z}$. GANs start by sampling $\vect{z}$, similar to the latent space in a VAE. They then use a generative network to map $\vect{z}$ to $\vect{\hat{x}}$. This $\vect{\hat{x}}$ is then sent through a discriminator/cost network to evaluate how "real" it is. One of the main differences from VAE and GAN is that **we do not need to measure a direct relationship (*i.e.* reconstruction loss) between the output of the generative network $\vect{\hat{x}}$ and real data $\vect{x}$.** Instead, we force $\vect{\hat{x}}$ to be similar to $\vect{x}$ by training the generator to produce $\vect{\hat{x}}$ such that the discriminator/cost network produces scores that are similar to those of real data $\vect{x}$, or more "real".-->
Los GAN también se diferencian de los VAE en la forma en que producen y usan $\vect{z}$. Las GAN comienzan muestreando $\vect{z}$, similar al espacio latente en un VAE. Luego usan una red generativa para mapear $\vect{z}$ a $\vect{\hat{x}}$. Este $\vect{\hat{x}}$ se envía luego a través de una red discriminadora / de costos para evaluar qué tan "real" es. Una de las principales diferencias de VAE y GAN es que ** no necesitamos medir una relación directa (* es decir, * pérdida de reconstrucción) entre la salida de la red generativa $\vect{\hat{x}}$ y los datos reales $\vect{x}$. ** En su lugar, forzamos $\vect{\hat{x}}$ a ser similar a $\vect{x}$ al entrenar el generador para producir $\vect{\hat{x}}$ tal que la red discriminadora / de costos produzca puntuaciones que sean similares a las de los datos reales $\vect{x}$, o más "reales".


<!--## Major pitfalls in GANs-->
## Principales dificultades en las GAN

<!--While GANs can be powerful for building generators, they have some major pitfalls.-->
Si bien las GAN pueden ser poderosas para construir generadores, tienen algunas dificultades importantes.


<!--### 1. Unstable convergence-->
### 1. Convergencia inestable

<!--As the generator improves with training, the discriminator performance gets worse because the discriminator can no longer easily tell the difference between real and fake data. If the generator is perfect, then the manifold of the real and fake data will lie on top of each other and the discriminator will create many misclassifications.-->
A medida que el generador mejora con el entrenamiento, el rendimiento del discriminador empeora porque el discriminador ya no puede diferenciar fácilmente entre datos reales y falsos. Si el generador es perfecto, entonces la variedad de datos reales y falsos se superpondrán y el discriminador creará muchas clasificaciones erróneas.

<!--This poses a problem for convergence of the GAN: the discriminator feedback gets less meaningful over time. If the GAN continues training past the point when the discriminator is giving completely random feedback, then the generator starts to train on junk feedback and its quality may collapse. [Refer to [training convergence in GANs](https://developers.google.com/machine-learning/gan/training)]-->
Esto plantea un problema para la convergencia de la GAN: la retroalimentación del discriminador se vuelve menos significativa con el tiempo. Si el GAN ​​continúa entrenando más allá del punto en el que el discriminador está dando retroalimentación completamente aleatoria, entonces el generador comienza a entrenar con retroalimentación basura y su calidad puede colapsar. [Consulte [formación de convergencia en GAN] (https://developers.google.com/machine-learning/gan/training)]

<!--As a result of this adversarial nature between the generator and discriminator there is an unstable equilibrium point rather than an equilibrium.-->
Como resultado de esta naturaleza antagónica entre el generador y el discriminador, hay un punto de equilibrio inestable en lugar de un equilibrio.


<!--###  2. Vanishing gradient-->
2. Desvanecimiento de gradiente

<!--Let's consider using the binary cross entropy loss for a GAN:-->
Consideremos usar la pérdida de entropía cruzada binaria para una GAN:

$$
\mathcal{L} = \mathbb{E}_\boldsymbol{x}[\log(D(\boldsymbol{x}))] + \mathbb{E}_\boldsymbol{\hat{x}}[\log(1-D(\boldsymbol{\hat{x}}))] \text{.}
$$

<!--As the discriminator becomes more confident, $D(\vect{x})$ gets closer to $1$ and $D(\vect{\hat{x}})$ gets closer to $0$. This confidence moves the outputs of the cost network into flatter regions where the gradients become more saturated. These flatter regions provide small, vanishing gradients that hinder the generator network's training. Thus, when training a GAN, you want to make sure that the cost gradually increases as you become more confident.-->
A medida que el discriminador se vuelve más seguro, $D(\vect{x})$ $ se acerca a  $1$ y $D(\vect{\hat{x}})$ se acerca a $0$. Esta confianza mueve los resultados de la red de costos a regiones más planas donde los gradientes se vuelven más saturados. Estas regiones más planas proporcionan pequeños gradientes que se desvanecen y dificultan el entrenamiento de la red de generadores. Por lo tanto, al entrenar a un GAN, debe asegurarse de que el costo aumente gradualmente a medida que adquiere más confianza.


<!--### 3. Mode collapse-->
### 3. Colapso de la moda

 <!--If a generator maps all $\vect{z}$'s from the sampler to a **single** $\vect{\hat{x}}$ that can fool the discriminator, then the generator will produce **only** that $\vect{\hat{x}}$. Eventually, the discriminator will learn to detect *specifically* this fake input. As a result, the generator simply finds the next most plausible $\vect{\hat{x}}$ and the cycle continues. Consequently, the discriminator gets trapped in local minima while cycling through fake $\vect{\hat{x}}$'s. A possible solution to this issue is to enforce some penalty to the generator for always giving the same output given different inputs.-->
 Si un generador mapea todos los $\vect{z}$ del muestreador a un ** único ** $\vect{\hat{x}}$ que puede engañar al discriminador, entonces el generador producirá **solo** ese $\vect{\hat{x}}$. Eventualmente, el discriminador aprenderá a detectar *específicamente* esta entrada falsa. Como resultado, el generador simplemente encuentra el siguiente $\vect{\hat{x}}$ más plausible y el ciclo continúa. En consecuencia, el discriminador queda atrapado en los mínimos locales mientras recorre los $\vect{\hat{x}}$ falsos. Una posible solución a este problema es imponer alguna penalización al generador por dar siempre la misma salida dadas diferentes entradas.


<!--## [Deep Convolutional Generative Adversarial Network (DCGAN) source code](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s)-->
## [Código fuente de Deep Convolutional Generative Adversarial Network (DCGAN)] (https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s)

<!--The source code of the example can be found [here](https://github.com/pytorch/examples/blob/master/dcgan/main.py).-->
El código fuente del ejemplo se puede encontrar [aquí] (https://github.com/pytorch/examples/blob/master/dcgan/main.py).


<!--### Generator-->
### Generador

<!--1. The generator upsamples the input using several `nn.ConvTranspose2d` modules separated with `nn.BatchNorm2d` and `nn.ReLU`.
2. At the end of the sequential, the network uses `nn.Tanh()` to squash outputs to $(-1,1)$.
3. The input random vector has size $nz$. The output has size $nc \times 64 \times 64$, where $nc$ is the number of channels.-->
1. El generador muestra la entrada utilizando varios módulos `nn.ConvTranspose2d` separados por` nn.BatchNorm2d` y `nn.ReLU`.
2. Al final de la secuencia, la red usa `nn.Tanh()` para aplastar las salidas a $(- 1,1)$.
3. El vector aleatorio de entrada tiene un tamaño $nz$. La salida tiene un tamaño $nc \times 64 \times 64$, donde $nc$ es el número de canales.

<!--```python
class Generator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # input is Z, going into a convolution
            nn.ConvTranspose2d(     nz, ngf * 8, 4, 1, 0, bias=False),
            nn.BatchNorm2d(ngf * 8),
            nn.ReLU(True),
            # state size. (ngf*8) x 4 x 4
            nn.ConvTranspose2d(ngf * 8, ngf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 4),
            nn.ReLU(True),
            # state size. (ngf*4) x 8 x 8
            nn.ConvTranspose2d(ngf * 4, ngf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 2),
            nn.ReLU(True),
            # state size. (ngf*2) x 16 x 16
            nn.ConvTranspose2d(ngf * 2,     ngf, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf),
            nn.ReLU(True),
            # state size. (ngf) x 32 x 32
            nn.ConvTranspose2d(    ngf,      nc, 4, 2, 1, bias=False),
            nn.Tanh()
            # state size. (nc) x 64 x 64
        )

    def forward(self, input):
        output = self.main(input)
        return output
```-->
```python
class Generator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # la entrada es Z, entrando en una convolución
            nn.ConvTranspose2d(     nz, ngf * 8, 4, 1, 0, bias=False),
            nn.BatchNorm2d(ngf * 8),
            nn.ReLU(True),
            # tamaño del estado. (ngf*8) x 4 x 4
            nn.ConvTranspose2d(ngf * 8, ngf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 4),
            nn.ReLU(True),
            # tamaño del estado. (ngf*4) x 8 x 8
            nn.ConvTranspose2d(ngf * 4, ngf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 2),
            nn.ReLU(True),
            # tamaño del estado. (ngf*2) x 16 x 16
            nn.ConvTranspose2d(ngf * 2,     ngf, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf),
            nn.ReLU(True),
            # tamaño del estado. (ngf) x 32 x 32
            nn.ConvTranspose2d(    ngf,      nc, 4, 2, 1, bias=False),
            nn.Tanh()
            # tamaño del estado. (nc) x 64 x 64
        )

    def forward(self, input):
        output = self.main(input)
        return output
```

<!--### Discriminator-->
### Discriminador

<!--1. It is important to use `nn.LeakyReLU` as the activation function to avoid killing the gradients in negative regions. Without these gradients, the generator will not receive updates.
2. At the end of the sequential, the discriminator uses `nn.Sigmoid()` to classify the input.-->
1. Es importante utilizar `nn.LeakyReLU` como función de activación para evitar matar los gradientes en las regiones negativas. Sin estos gradientes, el generador no recibirá actualizaciones.
2. Al final de la secuencia, el discriminador usa `nn.Sigmoid ()` para clasificar la entrada

<!--```python
class Discriminator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # input is (nc) x 64 x 64
            nn.Conv2d(nc, ndf, 4, 2, 1, bias=False),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf) x 32 x 32
            nn.Conv2d(ndf, ndf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 2),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*2) x 16 x 16
            nn.Conv2d(ndf * 2, ndf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 4),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*4) x 8 x 8
            nn.Conv2d(ndf * 4, ndf * 8, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 8),
            nn.LeakyReLU(0.2, inplace=True),
            # state size. (ndf*8) x 4 x 4
            nn.Conv2d(ndf * 8, 1, 4, 1, 0, bias=False),
            nn.Sigmoid()
        )

    def forward(self, input):
        output = self.main(input)
        return output.view(-1, 1).squeeze(1)
```-->
```python
class Discriminator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # la entrada es (nc) x 64 x 64
            nn.Conv2d(nc, ndf, 4, 2, 1, bias=False),
            nn.LeakyReLU(0.2, inplace=True),
            # tamaño del estado. (ndf) x 32 x 32
            nn.Conv2d(ndf, ndf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 2),
            nn.LeakyReLU(0.2, inplace=True),
            # tamaño del estado. (ndf*2) x 16 x 16
            nn.Conv2d(ndf * 2, ndf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 4),
            nn.LeakyReLU(0.2, inplace=True),
            # tamaño del estado. (ndf*4) x 8 x 8
            nn.Conv2d(ndf * 4, ndf * 8, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 8),
            nn.LeakyReLU(0.2, inplace=True),
            # tamaño del estado. (ndf*8) x 4 x 4
            nn.Conv2d(ndf * 8, 1, 4, 1, 0, bias=False),
            nn.Sigmoid()
        )

    def forward(self, input):
        output = self.main(input)
        return output.view(-1, 1).squeeze(1)
```

<!--These two classes are initialized as `netG` and `netD`.-->
Estas dos clases se inicializan como `netG` y` netD`


<!--### Loss function for GAN-->
### Función de pérdida para GAN

<!--We use Binary Cross Entropy (BCE) between target and output.-->
Usamos entropía cruzada binaria (BCE) entre el objetivo y la salida.

```python
criterion = nn.BCELoss()
```


<!--### Setup-->
### Preparación

<!--We set up `fixed_noise` of size `opt.batchSize` and length of random vector `nz`. We also create labels for real data and generated (fake) data called `real_label` and `fake_label`, respectively.-->
Configuramos `Fixed_noise` de tamaño` opt.batchSize` y la longitud del vector aleatorio `nz`. También creamos etiquetas para datos reales y datos generados (falsos) llamados `real_label` y` fake_label`, respectivamente.

```python
fixed_noise = torch.randn(opt.batchSize, nz, 1, 1, device=device)
real_label = 1
fake_label = 0
```

<!--Then we set up optimizers for discriminator and generator networks.-->
Luego configuramos optimizadores para redes discriminadoras y generadoras.

```python
optimizerD = optim.Adam(netD.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
optimizerG = optim.Adam(netG.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
```


<!--### Training-->
### Entrenamiento

<!--Each epoch of training is divided into two steps.-->
Cada época de entrenamiento esta divida en dos partes.

<!--**Step 1** is to update the discriminator network. This is done in two parts. First, we feed the discriminator real data coming from `dataloaders`, compute the loss between the output and `real_label`, and then accumulate gradients with backpropagation. Second, we feed the discriminator data generated by the generator network using the `fixed_noise`, compute the loss between the output and `fake_label`, and then accumulate the gradient. Finally, we use the accumulated gradients to update the parameters for the discriminator network.-->
**El paso 1** es actualizar la red discriminadora. Esto se hace en dos partes. Primero, alimentamos los datos reales del discriminador provenientes de los "dataloaders", calculamos la pérdida entre la salida y la "etiqueta_real", y luego acumulamos gradientes con propagación hacia atrás. En segundo lugar, alimentamos los datos del discriminador generados por la red del generador utilizando el `Fixed_noise`, calculamos la pérdida entre la salida y la` fake_label`, y luego acumulamos el gradiente. Finalmente, usamos los gradientes acumulados para actualizar los parámetros de la red discriminadora.

<!--Note that we detach the fake data to stop gradients from propagating to the generator while we train the discriminator.-->
Tenga en cuenta que separamos los datos falsos para evitar que los gradientes se propaguen al generador mientras entrenamos al discriminador.

<!--Also note that we only need to call `zero_grad()` once in the beginning to clear the gradients so the gradients from both the real and fake data can be used for the update. The two `.backward()` calls accumulate these gradients. We finally only need one call of `optimizerD.step()` to update the parameters.-->
También tenga en cuenta que solo necesitamos llamar a `zero_grad()` una vez al principio para borrar los gradientes de forma que los gradientes de los datos reales y falsos se puedan usar para la actualización. Las dos llamadas `.backward()` acumulan estos gradientes. Finalmente solo necesitamos una llamada a `optimizerD.step ()` para actualizar los parámetros.

<!--```python
# train with real
netD.zero_grad()
real_cpu = data[0].to(device)
batch_size = real_cpu.size(0)
label = torch.full((batch_size,), real_label, device=device)

output = netD(real_cpu)
errD_real = criterion(output, label)
errD_real.backward()
D_x = output.mean().item()

# train with fake
noise = torch.randn(batch_size, nz, 1, 1, device=device)
fake = netG(noise)
label.fill_(fake_label)
output = netD(fake.detach())
errD_fake = criterion(output, label)
errD_fake.backward()
D_G_z1 = output.mean().item()
errD = errD_real + errD_fake
optimizerD.step()
```-->
```python
# entrenar con reales
netD.zero_grad()
real_cpu = data[0].to(device)
batch_size = real_cpu.size(0)
label = torch.full((batch_size,), real_label, device=device)

output = netD(real_cpu)
errD_real = criterion(output, label)
errD_real.backward()
D_x = output.mean().item()

# entrenar con falsos
noise = torch.randn(batch_size, nz, 1, 1, device=device)
fake = netG(noise)
label.fill_(fake_label)
output = netD(fake.detach())
errD_fake = criterion(output, label)
errD_fake.backward()
D_G_z1 = output.mean().item()
errD = errD_real + errD_fake
optimizerD.step()
```

<!--**Step 2** is to update the Generator network. This time, we feed the discriminator the fake data, but compute the loss with the `real_label`! The purpose of doing this is to train the generator to make realistic $\vect{\hat{x}}$'s.-->
**El paso 2** es actualizar la red del generador. Esta vez, alimentamos al discriminador con los datos falsos, ¡pero calculamos la pérdida con el `real_label`! El propósito de hacer esto es entrenar al generador para hacer $\vect{\hat{x}}$ realistas.

<!--```python
netG.zero_grad()
label.fill_(real_label)  # fake labels are real for generator cost
output = netD(fake)
errG = criterion(output, label)
errG.backward()
D_G_z2 = output.mean().item()
optimizerG.step()
```-->
```python
netG.zero_grad()
label.fill_(real_label)  # las etiquetras falsas son para los costos del generador
output = netD(fake)
errG = criterion(output, label)
errG.backward()
D_G_z2 = output.mean().item()
optimizerG.step()
```
