---
lang-ref: ch.09-2
lang: es
lecturer: Yann LeCun
title: Modelos Mundiales y Redes Generativas Adversarias
authors: Bofei Zhang, Andrew Hopen, Maxwell Goldstein, Zeping Zhan
date: 30 Mar 2020
translator: mvortizr
translation-date: 16 Sep 2020
---


<!--## [World models for autonomous control](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)-->
## [Modelos mundiales para el control autónomo](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)

<!--One of the most important uses of self-supervised learning is to learn world models for control. When humans perform a task, we have an internal model for how the world works. For example, we gain an intuition for physics when we're about 9 months old, mostly through observation. In some sense, this is similar to self-supervised learning; in learning to predict what will happen, we learn abstract principles, just like self-supervised models learn latent features. But taking this one step further, the internal models let us act on the world. For example, we can use our learned physics intuition and our learned understanding of how our muscles work to predict --- and execute --- how to catch a falling pen.-->
Uno de los usos más importantes de el aprendizaje auto-supervisado es aprender modelos mundiales para control. Cuando los humanos realizan una tarea, tenemos un modelo interno de cómo el mundo funciona. Por ejemplo, nosotros ganamos una intuición física cuando tenemos alrededor de nueve meses, principalmente a través de la observación. En cierto sentido, ésto es similar al aprendizaje auto-supervisado; en aprender a predecir qué pasará, aprendemos principios abstractos, justo como los modelos auto-supervisados aprenden características latentes. Pero yendo un paso más allá, los modelos internos nos permiten actuar sobre el mundo. Por ejemplo, podemos usar nuestra intuición física aprendida y nuestra comprensión aprendida de cómo funcionan nuestros músculos para predecir --- y ejecutar --- cómo atrapar una pluma que cae.


<!--### What is a "world model"?-->
### ¿Qué es un "modelo mundial?

<!--An autonomous intelligence system comprises four major modules (Figure 1.). First, the perception module observes the world and computes a representation of the state of the world. This representation is incomplete because 1) the agent doesn't observe the whole universe, and 2) the accuracy of the observations is limited. It is also worth noting that in the feed-forward model, the perception module is only present for the initial time step. Second, the actor module (also called a policy module) imagines taking some action based on the (represented) state of the world. Third, the model module predicts the outcome of the action given the (represented) state of the world, and also possibly given some latent features. This prediction gets passed forward to the next time step as the guess for the next state of the world, taking on the role of the perception module from the initial time step. Fig 2 gives an in-detail demonstration of this feed-forward process. Finally, the critic module turns that same prediction into a cost of performing the proposed action, *e.g.* given the speed with which I believe the pen is falling, if I move muscles in this particular way, how badly will I miss the catch?-->
Un sistema de inteligencia autónomo comprende cuatro módulos principales (Figura 1.). Primero, el módulo de percepción observa el mundo y calcula una representación del estado del mundo. Esta representación está incompleta porque 1) el agente no observa todo el universo y 2) la precisión de las observaciones es limitada. También vale la pena señalar que en el modelo _feed-forward_(de retroalimentación hacia adelante), el módulo de percepción solo está presente para el paso de tiempo inicial. En segundo lugar, el módulo de actores (también llamado módulo de políticas) imagina tomar alguna acción basada en el estado (representado) del mundo. En tercer lugar, el módulo de modelo predice el resultado de la acción dado el estado (representado) del mundo, y también posiblemente dadas algunas características latentes. Ésta predicción pasa hacia adelante en el siguiente paso de tiempo como la suposición para el próximo estado del mundo, asumiendo el papel del módulo de percepción del paso de tiempo inicial. La figura 2 ofrece una demostración detallada de este proceso de retroalimentación hacia adelante. Finalmente, el módulo crítico convierte esa misma predicción en un costo de realizar la acción propuesta, *e.j*, dada la velocidad con la que creo que el bolígrafo está cayendo, si muevo los músculos de esta manera en particular, ¿Qué tanto perderé su captura?

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models_arch.png" height="400px" /><br>
<!--<b>Fig. 1</b>: The World Models architecture of an autonomous intelligence system demonstration.-->
<b>Fig. 1</b>: La arquitectura de los Modelos Mundiales de una demostración de un sistema de inteligencia autónoma.
</center>

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models.png" height="400px" /><br>
<!--<b>Fig. 2</b>: Model architecture.-->
<b>Fig. 2</b>: Arquitectura del modelo.
</center>


<!--## The classical setting-->
## La configuración clásica

<!--In classical optimal control, there is no actor/policy module, but rather just an action variable. This formulation is optimized by a classical method called Model Predictive Control, which was used by NASA in the 1960s to compute rocket trajectories when they switched from human computers (mostly Black women mathematicians) to electronic computers. We can think of this system as an unrolled RNN, and the actions as latent variables, and use backpropagation and gradient methods (or possibly other methods, such as dynamic programming for a discrete action set) to infer the sequence of actions that minimizes the sum of the time step costs.-->

En el control óptimo clásico, no hay un módulo de actor / política, sino solo una variable de acción. Esta formulación está optimizada por un método clásico llamado Modelo Predictivo de Control, que fue utilizado por la NASA en la década de 1960 para calcular las trayectorias de los cohetes cuando cambiaron de computadoras humanas (en su mayoría mujeres matemáticas negras) a computadoras electrónicas. Podemos pensar en este sistema como un RNN desenrollado, y las acciones como variables latentes, y usar métodos de retropropagación y gradiente (o posiblemente otros métodos, como la programación dinámica para un conjunto de acciones discretas) para inferir la secuencia de acciones que minimiza la suma de los costos de los pasos de tiempo


<!--Aside: We use the word "inference" for latent variables, and "learning" for parameters, though the process of optimizing them is generally similar. One important difference is that a latent variable takes a specific value for each sample, whereas, parameters are shared between samples.-->
Apartado: usamos la palabra "inferencia" para las variables latentes y "aprendizaje" para los parámetros, aunque el proceso de optimización es generalmente similar. Una diferencia importante es que una variable latente toma un valor específico para cada muestra, mientras que los parámetros se comparten entre las muestras.

<!--## An improvement-->
## Una mejora

<!--Now, we'd prefer not to go through the complicated process of backpropagating every time we want to make a plan. To address this, we use the same trick we used for variational autoencoder to improve sparse coding: we train an encoder to directly predict the optimal action sequence from the world representations. In this regime, the encoder is called a policy network.-->
Ahora, preferiríamos no pasar por el complicado proceso de retropropagación cada vez que queremos hacer un plan. Para abordar esto, usamos el mismo truco que usamos para el codificador automátco variacional para mejorar la codificación esparcida: entrenamos un codificador para predecir directamente la secuencia de acción óptima a partir de las representaciones del mundo. En este régimen, el codificador se denomina red de políticas.

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_policy_network.png" height="400px" /><br>
<!--<b>Fig. 3</b>: Policy Network.-->
<b>Fig. 3</b>: Red de Políticas
</center>

<!--Once trained, we can use the policy networks to predict the optimal action sequence immediately after perception.-->
Una vez entrenado, podemos usar la política de redes para predecir la secuencia óptima de acción inmediatamente después de la percepción


<!--## [Reinforcement learning (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)-->
## [Aprendizaje Reforzado (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)

<!--The main differences between RL and what we have studied up to this point are two-fold:
1. In Reinforcement learning environments, the cost function is a black box. In other words, the agent does not understand the reward dynamics.
2. In the setting of RL, we don't use a forward model of the world to step the environment. Instead we interact with the real world and learn the result by observing what happens. In the real world our measure of the state of the world is imperfect so it is not always possible to predict what will happen next.-->
Las principales diferencias entre RL y lo que hemos estudiado hasta este punto son dos:
1. En los entornos de aprendizaje por refuerzo, la función de costo es una caja negra. En otras palabras, el agente no comprende la dinámica de la recompensa.
2. En la configuración de RL, no utilizamos un modelo hacia adelante del mundo para avanzar en el ambiente. En cambio, interactuamos con el mundo real y aprendemos el resultado al observar lo que sucede. En el mundo real, nuestra medida del estado del mundo es imperfecta, por lo que no siempre es posible predecir lo que sucederá a continuación.


<!--The main problem of Reinforcement learning is that the cost function is not differentiable. This means that the only way to learn is through trial and error. Then the problem becomes how to explore the state space efficiently. Once you come up with a solution to this the next issue is the fundamental question of exploration *vs.* exploitation: would you rather take actions to maximally learn about the environment or instead exploit what you have already learned to get as high a reward as possible?-->
El principal problema del aprendizaje por refuerzo es que la función de costo no es diferenciable. Esto significa que la única forma de aprender es mediante prueba y error. Entonces el problema pasa a ser cómo explorar el espacio de estados de manera eficiente. Una vez que se le ocurre una solución a esto, el siguiente problema es la cuestión fundamental de exploración *vs.* explotación: ¿Preferiría tomar acciones para aprender al máximo sobre el ambiente o en su lugar explotar lo que ya ha aprendido para obtener una recompensa tan alta como sea posible?

<!--Actor-Critic methods are a popular family of RL algorithms which train both an actor and a critic. Many RL methods work similarly, by training a model of the cost function (the critic). In Actor-Critic methods the role of the critic is to learn the expected value of the value function. This enables back-propagation through the module, since the critic is just a neural network. The actor's responsibility is to propose actions to take in the environment, and the critic's job is to learn a model of the cost function. The actor and the critic work in tandem that leads to more efficient learning than if no critic is used.  If you don't have a good model of the world it is much more difficult to learn: *e.g.* the car next to the cliff will not know that falling off a cliff is a bad idea. This enables humans and animals to learn much more quickly than RL agents: we have really good world models in our head.-->
Los métodos actor-crítico son una familia popular de algoritmos de RL que entrenan tanto a un actor como a un crítico. Muchos métodos de RL funcionan de manera similar, entrenando un modelo de la función de costo (el crítico). En los métodos actor-crítico, el papel del crítico es aprender el valor esperado de la función de valor. Esto permite la propagación hacia atrás a través del módulo, ya que el crítico es solo una red neuronal. La responsabilidad del actor es proponer acciones a tomar en el entorno, y el trabajo del crítico es aprender un modelo de la función de costos. El actor y el crítico trabajan en conjunto, lo que conduce a un aprendizaje más eficiente que si no se utiliza ningún crítico. Si no tienes un buen modelo del mundo, es mucho más difícil de aprender: *Ej.* El coche que está al lado del acantilado no sabrá que caer por un acantilado es una mala idea. Esto permite que los humanos y los animales aprendan mucho más rápido que los agentes de RL: tenemos modelos mundiales realmente buenos en nuestra cabeza.

<!--We cannot always predict the future of the world due to inherent uncertainty: aleatory and epistemic uncertainty. Aleatoric uncertainty is due to things you cannot control or observe in the environment. Epistemic uncertainty is when you cannot predict the future of the world because your model does not have enough training data.-->
No siempre podemos predecir el futuro del mundo debido a la incertidumbre inherente: incertidumbre aleatoria y epistémica. La incertidumbre aleatoria se debe a cosas que no se pueden controlar u observar en el entorno. La incertidumbre epistémica ocurre cuando no se puede predecir el futuro del mundo porque el modelo no tiene suficientes datos de entrenamiento.

<!--The forward model would like to be able to predict-->
A el modelo hacia delante le gustaría ser capaz de predecir 

$$\hat s_{t+1} = g(s_t, a_t, z_t)$$

<!--where $z$ is a latent variable of which we don't know the value. $z$ represents what you cannot know about the world but which still influences the prediction (*i.e.* aleatoric uncertainty). We can regularize $z$ with sparsity, noise, or with an encoder. We can use forward models to learn to plan. The system works by having a decoder decode a concatenation of the state representation and the uncertainty $z$. The best $z$ is defined as the $z$ that minimizes the difference between $\hat s_{t+1}$ and the actual observed $s_{t+1}$.-->
donde $z$ es una variable latente de la cuál no sabemos el valor. $z$ representa lo que no puedes saber sobre el mundo pero que aún influye en la predicción (es decir, incertidumbre aleatoria). Podemos regularizar  $z$ con esparcidad, ruido, o con un codificador. Podemos usar modelos hacia adelante para aprender a planificar. El sistema trabaja al tener un decodificador decodificando una concatenación del estado de representación y la incertidumbre $z$. El mejor $z$ está definido como el $z$ que minimiza la diferencia entre $\hat s_{t+1}$ y el $s_{t+1}$ actual observado.


<!--## [Generative Adversarial Network](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)-->
## [Red Generativa Adversaria (GAN)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)

<!--There are many variations of GAN and here we think of GAN as a form of energy-based model using contrastive methods. It pushes up the energy of contrastive samples and pushes down the energy of training samples. A basic GAN consists of two parts: a generator which produces contrastive samples intelligently and a discriminator (sometimes called critic) which is essentially a cost function and acts as an energy model. Both the generator and the discriminator are neural nets.-->
Hay muchas variaciones de GAN y aquí pensamos en GAN como una forma de modelo basado en energía que utiliza métodos contrastivos. Empuja hacia arriba la energía de las muestras contrastivas y empuja hacia abajo la energía de las muestras de entrenamiento. Una GAN básica consta de dos partes: un generador que produce muestras contrastivas de manera inteligente y un discriminador (a veces llamado crítico) que es esencialmente una función de costo y actúa como un modelo energético. Tanto el generador como el discriminador son redes neuronales.

<!--The two kinds of input to GAN are respectively training samples and contrastive samples. For training samples, GAN passes these samples through the discriminator and makes their energy go down. For contrastive samples, GAN samples latent variables from some distribution, runs them through the generator to produce something similar to training samples, and passes them through the discriminator to make their energy go up. The loss function for discriminator is as follows:
-->
Los dos tipos de entrada a GAN son, respectivamente, muestras de entrenamiento y muestras contrastivas. Para las muestras de entrenamiento,la GAN pasa estas muestras a través del discriminador y hace que disminuya su energía. Para muestras contrastivas,la GAN muestrea variables latentes de alguna distribución, las pasa por el generador para producir algo similar a las muestras de entrenamiento y las pasa a través del discriminador para hacer que aumente su energía. La función de pérdida del discriminador es la siguiente:

$$\sum_i L_d(F(y), F(\bar{y}))$$

<!--where $L_d$ can be a margin-based loss function like $F(y) + [m - F(\bar{y})]^+$ or $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ as long as it makes $F(y)$ decrease and $F(\bar{y})$ increase. In this context, $y$ is the label,  and  $\bar{y}$ is the response variable gives lowest energy except $y$ itself.
There is going to be a different loss function for the generator:-->
Donde $L_d$ puede ser una función de pérdida basada en márgenes como  $F(y) + [m - F(\bar{y})]^+$ or $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ siempre y cuando haga disminuir a $F(y)$ e incremente $F(\bar{y})$. En éste contexto, $y$ es la etiqueta, y $\bar{y}$ es la variable de respuesta que proporciona la energía más baja, excepto a $y$ en sí.

$$L_g(F(\bar{y}))  = L_g(F(G(z)))$$

<!--where $z$ is the latent variable and $G$ is the generator neural net. We want to make the generator adapt its weight and produce $\bar{y}$ with low energy that can fool the discriminator.-->
donde $z$ es la variable latente y $G$ es la red neuronal generadora. Queremos hacer que el generador adapte su peso y produzca $\bar{y}$ con poca energía que pueda engañar al discriminador.

<!--The reason why this type of model is called generative adversarial network is because we have two objective functions that are incompatible with each other and we need to minimize them simultaneously. It’s not a gradient descent problem because the goal is to find a Nash equilibrium between these two functions and gradient descent is not capable of this by default.-->
La razón por la que a este tipo de modelo se le llama red generativa adversaria es porque tenemos dos funciones objetivas que son incompatibles entre sí y necesitamos minimizarlas simultáneamente. No es un problema de descenso de gradiente porque el objetivo es encontrar un equilibrio de Nash entre estas dos funciones y el descenso de gradiente no es capaz de hacerlo de forma predeterminada.

<!--There will be problems when we have samples that are close to the true manifold. Assume that we have an infinitely thin manifold. The discriminator needs to produce $0$ probability outside the manifold and infinite probability on the manifold. Since this is very difficult to achieve, GAN uses sigmoid and produces $0$ outside the manifold and produces $1$ on the manifold. The problem with this is that if we train the system successfully where we get the discriminator to produce $0$ outside the manifold, the energy function is completely useless. This is because the energy function is not smooth where all energy outside the data manifold will be infinity and all energy on the data manifold will be $0$. We don’t want the energy value to go from $0$ to infinity in a very small step. Researchers have proposed many ways to fix this problem by regularizing the energy function. A good example of improved GAN is Wasserstein GAN which limits the size of discriminator weight.-->
Habrá problemas cuando tengamos muestras cercanas a la verdadera variedad. Suponga que tenemos una variedad infinitamente delgada. El discriminador necesita producir una probabilidad de $0$ fuera de la variedad y una probabilidad infinita en la variedad. Dado que esto es muy difícil de lograr, GAN usa sigmoide y produce $0$ fuera de la variedad y produce $1$ en la variedad. El problema con esto es que si entrenamos el sistema con éxito donde conseguimos que el discriminador produzca $0$ fuera de la variedad, la función de energía es completamente inútil. Esto se debe a que la función de energía no es uniforme donde toda la energía fuera de la variedad de datos será infinita y toda la energía en la variedad de datos será $0$. No queremos que el valor de la energía pase de $0$ al infinito en un paso muy pequeño. Los investigadores han propuesto muchas formas de solucionar este problema regularizando la función energética. Un buen ejemplo de GAN mejorado es Wasserstein GAN, que limita el tamaño del peso del discriminador.

