---
lang-ref: ch.09-1
lang: es
lecturer: Yann LeCun
title: Codificador automático disperso recurrente discriminativo y dispersión de grupos
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 30 Mar 2020
translator: mvortizr
translation-date: 16 Sep 2020
---


<!--## [Discriminative recurrent sparse autoencoder (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)-->
## [Codificador automático disperso recurrente discriminativo (DrSAE)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)

<!--The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training.-->
La idea de DrSAE consiste en combinar codificación esparcida, o el codificador automático esparcido, con entrenamiento discriminativo
 <center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/></center>

<!--**Fig 1:** Discriminative Recurrent Sparse Auto-Encoder Network-->
**Fig 1:** Red de codificador automático disperso recurrente discriminativo

<!--The encoder, $W_e$, is similar to the encoder in the LISTA method. The $X$ variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, $S$, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer.-->
El codificador, $W_e$, es similar al codificador en el método LISTA. La variable $X$ es atravesada por $W_e$ y luego por una no linealidad. Este resultado es luego multiplicado por otra matriz aprendida, $S$, y agregado a $W_e$. Posteriormente es enviado a través de otra no linealidad. Este proceso puede ser repetido un número de veces, con cada repetición como una capa.

<!--We train this neural network with 3 different criteria:-->
Entrenamos la red neuronal con 3 criterios diferentes:

<!--1. $L_1$: Apply $L_1$ criterion on the feature vector $Z$ to make it sparse.-->
1. $L_1$: Aplicar el criterio $L_1$ en el vector de características $Z$ para hacerlo esparcido.
<!--2. Reconstruct $X$: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.-->
2. Reconstruir $X$: ésto se hace usando una matriz de decodificación que reproduce la entrada en la salida. Ésto se hace para minimizar el error cuadrático indicado por $W_d$ en la Figura 1.
<!--3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category.-->
3. Agregar un tercer término: Éste tercer término, indicado por $W_c$, es un simple clasificador lineal que intenta predecir una categoría.

<!--The system is trained to minimize all 3 of these criteria at the same time.-->
El sistema es entrenado para minimizar los 3 criterios al mismo tiempo

<!--The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features.-->
La ventaja de ésto es que al forzar el sistema a encontrar representaciones que pueden reconstruir la entrada, implica que se está basicamente sesgando el sistema a extraer características que contienen tanta información acerca de la entrada como es posible. En otras palabras, enriquece las características. 


<!--### Group Sparsity-->
### Dispersión Grupal

<!--The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling.-->
La idea aquí es generar características dispersas, no solo características normales que son extraídas por convoluciones, sino basicamente producir características que son dispersas después del pooling
 <center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/></center>

<!--**Fig 2:** Auto-Encoder with Group Sparsity-->
**Fig 2:** Codificador automático con dispersión de grupo


<!--Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable $Z$ going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of $Z$, and take the sum of those norms. So now that is what is used as the regulariser, so we can have sparsity on groups of $Z$. These groups, or pools of features, tend to group together features that are similar to one another.-->
La Figura 2 muestra un ejemplo de un codificador automático con dispersión de grupo. Aquí, en lugar de que la variable latente $Z$ vaya a $L_1$, ella pasa por básicamente un $L_2$ sobre grupos. Entonces se puede tomar la norma $L_2$ para cada componente en un grupos de $Z$, y tomar la suma de esas normas. Ahora eso es lo que se usa como regularizador, esto implica que podemos tener la dispersión de grupos de $Z$. Éstos grupos, o _pools_ de características, tienen a agrupar juntas características que son similares una con las otras.


<!--## [AE with group sparsity: questions and clarification](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)-->
## [Codificador automático (AE) con dispersión grupal: preguntas y aclaraciones](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)

<!--Q: Can a similar strategy used in the first slide with classifier and regulariser be applied for VAE?-->
Q: ¿Puede una estrategia similar ser usada en la primera lámina con el regularizador siendo aplicado por el VAE?

<!--A: Adding noise and forcing sparsity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function.-->
A: Agregar ruido y forzar la dispersión en una VAE son dos maneras de reducir la información que tiene la variable latente/código. Evita el aprendizaje de una función de identidad

<!--Q: In slide "AE with Group Sparsity", what is $P_j$?-->
Q: En la lámina "AE con dispersión grupal", ¿Qué es $P_j$?

<!--A: $p$ is a pool of features. For a vector $z$, it would be a subset of the values in $z$.-->
A:$p$ es un _pool_ de características. Para un vector $z$, sería el subconjunto de valores en $z$.

<!--Q: *Clarification on feature pooling.*-->
Q: Aclaración de _pooling_ de características

<!--A: (Yann draws representation of AE with group sparsity) Encoder produces latent variable $z$, which is regularized using the $L_2$ norm of pooled features. This $z$ is used by the decoder for image reconstruction.-->
A: (Yann dibuja una representación de AE con difusión grupal) El codificador produce la variable latente $z$, la cual es regularizada usando la norma $L_2$ de las características agrupadas. Éste $z$ es usado por el decodificador para la reconstrución de imagen.

<!--Q: Does group regularization help with grouping similar features?-->
Q: ¿La regularización grupal ayuda a agrupar características similares?

<!--A: The answer is unclear, work done here was done before computational power/ data was readily available. Techniques have not been brought back to the forefront.-->
A: La respuesta no es clara, el trabajo realizado aquí se realizó antes de que la potencia / datos computacionales estuvieran fácilmente disponibles. Las técnicas no se han vuelto a poner en primer plano


<!--## [Image level training, local filters but no weight sharing](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)-->
## [Entrenamiento a nivel de imagen, filtros locales pero sin compartir peso](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)

<!--The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it.-->
La respuesta sobre si ayuda o no, no está clara. Las personas interesadas en esto están interesadas en la restauración de imágenes o en algún tipo de aprendizaje auto supervisado. Esto funcionaría bien cuando el conjunto de datos fuera muy pequeño. Cuando se tiene un codificador y decodificador que es convolucional y se entrena con difusión grupal en celdas complejas, luego de que se termine de pre-entrenar, el sistema se deshace del decodificador y solo usa el codificador como extractor de características, digamos la primera capa de la red convolucional y se le añade una segunda capa encima.

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/></center>
<!--**Fig 3:** Structure of Convolutional RELU with Group Sparsity-->
**Fig 3:** Estructura de una RELU Convolucional con difusión grupal

<!--As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regulariser. This is like L2 pooling with an architecture similar to group sparsity.-->
Como se puede ver arriba, se empieza con una imagen, se tiene un codificador el cuál es basicamente una RELU Convolucional y algún tipo de capa de escala después de este. Se entrena con difusión grupal. Se tiene un decodificador lineal y un criterio que es agrupar por 1. Se toma la difusión grupal como un regularizador. Ésto es como _L2 pooling_ con una arquitectura similar a difusión grupal

<!--You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity.-->
También puedes entrenar otra instancia de ésta red. Ésta vez, puede agregar más capas y tener un decodificador con _L2 pooling_ y criterio de difusión, entrenarlo para reconstruir su entrada con _pooling_ arriba. Ésto va a crear una red convolucional pre-entrenada de 2 capas. Éste procedimiento es también llamado codificador automático apilado (_Stacked Autoencoder_). La característica principal aquí es que está entrenado para producir características invariantes con difusión grupal.

<!--Q : Should we use all possible sub-trees as groups?-->
Q: ¿Deberíamos usar todos los posibles sub-árboles como grupos?

<!--A : It’s up to you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used.-->
A: Eso depende de usted, puede usar múltiples árboles si quieres. Podemos entrenar el árbol con un árbol más grande de lo necesario y luego remover ramas que se usan raramente.

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/></center>
<!--**Fig 4:** Image Level Training, local filters but no weight sharing-->
**Fig 4:** Entrenamiento a nivel de imagen, filtros locales pero no pesos compartidos

<!--These are called pin-wheel patterns. This is a kind of organisation of the features. The orientation varies continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain.-->
Estos son llamados patrones molinillo. Ésto es una especie de organización de las características. La orientación varia continuamente mientras recorres esos puntos rojos. Si tomamos uno de ésos puntos rojos y si hacemos un pequeño círculo alrededor de los puntos rojos, notarás que la orientación del extractor varía continuamente mientras te mueves. Tendencias similares son observadas en el cerebro.

<!--Q : Is the group sparsity term trained to have a small value?-->
Q : ¿Está el término de difusión grupal entrenado para tener un valor pequeño?
 
<!--It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criterion, it determines what the encoder and decoder will do and what sort of features will be extracted.-->
Éste es un regularizador. El término en sí mismo no es entrenado, es fijado. Éste es solo la norma L2 de los grupos y los grupos son predeterminados. Pero, como es un criterio, determina lo que hacen el codificador y decodificador y que clase de  características van a ser extraídas.

<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/></center>
<!--**Fig 5:** Invariant Features through Lateral Inhibition-->
**Fig 5:** Características Invariantes a través de Inhibición Lateral.


<!-- Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix $S$ is either determined by hand or learned so as to maximise this term. If the terms in $S$ are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuroscience). Thus, you try to find a value for $S$ that is as large as possible.-->
Aquí, hay un decodificador lineal con error de reconstrución cuadrático. Hay un criterio en la energía. La matriz $S$ está determinada a mano o se aprende para maximizar éste término. Si los términos en $S$ son positivos y grandes, ello implica que el sistema no quiere $z_i$ y $z_j$ estén al mismo tiempos. En consecuencia, ésta especia de inhibición mutua (llamada inhibición natural en neurociencia). Así, estás intentando encontrar un valor para $S$ que es tan grande como es posible.

<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
<!--**Fig 6:** Invariant Features through Lateral Inhibition (Tree Form)-->
**Fig 6:** Características Invariantes a través de Inhibición Lateral (Forma de Árbol)

<!--If you organise S in terms of a tree, the lines represent the zero terms in the $S$ matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features except those which are up the tree or down the tree from it. This is something like the converse of group sparsity.-->
Si usted organiza S en términos de un árbol, las líneas representan los términos cero en la matriz $S$. Cuando usted no tiene una línea, existe un término no-cero. Entonces, cada característica inhibe todas las otras características exceptuando aquellas que están arriba del árbol o abajo del árbol de él. Ésto es algo así como lo opuesto a la difusión grupal.


<!--You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition.-->
Verá nuevamente que los sistemas están organizando características de una manera más o menos continua. Las características a lo largo de la rama de un árbol representan la misma característica con diferentes niveles de selectividad. Las características a lo largo de la periferia varían de forma más o menos continua porque no hay inhibición.

<!--To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger.-->
Para entrenar éste sistema, en cada iteración, usted da un $x$ y encuentra la $z$ que minimiza ésta función de energía. Luego da un paso de descenso de gradiente para actualizar $W$. También puedes hacer un paso de ascenso de gradiente  para hacer los términos en $S$ más grandes. 
