---
lang-ref: ch.08-3
title: Modelos Generativos - Auto-encodificadores Variacionales
lecturer: Alfredo Canziani
authors: Richard Pang, Aja Klevs, Hsin-Rung Chou, Mrinal Jain
date: 24 March 2020
lang: es
translation-date: 21 Sep 2020
translator: Victor Peñaloza
---

<!--### [Recap: Auto-encoder (AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)-->
### [Recapitulación: Auto-encodificador <sup>Auto-encoder</sup>(AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)

<!--To summarize at a high level, a very simple form of AE is as follows:-->
En resumen, a alto nivel, en una forma muy simple un AE es de la siguiente manera:
<!--- First, the autoencoder takes in an input and maps it to a hidden state through an affine transformation $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, where $f$ is an (element-wise) activation function. This is the **encoder** stage. Note that $\boldsymbol{h}$ is also called the **code**.-->

- Primero, el auto-encodificador<sup>auto-encoder</sup> toma una entrada y la hace corresponder con un estado oculto a través de una transformación afín $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, donde $f$ es una función de activación (entre elementos). Esta es la etapa de **encodificación**. Note que $\boldsymbol{h}$ es también llamado el **código**.
<!--- Next, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, where $g$ is an activation function. This is the **decoder** stage.-->
- Después, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}x \boldsymbol{h} + \boldsymbol{b}x)$, donde $g$ es una función de activación. Esta es la etapa de **decodificación**.
<!--*For a detailed explaination, refer to the notes of [Week 7]({{site.baseurl}}/en/week07/07-3/).*-->

*Para una explicación detallada, consulte las notas de la [Semana 7]({{site.baseurl}}/es/week07/07-3/).*


<!--### Intuition behind VAE and a comparison with classic autoencoders-->
### Intuición atrás de VAE y una comparación con los auto-encodificadores clásicos

<!--Next, we introduce Variational Autoencoders (or VAE), a type of generative models. But why do we even care about generative models? To answer the question, discriminative models learn to make predictions given some observations, but generative models aim to simulate the data generation process. One effect is that generative models can better understand the underlying causal relations which leads to better generalization.-->
Presentamos los Auto-encodificadores Variacionales (VAE), un tipo de modelos generativos. Pero, ¿por qué debemos interesarnos sobre modelos generativos? Para responder esta pregunta, los modelos discriminativos aprenden a realizar predicciones dadas algunas observaciones, pero los modelos generativos apuntan a simular el proceso de generación de datos. En consecuencia, los modelos generativos pueden entender mejor las relaciones casuales subyacentes que llevan a una mejor generalización.

<!--Note that although VAE has "Autoencoders" (AE) in its name (because of structural or architectural similarity to auto-encoders), the formulations between VAEs and AEs are very different. See *Figure 1* below.-->
Note que, aunque VAE tiene "Auto-encodificadores" (AE) en su nombre (debido a la similitud estructural a los auto-encodificadores), las formulaciones entre VAEs y AEs son muy diferentes. Ver la *Figura 1* abajo.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Fig. 1</b>: VAE *vs.* Classic AE
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Fig. 1</b>: VAE *vs.* AE Clásico.
</center>

<!--**What's the difference between variational auto-encoder (VAE) and classic auto-encoder (AE)?**-->
**¿Cuál es la diferencia entre un auto-encodificador variacional (VAE) y un auto-encodificador clásico (AE)?**

<!--For VAE:-->
Para VAE:
<!-- - First, the encoder stage: we pass the input $\boldsymbol{x}$ to the encoder. Instead of generating a hidden representation $\boldsymbol{h}$ (the code) in AE, the code in VAE comprises two things: $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ where $\boldsymbol{z}$ is the latent random variable following a Gaussian distribution with mean $\mathbb{E}(\boldsymbol{z})$ and variance $\mathbb{V}(\boldsymbol{z})$. Note that people use Gaussian distributions as the encoded distribution in practice, but other distributions can be used as well.-->
- Primero, la etapa de encodificación: pasamos la entrada $\boldsymbol{x}$ al encodificador. En lugar de generar una representación oculta $\boldsymbol{h}$ (the code) en el AE, el código en el Auto-encodifcador variacional (VAE) está formado por dos cosas:
$\mathbb{E}(\boldsymbol{z})$ y $\mathbb{V}(\boldsymbol{z})$ donde $\boldsymbol{z}$ es la variable aleatoria latente que sigue una distribución Gaussiana con media $\mathbb{E}(\boldsymbol{z})$ y varianza $\mathbb{V}(\boldsymbol{z})$. Note que las personas en la práctica utilizan distribuciones Gaussianas como la distribución encodificada, pero otras distribuciones también pueden ser utilizadas.
<!--    - The encoder will be a function from $\mathcal{X}$ to $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (here we use $\boldsymbol{h}$ to represent the concatenation of $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$).-->
   - El encodificador será una función de $\mathcal{X}$ a  $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (aquí usamos $\boldsymbol{h}$ para representar la concatenación de $\mathbb{E}(\boldsymbol{z})$ y $\mathbb{V}(\boldsymbol{z})$).
<!-- - Next, we will sample $\boldsymbol{z}$ from the above distribution parametrized by the encoder; specifically, $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ are passed into a **sampler** to generate the latent variable $\boldsymbol{z}$.-->
- Después, muestreamos $\boldsymbol{z}$ de la distribución anterior parametrizada por el encodificador; específicamente, $\mathbb{E}(\boldsymbol{z})$ y $\mathbb{V}(\boldsymbol{z})$ son pasados dentro de un **muestrador** para generar la variable latente $\boldsymbol{z}$.
<!-- - Next, $\boldsymbol{z}$ is passed into the decoder to generate $\hat{\boldsymbol{x}}$.-->
- Después, $\boldsymbol{z}$ es pasado en el decodificador para generar $\hat{\boldsymbol{x}}$.
<!--    - The decoder will be a function from $\mathcal{Z}$ to $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.-->
   - El decodificador será una función de $\mathcal{Z}$ hacia $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.

<!--In fact, for classic autoencoder, we can think of $\boldsymbol{h}$ as just the vector $\E(\boldsymbol{z})$ in the VAE formulation. In short, the main difference between VAEs and AEs is that VAEs have a good latent space that enables generative process.-->
En realidad, para el auto-encodificador clásico, podemos pensar en $\boldsymbol{h}$ justamente como el vector $\E(\boldsymbol{z})$ en la formulación de auto-codificador variacional VAE. En resumen, la principal diferencia entre VAEs y AEs es que los VAEs tienen un buen espacio latente que hace posible un proceso generativo.


<!--### The VAE objective (loss) function-->
### La función objetivo(perdida) de un VAE

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Fig. 2</b>: Mapping from input space to latent space
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Fig. 2</b>: Mapeo del espacio de entrada a un espacio latente.
</center>
<!--*See Figure 2 above. For now, ignore the top-right corner (which is the reparameterisation trick explained in the next section).*-->
*Observe la Figura 2 arriba. Por ahora, ignore la esquina superior derecha (la cual es el truco de re-parametrización explicado en la sección siguiente).*

<!--First, we encode from input space (left) to latent space (right), through encoder and noise. Next, we decode from latent space (right) to output space (left). To go from the latent to input space (the generative process) we will need to either learn the distribution (of the latent code) or enforce some structure. In our case, VAE enforces some structure to the latent space.-->
Primero, encodificamos desde el espacio de entrada(izquierda) hacia el espacio latente(derecha), a través del encodificador y ruido. Siguiente, decodificamos desde el espacio latente (derecha) hacia el espacio de salida (izquierda). Para ir desde el espacio latente hacia el espacio de entrada (el proceso generativo) necesitamos ya sea aprender la distribución (del código latente) o reforzar alguna estructura. En nuestro caso, VAE refuerza alguna estructura al espacio latente.

<!--As usual, to train VAE, we minimize a loss function. The loss function is therefore composed of a reconstruction term as well as a regularization term.-->
Como es usual, para entrenar un VAE, minimizamos una función de perdida. Por lo tanto, La función de perdida está compuesta por un término de reconstrucción y también un término de regularización.
<!--- The reconstruction term is on the final layer (left side of the figure). This corresponds to $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ in the figure.-->
- El término de reconstrucción está en la capa final (lado izquierdo de la figura). Esto corresponde a $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ en la figura.
<!--- The regularization term is on the latent layer, to enforce some specific Gaussian structure on the latent space (right side of the figure). We do so by using a penalty term $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. Without this term, VAE will act like a classic autoencoder, which may lead to overfitting, and we won't have the generative properties that we desire.-->
- El término de regularización está en la capa latente, para reforzar alguna estructura Gaussiana especifica en el espacio latente (lado derecho de la figura). Hacemos esto utilizando un término de penalización $l{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}d))$. Sin este término, un VAE actuara como un auto-encodificador clásico, lo cual puede llevar a sobreajuste y no tendremos las propiedades generativas que nosotros deseamos.


<!--### Discussion on sampling $\boldsymbol{z}$ (**reparameterisation trick**)-->
### Discusión sobre el muestreo de $\boldsymbol{z}$ (**truco de re-parametrización**)

<!--How do we sample from the distribution returned by the encoder in VAE? According to above, we sample from the Gaussian distribution, in order to obtain $\boldsymbol{z}$. However, this is problematic, because when we do gradient descent to train the VAE model, we don't know how to do backpropagation through the sampling module.-->
¿Como muestreamos de la distribución entregada por el encodificador en un VAE? De acuerdo a lo anterior, nosotros muestreamos desde la distribución Gaussiana, para obtener $\boldsymbol{z}$. Sin embargo, esto es problemático, debido a que cuando realizamos el algoritmo de gradiente descendiente para entrenar el modelo VAE, no sabemos cómo realizar retro-propagación a través del módulo de muestreo.

<!--Instead, we use the **reparameterization trick** to "sample" $\boldsymbol{z}$. We use $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ where $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. In this case, backpropagation in training is possible. Specifically, the gradients will go through the (element-wise) multiplication and addition in the above equation.-->
En lugar de eso, utilizamos el **truco de re-parametrización** para "muestrear" $\boldsymbol{z}$. Utilizamos $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ donde $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. En este caso, la retro-propagación en el entrenamiento es posible. Específicamente, las gradientes pasaran a través de la multiplicación y adición (entre elementos) en la ecuación de arriba.


<!--## [Breaking apart the VAE Loss Function](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)-->
## [Descomposición de la función de pérdida de un VAE](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)


<!--### Visualizing Latent Variable Estimates and Reconstruction Loss-->
### Visualizando estimaciones de la variable latente y pérdida de reconstrucción

<!--As stated above, the loss function for the VAE contains two parts: a reconstruction term and a regularization term.  We can write this as-->
Como se indicó anteriormente, la función de perdida para un VAE contiene dos partes: un término de reconstrucción y un término de regularización. Podemos escribir eso como:

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = l_{reconstruction} + \beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d))
$$

<!--To visualize the purpose of each term in the loss function, we can think of each estimated $\boldsymbol{z}$ value as a circle in $2d$ space, where the centre of the circle is $\mathbb{E}(\boldsymbol{z})$ and the surrounding area are the possible values of $\boldsymbol{z}$ determined by $\mathbb{V}(\boldsymbol{z}).$-->
Para visualizar el propósito de cada termino en la función de perdida, podemos pensar en cada valor estimado $\boldsymbol{z}$ como un círculo en un espacio $2d$, donde el centro del circulo es $\mathbb{E}(\boldsymbol{z})$ y el área alrededor son los posibles valores de $\boldsymbol{z}$ determinados por $\mathbb{V}(\boldsymbol{z}).$

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Fig. 3</b>: Visualizing vector $z$ as bubbles in the latent space
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Fig. 3</b>: Visualizando el vector $z$ como burbujas en el espacio latente.
</center>

<!--*In Figure 3 above, each bubble represents an estimated region of $\boldsymbol{z}$, and the arrows represent how the reconstruction term pushes each estimated value away from the others, which is explained more below.*-->
*En la Figura 3 de arriba, cada burbuja representa una región estimada de $\boldsymbol{z}$, y las flechas representan como el termino de reconstrucción empuja lejos de los otros cada valor estimado, lo cual es explicado más adelante.*

<!--If there is overlap between any two estimates of $z$, (visually, if two bubbles overlap) this creates ambiguity for reconstruction because the points in the overlap can be mapped to both original inputs. Therefore the reconstruction loss will push the points away from one another.-->
Si hay un traslape entre dos estimados cualquiera de $z$, (visualmente, si dos burbujas se traslapan) esto crea ambigüedad para la reconstrucción debido a que ambos puntos en el traslape pueden ser mapeados a la misma entrada original. Por lo tanto, la pérdida de reconstrucción empujara los puntos lejos uno de otro.

<!--However, if we use just the reconstruction loss, the estimates will continue to be pushed away from each other and the system could blow up.  This is where the penalty term comes in.-->
Sin embargo, si utilizamos solamente la pérdida de reconstrucción, los estimados continuarán siendo empujados lejos uno de otro y el sistema podría explotar. Aquí es donde el termino de penalización entra en juego.

<!--**Note:** for binary inputs the reconstruction loss is-->
**Nota:** Para entradas binarias la pérdida de reconstrucción es: 

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = - \sum\limits_{i=1}^n [x_i \log{(\hat{x_i})} + (1 - x_i)\log{(1-\hat{x_i})}]
$$

<!--and for real valued inputs the reconstruction loss is-->
Y para entradas de valores reales la pérdida de reconstrucción es:

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = \frac{1}{2} \Vert\boldsymbol{x} - \hat{\boldsymbol{x}} \Vert^2
$$


<!--### The penalty term-->
### El término de penalización

<!--The second term is the relative entropy (a measure of the distance between two distributions) between $\boldsymbol{z}$ which comes from a Gaussian with mean $\mathbb{E}(\boldsymbol{z})$, variance $\mathbb{V}(\boldsymbol{z})$ and the standard normal distribution. If we expand this second term in the VAE loss function we get:-->
El segundo término es la entropía relativa (una medida de distancia entre dos distribuciones) entre $\boldsymbol{z}$ la cual viene de una distribución Gaussiana con media $\mathbb{E}(\boldsymbol{z})$, varianza $\mathbb{V}(\boldsymbol{z})$ y la distribución normal estándar. Si expandimos este segundo término en la función de pérdida del VAE obtenemos:

$$
\beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d)) = \frac{\beta}{2} \sum\limits_{i=1}^d(\mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1 + \mathbb{E}(z_i)^2)
$$

<!--Where each expression in the summation has four terms. Below we write out and graph the first three terms in *Figure 4*.-->
Donde cada expresión en la sumatoria tiene cuatro términos. Abajo en la *Figura 4* escribimos y graficamos los primeros tres términos.

$$
v_i = \mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1
$$

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Fig. 4</b>: Plot showing how relative entropy forces the bubbles to have variance = 1
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Fig. 4</b>: Gráfico mostrando como la entropía relativa fuerza a las burbujas para tener una varianza = 1.
</center>
<!--So we can see that this expression is minimized when $z_i$ has variance 1.  Therefore our penalty loss will keep the variance of our estimated latent variables at around 1.  Visually, this means our "bubbles" from above will have a radius of around 1.-->
Así podemos ver que esta expresión es minimizada cuando $z_i$ tiene varianza 1. Por lo tanto, nuestra pérdida de penalización mantendrá la varianza de nuestras variables latentes estimadas cerca de 1. Visualmente, esto significa que nuestras "burbujas" de arriba tendrán un radio cercano a 1.

<!--The last term, $\mathbb{E}(z_i)^2$, minimizes the distance between the $z_i$ and therefore prevents the "exploding" encouraged by the reconstruction term.-->
El ultimo término, $\mathbb{E}(z_i)^2$, minimiza la distancia entre $z_i$ y por lo tanto previene la "explosión" impulsada por el término de reconstrucción.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Fig. 5</b>: The "bubble-of-bubble" interpretation of VAE
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Fig. 5</b>: La interpretación "burbuja-de-burbujas" de un VAE
</center>

<!--*Figure 5 above shows how VAE loss pushed the estimated latent variables as close together as possible without any overlap while keeping the estimated variance of each point around one.*-->
*La figura 5 de arriba muestra como la pérdida de un VAE empuja las variables latentes estimadas lo más cercano posible sin algún traslape, manteniendo así la varianza estimada de cada punto cerca a uno.*

<!--**Note:** The $\beta$ in the VAE loss function is a hyperparameter that dictates how to weight the reconstruction and penalty terms.-->
**Nota:** El $\beta$ en la función de pérdida del VAE es un hiper-parámetro que dicta como ponderar los términos de penalización y reconstrucción.


<!--## [Implementation of Variational Autoencoder (VAE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)-->
## [Implementación de un Auto-encodificador Variacional (VAE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)

<!--The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb).-->
El Jupyter Notebook puede ser encontrado [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb).

<!--In this notebook, we implement a VAE and train it on the MNIST dataset. Then we sample $\boldsymbol{z}$ from a normal distribution and feed to the decoder and compare the result. Finally, we look at how $\boldsymbol{z}$ changes in 2D projection.-->
En este Jupyter Notebook, implementamos un VAE y lo entrenamos en el conjunto de datos MNIST. Después muestreamos $\boldsymbol{z}$ de una distribución normal y alimentamos el decodificador y comparamos el resultado. Finalmente, observamos como cambia $\boldsymbol{z}$ en una proyección 2D.

<!--**Note:** In the MNIST dataset used, the pixel values have been normalized to be in range $[0, 1]$.-->
**Nota:** En el conjunto de datos usado MNIST, los valores de los píxeles fueron normalizados para estar en el rango de $[0, 1]$.


<!--### The Encoder and the Decoder-->
### El Encodificador y el Decodificador

<!--1. We define the encoder and decoder in our `VAE` module.-->
<!--2. For the last linear layer of encoder, we define the output to be of size $2d$, of which the first $d$ values are the means and the remaining $d$ values are the variances. We sample $\boldsymbol{z} \in R^d$ using these means and variances as explained in the reparameterisation trick before.-->
<!--3. For the last linear layer in the decoder, we use the sigmoid activation so that we can have output in range $[0, 1]$, similar to the input data.-->
1.	Definimos el encodificador y el decodificador en nuestro módulo `VAE`.
2.	Para la última capa lineal del encodificador, definimos el tamaño de la salida para que sea $2d$, de la cual los primeros valores $d$ son las medias y valores los restantes $d$ son las varianzas. Muestreamos $\boldsymbol{z} \in R^d$ usando estas medias y varianzas como fue explicado anteriormente en el truco de re-parametrización.
3.	Para la última capa lineal en el decodificador, utilizamos la activación sigmoide para que podamos tener una salida en el rango $[0, 1]$, similar a los datos de entrada.

```python
class VAE(nn.Module):
    def __init__(self):
        super().__init__()

        self.encoder = nn.Sequential(
            nn.Linear(784, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, d * 2)
        )

        self.decoder = nn.Sequential(
            nn.Linear(d, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, 784),
            nn.Sigmoid(),
        )
```


<!--### Reparameterisation and the `forward` function-->
### Re-parametrización y la función hacia `adelante` <sup>foward</sup>

<!--For the `reparameterise` function, if the model is in training mode, we compute the standard deviation (`std`) from log variance (`logvar`). We use log variance instead of variance because we want to make sure the variance is non-negative, and taking the log of it ensures that we have the full range of the variance, which makes the training more stable.-->
Para la función `reparametrise`, si el modelo está en modo de entrenamiento, calculamos la desviación estándar (`std`) del logaritmo de la varianza (`logvar`). Utilizamos el logaritmo de la varianza en lugar de la varianza porque queremos asegurarnos que la varianza es no-negativa, y tomar el logaritmo de ella nos asegura que obtendremos el rango completo de la varianza, lo cual hace que el entrenamiento sea más estable.

<!--During training, the `reparameterise` function will do the reparameterisation trick so that we can do backpropagation in training. To connect to the concept of a yellow bubble, as explained in the lecture, every time this function is called, we draw a point `eps = std.data.new(std.size()).normal_()`, so if we do 100 times, we will get 100 points which roughly forms a sphere because it's normal distribution, and the line `eps.mul(std).add_(mu)` will make this sphere centred in `mu` with radius equal to `std`.-->
Durante el entrenamiento, la función `reparametrise` realizará el truco de re-parametrización para que podamos realizar la retro-progragación en el entrenamiento. Para conectar con el concepto de una burbuja amarilla, como fue explicado en la lección, cada vez que esta función es llamada, dibujamos un punto `eps = std.data.new(std.size()).normal_()`, si realizamos esto 100 veces, obtendremos 100 puntos los cuales aproximadamente forman una esfera debido a que es una distribución normal, y la línea `eps.mul(std).add_(mu)` formará esta esfera centrada en `mu` con un radio igual a `std`. 

<!--For the `forward` function, we first compute the `mu` (first half) and `logvar` (second half) from the encoder, then we compute the $\boldsymbol{z}$ via the `reparamterise` function. Finally, we return the output of the decoder.-->
Para la función `forward`, primero calculamos `mu`, (primera mitad) y `logvar` (segunda mitad) obtenidas del encodificador, después calculamos $\boldsymbol{z}$ por medio de la función `reparamterise`. Finalmente, devolvemos la salida del decodificador.

```python
def reparameterise(self, mu, logvar):
    if self.training:
        std = logvar.mul(0.5).exp_()
        eps = std.data.new(std.size()).normal_()
        return eps.mul(std).add_(mu)
    else:
        return mu

def forward(self, x):
    mu_logvar = self.encoder(x.view(-1, 784)).view(-1, 2, d)
    mu = mu_logvar[:, 0, :]
    logvar = mu_logvar[:, 1, :]
    z = self.reparameterise(mu, logvar)
    return self.decoder(z), mu, logvar
```


<!--### Loss function for the VAE-->
### Función de pérdida para el VAE

<!--Here we define the reconstruction loss (binary cross entropy) and the relative entropy (KL divergence penalty).-->
Aquí definimos la reconstrucción de perdida (entropía cruzada binaria <sup> binary cross entropy </sup> y la entropía relativa (penalización de divergencia KL).

```python
def loss_function(x_hat, x, mu, logvar):
    BCE = nn.functional.binary_cross_entropy(
        x_hat, x.view(-1, 784), reduction='sum'
    )
    KLD = 0.5 * torch.sum(logvar.exp() - logvar - 1 + mu.pow(2))

    return BCE + KLD
```


<!--### Generating new samples-->
### Generando nuevas muestras

<!--After we train our model, we can sample a random $z$ from the normal distribution and feed it to our decoder. We can observe in *Figure 6* that some of the results are not good because our decoder has not "covered" the whole latent space. This can be improved if we train the model for more epochs.-->
Después de entrenar nuestro modelo, podemos muestrear un $z$ aleatorio desde la distribución normal y alimentar nuestro decodificador con él. Podemos observar en la *Figura 6* que algunos de los resultados no son buenos debido a que nuestro decodificador no ha "cubierto" el espacio latente completamente. Esto puede ser mejorado si entrenamos el modelo por más épocas.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Fig. 6</b>: Randomly moving in the latent space
</center>-->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Fig. 6</b>: Moviéndose aleatoriamente en el espacio latente.
</center>

<!--We can look at how one digit morphs into another, which would not have been possible if we used an autoencoder. We can see that when we walk in the latent space, the output of the decoder still looks legit. *Figure 7* below shows how we morph the digit $3$ to $8$.-->
Podemos ver como un dígito se transforma en otro, lo cual no sería posible si hubiéramos utilizado un auto-encodificador. Podemos ver que cuando caminamos en el espacio latente, la salida del decodificador aun parece legitima. La *Figura 7* de abajo muestra como transformamos el dígito $3$ a $8$.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: Morphing the digit 3 into 8
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: Transformando el dígito 3 en 8.
</center>


<!--### Projection of means-->
### Proyección de medias

<!--Finally, let's take a look at how the latent space changes during/after training. The following charts in *Figure 8* are the means from the output of the encoder, projected on 2D space, where each colour represents a digit. We can see that from epoch 0, the classes are spreading everywhere, with only little concentration. As the model is trained, the latent space becomes more well-defined and the classes (digits) starts to form clusters.-->
Finalmente, echemos un vistazo a como el espacio latente cambia durante/después del entrenamiento. Los siguientes gráficos en la *Figura 8* son las medias de la salida del encodificador, proyectadas en un espacio 2D, donde cada color representa un dígito. Podemos ver que en la época 0, las clases están dispersas en todos lados, solamente con una pequeña concentración. Conforme el modelo es entrenado, el espacio latente se vuelve mejor definido y las clases(dígitos) inician a formar grupos.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Fig. 8</b>: 2D projection of the means $\E(\vect{z})$ in latent space
</center>-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Fig. 8</b>: Proyección 2D de las medias $\E(\vect{z})$ en el espacio latente.
</center>
