---
lang-ref: ch.08-2
lang: es
lecturer: Yann LeCun
title: Modelos basados en energía de variables latentes regularizadas
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 8 Aug 2020
translator: mvortizr
---


<!--## [Regularized latent variable EBMs](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)-->
## [Modelos basados en energía de variables latentes regularizadas.](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

<!--Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables:-->
Los modelos con variables latentes son capaces de hacer una distribución de predicciones $\overline{y}$ condicionadas en una entrada observada $x$ y una *variable latente* adicional $z$. Los modelos basados en energía pueden también contener variables latentes:

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<!--<b>Fig. 1</b>: Example of an EBM with a latent variable-->
<b>Fig. 1</b>: Ejemplo de un EBM (modelo basado en energía) con una variable latente.
</center>

<!-- See the previous lecture's notes for more details. -->
Ver notas de lecciones pasadas para más detalles

<!--Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference.-->
Desafortunadamente, si la variable latente $z$ tiene mucho poder expresivo en producir una predicción final $\overline{y}$, cada salida verdadera $y$ va a ser perferctamente reconstruida desde la entrada $x$ con una $z$ apropiadamente elegida. Esto significa que la función de energía será 0 en todas partes, ya que la energía es optimizada sobre ambas $y$ y $z$ durante inferencia.

<!--A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable:-->
Una solución natural es limitar la capacidad de información de la variable latente $z$. Una forma de hacer esto es regularizar la  variable latente

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

<!--This method will limit the volume of space of $z$ which takes a small value and the value which will, in turn, controls the space of $y$ that has low energy. The value of $\lambda$ controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE).-->

Este método va a limitar el volumen de espacio de $z$ que toma un valor pequeño y el valor que, a su vez, controlará el espacio de $y$ que tiene energía baja. El valor de $\lambda$ controla esta compensación. Un ejemplo útil de $R$ es la norma $L_1$, que a su vez puede ser vista como una aproximación diferenciable de dimension efectiva en casi todas partes. Agregar ruido a $z$ mientras se limita su norma $L_2$ puede también limitar el contenido de su información (VAE).


<!--### Sparse Coding-->
### Codificación esparcida (_Sparse Coding_)

<!--Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function.-->
La codificación esparcida es un ejemplo de un EBM (modelo basado en energía) de variable latente regularizada el cual esencialmente intenta aproximar los datos con una función lineal a trozos

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

<!--The $n$-dimensional vector $z$ will tend to have a maximum number of non-zero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$.-->

El vector $n$-dimensional va a tender a tener un máximo número de componentes no-cero $m << n$. Luego cada $Wz$ será de elementos en la extensión de $m$ columnas de $W$

<!--After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero.-->

Luego de cada paso de optimización, la matriz $W$ y la variable latente $z$ son normalizadas por la suma de las normas $L_2$  de las columnas de $W$. Ésto asegura que $W$ y $z$ no diverjan al infinito y cero.


### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<!--<b>Fig. 2</b>: FISTA computation graph-->
<b>Fig. 2</b>: Grafo computacional FISTA 
</center>

<!--FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule:-->

FISTA (ISTA rápido, por sus siglas en inglés) es un algoritmo que optimiza la función de energía de la codificación esparcida $E(y,z)$ con respecto a $z$ a través de alternadamente optimizar los dos términos $\Vert y - Wz\Vert^2$ y $\lambda \Vert z\Vert_{L^1}$. Inicializamos $Z(0)$ e iterativamente actualizamos $Z$ de acuerdo con la siguiente regla:

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

<!--The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term.-->

La expresión interna $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ es un paso de gradiente por el término $\Vert y - Wz\Vert^2$. La función $\text{Shrinkage}$ cambia los valores hacia 0, lo cual optimiza el término $\lambda \Vert z\Vert_{L_1}$. 


### LISTA

<!--FISTA is too expensive to apply to large sets of high-dimensional data (*e.g.* images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$:-->

FISTA es muy costoso para ser aplicado en conjuntos largos de data de alta dimensión (*e.j.* imágenes). Una manera de hacerlo más eficiente es  entrenar una red para predecir el valor óptimo de la variable latente $z$:

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<!--<b>Fig. 3</b>: EBM with latent variable encoder-->
<b>Fig. 3</b>: EBM (Modelo basado en energía)  con un codificador de variable latente
</center>

<!--The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$:-->
La energía de ésta arquitectura incluye un término adicional que mide la diferencia entre la variable latente predecida $\overline z$ y la variable latente óptima $z$:

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

<!--We can further define-->
Podemos definir aún más

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

<!--and then write-->
y luego escribir

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

<!--This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm.-->
Ésta regla de actualización puede ser interpretada como una red recurrente, lo que sugiere que en su lugar podemos aprender los parámetros $W_e$ que iterativamente determinan la variable latente $z$. La red es manejada por un número fijo de pasos de tiempo $K$ y los gradientes de $W_e$ se computan usando la estándar propagación hacia atrás a través del tiempo. La red entrenada luego produce un buen $z$  en menos iteraciones que el algoritmo FISTA.  

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<!--<b>Fig. 4</b>: LISTA as a recurrent net unfolded through time.-->
<b>Fig. 4</b>: LISTA como una red recurrente desplegada a través del tiempo 
</center>


<!--### Sparse coding examples-->
### Ejemplos de codificación esparcida


<!--When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes.-->
Cuando un sistema de codificación esparcida con vectores latentes de 256 dimensiones es aplicado a los números escritos a mano MNIST, el sistema aprende un conjunto de 256 trazos que pueden ser linearmente combinados para reproducir casi todo el conjunto de entrenamiento. El regularizador de esparcimiento asegura que puedan ser reproducidos desde un número de trazos pequeño.
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<!--<b>Fig. 5</b>: Sparse coding on MNIST. Each image is a learned column of $W$.-->
<b>Fig. 5</b>: Codificación esparcida en MNIST. Cada imagen es una columna aprendida de  $W$.
</center>

<!--When a sparse coding system is trained on natural image patches, the learned features are Gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems.-->
Cuando un sistema de codificación esparcido es entrenado en parches de imágenes naturales, las características (_features_) aprendidas son filtros Gabor, que tienen  bordes orientados. Éstas caracteristicas aprenddidas se asemejan a las aprendidas en las primeras partes de los sistemas visuales animales. 


<!--### [Convolutional sparse coding](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)-->
### [Codificación esparcida convolucional](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

<!--Suppose, we have an image and the feature maps ($z_1, z_2, \cdots, z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as:-->
Supongamos que tenemos una imagen y los mapas de características (_feature maps_, $z_1, z_2, \cdots, z_n$) de la imagen. Entonces podemos convolucionar ($*$) cada uno de los mapas de características con el kernel $K_i$. Luego la reconstrucción puede ser simplemente calculada como:

$$Y=\sum_{i}K_i*Z_i$$

<!--This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results.-->
Ésto es diferente de la codificación esparcida original donde la reconstrucción fue hecha como $Y=\sum_{i}W_iZ_i$. En la codificación esparcida regular, tenemos una suma ponderada de columnas donde los pesos son coeficientes de $Z_i$. En la codificación convolucional esparcida, esto es todavía una operación lineal pero el diccionario matriz es ahora un conjunto de mapas de características que pueden convolucionar cada mapa de característica con cada kernel y sumar los resultados. 


<!--#### Convolutional sparse auto-encoder on natural images-->
#### Auto-codificador convolucional esparcido en imágenes natirales

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<!--<b>Fig.6</b> Filters and Basis Functions obtained. Linear convolutional decoder-->
<b>Fig.6</b> Fitros y funciones Bases obtenidas. Decodificador lineal convolucional
</center>

<!--The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error.-->
Los fitros en el codificador y decodificador lucen muy similares. El codificador es simplemente una convolución seguida de alguna no-linealidad y luego una capa diagonal para cambiar la escala. Luego hay escasez en las restricciones del código. El decodificador es solo un decodificador convolucional lineal y la reconstrucción aquí es el error cuadrático.

<!--So, if we impose that there is only one filter then it is just a centre surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centres around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centres around, etc.-->

Entonces, si imponemos que hay un solo filtro entonces entonces es solo un filtro de tipo envolvente central. Con dos filtros, podemos obtener algunos filtros de formas extrañas. Con cuatro filtros, obtenemos bordes orientados (horizontales y verticales); obtenemos 2 polaridades para cada uno de los filtros. Con ocho filtros podemos obtener bordes orientados en ocho direcciones diferentes. Con 16, obtenemos más orientación  junto con los centros alrededor. Mientras vamos incrementando los filtros, obtenemos filtros más diversos además de los detectores de bordes, también obtenemos detectores de rejilla de varias orientaciones, centros alrededor, etc.

<!--This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way.-->

Éste fenómeno parece ser interesante ya que es similar a lo que observamos en la corteza visual. Entonces ésto es una indicación de que podemos aprender buenas características (_features_) en un modo completamente no supervisado. 


<!--As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features.-->
Como uso secundario, si tomamos estas características y las conectamos en una red convolucional y luego la entrenamos en alguna tarea, no necesariamente tendremos mejores resultados que entrenar una red de imágenes desde cero. Sin embargo, existen algunas instancias donde puede ayudar a impulsar el rendimiento. Por ejemplo, en casos donde el número de ejemplos no es lo suficientemente largo o hay pocas categorías, al entrenarlo en una manera puramente supervisada, obtenemos características degeneradas

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<!--<b>Fig. 7 </b> Convolutional sparse encoding on colour image-->
<b>Fig. 7 </b> Codificación convolucional esparcida en una imagen a color
</center>

<!--The figure above is another example on colour images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-grey).-->
La figura anterior es otro ejemplo de imágenes a color. El kernel codificador (del lado derecho) es de tamaño 9 por 9. Éste kernel es aplicado convolucionalmente sobre toda la imagen. La imagen a la izquierda es de los códigos esparcidos del codificador. El vector $Z$ es un espacio muy esparcido donde existen sólo unos pocos componentes que son blanco o negro (no gris).


<!--### [Variational autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)-->
### Auto-codificador variable (__Varational autoencoder__)

<!--Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy.-->

Los auto-codificadores variables tienen una arquitectura similar a los EBM de variables latentes regularizadas, con la excepción del esparcimiento. Por lo contrario, la información contenida del código es limitada al hacerlo ruidoso.

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<!--<b>Fig. 8</b>: Architecture of Variational Autoencoder-->
<b>Fig. 8</b>: Arquitectura de un auto-codificador variable.
</center>

<!--The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$.-->
La variable latente $z$ no es computada a través de minimizar la función de energía con respecto a $z$. Por lo contrario, la función de energía es vista como un muestreo aleatorio $z$ de acuerdo a la distribución cual logaritmo es el costo que la conecta a ${\overline z}$. La distribución es Gaussiana con media ${\overline z}$ y esto resulta en un ruido Gaussiano que es agregado a ${\overline z}$.

<!--The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 9(a).-->
Los vectores de código con un ruido Gaussiano agregado pueden ser visualizados como esferas difusas como se muestra en la Fig. 9(a).

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><!--<br>(a) Original set of fuzzy balls </center>--> <br>(a) Conjunto original de esferas difusas </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/> <!--<br>(b) Movement of fuzzy balls due to energy minimization without regularization</center>-->  <br>(b)Movimiento de las esferas difusas debido a la minimización de energía sin regularización</center> |

<!--<center><b>Fig. 9:</b> Effect of energy minimization on fuzzy balls</center>-->
<center><b>Fig. 9:</b> Efecto de la minimización de energía en esferas difusas </center>

<!--The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 9(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction.-->

El sistema intenta hacer los vectores de código ${\overline z}$ tan largos como sea posible para que el efecto en $z$(ruido) sea tan pequeño como sea posible. Ésto resulta en esferas difusas flotando desde el origen como se muestra en la Fig. 9(b). Otra razón por la cual el sistema intenta hacer los vectores de código grandes es para prevenir las esferas difusas superpuestas, lo que causa que el decodificador se confunda entre diferentes muestras durante reconstrucción.

<!--But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 10.-->
Pero queremos que las besferas difusas se agrupen alrededor de una variedad de datos, si existen. Entonces, los vectores de códigos son regularizados para tener una media y varianza cercana a cero. Para hacer ésto, los conectamos con el origen usando un resorte como se muestra en la Fig. 10.


<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<!--<b>Fig. 10</b>: Effects of regularization visualized with springs-->
b>Fig. 10</b>: Efectos de la regularización visualizados con resortes
</center>

<!--The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar.-->
La fuerza del resorte determina que tan cerca las esferas difusas están del origen. Si el resorte es muy débil, entonces las esferas difusas volarían fuera del origen. Si es muy fuerte, entonces colapsarían al origen, resultando en un valor de energía alto. Para prevenir ésto, el sistema deja a las esferas superponerse solo si las muestras correspondientes son similares

<!--It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses.-->
También es posible adaptarse al tamaño de las esferas difusas. Ésto es limitado por una función de penalización (Divergencia KL) que intenta hacer la varianza cercana a 1 para que el tamaño de las esferas no sean ni muy grandes ni muy pequeñas que se derrumbe. 
