---
lang-ref: ch.08-1
lang: es
lecturer: Yann LeCun
title: Contrastive Methods in Energy-Based Models
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 8 Aug 2020
translator: LecJackS
---


<!--## [Recap](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)
-->
## [Resumen](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

<!--Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods.
-->
El Dr. LeCun pasó los primeros \~15 minutos dando una revisión de los modelos basados ​​en energía. Para obtener esta información, consulta los videos de la semana pasada (notas de la semana 7), especialmente el concepto de métodos de *aprendizaje contrastivos* (o *de contraste*).

<!--As we have learned from the last lecture, there are two main classes of learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function $F$ which has minimized/limited low energy regions by applying regularization.
-->

Como hemos aprendido en la última clase, hay dos tipos principales de métodos de aprendizaje:
1. Métodos Contrastivos que reducen la energía de los puntos de datos de entrenamiento, $F(x_i, y_i)$, mientras aumentan la energía en cualquier otro lado, $F(x_i, y’)$.
2. Métodos Arquitectónicos que construyen la función de energía $F$ que ha minimizado / limitado las regiones de baja energía mediante la aplicación de regularización.

<!--To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else.
-->

Para distinguir las características de los diferentes métodos de entrenamiento, el Dr. Yann LeCun ha resumido además 7 estrategias de entrenamiento de las dos clases mencionadas anteriormente. Uno de los cuales son los métodos similares al de Máxima Verosimilitud, que empujan hacia abajo la energía de los puntos de datos y empujan hacia arriba en todas las otras partes.

<!--Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn't “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values.
-->

El método de máxima verosimilitud empuja probabilísticamente hacia abajo las energías en los puntos de datos de entrenamiento y empuja hacia todas partes cada otro valor de $y’\neq y_i$. Máxima Verosimilitud no "se preocupa" por los valores absolutos de las energías, sino que sólo "se preocupa" por la diferencia entre energías. Debido a que la distribución de probabilidad siempre se normaliza para sumar/integrar a 1, comparar la relación entre dos puntos de datos dados es más útil que simplemente comparar valores absolutos.

<!--
## [Contrastive methods in self-supervised learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)
-->

## [Métodos contrastivos en el aprendizaje auto-supervisado](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!--In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold.
-->

En los métodos contrastivos, presionamos hacia abajo la energía de los puntos de datos de entrenamiento observados ($x_i$, $y_i$), mientras aumentamos la energía de los puntos fuera de la variedad (*manifold*) de datos de entrenamiento.

<!--In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks.
-->

En el aprendizaje auto-supervisado, usamos una parte de la entrada para predecir las otras partes. Esperamos que nuestro modelo pueda producir buenas características (*features*) en el área de visión por computadora, que compitan con las de las tareas supervisadas.

<!--Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below.
-->

Los investigadores han encontrado empíricamente que la aplicación de métodos de _encaje_ contrastivos (*contrastive embedding*) a modelos de aprendizaje auto-supervisados puede tener buenos resultados que rivalizan con los de los modelos supervisados. Exploraremos algunos de estos métodos y sus resultados a continuación.

<!--
### Contrastive embedding
-->
### Encaje contrastivo

<!--Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, *etc.*). We call this a **positive** pair.
-->

Considers un par ($x$, $y$), de modo que $x$ es una imagen e $y$ es una transformación de $x$ que conserva su contenido (rotación, ampliación, recorte, *etc.*). A esto lo llamamos un par **positivo**.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Positive Pair
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Par Positivo
</center>

<!--Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (*i.e.* a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold.
-->

Conceptualmente, los métodos de inserción contrastivos toman una red convolucional y alimentan $x$ e $y$ a través de esta red para obtener dos vectores de características: $h$ y $h'$. Debido a que $x$ e $y$ tienen el mismo contenido (*es decir,* un par positivo), queremos que sus vectores de características sean lo más similares posible. Como resultado, elegimos una métrica de similitud (como la similitud del coseno) y una función de pérdida que maximiza la similitud entre $h$ y $h'$. Al hacer esto, disminuimos la energía de las imágenes en la variedad (*manifold*) de datos de entrenamiento.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Negative Pair
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Par Negativo
</center>

<!--However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them.
-->

Sin embargo, también tenemos que aumentar la energía de los puntos fuera de esta variedad. Así que también generamos muestras **negativas** ($x_{\text{neg}}$, $y_{\text{neg}}$), imágenes con contenido diferente (etiquetas de clase diferentes, por ejemplo). Los alimentamos a nuestra red anterior, obtenemos los vectores de características $h$ y $h'$, y ahora tratamos de minimizar la similitud entre ellos.

<!--This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs.
-->

Este método nos permite empujar hacia abajo la energía de los pares similares, mientras empujamos hacia arriba la energía de pares diferentes.

<!--Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods.
-->

Resultados recientes (en ImageNet) han demostrado que este método puede producir características que son buenas para el reconocimiento de objetos que pueden rivalizar con las características aprendidas a través de métodos supervisados.

<!--
### Self-Supervised Results (MoCo, PIRL, SimCLR)
-->

### Resultados Auto-Supervisados ​​(MoCo, PIRL, SimCLR)

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL and MoCo on ImageNet
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL y MoCo en ImageNet
</center>

<!--As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRL is starting to approach the top-1 linear accuracy of supervised baselines (~75%).
-->

Como se ve en la figura anterior, MoCo y PIRL logran resultados SOTA (especialmente para modelos de menor capacidad, con una pequeña cantidad de parámetros). PIRL está comenzando a acercarse al top-1 en precisión lineal de los modelos supervisados (\~75%).

<!--We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows.
-->

Podemos entender mejor a PIRL observando su función objetivo: NCE (Estimador de Contraste de Ruido) de la siguiente manera.

<!--$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$
-->

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

<!--$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$
-->
$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

<!--Here we define the similarity metric between two feature maps/vectors as the cosine similarity.
-->

Aquí definimos la métrica de similitud entre dos mapas de características/vectores como la similitud del coseno.

<!--What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor.
-->

Lo que hace PIRL de manera diferente es que no usa la salida directa del extractor de características convolucionales. En su lugar, define diferentes _cabezas_ (_heads_) $f$ y $g$, que se pueden considerar como capas independientes sobre el extractor de características convolucionales base.

<!--Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs.
-->

Poniendo todo junto, la función objetivo NCE de PIRL funciona de la siguiente manera. En un mini-lote, tendremos un par positivo (similar) y muchos pares negativos (diferentes). Luego calculamos la similitud entre el vector de características de la imagen transformada ($I^t$) y el resto de los vectores de características en el minibatch (uno positivo, el resto negativo). A continuación, calculamos la puntuación de una función similar a softmax en el par positivo. Maximizar una puntuación softmax significa minimizar el resto de las puntuaciones, que es exactamente lo que queremos para un modelo basado en energía. La función de pérdida final, por lo tanto, nos permite construir un modelo que empuja la energía hacia abajo en pares similares, mientras la empuja hacia arriba en pares diferentes.

<!--Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank.
-->

El Dr. LeCun menciona que para que esto funcione, se requiere una gran cantidad de muestras negativas. En SGD, puede ser difícil mantener de manera consistente una gran cantidad de estas muestras negativas de mini lotes. Por lo tanto, PIRL también usa un banco de memoria en caché.

<!--**Question**: Why do we use cosine similarity instead of L2 Norm?
Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to centre) or make two vectors dissimilar by making them very "long" (away from the centre). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long.
-->

**Pregunta**: ¿Por qué utilizamos la similitud de coseno en lugar de la norma L2?
Respuesta: Con una norma L2, es muy fácil hacer dos vectores similares haciéndolos "cortos" (cerca del centro) o hacer dos vectores diferentes haciéndolos muy "largos" (lejos del centro). Esto se debe a que la norma L2 es solo una suma de diferencias parciales cuadradas entre los vectores. Por lo tanto, el uso de la similitud de coseno obliga al sistema a encontrar una buena solución sin "hacer trampa" haciendo vectores cortos o largos.

<!--
### SimCLR
-->

### SimCLR

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR Results on ImageNet
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: Resultados de SimCLR en ImageNet
</center>

<!--SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold.
-->

SimCLR muestra mejores resultados que los métodos anteriores. De hecho, alcanza el rendimiento de los métodos supervisados ​​en ImageNet, con una precisión lineal de primer nivel en ImageNet. La técnica utiliza un método sofisticado de aumento de datos para generar pares similares, y lo entrenan durante una gran cantidad de tiempo (con tamaños de lote muy, muy grandes) en TPUs. El Dr. LeCun cree que SimCLR, hasta cierto punto, muestra el límite de los métodos contrastivos. Hay muchas, muchas regiones en un espacio de alta dimensión en las que necesita aumentar la energía para asegurarse de que sea realmente más alta que en la variedad de datos. A medida que aumenta la dimensión de la representación, necesita más y más muestras negativas para asegurarse de que la energía sea mayor en esos lugares que no pertenecen al *manifold*.

<!--
## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)
-->

## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!--In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold.
-->

En la [práctica de la semana 7](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), hablamos sobre *denoising autoencoders*. El modelo tiende a aprender la representación de los datos reconstruyendo la entrada dañada en la entrada original. Más específicamente, entrenamos al sistema para producir una función de energía que crece cuadráticamente a medida que los datos corruptos se alejan de la variedad de los datos.

<!--<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Architecture of denoising autoencoder
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Architectura del *denoising autoencoder*
</center>

<!--
### Issues
-->

### Problemas

<!--However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance.
-->

Sin embargo, existen varios problemas con la eliminación de ruido de los codificadores automáticos. Un problema es que en un espacio continuo de alta dimensión, existen incontables formas de corromper un dato. Por lo tanto, no hay garantía de que podamos dar forma a la función de energía simplemente presionando hacia arriba en muchos lugares diferentes. Otro problema con el modelo es que funciona mal cuando se trata de imágenes debido a la falta de variables latentes. Dado que hay muchas formas de reconstruir las imágenes, el sistema produce varias predicciones y no aprende características particularmente buenas. Además, los puntos corruptos en el medio del *manifold* podrían reconstruirse a ambos lados. Esto creará puntos planos en la función de energía y afectará el rendimiento general.

<!--
## Other Contrastive Methods
-->
## Otros Métodos Contrastivos

<!--There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence.
-->

Existen otros métodos contrastivos como la divergencia contrastiva, la correspondencia de relaciones (*Ratio Matching*), la estimación contrastante de ruido y el flujo de probabilidad mínimo. Discutiremos brevemente la idea básica de divergencia contrastiva.

<!--
### Contrastive Divergence
-->

### Divergencia Contrastiva


<!--Contrastive divergence (CD) is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function.
-->

La divergencia contrastiva (CD) es otro modelo que aprende la representación corrompiendo inteligentemente la muestra de entrada. En un espacio continuo, primero elegimos una muestra de entrenamiento $y$ y reducimos su energía. Para esa muestra, usamos algún tipo de proceso basado en gradientes para movernos hacia abajo en la superficie de energía con ruido. Si el espacio de entrada es discreto, podemos perturbar la muestra de entrenamiento al azar para modificar la energía. Si la energía que obtenemos es menor, la conservamos. De lo contrario, lo descartamos con cierta probabilidad. Seguir haciéndolo eventualmente reducirá la energía de $y$. Luego podemos actualizar el parámetro de nuestra función de energía comparando $y$ y la muestra contrastada $\bar y$ con alguna función de pérdida.

<!--
### Persistent Contrastive Divergence
-->

### Divergencia Contrastiva Persistente

<!--One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases.
-->

Uno de los refinamientos de la divergencia contrastiva es la divergencia contrastiva persistente. El sistema usa un montón de "partículas" y recuerda sus posiciones. Estas partículas se mueven hacia abajo en la superficie de energía al igual que lo hicimos en divergencia contrastiva normal (CD). Eventualmente, encontrarán lugares de baja energía en nuestra superficie energética y harán que sean empujadas hacia arriba. Sin embargo, el sistema no escala bien a medida que aumenta la dimensionalidad.
