---
lang: es
lang-ref: ch.07-3
title: Introducción a autoencoders
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 06 Sep 2020
translator: David Paredes
---


<!--## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)-->
## [Aplicación de autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)


<!--### Image generation-->
### Generación de imágenes

<!--
Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center>
-->

¿Puedes decir qué cara es falsa en la Fig. 1? De hecho, ambos son producidos por el generador StyleGan2. Aunque los detalles faciales son muy realistas, el fondo parece extraño (izquierda: borrosidad, derecha: objetos deformados). Esto se debe a que la red neuronal se entrena en muestras de caras. El fondo tiene entonces una variabilidad mucho mayor. Aquí, la variedad de datos tiene aproximadamente 50 dimensiones, iguales a los grados de libertad de una imagen facial.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Caras generadas a partir de StyleGan2
</center>


<!--### Difference of Interpolation in Pixel Space and Latent Space-->
### Diferencia de interpolación en el espacio de píxeles y el espacio latente
<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center>

If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center>

If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center>

Obviously, latent space is better at capturing the structure of an image.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: Un perro y un pájaro
</center>

Si interpolamos linealmente entre la imagen del perro y el pájaro (Fig. 2) en el espacio de píxeles, obtendremos una superposición difusa de dos imágenes en la Fig. 3. Desde la parte superior izquierda a la inferior derecha, el peso de la imagen del perro disminuye y el peso de la imagen del pájaro aumenta.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Resultados después de la interpolación
</center>

Si interpolamos en dos representaciones de espacios latentes y los alimentamos al decodificador, obtendremos la transformación de perro a pájaro en la Fig.4.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Resultados después de alimentar al decodificador
</center>

Obviamente, el espacio latente es mejor para capturar la estructura de una imagen.


<!--### Transformation Examples-->
### Ejemplos de transformación

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Magnificación
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Cambio de posición
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Cambio de brillo
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotación (tenga en cuenta que la rotación podría ser 3D)
</center>


<!--### Image Super-resolution-->
### Súper resolución de images

<!--
This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez)

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center>

From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data.
-->

Este modelo tiene como objetivo mejorar la calidad de las imágenes y reconstruir los rostros originales. De izquierda a derecha en la Fig. 9, la primera columna es la imagen de entrada de 16x16, la segunda es lo que obtendría de una interpolación bicúbica estándar, la tercera es la salida generada por la red neuronal y a la derecha estám casos reales. (https://github.com/david-gpu/srez)

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstruyendo caras originales
</center>

A partir de las imágenes de salida, queda claro que existen sesgos en los datos de entrenamiento, lo que hace que las caras reconstruidas sean inexactas. Por ejemplo, el hombre asiático de arriba a la izquierda está hecho para parecer europeo en la salida debido a las imágenes de entrenamiento desequilibradas. La cara reconstruida de las mujeres de abajo a la izquierda se ve extraña debido a la falta de imágenes desde ese ángulo extraño en los datos de entrenamiento.


<!--### Image Inpainting-->
### Repintado de images

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center>

Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Poniendo parche gris en las caras
</center>

Poniendo un parche gris en la cara como en la Fig. 10 hace que la imagen se aleje de las variedades de los ejemplos de entrenamiento. La reconstrucción de la cara en la Fig. 11 se realiza encontrando la imagen de muestra más cercana en las variedades de los ejemplos de entrenamiento a través de la minimización de la función de energía.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Imagen reconstruida de <b>Fig. 10</b>
</center>


<!--### Caption to Image-->
### Subtítulos a imagen

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center>

The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images.
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Ejemplo de subtítulo a imagen
</center>

El traslado desde descripción de texto a imagen en la Fig. 12 se logra extrayendo las representaciones de características de texto asociadas con información visual importante y luego decodificándolas en imágenes.


<!--## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)-->
## [¿Qué son los autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

<!--
Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center>

Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network.

We can represent the above network mathematically by using the following equations:

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

We also specify the following dimensionalities:

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$
-->

Los autoencoders son redes neuronales artificiales, entrenadas de manera no supervisada, que tienen como objetivo aprender primero las representaciones codificadas de nuestros datos y luego generar los datos de entrada (lo más cerca posible) a partir de las representaciones codificadas aprendidas. Por tanto, la salida de de autoencoder es su predicción para la entrada.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Arquitectura de un autoencoder básico<br>
</center>

La Fig. 13 muestra la arquitectura de un autoencoder básico. Como antes, comenzamos desde abajo con la entrada $\boldsymbol{x}$ que está sujeta a un codificador (transformación afín definida por $\boldsymbol{W_h}$, seguido de un "apretón"). Esto da como resultado la capa oculta intermedia $\boldsymbol{h}$. Esto se somete al decodificador (otra transformación afín definida por $\boldsymbol{W_x}$ seguida de otro "apretón"). Esto produce la salida $\boldsymbol{\hat{x}}$, que es la predicción/reconstrucción de la entrada de nuestro modelo. Según nuestra convención, decimos que se trata de una red neuronal de 3 capas.

Podemos representar la red anterior matemáticamente usando las siguientes ecuaciones:

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

También especificamos las siguientes dimensionalidades:

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Nota:</b> Para representar los componentes principales (principal component analysis, PCA), podemos tener pesos ajustados (o pesos atados) definidos por $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$


<!--## Why are we using autoencoders?-->
## ¿Por qué utilizamos autoencoders?

<!--
At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders.

The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold i.e. given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations.

Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space.
-->

A este punto, es posible que te preguntes cuál es el sentido de predecir la entrada y cuáles son las aplicaciones de autoencoders.

Las aplicaciones principales de un autoencoder son la detección de anomalías o la eliminación de ruido de imágenes. Sabemos que la tarea de un autoencoder es poder reconstruir datos que viven en variedad, es decir, dado una variedad de datos, querríamos que nuestro autoencoder pudiera reconstruir solo la entrada que existe en esa variedad. Por lo tanto, restringimos el modelo para reconstruir cosas que se han observado durante el entrenamiento, por lo que cualquier variación presente en las nuevas entradas se eliminará porque el modelo sería insensible a ese tipo de perturbaciones.

Otra aplicación de un autoencoder es como un compresor de imágenes. Si tenemos una dimensionalidad intermedia $d$ menor que la dimensionalidad de entrada $n$, entonces el codificador puede usarse como un compresor y las representaciones ocultas (representaciones codificadas) abordarían toda (o la mayoría) de la información en la entrada específica pero ocupa menos espacio.


<!--## Reconstruction loss-->
## Función de costo de reconstrucción

<!--
Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e.

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

And when the input is real-valued, we may want to use the Mean Squared Error Loss given by

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$
-->

Veamos ahora las funciones de costo de reconstrucción que usamos generalmente. La función de costo general para el conjunto de datos se da como el promedio por costo de muestra, es decir,

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

Cuando la entrada es categórica, podríamos usar la función de costo de entropía cruzada (cross-entropy) para calcular el costo por muestra que viene dada por

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

Y cuando la entrada tiene un valor real, es posible que deseemos usar la función de costo de error cuadrático medio dada por

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$


<!--## Under-/over-complete hidden layer-->
## Capa oculta subcompleta o sobrecompleta

<!--
When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete vs an over-complete hidden layer<br>
</center>

As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier.

Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold.

It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc.
-->

Cuando la dimensionalidad de la capa oculta $d$ es menor que la dimensionalidad de la entrada $n$, decimos que esta capa oculta esta subcompleta. Y de manera similar, cuando $d>n$, lo llamamos una capa oculta sobrecompleta. La Fig. 14 muestra una capa oculta subcompleta a la izquierda y una capa oculta sobrecompleta a la derecha.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: Una capa oculta subcompleta vs una sobrecompleta<br>
</center>

Como se mencionó anteriormente, se puede usar una capa oculta subcompleta para la compresión, ya que estamos codificando la información de entrada en menos dimensiones. Por otro lado, en una capa sobrecompleta, usamos una codificación con mayor dimensionalidad que la entrada. Esto facilita la optimización.

Dado que estamos tratando de reconstruir la entrada, el modelo es propenso a copiar todas las características de entrada en la capa oculta y pasarla como salida, por lo que se comporta esencialmente como una función de identidad. Esto debe evitarse, ya que esto implicaría que nuestro modelo no aprende nada. Por lo tanto, necesitamos aplicar algunas restricciones adicionales mediante la aplicación de un cuello de botella de información. Hacemos esto restringiendo las posibles configuraciones que la capa oculta puede tomar a solo aquellas configuraciones vistas durante el entrenamiento. Esto permite una reconstrucción selectiva (limitada a un subconjunto del espacio de entrada) y hace que el modelo sea insensible a todo lo que no está en la variedad.

Cabe señalar que una capa subcompleta no puede comportarse como una función de identidad simplemente porque la capa oculta no tiene suficientes dimensiones para copiar la entrada. Por lo tanto, es menos probable que una capa oculta subcompleta se sobreajuste en comparación con una capa oculta sobrecompleta, pero aún así podría sobreajustarse. Por ejemplo, dado un codificador y un decodificador potentes, el modelo podría simplemente asociar un número a cada punto de datos y aprender el mapeo. Existen varios métodos para evitar el sobreajuste, como los métodos de regularización, los métodos arquitectónicos, etc.


<!--## Denoising autoencoder-->
## Autoencoder eliminador de ruido

<!--
Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center>

In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot.

Fig.16 gives the relationship between the input data and output data.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center>

We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center>

The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process.
-->

La Fig.15 muestra la variedad del autoencoder eliminador de ruido y la intuición de cómo funciona.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Autoencoder eliminador de ruido<br>
</center>

En este modelo, asumimos que estamos inyectando la misma distribución ruidosa que vamos a observar en la realidad, de modo que podamos aprender cómo recuperarnos de ella de manera robusta.
Al comparar la entrada y la salida, podemos decir que los puntos que ya estaban en los datos de la variedad no se movieron, y los puntos que estaban lejos de la variedad se movieron mucho.

La Fig.16 muestra la relación entre los datos de entrada y los datos de salida.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Entrada y salida del autoencoder eliminador de ruido<br>
</center>

También podemos usar diferentes colores para representar la distancia de los movimientos de cada punto de entrada, la Fig. 17 muestra el diagrama.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Medir la distancia de viaje de los datos de entrada<br>
</center>

Cuanto más claro sea el color, mayor será la distancia recorrida por un punto. Del diagrama, podemos decir que los puntos en las esquinas viajaron cerca de 1 unidad, mientras que los puntos dentro de las 2 ramas no se movieron en absoluto ya que son atraídos por las ramas superior e inferior durante el proceso de entrenamiento.


<!--## Contractive autoencoder-->
## Autoencoder contractivo

<!--
Fig.18 shows the loss function of the contractive autoencoder and the manifold.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center>

The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions.

Fig.19 shows how these autoencoders work in general.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center>

The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer.
-->

La Fig.18 muestra la función de costo del autoencoder contractivo y la variedad.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Autoencoder contractivo <br>
</center>


La función de costo contiene el término de reconstrucción más la norma al cuadrado del gradiente de la representación oculta con respecto a la entrada. Por lo tanto, la función de costo general minimizará la variación de la capa oculta dada la variación de la entrada. El beneficio sería hacer que el modelo sea sensible a las direcciones de reconstrucción mientras que insensible a cualquier otra dirección posible.

La Fig.19 muestra cómo funcionan estos autoencoders en general.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Autoencoder básico <br>
</center>

La variedades de los ejemplos de entrenamiento es un objeto unidimensional que va en tres dimensiones. Donde $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, el objetivo del autoencoder es estirar la línea curveada en una dirección, donde $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. Como resultado, un punto de la capa de entrada se transformará en un punto de la capa latente. Ahora tenemos la correspondencia entre los puntos en el espacio de entrada y los puntos en el espacio latente, pero no tenemos la correspondencia entre las regiones del espacio de entrada y las regiones del espacio latente. Luego, utilizaremos el decodificador para transformar un punto de la capa latente para generar una capa de salida significativa.

<!--## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)-->
## [Implementar un autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

<!--
The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).

In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs.
-->

El Jupyter Notebook se puede encontrar [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).

En este Notebook, vamos a implementar un autoencoder estándar y un autoencoder eliminador de ruido y luego compararemos las salidas.


<!--### Define autoencoder model architecture and reconstruction loss-->
### Definir la arquitectura del modelo de autoencoder y la función de costo de reconstrucción

<!--
Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model.
-->

Usando una imagen de $28 \times 28$,
y una capa oculta de 30 dimensiones. La rutina de transformación estaría pasando de $784\to30\to784$. Al aplicar la función de tangente hiperbólica a la rutina del codificador y decodificador, podemos limitar el rango de salida a $(-1, 1)$. El error cuadrático medio (Mean Squared Error, MSE) se utilizará como función de costo de este modelo.

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```


<!--### Train standard autoencoder-->
### Entrenar autoencoder estándar 

<!--
To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop:
-->

Para entrenar un autoencoder estándar usando PyTorch, necesitas poner los siguientes 5 métodos en el bucle de entrenamiento:


<!--#### Going forward:-->
#### Yendo hacia adelante:

<!--
1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`.
-->

1) Enviar la imagen de entrada a través del modelo llamando `output = model(img)` . <br>
2) Calcule la función de costo usando: `criterion(output, img.data)`.


<!--#### Going backward:-->
#### Yendo hacia atrás:

<!--
3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()`

Fig. 20 shows the output of the standard autoencoder.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/>
-->

3) Borre el gradiente para asegurarse de que no acumulemos el valor: `optimizer.zero_grad()`. <br>
4) Propagación hacia atrás: `loss.backward()`<br>
5) Paso hacia atrás: `optimizer.step()`

La Fig. 20 muestra la salida del autoencoder estándar.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Salida del autoencoder estándar <br>
</center>
<br/>


<!--### Train denoising autoencoder-->
### Entrenar un autoencoder eliminador de ruido

<!--
For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`.

Fig. 21 shows the output of the denoising autoencoder.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center>
-->

Para el autoencoder eliminador de ruido, necesitas agregar los siguientes pasos:<br>
1) LLamar `nn.Dropout()` para apagar neuronas aleatoriamente. <br>
2) Crear máscara de ruido: `do(torch.ones(img.shape))`.<br>
3) Crear imágenes malas multiplicando imágenes buenas por máscaras binarias: `img_bad = (img * noise).to(device)`.

La Fig. 21 muestra la salida del autoencoder eliminador de ruido.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Salida del autoencoder eliminador de ruido <br>
</center>


<!--### Kernels comparison-->
### Comparación de kernels

<!--
It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center>

On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center>

Compared to the state of the art, our autoencoder actually does better!! You can see the results below.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes inpainting output.
</center>
-->

Es importante tener en cuenta que a pesar del hecho de que la dimensión de la capa de entrada es $28 \times 28 = 784$, una capa oculta con una dimensión de 500 sigue siendo una capa sobrecompleta debido a la cantidad de píxeles negros en la imagen.
A continuación se muestran ejemplos de kernels utilizados en el autoencoder estándar subcompleto entrenado. Claramente, los píxeles en la región donde existe el número indican la detección de algún tipo de patrón, mientras que los píxeles fuera de esta región son básicamente aleatorios. Esto indica que el autoencoder estándar no se preocupa por los píxeles fuera de la región donde está el número.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Kernels de autoencoders estándares.
</center>

Por otro lado, cuando los mismos datos se envían a un autoencoder eliminador de ruido donde se aplica una máscara de dropout a cada imagen antes de ajustar el modelo, sucede algo diferente. Cada kernel que aprende un patrón establece los píxeles fuera de la región donde existe el número en algún valor constante. Debido a que se aplica una máscara de dropout a las imágenes, el modelo ahora se preocupa por los píxeles fuera de la región del número.

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Kernels de autoencoders eliminadores de ruido.
</center>

En comparación con el estado del arte, ¡nuestro autoencoder funciona mejor! Puedes ver los resultados a continuación.


<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Datos de entrada (dígitos MNIST).
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Reconstrucciones de autoencoders eliminadores de ruido.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Salida del repintado de images using el método de Telea.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Salida del repintado de images using el método de Navier-Stokes.
</center>

