---
lang: es
lang-ref: ch.07-2
lecturer: Yann LeCun
title: SSL, EBM con detalles y ejemplos
authors: Ravi Choudhary， B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 9 Mar 2020
translation-date: 06 Sep 2020
translator: David Paredes
---


<!--## [Self supervised learning](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)-->
## [Aprendizaje auto supervisado](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

<!--Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning. The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-Encoder (DAE) has particularly shown state-of-the-art results in Natural Language Processing (NLP).
-->

El aprendizaje auto supervisado (self-supervised learning, SSL) abarca tanto el aprendizaje supervisado como el no supervisado. El objetivo de la tarea de pretexto SSL es aprender una buena representación de la entrada para que posteriormente pueda utilizarse para tareas supervisadas. En SSL, el modelo está entrenado para predecir una parte de los datos dadas otras partes de los datos. Por ejemplo, BERT fue entrenado usando técnicas SSL y de autoencoder eliminador de ruido (Denoising Auto-Encoder, DAE) ha particularmente mostrado resultados en el estado del arte en el procesamiento del lenguaje natural (Natural Language Processing, NLP).

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Aprendizaje auto supervisado
</center>

<!--
Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.

For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity.

State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion.
-->

La tarea de aprendizaje auto supervisado se puede definir como sigue:
* Predecir el futuro desde el pasado.
* Predecir lo enmascarado desde lo visible.
* Predecir las partes ocluidas desde todas las partes disponibles.

Por ejemplo, si un sistema está entrenado para predecir el siguiente fotograma cuando se mueve la cámara, el sistema aprenderá implícitamente sobre la profundidad y el paralaje. Esto obligará al sistema a aprender que los objetos ocluidos de su visión no desaparecen sino que continúan existiendo y la distinción entre objetos animados e inanimados y el fondo. También puede terminar aprendiendo sobre física intuitiva como la gravedad.

El estado del arte de sistemas NLP (BERT) pre-entrenan una red neuronal gigante en una tarea de SSL.  Tu eliminas algunas de las palabras de una oración y hace que el sistema prediga las palabras que faltan. Esto ha tenido mucho éxito. También se probaron ideas similares en el ámbito de la visión por computadora. Como se muestra en la imagen a continuación, puedes tomar una imagen y eliminar una parte de la imagen y entrenar el modelo para predecir la parte que falta.

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Resultados correspondientes en visión por computadora
</center>

<!--
Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continuous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not.

An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models (EBMs) can be extremely useful for this.

A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss.
-->

Aunque los modelos pueden llenar el espacio que falta, ellos no han compartido el mismo nivel de éxito que los sistemas NLP. Si tuviera que tomar las representaciones internas generadas por estos modelos, como entrada a un sistema de visión por computadora, no podría vencer a un modelo que fue pre-entrenado de manera supervisada en ImageNet. La diferencia aquí es que NLP es discreto mientras que las imágenes son continuas. La diferencia en el éxito se debe a que en el dominio discreto sabemos cómo representar la incertidumbre, podemos usar un gran softmax sobre las posibles salidas, en el dominio continuo no lo hacemos.

Un sistema inteligente (agente de IA) necesita poder predecir los resultados de su propia acción en el entorno y a sí mismo para tomar decisiones inteligentes. Dado que el mundo no es completamente determinista y no hay suficiente poder de cómputo en una máquina / cerebro humano para tener en cuenta todas las posibilidades, debemos enseñar a los sistemas de IA a predecir en presencia de incertidumbre en espacios de gran dimensión. Los modelos basados ​​en energía (EBM) pueden ser extremadamente útiles para esto.

Una red neuronal entrenada con mínimos cuadrados para predecir el siguiente fotograma de un video dará como resultado imágenes borrosas porque el modelo no puede predecir exactamente el futuro, por lo que aprende a promediar todas las posibilidades del siguiente fotogramas a partir de los datos de entrenamiento para reducir la pérdida.


<!--### Latent variable energy-based models as a solution to make predictions for next frame:-->
### Modelos basados en energía de variable latente como una solución para hacer predicciones para el siguiente fotograma:

<!--
Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs.

These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$ for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system.

Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$.

Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$
-->

A diferencia de regresión lineal, los modelos basados en energía de variable latente toman lo que sabemos sobre el mundo así como una variable latente que nos da información sobre lo que sucedió en la realidad. Se puede utilizar una combinación de esas dos piezas de información para hacer una predicción cercana a lo que realmente ocurre.

Estos modelos se pueden considerar como sistemas que clasifican la compatibilidad entre la entrada $x$ y la salida real $y$ dependiendo de la predicción utilizando la variable latente que minimiza la energía del sistema. Observa la entrada $x$ y produce posibles predicciones $\bar{y}$ para diferentes combinaciones de entrada $x$ y variables latentes $z$ y elige la que minimiza la energía, el error de predicción, del sistema.

Dependiendo de la variable latente que dibujemos, podemos terminar con todas las predicciones posibles. La variable latente podría considerarse como una pieza de información importante sobre la salida $y$ que no está presente en la entrada $x$.

La función de energía de valor escalar puede tomar dos versiones:
1. Ccondicional $F(x, y)$ - mide la compatibilidad entre $x$ y $y$
2. Incondicional $F(y)$ - mide la compatibilidad entre los componentes de $y$


<!--## [Training an Energy-Based Model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)-->
## [Entrenando un modelo basado en energía](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)

<!--
There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization

There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the way they limit the information capacity of the code.

An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalised negative log density. Gibbs distribution gives us the likelihood of $y$ given $x$. It can be formulated as follows:

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta} \log \int_{y}e^{-\beta E(y,W)}
$$

Gradient of the negative log likelihood loss for one sample Y is as follows:

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

In the above gradient, the first term of the gradient at the data point $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy over all $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the data point $Y$ and the second term tries to increase the energy given to all other $Y$s.

The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases.
-->


Hay dos clases de modelos de aprendizaje para entrenar un modelo basado en energía para parametrizar $F(x, y)$.
1. **Métodos contrastivos:** Empuja hacia abajo en $F(x[i], y[i])$, empuja hacia arriba en otros puntos $F(x[i], y')$
2. **Métodos arquitectónicos:** Construir $F(x, y)$ para que el volumen de las regiones de baja energía se limite o minimice mediante regularización

Hay siete estrategias para dar forma a la función de energía. Los métodos contrastivos difieren en la forma en que seleccionan los puntos para empujar hacia arriba. Mientras que los métodos arquitectónicos difieren en la forma en que limitan la capacidad de información del código.

Un ejemplo del método contrastivo es el aprendizaje de máxima verosimilitud. La energía se puede interpretar como una densidad logarítmica negativa no normalizada. La distribución de Gibbs nos da la probabilidad de $y$ dado $x$. Puede formularse de la siguiente manera:


$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

La verosimilitud máxima intenta hacer que el numerador sea grande y el denominador pequeño para maximizar la probabilidad. Esto es equivalente a minimizar $-\log(P(Y \mid W))$ que se da a continuación


$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$

El gradiente de la funcion de pérdida de probabilidad logarítmica negativa para una muestra Y es el siguiente:

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

En el gradiente anterior, el primer término del gradiente en el punto de datos $Y$ y el segundo término del gradiente nos da el valor esperado del gradiente de la energía sobre todos los $Y$. Por lo tanto, cuando realizamos un descenso de gradiente, el primer término intenta reducir la energía dada al punto de datos $Y$ y el segundo término intenta aumentar la energía dada a todos los demás $Y$.

El gradiente de la función de energía es generalmente muy complejo y, por lo tanto, calcular, estimar o aproximar la integral es un caso muy interesante, ya que es intratable en la mayoría de los casos.


<!--## [Latent variable energy-based model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)-->
## [Modelo basado en energía de variable latente](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)

<!--
The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ varies over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modelling
3. [GLO](https://arxiv.org/abs/1707.05776)

These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, $F(y)$ that measures the compatibility between the components of $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$
-->

La principal ventaja de los modelos de variables latentes es que permiten múltiples predicciones a través de la variable latente. Como $z$ varía en un conjunto, $y$ varía en la variedad de posibles predicciones. Algunos ejemplos incluyen:
1. K-medias
2. Modelado disperso
3. Optimización generativa de variables latentes [Generative Latent Optimization(GLO)](https://arxiv.org/abs/1707.05776)

Estos pueden ser de dos tipos:
1. Modelos condicionales donde $y$ depende de $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Modelos incondicionales que tienen una función de energía de valor escalar, $F(y)$ que mide la compatibilidad entre los componentes de $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: EBM de variable latente
</center>


<!--## Latent variable EBM example: $K$-means-->
## Ejemplo de EBM de variable latente: $K$-medias

<!--
K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center>

Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster.

In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of $W$.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral plot
</center>

Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold?

K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them.
-->

K-medias es un algoritmo de agrupamiento simple que también se puede considerar como un modelo basado en energía donde estamos tratando de modelar la distribución sobre $y$. La función de energía es $E(y,z) = \Vert y-Wz \Vert^2$ donde $z$ es un vector $1$-hot.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: Ejemplo de K-medias
</center>

Dado un valor de $y$ y $k$, podemos hacer inferencias calculando cuál de las $k$ posibles columnas de $W$ minimiza el error de reconstrucción o la función de energía. Para entrenar el algoritmo, podemos adoptar un enfoque en el que podemos encontrar $z$ para elegir la columna de $W$ más cercana a $y$ y luego intentar acercarnos aún más dando un paso de gradiente y repetir el proceso. Sin embargo, el descenso de gradiente coordinado en realidad funciona mejor y más rápido.

En el gráfico de abajo podemos ver los puntos de datos a lo largo de la espiral rosada. Las manchas negras que rodean esta línea corresponden a pozos cuadráticos alrededor de cada uno de los prototipos de $W$.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Gráfico de espiral
</center>

Una vez que aprendamos la función de energía, podemos comenzar a abordar preguntas como:
1. Dado un punto $y_1$, ¿podemos predecir $y_2$?
2. Dado $y$, ¿podemos encontrar el punto más cercano en la variedad de datos?

K-medias pertenece a los métodos arquitectónicos (a diferencia de los métodos contrastivos). Por lo tanto, no empujamos hacia arriba la energía en ninguna parte, todo lo que hacemos es empujar la energía hacia abajo en ciertas regiones. Una desventaja es que una vez que se ha decidido el valor de $k$, solo puede haber $k$ puntos que tengan $0$ de energía, y todos los demás puntos tendrán una energía mayor que crecerá cuadráticamente a medida que nos alejamos de ellos.


<!--## Contrastive methods-->
## Métodos contrastivos

<!--
According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of $F(x,y)$) around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center>

There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo

We will briefly discuss denoising autoencoders and contrastive divergence.
-->

Según el Dr. Yann LeCun, todos usarán métodos arquitectónicos en algún momento, pero en este momento, son los métodos contrastivos los que funcionan para imágenes. Considera la siguiente figura que nos muestra algunos puntos de datos y contornos de la superficie de energía. Idealmente, queremos que la energía de la superficie tenga la energía más baja en el variedad de datos. Por lo tanto, lo que nos gustaría hacer es reducir la energía (es decir, el valor de $F(x,y)$) alrededor del ejemplo de entrenamiento, pero esto por sí solo puede no ser suficiente. Por lo tanto, también lo aumentamos para los $y$ en la región que debería tener alta energía pero tiene baja energía.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Métodos contrastivos
</center>

Hay varias formas de encontrar estos $y$ candidatos para los que queremos aumentar la energía. Algunos ejemplos son:
1. Autoencoder Eliminador de Ruido
2. Divergencia contrastiva
3. Monte Carlo
4. Cadena de Markov Monte Carlo
5. Montecarlo Hamiltoniano

Discutiremos brevemente autoencoders eliminadores de ruido y la divergencia contrastiva.


<!--### Denoising autoencoder (DAE)-->
### Autoencoder Eliminador de Ruido (Denoising autoencoder, DAE)

<!--
One way of finding $y$'s to increase energy for it is by randomly perturbing the training example as shown by the green arrows in the plot below.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center>

Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center>

Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point

If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold.

The following plot illustrates how we use the DAE.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center>
-->

Una forma de encontrar $y$ para aumentar la energía es perturbando aleatoriamente el ejemplo de entrenamiento como lo muestran las flechas verdes en la gráfica de abajo.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Mapa topográfico
</center>

Una vez que tengamos un punto de datos dañado, podemos empujar la energía hacia arriba. Si hacemos esto suficientes veces para todos los puntos de datos, la muestra de energía se acumulará alrededor de los ejemplos de entrenamiento. El siguiente gráfico ilustra cómo se realiza el entrenamiento.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Entrenamiento
</center>

Pasos para el entrenamiento:
1. Toma un punto $y$ y dañalo
2. Entrene el codificador y el decodificador para reconstruir el punto de datos original a partir de este punto de datos dañado.

Si el DAE está debidamente entrenado, la energía crece de forma cuadrática a medida que nos alejamos de la variedad de datos.

La siguiente gráfica ilustra cómo usamos el DAE.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: Cómo se usa DAE
</center>


<!--### BERT-->
### BERT

<!--
BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstruction step consists of trying to predict these. Hence, this is also called a masked autoencoder.
-->

BERT se entrena de manera similar, excepto que el espacio es discreto ya que estamos tratando con texto. La técnica de dañar consiste en enmascarar algunas de las palabras y el paso de reconstrucción consiste en intentar predecirlas. Por lo tanto, a esto también se le llama un autoencoder enmascarado.


<!--### Contrastive divergence-->
### Divergencia contrastiva

<!--
Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center>
-->

La divergencia contrastiva nos presenta una forma más inteligente de encontrar el punto $y$ para el que queremos empujar la energía hacia arriba. Podemos dar una patada aleatoria a nuestro punto de entrenamiento y luego bajar la función de energía usando el descenso de gradiente. Al final de la trayectoria, aumentamos la energía para el punto en el que aterrizamos. Esto se ilustra en el gráfico siguiente utilizando la línea verde.

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Divergencia contrastiva
</center>
