---
lang: es
lang-ref: ch.07-1
lecturer: Yann LeCun
title: Modelos basados en energía (EBM)
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translation-date: 06 Sep 2020
translator: David Paredes
---


<!--## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)-->
## [Descripción general](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

<!--We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:-->
Introduciremos una nueva estructura para definir modelos. Esta proporciona un marco unificador que ayuda a definir modelos supervisados, no supervisados y auto-supervisados. Los modelos basados en energía observan un conjunto de variables $x$ y generan un conjunto de variables $y$. Hay 2 problemas principales con las redes prealimentadas:

<!--1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities.-->
1. ¿Qué sucede si el procedimiento de inferencia es un cálculo más complejo que las capas apiladas de sumas ponderadas?
2. ¿Qué pasa si hay múltiples salidas posibles para una sola entrada? Ejemplo: predecir futuros fotogramas de video. Esencialmente en una red de clasificación, entrenamos esta red para emitir una puntuación para cada clase. Sin embargo, esto no es posible hacerlo en un dominio continuo de alta dimensión como imágenes. (¡No podemos tener softmax sobre imágenes!). Incluso si la salida es discreta, podría tener un gran espacio de muestra. Por ejemplo, el texto es compositivo que lleva a una gran cantidad de combinaciones posibles. Los modelos basados en energía proporcionan una mejor estructura para modelar estas modalidades.



<!--## EBM approach-->
## Enfoque de EBM

<!--Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`?
-->

En lugar de intentar clasificar $x$ en $y$, nos gustaría predecir si un determinado par de ($x$, $y$) encaja o no. O en otras palabras, encuentrar un $y$ compatible con $x$. También podemos plantear el problema como encontrar un $y$ para el cual algún $F(x,y)$ es bajo. Por ejemplo:

- ¿Es $y$ una imagen precisa de alta resolución de $x$?
- ¿Es el texto `A` una buena traducción del texto `B`?

<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
 -->


<!--### Definition-->
### Definición

<!--We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$
-->

Definimos una función de energía $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ donde $F(x,y)$ describe el nivel de dependencia entre pares $(x,y)$. (**Nota** que esta energía se usa en inferencia, **no** en el aprendizaje.) La inferencia esta dada por la siguiente ecuación:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


<!--### Solution: gradient-based inference-->
### Solución: inferencia basada en gradientes

<!--We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring.
-->

Nos gustaría que la función de energía fuera suave y diferenciable para poder usarla para realizar el método de inferencia basado en gradientes. Para realizar inferencias, buscamos esta función usando el descenso de gradiente para encontrar $y$ compatibles.
Hay muchos métodos alternativos a los métodos de gradiente para obtener el mínimo.

**Aparte**: Los modelos gráficos son un caso especial de modelos basados en energía. La función de energía se descompone como una suma de términos de energía. Cada término de energía tiene en cuenta un subconjunto de variables con las que estamos tratando. Si se organizan en una forma particular, existen algoritmos de inferencia eficientes para encontrar el mínimo de la suma de los términos con respecto a la variable que nos interesa inferir.

<!-- There are a type of Energy Based Models that are quite popular. These are
 -->
<!--## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)-->
## [EBM con variables latentes](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

<!--The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (e.g. French). Hence, having this latent variable in our model will be very useful to interpret such an input.
-->

La salida $y$ depende de $x$, así como también de una variable adicional $z$ (la variable latente) cuyo valor no conocemos. Estas variables latentes pueden proporcionar información auxiliar. Por ejemplo, una variable latente puede indicarle las posiciones de los límites de las palabras en un fragmento de texto. Esto sería útil para saber cuándo queremos interpretar la escritura a mano sin espacios. Esto también es especialmente útil para saber en el habla que puede tener lagunas difíciles de descifrar. Adicionalmente, algunos idiomas tienen límites de palabras muy tenues (por ejemplo, francés). Por tanto, tener esta variable latente en nuestro modelo será muy útil para interpretar dicha entrada.


<!--### Inference-->
### Inferencia

<!--To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$.
-->

Para hacer inferencia con variable latente de EBM, queremos minimizar simultáneamente la función de energía con respecto a y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

Y esto equivale a redefinir la función energética como: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, que equivale a: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
Cuando $\beta \rightarrow \infty$, entonces $\check{y} = \text{argmin}_{y}F(x,y)$.

<!--  ## Latent-Variable EBM -->
<!-- Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one.
-->
Otra gran ventaja de permitir variables latentes, es que al variar la variable latente sobre un conjunto, podemos hacer que la salida de predicción $y$ varíe también sobre la variedad de predicciones posibles (la cinta se muestra en el gráfico debajo): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

Esto permite que una máquina produzca múltiples salidas, no solo una.

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Grafo computacional de modelos basados ​​en energía
</center>


<!--### Examples-->
### Ejemplos

<!--One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced.
-->

Un ejemplo es la predicción de video. Hay muchas buenas aplicaciones para que usemos la predicción de video, un ejemplo es hacer un sistema de compresión de video. Otra es usar un video tomado de un automóvil autónomo y predecir lo que harán otros automóviles.

Otro ejemplo es la traducción. La traducción de idiomas siempre ha sido un problema difícil porque no existe una única traducción correcta para un texto de un idioma a otro. Usualmente, hay muchas formas diferentes de expresar la misma idea y las personas encuentran difícil razonar por qué eligen una sobre la otra. Así que sería bueno si tuviéramos alguna forma de parametrizar todas las posibles traducciones que un sistema podría producir para responder a un texto dado. Digamos que si queremos traducir del alemán al inglés, podría haber varias traducciones en inglés que sean todas correctas y, al variar algunas variables latentes, puede variar la traducción producida.


<!--## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)-->
## [Modelos basados en energía *v.s.* modelos probabilísticos](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

<!--We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy)
-->

Podemos ver las energías como probabilidades logarítmicas negativas no normalizadas, y usar la distribución de Gibbs-Boltzmann para convertir de energía a probabilidad después de que la normalización sea:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

donde $\beta$ es constante positiva y debe calibrarse para adaptarse a su modelo. Más grande $\beta$ da un modelo más fluctuante mientras más pequeño $\beta$ da un modelo más suave. (En física, $\beta$ es la temperatura inversa: $\beta \rightarrow \infty$ significa que la temperatura llega a cero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Ahora, si se margina sobre y: $P(y \mid x) = \int_z P(y,z \mid x)$, tenemos:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Por lo tanto, si tenemos un modelo de variable latente y queremos eliminar la variable latente $z$ de una manera probabilísticamente correcta, solo necesitamos redefinir la función de energía $F_\beta$ (Energía libre)


<!--### Free Energy-->
### Energía libre

<!--
$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.

Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy.

***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.***
-->

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Calcular esto puede ser muy difícil ... De hecho, en la mayoría de los casos, probablemente sea intratable.  Entonces, si tienes una variable latente que deseas minimizar dentro de su modelo, o si tienes una variable latente sobre la que desea marginar (lo que haces al definir esta función de energía $F$), y minimizar corresponde al límite infinito de $\beta$ de esta fórmula, entonces se puede hacer.

Según la definición de $F_\beta(x, y)$ anterior, $P(y \mid x)$ es solo una aplicación de la fórmula de Gibbs-Boltzmann y $z$ ha sido marginado implícitamente dentro de esto.  Los físicos llaman a esto "Energía Libre", por eso lo llamamos $F$. Entonces $e$ es la energía, y $F$ es la energía libre.

***Pregunta: ¿Puedes explicar las ventajas que ofrecen los modelos basados en energía?  En los modelos basados en probabilidad, también puedes tener variables latentes, que se pueden marginar.***

<!--The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, may more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them.
-->

La diferencia es que en los modelos probabilísticos, básicamente no tienes la opción de la función objetivo que vas a minimizar, y debe mantenerse fiel a la estructura probabilística en el sentido de que cada objeto que manipules tiene que ser una distribución normalizada (que puedes aproximar utilizando métodos variacionales, etc.). Aquí, estamos diciendo que, en última instancia, lo que quieres hacer con estos modelos es tomar decisiones. Si construyes un sistema que conduce un automóvil y el sistema te dice "Necesito girar a la izquierda con probabilidad de 0.8 o girar a la derecha con probabilidad de 0.2", vas a girar a la izquierda. El hecho de que las probabilidades sean 0,2 y 0,8 no importa; lo que quieres es tomar la mejor decisión, porque estás obligado a tomar una decisión. De modo que las probabilidades son inútiles si quieres tomar decisiones. Si deseas combinar la salida de un sistema automatizado con otro (por ejemplo, un humano o algún otro sistema), y estos sistemas no se entrenaron juntos, sino que se entrenaron por separado, entonces lo que deseas son puntajes calibrados para que puedas combinar las puntuaciones de los dos sistemas para que puedas tomar una buena decisión. Solo hay una forma de calibrar los puntajes y es convertirlos en probabilidades. Todas las demás formas son inferiores o equivalentes. Pero si vas a entrenar un sistema de principio a fin para que tome decisiones, entonces cualquier función de puntuación que utilices está bien, siempre y cuando dé la mejor puntuación a la mejor decisión. Los modelos basados en energía te brindan muchas más opciones sobre cómo manejar el modelo, pueden tener más opciones sobre cómo entrenarlo y qué función objetivu utilizas. Si insiste en que su modelo sea probabilístico, debe usar la máxima verosimilitud; básicamente, debes entrenar tu modelo de tal manera que la probabilidad que le dé a los datos que observó sea máxima. El problema es que solo se puede probar que esto funciona en el caso de que tu modelo sea "correcto", y tu modelo nunca es "correcto". Hay una cita de un famoso estadístico [Goerge Box] que dice ***"Todos los modelos son incorrectos, pero algunos son útiles."*** Entonces, los modelos probabilísticos, particularmente aquellos en espacios de alta dimensión y en espacios combinatorios como el texto, son todos modelos aproximados. Todos están mal de alguna manera, y si intentas normalizarlos, los haces más mal. Así que es mejor no normalizarlos.

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualization of the energy function that captures dependency between x and y
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualización de la función de energía que captura la dependencia entre x e y
</center>

<!--This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example:
-->

Esta es una función de energía que está destinada a capturar la dependencia entre *x* e *y*. Es como una cordillera, por así decirlo. Los valles están donde están los puntos negros (estos son puntos de datos), y hay montañas alrededor. Ahora, si entrenas un modelo probabilístico con esto, imagina que los puntos están en realidad en una variedad topológica infinitamente delgada. Entonces, la distribución de datos para los puntos negros es en realidad solo una línea, y hay tres de ellos. En realidad, no tienen ancho. Entonces, si entrenas un modelo probabilístico en esto, su modelo de densidad debería indicarte cuándo se encuentra en esta variedad topológica. En esta variedad topológica, la densidad es infinita, y solo $\varepsilon$ fuera de ella debería ser cero. Ese sería el modelo correcto de esta distribución. No solo la densidad debe ser infinita, sino que la integral sobre [x e y] debe ser 1. ¡Esto es muy difícil de implementar en la computadora! No solo eso, sino que también es básicamente imposible. Supongamos que deseas calcular esta función a través de algún tipo de red neuronal; tu red neuronal tendrá que tener pesos infinitos, y deberán calibrarse de tal manera que la integral de la salida de ese sistema en todo el dominio es 1. Eso es básicamente imposible. El exacto y correcto modelo probabilístico para este ejemplo de datos en particular es imposible. Esto es lo que la máxima verosimilitud querrá que produzcas, y no hay computadora en el mundo que pueda calcular esto. Entonces, de hecho, ni siquiera es interesante. Imagina que tienes el modelo de densidad perfecto para este ejemplo, que es una placa delgada en ese espacio (x, y), ¡no puedes hacer inferencias! Si te doy un valor de x y te pregunto "¿cuál es el mejor valor de y?" No podrías encontrarlo porque todos los valores de y, excepto un conjunto de probabilidad cero, tienen una probabilidad de cero, y solo hay unos pocos valores que son posibles. Para estos valores de x por ejemplo:

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Example for multiple prediction of EBM as an implicit function
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Ejemplo de predicción múltiple de EBM como función implícita
</center>

<!--
There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]!

So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regulariser})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser.

So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong.
-->

Hay 3 valores de y que son posibles y son infinitamente estrechos. Entonces no podrías encontrarlos. No existe un algoritmo de inferencia que te permita encontrarlos. La única forma en que puedas encontrarlos es si haces que tu función de contraste sea suave y diferenciable, y luego puedes comenzar desde cualquier punto y, mediante el descenso de gradiente, puedes encontrar un buen valor para y para cualquier valor de x. Pero este no va a ser un buen modelo probabilístico de la distribución si la distribución es del tipo que mencioné. Así que aquí hay un caso en el que insistir en tener un buen modelo probabilístico es realmente malo. ¡La máxima verosimilitud apesta [en este caso]!

Entonces, si eres un verdadero bayesiano, dices "oh, pero puedes corregir esto teniendo una probabilidad a priori fuerte donde la probabilidad a priori dice que tu función de densidad tiene que ser suave". Podrías pensar en esto como una probabilidad a priori. Pero, todo lo que haces en términos bayesianos (toma el logaritmo del mismo, olvídate de la normalización) obtienes modelos basados en energía. Los modelos basados en energía que tienen un regularizador, que es aditivo a tu función de energía, son completamente equivalentes a los modelos bayesianos donde la probabilidad es exponencial de la energía, y ahora obtienes $\exp(\text{energy}) \exp(\text{regulariser})$, por lo que es igual a $\exp(\text{energy} + \text{regulariser})$. Y si eliminas el exponencial, tienes un modelo basado en energía con un regularizador aditivo.

Por lo tanto, existe una correspondencia entre los métodos probabilístico y bayesiano, pero insistir en que hacer la máxima verosimilitud a veces es malo para usted, particularmente en espacios de alta dimensión o espacios combinatorios donde su modelo probabilístico es muy incorrecto. No está muy mal en distribuciones discretas (está bien) pero en casos continuos, puede estar realmente mal. Y todos los modelos están equivocados.
