---
lang: es
lang-ref: ch.06-3
title: Arquitectura de las RNNs y modelos LSTM
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
translation-date: 19 Apr 2020
translator: LecJackS
---


<!--## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)-->
## [Descripción general](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

<!--RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is just temporal inputs of X. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions.-->
Una RNN (*Recurrent Neural Network*) es un tipo de arquitectura que podemos usar para manejar secuencias de datos. ¿Qué es una secuencia? De la lección de CNNs, aprendimos que una señal puede ser 1D, 2D o 3D dependiendo del dominio. El dominio se define como desde donde estamos mapeando y hacia qué. El manejo de datos secuenciales se trata básicamente de datos 1D ya que el dominio es solo entradas temporales de X. Sin embargo, también se puede usar RNNs para tratar datos 2D, donde se tienen dos direcciones.

<!--
### Vanilla vs. Recurrent NN-->
### NNs simples vs. NNs recurrentes

<!--Below is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input.-->
A continuación se muestra un diagrama de red neuronal simple (*vanilla*) con tres capas. "Vainilla" es un término estadounidense que significa simple. La burbuja rosada es el vector de entrada x, en el centro está la capa oculta en verde, y la capa azul final es la salida. Usando un ejemplo de la electrónica digital a la derecha, esto es como compuerta lógica combinacional, donde la corriente de salida solo depende de la corriente de entrada.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 1:</b> Arquitectura Simple
</center>

<!--In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown on the left of the image above. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.-->
A diferencia de una red neuronal simple, en las redes neuronales recurrentes la salida actual depende no solo de la entrada actual, sino también del estado del sistema, que se muestra a la izquierda de la imagen de arriba. Esto es como una compuerta lógica secuencial en electrónica digital, donde la salida también depende de un "flip-flop" (una unidad de memoria básica en electrónica digital). Por lo tanto, la principal diferencia aquí es que la salida de una red neuronal simple solo depende de la entrada actual, mientras que la de una RNN también depende del estado del sistema.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 2:</b> Arquitectura de una RNN
</center>

<!--Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in the diagram above the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.-->
El diagrama de Yann agrega estas figuras entre las neuronas para representar el mapeo entre un tensor y otro (de un vector a otro). Por ejemplo, en el diagrama anterior, el vector de entrada x viajará a través de este elemento adicional a las representaciones ocultas h. Este elemento es en realidad una transformación afín, es decir, rotación más distorsión. Luego, a través de otra transformación, pasamos de la capa oculta a la salida final. Del mismo modo, en el diagrama de la RNN, se pueden tener los mismos elementos adicionales entre las neuronas.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Yann's RNN Architecture
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 3:</b> Arquitectura de una RNN de Yann
</center>

<!--
### Four types of RNN Architectures and Examples-->
### Cuatro tipos de Arquitecturas de RNNs y algunos ejemplos

<!--The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.-->
El primer caso es de una arquitectura del tipo *vector a secuencia*. La entrada será el círculo rosa y luego habrá evoluciones del estado interno del sistema representados como burbujas verdes. A medida que evoluciona el estado del sistema, para cada paso de tiempo habrá una salida específica, representada en azul.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Architecture 1: Vec to Seq
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 4:</b> Arquitectura 1: Vec a Sec
</center>

<!--An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using the diagram above, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.-->
Un ejemplo de este tipo de arquitectura es tener una entrada de tipo imagen, mientras que la salida será una secuencia de palabras que representan las descripciones en español de la imagen de entrada. Haciendo uso del diagrama anterior, cada burbuja azul puede ser un índice en un diccionario de palabras en español. Por ejemplo, si la salida es la oración "Este es un autobús escolar amarillo". Primero se obtiene el índice de la palabra "Esto", luego el índice de la palabra "es" y así sucesivamente. Algunos de los resultados de esta red se muestran a continuación. Por ejemplo, en la primera columna, la descripción de la última imagen es "Una manada de elefantes caminando por un campo de hierba seca", la cual está muy bien refinada. Luego, en la segunda columna, la primera imagen muestra "Dos perros juegan en la hierba", cuando en realidad son tres perros. En la última columna están los ejemplos más equivocados, como "Un autobús escolar amarillo estacionado en un estacionamiento". En general, estos resultados muestran que esta red puede fallar drásticamente y a veces funciona bien. Este es el caso de un vector de entrada, que es la representación de una imagen, a una secuencia de símbolos, que son, por ejemplo, caracteres o palabras que forman las oraciones en inglés. Este tipo de arquitectura se llama red autorregresiva. Una red autorregresiva es una red que proporciona una salida a partir de que se alimenta como entrada la salida anterior.

<!--The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.-->
El segundo tipo de arquitectura es de secuencia a un vector final (*secuencia a vector*). Esta red se va alimentando con una secuencia de símbolos y solo al terminar devuelve un resultado final. Una aplicación de esto puede ser usar la red para interpretar Python. Por ejemplo, la entrada son estas líneas del programa Python.


<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Architecture 2: Sec to Vec
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 5:</b> Arquitectura 2: Sec a Vec
</center>

<!--Then network will be able to output the correct solution of this program. Another more complicated program like this:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Architecture 2: Sec to Vec
</center>-->
Entonces la red podrá generar la solución correcta a este programa. Otro programa más complicado puede ser este:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 6:</b> Arquitectura 2: Sec a Vec
</center>

<!--Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.-->
En la que la salida debería ser 12184. Estos dos ejemplos muestran que se puede entrenar una red neuronal para hacer este tipo de operación. Solo necesitamos alimentarla con una secuencia de símbolos y hacer que la salida final sea un valor específico.

<!--The third is sequence to vector to sequence. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).-->
El tercer tipo de arquitectura es *secuencia a vector a secuencia*. Esta arquitectura solía ser la forma estándar de realizar traducción de idiomas. Se comienza con una secuencia de símbolos que se muestran aquí en rosa. Entonces todo se condensa en esta h final, que representa un concepto. Por ejemplo, podemos tener una oración como entrada y comprimirla temporalmente en un vector, que representa el significado y el mensaje que se debe enviar. Luego, después de obtener este significado en cualquier representación, la red lo desenrolla en un idioma diferente. Por ejemplo, "Hoy estoy muy feliz" como secuencia de palabras en español se puede traducir al italiano o al chino. En general, la red obtiene algún tipo de codificación como entradas y las convierte en una representación comprimida. Finalmente, realiza la decodificación dada la misma versión comprimida. En los últimos tiempos, se ha observado que redes como Transformers, que cubriremos en la próxima lección, superan este método en las tareas de traducción de idiomas. Este tipo de arquitectura solía ser tecnología de punta (*SOTA*) hace unos dos años (2018).

<!--If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Architecture 3: Seq to Vec to Seq
</center>-->
Si se realiza un PCA sobre el espacio latente, se obtendrán las palabras agrupadas por semántica como se muestra en este gráfico.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 7:</b> Arquitectura 3: Sec a Vec to Sec
</center>

<!--If we zoom in, we will see that the in the same location there are all the months, like January and November.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Architecture 3: Seq to Vec to Seq
</center>-->
Si hacemos zoom, veremos que en una misma ubicación se encuentran todos los meses, como enero y noviembre.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 8:</b> Arquitectura 3: Sec a Vec a Sec
</center>

<!--If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Architecture 3: Seq to Vec to Seq
</center>-->
Al enfocarse en una región diferente, se obtienen frases como "hace unos días", "los próximos meses", etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 9:</b> Arquitectura 3: Sec a Vec a Sec
</center>

<!--From these examples, we see that different locations will have some specific common meanings.-->
A partir de estos ejemplos, vemos que diferentes ubicaciones tendrán algunos significados comunes específicos.

<!--The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown below. You input the top prompt and then this network will try to complete the rest.-->
El cuarto y último caso es *secuencia a secuencia*. En esta red, a medida que se comienza a alimentar la entrada, la red comienza a generar salidas. Un ejemplo de este tipo de arquitectura es T9, que si recuerdas haber usado un teléfono Nokia, recibirías sugerencias de texto mientras escribías. Otro ejemplo es conversión de audio hablado a subtítulos. Un buen ejemplo es este escritor RNN. Cuando se comienza a escribir "los anillos de Saturno brillaron mientras", sugiere lo siguiente "dos hombres se miraron". Esta red fue entrenada sobre algunas novelas de ciencia ficción para que al escribir algo genere sugerencias que ayuden a escribir un libro. Un ejemplo más se muestra a continuación. Se ingresa algo en el indicador superior y luego esta red intentará completar el resto.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Architecture 4: Seq to Seq
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 10:</b> Arquitectura 4: Sec a Sec
</center>

<!--
## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)-->
## [Propagación Hacia Atrás a través del tiempo](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)

<!--
### Model architecture-->
### Arquitectura del modelo

<!--In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.-->
Para entrenar a un RNN, se debe utilizar la propagación hacia atrás a través del tiempo (*BPTT*). La arquitectura del modelo de RNN se muestra en la figura a continuación. El diseño de la izquierda utiliza la representación de bucle, mientras que la figura derecha despliega o desenrolla el bucle en una fila a lo largo del tiempo.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Back Propagation through time
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 11:</b> Propagación Hacia Atrás a través del tiempo
</center>

<!--Hidden representations are stated as-->
Las representaciones ocultas se declaran como

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

<!--The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as-->
La primera ecuación indica una función no lineal aplicada a una rotación sobre una versión de entrada apilada, donde se agrega la configuración previa de la capa oculta. Al principio, $h[0]$ se establece como 0. Para simplificar la ecuación, $W_h$ se puede escribir como dos matrices separadas, $\left[ W_{hx}\ W_{hh} \right]$, por lo que a veces la transformación se expresa como

$$
W_{hx} \cdot x[t] + W_{hh} \cdot h[t-1]
$$

<!--which corresponds to the stack representation of the input.-->
que corresponde a la representación apilada de la entrada.

<!--$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step.-->
$y[t]$ se calcula en la rotación final y luego podemos usar la regla de la cadena para propagar el error al paso de tiempo anterior.

<!--
### Batch-Ification in Language Modeling-->
### Batch-Ificación en modelado de idiomas

<!--When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.-->
Cuando se trata de una secuencia de símbolos, podemos separar el texto en batches de diferentes tamaños. Por ejemplo, cuando se trata de secuencias que se muestran en la siguiente figura, se aplica primero la separación en lotes, donde el dominio del tiempo se conserva verticalmente. En este caso, el tamaño del batch se establece en 4.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b>Batch-Idfication
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 12:</b> Batch-Ificación
</center>

<!--If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as-->
Si el período $T$ de BPTT se establece en 3, la primera entrada $x[1:T]$ y la salida $y[1:T]$ para RNNs se determina como

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

<!--When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.-->
Para procesar el primer lote a través de la RNN, en primer lugar, introducimos $x[1] = [a\ g\ m\ s]$ en la RNN y forzamos la salida a ser $y[1] = [b\ h\ n\ t]$. La representación oculta $h[1]$ se enviará al siguiente paso para ayudar a la RNN a predecir $y[2]$ a partir de $x[2]$. Después de enviar $h[T-1]$ al conjunto final de $x[T]$ e $y[T]$, cortamos el proceso de propagación de gradiente para $h[T]$ y $h[0]$, para que los gradientes no se propaguen infinitamente (`.detach()` en Pytorch). El proceso completo se muestra en la figura a continuación.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b>Batch-Idfication
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 13:</b> Batch-Ificación
</center>

<!--
## Vanishing and Exploding Gradient-->
## Desvanecimiento y Explosión de Gradiente

<!--
### Problem-->
### Problema

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b>Vanishing problem
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 14:</b>Problema del Desvanecimiento
</center>

<!--The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.-->
La figura anterior es una arquitectura típica de RNN. Para realizar la operación de rotación sobre los pasos anteriores en RNNs, utilizamos matrices, que pueden considerarse flechas horizontales en el modelo anterior. Dado que las matrices pueden cambiar el tamaño de las salidas, si el determinante de ellas es mayor que 1, el gradiente se inflará con el tiempo y causará una explosión de gradiente. En términos relativos, si el autovalor o valor propio que seleccionamos es pequeño y cercano a 0, el proceso de propagación reducirá los gradientes y producirá el desvanecimiento del gradiente.

<!--In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.-->
En las RNNs típicas, los gradientes se propagarán a través de todas las flechas posibles, lo que brinda a los gradientes una gran oportunidad de desaparecer o explotar. Por ejemplo, el gradiente en el tiempo 1 es grande, indicado con color más claro. Cuando pasa por una rotación, el gradiente se encoge mucho y en el paso temporal 3, se reduce a cero y muere.

<!--
### Solution-->
### Solución

<!--An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.-->
Una estrategia ideal para evitar que los gradientes exploten o desaparezcan, es evitar o saltarse las conexiones. Para lograr ésto, se pueden usar redes de multiplicación.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b>Skip connection
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 15:</b> Saltar conexiones
</center>

<!--In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.-->
En el caso anterior, dividimos la red original en 4 redes. Comencemos por la primera red. Toma un valor de la entrada en el tiempo 1 y envía la salida al primer estado intermedio en la capa oculta. El estado tiene otras 3 redes donde los "$\circ$"s permiten que los gradientes pasen mientras que los "$-$"s bloquean la propagación. Dicha técnica se llama red recurrente con compuertas (*Gated RNN*).

<!--LSTM is one prevalent gated RNN and is introduced in detail in the following sections.-->
LSTM (*Long Short-Term Memory*: Memoria Prolongada de Corto Plazo) es un tipo frecuente de RNN con compuertas y se presenta en detalle en las siguientes secciones.


## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)
<!--
### Model Architecture-->
### Arquitectura del Modelo

<!--Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.-->
A continuación hay ecuaciones que expresan una LSTM. La compuerta de entrada se resalta con cuadros amarillos, que será una transformación afín. Esta transformación de entrada multiplicará $c[t]$, que es nuestra compuerta candidata.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b>LSTM Architecture
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 16:</b> Arquitectura LSTM
</center>

<!--Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c[t]}$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.-->
La compuerta "*no-olvidar*" $f$ (*don't forget*) está multiplicando el valor anterior de la celda de memoria $c[t-1]$. El valor total de la celda $c[t]$ es el de la compuerta *no-olvidar* más el de la compuerta de entrada. La representación oculta final es la multiplicación elemento a elemento entre la compuerta de salida $o[t]$ y la tangente hiperbólica aplicada a la celda $c[t]$, de modo que los límites superior e inferior estén acotados. Finalmente, la compuerta candidata $\tilde{c}[t]$ es simplemente una red recurrente. Entonces tenemos una $o[t]$ para modular la salida, una $f[t]$ para modular la compuerta de no olvidar y una $i[t]$ para modular la compuerta de entrada. Todas estas interacciones entre la memoria y las compuertas son interacciones multiplicativas. $i[t]$, $f[t]$ y $o[t]$ son todas funciones sigmoides, que van de cero a uno. Por lo tanto, cuando se multiplica por cero, se tiene una compuerta cerrada. Al multiplicar por uno, se obtiene una compuerta abierta.

<!--How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b>LSTM Architecture - Output On
</center>-->
¿Cómo apagamos la salida? Digamos que tenemos una representación interna púrpura $th$ y ponemos un cero en la compuerta de salida. Entonces la salida será cero multiplicado por algo, con lo que obtenemos un cero. Si ponemos un uno en la compuerta de salida, obtendremos el mismo valor que la representación púrpura.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 17:</b> Arquitectura LSTM - Salida Activada
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b>LSTM Architecture - Output Off
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 18:</b> Arquitectura LSTM - Salida Desactivada
</center>

<!--Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and i[t] be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.-->
Del mismo modo podemos controlar la celda de memoria. Por ejemplo, podemos **reiniciarla** haciendo que $f[t]$ e $i[t]$ sean ceros. Después de la multiplicación y la suma, tendremos un cero dentro de la memoria. De lo contrario, podemos **mantener** la memoria, aún teniendo un cero en la representación interna $th$, pero manteniendo un uno en $f[t]$. Por lo tanto, la suma resulta en $c[t-1]$ y sigue su camino. Finalmente, podemos **escribir**, para lo cual debemos obtener un uno en la puerta de entrada, con lo que la multiplicación se vuelve púrpura, y luego establecer un cero en la compuerta de no olvidar para que realmente se olvide.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b>Visualization of the Memory Cell
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Visualización de la Celda de Memoria
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b>LSTM Architecture - Reset Memory
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 20:</b> Arquitectura LSTM - Reinicio de Memoria
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b>LSTM Architecture - Keep Memory
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 21:</b> Arquitectura LSTM - Mantener Memoria
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b>LSTM Architecture - Write Memory
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 22:</b> Architectura LSTM - Escribir Memoria
</center>

<!--
## Notebook Examples-->
## Ejemplos en Jupyter Notebook

<!--
### Sequence Classification-->
### Clasificación de Secuencias

<!--The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.-->
El objetivo es clasificar secuencias. Los elementos y objetivos se representan localmente (vectores de entrada con un solo bit distinto de cero). La secuencia comienza (***b**egins*) con una `B`, termina (***e**nds*) con una `E` (el "símbolo de activación"), y de lo contrario consiste en símbolos elegidos al azar del conjunto `{a, b, c , d}` excepto por dos elementos en las posiciones $t_1$ y $t_2$ que son `X` o `Y`. Para el caso `DifficultyLevel.HARD`, la longitud de la secuencia se elige aleatoriamente entre 100 y 110, $t_1$ se elige aleatoriamente entre 10 y 20, y $t_2$ se elige aleatoriamente entre 50 y 60. Hay 4 clases de secuencia: `Q`, `R`, `S` y `U`, que dependen del orden temporal de `X` e `Y`. Las reglas son: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

<!--1). Dataset Exploration-->
1). Exploración de conjunto de datos

<!--The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.-->
El tipo de retorno de un generador de datos es una tupla con longitud 2. El primer elemento de la tupla es el batch de secuencias con forma $(32, 9, 8)$. Estos son los datos que se enviarán a la red. Hay ocho símbolos diferentes en cada fila (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Cada fila es un vector one-hot. Una secuencia de filas representa una secuencia de símbolos. La primera fila de todos ceros es de relleno (*padding*). Usamos relleno cuando la longitud de la secuencia es más corta que la longitud máxima del batch. El segundo elemento en la tupla es el batch de etiquetas de clase correspondientes con forma $(32, 4)$, ya que tenemos 4 clases (`Q`, `R`, `S` y `U`). La primera secuencia es: `BbXcXcbE`. Entonces su etiqueta de clase decodificada es $[1, 0, 0, 0]$, correspondiente a `Q`.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> Input Vector Example
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figura 23:</b> Ejemplo de Vector de Entrada
</center>

<!--
2). Defining the Model and Training-->
2). Definiendo el Modelo y Entrenamiento

<!--Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:-->
Creemos una red recurrente simple, una LSTM, y entrenemos durante 10 *epochs*. En el ciclo de entrenamiento, siempre debemos respetar cinco pasos:

<!-- * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient-->
* Realizar el pasaje hacia adelante del modelo
* Calcular el error (*loss*)
* Reiniciar a cero el caché de gradientes
* Propagar hacia atrás para calcular la derivada parcial del error con respecto a los parámetros
* Dar un pequeño paso en la dirección opuesta a la del gradiente

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b>Simple RNN vs LSTM - 10 Epochs
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 24:</b> RNN Simple vs LSTM - 10 Epochs
</center>

<!--With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.-->
Con un nivel de dificultad fácil, la RNN obtiene un 50% de precisión mientras que la LSTM obtiene un 100% después de 10 epochs. Pero la LSTM tiene cuatro veces más parámetros que la RNN y también tiene dos capas ocultas, por lo que no es una comparación justa. Después de 100 epochs, la RNN también obtiene un 100% de precisión, lo que muestra que se tarda más en entrenarla que a una LSTM.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b>Simple RNN vs LSTM - 100 Epochs
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 25:</b> RNN Simple vs LSTM - 100 Epochs
</center>

<!--If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.-->
Si aumentamos la dificultad de la parte de entrenamiento (usando secuencias más largas), veremos que la RNN falla, mientras LSTM continúa funcionando.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b>Visualization of Hidden State Value
</center>-->
<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 26:</b> Visualización de los Valores del Estado Oculto
</center>

<!--The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence.-->
La visualización anterior está mostrando el valor del estado oculto a lo largo del tiempo en una LSTM. Pasaremos las entradas a través de una tangente hiperbólica, de modo que si la entrada está por debajo de $-2.5$, se asignará un $-1$, y si está por encima de $2.5$, se asignará un $1$. Entonces, en este caso, podemos ver la capa oculta específica que pone su atención en `X` (quinta fila en la imagen) para luego volverse roja hasta que se observó la otra `X`. Entonces, la quinta unidad oculta de la celda se activa al observar la `X` y se queda en silencio después de ver la otra `X`. Esto es lo que nos permite reconocer la clase de cada secuencia.

<!--
### Signal Echoing-->
### Señal de Eco

<!--Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.-->
La señal de eco de n pasos es un ejemplo de tarea sincronizada de muchos-a-muchos. Por ejemplo, la primera secuencia de entrada es `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, y la primera secuencia objetivo es `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. En este caso, el resultado es tres pasos después. Por lo tanto, necesitamos una memoria de trabajo de tiempo corto para mantener la información. Mientras que en el modelo de lenguajes, se debe decir algo que aún no se ha dicho.

<!--Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past.-->
Antes de enviar toda la secuencia a la red y forzar el objetivo final a ser "algo", necesitamos cortar la secuencia larga en pequeños trozos. Mientras alimentamos un nuevo fragmento, debemos mantener un estado oculto y enviarlo como entrada al estado interno junto con el siguiente fragmento nuevo. Con LSTMs, se puede mantener la memoria durante mucho tiempo, siempre que tenga suficiente capacidad. En las RNNs, después de alcanzar cierta longitud, se comienza a olvidar lo que sucedió en el pasado.
