---
lang-ref: ch.06-2
lecturer: Yann LeCun
title: RNNs, GRUs, LSTMs, Atención, Seq2Seq, y Redes de Memoria
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 Mar 2020
lang: es
translation-date: 10 May 2020
translator: Victor Peñaloza
---

<!--## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)-->

## [Arquitecturas de Aprendizaje Supervisado](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

<!--In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.-->
En aprendizaje supervisado, existen diferentes módulos para realizar diferentes funciones. Ser hábil en aprendizaje supervisado implica diseñar arquitecturas para cumplir tareas específicas. Similar a escribir programas con algoritmos para dar instrucciones a una computadora en días pasados, el aprendizaje supervisado reduce una función compleja a un grafo de módulos funcionales (posiblemente dinámico), cuyas funciones son finalizadas por aprendizaje.

<!--As with what we saw with convolutional networks, network architecture is important.-->
Así como lo vimos con las redes convolucionales, la arquitectura de la red es importante.


<!--## Recurrent Networks-->
## Redes Recurrentes

<!--In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.-->
En una Red Neuronal Convolucional, el grafo o las interconexiones entre los módulos no pueden tener ciclos. Existe al menos un orden parcial entre los módulos de tal forma que las entradas están disponibles cuando calculamos las salidas.

<!--As shown in Figure 1, there are loops in Recurrent Neural Networks.-->
Como es mostrado en la Figura 1, hay ciclos en las Redes Neuronales Recurrentes.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
<!--Figure 1. Recurrent Neural Network with roll-->
Figura 1. Red Neuronal Recurrente envuelta
</center>

 - $x(t)$ : <!--input that varies across time--> entrada que varía a través del tiempo.
 - $\text{Enc}(x(t))$:<!-- encoder that generates a representation of input--> codificador que genera una representación de la entrada.
 - $h(t)$:<!-- a representation of the input--> una representación de la entrada.
 - $w$:<!-- trainable parameters--> parámetros entrenables.
 - $z(t-1)$:<!-- previous hidden state, which is the output of the previous time step--> estado oculto previo, el cual es la salida del instante de tiempo previo.
 - $z(t)$:<!-- current hidden state--> estado oculto actual.
 - $g$:<!-- function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step--> función que puede ser una complicada red neuronal; una de las entradas es $z(t-1)$ la cual es la salida del instante de tiempo previo.
 - $\text{Dec}(z(t))$:<!-- decoder that generates an output--> decodificador que genera una salida.


<!--## Recurrent Networks: Unroll the loop-->
## Redes Recurrentes: Desenvolviendo el ciclo

<!--Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$.-->
Desenvolviendo el ciclo en el tiempo. La entrada es una secuencia $x_1, x_2, \cdots, x_T$.

<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
<!--Figure 2. Recurrent Networks with unrolled loop-->
Figura 2. Redes Recurrentes con el ciclo desenvuelto
</center>

<!--In Figure 2, the input is $x_1, x_2, x_3$.-->
En la Figura 2, la entrada es $x_1, x_2, x_3$.

<!--At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.-->
En el tiempo t=0, la entrada $x(0)$ es enviada al codificador y este genera la representación $h(x(0)) = \text{Enc}(x(0))$ posteriormente pasa hacia G para generar el estado oculto $z(0) = G(h_0, z', w)$. En $t = 0$, $z'$ en $G$ puede ser inicializada como $0$ o inicializada aleatoriamente. $z(0)$ es enviado al decodificador para generar una salida y también hacia el siguiente instante de tiempo.

<!--As there are no loops in this network, and we can implement backpropagation.-->
Como no hay ciclos en esta red, podemos implementar propagación hacia atrás.

<!--Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.-->
La Figura 2 muestra una red regular con una característica particular: cada bloque comparte los mismos pesos. Codificadores, decodificadores y funciones G tienen los mismos pesos respectivamente a través de diferentes instantes de tiempo.

<!--BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN.-->
BPTT: Propagación hacia atrás a través del tiempo (Brackprop through time). Desafortunadamente, BPTT no funciona muy bien en la forma simplista de una RNN.

<!--Problems with RNNs:-->
Problemas con RNNs:

<!--1. Vanishing gradients-->
   <!--- In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.-->
<!--2. Exploding gradients-->
   <!--- If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work.-->

1. Desvanecimiento de gradientes
   - En una secuencia larga, las gradientes son multiplicadas por la matriz de pesos (transpuesta) en cada instante de tiempo. Si hay valores pequeños en la matriz de pesos, la norma de las gradientes se volverá más pequeña cada vez exponencialmente.
2. Explosión de gradientes
   - Si tenemos una gran matriz de pesos y la no linealidad en la capa recurrente no está saturando, las gradientes explotaran. Los pesos divergirán en el paso de actualización. Podríamos tener que utilizar una tasa de aprendizaje muy pequeña para hacer que el algoritmo de gradiente descendiente funcione.

<!--One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.-->
Una razón para utilizar RNNs es por la ventaja de recordar información en el pasado. Sin embargo, con una simple RNN sin modificaciones, se podría fallar en la memorización de información a largo plazo.

<!--An example that has vanishing gradient problem:-->
Un ejemplo que tiene el problema de desvanecimiento de gradiente:

<!--The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program.-->
La entrada son los caracteres de un programa en C. El sistema dirá cuando este programa es un programa sintácticamente correcto. Un programa sintéticamente correcto debería tener un numero valido de llaves y paréntesis. Así, la red debería recordar cuantos paréntesis y llaves abiertas hay por revisar, y cuando habremos cerrado todas. La red tiene que almacenar dicha información en estados ocultos, como un contador. Sin embargo, debido al desvanecimiento de gradientes, la red fallara en preservar dicha información en un programa muy extenso.


<!--##  RNN Tricks-->
##  Trucos RNN

<!--- clipping gradients:  (avoid exploding gradients)-->
   <!--Squash the gradients when they get too large.-->
<!--- Initialization (start in right ballpark avoids exploding/vanishing)-->
   <!--Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix.-->
- Recorte de gradientes: (evitar la explosión de gradientes).
   Reducir las gradientes cuando estas se vuelvan muy grandes.
- Inicialización (iniciar en la región aproximada evita el desvanecimiento/explosión de gradientes).
   Inicializar las matrices de pesos para preservar la norma en algún grado. Por ejemplo, la inicialización ortogonal inicializa la matriz de pesos como una matriz ortogonal aleatoria.


<!--## Multiplicative Modules-->
## Módulos Multiplicativos

<!--In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.-->
En los módulos multiplicativos en lugar de solo calcular una suma ponderada de entradas, calculamos productos de entradas y luego calculamos la suma ponderada de eso.

<!--Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor.-->
Supongamos $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Aquí U es un tensor.

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$
<!--where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.-->
En donde $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

<!--The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.-->
La salida del sistema es una clásica suma ponderada de entradas y pesos. Los pesos por si mismos son también sumas ponderadas de pesos y entradas.

<!--Hypernetwork architecture: weights are computed by another network.-->
Arquitectura Híper-red: pesos son calculados por otra red.


<!--## Attention-->
## Atención

<!--$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.-->
$x_1$ y $x_2$ son vectores, $w_1$ y $w_2$ son escalares después de softmax donde $w_1 + w_2 = 1$, y  $w_1$ y $w_2$ están entre 0 y 1.

<!--$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.-->
$w_1x_1 + w_2x_2$ es una suma ponderada de $x_1$ y $x_2$ ponderada por coeficientes $w_1$ y $w_2$.

<!--By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.-->
Cambiando el tamaño relativo de $w_1$ y $w_2$, podemos intercambiar la salida de $w_1x_1 + w_2x_2$ a $x_1$ o $x_2$ o a alguna de las combinaciones lineales de $x_1$ y $x_2$.

<!--The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.-->
Las entradas pueden tener múltiples $x$ vectores (más que solo $x_1$ y $x_2$). El sistema escogerá una combinación apropiada, la elección de cual, está determinada por otra variable z. Un mecanismo de atención permite a la red neuronal enfocar su atención en entrada(s) determinadas e ignorar a las otras.

<!--Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.-->
Atención es cada vez más importante en sistemas NLP que utilizan arquitecturas transformadoras u otros tipos de atención.

<!--The weights are data independent because z is data independent.-->
Los pesos son independientes de los datos porque z es independiente de los datos.


<!--## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)-->
## [Unidades recurrentes con compuertas (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

<!--As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below:-->
Como es mencionado más arriba, las RNNs sufren de desvanecimiento/explosión de gradientes y no pueden recordar estados por mucho. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), es una aplicación de módulos multiplicativos que intenta resolver estos problemas. Es un ejemplo de red recurrente con memoria (otro es LSTM). La estructura de una unidad GRU es mostrada a continuación:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
<!--Figure 3. Gated Recurrent Unit-->
Figura 3. Unidad Recurrente con compuertas
</center>

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$
<!--where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.-->
En donde $\odot$ denota multiplicación entre elementos (producto Hadamard), $x_t$ es el vector de entrada, $h_t$ es el vector de salida, $z_t$ es el vector de compuerta de actualización, $r_t$ es el vector de compuerta de reinicio, $\phi_h$es una tan hiperbólica tanh, y $W$,$U$,$b$ son parámetros aprendibles.

<!--To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.-->
Para ser específicos, $z_t$ es un vector compuerta que determina cuanto de la información del pasado debería ser enviada hacia el futuro. Aplica una función sigmoide a la suma de dos capas lineales y un sesgo sobre la entrada $x_t$ y el estado previo $h_{t-1}$.  $z_t$ contiene coeficientes entre 0 y 1 como resultado de aplicar sigmoide. El estado final de salida $h_t$es una combinación convexa de $h_{t-1}$ y $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ vía $z_t$. Si el coeficiente es 1, la unidad actual de salida es simplemente una copia del estado previo e ignora la entrada (lo cual es el comportamiento por defecto). Si es menos que uno, se tomara en cuenta alguna nueva información proveniente de la entrada.

<!--The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input.-->
La compuerta de reinicio $r_t$es utilizada para decidir cuanto olvidar de la información del pasado. En el nuevo contenido de la memoria $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, si el coeficiente en $r_t$ es 0, entonces no se almacena nada de la información del pasado. Si al mismo tiempo $z_t$ es 0, entonces el sistema es completamente reiniciado ya que $h_t$ solo vería a la entrada.


<!--## LSTM (Long Short-Term Memory)-->
## LSTM (Gran Memoria a corto plazo)

<!--GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below:-->
GRU es en realidad una versión simplificada de LSTM la cual surgió mucho antes, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). Agrupando celdas de memoria para preservar información pasada, LSTMs también tienen como propósito resolver los problemas de pérdida de memoria a largo plazo en las RNNs. La estructura de las LSTMs se muestra a continuación:

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
<!--Figure 4. LSTM-->
Figura 4. LSTM
</center>

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$
<!--where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.-->
En donde $\odot$ denota multiplicación entre elementos, $x_t\in\mathbb{R}^a$ es un vector de entrada hacia la unidad LSTM, $f_t\in\mathbb{R}^h$ es el vector de activación de la compuerta de olvido, $i_t\in\mathbb{R}^h$ es el vector de activación de la compuerta de entrada/actualización, $o_t\in\mathbb{R}^h$ es el vector de activación de la compuerta de salida, $h_t\in\mathbb{R}^h$ es el vector de estados ocultos (también conocido como salida),$c_t\in\mathbb{R}^h$ es el vector de estado de la celda.

<!--An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.-->
Una unidad LSTM utiliza un estado de celda $c_t$ para transportar información a través de la unidad. Regula cuanta información es preservada o removida del estado de la celda a través de estructuras llamadas compuertas. La compuerta de olvido $f_t$ decide cuanta información proveniente del estado de la celda previa $c{t-1}$ queremos preservar, *observando la entrada actual y el estado oculto previo, produce un numero entre 0 y 1 como el coeficiente de* $c{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ calcula un nuevo candidato para actualizar el estado de la celda, y al igual que la compuerta de olvido, la compuerta de entrada $i_t$ decide cuanto de la actualización será aplicada. Finalmente, la salida $h_t$ estará basada en el estado de celda $c_t$, pero será puesta a través de una $\tanh$ que luego será filtrada por la compuerta de salida $o_t$.

<!--Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers.-->
Aunque LSTMs son ampliamente usadas en NLP, su popularidad está disminuyendo. Por ejemplo, el reconocimiento del habla se está moviendo hacia la utilización de redes CNN temporales, y NLP está moviéndose hacia la utilización de transformadores.


<!--## Sequence to Sequence Model-->
## Modelo Secuencia a Secuencia

<!--The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs.-->
El enfoque propuesto por [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) es el primer sistema de máquina neuronal de traducción en tener un rendimiento comparable a enfoques clásicos. Utiliza una arquitectura codificador-decodificador donde ambos el codificador y el decodificador son LSTMs multicapa.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
<!--Figure 5. Seq2Seq-->
Figura 5. Seq2Seq
</center>
<!--Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.-->
Cada celda en la figura es una LSTM. Para el codificador (la parte en la izquierda), el número de pasos de tiempo es igual a la longitud de la secuencia a ser traducida. En cada paso, hay una pila de LSTMs (cuatro capas en la publicación original) donde el estado oculto de la LSTM previa es alimentado hacia el siguiente. La última capa del último paso de tiempo entrega un vector que representa el significado de la oración completa, la cual es luego enviada hacia otra LSTM multicapa (el decodificador), que produce palabras en el lenguaje objetivo. En el decodificador, el texto es generado en una forma secuencial. Cada paso produce una palabra, la cual será una entrada para el siguiente paso de tiempo.

<!--This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information.-->
Esta arquitectura no es satisfactoria de dos maneras: Primero, el significado completo de la oración tiene que ser comprimido hacia el estado oculto entre el codificador y el decodificador. Segundo, las LSTMs realmente no preservan información por más que cerca de 20 palabras. La solución para estos problemas es llamada Bi-LSTM, la cual ejecuta dos LSTMs en direcciones opuestas. En una Bi-LSTM el significado es codificado en dos vectores, uno generado por ejecutar la LSTM de izquierda a derecha, y otro de derecha a izquierda. Esto permite duplicar la longitud de la oración sin perder mucha información.


<!--## Seq2seq with Attention-->
## Seq2seq con Atención

<!--The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, i.e. the attention mechanism.-->
El éxito del enfoque antes mencionado fue de corta vida. Otra publicación por [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  sugería que en lugar de tener una gigantesca red que comprima el significado de la oración entera en un vector, tendría más sentido si en cada paso de tiempo solamente enfocáramos la atención en las ubicaciones relevantes en el lenguaje original con significado equivalente, i.e. el mecanismo de atención.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
<!--Figure 6. Seq2Seq with Attention-->
Figura 6. Seq2Seq con Atención
</center>
<!--In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!-->
En atención, para producir la palabra actual en cada paso de tiempo, necesitamos decidir en cuales representaciones ocultas de palabras en la oración de entrada enfocarnos. Esencialmente, una red aprenderá a evaluar que tan bien cada entrada codificada coincide con la salida actual del decodificador. Estos punteos son normalizados por una función softmax, luego los coeficientes son utilizados para calcular una suma ponderada de los estados ocultos en el decodificador en diferentes pasos de tiempo. Ajustando los pesos, el sistema puede ajustar el área de entrada para enfocarse. La magia de este mecanismo es que la red utilizada para calcular los coeficientes puede ser entrenada a través de la propagación hacia atrás. ¡No hay necesidad de construirlas a mano!

<!--Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention.-->
Los mecanismos de atención transformaron completamente la traducción con máquinas neuronales. Tiempo después, Google publicó [*Atención Es Todo Lo Que Tú Necesitas*](https://arxiv.org/abs/1706.03762), ellos colocaron un transformador hacia adelante, donde cada capa y grupo de neuronas está implementando atención.


<!--## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)-->
## [Red de Memoria](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

<!--Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.-->
Las redes de memoria tienen sus raíces del trabajo en Facebook que fue iniciado por [Antoine Bordes](https://arxiv.org/abs/1410.3916) en 2014 y [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) en 2015.

<!--The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.-->
La idea de una red de memoria es que existen dos partes importantes en el cerebro: una es la **corteza**, que es donde se tiene la memoria a largo plazo. Existe un pedazo separado de neuronas llamado el **hipocampo** que envía conexiones a casi todas partes en la corteza. El hipocampo está pensado para ser utilizado por la memoria a corto plazo, recordando cosas por un relativo corto periodo de tiempo. La teoría predominante es que cuando se duerme, hay un montón de información transferida desde el hipocampo hacia la corteza para ser solidificada en la memoria a largo plazo ya que el hipocampo tiene capacidad limitada.

<!--For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result.-->
Para una red de memoria, existe una entrada a la red, $x$ (piensa en esto como una dirección de memoria), y compara esto $x$ con vectores $k_1, k_2, k_3, \cdots$ ("claves") a través del producto punto. Coloca todo esto a través de una función softmax, lo que obtienes es un arreglo de números que suman uno. Existe otro conjunto de otros vectores $v_1, v_2, v_3, \cdots$ ("valores"). Multiplica estos vectores por los escalares obtenidos de la función softmax y la suma de estos vectores (note el parecido al mecanismo de atención) le dará el resultado.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
<!--Figure 7. Memory Network-->
Figura 7. Red de Memoria
</center>
<!--If one of the keys (e.g. $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.-->
Si una de estas claves (e.g. $k_i$) coincide exactamente con $x$, entonces el coeficiente asociado con esta clave será muy cercano a uno. Entonces la salida del sistema será esencialmente $v_i$.

<!--This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.-->
Esta es una **memoria direccionable asociativa**. La memoria asociativa es aquella que, si tu entrada coincide con una clave, obtienes *ese* valor. Y estos es justamente a versión suave diferenciable de él, el cual permite la propagación hacia atrás y cambiar los vectores a través del gradiente descendiente.

<!--What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.-->
Lo que los autores hicieron fue contarle una historia a un sistema entregándole una secuencia de oraciones. Estas oraciones son codificadas en vectores ejecutándolas a través de una red neuronal que no ha sido pre-entrenada. Las oraciones son regresadas a la memoria de este tipo. Cuando realizas una pregunta al sistema, codificas la pregunta y la colocas como entrada de una red neuronal, la red neuronal produce un $x$ en la memoria, y la memoria retorna un valor.

<!--This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions.-->
Este valor, junto con el estado previo de la red, es utilizado para re-acceder a la memoria. Y puedes entrenar esta red completa para producir una respuesta a tu pregunta. Después de un entrenamiento extenso, este modelo realmente aprende a almacenar historias y responder preguntas.

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

<!--In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write.-->
En una red de memoria, existe una red neuronal que toma una entrada y produce una dirección para la memoria, regresa el valor hacia la red, se mantiene ejecutando, y eventualmente produce una salida. Esto es muy parecido a una computadora ya que hay un CPU y una memoria externa para leer y escribir.

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>
<!--Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>-->
Figura 8. Comparación entre una red de memoria y una computadora (Foto por <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Academy</a>)
</center>

<!--There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.-->
Existen personas que imaginan que se puede realmente construir **computadoras diferenciables** fuera de esto. Un ejemplo es la [Máquina Neuronal de Turing](https://arxiv.org/abs/1410.5401) de DeepMind, que fue hecha pública tres días después de que la publicación de Facebook fuera publicada en arXiv.

<!--The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks.-->
La idea es comparar entradas con claves, generar coeficientes, y producir valores – lo cual es básicamente lo que un transformador es. Un transformador es básicamente una red neuronal en la cual cada grupo de neuronas es una de estas redes.
