---
lang-ref: ch.06-1
lecturer: Yann LeCun
title: Aplicaciones de las Redes Convolucionales
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
lang: es
translation-date: 5 Jul 2020
translator : Victor Peñaloza
---


<!-- ## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s) -->
## [Reconocimiento de Código ZIP](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

<!-- In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network. -->

En la clase anterior, demostramos que una red convolucional puede reconocer dígitos, sin embargo, aún queda por saber como el modelo toma cada dígito y evita perturbaciones en los dígitos vecinos. El siguiente paso es detectar objetos que no se traslapen y utilizar el enfoque general de Supresión No-Máxima (NMS<sup>Non-Maximum Suppression</sup>). Ahora, dada la suposición que la entrada es una serie de dígitos que no se sobreponen, la estrategia es entrenar varias redes convolucionales y utilizar voto por mayoría o tomar los dígitos correspondientes a la puntación más alta generada por la red convolucional.


<!-- ### Recognition with CNN -->
### Reconocimiento con CNN

<!-- Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes. -->

Aquí presentamos la tarea de reconocimiento de 5 códigos ZIP que no se sobreponen. Al sistema no se le dio instrucciones sobre como separar cada dígito, pero sabe que debe predecir 5 dígitos. El sistema (Figura 1) consiste en 4 redes convolucionales de diferente tamaño, cada una produciendo un conjunto de salidas. La salida es representada en matrices. Las cuatro matrices de salida son de modelos con un ancho de filtro diferente en la última capa. En cada salida, hay 10 filas, representando 10 categorías de 0 a 9. El cuadrado blanco más grande representa una puntuación más alta en esa categoría. En estos cuatro bloques de salida, los tamaños horizontales de las últimas capas filtro son 5,4,3, y 2 respectivamente. El tamaño del filtro decide el ancho de la ventana del modelo que observa la entrada, por lo tanto, cada modelo está prediciendo dígitos basándose en diferentes tamaños de ventana. Luego el modelo toma un voto por mayoría y selecciona la categoría que corresponderá a la puntuación más alta de esa ventana. Para extraer información de utilidad, uno debe tener en cuenta que no todas las combinaciones de caracteres son posibles, por lo tanto, la corrección de errores aprovechando las restricciones de la entrada es de utilidad para asegurarse que las salidas son códigos ZIP verdaderos.


<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 1:</b> Múltiples clasificadores en el reconocimiento de códigos ZIP
</center>
<!-- Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit. -->

Ahora para ordenar los caracteres, el truco está en utilizar un algoritmo de distancia más corta. Desde que se nos ha dado rangos de caracteres posibles y el número total de dígitos a predecir, podemos afrontar este problema calculando el costo mínimo de producir dígitos y transiciones entre dígito. La ruta tiene que ser continua desde la celda más baja de la izquierda hacia la celda más arriba de la derecha en el grafo, y la ruta está restringida a solo contener movimientos de izquierda a derecha y de abajo hacia arriba. Note que, si el mismo número es repetido uno después de otro, el algoritmo debería ser capaz de distinguir que hay números repetidos en lugar de predecir un solo dígito.


<!-- ## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s) -->
## [Detección de Rostros](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

<!-- Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist. -->

Las redes neuronales convolucionales funcionan bien en tareas de detección y la detección de rostros no es la excepción. Para realizar detección de rostros hemos recopilado un conjunto de datos de imágenes con rostros y sin rostros, en los cuales hemos entrenado una red convolucional con un tamaño de ventana de 30 $\times$ 30 píxeles y le pedimos a la red que nos diga si existe un rostro o no. Una vez entrenada, aplicamos el modelo a una nueva imagen y si hay rostros aproximadamente dentro de una ventana de 30 $\times$ 30 píxeles, la red convolucional activara las salidas en las ubicaciones correspondientes. Sin embargo, dos problemas existen.

<!-- - **False Positives**: There are many ways that a patch of an image is not a face. During the training stage, the model may not see all of them (i.e. a fully representative set.). Therefore, the model may suffer from a lot of false positives at test time. -->

- **Falsos Positivos:** Hay muchas formas de que un pedazo de una imagen no sea un rostro. Durante la etapa de entrenamiento, el modelo podría no ver todo (i.e. un conjunto completamente representativo.) Por lo tanto, el modelo podría sufrir de un montón de falsos positivos en el tiempo de prueba.

<!-- - **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of  the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost. -->

- **Diferente Tamaño de Rostros:** No todos los rostros son de 30 $\times$ 30 píxeles, por lo tanto, rostros de diferentes tamaños podrían no ser detectados. Una forma de manejar este problema es generar versiones multi-escala de la misma imagen. El detector original detectará rostros cerca de 30 $\times$ 30 píxeles. Si aplicamos un escalamiento en la imagen por un factor de $\sqrt 2$, el modelo detectará rostros que son más pequeños en la imagen original ya que lo que eran 30 $\times$ 30 píxeles son ahora aproximadamente20 $\times$ 20 píxeles. Para detectar imágenes más grandes, podemos reducir el tamaño de la imagen. Este proceso no es costoso porque la mitad del costo viene de procesar la imagen original no-escalada. La suma de los costos de todas las otras redes combinadas es casi el mismo que procesar las imágenes originales no-escaladas. El tamaño de la red es el cuadrado del tamaño de la imagen en un lado, por lo tanto, si se reduce la escala de la imagen por $sqrt 2$, la red que necesitarías ejecutar es más pequeña por un factor de 2. Por lo tanto, el costo global es $1+1/2+1/4+1/8+1/16…$, el cual es igual a 2. Ejecutar un modelo multi-escala solo duplica el costo computacional.

<!-- ### A multi-scale face detection system -->
### Un Sistema de Detección de Rostros Multi-escala

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figura 2:</b> Sistema de detección de rostros
</center>

<!-- The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face. -->

Los mapas mostrados en la (Figura 3) indican las puntuaciones de los detectores de rostro. Este detector de rostros reconoce rostros que son de 20 $\times$ 20 píxeles de tamaño. En la escala-fina (Escala 3) hay varias puntuaciones altas, pero no son muy definitivas. Cuando el factor de escalamiento aumenta (Escala 6), observamos más regiones blancas agrupadas. Esas regiones blancas representan rostros detectados cuando aplicamos supresión no-máxima<sup>non-maximum suppression</sup> para obtener la ubicación final del rostro.

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 3:</b> Puntuaciones del detector de rostros para varios factores de escalamiento
</center>


<!-- ### Non-maximum suppression -->
### Supresión No-Máxima<sup>Non-maximum suppression</sup>

<!-- For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location. -->

Para cada región de alta-puntuación, existe probablemente un rostro por debajo. Si más rostros son detectados muy cerca del primero, significa que solo uno debería ser considerado correcto y el resto son incorrectos. Con supresión no-máxima, tomamos la puntuación más alta de los cuadros delimitadores que se traslapan y eliminamos los otros. El resultado será un solo cuadro delimitador en la ubicación óptima.


<!-- ### Negative mining -->
### Extracción Negativa<sup>Negative mining</sup>

<!-- In the last section, we discussed how the model will run into a large number of false positives at test time as there are many ways for objects to appear similar to a face. No training set will include all the non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches that the model detects as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives. -->

En la última sección, discutimos como el modelo ejecutará un gran número de falsos positivos en tiempo de prueba como tantas formas para los objetos sean similares a un rostro. Ningún conjunto de entrenamiento incluirá todos los objetos que no sean rostros que parezcan rostros. Podemos mitigar este problema a través de extracción negativa<sup>negative mining</sup>. En extracción negativa<sup>negative mining</sup>, creamos un conjunto de datos negativo de regiones de imágenes que no son rostros, que el modelo detecta como rostros. Los datos son recopilados ejecutando el modelo en entradas que se sabe no contienen rostros. Luego reentrenamos el detector utilizando el conjunto de datos negativo. Podemos repetir este proceso para incrementar la robustez de nuestro modelo contra los falsos positivos.


<!-- ## Semantic segmentation -->
## Segmentación Semántica

<!-- Semantic segmentation is the task of assigning a category to every pixel in an input image. -->
Segmentación semántica es la tarea de asignar una categoría a cada píxel en una imagen de entrada.


<!-- ### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s) -->
### [CNN para Visión Robótica Adaptativa de Largo Alcance](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

<!-- In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red. -->

En este proyecto, el objetivo fue etiquetar regiones de imágenes de entrada para que un robot pueda distinguir entre caminos y obstáculos. En la figura, las regiones verdes son áreas en las que el robot se puede conducir y las regiones rojas son obstáculos como grama alta. Para entrenar la red para esta tarea, tomamos un pedazo de la imagen y manualmente la etiquetamos como transitable o no (verde o roja). Luego entrenamos la red convolucional en los pedazos de imagen pidiéndole a la red predecir el color del pedazo de imagen. Una vez el sistema este suficientemente entrenado, es aplicado a la imagen completa, etiquetando todas las regiones de la imagen como verde o roja.

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 4:</b> CNN para Visión Robótica Adaptativa de Largo Alcance (DARPA LAGR programa 2005-2008)
</center>
<!-- There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle. -->
Existen cinco categorías para la predicción 1) súper verde, 2) verde, 3) purpura: obstáculo a nivel de línea de pie, 4) obstáculo rojo 5) súper rojo: definitivamente un obstáculo.

<!-- **Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it. -->
 **Etiquetas estéreo** (Figura 4, Columna 2)
Imágenes son capturadas por las 4 cámaras en el robot, las cuales son agrupadas en 2 pares de visión estéreo. Utilizando las distancias conocidas entre los pares de cámaras estéreo, las posiciones de cada píxel en el espacio 3D son posteriormente estimadas midiendo las distancias relativas entre los píxeles que aparecen en ambas cámaras en un par estéreo. Este es el mismo proceso que nuestro cerebro utiliza para estimar la distancia de los objetos que observamos. Utilizando la información de la posición estimada, un plano es ajustado al suelo, y luego los píxeles son etiquetados como verdes si están cerca del suelo y rojos si están arriba de él.

<!-- * **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly. -->
* **Limitaciones y Motivación para la Red Convolucional**: La visión estéreo solo funciona hasta 10 metros y conducir un robot requiere una visión de largo alcance. Una Red Convolucional sin embargo, es capaz de detectar objetos a muchas más grandes distancias, si es entrenada correctamente.

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center> -->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figura 5:</b> Pirámide invariante a la escala de imágenes con distancia normalizada<sup>Scale-invariant Pyramid of Distance-normalized Images</sup>
</center>

<!-- * **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales. -->
* **Entregadas como Entradas del Modelo**: Un pre-procesamiento importante incluye construir una pirámide invariante a la escala de imágenes con distancia normalizada (Figura 5). Esto es similar a lo que realizamos anteriormente en esta clase cuando intentamos detectar rostros de múltiples escalas.

<!-- **Model Outputs** (Figure 4, Column 3) -->
**Salidas del Modelo** (Figura 4, Columna 3)

<!-- The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network. -->
El modelo entrega como salidas una etiqueta para cada píxel en la imagen **hasta el horizonte**. Estas son las salidas una red convolucional clasificadora multi-escala.

<!-- * **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed. -->
* **Como el Modelo se Vuelve Adaptativo**: Los robots tienen acceso continuo a las etiquetas estéreo, permitiéndole a la red reentrenarse, adaptándose al nuevo ambiente en el que se encuentra. Por favor note que solo la última capa de la red habrá sido re-entrenada. Las capas previas son entrenadas y fijadas en el laboratorio.

<!-- **System Performance** -->
**Rendimiento del Sistema**

<!-- When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away. -->
Cuando se está intentando obtener una coordenada GPS en el otro lado de una barrera, el robot "observo" la barrera desde muy lejos y planificó una ruta que la evita. Esto es gracias a la CNN detectando objetos hasta 50-100m lejos.

<!-- **Limitation** -->
**Limitación**

<!-- Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly. -->
Anteriormente en los 2000s, los recursos de computación eran restringidos. El robot era capaz de procesar cerca de 1 cuadro por segundo, lo que significaba que no podría ser capaz de detectar a una persona que camina en su trayectoria por un segundo completo antes de ser capaz de reaccionar. La solución para esta limitación es un modelo de **Odometría Visual de Bajo Costo**. No está basado en redes neuronales, tiene una visión de ~2.5m, pero reacciona rápidamente.

<!-- ### Scene Parsing and Labelling -->

### Análisis de la escena<sup>Scene Parsing</sup> y Etiquetado

<!-- In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6). -->
En esta tarea, el modelo entrega en la salida una categoría de objeto (edificios, carros, cielo, etc.) para cada píxel. La arquitectura es también multi-escala (figura 6).

<!-- <center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center> -->
<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figura 6:</b> CNN multi-escala para análisis de escena
</center>
<!-- Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**. -->
Nótese que si retro-proyectamos una salida de la CNN en la entrada, esta corresponderá a una ventana de entrada de tamaño $46\times46$ en la imagen original en la parte más baja de la Pirámide Laplaciana. Esto significa que estamos **utilizando el contexto de $46\times46$ píxeles para decidir la categoría del píxel central**. 

<!-- However, sometimes this context size is not enough to determine the category for larger objects. -->
Sin embargo, algunas veces este tamaño de contexto no es suficiente para determinar la categoría para objetos grandes.
<!-- **The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows: -->
**El enfoque multi-escala permite una visión más amplia suministrando imágenes adicionales re-escaladas como entradas.** Los pasos son los siguientes:
<!-- 1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.-->
<!-- 2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features. -->
<!-- 3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image. -->
<!-- 4. **Stack** the three sets of (upsampled) features together and feed them to a classifier. -->

1. Tomar la misma imagen, reducirla por un factor de 2 y un factor de 4, separadamente.
2. Estas dos imágenes re-escaladas adicionales alimentan **la misma Red Convolucional** (mismos pesos, mismos filtros) y obtenemos otros dos conjuntos de características de Nivel 2.
3. **Sobre-muestrear<sup>Upsample</sup>** estas características para que ellas tengan el mismo tamaño que las Características de Nivel 2 de la imagen original.
4. **Apilar** los tres conjuntos de características (sobre-muestreadas) todos juntos y alimentar al clasificador con ellas.


<!-- Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$. -->
Ahora el tamaño más largo efectivo de contenido, el cual es del 1/4 de la imagen modificada en tamaño, es $184\times 184\, (46\times 4=184)$.

<!-- **Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking. -->
**Rendimiento**: Sin procesamiento posterior y ejecutando cuadro-por-cuadro, el modelo se ejecuta muy rápidamente incluso en hardware estándar.  Tiene un tamaño pequeño de datos de entrenamiento (2k~3k), pero aun así los resultados son rompe récords.