---
lang-ref: ch.05-3
title: Entendiendo las convoluciones y el motor de diferenciación automática
lecturer: Alfredo Canziani
authors: Leyi Zhu, Siqi Wang, Tao Wang, Anqi Zhang
date: 25 Feb 2020
lang: es
translation-date: 31 Mar 2020
translator: olivetom
---

<!-- ---
lang-ref: ch.05-3
title: Understanding convolutions and automatic differentiation engine
lecturer: Aaron Defazio
lecturer: Alfredo Canziani
authors: Leyi Zhu, Siqi Wang, Tao Wang, Anqi Zhang
date: 28 Feb 2020
--- -->


<!-- ## [Understanding 1D convolution](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s) -->
## [Entendiendo la convolución 1D](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)


<!-- In this part we will discuss convolution, since we would like to explore the sparsity, stationarity, compositionality of the data. -->
En esta parte trataremos convoluciones, ya que queremos explorar la raleza, estacionalidad y composicionalidad de los datos.

<!-- Instead of using the matrix $A$ discussed in the [previou week](en/week04/04-1), we will change the matrix width to the kernel size $k$. Therefore, each row of the matrix is a kernel. We can use the kernels by stacking and shifting (see Fig 1). Then we can have $m$ layers of height $n-k+1$. -->
En vez de usar la matriz $A$ tratada en la [semana previa](es/week04/04-1), cambiaremos el ancho de la matriz por el tamaño del núcleo $k$. Así, cada fila de la matriz es un núcleo. Podemos usar los núcleos apilándolos y desplazándolos (ver Fig 1). Así, podemos tener $m$ capas de alto $n-k+1$.


<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>Fig 1</b>: Illustration of 1D Convolution
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>Fig 1</b>: Ilustración de Convolución 1D
</center>

<!-- The output is $m$ (thickness) vectors of size $n-k+1$. -->
La salida is $m$ (grosor) vectores de tamaño $n-k+1$.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>Fig 2</b>: Result of 1D Convolution
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>Fig 2</b>: Resultado de Convolución 1D
</center>

<!-- Furthermore, a single input vector can viewed as a monophonic signal. -->
Además, un único vector de entrada puede ser visto como una señal mono-canal.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>Fig 3</b>: Monophonic signal
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>Fig 3</b>: Señal mono-canal
</center>

<!-- Now, the input $x$ is a mapping -->
Ahora, la entrada $x$ es un mapeo


$$
x:\Omega\rightarrow\mathbb{R}^{c}
$$

<!-- where $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (since this is $1$ dimensional signal / it has a $1$ dimensional domain) and in this case the channel number $c$ is $1$. When $c = 2$ this becomes a stereophonic signal. -->
donde $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (ya que es una señal $1$ dimensional / tiene un dominio $1$ dimensional) y en este caso el número de canal $c$ es $1$. Cuando $c = 2$ se convierte en una señal estereofónica.

<!-- For the 1D convolution, we can just compute the scalar product, kernel by kernel (see Fig 4). -->
Para la convolución 1D, podemos simplemente computar el producto escalar, núcleo por núcleo (ver Fig 4).

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<b>Fig 4</b>: Layer-by-layer Scalar Product of 1D Convolution
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<b>Fig 4</b>: Producto escalar de una convolución 1D capa por capa
</center>

<!-- ## [Dimension of kernels and output width in PyTorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s) -->
## [Dimensiones de núcleos y ancho de salida en Pytorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

<!-- Tips: We can use ***question mark*** in IPython to get access to the documents of functions. For example, -->
Consejo: podemos usar ***signo de pregunta*** en IPython para acceder a la documentación de funciones. Por ejemplo,

<!-- ```python
Init signature:
nn.Conv1d(
	in_channels,           # number of channels in the input image
	out_channels,          # number of channels produced by the convolution
	kernel_size,           # size of the convolving kernel
	stride=1,              # stride of the convolution
	padding=0,             # zero-padding added to both sides of the input
	dilation=1,            # spacing between kernel elements
	groups=1,              # nb of blocked connections from input to output
	bias=True,             # if `True`, adds a learnable bias to the output
	padding_mode='zeros',  # accepted values `zeros` and `circular`
)
``` -->
```python
Init signature:
nn.Conv1d(
	in_channels,           # nro de canales en la imagen de entrada
	out_channels,          # nro de canales que genera la convolución
	kernel_size,           # tamaño del núcleo convolucionante
	stride=1,              # paso de la convolución
	padding=0,             # relleno de ceros a ambos lados de la entrada
	dilation=1,            # espaciado entre los elementos del núcleo
	groups=1,              # nro de conecciones bloqueadas entre E/S
	bias=True,             # Si `True`, agrega un sesgo aprendible a la salida
	padding_mode='zeros',  # aceptar valor `zeros` y `circular`
)
```


<!-- ### 1D convolution -->
### Convolución 1D convolution


<!-- We have $1$ dimensional convolution going from $2$ channels (stereophonic signal) to $16$ channels ($16$ kernels) with kernel size of $3$ and stride of $1$. We then have $16$ kernels with thickness $2$ and length $3$. Let's assume that the input signal has a batch of size $1$ (one signal),  $2$ channels and $64$ samples. The resulting output layer has one signal, $16$ channels and the length of the signal is $62$ ($=64-3+1$). Also, if we output the bias size, we'll find the bias size is $16$, since we have one bias per weight. -->
Tenemos una convolución $1$ dimensional que va desde una señal de $2$ canales (señal estereofónica) a $16$ canales ($16 núcleos) con tamaño de núcleo $3$ y paso de $1$. Entonces tendremos $16$ canales de grosor $2$ y largo $3$. Asumamos que la señal de entrada tiene un tamaño de lote de $1$ (una señal), $2$ canales y $64$ muestras. La capa de salida resultante tiene una señal, $16$ canales y el largo de la señal es de $62$ ($=64-3+1). También, si imprimimos el tamaño del sesgo, encontraremos que su tamaño es de $16$, ya que tenemos un sesgo para cada peso.

<!-- ```python
conv = nn.Conv1d(2, 16, 3)  # 2 channels (stereo signal), 16 kernels of size 3
conv.weight.size()          # output: torch.Size([16, 2, 3])
conv.bias.size()            # output: torch.Size([16])

x = torch.rand(1, 2, 64)    # batch of size 1, 2 channels, 64 samples
conv(x).size()              # output: torch.Size([1, 16, 62])

conv = nn.Conv1d(2, 16, 5)  # 2 channels, 16 kernels of size 5
conv(x).size()              # output: torch.Size([1, 16, 60])
``` -->
```python
conv = nn.Conv1d(2, 16, 3)  # 2 canales (señal estére), 16 núcleos de tamaño 3
conv.weight.size()          # salida: torch.Size([16, 2, 3])
conv.bias.size()            # salida: torch.Size([16])

x = torch.rand(1, 2, 64)    # lote de tamaño 1, 2 canales, 64 muestras
conv(x).size()              # sailda: torch.Size([1, 16, 62])

conv = nn.Conv1d(2, 16, 5)  # 2 canales, 16 núcleos de tamaño 5
conv(x).size()              # salida: torch.Size([1, 16, 60])
```

<!-- ### 2D convolution -->
### Convolución 2D

<!-- We first define the input data as one sample, $20$ channels (say, we're using an hyperspectral image) with height $64$ and width $128$. The 2D convolution has $20$ channels from input and $16$ kernels with size of $3 \times 5$. After the convolution, the output data has one sample, $16$ channels with height $62$ $(=64-3+1)$ and width $124$ $(=128-5+1)$. -->
Primero definimos los datos de entrada como una muestra, $20$ canales (imágen hiper-espectral) con alto $64$ y ancho $128$. La convolución 2D tiene $20$ canales desde la entrada y $16$ núcleos de tamaño $3$ \times $5. Luego de la convolución, los datos de salida tienen una muestra, $16$ canales con alto $62$ $(=64-3+1) y ancho $124$ $(=128-5+1$).

<!-- ```python
x = torch.rand(1, 20, 64, 128)    # 1 sample, 20 channels, height 64, and width 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 channels, 16 kernels, kernel size is 3 x 5
conv.weight.size()                # output: torch.Size([16, 20, 3, 5])
conv(x).size()                    # output: torch.Size([1, 16, 62, 124])
``` -->
```python
x = torch.rand(1, 20, 64, 128)    # 1 salida, 20 canales, alto 64, y ancho 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 canales, 16 núcleos, tamaño núcleo 3 x 5
conv.weight.size()                # salida: torch.Size([16, 20, 3, 5])
conv(x).size()                    # salida: torch.Size([1, 16, 62, 124])
```

<!-- If we want to achieve the same dimensionality, we can have paddings. Continuing the code above, we can add new parameters to the convolution function: `stride=1` and `padding=(1, 2)`, which means $1$ on $y$ direction ($1$ at the top and $1$ at the bottom) and $2$ on $x$ direction. Then the output signal is in the same size compared to the input signal. The number of dimensions that is required to store the collection of kernels when you perform 2D convolution is $4$. -->
Si queremos obtener la mismas dimensiones, podemos usar relleno. Continuando el código de arriba, podemos agregar nuevos parámetros a la función de convolución `stride=1` y `padding=(1, 2)`, que significa $1$ en la dirección de $y$ ($1$ arriba y $1$ abajo) y $2$ en la dirección de $x$. Así, la señal de salida es del mismo tamaño que la señal de entrada. El número de dimensiones que se requiere para almacenar la colección de núcleos cuando se realiza convolución 2D es de $4$.

<!-- ```python
# 20 channels, 16 kernels of size 3 x 5, stride is 1, padding of 1 and 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # output: torch.Size([1, 16, 64, 128])
``` -->
```python
# 20 canales, 16 núcleos de tamaño 3 x 5, paso es 1, relleno de 1 y 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # salida: torch.Size([1, 16, 64, 128])
```

<!-- ## [How automatic gradient works?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s) -->
## [Cómo funcionan los gradientes automáticos?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

<!-- In this section we're going to ask torch to check all the computation over the tensors so that we can perform the computation of partial derivatives. -->
En esta sección vamos a pedirle a torch que corrobore todos los cálculos realizados con los tensores de manera que podamos realizar el cálculo de las derivadas parciales.

<!-- - Create a $2\times2$ tensor $\boldsymbol{x}$ with gradient-accumulation capabilities;
- Deduct $2$ from all elements of $\boldsymbol{x}$ and get $\boldsymbol{y}$; (If we print `y.grad_fn`, we will get `<SubBackward0 object at 0x12904b290>`, which means that y is generated by the module of subtraction $\boldsymbol{x}-2$. Also we can use `y.grad_fn.next_functions[0][0].variable` to derive the original tensor.)
- Do more operations: $\boldsymbol{z} = 3\boldsymbol{y}^2$;
- Calculate the mean of $\boldsymbol{z}$. -->
- Crear un tensor $2\times2$ $\boldsymbol{x}$ con capacidad de acumular gradiente;
- Restar $2$ de todos los elementos $\boldsymbol{x}$ y obtener $\boldsymbol{y}$; (Si imprimimos `y.grad_fn`, tendremos `<SubBackward0 object at 0x12904b290>`, que significa que y es generado por el módule de resta $\boldsymbol{x}-2$. También podemos usar `y.grad_fn.next_functions[0][0].variable` para derivar el tensor original.)
- Hacemos más operaciones: $\boldsymbol{z} = 3\boldsymbol{y}^2$;
- Calcular la media de $\boldsymbol{z}$.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>Fig 5</b>: Flow Chart of the Auto-gradient Example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>Fig 5</b>: Flujo del auto-gradiente del ejemplo
</center>

<!-- Back propagation is used for computing the gradients. In this example, the process of back propagation can be viewed as computing the gradient $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. After computing $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ by hand as a validation, we can find that the execution of `a.backward()` gives us the same value of *x.grad* as our computation. -->
La retro propagación se usa para el cálculo de los gradientes. En este ejemplo, el proceso de retro propagación puede ser visto como el cálculo del gradiente $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. Luego de calcular $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ a mano como validación, encontramos que la ejecución de `a.backward()` nos da el mismo valor de *x.grad* que el cálculo automático. 


<!-- Here is the process of computing back propagation by hand: -->
Este es el proceso de hacer a mano la retro propagación:

$$
\begin{aligned}
a &= \frac{1}{4} (z_1 + z_2 + z_3 + z_4) \\
z_i &= 3y_i^2 = 3(x_i-2)^2 \\
\frac{da}{dx_i} &= \frac{1}{4}\times3\times2(x_i-2) = \frac{3}{2}x_i-3 \\
x &= \begin{pmatrix} 1&2\\3&4\end{pmatrix} \\
\left(\frac{da}{dx_i}\right)^\top &= \begin{pmatrix} 1.5-3&3-3\\[2mm]4.5-3&6-3\end{pmatrix}=\begin{pmatrix} -1.5&0\\[2mm]1.5&3\end{pmatrix}
\end{aligned}
$$

<!-- Whenever you use partial derivative in PyTorch, you get the same shape of the original data. But the correct Jacobian thing should be the transpose. -->
Siempre que se usen derivadas parciales en PyTorch, obtenemos las mismas dimensiones que los datos originales. Sin embargo, el Jacobiano debe trasponerse.


<!-- ### From basic to more crazy -->
### De lo básico a lo más alocado


<!-- Now we have a $1\times3$ vector $x$, assign $y$ to the double $x$ and keep doubling $y$ until its norm is smaller than $1000$. Due to the randomness we have for $x$, we cannot directly know the number of iterations when the procedure terminates. -->
Ahora tenemos un vector $x$ $1\times3$, asignamos $y$ al doble de $x$ y continuamos duplicando $y$ mientras que su norma sea menor que $1000$. Debido a la aleatoridad que tenemos para $x$, no podemos saber de antemano la cantidad de iteraciones hasta que termine el procedimiento.


```python
x = torch.randn(3, requires_grad=True)

y = x * 2
i = 0
while y.data.norm() < 1000:
    y = y * 2
    i += 1
```

<!-- However, we can infer it easily by knowing the gradients we have. -->
Sin embargo, podemos inferirlo conociendo los gradientes que tenemos.


```python
gradients = torch.FloatTensor([0.1, 1.0, 0.0001])
y.backward(gradients)

print(x.grad)
tensor([1.0240e+02, 1.0240e+03, 1.0240e-01])
print(i)
9
```

<!-- As for the inference, we can use `requires_grad=True` to label that we want to track the gradient accumulation as shown below. If we omit `requires_grad=True` in either $x$ or $w$'s declaration and call `backward()` on $z$, there will be runtime error due to we do not have gradient accumulation on $x$ or $w$. -->
Al igual que para la inferencia, podemos usar `requires_grad=True` para denotar que queremos restrear la acumulación de gradiente como se muestra abajo. Si omitimos  `requires_grad=True` ya sea en la declaración de $x$ o $w$ y llamamos a `backward()` con $z$, ocurrirá un error de ejecución debido a que no tenemos acumulación de gradiente para $x$ o $w$.

<!-- ```python
# Both x and w that allows gradient accumulation
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
``` -->
```python
# Permitir acumulación de gradiente tanto para x como w
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
```

<!-- And, we can have `with torch.no_grad()` to omit the gradient accumulation. -->
Y con `with torch.no_grad()` podemos omitir la acumulación de gradiente.

<!-- ```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# All torch tensors will not have gradient accumulation
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch will throw an error here, since z has no grad accum.
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
``` -->
```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# Todos los tensores no tendrán acumulación de gradiente
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch lanzará error aquí, ya que z acumula gradiente.
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
```


<!-- ## More stuff -- custom gradients -->
## Más cosas -- gradientes personalizados

<!-- Also, instead of basic numerical operations, we can generate our own self-defined modules / functions, which can be plugged into the neural graph. The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb). -->
Además de las operaciones numéricas básicas, podemos definir nuestros propios módulos / funciones, que pueden insertarse en el grafo neuronal. La Jupyter Notebook relacionada puede encontrase [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).

<!-- To do so, we need to inherit `torch.autograd.Function` and override `forward()` and `backward()` functions. For example, if we want to training nets, we need to get the forward pass and know the partial derivatives of the input respect to the output, such that we can use this module in any kind of point in the code. Then, by using back-propagation (chain rule), we can plug the thing anywhere in the chain of operations, as long as we know the partial derivatives of the input respect to the output. -->
Para hacerlo, debemos heredar `torch.autograd.Function` y sobre escribir las funciones `forward()` y `backward()`. Por ejemplo, si queremos entrenar redes, necesitamos hacer la pasada hacia adelante y conocer las derivadas parciales de las entradas respecto de las salidas, de manera que podamos usar este módulo en cualquier punto del código. Luego, mediante la utilización de retro propagación (regla de la cadena), podemos insertar el módulo en cualquier lugar de la cadena de operaciones, en tanto y en cuanto conozcamos las derivadas parciales de la entrada con respecto a las salidas.

<!-- In this case, there are three examples of ***custom modules*** in the *notebook*, the `add`, `split` and `max` modules. For example, the custom addition module: -->
En este caso, hay tres ejemplos de ***módulos personalizados*** en el *notebook*, los módulos `add`, `split` y `max`. Por ejemplo, el módulo personalizado de suma:

<!-- ```python
# Custom addition module
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx is a context where we can save
        # computations for backward.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # need to return grads in order
        # of inputs to forward (excluding ctx)
        return grad_x1, grad_x2
``` -->
```python
# módulo sumador personalizado
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx es un contexto donde podemos guardar
        # cálculos para atrás.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # se necesita retornar gradientes en el orden
        # de la entradas del método forward (excluir ctx)
        return grad_x1, grad_x2
```
<!-- If we have addition of two things and get an output, we need to overwrite the forward function like this. And when we go down to do back propagation, the gradients copied over both sides. So we overwrite the backward function by copying. -->
Si tenemos la suma de dos cosas y obtenemos una salida, necesitamos sobre escribir la función forward como se muestra. Y para realizar la retro propagación, necesitamos sobre escribir la funcion backward de manera de retornar los gradientes.


<!-- For `split` and `max`, see the code of how we overwrite forward and backward functions in the *notebook*. If we come from the same thing and **Split**, when go down doing gradients, we should add / sum them. For `argmax`, it selects the index of the highest thing, so the index of the highest should be $1$ while others being $0$. Remember, according to different custom modules, we need to overwrite its own forward pass and how they do gradients in backward function. -->
Para los casos de `split` and `max`, ver el código de como se sobre escriben las funciones en el *notebook*. Para el caso de **Split**, cuando hacemos los gradientes deberiamos sumarlos. Para `argmax`, que selecciona el indice del mayor elemento, entonces el índice del mayor debería ser $1$ mientras que el resto $0$. Recordar que de acuerdo para diferentes módulos personalizados, debemos sobre escribir la pasada hacia adelante y la pasada hacia atrás siempre.
