---
lang-ref: ch.05-2
title: Técnicas de Optimización II
lecturer: Aaron Defazio
authors: Guido Petri, Haoyue Ping, Chinmay Singhal, Divya Juneja
date: 24 Feb 2020
lang: es
translation-date: 27 Mar 2020
translator: olivetom
---

<!--
## [Adaptive methods](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)
-->
## [Métodos Adaptativos](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)

<!-- SGD with momentum is currently the state of the art optimization method for a lot of ML problems. But there are other methods, generally called Adaptive Methods, innovated over the years that are particularly useful for poorly conditioned problems (if SGD does not work). -->

Actualmente SGD con momentum es el estado del arte en métodos de optimización para muchos problemas de ML. Pero hay otros métodos, llamados genéricamente Métodos Adaptativos, innovados recientemente que son particularmente útiles para problemas con condiciones pobres (si SGD no sirve).

<!-- In the SGD formulation, every single weight in network is updated using an equation with the same learning rate (global $\gamma$). Here, for adaptive methods, we *adapt a learning rate for each weight individually*. For this purpose, the information we get from gradients for each weight is used. -->

En la formulación de SGD, cada peso en la red es actualizado utilizando una ecuación con la misma taza de aprendizaje (global $\gamma$). En cambio, para los métodos adaptativos, *adaptamos una taza de aprendizaje para cada peso individualmente*. Para este propósito, es usada la informacion obtenida de los gradientes de cada peso.

<!-- Networks that are often used in practice have different structure in different parts of it. For instance, early parts of CNN may be very shallow convolution layers on large images and later in the network we might have convolutions of large number of channels on small images. Both of these operations are very different so a learning rate which works well for the beginning of the network may not work well for the latter sections of the network. This means adaptive learning rates by layer could be useful. -->

Las redes mas utilizadas en la práctica tienen diferente estructura en diferentes partes. Por ejemplo, las primeras partes de una red CNN pueden ser capas convolucionales muy superficiales sobre imágenes grandes y luego en la red podemos tener convoluciones con una gran cantidad de canales sobre imágenes pequeñas. Ambas operaciones son muy diferentes, entonces una taza de aprendizaje que anda bien para el principio de la red puede no andar bien para las últimas secciones de la red. Esto significa que tasas de aprendizaje adaptativas por capa pueden llegar a ser útiles.
<!-- Weights in the latter part of the network (4096 in figure 1 below) directly dictate the output and have a very strong effect on it. Hence, we need smaller learning rates for those. In contrast, earlier weights will have smaller individual effects on the output, especially when initialized randomly. -->

Los pesos en la parte final de la red (4096 en figura 1 abajo) directamente impone la salida y tiene un fuerte peso sobre ella. Por eso, necesitamos tasas de aprendizaje menores para estos casos. En contraste, los primeros pesos tendrán efectos individuales menores en la salida, especialmente cuando son inicializados aleatoriamente.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>Figure 1: </b>VGG16
</center>


### RMSprop
<!-- The key idea of *Root Mean Square Propagation* is that the gradient is normalized by its root-mean-square. -->

La idea central de *Root Mean Square Propagation* es normalizar el gradiente con su raíz cuadrada del valor medio de los cuadrados.
<!-- In the equation below, squaring the gradient denotes that each element of the vector is squared individually. -->

En la ecuación de abajo, elevando al cuadrado el gradiente denota que cada elemento del vector es elevado al cuadrado individualmente.

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$
<!-- where $\gamma$ is the global learning rate, $\epsilon$ is a value close to machine $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) (in order to avoid division by zero errors), and $v_{t+1}$ is the 2nd moment estimate. -->

donde $\gamma$ es la taza global de aprendizaje, $\epsilon$ es un valor infinitesimal $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) (para evitar errores de división por cero), y $v_{t+1}$ es la estimada del 2do. momento.
<!-- We update $v$ to estimate this noisy quantity via an *exponential moving average* (which is a standard way of maintaining an average of a quantity that may change over time). We need to put larger weights on the newer values as they provide more information. One way to do that is down-weight old values exponentially. The values in the $v$ calculation that are very old are down-weighted at each step by an $\alpha$ constant, which varies between 0 and 1. This dampens the old values until they are no longer an important part of the exponential moving average. -->

Actualizamos $v$ para estimar esta cantidad ruidosa via un *exponential moving average* (que es la forma estándar de mantener el promedio de una cantidad que puede cambiar en el tiempo). Necesitamos poner mayores pesos en los valores recientes ya que proporcionan mayor información. Una manera de hacerlo es bajando de peso valores viejos exponencialmente. Los valores en el cálculo de $v$ son bajados de peso en cada paso por una constante $\alpha$, que varía entre 0 and 1. Esto disminuye los valores viejos hasta que dejan de ser una parte importante del promedio móvil exponencial.
<!-- The original method keeps an exponential moving average of a non-central second moment, so we don't subtract the mean here. The *second moment* is used to normalize the gradient element-wise, which means that every element of the gradient is divided by the square root of the second moment estimate. If the expected value of gradient is small, this process is similar to dividing the gradient by the standard deviation. -->

El método original mantiene promedio móvil exponencial de un momento de segundo orden no-central. El *momento de segundo orden* es usado para normalizar todos los elementos del gradiente, lo que significa que cada elemento del gradiente es dividido por la raíz cuadrada de la estimada del momento de segundo orden. Si el valor esperado del grandiente es pequeño, este proceso es similar a dividir el gradiente por la desviación estándar.

<!-- Using a small $\epsilon$ in the denominator doesn't diverge because when $v$ is very small, the momentum is also very small. -->

Utilizando un $\epsilon$ pequeño en el denominador no diverge porque cuando $v$ es muy pequeño, el momento es muy pequeño también.

### ADAM

<!-- ADAM, or *Adaptive Moment Estimation*, which is RMSprop plus momentum, is a more commonly used method. The momentum update is converted to an exponential moving average and we don't need to change the learning rate when we deal with $\beta$. Just as in RMSprop, we take an exponential moving average of the squared gradient here. -->
ADAM, or *Estimación Adaptativa del Momento*, que es RMSprop más momento, es un método comunmente más usado. La actualización del momento se convierte en un promedio móvil exponencial sin querer cambiar la taza de aprendizaje cuando tratamos con $\beta$ \. Justo como en RMSprop, aquí tomamos el promedio móvil exponencial del gradiente cuadrado.

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!-- where $m_{t+1}$ is the momentum's exponential moving average. -->
donde $m_{t+1}$ es el promedio móvil exponencial del momento.

<!-- Bias correction that is used to keep the moving average unbiased during early iterations is not shown here. -->
Aquí no se muestra la correción de sesgo que es usada durante las primeras iteraciones para mantener sin sesgo el promedio móvil.


<!-- ### Practical side -->
### Lado práctico

<!-- When training neural networks, SGD often goes in the wrong direction in the beginning of the training process, whereas RMSprop hones in on the right direction. However, RMSprop suffers from noise just as regular SGD, so it bounces around the optimum significantly once it's close to a local minimizer. Just like when we add momentum to SGD, we get the same kind of improvement with ADAM. It is a good, not-noisy estimate of the solution, so **ADAM is generally recommended over RMSprop**. -->
Cuando se entrenan redes neuronales, a menudo al principio del proceso de entrenamiento SGD va en la dirección equivocada, mientras que RMSprop enfila hacia la dirección correcta. Sin embargo, RMSprop, al igual que SGD, es sensible al ruido, por lo que generalmente rebota significativamente alrededor del punto óptimo cuando está cerca de un mínimo local.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figure 2: </b> SGD vs RMSprop vs ADAM
</center><br> -->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figura 2: </b> SGD vs RMSprop vs ADAM
</center><br>

<!-- ADAM is necessary for training some of the networks for using language models. For optimizing neural networks, SGD with momentum or ADAM is generally preferred. However, ADAM's theory in papers is poorly understood and it also has several disadvantages: -->

ADAM es necesario para el entrenamiento de algunas de las redes que usan modelos del lenguage. Para la optimización de redes neuronales, se prefiere generalmente SGD con momento o ADAM. Sin embargo, la teoría de ADAM en los papers no es bien entendida y tiene varias desventajas:

<!-- * It can be shown on very simple test problems that the method does not converge. -->
* Se puede demostrar haciendo pruebas muy simples que el método no converge.
<!-- * It is known to give generalization errors. If the neural network is trained to give zero loss on the data you trained it on, it will not give zero loss on other data points that it has never seen before. It is quite common, particularly on image problems, that we get worse generalization errors than when SGD is used. Factors could include that it finds the closest local minimum, or less noise in ADAM, or its structure, for instance. -->
* Se sabe que produce errores de generalización. Si la red neuronal es entrenada de manera que la pérdida es cero en el conjunto de datos de entrenamiento, entonces la pérdida en puntos de datos desconocidos no será cero. Es bastante común, particulamente en problemas con imágenes, que se obtengan peores errores de generalización que cuando se usa SGD.
<!-- * With ADAM we need to maintain 3 buffers, whereas SGD needs 2 buffers. This doesn't really matter unless we train a model on the order of several gigabytes in size, in which case it might not fit in memory. -->
* Con ADAM se necesitan 3 memorias intermedias, mientras que con SGD se necesitan sólo 2. Esto importa solamente si entrenamos modelos cuyo tamaño son del orden de varios gigabytes ya que podrían no entrar en la memoria.
<!-- * 2 momentum parameters need to be tuned instead of 1. -->
* Se deben sintonizar dos parámetros de momento en lugar de 1.


<!-- ## [Normalization layers](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s) -->
## [Capas de normalización](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)


<!-- Rather than improving the optimization algorithms, *normalization layers* improve the network structure itself. They are additional layers in between existing layers. The goal is to improve the optimization and generalization performance. -->

Las *capas de normalización* más que mejorar los algoritmos de optimización, mejoran la estructura de la red en sí misma. Se conforman por capaz adicionales entre las capas existentes. El objetivo es mejorar las prestaciones de la optimización y la generalización.

<!-- In neural networks, we typically alternate linear operations with non-linear operations. The non-linear operations are also known as activation functions, such as ReLU. We can place normalization layers before the linear layers, or after the activation functions. The most common practice is to put them between the linear layers and activation functions, as in the figure below. -->

Típicamente, en las redes neuronales se utilizan alternadamente operaciones lineales y no lineales. Las operaciones no lineales, también conocidas como funciones de activación, tales como ReLU. Podemos colocar las capaz de normalización antes de las capaz lineales, o después de las funciones de activación. La práctica más común es colocarlas entre las capas lineales y las funciones de activación, como se muestra en la figura siguiente.

<!-- | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> | -->
<!-- | (a) Before adding normalization                              |                (b) After adding normalization                |                    (c) An example in CNNs                    | -->

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Antes de agregar normalización                              |                (b) Después de agregar normalización                |                    (c) Un ejemplo en CNNs                    |


<!-- <center><b>Figure 3:</b> Typical positions of normalization layers.</center> -->
<center><b>Figura 3:</b> Posiciones típicas de capas de normalización.</center>


<!-- In figure 3(c), the convolution is the linear layer, followed by batch normalization, followed by ReLU. -->
En la figura 3(c), la convolución es la capa lineal, seguida por una normalización de lote, seguida por ReLU.

<!-- Note that the normalization layers affect the data that flows through, but they don't change the power of the network in the sense that, with proper configuration of the weights, the unnormalized network can still give the same output as a normalized network. -->

Notar que las capas de normalización afectan los datos que fluyen a través, pero no cambian la potencia de la red en el sentido que, con la apropiada configuración de los pesos, una red no normalizada puede producir las mismas salidas que una red normalizada.

<!-- ### Normalization operations -->

### Operaciones de normalización
<!-- This is the generic notation for normalization: -->

La notación genéria para la normalización es la siguiente:

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

<!-- where $x$ is the input vector, y is the output vector, $\mu$ is the estimate of the mean of $x$, $\sigma$ is the estimate of the standard deviation (std) of $x$, $a$ is the learnable scaling factor, and $b$ is the learnable bias term. -->
donde $x$ es el vector de entrada, y es el vector de salida, $\mu$ es la estimación de la media de $x$, $\sigma$ es la estimación de la desviación estándar de $x$, $a$ es el factor escala aprendible, y $b$ es el término sesgo aprendible.

<!-- Without the learnable parameters $a$ and $b$, the distribution of output vector $y$ will have fixed mean 0 and std 1. The scaling factor $a$ and bias term $b$ maintain the representation power of the network, i.e., the output values can still be over any particular range. Note that $a$ and $b$ do not reverse the normalization, because they are learnable parameters and are much more stable than $\mu$ and $\sigma$. -->
Sin los parámetros aprendibles $a$ y $b$, la distribución del vector salida $y$ tendrá media 0 y desvío 1 fijos. El factor escala $a$ y el término sesgo $b$ mantienen el poder de representación de la red, p.e., los valores de salida pueden aún estar por encima de cualquier rango. Notar que $a$ y $b$ no deshace la normalización, porque son parametros aprendibles y mucho mas establs que $\mu$ y $\sigma$.
<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Normalization operations.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Operaciones de normalización.
</center>

<!-- There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels: -->
Existen varias maneras de normalizar el vector de entrada, basándose en como se seleccionan las muestras para la normalización. La Figura 4 lista 4 formas diferentes de normalización, para un mini-lote de $N$ imágenes de alto $H$ y ancho $W$ con $C$ canales:

<!-- - *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information. -->
- *Normalización de Lote (Batch norm)*: la normalización se aplica solo a un canal de la entrada. Este es el primer método propuesto y el más conocido. Por favor leer [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) para más información.
<!-- - *Layer norm*: the normalization is applied within one image across all channels. -->
- *Normalización de Capa (Layer norm)*: la normalización se aplica dentro de una imágen a través de todos los canales.
<!-- - *Instance norm*: the normalization is applied only over one image and one channel. -->
- *Normalización de Instancia (Instance norm)*: la normalización se aplica sobre una imagen y un canal.
<!-- - *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD. -->
- *Normalización de Grupo (Group Norm)*: la normalización es aplicada sobre una imágen pero a través de un número de canales. Por ejemplo, un grupo para los canales 0 a 9, luego el canal 10 al 19 es otro grupo, y así sucesivamente. En la práctica, el tamaño del grupo es casi siempre 32. Esta es la forma recomendada por Aaron Defazio, ya que en en la práctica tiene buena prestación y no hay conflicto con SGD.
<!-- In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems. -->
En la práctica, normalización de lotes y normalización de grupos son apropiadas para problemas de visión por computadora, mientras que para los problemas de lenguaje se usan normalización de capa y de instancia.


<!-- ### Why does normalization help? -->
### ¿Por qué sirve la normalización?

<!-- Although normalization works well in practice, the reasons behind its effectiveness are still disputed. Originally, normalization is proposed to reduce "internal covariate shift", but some scholars proved it wrong in experiments. Nevertheless, normalization clearly has a combination of the following factors: -->
Aunque la normalización en la práctica funciona bien, las razones detrás de su efectividad aún están en disputa. Originalmente, la normalización se propuso para reducir el "cambio en la covarianza interna", pero algunos textos lo desaprobaron con experimentos. Sin embargo, la normalización tiene claramente la combinación de los siguientes factores:

<!-- - Networks with normalization layers are easier to optimize, allowing for the use of larger learning rates. Normalization has an optimization effect that speeds up the training of neural networks. -->
- Las redes con normalización son más fáciles de optimizar, permitiendo el uso de tasas de aprendizaje más grandes. La normalización tiene un efecto de optimización que acelera el entrenamiento de redes neuronales.
<!-- - The mean/std estimates are noisy due to the randomness of the samples in batch. This extra "noise" results in better generalization in some cases. Normalization has a regularization effect. -->
- Las estimaciones de la media/desvío son ruidosas debido a la naturaleza aleatoria de las muestras del lote. Este ruido extra resulta a veces en mejor generalización.
<!-- - Normalization reduces sensitivity to weight initialization. -->
- La normalización reduce la sensibilidad a los pesos iniciales.

<!-- As a result, normalization lets you be more "careless" - you can combine almost any neural network building blocks together and have a good chance of training it without having to consider how poorly conditioned it might be. -->
Como resultado, la normalización permite ser un poco "descuidado" - ya que se pueden combinar bloques de redes neuronales teniendo una buena chance de entrenarla sin considerar cuan precariamente preparada puede estar la red.


<!-- ### Practical considerations -->
### Consideraciones prácticas

<!-- It’s important that back-propagation is done through the calculation of the mean and std, as well as the application of the normalization: the network training will diverge otherwise. The back-propagation calculation is fairly difficult and error-prone, but PyTorch is able to automatically calculate it for us, which is very helpful. Two normalization layer classes in PyTorch are listed below: -->
Es importante que la retro-propagación se hace mediante el cálculo de la media y el desvío, así como la aplicación de la normalización: de lo contrario el entrenamiento será divergente. El cálculo de la retro-propagación es bastane difícil y propenso a errores, pero Pytorch puede hacerlo automáticamente. Abajo, se listan dos clases de capa de normalización:

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

<!-- Batch norm was the first method developed and is the most widely known. However, **Aaron Defazio recommends using group norm** instead. It’s more stable, theoretically simpler, and usually works better. Group size 32 is a good default. -->
La normalización por lote fue el primer método desarrollado y el más ampliamente conocido. Sin embargo, **Aaron Defazio recomienda usar normalización de grupos** en su lugar. Es mas estable, teóricamente simple, y usualmente trabaja mejor. Un tamaño de grupo de 32 es un buen valor por defecto.

<!-- Note that for batch norm and instance norm, the mean/std used are fixed after training, rather than re-computed every time the network is evaluated, because multiple training samples are needed to perform normalization. This is not necessary for group norm and layer norm, since their normalization is over only one training sample. -->
Notar que para la normalización por lotes y por instancia, la media/desvío quedan fijos luego del entrenamiento, en vez de ser re-calculadas cada vez que la red es evaluada, porque se necesitan múltiples muestras para la normalización. Esto no es necesario para la normalización por grupo o por capa, ya que la normalización es sobre una única muestra.

<!-- ## [The Death of Optimization](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s) -->
## [La Muerte de la Optimización](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)


<!-- Sometimes we can barge into a field we know nothing about and improve how they are currently implementing things. One such example is the use of deep neural networks in the field of Magnetic Resonance Imaging (MRI) to accelerate MRI image reconstruction. -->
A veces, podemos incurrir en un nuevo campo donde no conocemos nada y mejorar como se hacen las cosas. Tal es el ejemplo del uso de redes neuronales para la reconstrucción de imágenes de resonancias magnéticas para acelerar su reconstrucción.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5: </b>Sometimes it actually works!
</center> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figura 5: </b>A veces funciona!
</center>


<!-- ### MRI Reconstruction -->
### Reconstrucción de IRM


<!-- In the traditional MRI reconstruction problem, raw data is taken from an MRI machine and an image is reconstructed from it using a simple pipeline/algorithm. MRI machines capture data in a 2-dimensional Fourier domain, one row or one column at a time (every few milliseconds). This raw input is composed of a frequency and a phase channel and the value represents the magnitude of a sine wave with that particular frequency and phase. Simply speaking, it can be thought of as a complex valued image, having a real and an imaginary channel. If we apply an inverse Fourier transform on this input, i.e add together all these sine waves weighted by their values, we can get the original anatomical image. -->
En el tradicional problema de la reconstrucción de imágenes de resonancias magnéticas, se toman los datos del resonador y a partir de allí se reconstruye una imágen usando un algoritmo simple. Los resonadores capturan datos en el dominio bi-dimensional de Fourier, una fila o columna cada pocos milisegundos. Estos datos crudos se componen de una frecuencia y un canal de phase. En otras palabras, puede pensarse como una imágen en el dominio complejo que tiene una parte real y un canal imaginario. Si aplicamos la transformada inversa de Fourier sobre la entrada, p.e. sumar todas las ondas seno multiplicadas por su valor, vamos a obtener como resultado la imágen anatómica.

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Figure 6: </b>MRI reconstruction
</center><br>
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Figura 6: </b>Reconstrucción de IRM
</center><br>

<!-- A linear mapping currently exists to go from the Fourier domain to the image domain and it's very efficient, literally taking milliseconds, no matter how big the image is. But the question is, can we do it even faster? -->



<!-- ### Accelerated MRI -->
### IRM Acelerada


<!-- The new problem that needs to be solved is accelerated MRI, where by acceleration we mean making the MRI reconstruction process much faster. We want to run the machines quicker and still be able to produce identical quality images. One way we can do this and the most successful way so far has been to not capture all the columns from the MRI scan. We can skip some columns randomly, though it's useful in practice to capture the middle columns, as they contain a lot of information across the image, but outside them we just capture randomly. The problem is that we can't use our linear mapping anymore to reconstruct the image. The rightmost image in Figure 7 shows the output of a linear mapping applied to the subsampled Fourier space. It's clear that this method doesn't give us very useful outputs, and that there's room to do something a little bit more intelligent. -->
El nuevo problema a ser resuelto es RMI acelerada, donde por acelerada entendemos realizar el proceso de reconstrucción más rápido. Queremos hacer funcionar la máquinas más rapidamente y producir imágenes de idéntica calidad. Una manera de hacerlo, y hasta ahora la única conocida, ha sido no capturar todas las columnas del escaneo RMI. Podemos saltearnos algunas columnas aleatoriamente, aunque en la práctica es útil capturar las columnas del medio ya que contienen mucha información de la imágen, pero fuera del medio capturamos aleatoriamente. El problema, es que no podemos usar más el mapeo lineal para la reconstrucción de la imágen. La figura más a la derecha de la Figura 7 muestra la salida de un mapeo lineal aplicado al espacio de Fourier sub-muestreado. Queda claro, que este método no otorga resultados útiles, y que hay mucho lugar para hacer algo más inteligente.
<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Figure 7: </b>Linear mapping on subsampled Fourier-space
</center><br> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Figura 7: </b>Mapeo lineal en espacio de Fourier sub-muestreado.
</center><br>


<!-- ### Compressed sensing -->
### Muestreo comprimido


<!-- One of the biggest breakthroughs in theoretical mathematics for a long time was compressed sensing. A paper by <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> showed that theoretically, we can get a perfect reconstruction from the subsampled Fourier-domain image. In other words, when the signal we are trying to reconstruct is sparse or sparsely structured, then it is possible to perfectly reconstruct it from fewer measurements. But there are some practical requirements for this to work - we don't need to sample randomly, rather we need to sample incoherently - though in practice, people just end up sampling randomly. Additionally, it takes the same time to sample a full column or half a column, so in practice we also sample entire columns. -->
Uno de los mayores avances en la teoría matemática durante mucho tiempo fueron los muestreos comprimidos. Un trabajo de investigación de <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> mostró que teóricamente, podemos obtener una reconstrucción perfecta a partir de una imagen sub-muestreada del dominio de Fourier. En otras palabras, cuando la señal que estamos intentando reconstruir es rala o estructurada en forma rala, entonces es perfectamente posible reconstruirla con menos muestras. Pero para que esto funcione, hay requerimientos prácticos que cumplir: no necesitamos muestrea aleatoriamente, sino necesitamos muestrear incoherentemente, aunque en la práctica se termina sobre-muestreando aleatoriamente. Adicionalmente, lleva lo mismo muestrea media columna que columna entera, asi que en la práctica muestreamos columnas enteras.

<!-- Another condition is that we need to have *sparsity* in our image, where by sparsity we mean a lot of zeros or black pixels in the image. The raw input can be represented sparsely if we do a wavelength decomposition, but even this decomposition gives us an approximately sparse and not an exactly sparse image. So, this approach gives us a pretty good but not perfect reconstruction, as we can see in Figure 8. However, if the input were very sparse in the wavelength domain, then we would definitely get a perfect image. -->
Otra condición, es que necesitamos tener *escasez* en la imágen, donde por escasez entendemos muchos pixeles en cero o negros. La entrada cruda puede ser representada de manera escasa si aplicamos la descomposición del ancho de onda, pero aún esta descomposición nos brinda una imágen aproximadamente escasa. Por ello, este tratamiento nos brinda una reconstrucción aproximada pero no perfecta como podemos ver en la Figura 8. Sin embargo, si la imagen en el dominio del ancho de onda fuera escasa, entonces obtendríamos una imágen perfecta.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8: </b>Compressed sensing
</center><br> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figura 8: </b>Muestreo comprimido
</center><br>

<!-- Compressed sensing is based on the theory of optimization. The way we can get this reconstruction is by solving a mini-optimization problem which has an additional regularization term: -->
El muestreo comprimido está basado en la teoría de la optimización. La manera en la que podemos obtener la reconstrucción es mediante la resolución de un mini-problema de optimización el cuál tiene un termino de regularización adicional:

$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

<!-- where $M$ is the mask function that zeros out non-sampled entries, $\mathcal{F}$ is the Fourier transform, $y$ is the observed Fourier-domain data, $\lambda$ is the regularization penalty strength, and $V$ is the regularization function. -->
donde $M$ es la función máscara que pone a cero elementos no muestreados, $\mathcal{F}$ es la transformada de Fourier, $y$ son los datos observados en el dominio de Fourier, $\lambda$ es la fuerza de la penalización de la regularización, y $V$ es la función de regularización.

<!-- The optimization problem must be solved for each time step or each "slice" in an MRI scan, which often takes much longer than the scan itself. This gives us another reason to find something better. -->
El problema de optimización debe ser resuelto para cada paso o cada "rebanada" de un escaneo IRM, que a menudo tarda más que el escaneo en sí mismo. Esto nos dá otra razón para encontrar una mejor solución.


<!-- ### Who needs optimization? -->
### Quién necesita optimización?

<!-- Instead of solving the little optimization problem at every time step, why not use a big neural network to produce the required solution directly? Our hope is that we can train a neural network with sufficient complexity that it essentially solves the optimization problem in one step and produces an output that is as good as the solution obtained from solving the optimization problem at each time step. -->
En vez de resolver un pequeño problema de optimización con cada paso del tiempo, por qué no usar una red neuronal grande para producir la solución requerida directamente? Nuestra esperanza es que podemos entrenar una red neuronal lo suficientemente compleja que resuelva el problema de optimización en un solo paso y que produce una salida que es tan buena como la solución obtenida mediante resolver el problema de optimización a cada paso.

$$
\hat{x} = B(y)
$$

<!-- where $B$ is our deep learning model and $y$ is the observed Fourier-domain data. -->
donde $B$ es nuestro modelo de aprendizaje profundo y  $y$ son los datos observados en el dominio de Fourier.


<!-- 15 years ago, this approach was difficult - but nowadays this is a lot easier to implement. Figure 9 shows the result of a deep learning approach to this problem and we can see that the output is much better than the compressed sensing approach and looks very similar to the actual scan. -->
Hace 15 años, esto era dificultoso, pero hoy en día es mucho mas fácil de implementar. La figura 9 muestra el resultado de la aplicación de aprendizaje profundo a este problema, y podemos ver que esta salida es mucho mejor que la salida utilizando muestreo comprimido y parece muy similar al escaneo real.

<!-- <center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Deep Learning approach
</center><br> -->
<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Enfoque Aprendizaje Profundo
</center><br>

<!-- The model used to generate this reconstruction uses an ADAM optimizer, group-norm normalization layers, and a U-Net based convolutional neural network. Such an approach is very close to practical applications and we will hopefully be seeing these accelerated MRI scans happening in clinical practice in a few years' time. -->
El modelo utilizado para generar esta reconstrucción utiliza el optimizador ADAM, capas de normalización de grupo, y una red convolucional basada en U-Net. Tal enfoque es muy similar a las aplicaciones prácticas y en pocos años estaremos viendo estos escaneos IRM en la práctica clínica con seguridad.
-->
