---
lang: es
lang-ref: ch.05-1
title: Técnicas de Optimización I
lecturer: Aaron Defazio
authors: Vaibhav Gupta, Himani Shah, Gowri Addepalli, Lakshmi Addepalli
date: 24 Feb 2020
translation-date: 25 Mar 2020
translator: LecJackS
---

<!-- [Gradient descent]
-->
## [Descenso de gradiente](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

<!-- We start our study of Optimization Methods with the most basic and the worst (reasoning to follow) method of the lot, Gradient Descent.
-->
Comenzamos nuestro estudio de los Métodos de Optimización con el método más básico y el peor de todos (como veremos): Descenso de Gradiente.

<!-- **Problem:**
-->
**Problema:**

$$
\min_w f(w)
$$

<!-- **Iterative Solution:**
-->
**Solución Iterativa:**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

<!-- where,
 - $w_{k+1}$ is the updated value after the $k$-th iteration,
 - $w_k$ is the initial value before the $k$-th iteration,
 - $\gamma_k$ is the step size,
 - $\nabla f(w_k)$ is the gradient of $f$.
-->
donde,
 - $w_{k+1}$ es el valor actualizado luego de $k$ iteraciones,
 - $w_k$ es el valor inicial antes de la iteración $k$-ésima,
 - $\gamma_k$ es el tamaño de paso,
 - $\nabla f(w_k)$ es el gradiente de $f$.

<!-- The assumption here is that the function $f$ is continuous and differentiable. Our aim is to find the lowest point (valley) of the optimization function. However, the actual direction to this valley is not known. We can only look locally, and therefore the direction of the negative gradient is the best information that we have. Taking a small step in that direction can only take us closer to the minimum. Once we have taken the small step, we again compute the new gradient and again move a small amount in that direction, till we reach the valley. Therefore, essentially all that the gradient descent is doing is following the direction of steepest descent (negative gradient).
-->
La suposición aquí es que la función $f$ es continua y diferenciable. Nuestro objetivo es encontrar el punto más bajo (valle) de la función de optimización. Sin embargo, la dirección real a este valle no se conoce. Solo podemos observar localmente y, por lo tanto, la dirección del gradiente negativo es la mejor información que tenemos. Dar un pequeño paso en esa dirección solo puede acercarnos al mínimo. Una vez que hemos dado el pequeño paso, calculamos el nuevo gradiente y volvemos a movernos una pequeña cantidad en esa dirección, hasta llegar al valle. Por lo tanto, esencialmente todo lo que hace el descenso de gradiente es seguir la dirección del descenso más pronunciado (gradiente negativo).

<!-- The $\gamma$ parameter in the iterative update equation is called the **step size**. Generally we don't know the value of the optimal step-size; so we have to try different values. Standard practice is to try a bunch of values on a log-scale and then use the best one. There are a few different scenarios that can occur. The image above depicts these scenarios for a 1D quadratic. If the learning rate is too low, then we would make steady progress towards the minimum. However, this might take more time than what is ideal. It is generally very difficult (or impossible) to get a step-size that would directly take us to the minimum. What we would ideally want is to have a step-size a little larger than the optimal. In practice, this gives the quickest convergence. However, if we use too large a learning rate, then the iterates get further and further away from the minima and we get divergence. In practice, we would want to use a learning rate that is just a little less than diverging.
-->
El parámetro $\gamma$ en la ecuación de actualización iterativa se llama **tamaño de paso**. Generalmente no conocemos el valor del tamaño de paso óptimo; entonces tenemos que probar diferentes valores. La práctica estándar es probar un montón de valores en una escala logarítmica y luego usar el mejor. Hay distintos escenarios que pueden ocurrir. La imagen de arriba muestra estos escenarios para una cuadrática en 1D. Si el valor de la tasa de aprendizaje es demasiado bajo, haríamos un progreso constante hacia el mínimo. Sin embargo, esto puede llevar más tiempo del ideal. En general, es muy difícil (o imposible) obtener un tamaño de paso que nos lleve directamente al mínimo. Lo que idealmente querríamos es tener un tamaño de paso un poco más grande que el óptimo. En la práctica, esto proporciona la convergencia más rápida. Sin embargo, si usamos una tasa de aprendizaje demasiado grande, las iteraciones nos alejarán cada vez más del mínimo y resultará en divergencia. En la práctica, nos gustaría utilizar una tasa de aprendizaje que sea ligeramente menor a la divergente.

<!-- <b>Figure 1:</b> Step sizes for 1D Quadratic
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figura 1:</b> Tamaño de paso para cuadrática en 1D
</center>


<!-- [Stochastic gradient descent]
-->
## [Descenso de Gradiente Estocástico](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)

<!-- In Stochastic Gradient Descent, we replace the actual gradient vector with a stochastic estimation of the gradient vector. Specifically for a neural network, the stochastic estimation means the gradient of the loss for a single data point (single instance).
-->
En el Descenso de Gradiente Estocástico (SGD), reemplazamos el vector de gradiente real con una estimación estocástica del vector de gradiente. Específicamente para una red neuronal, la estimación estocástica hace referencia al gradiente del error para un único punto de datos (instancia única).

<!-- Let $f_i$ denote the loss of the network for the $i$-th instance.
-->
Sea $f_i$ el error de la red para la $i$-ésima instancia.

$$
f_i = l(x_i, y_i, w)
$$

<!-- The function that we eventually want to minimize is $f$, the total loss over all instances.
-->
La función que eventualmente queremos minimizar es $f$, el error total sobre todas las instancias.

$$
f = \frac{1}{n}\sum_i^n f_i
$$

<!-- In SGD, we update the weights according to the gradient over $f_i$ (as opposed to the gradient over the total loss $f$).
-->
En SGD, actualizamos los pesos de acuerdo con el gradiente sobre $f_i$ (a diferencia del gradiente sobre el error total $f$).

<!-- {(i chosen uniformly at random)}
-->
$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i elegido uniformemente al azar)}
\end{aligned}
$$

<!-- If $i$ is chosen randomly, then $f_i$ is a noisy but unbiased estimator of $f$, which is mathematically written as:
-->
Si $i$ es elegido al azar, entonces $f_i$ es un estimador ruidoso pero insesgado de $f$, que se escribe matemáticamente como:

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

<!-- As a result of this, the expected $k$-th step of SGD is the same as the $k$-th step of full gradient descent:
-->
Como resultado de esto, el $k$-ésimo paso esperado de SGD es el mismo que el $k$-ésimo de Descenso de Gradiente completo:

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

<!-- Thus, any SGD update is the same as full-batch update in expectation. However, SGD is not just faster gradient descent with noise. Along with being faster, SGD can also get us better results than full-batch gradient descent. The noise in SGD can help us avoid the shallow local minima and find a better (deeper) minima. This phenomenon is called **annealing**.
-->
Por lo tanto, cualquier actualización de SGD es lo mismo, en esperanza, que la actualización de lote completo (*full batch*). Sin embargo, SGD no es solo un descenso de gradiente más rápido con ruido. Además de ser más rápido, SGD también puede obtener mejores resultados que el descenso de gradiente de lote completo. El ruido en SGD puede ayudarnos a evitar los mínimos locales poco profundos y a encontrar mejores mínimos (más profundos). Este fenómeno es llamado ***annealing***.

<!-- <b>Figure 2:</b> Annealing with SGD
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figura 2:</b> *Annealing* con SGD
</center>

<!-- In summary, the advantages of Stochastic Gradient Descent are as follows:

 1. There is a lot of redundant information across instances. SGD prevents a lot of these redundant computations.
 2. At early stages, the noise is small as compared to the information in the gradient. Therefore a SGD step is *virtually as good as* a GD step.
 3. *Annealing* - The noise in SGD update can prevent convergence to a bad(shallow) local minima.
 4. Stochastic Gradient Descent is drastically cheaper to compute (as you don't go over all data points).
-->
En resumen, las ventajas del Descenso de Gradiente Estocástico son las siguientes:

 1. Hay mucha información redundante en todas las instancias. SGD evita muchos de estos cálculos redundantes.
 2. En las primeras etapas, el ruido es pequeño en comparación con la información en el gradiente. Por lo tanto, un paso SGD es *prácticamente tan bueno como* un paso de GD.
 3. *Annealing* - El ruido en la actualización de SGD puede evitar la convergencia a un mínimo local malo (superficial).
 4. El Descenso de Gradiente Estocástico es drásticamente más barato de calcular (ya que no utiliza todos los puntos de datos, sino solo uno, en cada cálculo del gradiente).

<!-- Mini-batching
-->
### Mini-batching

<!-- In mini-batching, we consider the loss over multiple randomly selected instances instead of calculating it over just one instance. This reduces the noise in the step update.
-->
En *mini-batching*, consideramos el error usando varias instancias de datos seleccionadas al azar en lugar de calcularlas en una sola instancia. Esto reduce el ruido en cada actualización.

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

<!-- Often we are able to make better use of our hardware by using mini batches instead of a single instance. For example, GPUs are poorly utilized when we use single instance training. Distributed network training techniques split a large mini-batch between the machines of a cluster and then aggregate the resulting gradients. Facebook recently trained a network on ImageNet data within an hour, using distributed training.
-->
A menudo podemos hacer un mejor uso de nuestro hardware mediante mini-batches en lugar de una sola instancia. Por ejemplo, las GPU se utilizan de manera ineficiente cuando utilizamos entrenamiento de instancia única. Las técnicas de entrenamiento en redes distribuidas dividen un gran mini-batch entre las máquinas de un clúster y luego suman los gradientes resultantes. Facebook recientemente entrenó una red con los datos de ImageNet en una hora, utilizando entrenamiento distribuido.

<!-- It is important to note that gradient descent should never be used with full sized batches. In case you want to train on the full batch-size, use an optimization technique called LBFGS. PyTorch and SciPy both provide implementations of this technique.
-->
Es importante tener en cuenta que el descenso de gradiente nunca debe usarse con lotes de tamaño completo. En caso de que se quiera entrenar en el lote completo, debe usarse una técnica de optimización llamada LBFGS. PyTorch y SciPy proporcionan implementaciones de esta técnica.

<!-- [Momentum]
-->
## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

<!-- In Momentum, we have two iterates ($p$ and $w$) instead of just one. The updates are as follows:
-->
En Momentum, tenemos dos parámetros iterables ($p$ y $w$) en lugar de solo uno. Se actualizan de la siguiente manera:

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

<!-- $p$ is called the SGD momentum. At each update step we add the stochastic gradient to the old value of the momentum, after dampening it by a factor $\beta$ (value between 0 and 1). $p$ can be thought of as a running average of the gradients. Finally we move $w$ in the direction of the new momentum $p$.
-->
$p$ se llama el impulso (*momentum*) de SGD. En cada paso de actualización, sumamos el gradiente estocástico al valor anterior del impulso, después de reducirlo por un factor $\beta$ (valor entre 0 y 1). $p$ puede considerarse como un promedio continuo de los gradientes. Finalmente, movemos $w$ en la dirección del nuevo impulso $p$.

<!-- Alternate Form: Stochastic Heavy Ball Method
-->
Forma alternativa: Método Estocástico de Bola Pesada

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

<!-- This form is mathematically equivalent to the previous form. Here, the next step is a combination of previous step's direction( $w_k - w_{k-1}$) and the new negative gradient.
-->
Esta forma es matemáticamente equivalente a la anterior. Aquí, el siguiente paso es una combinación de la dirección del paso anterior ($w_k - w_{k-1}$) y el nuevo gradiente negativo.


<!-- Intuition
-->
### Intuición

<!-- SGD Momentum is similar to the concept of momentum in physics. The optimization process resembles a heavy ball rolling down the hill. Momentum keeps the ball moving in the same direction that it is already moving in. Gradient can be thought of as a force pushing the ball in some other direction.
-->
SGD Momentum es similar al concepto de impulso en física. El proceso de optimización se asemeja a una bola pesada rodando cuesta abajo. Momentum mantiene la pelota en movimiento en la misma dirección en la que ya se está moviendo. El gradiente puede considerarse como una fuerza que empuja la pelota en otra dirección.

<!-- <b>Figure 3:</b> Effect of Momentum<br>
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figura 3:</b> Efecto de Momentum<br>
<b>Fuente:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

<!-- Rather than making dramatic changes in the direction of travel (as in the figure on the left), momentum makes modest changes. Momentum dampens the oscillations which are common when we use only SGD.
-->
En lugar de hacer cambios dramáticos en la dirección de movimiento (como en la figura de la izquierda), el impulso produce cambios modestos. Momentum amortigua las oscilaciones que son comunes cuando solo usamos SGD.

<!-- The $\beta$ parameter is called the Dampening Factor. $\beta$ has to be greater than zero, because if it is equal to zero, you are just doing gradient descent. It also has to be less than 1, otherwise everything will blow up. Smaller values of $\beta$ result in change in direction quicker. For larger values, it takes longer to make turns.
-->
El parámetro $\beta$ se llama Factor de Amortiguación. $\beta$ tiene que ser mayor que cero, porque de ser igual a cero, solo se estaría calculando un descenso de gradiente. También tiene que ser menor que 1, de lo contrario todo explotará. Los valores más pequeños de $\beta$ resultan en cambios de dirección más pronunciados. Para valores más grandes, toma más tiempo cambiar de dirección.

<!-- <b>Figure 4:</b> Effect of Beta on Convergence
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figura 4:</b> Efecto de Beta en la convergencia
</center>


<!-- Practical guidelines
-->
### Pautas prácticas

<!-- Momentum must pretty much be always be used with stochastic gradient descent.
$\beta$ = 0.9 or 0.99 almost always works well.
-->
Momentum debe usarse casi siempre con descenso de gradiente estocástico.
$\beta$ = 0.9 ó 0.99 suele funcionar bien.

<!-- The step size parameter usually needs to be decreased when the momentum parameter is increased to maintain convergence. If $\beta$ changes from 0.9 to 0.99, learning rate must be decreased by a factor of 10.
-->
El valor del parámetro de tamaño de paso generalmente debe disminuirse cuando se aumenta el parámetro de impulso para mantener la convergencia. Si $\beta$ cambia de 0.9 a 0.99, el valor de la tasa de aprendizaje debe reducirse en un factor de 10.

<!-- Why does momentum works?
-->
### ¿Por qué funciona Momentum?

<!-- Acceleration
-->
#### Aceleración

<!-- The following are the update rules for Nesterov's momentum.
-->
Las siguientes son las reglas de actualización para el impulso de Nesterov.

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

<!-- With Nesterov's Momentum, you can get accelerated convergence if you choose the constants very carefully. But this applies only to convex problems and not to Neural Networks.
-->
Con el impulso de Nesterov, puede obtenerse una convergencia acelerada si se eligen las constantes con mucho cuidado. Pero esto solo se aplica a problemas convexos y no a redes neuronales.

<!-- Many people say that normal momentum is also an accelerated method. But in reality, it is accelerated only for quadratics. Also, acceleration does not work well with SGD, as SGD has noise and acceleration does not work well with noise. Therefore, though some bit of acceleration is present with Momentum SGD, it alone is not a good explanation for the high performance of the technique.
-->
Mucha gente dice que el impulso normal también es un método acelerado. Pero en realidad, se acelera solo para las funciones cuadráticas. Además, la aceleración no funciona bien con SGD, ya que SGD tiene ruido y la aceleración no funciona bien con ruido. Por lo tanto, aunque hay un poco de aceleración con Momentum SGD, por sí solo no es una buena explicación del alto rendimiento de la técnica.


<!-- Noise smoothing
-->
#### Suavisado del ruido

<!-- Probably a more practical and probable reason to why momentum works is Noise Smoothing.
-->
Probablemente, una razón más práctica y probable de por qué Momentum funciona es el suavizado del ruido.

<!-- Momentum averages gradients. It is a running average of gradients that we use for each step update.
-->
Momentum promedia gradientes. Es un promedio continuo de gradientes que utilizamos para cada actualización en cada paso.

<!-- Theoretically, for SGD to work we should take average over all step updates.
-->
Teóricamente, para que SGD funcione, deberíamos tomar el promedio de todas las actualizaciones de los pasos.

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

<!-- The great thing about SGD with momentum is that this averaging is no longer necessary. Momentum adds smoothing to the optimization process, which makes each update a good approximation to the solution. With SGD you would want to average a whole bunch of updates and then take a step in that direction.
-->
Lo mejor acerca de SGD con Momentum es que este promedio ya no es necesario. Momentum agrega un suavizado al proceso de optimización, lo que hace que cada actualización sea una buena aproximación a la solución. Con SGD, se querría promediar un montón de actualizaciones y luego dar un paso en esa dirección.

<!-- Both Acceleration and Noise smoothing contribute to high performance of momentum.
-->
Tanto la aceleración como el suavizado del ruido contribuyen al alto rendimiento de Momentum.

<!-- <b>Figure 5:</b> SGD vs Momentum
-->
<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figura 5:</b> SGD <i>vs.</i> Momentum
</center>

<!-- With SGD, we make good progress towards solution initially but when we reach bowl(bottom of the valley) we bounce around in this floor. If we adjust learning rate we will bounce around slower. With momentum we smooth out the steps, so that there is no bouncing around.
-->
Con SGD, inicialmente hacemos un buen progreso hacia la solución, pero cuando llegamos al tazón (fondo del valle) nos quedamos rebotando en este piso. Si ajustamos la tasa de aprendizaje de manera acorde, rebotaremos menos. Con Momentum suavizamos los pasos, y con esto se logra que no haya rebotes.
