---
lang: es
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: Álgebra lineal y convoluciones
authors: Yuchi Ge, Anshan He, Shuting Gu, and Weiyang Wen
date: 18 Feb 2020
translation-date: 26 Mar 2020
translator: Manuel Pinar-Molina
---


<!-- ## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)
-->
## [Repaso de álgebra lineal](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

<!-- This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:
-->
Esta parte es un repaso de álgebra lineal básica dentro del contexto de las redes neuronales. Empezamos con una capa oculta simple $\boldsymbol{h}$:

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!-- The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$:
-->
La salida es una función no lineal $f$ aplicada a un vector $z$. Aquí, $z$ es la salida de una transformación afín $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ al vector de entrada $\boldsymbol{x} \in\mathbb{R^n}$:

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!-- For simplicity biases are ignored. The linear equation can be expanded as:
-->
Para simplificar, ignoraremos los términos constantes (*bias*). Podemos desarrollar la función lineal del siguiente modo:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

<!-- where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$.
-->
donde $\boldsymbol{a}^{(i)}$ es la $i$-ésima fila de la matriz $\boldsymbol{A}$.

<!-- To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$.
-->
Para entender el significado de esta transformación, analizaremos una componente de $\boldsymbol{z}$ tal que $a^{(1)}\boldsymbol{x}$. Para  $n=2$, $\boldsymbol{a} = (a_1,a_2)$ y $\boldsymbol{x}  = (x_1,x_2)$.

<!-- $\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as:
-->
$\boldsymbol{a}$ y $\boldsymbol{x}$ pueden dibujarse como vectores en los ejes de coordenados de $\mathbb{R^2}$. Ahora, si el ángulo entre $\boldsymbol{a}$ y $\hat{\boldsymbol{\imath}}$ es $\alpha$ y el ángulo entre $\boldsymbol{x}$ y $\hat{\boldsymbol{\imath}}$ es $\xi$, entonces con trigonometría $a^\top\boldsymbol{x}$ puede desarrollarse como:

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$

<!-- The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can understoof by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.
-->
La salida mide la alineación de la entrada con una fila específica de la matriz $\boldsymbol{A}$. Esto se puede entender observando el ángulo entre los dos vectores, $\xi-\alpha$. Cuando $\xi = \alpha$, los dos vectores están perfectamente alineados y se obtiene el máximo. Si $\xi - \alpha = \pi$, entonces $\boldsymbol{a}^\top\boldsymbol{x}$ alcanza su mínimo y los dos vectores están apuntando en direcciones opuestas. En esencia, la transformación lineal permite ver la proyección de una entrada a varias orientaciones definidas por $A$. Esta intuición aplica en dimensiones superiores.

<!-- Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:
-->
Otra forma de entender la transformación lineal es entendiendo que $\boldsymbol{z}$ también puede desarrollarse como:

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

<!-- The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.
-->
La salida es la suma ponderada de las columnas de la matriz $\boldsymbol{A}$. Por lo tanto, la señal no es más que una composición de la entrada.

<!-- ## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)
-->
## [Extender álgebra lineal a convoluciones](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!-- Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: -
-->
Ahora extenderemos el álgebra lineal a convoluciones, usando un ejemplo de análisis de datos de audio. Empezamos representando una capa totalmente conectada como una matriz de multiplicación:

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$.
-->
En este ejemplo, la matriz de pesos tiene un tamaño de $4 \times 3$, el vector de entrada tiene un tamaño de $3 \times 1$  y el vector de salida tiene un tamaño $4 \times 1$.

<!-- However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (e.g. 3 seconds) times the sampling rate (e.g. 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat".
-->
Sin embargo, para datos de audio, los datos de mucha mayor longitud (no de tres muestras de longitud). El número de muestras en los datos de audio es igual a la duración del audio(por ejemplo, tres segundos) por la tasa de muestreo (por ejemplo, 22.05 kHz). Como se muestra a continucación, el vector de entrada $\boldsymbol{x}$ será muy grande. Así pues, la matriz de pesos será más "ancha".

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- The above formulation will be difficult to train. Fortunately there are ways to simplify the same.
-->
La formulación anterior será difícil de entrenar. Afortunadamente, hay maneras de simplificar esto.

<!-- ### Property: locality
-->
### Propiedad: localidad

<!-- Due to locality (i.e. we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.
-->
Debido a la localidad  (es decir, no nos importan los puntos lejanos) de los datos, $w_{1k}$ de la matriz de pesos anterior, pueden sustituirse con 0 cuando $k$ es relativamente grande. Por lo tanto, la primera fila de la matriz se convierte en un *kernel* de dimensión tres. Llamaremos a este *kernel* de dimensión tres $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!-- ### Property: stationarity
-->
### Propiedad: estacionariedad

<!-- Natural data signals have the property of stationarity (i.e. certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (i.e. stride is 1), resulting in the following:
-->
Los datos de señales naturales poseen la propiedad de estacionariedad (es decir, ciertos patrones se repetirán). Esto nos ayuda a reusar el *kernel* $\mathbf{a}^{(1)}$ que definimos previamente. Usamos este *kernel* colocándolo una posición más lejos a la vez (es decir, con una zancada (*stride*) de uno), lo que resulta en lo siguiente:

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

<!-- Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing.
-->
La parte superior derecha y la parte inferior izquierda de la matriz se sustituyen por $0$ gracias a la localidad, lo que lleva a su dispersión (mayoría ceros). El reusar ciertos *kernels* una y otra vez es conocido como compartir pesos.

<!-- ### Multiple layers of Toeplitz matrix
-->
### Múltiples capas de la matriz de Teoplitz

<!-- After these changes, the number of parameters we are left with is 3 (i.e. $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (i.e. $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same.
-->
Después de estos cambios, el número de parámetros que nos quedan es tres (es decir, $a_1,a_2,a_3$). En comparación con la matriz de pesos anterior, que tenía 12 parámetros (es decir, $w_{11},w_{12},\cdots,w_{43}$), el número actual de parámetros es demasiado restrictivo y nos gustaría ampliarlo.

<!-- The previous matrix can be considered to be a layer (i.e. a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters.
-->
A la matriz anterior se le puede considerar una capa (es decir, una capa convolucional) con el *kernel* $\boldsymbol{a}^{(1)}$. Entonces podemos construir múltiples capas con diferentes *kernels* $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, para incrementar el número de parámetros.

<!-- Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well.
-->
Cada capa tiene una matriz que contiene solo un *kernel*, que es copiado múltiples veces. A este tipo de matriz se le llama matriz de Toeplitz. En cada matriz de Toeplitz, cada diagonal descendente de izquierda a derecha es constante. Las matrices de Toeplitz que usamos aquí también son matrices dispersas.

<!-- Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector is looks like the following: -
-->
Dado el primer *kernel* $\boldsymbol{a}^{(1)}$ y el vector de entrada $\boldsymbol{x}$, la primera posición de la salida dada por esta capa es $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Por lo tanto, el vector de salida completo tendrá la forma siguiente:

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

<!-- The same matrix multiplication method can be applied on following convolutional layers with other kernels (e.g. $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results.
-->
Se puede aplicar el mismo método de multiplicación de matrices en las siguientes capas convolucionales con otros *kernels* (por ejemplo, $\boldsymbol{a}^{(2)}$ y $\boldsymbol{a}^{(3)}$) para obtener resultados similares.

<!-- ## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)
-->
## [Escuchando convoluciones - *Jupyter Notebook*](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).
-->
Puedes encontrar el *Jupyter Notebook* [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).

<!-- In this notebook, we are going to explore Convolution as a 'running scalar product'.
-->
En este cuaderno, vamos a explorar la convolución como "un producto escalar móvil".

<!-- The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and it's sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2).
-->
La biblioteca `librosa` nos permite cargar un segmento de audio $\boldsymbol{x}$ y su frecuencia de muestreo. En este caso, hay 70 641 muestras, la tasa de muestreo es 22.05 kHz y la longitud total del segmento de audio es 3.2 s. La señal de audio importada es ondulada (ver la figura 1) y podemos suponer cómo suena por la amplitud del eje $y$. La señal de audio $x(t)$ es, en realidad, el sonido que suena cuando apagas el sistema operativo Windows (ver la figura 2).

<!-- <b>Fig. 1</b>: A visualization of the audio signal. <br>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: Visualización de la señal de audio<br>
</center>
<!-- <b>Fig. 2</b>: Notes for the above audio signal.<br>
-->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Notas de la señal de audio anterior<br>
</center>

<!-- We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (e.g. first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal.
-->
Necesitamos separar las notas de la forma de onda. Para conseguirlo, si usamos la transformada de Fourier (FT, por sus siglas en inglés), todas las notas saldrían juntas y sería difícil determinar el momento exacto y la ubicación de cada tono. Por lo tanto, se necesita una FT localizada (también conocida como espectrograma). Como se observa en el espectrograma (ver la figura 3), diferentes tonos alcanzan su máxima frecuencia (por ejemplo, el primer tono llega a su máximo en en 1 600). El concatenar los cuatro tonos en sus frecuencias nos da una versión de tono de la señal original.

<!-- <b>Fig. 3</b>: Audio signal and its spectrogram.<br>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Señal de audio y su espectrograma<br>
</center>

<!-- Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes the in the input piece (i.e. the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolution of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the the convolutions prove the effectiveness of the convolutions in extracting the the notes.
-->
La convolución de la señal de entrada con todos los tonos (por ejemplo, todas las teclas del piano) puede ayudar a extraer todas las notas en la pieza de entrada (es decir, los resultados cuando el audio coincide con *kernels* específicos). Los espectrogramas de la señal original y la señal de los tonos concatenados se muestran en la figura 4 mientras que las frecuencias de la señal original y los cuatro tonos se muestran en la figura 5. La gráfica de la convolución de los cuatro *kernels* con la señal de entrada (señal original) se muestra en la figura 6. La figura 6 junto con los clips de audio de las convoluciones prueban la efectividad de las convoluciones para extraer las notas.

<!-- <b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
-->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Espectrograma de la señal original (izquierda) y espectrograma de la concatenación de tonos (derecha)<br>
</center>

<!-- <b>Fig. 5</b>: First melody's note.<br>
-->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: Primera nota de la melodía<br>
</center>
<!-- <b>Fig. 6</b>: Convolution of four kernels.<br>
-->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolución de cuatro <em>kernels</em><br>
</center>

<!-- ## Dimensionality of different datasets
-->
## Dimensionalidad de los diferentes conjuntos de datos

<!-- The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$.
-->
La última parte es una pequeña digresión sobre las diferentes representaciones de la dimensionalidad y ejemplos de lo mismo. Aquí consideramos que el conjunto de entrada $X$ está formado por funciones de mapeado del dominio $\Omega$ hacia los canales $c$.

<!-- ### Examples
-->
### Ejemplos

<!-- * Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), etc.
* Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*
* Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it si called Hamiltonian.
-->
* Datos de audio: el dominio es unidimensional, señal discreta indexada en el tiempo; número de canales $c$ puede variar desde 1 (mono), 2 (estéreo), 5+1 (Dolby 5.1), etc.
* Datos de imagen: el dominio es bidimensional (pixeles); $c$ pueden variar desde 1 (escala de grises), 3 (color), 20(hiperespectral), etc.
* Relatividad especial: el dominio es $\mathbb{R^4} \times \mathbb{R^4}$ (espacio-tiempo $\times$ cuatro-momentum); cuando $c = 1$ es conocido como Hamiltoniano.
<!-- <b>Fig. 7</b>: Different dimensions of different types of signals.<br>
-->
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Fig. 7</b>: Diferentes dimensiones de diferentes tipos de señales<br>
</center>
