---
lang: es
lang-ref: ch.03-3
title: Propiedades de las señales naturales
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
translation-date: 2 Apr 2020
translator: LecJackS
---


<!-- ## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)
-->
## [Propiedades de las señales naturales](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

<!-- All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2,...,x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language i.e. it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.
-->
Todas las señales pueden considerarse como vectores. Por ejemplo, una señal de audio es una señal unidimensional $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ donde cada valor $x_t$ representa la amplitud de la forma de onda en el tiempo $t$. Para dar sentido a lo que alguien está hablando, nuestra cóclea primero convierte las vibraciones de la presión del aire en señales y luego el cerebro usa un modelo de lenguaje para convertir esta señal a un idioma, es decir, necesita elegir el enunciado más probable, dada la señal. En la música, la señal es estereofónica, o sea que tiene dos o más canales para dar la ilusión de que el sonido proviene de múltiples direcciones. Aunque tenga dos canales, sigue siendo una señal unidimensional porque el tiempo es la única variable a lo largo de la cual está cambiando la señal.

<!-- An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.
-->
Una imagen es una señal bidimensional porque la información se representa espacialmente. Hay que tener en cuenta que cada punto puede ser un vector en sí mismo. Esto significa que si tenemos $d$ canales en una imagen, cada punto espacial en la imagen es un vector de dimensión $d$. Una imagen en color tiene planos RGB, lo que significa que $d = 3$. Para cualquier punto $x_{i,j}$, esto corresponde a la intensidad de los colores rojo, verde y azul, respectivamente.

<!-- We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.
-->
Incluso podemos representar el lenguaje con la lógica anterior. Cada palabra corresponde a un vector *one-hot*, con un uno en la posición en la que se encuentra en nuestro vocabulario y ceros en el resto. Esto significa que cada palabra es un vector del tamaño del vocabulario.

<!-- Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.
-->
Las señales de datos naturales siguen estas propiedades:
1. Estacionariedad: Ciertos patrones se repiten a lo largo de una señal. En las señales de audio, observamos el mismo tipo de patrones una y otra vez en todo el dominio temporal. En imágenes, esto significa que podemos esperar que se repitan patrones visuales similares a través de la dimensionalidad.
2. Localidad: Los puntos cercanos están más correlacionados que los puntos lejanos. Para la señal unidimensional, esto significa que si observamos un pico en algún punto $t_i$, esperamos que los puntos en una pequeña ventana alrededor de $t_i$ tengan valores similares a $t_i$, pero para un punto $t_j$ lejos de $t_i$, $x_{t_i}$ tiene muy poca relación con $x_{t_j}$. Más formalmente, la convolución entre una señal y su contraparte invertida tiene un pico cuando la señal se superpone perfectamente con su versión invertida. Una convolución entre dos señales unidimensionales (correlación cruzada) no es más que su producto punto, que es una medida de cuán similares o cercanos son los dos vectores. Por lo tanto, la información está contenida en porciones y partes específicas de la señal. Para las imágenes, esto significa que la correlación entre dos puntos en una imagen disminuye a medida que alejamos los puntos. Si el pixel $x_{0,0}$ es azul, la probabilidad de que el próximo pixel ($x_{1,0}, x_{0,1}$) también sea azul es bastante alta, pero a medida que se avanza hacia el extremo opuesto de la imagen ($x_{-1,-1}$), el valor de este pixel será independiente del valor de pixel en $ x_{0,0}$.
3. Composicionalidad: todo en la naturaleza está compuesto de partes que se componen de subpartes, y así sucesivamente. Por ejemplo, los caracteres forman cadenas que forman palabras, que luego forman oraciones. Las oraciones se pueden combinar para formar documentos. La composicionidad permite que el mundo sea explicable.

<!-- If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.
-->
Si nuestros datos exhiben estacionariedad, localidad y composicionalidad, podemos explotarlos con redes que utilicen dispersión, parámetros compartidos y apilamiento de capas.


<!--
## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
-->
## [Explotando propiedades de las señales naturales para generar invariancia y equivalencia](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)

<!--
### Locality  $\Rightarrow$ sparsity
-->
### Localidad $\Rightarrow$ dispersión

<!-- Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.
-->
La figura 1 muestra una red de cinco capas *fully connected*. Cada flecha representa un peso que se multiplicará por las entradas. Como podemos ver, esta red es computacionalmente costosa.

<!-- <b>Figure 1:</b> Fully Connected Network</center> -->
<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figura 1:</b> Red *Fully Connected*</center>


<!-- If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.
-->
Si nuestros datos exhiben localidad, cada neurona necesita estar conectada a solo unas pocas neuronas locales de la capa anterior. Por lo tanto, algunas conexiones se pueden ignorar, como se muestra en la figura 2. La figura 2(a) representa una red FC. Aprovechando la propiedad de localidad de nuestros datos, eliminamos las conexiones entre neuronas lejanas como se ve en la figura 2(b). Aunque las neuronas de la capa oculta (verde) en la figura 2(b) no abarcan toda la entrada, la arquitectura general podrá considerar todas las neuronas de entrada. El campo receptivo (RF, por sus siglas en inglés) es el número de neuronas de capas anteriores que cada neurona de una capa en particular puede ver o ha tenido en cuenta. Por lo tanto, el RF de la capa de salida con respecto a la capa oculta es tres, el RF de la capa oculta con respecto a la capa de entrada es tres, pero el RF de la capa de salida con respecto a la capa de entrada es cinco.

<!--
|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> Before Applying Sparsity | <b>Figure 2(b):</b> After Applying Sparsity|
-->
|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figura 2(a):</b> Antes de aplicar dispersión | <b>Figura 2(b):</b> Luego de aplicar dispersión|


<!-- ### Stationarity $\Rightarrow$ parameters sharing
-->
### Estacionariedad $\Rightarrow$ parámetros compartidos

<!-- If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.
-->
Si nuestros datos muestran estacionariedad, podríamos usar un pequeño conjunto de parámetros varias veces en la arquitectura de red. Por ejemplo, en nuestra red dispersa, (ver la figura 3(a)), podemos usar un conjunto de tres parámetros compartidos (amarillo, naranja y rojo). ¡El número de parámetros caerá de 9 a 3! La nueva arquitectura incluso podría funcionar mejor porque tenemos más datos para entrenar esos pesos específicos.
Los pesos después de aplicar la dispersión y los parámetros compartidos se denominan "*kernel* de convolución".

<!--
|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> Before Applying Parameter Sharing | <b>Figure 3(b):</b> After Applying Parameter Sharing|
-->
|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figura 3(a):</b> Antes de compartir parámetros | <b>Figura 3(b):</b> Después de compartir parámetros|

<!-- Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation
-->
Las siguientes son algunas ventajas de usar dispersión y parámetros compartidos:
* Uso parámetros compartidos
  * convergencia más rápida
  * mejor generalización
  * no limitado al tamaño de entrada
  * independencia de *kernels* $\Rightarrow$ alta paralelización
* Dispersión de conexiones
  * reduce la cantidad de cómputo

<!-- Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).
-->
La figura 4 muestra un ejemplo de *kernels* sobre datos unidimensionales, donde el tamaño del *kernel* es: 2 (número de *kernels*) * 7 (ancho de la capa anterior) * 3 (número de conexiones/pesos únicos).

<!-- The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.
-->
La elección del tamaño del *kernel* es empírica. La convolución de 3 * 3 parece ser el tamaño mínimo para los datos espaciales. La convolución de tamaño uno se puede usar para obtener una capa final que se puede aplicar a una imagen de entrada más grande. Tamaños de *kernel* de un número par podrían disminuir la calidad de los datos, por lo que siempre usamos un tamaño de *kernel* de números impares, generalmente 3 o 5.

<!--
|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> Kernels on 1D Data | <b>Figure 4(b):</b> Data with Zero Padding|
-->
|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figura 4(a):</b> *Kernels* sobre datos unidimensionales | <b>Figura 4(b):</b> Datos con *padding* de ceros|

<!--
### Padding
-->
### *Padding*

<!-- Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.
-->
Aplicar *padding* (relleno) generalmente perjudica los resultados finales, pero es conveniente a nivel programación. Solemos usar *padding* de ceros: `tamaño = (tamaño del kernel - 1) / 2`.


<!--
### Standard spatial CNN
-->
### CNN espacial estándar

<!-- A standard spatial CNN has the following properties:
-->
Una CNN espacial estándar tiene las siguientes propiedades:

<!-- * Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection
-->
* Múltiples capas
  * Convolución
  * No linealidad (ReLU y *Leaky*)
  * *Pooling*
  * Normalización por lotes (*Batch normalization*)
* Conexión residual de derivación (*residual bypass conection*)

<!-- Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.
-->
*Batch normalization* y las conexiones residuales de derivación son muy útiles para que la red entrene bien.
Pueden perderse partes de una señal si se apilan demasiadas capas, por lo que agregar conexiones de derivación garantizan una ruta para que la información circule de abajo hacia arriba y también una ruta para los gradientes que vienen de arriba hacia abajo.

<!-- In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.
-->
En la figura 5, mientras que la imagen de entrada contiene principalmente información espacial en dos dimensiones (aparte de la información característica, que es el color de cada pixel), la capa de salida es gruesa. A mitad de camino, existe un equilibrio entre la información espacial y la información característica, y la representación se vuelve más densa. Por lo tanto, a medida que avanzamos en la jerarquía, obtenemos una representación más densa al mismo tiempo que perdemos información espacial.

<!-- <b>Figure 5:</b> Information Representations Moving up the Hierachy</center> -->
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figura 5:</b> Representaciones de la información a medida que subimos en la jerarquía</center>


<!-- ### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)
-->
### [*Pooling*](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<!-- <b>Figure 6:</b> Illustration of Pooling</center> -->
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figura 6:</b> Illustración del *pooling*</center>

<!-- A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.
-->
Un operador específico, Norma-$L_p$, se aplica a diferentes regiones (ver la figura 6). Tal operador da solo un valor por región (un valor para cuatro pixeles en nuestro ejemplo). Luego iteramos sobre todos los datos, región por región, avanzando en tamaño de zancada. Si comenzamos con datos de $m * n$ con $c$ canales, terminaremos con datos de $\frac{m}{2} * \frac{n}{2}$ aún con $ c $ canales (ver figura 7).
La operación de *pooling* no está parametrizada; sin embargo, podemos elegir diferentes tipos de *pooling*, como *max pooling*, *pooling* promedio, etc. El objetivo principal de la operación de pooling es reducir la cantidad de datos para poder hacer los cálculos en una cantidad de tiempo razonable.

<!-- <b>Figure 7:</b> Pooling results </center> -->
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figura 7:</b> Resultado de aplicar *pooling* </center>


<!-- ## CNN - Jupyter Notebook
-->
## CNN - *Jupyter Notebook*

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->
El *Jupyter Notebook* se puede encontrar [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). Para ejecutarlo, asegúrate de tener instalado el entorno `pDL` como se especifica en [`README-ES.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/docs/es/README-ES.md).

<!-- In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)
-->
En este *Notebook*, entrenamos un perceptrón multicapa (red FC) y una red neuronal convolucional (CNN) para la tarea de clasificación con el conjunto datos de MNIST. Ten en cuenta que ambas redes tienen el mismo número de parámetros. (ver la figura 8)

<!-- <b>Figure 8:</b> Instances from the Original MNIST Dataset </center> -->
<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figura 8:</b> Instancias del conjunto de datos MNIST original</center>

<!-- Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:
-->
Antes de entrenar, normalizamos nuestros datos para que la inicialización de la red coincida con nuestra distribución de datos (¡muy importante!). Además, asegúrate de que las siguientes cinco operaciones/pasos estén presentes en tu algoritmo de entrenamiento:

<!--
 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method
-->
1. Introducción de datos al modelo
2. Calcular la función de costo
3. Limpiar el caché de gradientes acumulados con `zero_grad()`
4. Calcular los gradientes
5. Realizar un paso con el método del optimizador

<!-- First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.
-->
Primero, entrenamos ambas redes con los datos de MNIST normalizados. La precisión de la red FC resultó ser de $87 \%$ mientras que la precisión de la CNN resultó ser de $95 \%$. Dado el mismo número de parámetros, la CNN logró entrenar muchos más filtros. En la red FC, se entrenan filtros que intentan obtener algunas dependencias entre cosas muy distantes entre sí con cosas que están muy próximas. Son filtros completamente desperdiciados. En cambio, en la red convolucional, todos estos parámetros se concentran en la relación entre pixeles vecinos.

<!-- Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.
-->
A continuación, realizamos una permutación aleatoria de todos los pixeles en todas las imágenes de nuestro conjunto de datos MNIST. Esto transforma la figura 8 en la figura 9. Luego entrenamos ambas redes en este conjunto de datos modificado.

<!-- <b>Figure 9:</b> Instances from Permuted MNIST Dataset</center> -->
<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figura 9:</b> Instancias del conjunto de datos MNIST permutado</center>

<!-- The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->
El rendimiento de la red FC se mantuvo casi sin cambios ($85 \%$), mientras que la exactitud de la CNN se redujo a $83 \%$. Esto se debe a que, después de una permutación aleatoria, las imágenes ya no tienen las tres propiedades de localidad, estacionariedad y composicionalidad que una CNN puede explotar.
