---
lang: es
lang-ref: ch.03-2
lecturer: Yann LeCun
title: Evoluciones de CNNs, Arquitecturas, Detalles y Ventajas de Implementación.
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translation-date: 01 Apr 2020
translator: LecJackS
---

<!--
## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)
-->
## [Proto-CNN y evolución hasta las CNN modernas](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)

<!--
### Proto-convolutional neural nets on small data sets
-->
### Redes neuronales proto-convolucionales en pequeños conjuntos de datos

<!--
Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:
-->
Inspirado por el trabajo de Fukushima en el modelado de la corteza visual, haciendo uso de la jerarquía celular simple/compleja combinada con entrenamiento supervisado y retropropagación, se condujo al desarrollo de la primera CNN en la Universidad de Toronto en los años de 1988-1989 por el profesor Yann LeCun. Los experimentos utilizaron un pequeño conjunto de datos de 320 dígitos 'escritos' con el mouse. Se compararon los rendimientos de las siguientes arquitecturas:

<!--
1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps)
-->
1. Una sola capa totalmente conectada (*FC: fully connected*)
2. Dos capas FC
3. Capas conectadas localmente sin parámetros compartidos
4. Red restringida con pesos compartidos y conexiones locales
5. Red restringida con pesos compartidos y conexiones locales 2 (con más mapeo de características o *features*)

<!-- The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit.
-->
Las redes más exitosas (red restringida con parámetros compartidos) tenían la mayor capacidad de generalización y forman la base de las CNN modernas. Mientras tanto, el modelo de capa única FC tiende a sobreajustarse (*overfitting*).

<!--
### First "real" ConvNets at Bell Labs
-->
### Primeras ConvNets "reales" en los laboratorios Bell

<!-- After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:
-->
Después de mudarse a Bell Labs, la investigación de LeCunn pasó a utilizar códigos postales escritos a mano del servicio postal de los EE.UU., para entrenar una CNN más grande:

<!--
* 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling-->
* Capa de entrada de 256 (16$\times$16) valores (pixeles)
* 12 *kernels* de 5$\times$5 con tamaño de zancada de 2 (avanzaba de a 2 pixeles): la siguiente capa tiene menor resolución
* **SIN** operación de *pooling*


<!-- ### Convolutional network architecture with pooling-->
### Arquitectura de red convolucional con **pooling**

<!-- The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half.
-->
Al año siguiente, se hicieron algunos cambios: se introdujo una capa de *pooling* (operación de muestreo) separada. La operación de pooling se realiza promediando los valores de entrada, agregando un sesgo (*bias*) y pasando a una función no lineal (en este caso la función tangente hiperbólica). El *pooling* de 2$\times$2 se realizaba con una zancada de 2, reduciendo así las resoluciones a la mitad.

<!-- <b>Fig. 1</b> ConvNet Architecture -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> Arquitectura ConvNet
</center>

<!-- An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels
-->
Un ejemplo de una sola capa convolucional sería el siguiente:
1. Se toma una entrada con tamaño 32$\times$32
2. La capa de convolución pasa sobre la imagen un *kernel* de 5$\times$5 con zancada 1, con un tamaño mapa de características resultante de 28$\times$28
3. Se pasa el mapa de características por una función no lineal: tamaño resultante 28$\times$28
4. Se pasa a la capa *pooling* que promedia una ventana de 2$\times$2 con zancada de 2: tamaño resultante 14$\times$14
5. Se repiten los pasos 1 al 4 para cuatro *kernels*

<!-- The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map:
-->
La primera capa, simples combinaciones de convolución/*pooling*, generalmente detecta características simples, como deteccion de bordes con orientación. Después de la primera capa de convolución/*pooling*, el objetivo es detectar combinaciones de características de capas anteriores. Para hacer esto, los pasos 2 al 4 se repiten con múltiples *kernels* sobre los mapas de características resultantes de la capa anterior y se suman en un nuevo mapa de características:

<!-- 1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map
-->
1. Un nuevo *kernel* de 5$\times$5 se desliza sobre todos los mapas de características de las capas anteriores y se suman entre sí los resultados. (Nota: en el experimento del Prof. LeCun en 1989, se ignoraban ciertas conexiones por limitaciones computacionales. Las configuraciones modernas generalmente imponen conexiones completas): tamaño de salida 10$\times$10
2. Se pasa la salida de la convolución por una función no lineal: tamaño resultante 10$\times$10
3. Se repiten los pasos 1-2 para 16 *kernels*
4. Se pasa el resultado a la capa *pooling* que promedia una ventana de 2$\times$2 con zancada de 2: con tamaño de salida de cada mapa de características de 5$\times$5

<!-- To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional. -->
Para generar una salida, la última capa de convolución es dirigida, lo que parece a una conexión completa, pero de hecho es convolucional.

<!-- 1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel)
-->
1. La capa de convolución final desliza un *kernel* 5$\times$5 sobre todos los mapas de características, con los resultados sumados: tamaño 1$\times$1
2. Se pasa a través de la función no lineal: tamaño 1$\times$1
3. Se genera una única salida para una categoría
4. Se repiten todos los pasos anteriores para cada una de las diez categorías (en paralelo)

<!-- See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).-->
Ve [esta animación](http://cs231n.github.io/convolutional-networks/) en el sitio web de Andrej Karpathy, sobre cómo las convoluciones cambian la forma de los mapas de características de la siguiente capa. El artículo completo se puede encontrar [aquí](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).

<!-- ### Shift equivariance -->
### Equivarianza a los desplazamientos

<!-- <b>Fig. 2</b> Shift Equivariance -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Equivarianza a los cambios de posición
</center>

<!-- As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. E.g. the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, i.e. making the representation more abstract and less sensitive to shifts and distortions.
-->
Como lo demuestra la animación en las diapositivas (este es otro ejemplo), trasladar la imagen de entrada da como resultado la misma traslación de los mapas de características. Sin embargo, los cambios en los mapas de características se escalan por operaciones de convolución/*pooling*. Por ejemplo, el *pooling* de 2$\times$2 con zancada de 2 reducirá el desplazamiento de un pixel en la capa de entrada a un desplazamiento de 0.5 pixeles en los siguientes mapas de características. La resolución espacial se intercambia por un mayor número de tipos de características, es decir, haciendo que la representación sea más abstracta y menos sensible a los cambios de posición y distorsiones.

<!--
### Overall architecture breakdown
-->
### Desglose general de la arquitectura

<!-- Generic CNN architecture can be broken down into several basic layer archetypes: -->
La arquitectura genérica de las CNN se puede dividir en varios arquetipos de capa básica:

<!--
* **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods e.g. average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation -->
* **Normalización**
  * Ajuste de blanqueamiento (opcional)
  * Métodos sustractivos, por ejemplo: sustracción del promedio, filtrado pasa altas
  * Divisivo: normalización de contraste local, normalización de varianza

<!--
* **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections -->
* **Bancos de Filtrado**
  * Aumenta la dimensionalidad
  * Proyección sobre bases completas
  * Detecciones de bordes

<!--
* **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$ -->
* **No linealidades**
  * Aumento de dispersión
  * Típicamente Unidad Lineal Rectificada (ReLU): $\text{ReLU}(x) = \max(x, 0)$

<!--
* **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$ -->
* ***Pooling***
  * Muestreo sobre un mapa de características
  * *Max Pooling*: $\text{MAX}= \text{Max}_i(X_i)$

  * *Pooling* de norma-LP:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

  * *Pooling* de probabilidad-Logarítmica:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$


<!-- ## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s) -->
## [LeNet5 y reconocimiento de dígitos](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)

<!-- ### Implementation of LeNet5 in PyTorch -->
### Implementación de LeNet5 en PyTorch

<!-- LeNet5 consists of the following layers (1 being the top-most layer): -->
LeNet5 está formado por las siguientes capas (siendo 1 la capa superior)

<!--
1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1. -->
1. *Log-softmax*
2. Capa *Fully Connected* de dimensiones 500$\times$10
3. ReLu
4. Capa *Fully Connected* de dimensiones (4$\times$4$\times$50)$\times$500
5. *Max Pooling* de dimensiones 2$\times$2, zancada de 2
6. ReLu
7. Convolución con 20 canales de salida, *kernel* de 5$\times$5, zancada de 1
8. *Max Pooling* de dimensiones 2$\times$2, zancada de 2
9. ReLu
10. Convolución con 20 canales de salida, *kernel* de 5$\times$5, zancada de 1

<!-- The input is a 32$\times$32 grey scale image (1 input channel). -->
La entrada es una imagen en escala de grises de 32$\times$32 (1 canal de entrada).

<!-- LeNet5 can be implemented in PyTorch with the following code: -->
LeNet5 se puede implementar en PyTorch con el siguiente código:

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
    x = F.relu(self.conv1(x))
    x = F.max_pool2d(x, 2, 2)
    x = F.relu(self.conv2(x))
    x = F.max_pool2d(x, 2, 2)
    x = x.view(-1, 4*4*50)
    x = F.relu(self.fc1)
    x = self.fc2(x)
    return F.logsoftmax(x, dim=1)
```

<!-- Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes. -->
Aunque `fc1` y `fc2` son capas completamente conectadas (FC), pueden considerarse capas convolucionales cuyos *kernels* cubren toda la entrada. Las capas completamente conectadas se utilizan con fines de eficiencia.

<!-- The same code can be expressed using `nn.Sequential`, but it is outdated. -->
 El mismo código puede expresarse usando `nn.Sequential`, pero está desactualizado.

<!-- ## Advantages of CNN -->
## Ventajas de las CNN

<!-- In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output. -->
En una red totalmente convolucional, no es necesario especificar el tamaño de la entrada. Sin embargo, cambiar el tamaño de la entrada también cambia el tamaño de la salida.

<!-- Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image. -->
Considera un sistema de reconocimiento de escritura cursiva a mano. No es necesario dividir la imagen de entrada en segmentos. Podemos aplicar la CNN sobre toda la imagen: los *kernels* cubrirán todas las ubicaciones de la imagen completa y registrarán la misma salida independientemente de dónde se encuentre el patrón. Aplicar la CNN sobre una imagen completa es mucho más barato que aplicarla en varias ubicaciones por separado. No se requiere segmentación previa, lo cual es un alivio porque la tarea de segmentar una imagen es similar a la de reconocer una imagen.

<!-- ### Example: MNIST -->
### Ejemplo: MNIST

<!-- LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre. -->
LeNet5 está entrenada con imágenes de MNIST de tamaño 32$\times$32 para la clasificación de dígitos individuales en el centro de la imagen. Se utilizó una técnica de aumento de datos de entrenamiento al mover el dígito, cambiar el tamaño del dígito e insertar otros dígitos a un lado. También se entrenó con una categoría 11 que representaba a niguna de las anteriores. Las imágenes etiquetadas con esta categoría se generaron ya sea produciendo imágenes completamente en blanco o colocando dígitos a un lado pero no en el centro.

<!-- <b>Fig. 3</b> Sliding Window ConvNet -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Ventana deslizante de una ConvNet
</center>


<!-- The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations. -->
La imagen de arriba demuestra que una red LeNet5 entrenada con imáges de 32$\times$32 se puede aplicar en una imagen de entrada de 32$\times$64 px para reconocer el dígito en múltiples ubicaciones.

<!-- ## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s) -->
## [Problema de unión de características](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

<!-- ### What is the feature binding problem? -->
### ¿Cuál es el problema de unión de características?

<!-- Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object? -->
Los neurocientíficos visuales y los profesionales en el área de visión por computadora tienen el problema de definir el objeto como un objeto. Un objeto es una colección de características, pero ¿cómo vincular todas las características para formar este objeto?

<!-- ### How to solve it? -->
### ¿Cómo solucionarlo?

<!-- We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN.
-->
Podemos resolver este problema de unión de características usando una CNN muy simple: solo dos capas de convoluciones con *pooling* más otras dos capas completamente conectadas sin ningún mecanismo específico para ello, dado que tenemos suficientes no linealidades y datos para entrenar nuestra CNN.

<!-- <b>Fig. 4</b> ConvNet Addressing Feature Binding -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet interpretando la unión de características
</center>

<!-- The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, i.e. recognizing features in a hierarchical, compositional way. -->
La animación anterior muestra la capacidad de las CNN para reconocer diferentes dígitos al mover un solo trazo, lo que demuestra su capacidad para abordar problemas de unión de características, es decir, reconocer características de forma jerárquica y composicional.

<!-- ### Example: dynamic input length -->
### Ejemplo: longitud de entrada dinámica

<!-- We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output. -->
Podemos construir una CNN con dos capas de convolución con zancada de uno y dos capas de *pooling* con zancada de dos, de modo que la zancada general sea cuatro. Por lo tanto, si queremos obtener una nueva salida, debemos desplazar nuestra ventana de entrada en cuatro. Para ser más explícitos, podemos ver la siguiente figura (unidades verdes). Primero, tenemos una entrada de tamaño diez y realizamos una convolución de tamaño tres para obtener ocho unidades. Después de eso, realizamos un *pooling* de tamaño dos para obtener cuatro unidades. Del mismo modo, repetimos nuevamente la convolución y el *pooling* y, finalmente, obtenemos una salida.

<!-- <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding -->
<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> Arquitectura ConvNet sobre unión de tamaño de entrada variante
</center>

<!-- Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2)-->

<!-- the overall subsampling we have shown from input to output is 4 (2x2)-->

<!-- . Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs.
-->

Supongamos que agregamos cuatro unidades en la capa de entrada (unidades rosa en la imagen de arriba), para que podamos obtener cuatro unidades más después de la primera capa de convolución, dos unidades más después de la primera capa de *pooling*, dos unidades más después de la segunda capa de convolución capa y una salida más. Por lo tanto, el tamaño de la ventana para generar una nueva salida es cuatro (zancadas de 2 $\times$2). Además, esto es una demostración del hecho de que si aumentamos el tamaño de la entrada, aumentaremos el tamaño de cada capa, demostrando la capacidad de las CNN de manejar entradas de longitud dinámica.


<!-- ## What are CNN good for -->
## ¿En qué son buenas las CNN?

<!-- CNN are good for signals that come to you in the form of multidimensional arrays. These signals have three major characters.
1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections.
2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image.
3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells. -->
Las CNNs son buenas para señales que llegan en forma de arreglos multidimensionales. Estas señales tienen tres propiedades principales.
1. **Localidad**: La primera es que existe una fuerte correlación local entre los valores. Si tomamos dos pixeles cercanos de una imagen natural, es muy probable que esos pixeles tengan el mismo color. A medida que dos pixeles se separen más, la similitud entre ellos disminuirá. Las correlaciones locales pueden ayudarnos a detectar características locales, que es lo que están haciendo las CNN. Si alimentamos la CNN con pixeles permutados, no funcionará bien al reconocer las imágenes de entrada, mientras que una FC no se verá afectada por ello. La correlación local justifica las conexiones locales.
2. **Estacionariedad**: La segunda propiedad es que las características son esenciales y pueden aparecer en cualquier lugar de la imagen, lo que justifica los parámetros compartidos y el *pooling*. Además, las señales estadísticas se distribuyen uniformemente, lo que significa que debemos repetir la detección de características para cada ubicación en la imagen de entrada.
3. **Composicionalidad**: La tercera propiedad es que las imágenes naturales son composicionales, lo que significa que las características componen una imagen de manera jerárquica. Esto justifica el uso de múltiples capas de neuronas, que también se corresponde estrechamente con la investigación de Hubel y Wiesel sobre células simples y complejas.

<!-- Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition. -->
Además, las personas hacen un buen uso de las CNN en videos, imágenes, textos y para el reconocimiento de voz.
