---
lang: es
lang-ref: ch.03-1
lecturer: Yann LeCun
title: Visualización de transformación de párametros vía red neuronal y conceptos fundamentales de convolución
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
translation-date: 24 Mar 2020
translator: je-santos
---


## [Visualización de redes neuronales](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

<!--
In this section we will visualise the inner workings of a neural network.
-->
En esta sección visualizaremos cómo funciona una red neuronal por dentro.

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Estructura de una red</center>

<!--
Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.
-->

En la figura 1, podemos observar la estructura de la red neuronal que quisiéramos visualizar. Convencionalmente, al dibujar una red, la entrada es colocada en la parte inferior o a la izquierda del diagrama, y la salida, en la parte superior o a la derecha. En la figura 1, las neuronas rosadas representan la entrada, y las azules, la salida. En esta red, tenemos cuatro capas ocultas (en verde); así que tenemos seis capas en total (4 capas ocultas + 1 capa de entrada + 1 capa de salida). Esta red tiene dos neuronas por cada capa oculta; por ende, la dimensión de la matriz de pesos ($W$) en cada capa es $2x2$. Esto es debido a que, en este caso, queremos transformar el plano de entrada (2D) a otro plano (2D) que podemos visualizar.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualización del espacio siendo doblado por la red</center>

<!--
The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.
-->

La transformación que ocurre en cada capa de la red es análoga a doblar nuestro plano en algunas regiones específicas como se muestra en la figura 2. Este doblez es muy abrupto dado que todas las transformaciones ocurren la capa de dos dimensiones. En este experimento, encontramos que si solo tenemos dos neuronas en cada capa oculta, la optimización toma más tiempo. La optimización sería más fácil si tuviéramos más neuronas en las capas ocultas. Esta discusión nos lleva a una pregunta importante: ¿por qué es más difícil entrenar una red con menos neuronas en las capas ocultas? Deberías meditar en la respuesta; regresaremos más tarde a ella después de la visualización de  $\texttt{ReLU}$.


| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<center>Fig. 3 Visualización del operador ReLU</center>


<!--
When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.

-->

Al viajar por la red una capa oculta a la vez, observamos que cada una realiza una transformación afín seguida de aplicar la operación no lineal ReLU, la cual elimina los valores negativos. En las figuras 3(a) y 3(b), podemos ver la visualización del operador ReLU. Este operados nos ayuda a realizar transformaciones no lineales. Después de múltiples pasos que realizan una transformación afín y operación no lineal, obtenemos datos que se pueden separar linealmente como se aprecia en la figura 4.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualización de los datos de salida </center>


<!--
This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.
-->

Este ejercicio nos provee intuición de por qué la red con dos neuronas en cada capa es más difícil de entrenar. Nuestra red de seis capas tiene un sesgo (*bias*) en cada capa oculta. Por consiguiente, si uno de estos valores desplaza puntos fuera del cuadrante superior derecho, los puntos desplazados serían eliminados con ReLU (al ser negativos). Después de esto, sin importar cómo las capas subsecuentes transformen los datos, los valores seguirán siendo cero. Podemos agilizar el entrenamiento de la red al hacerla "más gruesa" (es decir, agregando más neuronas en las capas ocultas o agregando más capas ocultas o una combinación de ambos métodos). A lo largo de este curso, exploraremos cómo determinar la mejor arqutectura de la red para un problema dado.

## [Transformación de parámetros](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

<!--
General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,
-->


La transformación general de parámetros se refiere a que nuestro vector de parámetros $w$ es la salida de una función. Con esta transformación, podemos mapear el espacio de parámetros original a algún otro espacio. En la figura 5, $w$ es, de hecho, la salida de $H$ con el parámetro $u$. $G(x,w)$ es una red y $C(y,\bar y)$ es una función de costo. La función de propagación hacia atrás también es adecuada como sigue:

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

<!--
These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.
-->

Estas fórmulas se aplican en forma matricial. Presta atención a que las dimensiones de los términos deben de ser consistentes. La dimensión de $u$, $w$, $\frac{\partial H}{\partial u}^\top$, $\frac{\partial C}{\partial w}^\top$ son $[N_u \times 1]$, $[N_w \times 1]$, $[N_u \times N_w]$, $[N_w \times 1]$, respectivamente. Por consiguiente, la dimensión de la propagación hacia atrás es consistente.


<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 Forma general de transformación de parámetros</center>

### Una transformación de parámetros simple: la reutilización de parámetros


<!--
A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->

La transformación mediante la reutilización de parámetros (*weight sharing*) significa que $H(u)$ únicamente replica un componente de  $u$ en componentes múltiples de $w$. $H(u)$ es como una rama en forma de **Y** que copia $u_1$ a $w_1$, $w_2$. Esto se puede expresar de la siguiente manera:

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$


Obligamos a los parámetros compartidos a ser iguales para que el gradiente con respecto a los parámetros compartidos sea sumado en la propagación hacia atrás. Por ejemplo, el gradiente de la función de costo $C(y, \bar y)$ con respecto a $u_1$ es la suma del gradiente de la función de costo $C(y, \bar y)$ con respecto a $w_1$ más el gradiente de la función de costo $C(y, \bar y)$ con respecto a $w_2$.


### Hiperredes

<!--
A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.
-->

Una "hiperred" es una red en la que los pesos de una red son la salida de otra red. La figura 6 muestra el grafo computacional de una "hiperred". En esta, la función $H$ es una red con un vector de parámetros $u$ y entrada $x$. Esto resulta en que los pesos de $G(x,w)$ son configurados dinámicamente por la red $H(x,u)$. A pesar de que esto no es una idea nueva, sigue siendo una implementación muy poderosa.

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 "hiperred"</center>

### Detección de patrones en datos secuenciales

<!--
Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function.

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 Motif Detection for Sequential Data</center>

In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->


La transformación mediante la reutilización de parámetros (*weight sharing*) puede ser utilizada para detectar patrones. Esto se refiere a la localización de patrones repetidos en datos secuenciales como palabras clave en voz o texto. Una forma de lograr esto, como se demuestra en la figura 7, es deslizar una ventana en los datos, la cual desplaza la función con parámetros reutilizados para detectar un patrón específico (es decir, un sonido en específico en una señal de voz), y la salida (es decir, una calificación) va hacia una función que busca el valor máximo.


<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 Detección de patrones en datos secuenciales</center>


En este ejemplo tenemos cinco de estas funciones. Como resultado de esta solución, sumamos cinco gradientes y realizamos una propagación hacia atrás del error para actualizar el parámetro $w$. Al implementar esto en PyTorch, queremos evitar la acumulación implícita de estos gradientes, así que necesitamos usar `zero_grad()` para inicializar el gradiente.


 ### Detección de patrones en imágenes

 <!--
 The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".

 <center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
 Fig. 8 Motif Detection for Images</center>

 It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.

 <center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
 Fig. 9 Shift Invariance</center>

 This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
 -->

La otra apliación útil es en la detección de patrones en imágenes. Usualmente, deslizamos nuestras "plantillas" sobre las imágenes para detectar formas independientemente de la posición y distorción de las formas. Un ejemplo simple es distinguir entre las letras "C" y "D" como se muestra en la figura 8. La diferencia entre las letras "C" y "D" es que la "C" tiene dos extremos, mientras que la letra "D" tiene dos esquinas. Así que podemos diseñar "plantillas de extremos" y "plantillas de esquinas". Si la forma es similar a estas "plantillas", tendrá salidas umbralizadas. Entonces podemos distinguir letras a partir de estas salidas al sumarlas. En la figura 8, la red detecta dos extremos y ninguna esquina; así que activa la respuesta "C".

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 Detección de patrones en imágenes</center>

También es importante que nuestro método con "plantillas" sea invariante al desplazamiento (al desplazar la entrada, la salida--la letra detectada--no debería cambiar). Esto se puede lograr con la transformación de la reutilización de parámetros (*weight sharing*). Como se aprecia en la figura 9, al cambiar la ubicación de "D", aún podemos detectar los patrones de esquinas pese a que fueron desplazadas. Al sumar los patrones, se activará la detección de "D".

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Invariancia al desplazamiento</center>

Este método manual de utilización de detectores locales y sumas para detección de dígitos se utilizó por muchos años. Sin embargo, este presenta un problema: ¿cómo podemos diseñar estas "plantillas" automáticamente? ¿Es posible utilizar redes neuronales para aprender estas "plantillas"? A continuación, presentaremos el concepto de **convoluciones**, es decir, la operación que utilizamos para operar las "plantillas" en imágenes.

## Convolución discreta

### Convolución

<!--
The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:

$$y_i = \sum_j w_j x_{i-j}$$

In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.


-->

La definición matématica precisa de la convolución en el caso unidimensional entre la entrada $x$ y $w$ es:

$$y_i = \sum_j w_j x_{i-j}$$

En palantas, la $i$-ésima salida se calcula como el producto punto entre el **reverso** de $w$ y una ventana del mismo tamaño en $x$. Para calcular la salida completa, comienza con la ventana al inicio, desplaza esta ventana un lugar cada vez y repite hasta haber terminado con $x$.

### Correlación cruzada

<!--
In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:

$$y_i = \sum_j w_j x_{i+j}$$

Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.

Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.
-->


En la práctica, la convención de los sistemas de aprendizaje profundo como PyTorch es ligeramente diferente. La convolución en PyTorch está implementada **sin revertir** $w$:

$$y_i = \sum_j w_j x_{i+j}$$

Los matemáticos denotan a esta fórmula como "correlación cruzada". En nuestro contexto, esta diferencia es únicamente en la convención. En la práctica, los términos correlación cruzada y convolución son intercambiables si uno lee los pesos guardados en la memoria hacia delante o hacia atrás.

Ser conscientes de esta diferencia es importante, por ejemplo, si uno quiere hacer uso de ciertas propiedades de la correlación cruzada o la convolución de textos matemáticos.


<!--
### Higher dimensional convolution

For two dimensional inputs such as images, we make use of the two dimensional version of convolution:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->

### Convolución en más dimensiones

Para entradas bidimensiones como son las imágenes, usamos la versión bidimensional de la convolución:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

Esta definición puede extenderse fácilmente a tres o cuatro dimensiones. Aquí, $w$ es llamado ***kernel* de convolución**.

<!--
### Regular twists that can be made with the convolutional operator in DCNNs

1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:

| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |
-->

### Variantes para el operador convolucional en DCNN

1. **Zancadas (*Striding*)**: en lugar de desplazar la ventana en $x$ una entrada a la vez, se puede realizar con un paso más grande (por ejemplo, dos o tres entradas a la vez).
Ejemplo: Supón que la entrada $x$ es unidimensional y tiene un tamaño de 100 y que $w$ tiene un tamaño de cinco. El tamaño de la salida con una zancada (*stride*) de uno o dos se muestra en la siguiente tabla:


| *Stride*       | 1                          | 2                          |
| ------------   | -------------------------- | -------------------------- |
| Tamaño de la salida: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |


<!--
2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.
-->

2. **Relleno (*Padding*)**: Con frecuencia, al diseñar arquitecturas de redes neuronales profundas, queremos que la salida de la convolución sea del mismo tamaño que los datos de entrada. Esto puede lograrse rellenando los extremos de la entrada con un número de (comúnmente) ceros. Este relleno se realiza principalmente por comodidad. A veces puede tener un impacto negativo en el desempeño y resultar en extraños efectos en los bordes. Habiendo dicho esto, al utilizar una no linealidad como ReLU, rellenar con ceros es razonable.


<!--
## Deep Convolution Neural Networks (DCNNs)

As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.

The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.

Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.

This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.

The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:

> The most incomprehensible thing about the universe is that it is comprehensible.

The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:

> The world is compositional or God exists.

-->

## Redes neuronales convolucionales profundas (DCNN)

Como se describió previamente, las redes neuronales profundas están típicamente organizadas en secciones que alternan operadores lineales y capas con operaciones no-lineales que operan punto a punto. En las redes neuronales convolucionales, el operador lineal será el operador de convolución descrito anteriormente. Adicionalmente, existe un tercer tipo opcional de capa denominado capa de muestreo (*pooling*).

La razón detrás de apilar varias de estas capas es debido a que queremos construir una representación jerárquica de los datos. Las CNN no están limitadas al procesamiento de imágenes. También se han aplicado con éxito a voz y lenguaje. Técnicamente, pueden aplicarse a cualquier tipo de datos que estén organizados en arreglos (de cualquier dimensión) que cumplan con ciertas propiedades.

¿Por qué querríamos capturar la representación jerárquica del mundo? Debido a que el mundo en el que vivimos es composicional. Se ha hecho alusión a este punto en la secciones anteriores. Dicha naturaleza jerárquica puede observarse del hecho de que grupos de pixeles locales se ensamblan para formar patrones simples, tales como bordes orientados. Estos bordes a su vez se ensamblan para formar características locales tales como esquinas, juniones en forma de "T", etc. Estos bordes se ensamblan para formar patrones que son incluso más abstractos. Podemos continuar construyendo estas representaciones jerárquicas hasta llegar a los objectos que observamos en el mundo real.

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Fig. 10. Visualización de características de una red convolucional entrenada en ImageNet [Zeiler & Fergus 2013]</center>


Esta naturaleza jerárquica y composicional que observamos en el mundo natural es, por lo tanto, no solo resultado de nuestra percepción visual, sino también verdadera al nivel físico. En el nivel más bajo de la descripción, tenemos partículas elementales que al ensamblarse forman átomos, estos últimos en conjunto forman moléculas, que a su vez forman materiales y partes de objetos hasta que, al final, forman objectos completos en el mundo real.

La naturaleza composicional del mundo podría ser la respuesta a la pregunta retórica de Einstein de cómo los humanos entienden el mundo en que viven.

> La cuestión más incomprensible del universo es que es comprensible

El hecho de que los humanos entiendan el mundo gracias a esta naturaleza composicional sigue pareciendo una conspiración para Yann. Sin embargo, se puede argumentar que sin composicionalidad, tomaría incluso más magia para los humanos comprender el mundo en el que viven. Parafraseando al gran matemático Stuart Geman:

> El mundo es composicional o Dios existe.

<!--
## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">Figure 11. Simon Thorpe's model of visual information flow in the brain <div>

Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.

Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.

These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.

One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">Figure 12. Gallen & Van Essen's model of dorsal & ventral pathways in the brain <div>

The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).
-->


## [Inspiración de la biología](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

¿Por qué el aprendizaje profundo debe estar arraigado en la idea de que nuestro mundo es comprensible y tiene una naturaleza composicional? Estudios conducidos por Simon Thorpe ayudaron a motivar esta pregunta. Él demostró que la manera en que reconocemos objetos cotidianos es muy rápida. Sus experimentos consistieron en mostrar rápidamente un conjunto de imágenes cada 100 ms y enseguida preguntar a sus usuarios que identificaran estas imagenes, quienes fueron capaces de hacerlo. Esto demostró que solo le toma 100 ms a los humanos detectar objetos. Adicionalmente, considera el siguiente diagrama, que ilustra las distintas partes del cerebro indicando el tiempo que toma para que las neuronas propaguen información de un área a otra:

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">Fig. 11. Modelo de Simon Thorpe del flujo de información visual en el cerebro</div>

Las señales pasan de la retina al núcleo geniculado lateral (LGN, por sus siglas en inglés), que ayuda con la mejora del contraste, el  manejo de compuertas, etc. Luego proceden al córtex visual primario V1, V2, V4,  seguido del córtex inferotemporal (PIT, por sus siglas en inglés), el cual es la parte del cerebro donde las categorías están definidas. Observaciones de cirugías abiertas cerebrales han mostrado que si se le muestra a un humano una película, las neuronas en el PIT se activarán únicamente cuando detecten ciertas imágenes--como Jennifer Aniston o la abuela de alguna persona--y de ninguna otra forma. Las respuestas neuronales son invariantes a cualidades como posición, tamaño, iluminación, la orientación de la abuela, o cómo está vestida ella, etc.

Asimismo, la rapidez del tiempo de reacción con la que los humanos fueron capaces de clasificar estos objectos--apenas tiempo suficiente para que algunos picos pasen--demuestra que es posible realizar esta tarea sin el tiempo adicional requerido para operaciones recurrentes más complejas. Más bien, esto es un proceso de un solo pase hacia adelante (*single feed-forward*).

Estas ideas sugirieron que podríamos desarrollar una arquitectura de red neuronal que sea completamente hacia adelante, pero que al mismo tiempo fuera capaz de resolver el problema de reconocimiento en una manera que sea invariante a transformaciones irrelevantes de las señales de entrada.

Una idea más proveniente del cerebro humano viene de Gallant y Van Essen, cuyo modelo del cerebro ilustra dos caminos distintos:

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">Fig. 12. Modelo de Gallen y Van Essen de caminos ventrales y dorsales en el cerebro</div>

El lado derecho representa el camino ventral, el cual indica qué se está viendo, mientras que el lado izquierdo representa el camino dorsal, el cual identifica ubicaciones, geometría y movimiento. Parecen ser relativamente independientes (con algunas interacciones entre sí, por supuesto) en el córtex visual del humano (y del primate)



<!--
### Hubel & Weisel's contributions (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">Figure 13. Hubel & Weisel's experiments with visual stimuli in cat brains <div>

Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.

They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".

Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.
-->


### Contribuciones de Hubel y Wiesel (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">Fig. 13. Los experimentos de Hubel y Wiesel mediante estímulos en cerebros de gatos</div>

En sus experimentos, Hubel y Wiesel utilizaron electrodos para medir activaciones neuronales en respuesta a estímulos visuales en cerebros de gatos. Con estos, descubrieron que las neuronas en la región V1 son sensibles únicamente a ciertas zonas de un campo visual (llamadas "campos receptores") y detectan bordes orientados. Por ejemplo, Hubel y Wiesel demostraron que si muestras a un gato una barra vertical y comienzas a rotarla, a un ángulo dado la neurona se activará. De manera similar, cuando esta barra se aleja de ese ángulo, la activación de la neurona decrece. A estas neuronas de activación selectiva Hubel y Wiesel las llamaron "células simples", por su habilidad para detectar patrones locales.

Ellos también descubrieron que si se aleja la barra del campo receptor, esa neurona en particular dejará de activarse, pero alguna otra lo hará. Existen detectores de patrones locales que corresponden a todas las áreas del campo visual, y de ahí la idea de que  el cerebro humano procesa la información visual como una colección de "convoluciones".

Otro tipo de neurona, a la que ellos nombraron "célula compleja", acumula la salida de múltiples células simples dentro de un área determinada. Podemos pensar que estas células calculan una acumulación de las activaciones utilizando una función como máximo, suma, suma de cuadrados o cualquier otra función que no dependa del orden. Estas células complejas detectan bordes y orientaciones en una región, sin importar en dónde se encuentran estos estímulos dentro de la región. En otras palabras, son invariantes al desplazamiento con respecto a pequeñas variaciones en las posiciones de la entrada.


<!--
### Fukushima's contributions (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">Figure 14. Fukushima's CNN model <div>

Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.

Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)
-->


### Contribuciones de Fukushima (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">Fig. 14. Modelo de CNN de Fukushima</div>

Fukushima fue el primero en implementar con modelos computacionales la idea de capas múltiples de células simples y complejas utilizando un conjunto de datos de dígitos escritos a mano. Algunos de estos detectores de características eran hechos a mano o aprendidos. Aunque el aprendizaje usaba algoritmos de agrupamiento no supervisado, entrenados para cada capa de forma separada debido a que aún no se utilizaba la retropropagación.

Algunos años después (1989, 1998), Yann LeCun implementó la misma arquitectura, pero esta vez entrenó los detectores en una forma supervisada utilizando retropropagación. Esto es considerado ampliamente como el nacimiento de las redes neuronales convolucionales modernas. (Nota: Riesenhuber en 1999 en el MIT también redescubrió esta arquitectura. Sin embargo, él no utilizó retropropagación).
