---
lang-ref: ch.02-3
title: Redes Neuronales Artificiales (ANNs)
lecturer: Alfredo Canziani
authors:
date: 4 Feb 2020
typora-root-url: 02-3
lang: es
translation-date: 3 Apr 2020
translator: andrescastro-itm
--- 

## [Aprendizaje supervisado para clasificación](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

<!--
## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)
-->

* Considere la **Fig. 1(a)** de abajo. Los puntos de este gráfico se encuentran en las ramas de la espiral, y viven en $\R^2$. Cada color representa una etiqueta de clase. El número de clases únicas es $K = 3$. Esto es representado matemáticamente por la **Ec. 1(a)**.

* **Fig. 1(b)** muestra una espiral similar, con un término añadido de ruido Gaussiano. Esto es representado matemáticamente por la **Ec. 1(b)**.

En ambos casos, estos puntos no son linealmente separables.

<center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> Espiral "limpia" en 2D
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> Espiral "ruidosa" en 2D
       </center>
      </td>
  </table>
  </center>

<!--
* Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**.

* **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**.

  In both cases, these points are not linearly separable.
  
  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "Clean" 2D spiral
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "Noisy" 2D spiral
       </center>
      </td>
  </table>
  </center>
-->

$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Ec. 1(a)</b> </center>
  
  $$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Ec. 1(b)</b></center>

<!--
$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>
-->


¿Qué significa realizar **clasificación**? Considere el caso de **regresión logística**. Si la regresión logística para clasificación es aplicada a estos datos, creará un conjunto de **planos lineales** (fronteras de decisión) en un intento de separar los datos en sus clases. El problema con esta solución es que en cada región existen puntos que pertenecen a múltiples clases. Las ramas de la espiral cruzan las fronteras de decisión lineales. Esta **no** es una gran solución!

<!--
What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution!
-->

**¿Cómo arreglamos esto?** Transformamos el espacio de entrada de tal manera que los datos son forzados a ser linealmente separables. Para hacer esto, durante el transcurso del entrenamiento de una red neuronal las fronteras de decisión que aprenda tratarán de adaptarse a la distribución de los datos de entrenamiento.


<!--
**How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data.
-->

**Nota:** Una red neuronal siempre se representa desde **abajo hacia arriba**. La primera capa está en la parte inferior, y la última en la parte superior. Esto se debe a que conceptualmente, los datos de entrada son características de bajo nivel para cualquier tarea que la red neural esté realizando. A medida que los datos se desplazan **hacia arriba** a través de la red, cada capa subsiguiente extrae características de un nivel más alto.

<!--
**Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level.
-->

## Datos de entrenamiento

<!--
## Training data
-->

La semana pasada vimos que una red neural recién inicializada transforma su entrada de forma arbitraria. Esta transformación, sin embargo, no es **(inicialmente)** instrumental para realizar la tarea en cuestión. Ahora exploraremos cómo, usando datos, podemos forzar esta transformación para que tenga algún significado que sea relevante para la tarea en curso. Los siguientes son datos utilizados como entrada de entrenamiento para una red.

<!--
Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network.
-->

* $\vect{X}$ representa los datos de entrada, una matriz de dimensión $m$ (número de datos de entrada de entrenamiento) x $n$ (dimensión de cada punto de entrada). En el caso de los datos mostrados en las Figuras **1(a)** y **1(b)**, $n = 2$.

<!--
* $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$.
-->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Datos de entrenamiento
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Training data
</center>
-->

* El vector $\vect{c}$ y la matriz $\boldsymbol{Y}$ representan etiquetas de clase para cada uno de los $m$ puntos de datos. En el ejemplo anterior, hay $3$ clases diferentes.

<!--
* Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.
-->
  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, y $\vect{c} \in \R^m$. Sin embargo, no podemos usar $\vect{c}$ como datos de entrenamiento. Si usamos etiquetas de clase numéricas distintas $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, la red puede inferir un orden dentro de las clases que no es representativo de la distribución de los datos.
  * Para evitar este problema, usamos una codificación ***one-hot***. Para cada etiqueta $c_i$, se crea un vector nulo $K$-dimensional $\vect{y}^{(i)}$, en el cual el elemento $c_i$-ésimo es establecido en $1$ (ver **Fig. 3** de abajo).
  
<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> Codificación *one hot*
</center>

  * Por lo tanto, $\boldsymbol Y \in \R^{m \times K}$. Esta matriz también puede ser pensada como que contiene una masa probabilística, que está totalmente concentrada en uno de los $K$ puntos.
  
<!--
  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below).


<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> One hot encoding
</center>


  * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots.
-->

## Capas totalmente conectadas (FC)

<!--
## Fully (FC) connected layers
-->

Ahora veremos lo que es una red completamente conectada (FC) y cómo funciona.

<!--
We will now take a look at what a fully connected (FC) network is, and how it works.
-->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Red neuronal totalmente conectada
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Fully connected neural network
</center>
-->

Considere la red que se muestra arriba en la **Fig. 4**. Los datos de entrada, $\boldsymbol x$, están condicionados a una transformación afín definida por $\boldsymbol W_h$, seguida de una transformación no lineal. El resultado de esta transformación no lineal se denota como $\boldsymbol h$, representando una salida **oculta**, es decir, una que no se **ve** desde fuera de la red. Esto es seguido por otra transformación afín ($\boldsymbol W_y$), seguida por otra transformación no lineal. Esto produce la salida final, $\boldsymbol{ \hat{y}}$. Esta red puede ser representada matemáticamente por las ecuaciones en **Ec. 2** a continuación. $$f$$ y $$g$$ son ambas no linealidades.

<!--
Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $ \boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, i.e. one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}} $. This network can be represented mathematically by the equations in **Eqn. 2** below. $$f$$ and $$g$$ are both non-linearities.
-->

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>Ec. 2</b> Las matemáticas detrás de la red totalmente conectada</center>

<!--
$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>Eqn. 2</b> Mathematics behind a FC network</center>
-->

Una red neuronal básica como la que se muestra arriba es simplemente un conjunto de pares sucesivos, siendo cada par una transformación afín seguida de una operación no lineal (aplastamiento). Entre las funciones no lineales que se utilizan con frecuencia se encuentran la ReLU, la sigmoidea, la tangente hiperbólica y la softmax.

<!--
A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax.
-->

La red que se muestra arriba es una red de 3 capas:

 1. neurona de entrada
 2. neurona oculta
 3. neurona de salida

<!--
The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron
-->

Por lo tanto, una red neuronal de $3$ capas tiene $2$ transformaciones afines. Esto puede ser extrapolado a una red de $n$ capas.

Ahora pasemos a un caso más complicado.

Hagamos un caso de 3 capas ocultas, completamente conectadas en cada capa. Una ilustración se puede encontrar en la **Fig. 5**

<!--
Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extrapolated to a $n$-layer network.

Now let's move to a more complicated case.

Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5**
-->

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Red neuronal con 3 capas ocultas
</center>

<!--
<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Neural net with 3 hidden layers
</center>
-->

Consideremos la neurona $j$ en la segunda capa. Su activación es: 

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

donde $\vect{w}^{(j)}$ es la $j$-ésima fila de $\vect{W}^{(1)}$.

Nótese que la activacion de la capa de entrada en este caso es únicamente la identidad. Las capas ocultas pueden tener activaciones como ReLU, tangente hiperbólica, sigmoide, soft (arg)max, etc.

La activación de la última capa en general dependeráde su caso de uso, como se explica en [este](https://piazza.com/class/k5spqaanqk51ks?cid=36) anuncio de Piazza.

<!--
Let's consider a neuron $j$ in the second layer. It's activation is:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$.

Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, etc.

The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post.
-->

## Red neuronal (inferencia)

<!--
## Neural network (inference)
-->

Pensemos de nuevo en la red neural de tres capas (entrada, oculta, salida), como se ve en la **Fig. 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Red neuronal de tres capas
</center>

<!--
Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Three-layer neural network
</center>
-->
¿Qué tipo de funciones estamos viendo?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

<!--
What kind of functions are we looking at?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$
-->

Sin embargo, es útil visualizar el hecho de que hay una capa oculta, y el mapeo puede ser ampliado como:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

<!--
However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$
-->

¿Cómo podría ser un ejemplo de configuración para el caso anterior? En este caso, se tiene una entrada de dimensión dos ($n=2$), la única capa oculta podría tener una dimensión de 1000 ($d = 1000$), y tenemos 3 clases ($C=3$). Hay buenas razones prácticas para no tener demasiadas neuronas en una capa oculta, por lo que podría tener sentido dividir esa única capa oculta en 3 con 10 neuronas cada una ($1000 \rightarrow 10 \times 10 \times 10$).

<!--
What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$).
-->

## [Red neuronal (entrenamiento I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

<!--
## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)
-->

Entonces, ¿cómo luce el típico entrenamiento? Es útil formular esto en la terminología estándar de costo.

En primer lugar, volvamos a introducir el soft (arg)max y declaremos explícitamente que es una función de activación común para la última capa, cuando se utiliza el costo *log-likelihood* negativo, en los casos de predicción de múltiples clases. Como dijo el profesor LeCun en su lección, esto se debe a que se obtienen mejores gradientes que si se utilizaran los sigmoides y el costo cuadrático. Además, su última capa ya estará normalizada (la suma de todas las neuronas de la última capa será $1$), de una manera que es más favorable para los métodos de gradientes que la normalización explícita (dividiendo por la norma).

<!--
So what does typical training look like? It is helpful to formulate this into the standard terminology of losses.

First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm).
-->

El soft (arg)max dará *logits* en la última capa que se ven así:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

Es importante señalar que el conjunto no está cerrado debido a la naturaleza estrictamente positiva de la función exponencial.

<!--
The soft (arg)max will give you logits in the last layer that look like this:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

It is important to note that the set is not closed because of the strictly positive nature of the exponential function.
-->

Dado el conjunto de las predicciones $\matr{\hat{Y}}$, el costo será:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Acá c denota la etiqueta entera, no la representación de codificación ***one-hot***.

<!--
Given the set of the predictions $\matr{\hat{Y}}$, the loss will be:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Here c denotes the integer label, not the one hot encoding representation.
-->


Hagamos dos ejemplos, uno en el que un ejemplo esté clasificado correctamente, y otro en el que no lo esté.

Digamos que

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

<!--
So let's do two examples, one where an example is correctly classified, and one where it is not.

Let's say

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$
-->

¿Cuál es el costo por instancia?

Para el caso de una *predicción casi perfecta* ($sim$ significa *aproximadamente*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

<!--
What is the instance wise loss?

For the case of *nearly perfect prediction* ($\sim$ means *circa*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$
-->

Para el caso de *casi absolutamente equivocado*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

Observe en los ejemplos anteriores, $\sim 0 \rightarrow 0^{+}$ y $\sim 1 \rightarrow 1^{-}$. ¿Por qué es así? Tómate un minuto para pensar.

<!--
For the case of *nearly absolutely wrong*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think.
-->

**Nota**: Es importante saber que si usas `CrossEntropyLoss`, obtendrás `LogSoftMax` y el `NLLLoss` Loglikelihood negativo juntos, ¡así que no lo hagas dos veces!

<!--
**Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice!
-->

## [Red neuronal (entrenamiento II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

<!--
## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)
-->

Para el entrenamiento, agregamos todos los parámetros entrenables -- matrices de peso y sesgos -- en una colección que llamamos $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. Esto nos permite escribir la función objetivo o de costo como:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

<!--
For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$
-->

Esto hace que el costo dependa de la salida de la red $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, de modo que podemos convertir esto en un problema de optimización.

Una simple ilustración de cómo funciona esto se puede ver en la **Fig. 7**, donde $J(\vartheta)$, la función que necesitamos minimizar, tiene sólo un parámetro escalar $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimización de una función de costo mediante descenso de gradiente.
</center>
<!--
This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem.

A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimizing a loss function through gradient descent.
</center>
-->

Escogemos un punto de inicialización aleatorio $\vartheta_0$ -- con el costo asociado $J(\vartheta_0)$. Podemos calcular la derivada evaluada en ese punto $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. En este caso, la pendiente de la derivada es positiva. Así que tenemos que dar un paso en la dirección del descenso más pronunciado. En este caso, eso es $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

La repetición iterativa de este proceso se conoce como descenso de gradiente. Los métodos de gradiente son las herramientas principales para entrenar una red neuronal.

<!--
We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network.
-->

Para calcular los gradientes necesarios, tenemos que usar la propagación hacia atrás

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$

<!--
In order to compute the necessary gradients, we have to use back-propagation

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$
-->

## Clasificación en la espiral - *Jupyter notebook*

<!--
## Spiral classification - Jupyter notebook
-->

El *Jupyter notebook* se puede encontrar [aquí](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). Para ejecutar el *notebook*, asegúrese de tener instalado el entorno del `minicurso DL` como se especifica en [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

<!--
The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).
-->

Una explicación de cómo usar `torch.device()` se puede encontrar en [notas de la semana pasada](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

<!--
An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).
-->

Como antes, vamos a trabajar con puntos en $\mathbb{R}^2$ con tres etiquetas categóricas diferentes -- en rojo, amarillo y azul -- como se puede ver en la **Fig. 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Datos de clasificación de espirales.
</center>

<!--
Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels - in red, yellow and blue - as can be seen in **Fig. 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Spiral classification data.
</center>
-->

`nn.Sequential()` es un contenedor que pasa módulos al constructor en el orden en que son añadidos; `nn.linear()` está mal nombrado porque aplica una transformación **afín** de los datos entrantes: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. Para más información, consulta la [documentación de PyTorch](https://pytorch.org/docs/stable/nn.html).

<!--
`nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html).
-->

Recuerda, una transformación afín son cinco cosas: rotación, reflexión, traslación, escalado y *shearing*.

<!--
Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing.
-->

Como se puede ver en la **Fig. 9**, al tratar de separar los datos de las espirales con fronteras de decisión lineales -- sólo usando módulos `nn.linear()`, sin una no-linealidad entre ellos -- lo mejor que podemos lograr es una precisión del $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Fronteras de decisión lineales.
</center>

<!--
As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Linear decision boundaries.
</center>
-->

Cuando pasamos de un modelo lineal a uno con dos módulos `nn.linear()` y un `nn.ReLU()` entre ellos, la precisión sube al $95\%$. Esto se debe a que las fronteras se vuelven no lineales y se adaptan mucho mejor a la forma espiral de los datos, como se puede ver en la **Fig. 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Fronteras de decisión no lineales.
</center>

<!--
When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Non-linear decision boundaries.
</center>
-->

Un ejemplo de un problema de regresión que no puede ser resuelto correctamente con una regresión lineal, pero que se resuelve fácilmente con la misma estructura de red neuronal puede verse en [este *cuaderno*](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) y en la **Fig. 11**, que muestra 10 redes diferentes, donde 5 tienen una función de activación `nn.ReLU()` y 5 tienen una `nn.Tanh()`. La primera es una función lineal por partes, mientras que la segunda es una regresión continua y suave.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Redes neuronales, junto con su varianza y desviación estándar.<br>
Izquierda: Cinco redes con <code>ReLU</code>.  Derecha: Cinco redes con <code>tanh</code>.
</center>

<!--
An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Neural networks, along with their variance and standard deviation.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>
-->

Las líneas amarillas y verdes muestran la desviación estándar y la varianza de las redes. Su uso es útil para algo similar a un "intervalo de confianza" -- ya que las funciones dan una única predicción por salida. El uso de la predicción de la varianza del conjunto nos permite estimar la incertidumbre con la que se hace la predicción. La importancia de esto se puede ver en la **Fig. 12**, donde extendemos las funciones de decisión fuera del intervalo de entrenamiento y estas tienden a $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Redes neuronales con varianza y desviación estándar fuera del intervalo de entrenamiento.<br>
Left: Cinco redes <code>ReLU</code>.  Right: Cinco redes <code>tanh</code>.
</center>

<!--
The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" - since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Neural networks, with variance and standard deviation, outside training interval.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>
-->

Para entrenar cualquier Red Neuronal usando PyTorch, se necesitan 5 pasos fundamentales en el ciclo de entrenamiento:

<!--
To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop:
-->

1. `output = model(input)` es el paso hacia adelante del modelo, que toma la entrada y genera la salida.
2. `J = loss(output, target <or> label)` toma la salida del modelo y calcula el costo de entrenamiento con respecto a la etiqueta real u objetivo.
3. `model.zero_grad()` limpia los cálculos de gradiente, para que no se acumulen para el siguiente paso.
4. `J.backward()` hace la propagación hacia atrás y la acumulación: Calcula $\nabla_\texttt{x} J$ por cada variable$\texttt{x}$ para la que hemos especificado `requires_grad=True`. Estos se acumulan en el gradiente de cada variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` da un paso en el descenso del gradiente: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

<!--
1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.
-->

Cuando se entrena a un NN, es muy probable que se necesiten estos 5 pasos en el orden en que fueron presentados.

<!--
When training a NN, it is very likely that you need these 5 steps in the order they were presented.
-->
