---
lang-ref: ch.02-2
lecturer: Yann LeCun
title: Calcular los gradientes para los módulos NN y los trucos prácticos para la propagación hacia atrás
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
lang: es
translation-date: 28 Mar 2020
translator: andrescastro-itm
---


## [Un ejemplo concreto de propagación hacia atrás e introducción a módulos básicos de redes neuronales](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)

<!---## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3022s)-->

### Ejemplo

<!---### Example-->

A continuación consideramos un ejemplo concreto de propagación hacia atrás asistido por un grafo visual. La función arbitraria $G(w)$  es ingresada en la función de costo $C$, la cual puede ser representada como un grafo. A través de la manipulación de la multiplicación de las matrices Jacobianas, podemos transformar este grafo en el grafo que calculará los gradientes en el sentido contrario (de atrás hacia adelante). (Note que PyTorch y TensorFlow hacen esto automáticamente para el usuario, i.e. el grafo hacia adelante es "reversado" automáticamente para crear el grafo de derivadas que propaga hacia atrás el gradiente).

<!---We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is inputted into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e. the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.)-->

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Diagrama de gradiente" style="zoom:40%;" /></center>

En este ejemplo, el grafo verde de la derecha representa el grafo de gradientes. Siguiendo el grafo desde el nodo superior, se tiene que

<!-- this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that-->

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

En términos de dimensiones, $\frac{\partial C(y,\bar{y})}{\partial w}$ es un vector fila de tamaño $1\times N$, donde $N$ es el número de componentes de $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  es un vector fila de tamaño $1\times M$, donde $M$ es la dimensión de la salida; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ es una matriz de tamaño $M\times N$, donde $M$ es el número de salidas de $G$ y $N$ es la dimensión de $w$.

<!--In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.-->

Obsérvese que pueden surgir complicaciones cuando la arquitectura del grafo no es fija, sino que depende de los datos. Por ejemplo, podríamos elegir el módulo de red neuronal en función de la longitud del vector de entrada. Aunque esto es posible, se hace cada vez más difícil manejar esta variación cuando el número de bucles supera una cantidad razonable.

<!--Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount.-->


### Módulos básicos de redes neuronales

<!--### Basic neural net modules-->

Existen diferentes tipos de módulos pre-definidos (pre-construidos) además de los familiares módulos Linear y ReLU. Estos son útiles dado que están optimizados de manera única para realizar sus respectivas funciones (contrario a estar construidos como una combinación de otros módulos elementales).

<!--There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules).-->

- Linear: $Y=W\cdot X$

$$
\begin{aligned}
\frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
\frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
\end{aligned}
$$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{De otro modo}
      \end{cases}
  $$

- Duplicar: $Y_1=X$, $Y_2=X$

  - Como un "divisor Y" donde ambas salidas son iguales a la entrada.

  - Al propagar hacia atrás, los gradientes se suman

  - Puede ser divididos en $n$ ramas de manera similar

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$


- Suma: $Y=X_1+X_2$

  - Si se suman dos variables, cuando una es perturbada, la salida será perturbada por la misma cantidad, i.e.

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{y}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$


- Max: $Y=\max(X_1,X_2)$

  -  Dado que esta función también puede representarse como

$$
Y=\max(X_1,X_2)=\begin{cases}
      X_1 & X_1 > X_2 \\
      X_2 & \text{de otro modo}
   \end{cases}
\Rightarrow
\frac{dY}{dX_1}=\begin{cases}
      1 & X_1 > X_2 \\
      0 & \text{de otro modo}
   \end{cases}
$$

 - - Por lo tanto, por regla de la cadena,

$$
\frac{dC}{dX_1}=\begin{cases}
      \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
      0 & \text{de otro modo}
   \end{cases}
$$


## [LogSoftMax vs SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, que también es un módulo de PyTorch, es una forma conveniente de transformar un grupo de números en un grupo de números positivos entre $0$ y $1$ que suman uno. Estos números pueden ser interpretados como una distribución de probabilidad. Por consiguiente, se utiliza comúnmente en los problemas de clasificación. $y_i$ en la siguiente ecuación es un vector de probabilidades para todas las categorías.

<!--*SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between 0 and 1 that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories.-->

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

Sin embargo, el uso de softmax deja la red susceptible a desvanecimiento de gradientes. El desvanecimiento de gradiente es un problema, ya que impide que los pesos que se encuentran descendiendo sean modificados por la red neuronal, lo que puede detener completamente que la red neuronal siga entrenándose. La función sigmoide logística, que es la función de softmax para un valor, muestra que cuando $s$ es grande, $h(s)$ es $1$, y cuando $s$ es pequeña, $h(s)$ es $0$. Debido a que la función sigmoide es plana en $h(s) = 0 $ y $h(s) = 1$, el gradiente es $0$, lo que resulta en un gradiente que se desvanece.

<!--However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when s is large, $h(s)$ is 1, and when s is small, $h(s)$ is 0. Because the sigmoid function is flat at $h(s) = 0 $ and $h(s) = 1$, the gradient is 0, which results in a vanishing gradient.-->

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Funció sigmoide para ilustrar el gradiente que se desvanece" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

A los matemáticos se les ocurrió la idea de logsoftmax para resolver el problema de desvanecimiento de gradiente generado por el softmax. *LogSoftMax* es otro módulo básico en PyTorch. Como se puede ver en la siguiente ecuación, *LogSoftMax* es una combinación de softmax y log.

<!--Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log.-->

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

La siguiente ecuación demuestra otra forma de ver la misma ecuación. La figura de abajo muestra la parte $\log(1 + \exp(s))$ de la función. Cuando $s$ es muy pequeña, el valor es $0$, y cuando $s$ es muy grande, el valor es $s$. Como resultado, no se satura, y se evita el problema del desvanecimiento del gradiente.

<!--The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When s is very small, the value is 0, and when s is very large, the value is s. As a result it doesn’t saturate, and the vanishing gradient problem is avoided.-->

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Gráfico de la parte logaritmica de las funciones" /></center>

## [Trucos prácticos para la propagación hacia atrás](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)

<!--## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4924s)-->

### Usar ReLU como la función de activación no lineal

ReLU funciona mejor para redes con muchas capas, lo que ha hecho que alternativas como la función sigmoide y la función tangente hiperbólica $\tanh(\cdot)$ pierdan popularidad (dejen de ser usadas). La razón por la que ReLU funciona mejor es probablemente debido a su única torcedura que lo hace equivariante a la escala.

<!-- works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.-->

### Usar pérdida de entropía cruzada (cross-entropy loss) como la función objetivo para problemas de clasificación

Log softmax, el cual se ha discutido anteriormente en la lección, es un caso especial de pérdida de entropía cruzada. En PyTorch, asegúrese de proporcionar la función de pérdida de entropía cruzada con *log* softmax como entrada (a diferencia de la softmax normal).

<!--Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).-->

### Usar descenso de gradiente estocástico (SGD) sobre minibatches durante el entrenamiento

Como se discutió anteriormente, los minibatches permiten entrenar más eficientemente porque hay redundancia en los datos; no debería ser necesario hacer una predicción y calcular la pérdida en cada observación en cada paso para estimar el gradiente.

<!--As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.-->

### Mezclar el orden de los ejemplos de entrenamiento cuando se utiliza descenso de gradiente estocástico (SGD)

El orden importa. Si el modelo sólo ve ejemplos de una sola clase durante cada paso del entrenamiento, entonces aprenderá a predecir esa clase sin aprender por qué debería estar prediciendo esa clase. Por ejemplo, si estuviera tratando de clasificar los dígitos del conjunto de datos MNIST y los datos no estuvieran desordenados, los parámetros de sesgo en la última capa simplemente predecirían siempre el cero, y luego se adaptarían para predecir siempre el uno, luego el dos, etc. Lo ideal sería tener muestras de cada clase en cada minibatch.

<!--Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, etc. Ideally, you should have samples from every class in every minibatch.-->

Sin embargo, hay un debate en curso sobre si es necesario cambiar el orden de las muestras en cada ciclo (época).

<!--However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch).-->

### Normalizar las entradas para que tengan media cero y varianza unitaria

Antes del entrenamiento, es útil normalizar cada característica de entrada de modo que tenga una media de cero y una desviación estándar de uno. Cuando se utilizan datos de imágenes RGB, es comun calcular la media y desviación estándar de cada canal individualmente y normalizar la imagen canal por canal. Por ejemplo, tome la media $m_b$ y a desviación estándar $\sigma_b$ de todos los valores de azul del conjunto de datos, luego normalice los valores de azul para cada imagen individual como

<!--Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as.-->

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

donde $\epsilon$ es un número arbitrariamente pequeño que se usa para evitar la división por cero. Se debe hacer lo mismo para los canales verde y rojo. Esto es necesario para obtener una señal significativa de las imágenes tomadas con diferente iluminación; por ejemplo, las imágenes iluminadas de día tienen mucho rojo mientras que las imágenes submarinas casi no tienen.

<!--where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none.-->

### Usar una método para decrementar la tasa de aprendizaje

La tasa de aprendizaje debe disminuir a medida que el entrenamiento avanza. En la práctica, los modelos más avanzados son entrenados usando algoritmos como Adam/Momentum, los cuales adaptan la tasa de aprendizaje en lugar de un simple SGD con una tasa de aprendizaje constante.

<!--### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam/Momentum which adapt the learning rate instead of simple SGD with a constant learning rate.
-->

### Usar regularización L1 y/o L2 para el decaímiento de los pesos

Se puede añadir un costo para valores de pesos grandes a la función de costo. Por ejemplo, usando regularización L2, podemos definir la pérdida $L$ y actualizar los pesos $w$ como sigue:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

Para entender por qué esto se llama decaímiento de los pesos, observe que podemos reescribir la fórmula anterior para mostrar que multiplicamos $w_i$ por una constante menor que uno durante la actualización.

To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

La regularización L1 (Lasso) es similar, excepto que usamos $\sum_i \vert w_i\vert$ en lugar de $\Vert w \Vert^2$.

Básicamente, la regularización trata de decirle al sistema que minimice la función de costo con el vector de peso más corto posible. Con la regularización L1, los pesos que no son útiles se reducen a $0$.

<!---

### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to 0.
-->

### Inicialización de los pesos
Los pesos deben ser inicializados al azar, sin embargo, no deben ser demasiado grandes ni demasiado pequeños, de manera que la salida sea aproximadamente de la misma varianza que la entrada. Existen varios trucos de inicialización de pesos incorporados en PyTorch. Uno de los trucos que funciona bien para los modelos profundos es la inicialización Kaiming, en la que la varianza de los pesos es inversamente proporcional a la raíz cuadrada del número de entradas.

<!--
### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the variance of the weights is inversely proportional to square root of number of inputs.
-->

### Usar *dropout*

*Dropout* es otra forma de regularización. Se puede considerar como otra capa de la red neural: toma las entradas, establece aleatoriamente en cero $n/2$ de las entradas y devuelve el resultado como salida. Esto obliga al sistema a tomar información de todas las unidades de entrada en lugar de depender excesivamente de un pequeño número de unidades de entrada, distribuyendo así la información entre todas las unidades de una capa. Este método fue propuesto inicialmente por <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

Para más trucos, ver <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finalmente, observe que la propagación hacia atrás no funciona únicamente para modelos apilados; también puede funcionar para cualquier grafo acíclico dirigido (DAG) siempre y cuando exista un orden parcial en los módulos.

<!--
### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

For more tricks, see  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules.
-->
