---
lang: es
lang-ref: ch.01-3
title: Motivación, Álgebra Lineal y Visualización
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translation-date: 30 Mar 2020
translator: juanmartinezitm
---

<!--
## Resources

Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box.
-->

## Recursos

Por favor sigue a Alfredo Canziani [en Twitter @alfcnz](https://twitter.com/alfcnz). Videos y libros con detalles relevantes en álgebra lineal y descomposición en valores singulares (SVD) se pueden encontrar buscando en la cuenta de Twitter de Alfredo, por ejemplo, escribiendo `linear algebra (from:alfcnz)` en el cuadro de búsqueda.

<!--
## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:

-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections.
-->
## [Transformaciones y motivación](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

Como ejemplo motivacional, consideremos la clasificación de imágenes. Suponga que tomamos una fotografía con una cámara de 1 mega-píxel. Esta imagen tendrá alrededor de 1000 píxeles verticalmente y 1000 píxeles horizontalmente, y cada píxel tendrá dimensión de tres colores para rojo, verde y azul (RGB). Cada imagen particular puede entonces ser considerada como un punto en un espacio de 3 millones de dimensiones. Con esa amplia dimensionalidad, muchas imágenes interesantes que quisiéramos clasificar -- tales como un perro *vs.* un gato -- estarán esencialmente en la misma región del espacio.

Para separar efectivamente estas imágenes, consideramos formas de transformar los datos con el fin de mover los puntos. Recuerde que en un espacio 2-D, una transformación lineal es lo mismo que una multiplicación de matrices. Por ejemplo, las siguientes son transformaciones lineales:

-   Rotación (cuando la matriz es ortonormal).
-   Escalamiento (cuando la matriz es diagonal).
-   Reflexión (cuando el determinante es negativo).
-   Cizallamiento o Transvección (*Shear*)

Observa que la traslación por si sola no es lineal dado que 0 no siempre será mapeado a 0, sin embargo es una transformación afín. Volviendo a nuestro ejemplo en imágenes, podemos transformar los puntos trasladándolos de forma tal que sean agrupados alrededor de 0 y escalados con una matriz diagonal de tal forma que nos acerquemos a esa región. Finalmente, podemos hacer clasificación hallando lineas a través del espacio que separen los diferentes puntos en sus respectivas clases. En otras palabras, la idea es usar transformaciones lineales y no lineales para mapear los puntos a un espacio donde sean linealmente separables. Esta idea se hará más concreta en las siguientes secciones.

<!--
 ## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

 In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one vs all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities.

 --->

## [Visualización de datos - separando puntos por colores utilizando una red](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

En nuestra visualización, tenemos cinco ramas de una espiral, cada rama corresponde a un color diferente. Los puntos viven en un plano bidimensional y pueden ser representados como una tupla; el color representa una tercera dimensión que puede ser pensada como la clase para cada uno de los puntos. Entonces utilizamos la red para separar cada uno de los puntos por color.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Puntos de entrada - antes de la red             |            (b) Puntos de salida - después de la red             |

<center> Figura 1: Espiral de cinco colores </center>

La red "comprime" el espacio fabricado con el fin de separar cada uno de los puntos en diferentes subespacios. Cuando converge, la red separa cada uno de los colores en cuatro diferentes subespacios de la variedad final. En otras palabras, cada uno de los colores en este nuevo espacio será linealmente separable utilizando una regresión del tipo una vs todas. Los vectores en el diagrama pueden ser representados como una matriz de 5 por 2; esta matriz puede ser multiplicada con cada punto para devolver puntuaciones para cada uno de los cinco colores. Cada uno de los puntos se puede entonces clasificar por color utilizando sus respectivas puntuaciones. Aquí, la dimensión de salida es cinco, una para cada uno de los colores, y la dimensión de entrada es dos, una para las coordenadas x e y de cada uno de los puntos. Para resumir, esta red básicamente comprime el espacio fabricado y realiza una transformación parametrizada por varias matrices y por no-linealidades.

<!--
### Network architecture

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center>

The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour.
-->
### Arquitectura de la red

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figura 2: Arquitectura de la red
</center>

La primera matriz mapea la entrada bidimensional a una capa oculta intermedia de 100 dimensiones. Después tenemos una capa no-lineal, `ReLU` o Unidad Lineal Rectificada, que es simplemente la función *parte positiva* $(\cdot)^+$. Después, para mostrar nuestra imagen en una representación gráfica, incluimos una capa de tipo *embedding* que mapea la capa oculta de entrada 100 dimensional a una salida bidimensional. Finalmente, la capa de *embedding* se proyecta a la capa final de 5 dimensiones de la red, representando una puntuación para cada color.

<!--
## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->
## [Proyecciones aleatorias - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

El documento *Jupyter Notebook* se puede encontrar [aquí](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). Para ejecutarlo, asegúrate de tener el ambiente `pDL` instalado como se especifica en [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

<!--
### PyTorch `device`

PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`.
-->
### PyTorch `device`

PyTorch se puede ejecutar tanto en la CPU como en la GPU del computador. La CPU es útil para tareas secuenciales, mientras que la GPU es útil para tareas en paralelo. Antes de ejecutar en el *dispositivo* seleccionado, debemos primero asegurarnos de que nuestros tensores y modelos se transfieran a la memoria del dispositivo. Esto se puede hacer con las siguientes dos líneas de código:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```
La primera línea crea una variable, llamada `device` (dispositivo), que se asigna a la GPU si está disponible; de otra forma, se asigna por defecto a la CPU. En la siguiente linea, se crea un tensor y se envía a la memoria del dispositivo llamando `.to(device)`.

<!--
### Jupyter Notebook tip

To see the documentation for a function in a notebook cell, use `Shift + Tab.`
-->

### Jupyter Notebook tip

Para ver la documentación para una función en una celda del *notebook*, utilice `Shift + Tab.`

<!--
### Visualizing linear transformations

Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figure 3:  Linear transformations from random matrices </center>
-->

### Visualizando transformaciones lineales

Recuerde que una transformación lineal se puede representar como una matriz. Utilizando descomposición en valores singulares, podemos descomponer esta matriz en tres matrices de componentes, cada una representando una transformación lineal diferente.

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

En la eq.(1), las matrices $U$ y $V^\top$ son ortogonales y representan las transformaciones rotación y reflexión. La matriz del medio es diagonal y representa una transformación de escalamiento.

Visualizamos la transformación lineal de varias matrices aleatorias en la Fig.3. Note el efecto de los valores singulares en las transformaciones resultantes.

Las matrices utilizadas se generaron con Numpy; sin embargo, podemos utilizar también la clase de Pytorch `nn.Linear` con `bias = False` para crear transformaciones lineales.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Puntos originales       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figura 3:  Transformaciones lineales de matrices aleatorias </center>

<!--
### Non-linear transformations

Next, we visualize the following transformation:

$$
f(x) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \bigg)
$$

Recall, the graph of $\tanh(\cdot)$ in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center>

The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center>
-->

### Transformaciones no-lineales

A continuación, visualizamos la siguiente transformación:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Recuerda, la gráfica de $\tanh(\cdot)$ en Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figura 4: No-linealidad tangente hiperbólica
</center>

El efecto de esta no-linealidad es acotar puntos entre $-1$ y $+1$, creando un cuadrado. A medida que el valor de $s$ en eq. (2) aumenta, más y más puntos se empujan al borde del cuadrado. Esto se muestra en Fig. 5. Llevando más puntos a la esquina, los separamos más y podemos entonces intentar clasificarlos.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) No-linealidad con $s=1$                 |                 (b) No-linealidad con $s=5$                  |

<center> Figure 5: Transformaciones no-lineales </center>

<!--
### Random neural net

Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center>
-->

### Red neuronal aleatoria

Finalmente, visualizamos la transformación realizada por una simple red neuronal sin entrenar. La red consiste de una capa lineal, que realiza una transformación afín, seguida por una no-linealidad tangente hiperbólica, y finalmente otra capa lineal. Examinando la transformación en la Fig. 6, observamos que es poco probable que veamos las transformaciones lineales y no-lineales de antes. Avanzando, veremos cómo hacer que estas transformaciones realizadas por las redes neuronales sean útiles para nuestro objetivo final de clasificación.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figura 6: Transformación de una red neuronal sin entrenar
</center>
